// Copyright 2020 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by generate_visitor.go. DO NOT EDIT.

package scop

import "context"

// ValidationOp is an operation which can be visited by ValidationVisitor.
type ValidationOp interface {
	Op
	Visit(context.Context, ValidationVisitor) error
}

// ValidationVisitor is a visitor for ValidationOp operations.
type ValidationVisitor interface {
	ValidateIndex(context.Context, ValidateIndex) error
	ValidateConstraint(context.Context, ValidateConstraint) error
	ValidateColumnNotNull(context.Context, ValidateColumnNotNull) error
}

// Visit is part of the ValidationOp interface.
func (op ValidateIndex) Visit(ctx context.Context, v ValidationVisitor) error {
	return v.ValidateIndex(ctx, op)
}

// Visit is part of the ValidationOp interface.
func (op ValidateConstraint) Visit(ctx context.Context, v ValidationVisitor) error {
	return v.ValidateConstraint(ctx, op)
}

// Visit is part of the ValidationOp interface.
func (op ValidateColumnNotNull) Visit(ctx context.Context, v ValidationVisitor) error {
	return v.ValidateColumnNotNull(ctx, op)
}
