// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package scop

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[StatementPhase-1]
	_ = x[PreCommitPhase-2]
	_ = x[PostCommitPhase-3]
	_ = x[PostCommitNonRevertiblePhase-4]
	_ = x[EarliestPhase-1]
	_ = x[LatestPhase-4]
}

func (i Phase) String() string {
	switch i {
	case StatementPhase:
		return "StatementPhase"
	case PreCommitPhase:
		return "PreCommitPhase"
	case PostCommitPhase:
		return "PostCommitPhase"
	case PostCommitNonRevertiblePhase:
		return "PostCommitNonRevertiblePhase"
	default:
		return "Phase(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
