// Copyright 2020 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by generate_visitor.go. DO NOT EDIT.

package scop

import "context"

// DeferredMutationOp is an operation which can be visited by DeferredMutationVisitor.
type DeferredMutationOp interface {
	Op
	Visit(context.Context, DeferredMutationVisitor) error
}

// DeferredMutationVisitor is a visitor for DeferredMutationOp operations.
type DeferredMutationVisitor interface {
	CreateGCJobForDatabase(context.Context, CreateGCJobForDatabase) error
	CreateGCJobForTable(context.Context, CreateGCJobForTable) error
	CreateGCJobForIndex(context.Context, CreateGCJobForIndex) error
	UpdateSchemaChangerJob(context.Context, UpdateSchemaChangerJob) error
	CreateSchemaChangerJob(context.Context, CreateSchemaChangerJob) error
	RemoveDatabaseRoleSettings(context.Context, RemoveDatabaseRoleSettings) error
	DeleteSchedule(context.Context, DeleteSchedule) error
	RefreshStats(context.Context, RefreshStats) error
	MaybeAddSplitForIndex(context.Context, MaybeAddSplitForIndex) error
}

// Visit is part of the DeferredMutationOp interface.
func (op CreateGCJobForDatabase) Visit(ctx context.Context, v DeferredMutationVisitor) error {
	return v.CreateGCJobForDatabase(ctx, op)
}

// Visit is part of the DeferredMutationOp interface.
func (op CreateGCJobForTable) Visit(ctx context.Context, v DeferredMutationVisitor) error {
	return v.CreateGCJobForTable(ctx, op)
}

// Visit is part of the DeferredMutationOp interface.
func (op CreateGCJobForIndex) Visit(ctx context.Context, v DeferredMutationVisitor) error {
	return v.CreateGCJobForIndex(ctx, op)
}

// Visit is part of the DeferredMutationOp interface.
func (op UpdateSchemaChangerJob) Visit(ctx context.Context, v DeferredMutationVisitor) error {
	return v.UpdateSchemaChangerJob(ctx, op)
}

// Visit is part of the DeferredMutationOp interface.
func (op CreateSchemaChangerJob) Visit(ctx context.Context, v DeferredMutationVisitor) error {
	return v.CreateSchemaChangerJob(ctx, op)
}

// Visit is part of the DeferredMutationOp interface.
func (op RemoveDatabaseRoleSettings) Visit(ctx context.Context, v DeferredMutationVisitor) error {
	return v.RemoveDatabaseRoleSettings(ctx, op)
}

// Visit is part of the DeferredMutationOp interface.
func (op DeleteSchedule) Visit(ctx context.Context, v DeferredMutationVisitor) error {
	return v.DeleteSchedule(ctx, op)
}

// Visit is part of the DeferredMutationOp interface.
func (op RefreshStats) Visit(ctx context.Context, v DeferredMutationVisitor) error {
	return v.RefreshStats(ctx, op)
}

// Visit is part of the DeferredMutationOp interface.
func (op MaybeAddSplitForIndex) Visit(ctx context.Context, v DeferredMutationVisitor) error {
	return v.MaybeAddSplitForIndex(ctx, op)
}
