// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package entitynodetest

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[i8-0]
	_ = x[pi8-1]
	_ = x[i16-2]
	_ = x[value-3]
	_ = x[left-4]
	_ = x[right-5]
	_ = x[i16ref-6]
}

func (i testAttr) String() string {
	switch i {
	case i8:
		return "i8"
	case pi8:
		return "pi8"
	case i16:
		return "i16"
	case value:
		return "value"
	case left:
		return "left"
	case right:
		return "right"
	case i16ref:
		return "i16ref"
	default:
		return "testAttr(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
