// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package comparetest

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[i8-0]
	_ = x[pi8-1]
	_ = x[i16-2]
	_ = x[pi16-3]
	_ = x[i32-4]
	_ = x[pi32-5]
	_ = x[i64-6]
	_ = x[pi64-7]
	_ = x[ui8-8]
	_ = x[pui8-9]
	_ = x[ui16-10]
	_ = x[pui16-11]
	_ = x[ui32-12]
	_ = x[pui32-13]
	_ = x[ui64-14]
	_ = x[pui64-15]
	_ = x[i-16]
	_ = x[pi-17]
	_ = x[ui-18]
	_ = x[pui-19]
	_ = x[str-20]
	_ = x[pstr-21]
	_ = x[_uintptr-22]
	_ = x[puintptr-23]
}

func (_i testAttr) String() string {
	switch _i {
	case i8:
		return "i8"
	case pi8:
		return "pi8"
	case i16:
		return "i16"
	case pi16:
		return "pi16"
	case i32:
		return "i32"
	case pi32:
		return "pi32"
	case i64:
		return "i64"
	case pi64:
		return "pi64"
	case ui8:
		return "ui8"
	case pui8:
		return "pui8"
	case ui16:
		return "ui16"
	case pui16:
		return "pui16"
	case ui32:
		return "ui32"
	case pui32:
		return "pui32"
	case ui64:
		return "ui64"
	case pui64:
		return "pui64"
	case i:
		return "i"
	case pi:
		return "pi"
	case ui:
		return "ui"
	case pui:
		return "pui"
	case str:
		return "str"
	case pstr:
		return "pstr"
	case _uintptr:
		return "_uintptr"
	case puintptr:
		return "puintptr"
	default:
		return "testAttr(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
