// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package pgwirebase

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[PGNumericPos-0]
	_ = x[PGNumericNeg-16384]
}

func (i PGNumericSign) String() string {
	switch i {
	case PGNumericPos:
		return "PGNumericPos"
	case PGNumericNeg:
		return "PGNumericNeg"
	default:
		return "PGNumericSign(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
