// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package pgwirebase

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[ClientMsgBind-66]
	_ = x[ClientMsgClose-67]
	_ = x[ClientMsgCopyData-100]
	_ = x[ClientMsgCopyDone-99]
	_ = x[ClientMsgCopyFail-102]
	_ = x[ClientMsgDescribe-68]
	_ = x[ClientMsgExecute-69]
	_ = x[ClientMsgFlush-72]
	_ = x[ClientMsgParse-80]
	_ = x[ClientMsgPassword-112]
	_ = x[ClientMsgSimpleQuery-81]
	_ = x[ClientMsgSync-83]
	_ = x[ClientMsgTerminate-88]
}

func (i ClientMessageType) String() string {
	switch i {
	case ClientMsgBind:
		return "ClientMsgBind"
	case ClientMsgClose:
		return "ClientMsgClose"
	case ClientMsgCopyData:
		return "ClientMsgCopyData"
	case ClientMsgCopyDone:
		return "ClientMsgCopyDone"
	case ClientMsgCopyFail:
		return "ClientMsgCopyFail"
	case ClientMsgDescribe:
		return "ClientMsgDescribe"
	case ClientMsgExecute:
		return "ClientMsgExecute"
	case ClientMsgFlush:
		return "ClientMsgFlush"
	case ClientMsgParse:
		return "ClientMsgParse"
	case ClientMsgPassword:
		return "ClientMsgPassword"
	case ClientMsgSimpleQuery:
		return "ClientMsgSimpleQuery"
	case ClientMsgSync:
		return "ClientMsgSync"
	case ClientMsgTerminate:
		return "ClientMsgTerminate"
	default:
		return "ClientMessageType(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
