#!/usr/bin/env bash

# Copyright 2017 The Cockroach Authors.
#
# Use of this software is governed by the CockroachDB Software License
# included in the /LICENSE file.


# Trigger this script by running `make generate PKG=./pkg/sql/parser` from the
# repository root to ensure your PATH includes vendored binaries.

set -euo pipefail

# We need to set these environment variables to ensure the output of
# `sort` is the same everywhere.
export LC_ALL=C
export LANG=C

cat <<EOF
// Code generated by help_gen_test.sh. DO NOT EDIT.
// GENERATED FILE DO NOT EDIT

package parser

var expectedHelpStrings = []string{
EOF

grep 'helpWith(' | sed -e 's/^.*sqllex,//g;s/).*/,/g' | grep -v '""' | sort -u

cat <<EOF
}
EOF
