// Copyright 2018 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package opt

// RuleName enumerates the names of all the optimizer rules. Manual rule names
// are defined in this file and rule names generated by Optgen are defined in
// rule_name.og.go.
type RuleName uint32

// Enumeration of all manual rule names.
const (
	InvalidRuleName RuleName = iota

	// ------------------------------------------------------------
	// Manual Rule Names
	// ------------------------------------------------------------

	SimplifyRootOrdering
	PruneRootCols
	SimplifyZeroCardinalityGroup

	// NumManualRules tracks the number of manually-defined rules.
	NumManualRuleNames
)

// IsNormalize returns true if r is a normalization rule.
func (r RuleName) IsNormalize() bool {
	return r < startExploreRule
}

// IsExplore returns true if r is an exploration rule.
func (r RuleName) IsExplore() bool {
	return r > startExploreRule
}

// Make linter happy.
var _ = InvalidRuleName
var _ = NumManualRuleNames
var _ = RuleName.IsNormalize
var _ = RuleName.IsExplore
