// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package lang

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[UnknownOp-0]
	_ = x[RootOp-1]
	_ = x[DefineSetOp-2]
	_ = x[RuleSetOp-3]
	_ = x[DefineOp-4]
	_ = x[CommentsOp-5]
	_ = x[CommentOp-6]
	_ = x[TagsOp-7]
	_ = x[TagOp-8]
	_ = x[DefineFieldsOp-9]
	_ = x[DefineFieldOp-10]
	_ = x[RuleOp-11]
	_ = x[FuncOp-12]
	_ = x[NamesOp-13]
	_ = x[NameOp-14]
	_ = x[AndOp-15]
	_ = x[NotOp-16]
	_ = x[ListOp-17]
	_ = x[ListAnyOp-18]
	_ = x[BindOp-19]
	_ = x[LetOp-20]
	_ = x[RefOp-21]
	_ = x[AnyOp-22]
	_ = x[SliceOp-23]
	_ = x[StringOp-24]
	_ = x[StringsOp-25]
	_ = x[NumberOp-26]
	_ = x[CustomFuncOp-27]
}

func (i Operator) String() string {
	switch i {
	case UnknownOp:
		return "UnknownOp"
	case RootOp:
		return "RootOp"
	case DefineSetOp:
		return "DefineSetOp"
	case RuleSetOp:
		return "RuleSetOp"
	case DefineOp:
		return "DefineOp"
	case CommentsOp:
		return "CommentsOp"
	case CommentOp:
		return "CommentOp"
	case TagsOp:
		return "TagsOp"
	case TagOp:
		return "TagOp"
	case DefineFieldsOp:
		return "DefineFieldsOp"
	case DefineFieldOp:
		return "DefineFieldOp"
	case RuleOp:
		return "RuleOp"
	case FuncOp:
		return "FuncOp"
	case NamesOp:
		return "NamesOp"
	case NameOp:
		return "NameOp"
	case AndOp:
		return "AndOp"
	case NotOp:
		return "NotOp"
	case ListOp:
		return "ListOp"
	case ListAnyOp:
		return "ListAnyOp"
	case BindOp:
		return "BindOp"
	case LetOp:
		return "LetOp"
	case RefOp:
		return "RefOp"
	case AnyOp:
		return "AnyOp"
	case SliceOp:
		return "SliceOp"
	case StringOp:
		return "StringOp"
	case StringsOp:
		return "StringsOp"
	case NumberOp:
		return "NumberOp"
	case CustomFuncOp:
		return "CustomFuncOp"
	default:
		return "Operator(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
