// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package lang

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[ILLEGAL-0]
	_ = x[ERROR-1]
	_ = x[EOF-2]
	_ = x[IDENT-3]
	_ = x[STRING-4]
	_ = x[NUMBER-5]
	_ = x[WHITESPACE-6]
	_ = x[COMMENT-7]
	_ = x[LPAREN-8]
	_ = x[RPAREN-9]
	_ = x[LBRACKET-10]
	_ = x[RBRACKET-11]
	_ = x[LBRACE-12]
	_ = x[RBRACE-13]
	_ = x[DOLLAR-14]
	_ = x[COLON-15]
	_ = x[ASTERISK-16]
	_ = x[EQUALS-17]
	_ = x[ARROW-18]
	_ = x[AMPERSAND-19]
	_ = x[COMMA-20]
	_ = x[CARET-21]
	_ = x[DOT-22]
	_ = x[ELLIPSES-23]
	_ = x[PIPE-24]
}

func (i Token) String() string {
	switch i {
	case ILLEGAL:
		return "ILLEGAL"
	case ERROR:
		return "ERROR"
	case EOF:
		return "EOF"
	case IDENT:
		return "IDENT"
	case STRING:
		return "STRING"
	case NUMBER:
		return "NUMBER"
	case WHITESPACE:
		return "WHITESPACE"
	case COMMENT:
		return "COMMENT"
	case LPAREN:
		return "LPAREN"
	case RPAREN:
		return "RPAREN"
	case LBRACKET:
		return "LBRACKET"
	case RBRACKET:
		return "RBRACKET"
	case LBRACE:
		return "LBRACE"
	case RBRACE:
		return "RBRACE"
	case DOLLAR:
		return "DOLLAR"
	case COLON:
		return "COLON"
	case ASTERISK:
		return "ASTERISK"
	case EQUALS:
		return "EQUALS"
	case ARROW:
		return "ARROW"
	case AMPERSAND:
		return "AMPERSAND"
	case COMMA:
		return "COMMA"
	case CARET:
		return "CARET"
	case DOT:
		return "DOT"
	case ELLIPSES:
		return "ELLIPSES"
	case PIPE:
		return "PIPE"
	default:
		return "Token(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
