// Code generated by langgen; DO NOT EDIT.

package lang

import (
	"bytes"
	"fmt"
)

type RootExpr struct {
	Defines DefineSetExpr
	Rules   RuleSetExpr
	Src     *SourceLoc
}

func (e *RootExpr) Op() Operator {
	return RootOp
}

func (e *RootExpr) ChildCount() int {
	return 2
}

func (e *RootExpr) Child(nth int) Expr {
	switch nth {
	case 0:
		return &e.Defines
	case 1:
		return &e.Rules
	}
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *RootExpr) ChildName(nth int) string {
	switch nth {
	case 0:
		return "Defines"
	case 1:
		return "Rules"
	}
	return ""
}

func (e *RootExpr) Value() interface{} {
	return nil
}

func (e *RootExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		return &RootExpr{Defines: *children[0].(*DefineSetExpr), Rules: *children[1].(*RuleSetExpr), Src: e.Source()}
	}
	return e
}

func (e *RootExpr) Source() *SourceLoc {
	return e.Src
}

func (e *RootExpr) InferredType() DataType {
	return AnyDataType
}

func (e *RootExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *RootExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type DefineSetExpr []*DefineExpr

func (e *DefineSetExpr) Op() Operator {
	return DefineSetOp
}

func (e *DefineSetExpr) ChildCount() int {
	return len(*e)
}

func (e *DefineSetExpr) Child(nth int) Expr {
	return (*e)[nth]
}

func (e *DefineSetExpr) ChildName(nth int) string {
	return ""
}

func (e *DefineSetExpr) Value() interface{} {
	return nil
}

func (e *DefineSetExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		typedChildren := make(DefineSetExpr, len(children))
		for i := 0; i < len(children); i++ {
			typedChildren[i] = children[i].(*DefineExpr)
		}
		return &typedChildren
	}
	return e
}

func (e *DefineSetExpr) Source() *SourceLoc {
	return nil
}

func (e *DefineSetExpr) InferredType() DataType {
	return AnyDataType
}

func (e *DefineSetExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *DefineSetExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type RuleSetExpr []*RuleExpr

func (e *RuleSetExpr) Op() Operator {
	return RuleSetOp
}

func (e *RuleSetExpr) ChildCount() int {
	return len(*e)
}

func (e *RuleSetExpr) Child(nth int) Expr {
	return (*e)[nth]
}

func (e *RuleSetExpr) ChildName(nth int) string {
	return ""
}

func (e *RuleSetExpr) Value() interface{} {
	return nil
}

func (e *RuleSetExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		typedChildren := make(RuleSetExpr, len(children))
		for i := 0; i < len(children); i++ {
			typedChildren[i] = children[i].(*RuleExpr)
		}
		return &typedChildren
	}
	return e
}

func (e *RuleSetExpr) Source() *SourceLoc {
	return nil
}

func (e *RuleSetExpr) InferredType() DataType {
	return AnyDataType
}

func (e *RuleSetExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *RuleSetExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type DefineExpr struct {
	Comments CommentsExpr
	Tags     TagsExpr
	Name     StringExpr
	Fields   DefineFieldsExpr
	Src      *SourceLoc
}

func (e *DefineExpr) Op() Operator {
	return DefineOp
}

func (e *DefineExpr) ChildCount() int {
	return 4
}

func (e *DefineExpr) Child(nth int) Expr {
	switch nth {
	case 0:
		return &e.Comments
	case 1:
		return &e.Tags
	case 2:
		return &e.Name
	case 3:
		return &e.Fields
	}
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *DefineExpr) ChildName(nth int) string {
	switch nth {
	case 0:
		return "Comments"
	case 1:
		return "Tags"
	case 2:
		return "Name"
	case 3:
		return "Fields"
	}
	return ""
}

func (e *DefineExpr) Value() interface{} {
	return nil
}

func (e *DefineExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		return &DefineExpr{Comments: *children[0].(*CommentsExpr), Tags: *children[1].(*TagsExpr), Name: *children[2].(*StringExpr), Fields: *children[3].(*DefineFieldsExpr), Src: e.Source()}
	}
	return e
}

func (e *DefineExpr) Source() *SourceLoc {
	return e.Src
}

func (e *DefineExpr) InferredType() DataType {
	return AnyDataType
}

func (e *DefineExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *DefineExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type CommentsExpr []CommentExpr

func (e *CommentsExpr) Op() Operator {
	return CommentsOp
}

func (e *CommentsExpr) ChildCount() int {
	return len(*e)
}

func (e *CommentsExpr) Child(nth int) Expr {
	return &(*e)[nth]
}

func (e *CommentsExpr) ChildName(nth int) string {
	return ""
}

func (e *CommentsExpr) Value() interface{} {
	return nil
}

func (e *CommentsExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		typedChildren := make(CommentsExpr, len(children))
		for i := 0; i < len(children); i++ {
			typedChildren[i] = *children[i].(*CommentExpr)
		}
		return &typedChildren
	}
	return e
}

func (e *CommentsExpr) Source() *SourceLoc {
	return nil
}

func (e *CommentsExpr) InferredType() DataType {
	return AnyDataType
}

func (e *CommentsExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *CommentsExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type CommentExpr string

func (e *CommentExpr) Op() Operator {
	return CommentOp
}

func (e *CommentExpr) ChildCount() int {
	return 0
}

func (e *CommentExpr) Child(nth int) Expr {
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *CommentExpr) ChildName(nth int) string {
	return ""
}

func (e *CommentExpr) Value() interface{} {
	return string(*e)
}

func (e *CommentExpr) Visit(visit VisitFunc) Expr {
	return e
}

func (e *CommentExpr) Source() *SourceLoc {
	return nil
}

func (e *CommentExpr) InferredType() DataType {
	return StringDataType
}

func (e *CommentExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *CommentExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type TagsExpr []TagExpr

func (e *TagsExpr) Op() Operator {
	return TagsOp
}

func (e *TagsExpr) ChildCount() int {
	return len(*e)
}

func (e *TagsExpr) Child(nth int) Expr {
	return &(*e)[nth]
}

func (e *TagsExpr) ChildName(nth int) string {
	return ""
}

func (e *TagsExpr) Value() interface{} {
	return nil
}

func (e *TagsExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		typedChildren := make(TagsExpr, len(children))
		for i := 0; i < len(children); i++ {
			typedChildren[i] = *children[i].(*TagExpr)
		}
		return &typedChildren
	}
	return e
}

func (e *TagsExpr) Source() *SourceLoc {
	return nil
}

func (e *TagsExpr) InferredType() DataType {
	return AnyDataType
}

func (e *TagsExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *TagsExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type TagExpr string

func (e *TagExpr) Op() Operator {
	return TagOp
}

func (e *TagExpr) ChildCount() int {
	return 0
}

func (e *TagExpr) Child(nth int) Expr {
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *TagExpr) ChildName(nth int) string {
	return ""
}

func (e *TagExpr) Value() interface{} {
	return string(*e)
}

func (e *TagExpr) Visit(visit VisitFunc) Expr {
	return e
}

func (e *TagExpr) Source() *SourceLoc {
	return nil
}

func (e *TagExpr) InferredType() DataType {
	return StringDataType
}

func (e *TagExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *TagExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type DefineFieldsExpr []*DefineFieldExpr

func (e *DefineFieldsExpr) Op() Operator {
	return DefineFieldsOp
}

func (e *DefineFieldsExpr) ChildCount() int {
	return len(*e)
}

func (e *DefineFieldsExpr) Child(nth int) Expr {
	return (*e)[nth]
}

func (e *DefineFieldsExpr) ChildName(nth int) string {
	return ""
}

func (e *DefineFieldsExpr) Value() interface{} {
	return nil
}

func (e *DefineFieldsExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		typedChildren := make(DefineFieldsExpr, len(children))
		for i := 0; i < len(children); i++ {
			typedChildren[i] = children[i].(*DefineFieldExpr)
		}
		return &typedChildren
	}
	return e
}

func (e *DefineFieldsExpr) Source() *SourceLoc {
	return nil
}

func (e *DefineFieldsExpr) InferredType() DataType {
	return AnyDataType
}

func (e *DefineFieldsExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *DefineFieldsExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type DefineFieldExpr struct {
	Comments CommentsExpr
	Name     StringExpr
	Type     StringExpr
	Src      *SourceLoc
}

func (e *DefineFieldExpr) Op() Operator {
	return DefineFieldOp
}

func (e *DefineFieldExpr) ChildCount() int {
	return 3
}

func (e *DefineFieldExpr) Child(nth int) Expr {
	switch nth {
	case 0:
		return &e.Comments
	case 1:
		return &e.Name
	case 2:
		return &e.Type
	}
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *DefineFieldExpr) ChildName(nth int) string {
	switch nth {
	case 0:
		return "Comments"
	case 1:
		return "Name"
	case 2:
		return "Type"
	}
	return ""
}

func (e *DefineFieldExpr) Value() interface{} {
	return nil
}

func (e *DefineFieldExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		return &DefineFieldExpr{Comments: *children[0].(*CommentsExpr), Name: *children[1].(*StringExpr), Type: *children[2].(*StringExpr), Src: e.Source()}
	}
	return e
}

func (e *DefineFieldExpr) Source() *SourceLoc {
	return e.Src
}

func (e *DefineFieldExpr) InferredType() DataType {
	return AnyDataType
}

func (e *DefineFieldExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *DefineFieldExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type RuleExpr struct {
	Comments CommentsExpr
	Name     StringExpr
	Tags     TagsExpr
	Match    *FuncExpr
	Replace  Expr
	Src      *SourceLoc
}

func (e *RuleExpr) Op() Operator {
	return RuleOp
}

func (e *RuleExpr) ChildCount() int {
	return 5
}

func (e *RuleExpr) Child(nth int) Expr {
	switch nth {
	case 0:
		return &e.Comments
	case 1:
		return &e.Name
	case 2:
		return &e.Tags
	case 3:
		return e.Match
	case 4:
		return e.Replace
	}
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *RuleExpr) ChildName(nth int) string {
	switch nth {
	case 0:
		return "Comments"
	case 1:
		return "Name"
	case 2:
		return "Tags"
	case 3:
		return "Match"
	case 4:
		return "Replace"
	}
	return ""
}

func (e *RuleExpr) Value() interface{} {
	return nil
}

func (e *RuleExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		return &RuleExpr{Comments: *children[0].(*CommentsExpr), Name: *children[1].(*StringExpr), Tags: *children[2].(*TagsExpr), Match: children[3].(*FuncExpr), Replace: children[4], Src: e.Source()}
	}
	return e
}

func (e *RuleExpr) Source() *SourceLoc {
	return e.Src
}

func (e *RuleExpr) InferredType() DataType {
	return AnyDataType
}

func (e *RuleExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *RuleExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type FuncExpr struct {
	Name Expr
	Args SliceExpr
	Src  *SourceLoc
	Typ  DataType
}

func (e *FuncExpr) Op() Operator {
	return FuncOp
}

func (e *FuncExpr) ChildCount() int {
	return 2
}

func (e *FuncExpr) Child(nth int) Expr {
	switch nth {
	case 0:
		return e.Name
	case 1:
		return &e.Args
	}
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *FuncExpr) ChildName(nth int) string {
	switch nth {
	case 0:
		return "Name"
	case 1:
		return "Args"
	}
	return ""
}

func (e *FuncExpr) Value() interface{} {
	return nil
}

func (e *FuncExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		return &FuncExpr{Name: children[0], Args: *children[1].(*SliceExpr), Src: e.Source()}
	}
	return e
}

func (e *FuncExpr) Source() *SourceLoc {
	return e.Src
}

func (e *FuncExpr) InferredType() DataType {
	return e.Typ
}

func (e *FuncExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *FuncExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type NamesExpr []NameExpr

func (e *NamesExpr) Op() Operator {
	return NamesOp
}

func (e *NamesExpr) ChildCount() int {
	return len(*e)
}

func (e *NamesExpr) Child(nth int) Expr {
	return &(*e)[nth]
}

func (e *NamesExpr) ChildName(nth int) string {
	return ""
}

func (e *NamesExpr) Value() interface{} {
	return nil
}

func (e *NamesExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		typedChildren := make(NamesExpr, len(children))
		for i := 0; i < len(children); i++ {
			typedChildren[i] = *children[i].(*NameExpr)
		}
		return &typedChildren
	}
	return e
}

func (e *NamesExpr) Source() *SourceLoc {
	return nil
}

func (e *NamesExpr) InferredType() DataType {
	return AnyDataType
}

func (e *NamesExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *NamesExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type NameExpr string

func (e *NameExpr) Op() Operator {
	return NameOp
}

func (e *NameExpr) ChildCount() int {
	return 0
}

func (e *NameExpr) Child(nth int) Expr {
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *NameExpr) ChildName(nth int) string {
	return ""
}

func (e *NameExpr) Value() interface{} {
	return string(*e)
}

func (e *NameExpr) Visit(visit VisitFunc) Expr {
	return e
}

func (e *NameExpr) Source() *SourceLoc {
	return nil
}

func (e *NameExpr) InferredType() DataType {
	return StringDataType
}

func (e *NameExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *NameExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type AndExpr struct {
	Left  Expr
	Right Expr
	Src   *SourceLoc
	Typ   DataType
}

func (e *AndExpr) Op() Operator {
	return AndOp
}

func (e *AndExpr) ChildCount() int {
	return 2
}

func (e *AndExpr) Child(nth int) Expr {
	switch nth {
	case 0:
		return e.Left
	case 1:
		return e.Right
	}
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *AndExpr) ChildName(nth int) string {
	switch nth {
	case 0:
		return "Left"
	case 1:
		return "Right"
	}
	return ""
}

func (e *AndExpr) Value() interface{} {
	return nil
}

func (e *AndExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		return &AndExpr{Left: children[0], Right: children[1], Src: e.Source()}
	}
	return e
}

func (e *AndExpr) Source() *SourceLoc {
	return e.Src
}

func (e *AndExpr) InferredType() DataType {
	return e.Typ
}

func (e *AndExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *AndExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type NotExpr struct {
	Input Expr
	Src   *SourceLoc
	Typ   DataType
}

func (e *NotExpr) Op() Operator {
	return NotOp
}

func (e *NotExpr) ChildCount() int {
	return 1
}

func (e *NotExpr) Child(nth int) Expr {
	switch nth {
	case 0:
		return e.Input
	}
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *NotExpr) ChildName(nth int) string {
	switch nth {
	case 0:
		return "Input"
	}
	return ""
}

func (e *NotExpr) Value() interface{} {
	return nil
}

func (e *NotExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		return &NotExpr{Input: children[0], Src: e.Source()}
	}
	return e
}

func (e *NotExpr) Source() *SourceLoc {
	return e.Src
}

func (e *NotExpr) InferredType() DataType {
	return e.Typ
}

func (e *NotExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *NotExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type ListExpr struct {
	Items SliceExpr
	Src   *SourceLoc
	Typ   DataType
}

func (e *ListExpr) Op() Operator {
	return ListOp
}

func (e *ListExpr) ChildCount() int {
	return 1
}

func (e *ListExpr) Child(nth int) Expr {
	switch nth {
	case 0:
		return &e.Items
	}
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *ListExpr) ChildName(nth int) string {
	switch nth {
	case 0:
		return "Items"
	}
	return ""
}

func (e *ListExpr) Value() interface{} {
	return nil
}

func (e *ListExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		return &ListExpr{Items: *children[0].(*SliceExpr), Src: e.Source()}
	}
	return e
}

func (e *ListExpr) Source() *SourceLoc {
	return e.Src
}

func (e *ListExpr) InferredType() DataType {
	return e.Typ
}

func (e *ListExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *ListExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type ListAnyExpr struct {
	Src *SourceLoc
}

func (e *ListAnyExpr) Op() Operator {
	return ListAnyOp
}

func (e *ListAnyExpr) ChildCount() int {
	return 0
}

func (e *ListAnyExpr) Child(nth int) Expr {
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *ListAnyExpr) ChildName(nth int) string {
	return ""
}

func (e *ListAnyExpr) Value() interface{} {
	return nil
}

func (e *ListAnyExpr) Visit(visit VisitFunc) Expr {
	return e
}

func (e *ListAnyExpr) Source() *SourceLoc {
	return e.Src
}

func (e *ListAnyExpr) InferredType() DataType {
	return AnyDataType
}

func (e *ListAnyExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *ListAnyExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type BindExpr struct {
	Label  StringExpr
	Target Expr
	Src    *SourceLoc
	Typ    DataType
}

func (e *BindExpr) Op() Operator {
	return BindOp
}

func (e *BindExpr) ChildCount() int {
	return 2
}

func (e *BindExpr) Child(nth int) Expr {
	switch nth {
	case 0:
		return &e.Label
	case 1:
		return e.Target
	}
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *BindExpr) ChildName(nth int) string {
	switch nth {
	case 0:
		return "Label"
	case 1:
		return "Target"
	}
	return ""
}

func (e *BindExpr) Value() interface{} {
	return nil
}

func (e *BindExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		return &BindExpr{Label: *children[0].(*StringExpr), Target: children[1], Src: e.Source()}
	}
	return e
}

func (e *BindExpr) Source() *SourceLoc {
	return e.Src
}

func (e *BindExpr) InferredType() DataType {
	return e.Typ
}

func (e *BindExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *BindExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type LetExpr struct {
	Labels StringsExpr
	Target Expr
	Result *RefExpr
	Src    *SourceLoc
	Typ    DataType
}

func (e *LetExpr) Op() Operator {
	return LetOp
}

func (e *LetExpr) ChildCount() int {
	return 3
}

func (e *LetExpr) Child(nth int) Expr {
	switch nth {
	case 0:
		return &e.Labels
	case 1:
		return e.Target
	case 2:
		return e.Result
	}
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *LetExpr) ChildName(nth int) string {
	switch nth {
	case 0:
		return "Labels"
	case 1:
		return "Target"
	case 2:
		return "Result"
	}
	return ""
}

func (e *LetExpr) Value() interface{} {
	return nil
}

func (e *LetExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		return &LetExpr{Labels: *children[0].(*StringsExpr), Target: children[1], Result: children[2].(*RefExpr), Src: e.Source()}
	}
	return e
}

func (e *LetExpr) Source() *SourceLoc {
	return e.Src
}

func (e *LetExpr) InferredType() DataType {
	return e.Typ
}

func (e *LetExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *LetExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type RefExpr struct {
	Label StringExpr
	Src   *SourceLoc
	Typ   DataType
}

func (e *RefExpr) Op() Operator {
	return RefOp
}

func (e *RefExpr) ChildCount() int {
	return 1
}

func (e *RefExpr) Child(nth int) Expr {
	switch nth {
	case 0:
		return &e.Label
	}
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *RefExpr) ChildName(nth int) string {
	switch nth {
	case 0:
		return "Label"
	}
	return ""
}

func (e *RefExpr) Value() interface{} {
	return nil
}

func (e *RefExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		return &RefExpr{Label: *children[0].(*StringExpr), Src: e.Source()}
	}
	return e
}

func (e *RefExpr) Source() *SourceLoc {
	return e.Src
}

func (e *RefExpr) InferredType() DataType {
	return e.Typ
}

func (e *RefExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *RefExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type AnyExpr struct {
	Src *SourceLoc
	Typ DataType
}

func (e *AnyExpr) Op() Operator {
	return AnyOp
}

func (e *AnyExpr) ChildCount() int {
	return 0
}

func (e *AnyExpr) Child(nth int) Expr {
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *AnyExpr) ChildName(nth int) string {
	return ""
}

func (e *AnyExpr) Value() interface{} {
	return nil
}

func (e *AnyExpr) Visit(visit VisitFunc) Expr {
	return e
}

func (e *AnyExpr) Source() *SourceLoc {
	return e.Src
}

func (e *AnyExpr) InferredType() DataType {
	return e.Typ
}

func (e *AnyExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *AnyExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type SliceExpr []Expr

func (e *SliceExpr) Op() Operator {
	return SliceOp
}

func (e *SliceExpr) ChildCount() int {
	return len(*e)
}

func (e *SliceExpr) Child(nth int) Expr {
	return (*e)[nth]
}

func (e *SliceExpr) ChildName(nth int) string {
	return ""
}

func (e *SliceExpr) Value() interface{} {
	return nil
}

func (e *SliceExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		typedChildren := SliceExpr(children)
		return &typedChildren
	}
	return e
}

func (e *SliceExpr) Source() *SourceLoc {
	return nil
}

func (e *SliceExpr) InferredType() DataType {
	return AnyDataType
}

func (e *SliceExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *SliceExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type StringExpr string

func (e *StringExpr) Op() Operator {
	return StringOp
}

func (e *StringExpr) ChildCount() int {
	return 0
}

func (e *StringExpr) Child(nth int) Expr {
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *StringExpr) ChildName(nth int) string {
	return ""
}

func (e *StringExpr) Value() interface{} {
	return string(*e)
}

func (e *StringExpr) Visit(visit VisitFunc) Expr {
	return e
}

func (e *StringExpr) Source() *SourceLoc {
	return nil
}

func (e *StringExpr) InferredType() DataType {
	return StringDataType
}

func (e *StringExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *StringExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type StringsExpr []StringExpr

func (e *StringsExpr) Op() Operator {
	return StringsOp
}

func (e *StringsExpr) ChildCount() int {
	return len(*e)
}

func (e *StringsExpr) Child(nth int) Expr {
	return &(*e)[nth]
}

func (e *StringsExpr) ChildName(nth int) string {
	return ""
}

func (e *StringsExpr) Value() interface{} {
	return nil
}

func (e *StringsExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		typedChildren := make(StringsExpr, len(children))
		for i := 0; i < len(children); i++ {
			typedChildren[i] = *children[i].(*StringExpr)
		}
		return &typedChildren
	}
	return e
}

func (e *StringsExpr) Source() *SourceLoc {
	return nil
}

func (e *StringsExpr) InferredType() DataType {
	return AnyDataType
}

func (e *StringsExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *StringsExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type NumberExpr int64

func (e *NumberExpr) Op() Operator {
	return NumberOp
}

func (e *NumberExpr) ChildCount() int {
	return 0
}

func (e *NumberExpr) Child(nth int) Expr {
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *NumberExpr) ChildName(nth int) string {
	return ""
}

func (e *NumberExpr) Value() interface{} {
	return int64(*e)
}

func (e *NumberExpr) Visit(visit VisitFunc) Expr {
	return e
}

func (e *NumberExpr) Source() *SourceLoc {
	return nil
}

func (e *NumberExpr) InferredType() DataType {
	return Int64DataType
}

func (e *NumberExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *NumberExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}

type CustomFuncExpr struct {
	Name NameExpr
	Args SliceExpr
	Src  *SourceLoc
	Typ  DataType
}

func (e *CustomFuncExpr) Op() Operator {
	return CustomFuncOp
}

func (e *CustomFuncExpr) ChildCount() int {
	return 2
}

func (e *CustomFuncExpr) Child(nth int) Expr {
	switch nth {
	case 0:
		return &e.Name
	case 1:
		return &e.Args
	}
	panic(fmt.Sprintf("child index %d is out of range", nth))
}

func (e *CustomFuncExpr) ChildName(nth int) string {
	switch nth {
	case 0:
		return "Name"
	case 1:
		return "Args"
	}
	return ""
}

func (e *CustomFuncExpr) Value() interface{} {
	return nil
}

func (e *CustomFuncExpr) Visit(visit VisitFunc) Expr {
	children := visitChildren(e, visit)
	if children != nil {
		return &CustomFuncExpr{Name: *children[0].(*NameExpr), Args: *children[1].(*SliceExpr), Src: e.Source()}
	}
	return e
}

func (e *CustomFuncExpr) Source() *SourceLoc {
	return e.Src
}

func (e *CustomFuncExpr) InferredType() DataType {
	return e.Typ
}

func (e *CustomFuncExpr) String() string {
	var buf bytes.Buffer
	e.Format(&buf, 0)
	return buf.String()
}

func (e *CustomFuncExpr) Format(buf *bytes.Buffer, level int) {
	formatExpr(e, buf, level)
}
