// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package sql

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[NodeOK-0]
	_ = x[NodeUnhealthy-1]
	_ = x[NodeDraining-2]
}

func (i NodeStatus) String() string {
	switch i {
	case NodeOK:
		return "NodeOK"
	case NodeUnhealthy:
		return "NodeUnhealthy"
	case NodeDraining:
		return "NodeDraining"
	default:
		return "NodeStatus(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
