# DO NOT EDIT THIS FILE MANUALLY! Use `release update-releases-file`.
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")

CONFIG_LINUX_AMD64 = "linux-amd64"
CONFIG_LINUX_ARM64 = "linux-arm64"
CONFIG_DARWIN_AMD64 = "darwin-10.9-amd64"
CONFIG_DARWIN_ARM64 = "darwin-11.0-arm64"

_CONFIGS = [
    ("24.2.7", [
        (CONFIG_DARWIN_AMD64, "e2e411277fa62b5c84213f744bcfcfb1d1ff01b1bba9739da7f5fa69821e851b"),
        (CONFIG_DARWIN_ARM64, "23b50510c0272267b77a9fcff684f5a9d492b5d2de22058fea601cd9a1cce75b"),
        (CONFIG_LINUX_AMD64, "09ca3a221e7fc4842ae5830759dd944173d93b376707357ebb5e31d580e73390"),
        (CONFIG_LINUX_ARM64, "be7942c88f5e55c9272a1f9961c685737091897c305247766668f8405ceae59a"),
    ]),
    ("24.3.2", [
        (CONFIG_DARWIN_AMD64, "9b500e5e99f6f8460d0b49a7ac2094c7ae699345997a498abd985e348ae5e72c"),
        (CONFIG_DARWIN_ARM64, "07d318d23440579c2531af305c50c62e51edb5e28c63f67d4f7f3c6829d4d801"),
        (CONFIG_LINUX_AMD64, "9eead2cf7d8619b0d8cf40a11cb960b5f268b5e71a6265e1a1fc6825f7caa17b"),
        (CONFIG_LINUX_ARM64, "7cdba86e2937ae7fa5be889112cd1045d61d5c83f1921e0b7cbe5e2b50da5328"),
    ]),
]

def _munge_name(s):
    return s.replace("-", "_").replace(".", "_")

def _repo_name(version, config_name):
    return "cockroach_binary_v{}_{}".format(
        _munge_name(version),
        _munge_name(config_name))

def _file_name(version, config_name):
    return "cockroach-v{}.{}/cockroach".format(
        version, config_name)

def target(config_name):
    targets = []
    for versionAndConfigs in _CONFIGS:
        version, _ = versionAndConfigs
        targets.append("@{}//:{}".format(_repo_name(version, config_name),
                                         _file_name(version, config_name)))
    return targets

def cockroach_binaries_for_testing():
    for versionAndConfigs in _CONFIGS:
        version, configs = versionAndConfigs
        for config in configs:
            config_name, shasum = config
            file_name = _file_name(version, config_name)
            http_archive(
                name = _repo_name(version, config_name),
                build_file_content = """exports_files(["{}"])""".format(file_name),
                sha256 = shasum,
                urls = [
                    "https://binaries.cockroachdb.com/{}".format(
                        file_name.removesuffix("/cockroach")) + ".tgz",
                ],
            )
