// Copyright 2021 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package execinfrapb

// Prettier aliases for AggregatorSpec_Func values.
const (
	AnyNotNull     = AggregatorSpec_ANY_NOT_NULL
	Avg            = AggregatorSpec_AVG
	BoolAnd        = AggregatorSpec_BOOL_AND
	BoolOr         = AggregatorSpec_BOOL_OR
	ConcatAgg      = AggregatorSpec_CONCAT_AGG
	Count          = AggregatorSpec_COUNT
	Max            = AggregatorSpec_MAX
	Min            = AggregatorSpec_MIN
	Stddev         = AggregatorSpec_STDDEV
	Sum            = AggregatorSpec_SUM
	SumInt         = AggregatorSpec_SUM_INT
	Variance       = AggregatorSpec_VARIANCE
	XorAgg         = AggregatorSpec_XOR_AGG
	CountRows      = AggregatorSpec_COUNT_ROWS
	Sqrdiff        = AggregatorSpec_SQRDIFF
	FinalVariance  = AggregatorSpec_FINAL_VARIANCE
	FinalVarPop    = AggregatorSpec_FINAL_VAR_POP
	FinalStddev    = AggregatorSpec_FINAL_STDDEV
	FinalStddevPop = AggregatorSpec_FINAL_STDDEV_POP
	ArrayAgg       = AggregatorSpec_ARRAY_AGG
	JSONAgg        = AggregatorSpec_JSON_AGG
	// JSONBAgg is an alias for JSONAgg, they do the same thing.
	JSONBAgg                    = AggregatorSpec_JSONB_AGG
	StringAgg                   = AggregatorSpec_STRING_AGG
	BitAnd                      = AggregatorSpec_BIT_AND
	BitOr                       = AggregatorSpec_BIT_OR
	Corr                        = AggregatorSpec_CORR
	PercentileDiscImpl          = AggregatorSpec_PERCENTILE_DISC_IMPL
	PercentileContImpl          = AggregatorSpec_PERCENTILE_CONT_IMPL
	JSONObjectAgg               = AggregatorSpec_JSON_OBJECT_AGG
	JSONBObjectAgg              = AggregatorSpec_JSONB_OBJECT_AGG
	VarPop                      = AggregatorSpec_VAR_POP
	StddevPop                   = AggregatorSpec_STDDEV_POP
	StMakeline                  = AggregatorSpec_ST_MAKELINE
	StExtent                    = AggregatorSpec_ST_EXTENT
	StUnion                     = AggregatorSpec_ST_UNION
	StCollect                   = AggregatorSpec_ST_COLLECT
	CovarPop                    = AggregatorSpec_COVAR_POP
	CovarSamp                   = AggregatorSpec_COVAR_SAMP
	RegrIntercept               = AggregatorSpec_REGR_INTERCEPT
	RegrR2                      = AggregatorSpec_REGR_R2
	RegrSlope                   = AggregatorSpec_REGR_SLOPE
	RegrSxx                     = AggregatorSpec_REGR_SXX
	RegrSyy                     = AggregatorSpec_REGR_SYY
	RegrSxy                     = AggregatorSpec_REGR_SXY
	RegrCount                   = AggregatorSpec_REGR_COUNT
	RegrAvgx                    = AggregatorSpec_REGR_AVGX
	RegrAvgy                    = AggregatorSpec_REGR_AVGY
	TransitionRegrAggregate     = AggregatorSpec_TRANSITION_REGRESSION_AGGREGATE
	FinalCovarPop               = AggregatorSpec_FINAL_COVAR_POP
	FinalRegrSxx                = AggregatorSpec_FINAL_REGR_SXX
	FinalRegrSxy                = AggregatorSpec_FINAL_REGR_SXY
	FinalRegrSyy                = AggregatorSpec_FINAL_REGR_SYY
	FinalRegrAvgx               = AggregatorSpec_FINAL_REGR_AVGX
	FinalRegrAvgy               = AggregatorSpec_FINAL_REGR_AVGY
	FinalRegrIntercept          = AggregatorSpec_FINAL_REGR_INTERCEPT
	FinalRegrR2                 = AggregatorSpec_FINAL_REGR_R2
	FinalRegrSlope              = AggregatorSpec_FINAL_REGR_SLOPE
	FinalCovarSamp              = AggregatorSpec_FINAL_COVAR_SAMP
	FinalCorr                   = AggregatorSpec_FINAL_CORR
	FinalSqrdiff                = AggregatorSpec_FINAL_SQRDIFF
	ArrayCatAgg                 = AggregatorSpec_ARRAY_CAT_AGG
	MergeStatsMetadata          = AggregatorSpec_MERGE_STATS_METADATA
	MergeStatementStats         = AggregatorSpec_MERGE_STATEMENT_STATS
	MergeTransactionStats       = AggregatorSpec_MERGE_TRANSACTION_STATS
	MergeAggregatedStmtMetadata = AggregatorSpec_MERGE_AGGREGATED_STMT_METADATA
)
