// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package execinfra

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[StateRunning-0]
	_ = x[StateDraining-1]
	_ = x[StateTrailingMeta-2]
	_ = x[StateExhausted-3]
}

func (i procState) String() string {
	switch i {
	case StateRunning:
		return "StateRunning"
	case StateDraining:
		return "StateDraining"
	case StateTrailingMeta:
		return "StateTrailingMeta"
	case StateExhausted:
		return "StateExhausted"
	default:
		return "procState(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
