// Copyright 2023 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

// Code generated by "stringer"; DO NOT EDIT.

package colfetcher

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[stateInvalid-0]
	_ = x[stateInitFetch-1]
	_ = x[stateResetBatch-2]
	_ = x[stateDecodeFirstKVOfRow-3]
	_ = x[stateFetchNextKVWithUnfinishedRow-4]
	_ = x[stateFinalizeRow-5]
	_ = x[stateEmitLastBatch-6]
	_ = x[stateFinished-7]
}

func (i fetcherState) String() string {
	switch i {
	case stateInvalid:
		return "stateInvalid"
	case stateInitFetch:
		return "stateInitFetch"
	case stateResetBatch:
		return "stateResetBatch"
	case stateDecodeFirstKVOfRow:
		return "stateDecodeFirstKVOfRow"
	case stateFetchNextKVWithUnfinishedRow:
		return "stateFetchNextKVWithUnfinishedRow"
	case stateFinalizeRow:
		return "stateFinalizeRow"
	case stateEmitLastBatch:
		return "stateEmitLastBatch"
	case stateFinished:
		return "stateFinished"
	default:
		return "fetcherState(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
