// Code generated by execgen; DO NOT EDIT.
// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexec

import (
	"bytes"
	"math"

	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ = coldataext.CompareDatum
	_ tree.AggType
)

// vecComparator is a helper for the ordered synchronizer. It stores multiple
// column vectors of a single type and facilitates comparing values between
// them.
type vecComparator interface {
	// compare compares values from two vectors. vecIdx is the index of the vector
	// and valIdx is the index of the value in that vector to compare. Returns -1,
	// 0, or 1.
	compare(vecIdx1, vecIdx2 int, valIdx1, valIdx2 int) int

	// set sets the value of the vector at dstVecIdx at index dstValIdx to the value
	// at the vector at srcVecIdx at index srcValIdx.
	// NOTE: whenever set is used, the caller is responsible for updating the
	// memory accounts.
	set(srcVecIdx, dstVecIdx int, srcValIdx, dstValIdx int)

	// setVec updates the vector at idx.
	setVec(idx int, vec *coldata.Vec)
}

type BoolVecComparator struct {
	vecs  []coldata.Bools
	nulls []*coldata.Nulls
}

func (c *BoolVecComparator) compare(vecIdx1, vecIdx2 int, valIdx1, valIdx2 int) int {
	n1 := c.nulls[vecIdx1].MaybeHasNulls() && c.nulls[vecIdx1].NullAt(valIdx1)
	n2 := c.nulls[vecIdx2].MaybeHasNulls() && c.nulls[vecIdx2].NullAt(valIdx2)
	if n1 && n2 {
		return 0
	} else if n1 {
		return -1
	} else if n2 {
		return 1
	}
	left := c.vecs[vecIdx1].Get(valIdx1)
	right := c.vecs[vecIdx2].Get(valIdx2)
	var cmp int

	if !left && right {
		cmp = -1
	} else if left && !right {
		cmp = 1
	} else {
		cmp = 0
	}

	return cmp
}

func (c *BoolVecComparator) setVec(idx int, vec *coldata.Vec) {
	c.vecs[idx] = vec.Bool()
	c.nulls[idx] = vec.Nulls()
}

func (c *BoolVecComparator) set(srcVecIdx, dstVecIdx int, srcIdx, dstIdx int) {
	if c.nulls[srcVecIdx].MaybeHasNulls() && c.nulls[srcVecIdx].NullAt(srcIdx) {
		c.nulls[dstVecIdx].SetNull(dstIdx)
	} else {
		c.nulls[dstVecIdx].UnsetNull(dstIdx)
		v := c.vecs[srcVecIdx].Get(srcIdx)
		c.vecs[dstVecIdx].Set(dstIdx, v)
	}
}

type BytesVecComparator struct {
	vecs  []*coldata.Bytes
	nulls []*coldata.Nulls
}

func (c *BytesVecComparator) compare(vecIdx1, vecIdx2 int, valIdx1, valIdx2 int) int {
	n1 := c.nulls[vecIdx1].MaybeHasNulls() && c.nulls[vecIdx1].NullAt(valIdx1)
	n2 := c.nulls[vecIdx2].MaybeHasNulls() && c.nulls[vecIdx2].NullAt(valIdx2)
	if n1 && n2 {
		return 0
	} else if n1 {
		return -1
	} else if n2 {
		return 1
	}
	left := c.vecs[vecIdx1].Get(valIdx1)
	right := c.vecs[vecIdx2].Get(valIdx2)
	var cmp int
	cmp = bytes.Compare(left, right)
	return cmp
}

func (c *BytesVecComparator) setVec(idx int, vec *coldata.Vec) {
	c.vecs[idx] = vec.Bytes()
	c.nulls[idx] = vec.Nulls()
}

func (c *BytesVecComparator) set(srcVecIdx, dstVecIdx int, srcIdx, dstIdx int) {
	if c.nulls[srcVecIdx].MaybeHasNulls() && c.nulls[srcVecIdx].NullAt(srcIdx) {
		c.nulls[dstVecIdx].SetNull(dstIdx)
	} else {
		c.nulls[dstVecIdx].UnsetNull(dstIdx)
		c.vecs[dstVecIdx].Copy(c.vecs[srcVecIdx], dstIdx, srcIdx)
	}
}

type DecimalVecComparator struct {
	vecs  []coldata.Decimals
	nulls []*coldata.Nulls
}

func (c *DecimalVecComparator) compare(vecIdx1, vecIdx2 int, valIdx1, valIdx2 int) int {
	n1 := c.nulls[vecIdx1].MaybeHasNulls() && c.nulls[vecIdx1].NullAt(valIdx1)
	n2 := c.nulls[vecIdx2].MaybeHasNulls() && c.nulls[vecIdx2].NullAt(valIdx2)
	if n1 && n2 {
		return 0
	} else if n1 {
		return -1
	} else if n2 {
		return 1
	}
	left := c.vecs[vecIdx1].Get(valIdx1)
	right := c.vecs[vecIdx2].Get(valIdx2)
	var cmp int
	cmp = tree.CompareDecimals(&left, &right)
	return cmp
}

func (c *DecimalVecComparator) setVec(idx int, vec *coldata.Vec) {
	c.vecs[idx] = vec.Decimal()
	c.nulls[idx] = vec.Nulls()
}

func (c *DecimalVecComparator) set(srcVecIdx, dstVecIdx int, srcIdx, dstIdx int) {
	if c.nulls[srcVecIdx].MaybeHasNulls() && c.nulls[srcVecIdx].NullAt(srcIdx) {
		c.nulls[dstVecIdx].SetNull(dstIdx)
	} else {
		c.nulls[dstVecIdx].UnsetNull(dstIdx)
		v := c.vecs[srcVecIdx].Get(srcIdx)
		c.vecs[dstVecIdx].Set(dstIdx, v)
	}
}

type Int16VecComparator struct {
	vecs  []coldata.Int16s
	nulls []*coldata.Nulls
}

func (c *Int16VecComparator) compare(vecIdx1, vecIdx2 int, valIdx1, valIdx2 int) int {
	n1 := c.nulls[vecIdx1].MaybeHasNulls() && c.nulls[vecIdx1].NullAt(valIdx1)
	n2 := c.nulls[vecIdx2].MaybeHasNulls() && c.nulls[vecIdx2].NullAt(valIdx2)
	if n1 && n2 {
		return 0
	} else if n1 {
		return -1
	} else if n2 {
		return 1
	}
	left := c.vecs[vecIdx1].Get(valIdx1)
	right := c.vecs[vecIdx2].Get(valIdx2)
	var cmp int

	{
		a, b := int64(left), int64(right)
		if a < b {
			cmp = -1
		} else if a > b {
			cmp = 1
		} else {
			cmp = 0
		}
	}

	return cmp
}

func (c *Int16VecComparator) setVec(idx int, vec *coldata.Vec) {
	c.vecs[idx] = vec.Int16()
	c.nulls[idx] = vec.Nulls()
}

func (c *Int16VecComparator) set(srcVecIdx, dstVecIdx int, srcIdx, dstIdx int) {
	if c.nulls[srcVecIdx].MaybeHasNulls() && c.nulls[srcVecIdx].NullAt(srcIdx) {
		c.nulls[dstVecIdx].SetNull(dstIdx)
	} else {
		c.nulls[dstVecIdx].UnsetNull(dstIdx)
		v := c.vecs[srcVecIdx].Get(srcIdx)
		c.vecs[dstVecIdx].Set(dstIdx, v)
	}
}

type Int32VecComparator struct {
	vecs  []coldata.Int32s
	nulls []*coldata.Nulls
}

func (c *Int32VecComparator) compare(vecIdx1, vecIdx2 int, valIdx1, valIdx2 int) int {
	n1 := c.nulls[vecIdx1].MaybeHasNulls() && c.nulls[vecIdx1].NullAt(valIdx1)
	n2 := c.nulls[vecIdx2].MaybeHasNulls() && c.nulls[vecIdx2].NullAt(valIdx2)
	if n1 && n2 {
		return 0
	} else if n1 {
		return -1
	} else if n2 {
		return 1
	}
	left := c.vecs[vecIdx1].Get(valIdx1)
	right := c.vecs[vecIdx2].Get(valIdx2)
	var cmp int

	{
		a, b := int64(left), int64(right)
		if a < b {
			cmp = -1
		} else if a > b {
			cmp = 1
		} else {
			cmp = 0
		}
	}

	return cmp
}

func (c *Int32VecComparator) setVec(idx int, vec *coldata.Vec) {
	c.vecs[idx] = vec.Int32()
	c.nulls[idx] = vec.Nulls()
}

func (c *Int32VecComparator) set(srcVecIdx, dstVecIdx int, srcIdx, dstIdx int) {
	if c.nulls[srcVecIdx].MaybeHasNulls() && c.nulls[srcVecIdx].NullAt(srcIdx) {
		c.nulls[dstVecIdx].SetNull(dstIdx)
	} else {
		c.nulls[dstVecIdx].UnsetNull(dstIdx)
		v := c.vecs[srcVecIdx].Get(srcIdx)
		c.vecs[dstVecIdx].Set(dstIdx, v)
	}
}

type Int64VecComparator struct {
	vecs  []coldata.Int64s
	nulls []*coldata.Nulls
}

func (c *Int64VecComparator) compare(vecIdx1, vecIdx2 int, valIdx1, valIdx2 int) int {
	n1 := c.nulls[vecIdx1].MaybeHasNulls() && c.nulls[vecIdx1].NullAt(valIdx1)
	n2 := c.nulls[vecIdx2].MaybeHasNulls() && c.nulls[vecIdx2].NullAt(valIdx2)
	if n1 && n2 {
		return 0
	} else if n1 {
		return -1
	} else if n2 {
		return 1
	}
	left := c.vecs[vecIdx1].Get(valIdx1)
	right := c.vecs[vecIdx2].Get(valIdx2)
	var cmp int

	{
		a, b := int64(left), int64(right)
		if a < b {
			cmp = -1
		} else if a > b {
			cmp = 1
		} else {
			cmp = 0
		}
	}

	return cmp
}

func (c *Int64VecComparator) setVec(idx int, vec *coldata.Vec) {
	c.vecs[idx] = vec.Int64()
	c.nulls[idx] = vec.Nulls()
}

func (c *Int64VecComparator) set(srcVecIdx, dstVecIdx int, srcIdx, dstIdx int) {
	if c.nulls[srcVecIdx].MaybeHasNulls() && c.nulls[srcVecIdx].NullAt(srcIdx) {
		c.nulls[dstVecIdx].SetNull(dstIdx)
	} else {
		c.nulls[dstVecIdx].UnsetNull(dstIdx)
		v := c.vecs[srcVecIdx].Get(srcIdx)
		c.vecs[dstVecIdx].Set(dstIdx, v)
	}
}

type Float64VecComparator struct {
	vecs  []coldata.Float64s
	nulls []*coldata.Nulls
}

func (c *Float64VecComparator) compare(vecIdx1, vecIdx2 int, valIdx1, valIdx2 int) int {
	n1 := c.nulls[vecIdx1].MaybeHasNulls() && c.nulls[vecIdx1].NullAt(valIdx1)
	n2 := c.nulls[vecIdx2].MaybeHasNulls() && c.nulls[vecIdx2].NullAt(valIdx2)
	if n1 && n2 {
		return 0
	} else if n1 {
		return -1
	} else if n2 {
		return 1
	}
	left := c.vecs[vecIdx1].Get(valIdx1)
	right := c.vecs[vecIdx2].Get(valIdx2)
	var cmp int

	{
		a, b := float64(left), float64(right)
		if a < b {
			cmp = -1
		} else if a > b {
			cmp = 1
		} else if a == b {
			cmp = 0
		} else if math.IsNaN(a) {
			if math.IsNaN(b) {
				cmp = 0
			} else {
				cmp = -1
			}
		} else {
			cmp = 1
		}
	}

	return cmp
}

func (c *Float64VecComparator) setVec(idx int, vec *coldata.Vec) {
	c.vecs[idx] = vec.Float64()
	c.nulls[idx] = vec.Nulls()
}

func (c *Float64VecComparator) set(srcVecIdx, dstVecIdx int, srcIdx, dstIdx int) {
	if c.nulls[srcVecIdx].MaybeHasNulls() && c.nulls[srcVecIdx].NullAt(srcIdx) {
		c.nulls[dstVecIdx].SetNull(dstIdx)
	} else {
		c.nulls[dstVecIdx].UnsetNull(dstIdx)
		v := c.vecs[srcVecIdx].Get(srcIdx)
		c.vecs[dstVecIdx].Set(dstIdx, v)
	}
}

type TimestampVecComparator struct {
	vecs  []coldata.Times
	nulls []*coldata.Nulls
}

func (c *TimestampVecComparator) compare(vecIdx1, vecIdx2 int, valIdx1, valIdx2 int) int {
	n1 := c.nulls[vecIdx1].MaybeHasNulls() && c.nulls[vecIdx1].NullAt(valIdx1)
	n2 := c.nulls[vecIdx2].MaybeHasNulls() && c.nulls[vecIdx2].NullAt(valIdx2)
	if n1 && n2 {
		return 0
	} else if n1 {
		return -1
	} else if n2 {
		return 1
	}
	left := c.vecs[vecIdx1].Get(valIdx1)
	right := c.vecs[vecIdx2].Get(valIdx2)
	var cmp int

	if left.Before(right) {
		cmp = -1
	} else if right.Before(left) {
		cmp = 1
	} else {
		cmp = 0
	}
	return cmp
}

func (c *TimestampVecComparator) setVec(idx int, vec *coldata.Vec) {
	c.vecs[idx] = vec.Timestamp()
	c.nulls[idx] = vec.Nulls()
}

func (c *TimestampVecComparator) set(srcVecIdx, dstVecIdx int, srcIdx, dstIdx int) {
	if c.nulls[srcVecIdx].MaybeHasNulls() && c.nulls[srcVecIdx].NullAt(srcIdx) {
		c.nulls[dstVecIdx].SetNull(dstIdx)
	} else {
		c.nulls[dstVecIdx].UnsetNull(dstIdx)
		v := c.vecs[srcVecIdx].Get(srcIdx)
		c.vecs[dstVecIdx].Set(dstIdx, v)
	}
}

type IntervalVecComparator struct {
	vecs  []coldata.Durations
	nulls []*coldata.Nulls
}

func (c *IntervalVecComparator) compare(vecIdx1, vecIdx2 int, valIdx1, valIdx2 int) int {
	n1 := c.nulls[vecIdx1].MaybeHasNulls() && c.nulls[vecIdx1].NullAt(valIdx1)
	n2 := c.nulls[vecIdx2].MaybeHasNulls() && c.nulls[vecIdx2].NullAt(valIdx2)
	if n1 && n2 {
		return 0
	} else if n1 {
		return -1
	} else if n2 {
		return 1
	}
	left := c.vecs[vecIdx1].Get(valIdx1)
	right := c.vecs[vecIdx2].Get(valIdx2)
	var cmp int
	cmp = left.Compare(right)
	return cmp
}

func (c *IntervalVecComparator) setVec(idx int, vec *coldata.Vec) {
	c.vecs[idx] = vec.Interval()
	c.nulls[idx] = vec.Nulls()
}

func (c *IntervalVecComparator) set(srcVecIdx, dstVecIdx int, srcIdx, dstIdx int) {
	if c.nulls[srcVecIdx].MaybeHasNulls() && c.nulls[srcVecIdx].NullAt(srcIdx) {
		c.nulls[dstVecIdx].SetNull(dstIdx)
	} else {
		c.nulls[dstVecIdx].UnsetNull(dstIdx)
		v := c.vecs[srcVecIdx].Get(srcIdx)
		c.vecs[dstVecIdx].Set(dstIdx, v)
	}
}

type JSONVecComparator struct {
	vecs  []*coldata.JSONs
	nulls []*coldata.Nulls
}

func (c *JSONVecComparator) compare(vecIdx1, vecIdx2 int, valIdx1, valIdx2 int) int {
	n1 := c.nulls[vecIdx1].MaybeHasNulls() && c.nulls[vecIdx1].NullAt(valIdx1)
	n2 := c.nulls[vecIdx2].MaybeHasNulls() && c.nulls[vecIdx2].NullAt(valIdx2)
	if n1 && n2 {
		return 0
	} else if n1 {
		return -1
	} else if n2 {
		return 1
	}
	left := c.vecs[vecIdx1].Get(valIdx1)
	right := c.vecs[vecIdx2].Get(valIdx2)
	var cmp int

	var err error
	cmp, err = left.Compare(right)
	if err != nil {
		colexecerror.ExpectedError(err)
	}

	return cmp
}

func (c *JSONVecComparator) setVec(idx int, vec *coldata.Vec) {
	c.vecs[idx] = vec.JSON()
	c.nulls[idx] = vec.Nulls()
}

func (c *JSONVecComparator) set(srcVecIdx, dstVecIdx int, srcIdx, dstIdx int) {
	if c.nulls[srcVecIdx].MaybeHasNulls() && c.nulls[srcVecIdx].NullAt(srcIdx) {
		c.nulls[dstVecIdx].SetNull(dstIdx)
	} else {
		c.nulls[dstVecIdx].UnsetNull(dstIdx)
		c.vecs[dstVecIdx].Copy(c.vecs[srcVecIdx], dstIdx, srcIdx)
	}
}

type DatumVecComparator struct {
	vecs  []coldata.DatumVec
	nulls []*coldata.Nulls
}

func (c *DatumVecComparator) compare(vecIdx1, vecIdx2 int, valIdx1, valIdx2 int) int {
	n1 := c.nulls[vecIdx1].MaybeHasNulls() && c.nulls[vecIdx1].NullAt(valIdx1)
	n2 := c.nulls[vecIdx2].MaybeHasNulls() && c.nulls[vecIdx2].NullAt(valIdx2)
	if n1 && n2 {
		return 0
	} else if n1 {
		return -1
	} else if n2 {
		return 1
	}
	left := c.vecs[vecIdx1].Get(valIdx1)
	right := c.vecs[vecIdx2].Get(valIdx2)
	var cmp int

	cmp = coldataext.CompareDatum(left, c.vecs[vecIdx1], right)

	return cmp
}

func (c *DatumVecComparator) setVec(idx int, vec *coldata.Vec) {
	c.vecs[idx] = vec.Datum()
	c.nulls[idx] = vec.Nulls()
}

func (c *DatumVecComparator) set(srcVecIdx, dstVecIdx int, srcIdx, dstIdx int) {
	if c.nulls[srcVecIdx].MaybeHasNulls() && c.nulls[srcVecIdx].NullAt(srcIdx) {
		c.nulls[dstVecIdx].SetNull(dstIdx)
	} else {
		c.nulls[dstVecIdx].UnsetNull(dstIdx)
		v := c.vecs[srcVecIdx].Get(srcIdx)
		c.vecs[dstVecIdx].Set(dstIdx, v)
	}
}

func GetVecComparator(t *types.T, numVecs int) vecComparator {
	switch typeconv.TypeFamilyToCanonicalTypeFamily(t.Family()) {
	case types.BoolFamily:
		switch t.Width() {
		case -1:
		default:
			return &BoolVecComparator{
				vecs:  make([]coldata.Bools, numVecs),
				nulls: make([]*coldata.Nulls, numVecs),
			}
		}
	case types.BytesFamily:
		switch t.Width() {
		case -1:
		default:
			return &BytesVecComparator{
				vecs:  make([]*coldata.Bytes, numVecs),
				nulls: make([]*coldata.Nulls, numVecs),
			}
		}
	case types.DecimalFamily:
		switch t.Width() {
		case -1:
		default:
			return &DecimalVecComparator{
				vecs:  make([]coldata.Decimals, numVecs),
				nulls: make([]*coldata.Nulls, numVecs),
			}
		}
	case types.IntFamily:
		switch t.Width() {
		case 16:
			return &Int16VecComparator{
				vecs:  make([]coldata.Int16s, numVecs),
				nulls: make([]*coldata.Nulls, numVecs),
			}
		case 32:
			return &Int32VecComparator{
				vecs:  make([]coldata.Int32s, numVecs),
				nulls: make([]*coldata.Nulls, numVecs),
			}
		case -1:
		default:
			return &Int64VecComparator{
				vecs:  make([]coldata.Int64s, numVecs),
				nulls: make([]*coldata.Nulls, numVecs),
			}
		}
	case types.FloatFamily:
		switch t.Width() {
		case -1:
		default:
			return &Float64VecComparator{
				vecs:  make([]coldata.Float64s, numVecs),
				nulls: make([]*coldata.Nulls, numVecs),
			}
		}
	case types.TimestampTZFamily:
		switch t.Width() {
		case -1:
		default:
			return &TimestampVecComparator{
				vecs:  make([]coldata.Times, numVecs),
				nulls: make([]*coldata.Nulls, numVecs),
			}
		}
	case types.IntervalFamily:
		switch t.Width() {
		case -1:
		default:
			return &IntervalVecComparator{
				vecs:  make([]coldata.Durations, numVecs),
				nulls: make([]*coldata.Nulls, numVecs),
			}
		}
	case types.JsonFamily:
		switch t.Width() {
		case -1:
		default:
			return &JSONVecComparator{
				vecs:  make([]*coldata.JSONs, numVecs),
				nulls: make([]*coldata.Nulls, numVecs),
			}
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch t.Width() {
		case -1:
		default:
			return &DatumVecComparator{
				vecs:  make([]coldata.DatumVec, numVecs),
				nulls: make([]*coldata.Nulls, numVecs),
			}
		}
	}
	colexecerror.InternalError(errors.AssertionFailedf("unhandled type %s", t))
	// This code is unreachable, but the compiler cannot infer that.
	return nil
}
