// Code generated by execgen; DO NOT EDIT.
// Copyright 2018 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexec

import (
	"bytes"
	"context"
	"math"
	"math/bits"

	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexecutils"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
	"github.com/cockroachdb/cockroach/pkg/sql/execinfrapb"
	"github.com/cockroachdb/cockroach/pkg/sql/memsize"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ = coldataext.CompareDatum
	_ tree.AggType
)

func newSingleSorterWithNulls(t *types.T, dir execinfrapb.Ordering_Column_Direction) colSorter {
	switch dir {
	case execinfrapb.Ordering_Column_ASC:
		switch typeconv.TypeFamilyToCanonicalTypeFamily(t.Family()) {
		case types.BoolFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortBoolAscWithNullsOp{}
			}
		case types.BytesFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortBytesAscWithNullsOp{}
			}
		case types.DecimalFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortDecimalAscWithNullsOp{}
			}
		case types.IntFamily:
			switch t.Width() {
			case 16:
				return &sortInt16AscWithNullsOp{}
			case 32:
				return &sortInt32AscWithNullsOp{}
			case -1:
			default:
				return &sortInt64AscWithNullsOp{}
			}
		case types.FloatFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortFloat64AscWithNullsOp{}
			}
		case types.TimestampTZFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortTimestampAscWithNullsOp{}
			}
		case types.IntervalFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortIntervalAscWithNullsOp{}
			}
		case types.JsonFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortJSONAscWithNullsOp{}
			}
		case typeconv.DatumVecCanonicalTypeFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortDatumAscWithNullsOp{}
			}
		}
	case execinfrapb.Ordering_Column_DESC:
		switch typeconv.TypeFamilyToCanonicalTypeFamily(t.Family()) {
		case types.BoolFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortBoolDescWithNullsOp{}
			}
		case types.BytesFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortBytesDescWithNullsOp{}
			}
		case types.DecimalFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortDecimalDescWithNullsOp{}
			}
		case types.IntFamily:
			switch t.Width() {
			case 16:
				return &sortInt16DescWithNullsOp{}
			case 32:
				return &sortInt32DescWithNullsOp{}
			case -1:
			default:
				return &sortInt64DescWithNullsOp{}
			}
		case types.FloatFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortFloat64DescWithNullsOp{}
			}
		case types.TimestampTZFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortTimestampDescWithNullsOp{}
			}
		case types.IntervalFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortIntervalDescWithNullsOp{}
			}
		case types.JsonFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortJSONDescWithNullsOp{}
			}
		case typeconv.DatumVecCanonicalTypeFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortDatumDescWithNullsOp{}
			}
		}
	}
	colexecerror.InternalError(errors.AssertionFailedf("unsupported type %s", t))
	// This code is unreachable, but the compiler cannot infer that.
	return nil
}

func newSingleSorterWithoutNulls(t *types.T, dir execinfrapb.Ordering_Column_Direction) colSorter {
	switch dir {
	case execinfrapb.Ordering_Column_ASC:
		switch typeconv.TypeFamilyToCanonicalTypeFamily(t.Family()) {
		case types.BoolFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortBoolAscOp{}
			}
		case types.BytesFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortBytesAscOp{}
			}
		case types.DecimalFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortDecimalAscOp{}
			}
		case types.IntFamily:
			switch t.Width() {
			case 16:
				return &sortInt16AscOp{}
			case 32:
				return &sortInt32AscOp{}
			case -1:
			default:
				return &sortInt64AscOp{}
			}
		case types.FloatFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortFloat64AscOp{}
			}
		case types.TimestampTZFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortTimestampAscOp{}
			}
		case types.IntervalFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortIntervalAscOp{}
			}
		case types.JsonFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortJSONAscOp{}
			}
		case typeconv.DatumVecCanonicalTypeFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortDatumAscOp{}
			}
		}
	case execinfrapb.Ordering_Column_DESC:
		switch typeconv.TypeFamilyToCanonicalTypeFamily(t.Family()) {
		case types.BoolFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortBoolDescOp{}
			}
		case types.BytesFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortBytesDescOp{}
			}
		case types.DecimalFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortDecimalDescOp{}
			}
		case types.IntFamily:
			switch t.Width() {
			case 16:
				return &sortInt16DescOp{}
			case 32:
				return &sortInt32DescOp{}
			case -1:
			default:
				return &sortInt64DescOp{}
			}
		case types.FloatFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortFloat64DescOp{}
			}
		case types.TimestampTZFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortTimestampDescOp{}
			}
		case types.IntervalFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortIntervalDescOp{}
			}
		case types.JsonFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortJSONDescOp{}
			}
		case typeconv.DatumVecCanonicalTypeFamily:
			switch t.Width() {
			case -1:
			default:
				return &sortDatumDescOp{}
			}
		}
	}
	colexecerror.InternalError(errors.AssertionFailedf("unsupported type %s", t))
	// This code is unreachable, but the compiler cannot infer that.
	return nil
}

type sortBoolAscWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Bools
	order         []int
}

func (s *sortBoolAscWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Bool()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortBoolAscWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortBoolAscWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortBoolAscWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortBoolAscWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If ascending, nulls always sort first, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return true
	} else if n2 {
		return false
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		if !arg1 && arg2 {
			cmpResult = -1
		} else if arg1 && !arg2 {
			cmpResult = 1
		} else {
			cmpResult = 0
		}

		lt = cmpResult < 0
	}

	return lt
}

func (s *sortBoolAscWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortBoolAscWithNullsOp) Len() int {
	return len(s.order)
}

type sortBytesAscWithNullsOp struct {
	allocator          *colmem.Allocator
	abbreviatedSortCol []uint64
	nulls              *coldata.Nulls
	cancelChecker      colexecutils.CancelChecker
	sortCol            *coldata.Bytes
	order              []int
}

func (s *sortBytesAscWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Bytes()
	s.allocator = allocator
	s.allocator.AdjustMemoryUsage(memsize.Uint64 * int64(s.sortCol.Len()))
	s.abbreviatedSortCol = s.sortCol.Abbreviated()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortBytesAscWithNullsOp) reset() {
	s.allocator.AdjustMemoryUsage(0 - memsize.Uint64*int64(s.sortCol.Len()))
	s.allocator = nil
	s.abbreviatedSortCol = nil
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortBytesAscWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortBytesAscWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortBytesAscWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If ascending, nulls always sort first, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return true
	} else if n2 {
		return false
	}

	// If the type can be abbreviated as a uint64, compare the abbreviated
	// values first. If they are not equal, we are done with the comparison. If
	// they are equal, we must fallback to a full comparison of the datums.
	abbr1 := s.abbreviatedSortCol[s.order[i]]
	abbr2 := s.abbreviatedSortCol[s.order[j]]
	if abbr1 != abbr2 {
		return abbr1 < abbr2
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int
		cmpResult = bytes.Compare(arg1, arg2)
		lt = cmpResult < 0
	}

	return lt
}

func (s *sortBytesAscWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortBytesAscWithNullsOp) Len() int {
	return len(s.order)
}

type sortDecimalAscWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Decimals
	order         []int
}

func (s *sortDecimalAscWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Decimal()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortDecimalAscWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortDecimalAscWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortDecimalAscWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortDecimalAscWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If ascending, nulls always sort first, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return true
	} else if n2 {
		return false
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int
		cmpResult = tree.CompareDecimals(&arg1, &arg2)
		lt = cmpResult < 0
	}

	return lt
}

func (s *sortDecimalAscWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortDecimalAscWithNullsOp) Len() int {
	return len(s.order)
}

type sortInt16AscWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Int16s
	order         []int
}

func (s *sortInt16AscWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Int16()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortInt16AscWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortInt16AscWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortInt16AscWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortInt16AscWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If ascending, nulls always sort first, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return true
	} else if n2 {
		return false
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := int64(arg1), int64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else {
				cmpResult = 0
			}
		}

		lt = cmpResult < 0
	}

	return lt
}

func (s *sortInt16AscWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt16AscWithNullsOp) Len() int {
	return len(s.order)
}

type sortInt32AscWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Int32s
	order         []int
}

func (s *sortInt32AscWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Int32()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortInt32AscWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortInt32AscWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortInt32AscWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortInt32AscWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If ascending, nulls always sort first, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return true
	} else if n2 {
		return false
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := int64(arg1), int64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else {
				cmpResult = 0
			}
		}

		lt = cmpResult < 0
	}

	return lt
}

func (s *sortInt32AscWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt32AscWithNullsOp) Len() int {
	return len(s.order)
}

type sortInt64AscWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Int64s
	order         []int
}

func (s *sortInt64AscWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Int64()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortInt64AscWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortInt64AscWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortInt64AscWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortInt64AscWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If ascending, nulls always sort first, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return true
	} else if n2 {
		return false
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := int64(arg1), int64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else {
				cmpResult = 0
			}
		}

		lt = cmpResult < 0
	}

	return lt
}

func (s *sortInt64AscWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt64AscWithNullsOp) Len() int {
	return len(s.order)
}

type sortFloat64AscWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Float64s
	order         []int
}

func (s *sortFloat64AscWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Float64()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortFloat64AscWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortFloat64AscWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortFloat64AscWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortFloat64AscWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If ascending, nulls always sort first, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return true
	} else if n2 {
		return false
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := float64(arg1), float64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else if a == b {
				cmpResult = 0
			} else if math.IsNaN(a) {
				if math.IsNaN(b) {
					cmpResult = 0
				} else {
					cmpResult = -1
				}
			} else {
				cmpResult = 1
			}
		}

		lt = cmpResult < 0
	}

	return lt
}

func (s *sortFloat64AscWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortFloat64AscWithNullsOp) Len() int {
	return len(s.order)
}

type sortTimestampAscWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Times
	order         []int
}

func (s *sortTimestampAscWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Timestamp()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortTimestampAscWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortTimestampAscWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortTimestampAscWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortTimestampAscWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If ascending, nulls always sort first, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return true
	} else if n2 {
		return false
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		if arg1.Before(arg2) {
			cmpResult = -1
		} else if arg2.Before(arg1) {
			cmpResult = 1
		} else {
			cmpResult = 0
		}
		lt = cmpResult < 0
	}

	return lt
}

func (s *sortTimestampAscWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortTimestampAscWithNullsOp) Len() int {
	return len(s.order)
}

type sortIntervalAscWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Durations
	order         []int
}

func (s *sortIntervalAscWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Interval()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortIntervalAscWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortIntervalAscWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortIntervalAscWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortIntervalAscWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If ascending, nulls always sort first, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return true
	} else if n2 {
		return false
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int
		cmpResult = arg1.Compare(arg2)
		lt = cmpResult < 0
	}

	return lt
}

func (s *sortIntervalAscWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortIntervalAscWithNullsOp) Len() int {
	return len(s.order)
}

type sortJSONAscWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       *coldata.JSONs
	order         []int
}

func (s *sortJSONAscWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.JSON()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortJSONAscWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortJSONAscWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortJSONAscWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortJSONAscWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If ascending, nulls always sort first, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return true
	} else if n2 {
		return false
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		var err error
		cmpResult, err = arg1.Compare(arg2)
		if err != nil {
			colexecerror.ExpectedError(err)
		}

		lt = cmpResult < 0
	}

	return lt
}

func (s *sortJSONAscWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortJSONAscWithNullsOp) Len() int {
	return len(s.order)
}

type sortDatumAscWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.DatumVec
	order         []int
}

func (s *sortDatumAscWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Datum()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortDatumAscWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortDatumAscWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortDatumAscWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortDatumAscWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If ascending, nulls always sort first, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return true
	} else if n2 {
		return false
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		cmpResult = coldataext.CompareDatum(arg1, s.sortCol, arg2)

		lt = cmpResult < 0
	}

	return lt
}

func (s *sortDatumAscWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortDatumAscWithNullsOp) Len() int {
	return len(s.order)
}

type sortBoolDescWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Bools
	order         []int
}

func (s *sortBoolDescWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Bool()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortBoolDescWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortBoolDescWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortBoolDescWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortBoolDescWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If descending, nulls always sort last, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return false
	} else if n2 {
		return true
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		if !arg1 && arg2 {
			cmpResult = -1
		} else if arg1 && !arg2 {
			cmpResult = 1
		} else {
			cmpResult = 0
		}

		lt = cmpResult > 0
	}

	return lt
}

func (s *sortBoolDescWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortBoolDescWithNullsOp) Len() int {
	return len(s.order)
}

type sortBytesDescWithNullsOp struct {
	allocator          *colmem.Allocator
	abbreviatedSortCol []uint64
	nulls              *coldata.Nulls
	cancelChecker      colexecutils.CancelChecker
	sortCol            *coldata.Bytes
	order              []int
}

func (s *sortBytesDescWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Bytes()
	s.allocator = allocator
	s.allocator.AdjustMemoryUsage(memsize.Uint64 * int64(s.sortCol.Len()))
	s.abbreviatedSortCol = s.sortCol.Abbreviated()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortBytesDescWithNullsOp) reset() {
	s.allocator.AdjustMemoryUsage(0 - memsize.Uint64*int64(s.sortCol.Len()))
	s.allocator = nil
	s.abbreviatedSortCol = nil
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortBytesDescWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortBytesDescWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortBytesDescWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If descending, nulls always sort last, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return false
	} else if n2 {
		return true
	}

	// If the type can be abbreviated as a uint64, compare the abbreviated
	// values first. If they are not equal, we are done with the comparison. If
	// they are equal, we must fallback to a full comparison of the datums.
	abbr1 := s.abbreviatedSortCol[s.order[i]]
	abbr2 := s.abbreviatedSortCol[s.order[j]]
	if abbr1 != abbr2 {
		return abbr1 > abbr2
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int
		cmpResult = bytes.Compare(arg1, arg2)
		lt = cmpResult > 0
	}

	return lt
}

func (s *sortBytesDescWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortBytesDescWithNullsOp) Len() int {
	return len(s.order)
}

type sortDecimalDescWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Decimals
	order         []int
}

func (s *sortDecimalDescWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Decimal()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortDecimalDescWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortDecimalDescWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortDecimalDescWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortDecimalDescWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If descending, nulls always sort last, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return false
	} else if n2 {
		return true
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int
		cmpResult = tree.CompareDecimals(&arg1, &arg2)
		lt = cmpResult > 0
	}

	return lt
}

func (s *sortDecimalDescWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortDecimalDescWithNullsOp) Len() int {
	return len(s.order)
}

type sortInt16DescWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Int16s
	order         []int
}

func (s *sortInt16DescWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Int16()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortInt16DescWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortInt16DescWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortInt16DescWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortInt16DescWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If descending, nulls always sort last, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return false
	} else if n2 {
		return true
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := int64(arg1), int64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else {
				cmpResult = 0
			}
		}

		lt = cmpResult > 0
	}

	return lt
}

func (s *sortInt16DescWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt16DescWithNullsOp) Len() int {
	return len(s.order)
}

type sortInt32DescWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Int32s
	order         []int
}

func (s *sortInt32DescWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Int32()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortInt32DescWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortInt32DescWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortInt32DescWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortInt32DescWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If descending, nulls always sort last, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return false
	} else if n2 {
		return true
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := int64(arg1), int64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else {
				cmpResult = 0
			}
		}

		lt = cmpResult > 0
	}

	return lt
}

func (s *sortInt32DescWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt32DescWithNullsOp) Len() int {
	return len(s.order)
}

type sortInt64DescWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Int64s
	order         []int
}

func (s *sortInt64DescWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Int64()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortInt64DescWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortInt64DescWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortInt64DescWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortInt64DescWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If descending, nulls always sort last, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return false
	} else if n2 {
		return true
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := int64(arg1), int64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else {
				cmpResult = 0
			}
		}

		lt = cmpResult > 0
	}

	return lt
}

func (s *sortInt64DescWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt64DescWithNullsOp) Len() int {
	return len(s.order)
}

type sortFloat64DescWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Float64s
	order         []int
}

func (s *sortFloat64DescWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Float64()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortFloat64DescWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortFloat64DescWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortFloat64DescWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortFloat64DescWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If descending, nulls always sort last, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return false
	} else if n2 {
		return true
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := float64(arg1), float64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else if a == b {
				cmpResult = 0
			} else if math.IsNaN(a) {
				if math.IsNaN(b) {
					cmpResult = 0
				} else {
					cmpResult = -1
				}
			} else {
				cmpResult = 1
			}
		}

		lt = cmpResult > 0
	}

	return lt
}

func (s *sortFloat64DescWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortFloat64DescWithNullsOp) Len() int {
	return len(s.order)
}

type sortTimestampDescWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Times
	order         []int
}

func (s *sortTimestampDescWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Timestamp()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortTimestampDescWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortTimestampDescWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortTimestampDescWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortTimestampDescWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If descending, nulls always sort last, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return false
	} else if n2 {
		return true
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		if arg1.Before(arg2) {
			cmpResult = -1
		} else if arg2.Before(arg1) {
			cmpResult = 1
		} else {
			cmpResult = 0
		}
		lt = cmpResult > 0
	}

	return lt
}

func (s *sortTimestampDescWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortTimestampDescWithNullsOp) Len() int {
	return len(s.order)
}

type sortIntervalDescWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Durations
	order         []int
}

func (s *sortIntervalDescWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Interval()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortIntervalDescWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortIntervalDescWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortIntervalDescWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortIntervalDescWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If descending, nulls always sort last, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return false
	} else if n2 {
		return true
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int
		cmpResult = arg1.Compare(arg2)
		lt = cmpResult > 0
	}

	return lt
}

func (s *sortIntervalDescWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortIntervalDescWithNullsOp) Len() int {
	return len(s.order)
}

type sortJSONDescWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       *coldata.JSONs
	order         []int
}

func (s *sortJSONDescWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.JSON()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortJSONDescWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortJSONDescWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortJSONDescWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortJSONDescWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If descending, nulls always sort last, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return false
	} else if n2 {
		return true
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		var err error
		cmpResult, err = arg1.Compare(arg2)
		if err != nil {
			colexecerror.ExpectedError(err)
		}

		lt = cmpResult > 0
	}

	return lt
}

func (s *sortJSONDescWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortJSONDescWithNullsOp) Len() int {
	return len(s.order)
}

type sortDatumDescWithNullsOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.DatumVec
	order         []int
}

func (s *sortDatumDescWithNullsOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Datum()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortDatumDescWithNullsOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortDatumDescWithNullsOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortDatumDescWithNullsOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortDatumDescWithNullsOp) Less(i, j int) bool {
	n1 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[i])
	n2 := s.nulls.MaybeHasNulls() && s.nulls.NullAt(s.order[j])
	// If descending, nulls always sort last, so we encode that logic here.
	if n1 && n2 {
		return false
	} else if n1 {
		return false
	} else if n2 {
		return true
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		cmpResult = coldataext.CompareDatum(arg1, s.sortCol, arg2)

		lt = cmpResult > 0
	}

	return lt
}

func (s *sortDatumDescWithNullsOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortDatumDescWithNullsOp) Len() int {
	return len(s.order)
}

type sortBoolAscOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Bools
	order         []int
}

func (s *sortBoolAscOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Bool()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortBoolAscOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortBoolAscOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortBoolAscOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortBoolAscOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		if !arg1 && arg2 {
			cmpResult = -1
		} else if arg1 && !arg2 {
			cmpResult = 1
		} else {
			cmpResult = 0
		}

		lt = cmpResult < 0
	}

	return lt
}

func (s *sortBoolAscOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortBoolAscOp) Len() int {
	return len(s.order)
}

type sortBytesAscOp struct {
	allocator          *colmem.Allocator
	abbreviatedSortCol []uint64
	nulls              *coldata.Nulls
	cancelChecker      colexecutils.CancelChecker
	sortCol            *coldata.Bytes
	order              []int
}

func (s *sortBytesAscOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Bytes()
	s.allocator = allocator
	s.allocator.AdjustMemoryUsage(memsize.Uint64 * int64(s.sortCol.Len()))
	s.abbreviatedSortCol = s.sortCol.Abbreviated()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortBytesAscOp) reset() {
	s.allocator.AdjustMemoryUsage(0 - memsize.Uint64*int64(s.sortCol.Len()))
	s.allocator = nil
	s.abbreviatedSortCol = nil
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortBytesAscOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortBytesAscOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortBytesAscOp) Less(i, j int) bool {

	// If the type can be abbreviated as a uint64, compare the abbreviated
	// values first. If they are not equal, we are done with the comparison. If
	// they are equal, we must fallback to a full comparison of the datums.
	abbr1 := s.abbreviatedSortCol[s.order[i]]
	abbr2 := s.abbreviatedSortCol[s.order[j]]
	if abbr1 != abbr2 {
		return abbr1 < abbr2
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int
		cmpResult = bytes.Compare(arg1, arg2)
		lt = cmpResult < 0
	}

	return lt
}

func (s *sortBytesAscOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortBytesAscOp) Len() int {
	return len(s.order)
}

type sortDecimalAscOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Decimals
	order         []int
}

func (s *sortDecimalAscOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Decimal()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortDecimalAscOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortDecimalAscOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortDecimalAscOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortDecimalAscOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int
		cmpResult = tree.CompareDecimals(&arg1, &arg2)
		lt = cmpResult < 0
	}

	return lt
}

func (s *sortDecimalAscOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortDecimalAscOp) Len() int {
	return len(s.order)
}

type sortInt16AscOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Int16s
	order         []int
}

func (s *sortInt16AscOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Int16()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortInt16AscOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortInt16AscOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortInt16AscOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

// gcassert:inline
func (s *sortInt16AscOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := int64(arg1), int64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else {
				cmpResult = 0
			}
		}

		lt = cmpResult < 0
	}

	return lt
}

func (s *sortInt16AscOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt16AscOp) Len() int {
	return len(s.order)
}

type sortInt32AscOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Int32s
	order         []int
}

func (s *sortInt32AscOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Int32()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortInt32AscOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortInt32AscOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortInt32AscOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

// gcassert:inline
func (s *sortInt32AscOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := int64(arg1), int64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else {
				cmpResult = 0
			}
		}

		lt = cmpResult < 0
	}

	return lt
}

func (s *sortInt32AscOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt32AscOp) Len() int {
	return len(s.order)
}

type sortInt64AscOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Int64s
	order         []int
}

func (s *sortInt64AscOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Int64()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortInt64AscOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortInt64AscOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortInt64AscOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

// gcassert:inline
func (s *sortInt64AscOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := int64(arg1), int64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else {
				cmpResult = 0
			}
		}

		lt = cmpResult < 0
	}

	return lt
}

func (s *sortInt64AscOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt64AscOp) Len() int {
	return len(s.order)
}

type sortFloat64AscOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Float64s
	order         []int
}

func (s *sortFloat64AscOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Float64()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortFloat64AscOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortFloat64AscOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortFloat64AscOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortFloat64AscOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := float64(arg1), float64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else if a == b {
				cmpResult = 0
			} else if math.IsNaN(a) {
				if math.IsNaN(b) {
					cmpResult = 0
				} else {
					cmpResult = -1
				}
			} else {
				cmpResult = 1
			}
		}

		lt = cmpResult < 0
	}

	return lt
}

func (s *sortFloat64AscOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortFloat64AscOp) Len() int {
	return len(s.order)
}

type sortTimestampAscOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Times
	order         []int
}

func (s *sortTimestampAscOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Timestamp()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortTimestampAscOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortTimestampAscOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortTimestampAscOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortTimestampAscOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		if arg1.Before(arg2) {
			cmpResult = -1
		} else if arg2.Before(arg1) {
			cmpResult = 1
		} else {
			cmpResult = 0
		}
		lt = cmpResult < 0
	}

	return lt
}

func (s *sortTimestampAscOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortTimestampAscOp) Len() int {
	return len(s.order)
}

type sortIntervalAscOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Durations
	order         []int
}

func (s *sortIntervalAscOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Interval()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortIntervalAscOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortIntervalAscOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortIntervalAscOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortIntervalAscOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int
		cmpResult = arg1.Compare(arg2)
		lt = cmpResult < 0
	}

	return lt
}

func (s *sortIntervalAscOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortIntervalAscOp) Len() int {
	return len(s.order)
}

type sortJSONAscOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       *coldata.JSONs
	order         []int
}

func (s *sortJSONAscOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.JSON()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortJSONAscOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortJSONAscOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortJSONAscOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortJSONAscOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		var err error
		cmpResult, err = arg1.Compare(arg2)
		if err != nil {
			colexecerror.ExpectedError(err)
		}

		lt = cmpResult < 0
	}

	return lt
}

func (s *sortJSONAscOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortJSONAscOp) Len() int {
	return len(s.order)
}

type sortDatumAscOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.DatumVec
	order         []int
}

func (s *sortDatumAscOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Datum()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortDatumAscOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortDatumAscOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortDatumAscOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortDatumAscOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		cmpResult = coldataext.CompareDatum(arg1, s.sortCol, arg2)

		lt = cmpResult < 0
	}

	return lt
}

func (s *sortDatumAscOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortDatumAscOp) Len() int {
	return len(s.order)
}

type sortBoolDescOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Bools
	order         []int
}

func (s *sortBoolDescOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Bool()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortBoolDescOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortBoolDescOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortBoolDescOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortBoolDescOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		if !arg1 && arg2 {
			cmpResult = -1
		} else if arg1 && !arg2 {
			cmpResult = 1
		} else {
			cmpResult = 0
		}

		lt = cmpResult > 0
	}

	return lt
}

func (s *sortBoolDescOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortBoolDescOp) Len() int {
	return len(s.order)
}

type sortBytesDescOp struct {
	allocator          *colmem.Allocator
	abbreviatedSortCol []uint64
	nulls              *coldata.Nulls
	cancelChecker      colexecutils.CancelChecker
	sortCol            *coldata.Bytes
	order              []int
}

func (s *sortBytesDescOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Bytes()
	s.allocator = allocator
	s.allocator.AdjustMemoryUsage(memsize.Uint64 * int64(s.sortCol.Len()))
	s.abbreviatedSortCol = s.sortCol.Abbreviated()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortBytesDescOp) reset() {
	s.allocator.AdjustMemoryUsage(0 - memsize.Uint64*int64(s.sortCol.Len()))
	s.allocator = nil
	s.abbreviatedSortCol = nil
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortBytesDescOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortBytesDescOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortBytesDescOp) Less(i, j int) bool {

	// If the type can be abbreviated as a uint64, compare the abbreviated
	// values first. If they are not equal, we are done with the comparison. If
	// they are equal, we must fallback to a full comparison of the datums.
	abbr1 := s.abbreviatedSortCol[s.order[i]]
	abbr2 := s.abbreviatedSortCol[s.order[j]]
	if abbr1 != abbr2 {
		return abbr1 > abbr2
	}

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int
		cmpResult = bytes.Compare(arg1, arg2)
		lt = cmpResult > 0
	}

	return lt
}

func (s *sortBytesDescOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortBytesDescOp) Len() int {
	return len(s.order)
}

type sortDecimalDescOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Decimals
	order         []int
}

func (s *sortDecimalDescOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Decimal()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortDecimalDescOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortDecimalDescOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortDecimalDescOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortDecimalDescOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int
		cmpResult = tree.CompareDecimals(&arg1, &arg2)
		lt = cmpResult > 0
	}

	return lt
}

func (s *sortDecimalDescOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortDecimalDescOp) Len() int {
	return len(s.order)
}

type sortInt16DescOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Int16s
	order         []int
}

func (s *sortInt16DescOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Int16()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortInt16DescOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortInt16DescOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortInt16DescOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

// gcassert:inline
func (s *sortInt16DescOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := int64(arg1), int64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else {
				cmpResult = 0
			}
		}

		lt = cmpResult > 0
	}

	return lt
}

func (s *sortInt16DescOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt16DescOp) Len() int {
	return len(s.order)
}

type sortInt32DescOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Int32s
	order         []int
}

func (s *sortInt32DescOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Int32()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortInt32DescOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortInt32DescOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortInt32DescOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

// gcassert:inline
func (s *sortInt32DescOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := int64(arg1), int64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else {
				cmpResult = 0
			}
		}

		lt = cmpResult > 0
	}

	return lt
}

func (s *sortInt32DescOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt32DescOp) Len() int {
	return len(s.order)
}

type sortInt64DescOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Int64s
	order         []int
}

func (s *sortInt64DescOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Int64()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortInt64DescOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortInt64DescOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortInt64DescOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

// gcassert:inline
func (s *sortInt64DescOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := int64(arg1), int64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else {
				cmpResult = 0
			}
		}

		lt = cmpResult > 0
	}

	return lt
}

func (s *sortInt64DescOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt64DescOp) Len() int {
	return len(s.order)
}

type sortFloat64DescOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Float64s
	order         []int
}

func (s *sortFloat64DescOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Float64()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortFloat64DescOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortFloat64DescOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortFloat64DescOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortFloat64DescOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		{
			a, b := float64(arg1), float64(arg2)
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else if a == b {
				cmpResult = 0
			} else if math.IsNaN(a) {
				if math.IsNaN(b) {
					cmpResult = 0
				} else {
					cmpResult = -1
				}
			} else {
				cmpResult = 1
			}
		}

		lt = cmpResult > 0
	}

	return lt
}

func (s *sortFloat64DescOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortFloat64DescOp) Len() int {
	return len(s.order)
}

type sortTimestampDescOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Times
	order         []int
}

func (s *sortTimestampDescOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Timestamp()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortTimestampDescOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortTimestampDescOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortTimestampDescOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortTimestampDescOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		if arg1.Before(arg2) {
			cmpResult = -1
		} else if arg2.Before(arg1) {
			cmpResult = 1
		} else {
			cmpResult = 0
		}
		lt = cmpResult > 0
	}

	return lt
}

func (s *sortTimestampDescOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortTimestampDescOp) Len() int {
	return len(s.order)
}

type sortIntervalDescOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.Durations
	order         []int
}

func (s *sortIntervalDescOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Interval()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortIntervalDescOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortIntervalDescOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortIntervalDescOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortIntervalDescOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int
		cmpResult = arg1.Compare(arg2)
		lt = cmpResult > 0
	}

	return lt
}

func (s *sortIntervalDescOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortIntervalDescOp) Len() int {
	return len(s.order)
}

type sortJSONDescOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       *coldata.JSONs
	order         []int
}

func (s *sortJSONDescOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.JSON()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortJSONDescOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortJSONDescOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortJSONDescOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortJSONDescOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		var err error
		cmpResult, err = arg1.Compare(arg2)
		if err != nil {
			colexecerror.ExpectedError(err)
		}

		lt = cmpResult > 0
	}

	return lt
}

func (s *sortJSONDescOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortJSONDescOp) Len() int {
	return len(s.order)
}

type sortDatumDescOp struct {
	nulls         *coldata.Nulls
	cancelChecker colexecutils.CancelChecker
	sortCol       coldata.DatumVec
	order         []int
}

func (s *sortDatumDescOp) init(
	ctx context.Context, allocator *colmem.Allocator, col *coldata.Vec, order []int,
) {
	s.sortCol = col.Datum()
	s.nulls = col.Nulls()
	s.order = order
	s.cancelChecker.Init(ctx)
}

func (s *sortDatumDescOp) reset() {
	s.sortCol = nil
	s.nulls = nil
	s.order = nil
}

func (s *sortDatumDescOp) sort() {
	n := s.sortCol.Len()
	s.pdqsort(0, n, bits.Len(uint(n)))
}

func (s *sortDatumDescOp) sortPartitions(partitions []int) {
	order := s.order
	for i, partitionStart := range partitions {
		var partitionEnd int
		if i == len(partitions)-1 {
			partitionEnd = len(order)
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		n := partitionEnd - partitionStart
		s.pdqsort(0, n, bits.Len(uint(n)))
	}
}

func (s *sortDatumDescOp) Less(i, j int) bool {

	var lt bool
	// We always indirect via the order vector.
	arg1 := s.sortCol.Get(s.order[i])
	arg2 := s.sortCol.Get(s.order[j])

	{
		var cmpResult int

		cmpResult = coldataext.CompareDatum(arg1, s.sortCol, arg2)

		lt = cmpResult > 0
	}

	return lt
}

func (s *sortDatumDescOp) Swap(i, j int) {
	// We don't physically swap the column - we merely edit the order vector.
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortDatumDescOp) Len() int {
	return len(s.order)
}
