// Code generated by execgen; DO NOT EDIT.
// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexec

import (
	"bytes"
	"context"
	"math"
	"time"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexecutils"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecop"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/eval"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/cockroach/pkg/util/json"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ apd.Context
	_ duration.Duration
	_ = coldataext.CompareDatum
	_ json.JSON
)

// Remove unused warnings.
var (
	_ = colexecerror.InternalError
)

// Enum used to represent comparison results.
type comparisonResult int

const (
	siTrue comparisonResult = iota
	siFalse
	siNull
)

func GetInProjectionOperator(
	ctx context.Context,
	evalCtx *eval.Context,
	allocator *colmem.Allocator,
	t *types.T,
	input colexecop.Operator,
	colIdx int,
	resultIdx int,
	datumTuple *tree.DTuple,
	negate bool,
) (colexecop.Operator, error) {
	input = colexecutils.NewVectorTypeEnforcer(allocator, input, types.Bool, resultIdx)
	switch typeconv.TypeFamilyToCanonicalTypeFamily(t.Family()) {
	case types.BoolFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &projectInOpBool{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				allocator:      allocator,
				colIdx:         colIdx,
				outputIdx:      resultIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowBool(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case types.BytesFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &projectInOpBytes{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				allocator:      allocator,
				colIdx:         colIdx,
				outputIdx:      resultIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowBytes(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case types.DecimalFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &projectInOpDecimal{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				allocator:      allocator,
				colIdx:         colIdx,
				outputIdx:      resultIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowDecimal(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case types.IntFamily:
		switch t.Width() {
		case 16:
			obj := &projectInOpInt16{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				allocator:      allocator,
				colIdx:         colIdx,
				outputIdx:      resultIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowInt16(ctx, evalCtx, t, datumTuple)
			return obj, nil
		case 32:
			obj := &projectInOpInt32{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				allocator:      allocator,
				colIdx:         colIdx,
				outputIdx:      resultIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowInt32(ctx, evalCtx, t, datumTuple)
			return obj, nil
		case -1:
		default:
			obj := &projectInOpInt64{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				allocator:      allocator,
				colIdx:         colIdx,
				outputIdx:      resultIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowInt64(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case types.FloatFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &projectInOpFloat64{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				allocator:      allocator,
				colIdx:         colIdx,
				outputIdx:      resultIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowFloat64(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case types.TimestampTZFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &projectInOpTimestamp{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				allocator:      allocator,
				colIdx:         colIdx,
				outputIdx:      resultIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowTimestamp(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case types.IntervalFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &projectInOpInterval{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				allocator:      allocator,
				colIdx:         colIdx,
				outputIdx:      resultIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowInterval(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case types.JsonFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &projectInOpJSON{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				allocator:      allocator,
				colIdx:         colIdx,
				outputIdx:      resultIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowJSON(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &projectInOpDatum{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				allocator:      allocator,
				colIdx:         colIdx,
				outputIdx:      resultIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowDatum(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	}
	return nil, errors.AssertionFailedf("unhandled type: %s", t.Name())
}

func GetInOperator(
	ctx context.Context,
	evalCtx *eval.Context,
	t *types.T,
	input colexecop.Operator,
	colIdx int,
	datumTuple *tree.DTuple,
	negate bool,
) (colexecop.Operator, error) {
	switch typeconv.TypeFamilyToCanonicalTypeFamily(t.Family()) {
	case types.BoolFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &selectInOpBool{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				colIdx:         colIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowBool(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case types.BytesFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &selectInOpBytes{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				colIdx:         colIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowBytes(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case types.DecimalFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &selectInOpDecimal{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				colIdx:         colIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowDecimal(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case types.IntFamily:
		switch t.Width() {
		case 16:
			obj := &selectInOpInt16{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				colIdx:         colIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowInt16(ctx, evalCtx, t, datumTuple)
			return obj, nil
		case 32:
			obj := &selectInOpInt32{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				colIdx:         colIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowInt32(ctx, evalCtx, t, datumTuple)
			return obj, nil
		case -1:
		default:
			obj := &selectInOpInt64{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				colIdx:         colIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowInt64(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case types.FloatFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &selectInOpFloat64{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				colIdx:         colIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowFloat64(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case types.TimestampTZFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &selectInOpTimestamp{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				colIdx:         colIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowTimestamp(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case types.IntervalFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &selectInOpInterval{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				colIdx:         colIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowInterval(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case types.JsonFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &selectInOpJSON{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				colIdx:         colIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowJSON(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch t.Width() {
		case -1:
		default:
			obj := &selectInOpDatum{
				OneInputHelper: colexecop.MakeOneInputHelper(input),
				colIdx:         colIdx,
				negate:         negate,
			}
			obj.filterRow, obj.hasNulls = fillDatumRowDatum(ctx, evalCtx, t, datumTuple)
			return obj, nil
		}
	}
	return nil, errors.AssertionFailedf("unhandled type: %s", t.Name())
}

type selectInOpBool struct {
	colexecop.OneInputHelper
	filterRow []bool
	colIdx    int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &selectInOpBool{}

type projectInOpBool struct {
	colexecop.OneInputHelper
	allocator *colmem.Allocator
	filterRow []bool
	colIdx    int
	outputIdx int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &projectInOpBool{}

func fillDatumRowBool(
	ctx context.Context, evalCtx *eval.Context, t *types.T, datumTuple *tree.DTuple,
) ([]bool, bool) {
	// Sort the contents of the tuple, if they are not already sorted.
	datumTuple.Normalize(ctx, evalCtx)

	conv := colconv.GetDatumToPhysicalFn(t)
	var result []bool
	hasNulls := false
	for _, d := range datumTuple.D {
		if d == tree.DNull {
			hasNulls = true
		} else {
			convRaw := conv(d)
			converted := convRaw.(bool)
			result = append(result, converted)
		}
	}
	return result, hasNulls
}

func cmpInBool(
	targetElem bool, targetCol coldata.Bools, filterRow []bool, hasNulls bool,
) comparisonResult {
	// Filter row input was already sorted in fillDatumRowBool, so we can
	// perform a binary search.
	lo := 0
	hi := len(filterRow)
	for lo < hi {
		i := (lo + hi) / 2
		var cmpResult int

		if !targetElem && filterRow[i] {
			cmpResult = -1
		} else if targetElem && !filterRow[i] {
			cmpResult = 1
		} else {
			cmpResult = 0
		}

		if cmpResult == 0 {
			return siTrue
		} else if cmpResult > 0 {
			lo = i + 1
		} else {
			hi = i
		}
	}

	if hasNulls {
		return siNull
	} else {
		return siFalse
	}
}

func (si *selectInOpBool) Next() coldata.Batch {
	for {
		batch := si.Input.Next()
		if batch.Length() == 0 {
			return coldata.ZeroBatch
		}

		vec := batch.ColVec(si.colIdx)
		col := vec.Bool()
		var idx int
		n := batch.Length()

		compVal := siTrue
		if si.negate {
			compVal = siFalse
		}

		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInBool(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInBool(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if cmpInBool(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if cmpInBool(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		}

		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (pi *projectInOpBool) Next() coldata.Batch {
	batch := pi.Input.Next()
	if batch.Length() == 0 {
		return coldata.ZeroBatch
	}

	vec := batch.ColVec(pi.colIdx)
	col := vec.Bool()

	projVec := batch.ColVec(pi.outputIdx)
	projCol := projVec.Bool()
	projNulls := projVec.Nulls()

	n := batch.Length()

	cmpVal := siTrue
	if pi.negate {
		cmpVal = siFalse
	}

	if vec.MaybeHasNulls() {
		nulls := vec.Nulls()
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					v := col.Get(i)
					cmpRes := cmpInBool(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					//gcassert:bce
					v := col.Get(i)
					cmpRes := cmpInBool(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		}
	} else {
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				v := col.Get(i)
				cmpRes := cmpInBool(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				//gcassert:bce
				v := col.Get(i)
				cmpRes := cmpInBool(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		}
	}
	return batch
}

type selectInOpBytes struct {
	colexecop.OneInputHelper
	filterRow [][]byte
	colIdx    int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &selectInOpBytes{}

type projectInOpBytes struct {
	colexecop.OneInputHelper
	allocator *colmem.Allocator
	filterRow [][]byte
	colIdx    int
	outputIdx int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &projectInOpBytes{}

func fillDatumRowBytes(
	ctx context.Context, evalCtx *eval.Context, t *types.T, datumTuple *tree.DTuple,
) ([][]byte, bool) {
	// Sort the contents of the tuple, if they are not already sorted.
	datumTuple.Normalize(ctx, evalCtx)

	conv := colconv.GetDatumToPhysicalFn(t)
	var result [][]byte
	hasNulls := false
	for _, d := range datumTuple.D {
		if d == tree.DNull {
			hasNulls = true
		} else {
			convRaw := conv(d)
			converted := convRaw.([]byte)
			result = append(result, converted)
		}
	}
	return result, hasNulls
}

func cmpInBytes(
	targetElem []byte, targetCol *coldata.Bytes, filterRow [][]byte, hasNulls bool,
) comparisonResult {
	// Filter row input was already sorted in fillDatumRowBytes, so we can
	// perform a binary search.
	lo := 0
	hi := len(filterRow)
	for lo < hi {
		i := (lo + hi) / 2
		var cmpResult int
		cmpResult = bytes.Compare(targetElem, filterRow[i])
		if cmpResult == 0 {
			return siTrue
		} else if cmpResult > 0 {
			lo = i + 1
		} else {
			hi = i
		}
	}

	if hasNulls {
		return siNull
	} else {
		return siFalse
	}
}

func (si *selectInOpBytes) Next() coldata.Batch {
	for {
		batch := si.Input.Next()
		if batch.Length() == 0 {
			return coldata.ZeroBatch
		}

		vec := batch.ColVec(si.colIdx)
		col := vec.Bytes()
		var idx int
		n := batch.Length()

		compVal := siTrue
		if si.negate {
			compVal = siFalse
		}

		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInBytes(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInBytes(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if cmpInBytes(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					v := col.Get(i)
					if cmpInBytes(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		}

		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (pi *projectInOpBytes) Next() coldata.Batch {
	batch := pi.Input.Next()
	if batch.Length() == 0 {
		return coldata.ZeroBatch
	}

	vec := batch.ColVec(pi.colIdx)
	col := vec.Bytes()

	projVec := batch.ColVec(pi.outputIdx)
	projCol := projVec.Bool()
	projNulls := projVec.Nulls()

	n := batch.Length()

	cmpVal := siTrue
	if pi.negate {
		cmpVal = siFalse
	}

	if vec.MaybeHasNulls() {
		nulls := vec.Nulls()
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					v := col.Get(i)
					cmpRes := cmpInBytes(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					v := col.Get(i)
					cmpRes := cmpInBytes(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		}
	} else {
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				v := col.Get(i)
				cmpRes := cmpInBytes(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				v := col.Get(i)
				cmpRes := cmpInBytes(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		}
	}
	return batch
}

type selectInOpDecimal struct {
	colexecop.OneInputHelper
	filterRow []apd.Decimal
	colIdx    int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &selectInOpDecimal{}

type projectInOpDecimal struct {
	colexecop.OneInputHelper
	allocator *colmem.Allocator
	filterRow []apd.Decimal
	colIdx    int
	outputIdx int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &projectInOpDecimal{}

func fillDatumRowDecimal(
	ctx context.Context, evalCtx *eval.Context, t *types.T, datumTuple *tree.DTuple,
) ([]apd.Decimal, bool) {
	// Sort the contents of the tuple, if they are not already sorted.
	datumTuple.Normalize(ctx, evalCtx)

	conv := colconv.GetDatumToPhysicalFn(t)
	var result []apd.Decimal
	hasNulls := false
	for _, d := range datumTuple.D {
		if d == tree.DNull {
			hasNulls = true
		} else {
			convRaw := conv(d)
			converted := convRaw.(apd.Decimal)
			result = append(result, converted)
		}
	}
	return result, hasNulls
}

func cmpInDecimal(
	targetElem apd.Decimal, targetCol coldata.Decimals, filterRow []apd.Decimal, hasNulls bool,
) comparisonResult {
	// Filter row input was already sorted in fillDatumRowDecimal, so we can
	// perform a binary search.
	lo := 0
	hi := len(filterRow)
	for lo < hi {
		i := (lo + hi) / 2
		var cmpResult int
		cmpResult = tree.CompareDecimals(&targetElem, &filterRow[i])
		if cmpResult == 0 {
			return siTrue
		} else if cmpResult > 0 {
			lo = i + 1
		} else {
			hi = i
		}
	}

	if hasNulls {
		return siNull
	} else {
		return siFalse
	}
}

func (si *selectInOpDecimal) Next() coldata.Batch {
	for {
		batch := si.Input.Next()
		if batch.Length() == 0 {
			return coldata.ZeroBatch
		}

		vec := batch.ColVec(si.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()

		compVal := siTrue
		if si.negate {
			compVal = siFalse
		}

		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInDecimal(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInDecimal(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if cmpInDecimal(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if cmpInDecimal(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		}

		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (pi *projectInOpDecimal) Next() coldata.Batch {
	batch := pi.Input.Next()
	if batch.Length() == 0 {
		return coldata.ZeroBatch
	}

	vec := batch.ColVec(pi.colIdx)
	col := vec.Decimal()

	projVec := batch.ColVec(pi.outputIdx)
	projCol := projVec.Bool()
	projNulls := projVec.Nulls()

	n := batch.Length()

	cmpVal := siTrue
	if pi.negate {
		cmpVal = siFalse
	}

	if vec.MaybeHasNulls() {
		nulls := vec.Nulls()
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					v := col.Get(i)
					cmpRes := cmpInDecimal(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					//gcassert:bce
					v := col.Get(i)
					cmpRes := cmpInDecimal(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		}
	} else {
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				v := col.Get(i)
				cmpRes := cmpInDecimal(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				//gcassert:bce
				v := col.Get(i)
				cmpRes := cmpInDecimal(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		}
	}
	return batch
}

type selectInOpInt16 struct {
	colexecop.OneInputHelper
	filterRow []int64
	colIdx    int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &selectInOpInt16{}

type projectInOpInt16 struct {
	colexecop.OneInputHelper
	allocator *colmem.Allocator
	filterRow []int64
	colIdx    int
	outputIdx int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &projectInOpInt16{}

func fillDatumRowInt16(
	ctx context.Context, evalCtx *eval.Context, t *types.T, datumTuple *tree.DTuple,
) ([]int64, bool) {
	// Sort the contents of the tuple, if they are not already sorted.
	datumTuple.Normalize(ctx, evalCtx)

	// Ensure that we always upcast all integer types.
	conv := colconv.GetDatumToPhysicalFn(types.Int)
	var result []int64
	hasNulls := false
	for _, d := range datumTuple.D {
		if d == tree.DNull {
			hasNulls = true
		} else {
			convRaw := conv(d)
			converted := convRaw.(int64)
			result = append(result, converted)
		}
	}
	return result, hasNulls
}

func cmpInInt16(
	targetElem int16, targetCol coldata.Int16s, filterRow []int64, hasNulls bool,
) comparisonResult {
	// Filter row input was already sorted in fillDatumRowInt16, so we can
	// perform a binary search.
	lo := 0
	hi := len(filterRow)
	for lo < hi {
		i := (lo + hi) / 2
		var cmpResult int

		{
			a, b := int64(targetElem), int64(filterRow[i])
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else {
				cmpResult = 0
			}
		}

		if cmpResult == 0 {
			return siTrue
		} else if cmpResult > 0 {
			lo = i + 1
		} else {
			hi = i
		}
	}

	if hasNulls {
		return siNull
	} else {
		return siFalse
	}
}

func (si *selectInOpInt16) Next() coldata.Batch {
	for {
		batch := si.Input.Next()
		if batch.Length() == 0 {
			return coldata.ZeroBatch
		}

		vec := batch.ColVec(si.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()

		compVal := siTrue
		if si.negate {
			compVal = siFalse
		}

		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInInt16(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInInt16(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if cmpInInt16(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if cmpInInt16(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		}

		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (pi *projectInOpInt16) Next() coldata.Batch {
	batch := pi.Input.Next()
	if batch.Length() == 0 {
		return coldata.ZeroBatch
	}

	vec := batch.ColVec(pi.colIdx)
	col := vec.Int16()

	projVec := batch.ColVec(pi.outputIdx)
	projCol := projVec.Bool()
	projNulls := projVec.Nulls()

	n := batch.Length()

	cmpVal := siTrue
	if pi.negate {
		cmpVal = siFalse
	}

	if vec.MaybeHasNulls() {
		nulls := vec.Nulls()
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					v := col.Get(i)
					cmpRes := cmpInInt16(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					//gcassert:bce
					v := col.Get(i)
					cmpRes := cmpInInt16(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		}
	} else {
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				v := col.Get(i)
				cmpRes := cmpInInt16(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				//gcassert:bce
				v := col.Get(i)
				cmpRes := cmpInInt16(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		}
	}
	return batch
}

type selectInOpInt32 struct {
	colexecop.OneInputHelper
	filterRow []int64
	colIdx    int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &selectInOpInt32{}

type projectInOpInt32 struct {
	colexecop.OneInputHelper
	allocator *colmem.Allocator
	filterRow []int64
	colIdx    int
	outputIdx int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &projectInOpInt32{}

func fillDatumRowInt32(
	ctx context.Context, evalCtx *eval.Context, t *types.T, datumTuple *tree.DTuple,
) ([]int64, bool) {
	// Sort the contents of the tuple, if they are not already sorted.
	datumTuple.Normalize(ctx, evalCtx)

	// Ensure that we always upcast all integer types.
	conv := colconv.GetDatumToPhysicalFn(types.Int)
	var result []int64
	hasNulls := false
	for _, d := range datumTuple.D {
		if d == tree.DNull {
			hasNulls = true
		} else {
			convRaw := conv(d)
			converted := convRaw.(int64)
			result = append(result, converted)
		}
	}
	return result, hasNulls
}

func cmpInInt32(
	targetElem int32, targetCol coldata.Int32s, filterRow []int64, hasNulls bool,
) comparisonResult {
	// Filter row input was already sorted in fillDatumRowInt32, so we can
	// perform a binary search.
	lo := 0
	hi := len(filterRow)
	for lo < hi {
		i := (lo + hi) / 2
		var cmpResult int

		{
			a, b := int64(targetElem), int64(filterRow[i])
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else {
				cmpResult = 0
			}
		}

		if cmpResult == 0 {
			return siTrue
		} else if cmpResult > 0 {
			lo = i + 1
		} else {
			hi = i
		}
	}

	if hasNulls {
		return siNull
	} else {
		return siFalse
	}
}

func (si *selectInOpInt32) Next() coldata.Batch {
	for {
		batch := si.Input.Next()
		if batch.Length() == 0 {
			return coldata.ZeroBatch
		}

		vec := batch.ColVec(si.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()

		compVal := siTrue
		if si.negate {
			compVal = siFalse
		}

		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInInt32(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInInt32(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if cmpInInt32(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if cmpInInt32(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		}

		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (pi *projectInOpInt32) Next() coldata.Batch {
	batch := pi.Input.Next()
	if batch.Length() == 0 {
		return coldata.ZeroBatch
	}

	vec := batch.ColVec(pi.colIdx)
	col := vec.Int32()

	projVec := batch.ColVec(pi.outputIdx)
	projCol := projVec.Bool()
	projNulls := projVec.Nulls()

	n := batch.Length()

	cmpVal := siTrue
	if pi.negate {
		cmpVal = siFalse
	}

	if vec.MaybeHasNulls() {
		nulls := vec.Nulls()
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					v := col.Get(i)
					cmpRes := cmpInInt32(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					//gcassert:bce
					v := col.Get(i)
					cmpRes := cmpInInt32(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		}
	} else {
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				v := col.Get(i)
				cmpRes := cmpInInt32(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				//gcassert:bce
				v := col.Get(i)
				cmpRes := cmpInInt32(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		}
	}
	return batch
}

type selectInOpInt64 struct {
	colexecop.OneInputHelper
	filterRow []int64
	colIdx    int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &selectInOpInt64{}

type projectInOpInt64 struct {
	colexecop.OneInputHelper
	allocator *colmem.Allocator
	filterRow []int64
	colIdx    int
	outputIdx int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &projectInOpInt64{}

func fillDatumRowInt64(
	ctx context.Context, evalCtx *eval.Context, t *types.T, datumTuple *tree.DTuple,
) ([]int64, bool) {
	// Sort the contents of the tuple, if they are not already sorted.
	datumTuple.Normalize(ctx, evalCtx)

	conv := colconv.GetDatumToPhysicalFn(t)
	var result []int64
	hasNulls := false
	for _, d := range datumTuple.D {
		if d == tree.DNull {
			hasNulls = true
		} else {
			convRaw := conv(d)
			converted := convRaw.(int64)
			result = append(result, converted)
		}
	}
	return result, hasNulls
}

func cmpInInt64(
	targetElem int64, targetCol coldata.Int64s, filterRow []int64, hasNulls bool,
) comparisonResult {
	// Filter row input was already sorted in fillDatumRowInt64, so we can
	// perform a binary search.
	lo := 0
	hi := len(filterRow)
	for lo < hi {
		i := (lo + hi) / 2
		var cmpResult int

		{
			a, b := int64(targetElem), int64(filterRow[i])
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else {
				cmpResult = 0
			}
		}

		if cmpResult == 0 {
			return siTrue
		} else if cmpResult > 0 {
			lo = i + 1
		} else {
			hi = i
		}
	}

	if hasNulls {
		return siNull
	} else {
		return siFalse
	}
}

func (si *selectInOpInt64) Next() coldata.Batch {
	for {
		batch := si.Input.Next()
		if batch.Length() == 0 {
			return coldata.ZeroBatch
		}

		vec := batch.ColVec(si.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()

		compVal := siTrue
		if si.negate {
			compVal = siFalse
		}

		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInInt64(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInInt64(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if cmpInInt64(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if cmpInInt64(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		}

		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (pi *projectInOpInt64) Next() coldata.Batch {
	batch := pi.Input.Next()
	if batch.Length() == 0 {
		return coldata.ZeroBatch
	}

	vec := batch.ColVec(pi.colIdx)
	col := vec.Int64()

	projVec := batch.ColVec(pi.outputIdx)
	projCol := projVec.Bool()
	projNulls := projVec.Nulls()

	n := batch.Length()

	cmpVal := siTrue
	if pi.negate {
		cmpVal = siFalse
	}

	if vec.MaybeHasNulls() {
		nulls := vec.Nulls()
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					v := col.Get(i)
					cmpRes := cmpInInt64(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					//gcassert:bce
					v := col.Get(i)
					cmpRes := cmpInInt64(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		}
	} else {
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				v := col.Get(i)
				cmpRes := cmpInInt64(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				//gcassert:bce
				v := col.Get(i)
				cmpRes := cmpInInt64(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		}
	}
	return batch
}

type selectInOpFloat64 struct {
	colexecop.OneInputHelper
	filterRow []float64
	colIdx    int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &selectInOpFloat64{}

type projectInOpFloat64 struct {
	colexecop.OneInputHelper
	allocator *colmem.Allocator
	filterRow []float64
	colIdx    int
	outputIdx int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &projectInOpFloat64{}

func fillDatumRowFloat64(
	ctx context.Context, evalCtx *eval.Context, t *types.T, datumTuple *tree.DTuple,
) ([]float64, bool) {
	// Sort the contents of the tuple, if they are not already sorted.
	datumTuple.Normalize(ctx, evalCtx)

	conv := colconv.GetDatumToPhysicalFn(t)
	var result []float64
	hasNulls := false
	for _, d := range datumTuple.D {
		if d == tree.DNull {
			hasNulls = true
		} else {
			convRaw := conv(d)
			converted := convRaw.(float64)
			result = append(result, converted)
		}
	}
	return result, hasNulls
}

func cmpInFloat64(
	targetElem float64, targetCol coldata.Float64s, filterRow []float64, hasNulls bool,
) comparisonResult {
	// Filter row input was already sorted in fillDatumRowFloat64, so we can
	// perform a binary search.
	lo := 0
	hi := len(filterRow)
	for lo < hi {
		i := (lo + hi) / 2
		var cmpResult int

		{
			a, b := float64(targetElem), float64(filterRow[i])
			if a < b {
				cmpResult = -1
			} else if a > b {
				cmpResult = 1
			} else if a == b {
				cmpResult = 0
			} else if math.IsNaN(a) {
				if math.IsNaN(b) {
					cmpResult = 0
				} else {
					cmpResult = -1
				}
			} else {
				cmpResult = 1
			}
		}

		if cmpResult == 0 {
			return siTrue
		} else if cmpResult > 0 {
			lo = i + 1
		} else {
			hi = i
		}
	}

	if hasNulls {
		return siNull
	} else {
		return siFalse
	}
}

func (si *selectInOpFloat64) Next() coldata.Batch {
	for {
		batch := si.Input.Next()
		if batch.Length() == 0 {
			return coldata.ZeroBatch
		}

		vec := batch.ColVec(si.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()

		compVal := siTrue
		if si.negate {
			compVal = siFalse
		}

		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInFloat64(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInFloat64(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if cmpInFloat64(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if cmpInFloat64(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		}

		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (pi *projectInOpFloat64) Next() coldata.Batch {
	batch := pi.Input.Next()
	if batch.Length() == 0 {
		return coldata.ZeroBatch
	}

	vec := batch.ColVec(pi.colIdx)
	col := vec.Float64()

	projVec := batch.ColVec(pi.outputIdx)
	projCol := projVec.Bool()
	projNulls := projVec.Nulls()

	n := batch.Length()

	cmpVal := siTrue
	if pi.negate {
		cmpVal = siFalse
	}

	if vec.MaybeHasNulls() {
		nulls := vec.Nulls()
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					v := col.Get(i)
					cmpRes := cmpInFloat64(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					//gcassert:bce
					v := col.Get(i)
					cmpRes := cmpInFloat64(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		}
	} else {
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				v := col.Get(i)
				cmpRes := cmpInFloat64(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				//gcassert:bce
				v := col.Get(i)
				cmpRes := cmpInFloat64(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		}
	}
	return batch
}

type selectInOpTimestamp struct {
	colexecop.OneInputHelper
	filterRow []time.Time
	colIdx    int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &selectInOpTimestamp{}

type projectInOpTimestamp struct {
	colexecop.OneInputHelper
	allocator *colmem.Allocator
	filterRow []time.Time
	colIdx    int
	outputIdx int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &projectInOpTimestamp{}

func fillDatumRowTimestamp(
	ctx context.Context, evalCtx *eval.Context, t *types.T, datumTuple *tree.DTuple,
) ([]time.Time, bool) {
	// Sort the contents of the tuple, if they are not already sorted.
	datumTuple.Normalize(ctx, evalCtx)

	conv := colconv.GetDatumToPhysicalFn(t)
	var result []time.Time
	hasNulls := false
	for _, d := range datumTuple.D {
		if d == tree.DNull {
			hasNulls = true
		} else {
			convRaw := conv(d)
			converted := convRaw.(time.Time)
			result = append(result, converted)
		}
	}
	return result, hasNulls
}

func cmpInTimestamp(
	targetElem time.Time, targetCol coldata.Times, filterRow []time.Time, hasNulls bool,
) comparisonResult {
	// Filter row input was already sorted in fillDatumRowTimestamp, so we can
	// perform a binary search.
	lo := 0
	hi := len(filterRow)
	for lo < hi {
		i := (lo + hi) / 2
		var cmpResult int

		if targetElem.Before(filterRow[i]) {
			cmpResult = -1
		} else if filterRow[i].Before(targetElem) {
			cmpResult = 1
		} else {
			cmpResult = 0
		}
		if cmpResult == 0 {
			return siTrue
		} else if cmpResult > 0 {
			lo = i + 1
		} else {
			hi = i
		}
	}

	if hasNulls {
		return siNull
	} else {
		return siFalse
	}
}

func (si *selectInOpTimestamp) Next() coldata.Batch {
	for {
		batch := si.Input.Next()
		if batch.Length() == 0 {
			return coldata.ZeroBatch
		}

		vec := batch.ColVec(si.colIdx)
		col := vec.Timestamp()
		var idx int
		n := batch.Length()

		compVal := siTrue
		if si.negate {
			compVal = siFalse
		}

		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInTimestamp(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInTimestamp(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if cmpInTimestamp(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if cmpInTimestamp(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		}

		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (pi *projectInOpTimestamp) Next() coldata.Batch {
	batch := pi.Input.Next()
	if batch.Length() == 0 {
		return coldata.ZeroBatch
	}

	vec := batch.ColVec(pi.colIdx)
	col := vec.Timestamp()

	projVec := batch.ColVec(pi.outputIdx)
	projCol := projVec.Bool()
	projNulls := projVec.Nulls()

	n := batch.Length()

	cmpVal := siTrue
	if pi.negate {
		cmpVal = siFalse
	}

	if vec.MaybeHasNulls() {
		nulls := vec.Nulls()
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					v := col.Get(i)
					cmpRes := cmpInTimestamp(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					//gcassert:bce
					v := col.Get(i)
					cmpRes := cmpInTimestamp(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		}
	} else {
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				v := col.Get(i)
				cmpRes := cmpInTimestamp(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				//gcassert:bce
				v := col.Get(i)
				cmpRes := cmpInTimestamp(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		}
	}
	return batch
}

type selectInOpInterval struct {
	colexecop.OneInputHelper
	filterRow []duration.Duration
	colIdx    int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &selectInOpInterval{}

type projectInOpInterval struct {
	colexecop.OneInputHelper
	allocator *colmem.Allocator
	filterRow []duration.Duration
	colIdx    int
	outputIdx int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &projectInOpInterval{}

func fillDatumRowInterval(
	ctx context.Context, evalCtx *eval.Context, t *types.T, datumTuple *tree.DTuple,
) ([]duration.Duration, bool) {
	// Sort the contents of the tuple, if they are not already sorted.
	datumTuple.Normalize(ctx, evalCtx)

	conv := colconv.GetDatumToPhysicalFn(t)
	var result []duration.Duration
	hasNulls := false
	for _, d := range datumTuple.D {
		if d == tree.DNull {
			hasNulls = true
		} else {
			convRaw := conv(d)
			converted := convRaw.(duration.Duration)
			result = append(result, converted)
		}
	}
	return result, hasNulls
}

func cmpInInterval(
	targetElem duration.Duration, targetCol coldata.Durations, filterRow []duration.Duration, hasNulls bool,
) comparisonResult {
	// Filter row input was already sorted in fillDatumRowInterval, so we can
	// perform a binary search.
	lo := 0
	hi := len(filterRow)
	for lo < hi {
		i := (lo + hi) / 2
		var cmpResult int
		cmpResult = targetElem.Compare(filterRow[i])
		if cmpResult == 0 {
			return siTrue
		} else if cmpResult > 0 {
			lo = i + 1
		} else {
			hi = i
		}
	}

	if hasNulls {
		return siNull
	} else {
		return siFalse
	}
}

func (si *selectInOpInterval) Next() coldata.Batch {
	for {
		batch := si.Input.Next()
		if batch.Length() == 0 {
			return coldata.ZeroBatch
		}

		vec := batch.ColVec(si.colIdx)
		col := vec.Interval()
		var idx int
		n := batch.Length()

		compVal := siTrue
		if si.negate {
			compVal = siFalse
		}

		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInInterval(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInInterval(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if cmpInInterval(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					v := col.Get(i)
					if cmpInInterval(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		}

		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (pi *projectInOpInterval) Next() coldata.Batch {
	batch := pi.Input.Next()
	if batch.Length() == 0 {
		return coldata.ZeroBatch
	}

	vec := batch.ColVec(pi.colIdx)
	col := vec.Interval()

	projVec := batch.ColVec(pi.outputIdx)
	projCol := projVec.Bool()
	projNulls := projVec.Nulls()

	n := batch.Length()

	cmpVal := siTrue
	if pi.negate {
		cmpVal = siFalse
	}

	if vec.MaybeHasNulls() {
		nulls := vec.Nulls()
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					v := col.Get(i)
					cmpRes := cmpInInterval(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					//gcassert:bce
					v := col.Get(i)
					cmpRes := cmpInInterval(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		}
	} else {
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				v := col.Get(i)
				cmpRes := cmpInInterval(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				//gcassert:bce
				v := col.Get(i)
				cmpRes := cmpInInterval(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		}
	}
	return batch
}

type selectInOpJSON struct {
	colexecop.OneInputHelper
	filterRow []json.JSON
	colIdx    int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &selectInOpJSON{}

type projectInOpJSON struct {
	colexecop.OneInputHelper
	allocator *colmem.Allocator
	filterRow []json.JSON
	colIdx    int
	outputIdx int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &projectInOpJSON{}

func fillDatumRowJSON(
	ctx context.Context, evalCtx *eval.Context, t *types.T, datumTuple *tree.DTuple,
) ([]json.JSON, bool) {
	// Sort the contents of the tuple, if they are not already sorted.
	datumTuple.Normalize(ctx, evalCtx)

	conv := colconv.GetDatumToPhysicalFn(t)
	var result []json.JSON
	hasNulls := false
	for _, d := range datumTuple.D {
		if d == tree.DNull {
			hasNulls = true
		} else {
			convRaw := conv(d)
			converted := convRaw.(json.JSON)
			result = append(result, converted)
		}
	}
	return result, hasNulls
}

func cmpInJSON(
	targetElem json.JSON, targetCol *coldata.JSONs, filterRow []json.JSON, hasNulls bool,
) comparisonResult {
	// Filter row input was already sorted in fillDatumRowJSON, so we can
	// perform a binary search.
	lo := 0
	hi := len(filterRow)
	for lo < hi {
		i := (lo + hi) / 2
		var cmpResult int

		var err error
		cmpResult, err = targetElem.Compare(filterRow[i])
		if err != nil {
			colexecerror.ExpectedError(err)
		}

		if cmpResult == 0 {
			return siTrue
		} else if cmpResult > 0 {
			lo = i + 1
		} else {
			hi = i
		}
	}

	if hasNulls {
		return siNull
	} else {
		return siFalse
	}
}

func (si *selectInOpJSON) Next() coldata.Batch {
	for {
		batch := si.Input.Next()
		if batch.Length() == 0 {
			return coldata.ZeroBatch
		}

		vec := batch.ColVec(si.colIdx)
		col := vec.JSON()
		var idx int
		n := batch.Length()

		compVal := siTrue
		if si.negate {
			compVal = siFalse
		}

		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInJSON(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInJSON(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if cmpInJSON(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					v := col.Get(i)
					if cmpInJSON(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		}

		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (pi *projectInOpJSON) Next() coldata.Batch {
	batch := pi.Input.Next()
	if batch.Length() == 0 {
		return coldata.ZeroBatch
	}

	vec := batch.ColVec(pi.colIdx)
	col := vec.JSON()

	projVec := batch.ColVec(pi.outputIdx)
	projCol := projVec.Bool()
	projNulls := projVec.Nulls()

	n := batch.Length()

	cmpVal := siTrue
	if pi.negate {
		cmpVal = siFalse
	}

	if vec.MaybeHasNulls() {
		nulls := vec.Nulls()
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					v := col.Get(i)
					cmpRes := cmpInJSON(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					v := col.Get(i)
					cmpRes := cmpInJSON(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		}
	} else {
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				v := col.Get(i)
				cmpRes := cmpInJSON(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				v := col.Get(i)
				cmpRes := cmpInJSON(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		}
	}
	return batch
}

type selectInOpDatum struct {
	colexecop.OneInputHelper
	filterRow []interface{}
	colIdx    int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &selectInOpDatum{}

type projectInOpDatum struct {
	colexecop.OneInputHelper
	allocator *colmem.Allocator
	filterRow []interface{}
	colIdx    int
	outputIdx int
	hasNulls  bool
	negate    bool
}

var _ colexecop.Operator = &projectInOpDatum{}

func fillDatumRowDatum(
	ctx context.Context, evalCtx *eval.Context, t *types.T, datumTuple *tree.DTuple,
) ([]interface{}, bool) {
	// Sort the contents of the tuple, if they are not already sorted.
	datumTuple.Normalize(ctx, evalCtx)

	conv := colconv.GetDatumToPhysicalFn(t)
	var result []interface{}
	hasNulls := false
	for _, d := range datumTuple.D {
		if d == tree.DNull {
			hasNulls = true
		} else {
			convRaw := conv(d)
			converted := convRaw.(interface{})
			result = append(result, converted)
		}
	}
	return result, hasNulls
}

func cmpInDatum(
	targetElem interface{}, targetCol coldata.DatumVec, filterRow []interface{}, hasNulls bool,
) comparisonResult {
	// Filter row input was already sorted in fillDatumRowDatum, so we can
	// perform a binary search.
	lo := 0
	hi := len(filterRow)
	for lo < hi {
		i := (lo + hi) / 2
		var cmpResult int

		cmpResult = coldataext.CompareDatum(targetElem, targetCol, filterRow[i])

		if cmpResult == 0 {
			return siTrue
		} else if cmpResult > 0 {
			lo = i + 1
		} else {
			hi = i
		}
	}

	if hasNulls {
		return siNull
	} else {
		return siFalse
	}
}

func (si *selectInOpDatum) Next() coldata.Batch {
	for {
		batch := si.Input.Next()
		if batch.Length() == 0 {
			return coldata.ZeroBatch
		}

		vec := batch.ColVec(si.colIdx)
		col := vec.Datum()
		var idx int
		n := batch.Length()

		compVal := siTrue
		if si.negate {
			compVal = siFalse
		}

		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInDatum(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					v := col.Get(i)
					if !nulls.NullAt(i) && cmpInDatum(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					v := col.Get(i)
					if cmpInDatum(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					v := col.Get(i)
					if cmpInDatum(v, col, si.filterRow, si.hasNulls) == compVal {
						sel[idx] = i
						idx++
					}
				}
			}
		}

		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (pi *projectInOpDatum) Next() coldata.Batch {
	batch := pi.Input.Next()
	if batch.Length() == 0 {
		return coldata.ZeroBatch
	}

	vec := batch.ColVec(pi.colIdx)
	col := vec.Datum()

	projVec := batch.ColVec(pi.outputIdx)
	projCol := projVec.Bool()
	projNulls := projVec.Nulls()

	n := batch.Length()

	cmpVal := siTrue
	if pi.negate {
		cmpVal = siFalse
	}

	if vec.MaybeHasNulls() {
		nulls := vec.Nulls()
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					v := col.Get(i)
					cmpRes := cmpInDatum(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				if nulls.NullAt(i) {
					projNulls.SetNull(i)
				} else {
					v := col.Get(i)
					cmpRes := cmpInDatum(v, col, pi.filterRow, pi.hasNulls)
					if cmpRes == siNull {
						projNulls.SetNull(i)
					} else {
						projCol[i] = cmpRes == cmpVal
					}
				}
			}
		}
	} else {
		if sel := batch.Selection(); sel != nil {
			sel = sel[:n]
			for _, i := range sel {
				v := col.Get(i)
				cmpRes := cmpInDatum(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		} else {
			_ = col.Get(n - 1)
			for i := 0; i < n; i++ {
				v := col.Get(i)
				cmpRes := cmpInDatum(v, col, pi.filterRow, pi.hasNulls)
				if cmpRes == siNull {
					projNulls.SetNull(i)
				} else {
					projCol[i] = cmpRes == cmpVal
				}
			}
		}
	}
	return batch
}
