// Code generated by execgen; DO NOT EDIT.
// Copyright 2022 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexec

import (
	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/rowenc"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/cockroach/pkg/util/encoding"
	"github.com/cockroachdb/cockroach/pkg/util/json"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ = typeconv.DatumVecCanonicalTypeFamily
	_ apd.Context
	_ duration.Duration
	_ encoding.Direction
	_ json.JSON
)

// EncDatumRowToColVecs converts the provided rowenc.EncDatumRow to the columnar
// format and writes the converted values at the rowIdx position of the given
// vecs.
// Note: it is the caller's responsibility to perform the memory accounting.
func EncDatumRowToColVecs(
	row rowenc.EncDatumRow,
	rowIdx int,
	vecs coldata.TypedVecs,
	typs []*types.T,
	alloc *tree.DatumAlloc,
) {
	for vecIdx, t := range typs {
		if row[vecIdx].Datum == nil {
			if err := row[vecIdx].EnsureDecoded(t, alloc); err != nil {
				colexecerror.InternalError(err)
			}
		}
		datum := row[vecIdx].Datum
		if datum == tree.DNull {
			vecs.Nulls[vecIdx].SetNull(rowIdx)
		} else {
			switch t.Family() {
			case types.BoolFamily:
				switch t.Width() {
				case -1:
				default:

					v := bool(*datum.(*tree.DBool))
					vecs.BoolCols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				}
			case types.IntFamily:
				switch t.Width() {
				case 16:

					v := int16(*datum.(*tree.DInt))
					vecs.Int16Cols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				case 32:

					v := int32(*datum.(*tree.DInt))
					vecs.Int32Cols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				case -1:
				default:

					v := int64(*datum.(*tree.DInt))
					vecs.Int64Cols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				}
			case types.FloatFamily:
				switch t.Width() {
				case -1:
				default:

					v := float64(*datum.(*tree.DFloat))
					vecs.Float64Cols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				}
			case types.DecimalFamily:
				switch t.Width() {
				case -1:
				default:

					v := datum.(*tree.DDecimal).Decimal
					vecs.DecimalCols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				}
			case types.DateFamily:
				switch t.Width() {
				case -1:
				default:

					v := datum.(*tree.DDate).UnixEpochDaysWithOrig()
					vecs.Int64Cols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				}
			case types.TimestampFamily:
				switch t.Width() {
				case -1:
				default:

					v := datum.(*tree.DTimestamp).Time
					vecs.TimestampCols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				}
			case types.IntervalFamily:
				switch t.Width() {
				case -1:
				default:

					v := datum.(*tree.DInterval).Duration
					vecs.IntervalCols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				}
			case types.StringFamily:
				switch t.Width() {
				case -1:
				default:
					// Handle other STRING-related OID types, like oid.T_name.
					wrapper, ok := datum.(*tree.DOidWrapper)
					if ok {
						datum = wrapper.Wrapped
					}
					v := encoding.UnsafeConvertStringToBytes(string(*datum.(*tree.DString)))
					vecs.BytesCols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				}
			case types.BytesFamily:
				switch t.Width() {
				case -1:
				default:

					v := encoding.UnsafeConvertStringToBytes(string(*datum.(*tree.DBytes)))
					vecs.BytesCols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				}
			case types.TimestampTZFamily:
				switch t.Width() {
				case -1:
				default:

					v := datum.(*tree.DTimestampTZ).Time
					vecs.TimestampCols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				}
			case types.UuidFamily:
				switch t.Width() {
				case -1:
				default:

					v := datum.(*tree.DUuid).UUID.GetBytesMut()
					vecs.BytesCols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				}
			case types.JsonFamily:
				switch t.Width() {
				case -1:
				default:

					v := datum.(*tree.DJSON).JSON
					vecs.JSONCols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				}
			case types.EnumFamily:
				switch t.Width() {
				case -1:
				default:

					v := datum.(*tree.DEnum).PhysicalRep
					vecs.BytesCols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				}
			case types.EncodedKeyFamily:
				switch t.Width() {
				case -1:
				default:

					v := encoding.UnsafeConvertStringToBytes(string(*datum.(*tree.DEncodedKey)))
					vecs.BytesCols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				}
			case typeconv.DatumVecCanonicalTypeFamily:
			default:
				switch t.Width() {
				case -1:
				default:

					v := datum
					vecs.DatumCols[vecs.ColsMap[vecIdx]].Set(rowIdx, v)
				}
			}
		}
	}
}
