// Code generated by execgen; DO NOT EDIT.
// Copyright 2021 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecwindow

import (
	"context"
	"math"
	"time"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexecutils"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/execinfra"
	"github.com/cockroachdb/cockroach/pkg/sql/execinfrapb"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/eval"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/cockroach/pkg/util/timeutil/pgdate"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ apd.Context
	_ = coldataext.CompareDatum
	_ duration.Duration
	_ pgdate.Date
)

// rangeOffsetHandler is a utility operator used to retrieve the location of the
// start or end bound for each row when in RANGE mode with an offset.
type rangeOffsetHandler interface {
	// startPartition resets the rangeOffsetHandler for use on the current
	// partition.
	startPartition(storedCols *colexecutils.SpillingBuffer, peersColIdx, ordColIdx int)

	// getIdx provides an updated bound index for the current row given the
	// location of the last bound index. getIdx should only be called for the
	// first row of each peer group.
	getIdx(ctx context.Context, currRow, lastIdx int) int

	// close releases references to prevent memory leaks.
	close()
}

func newRangeOffsetHandler(
	evalCtx *eval.Context,
	datumAlloc *tree.DatumAlloc,
	bound *execinfrapb.WindowerSpec_Frame_Bound,
	ordColType *types.T,
	ordColAsc, isStart bool,
) rangeOffsetHandler {
	switch bound.BoundType {
	case execinfrapb.WindowerSpec_Frame_OFFSET_PRECEDING:
		switch isStart {
		case true:
			switch ordColAsc {
			case true:
				switch ordColType.Family() {
				case types.IntFamily:
					switch ordColType.Width() {
					case 16:
						op := &rangeHandlerOffsetPrecedingStartAscInt16{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int16),
						}
						return op
					case 32:
						op := &rangeHandlerOffsetPrecedingStartAscInt32{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int32),
						}
						return op
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingStartAscInt64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int64),
						}
						return op
					}
				case types.DecimalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingStartAscDecimal{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(apd.Decimal),
						}
						return op
					}
				case types.FloatFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingStartAscFloat64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(float64),
						}
						return op
					}
				case types.IntervalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingStartAscInterval{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.DateFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingStartAscDate{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimestampTZFamily, types.TimestampFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingStartAscTimestamp{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimeTZFamily, types.TimeFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingStartAscDatum{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(tree.Datum),
						}
						_, binOp, _ := eval.WindowFrameRangeOps{}.LookupImpl(
							ordColType, getOffsetType(ordColType))
						op.overloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp.EvalOp, EvalCtx: evalCtx}
						return op
					}
				}
			case false:
				switch ordColType.Family() {
				case types.IntFamily:
					switch ordColType.Width() {
					case 16:
						op := &rangeHandlerOffsetPrecedingStartDescInt16{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int16),
						}
						return op
					case 32:
						op := &rangeHandlerOffsetPrecedingStartDescInt32{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int32),
						}
						return op
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingStartDescInt64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int64),
						}
						return op
					}
				case types.DecimalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingStartDescDecimal{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(apd.Decimal),
						}
						return op
					}
				case types.FloatFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingStartDescFloat64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(float64),
						}
						return op
					}
				case types.IntervalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingStartDescInterval{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.DateFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingStartDescDate{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimestampTZFamily, types.TimestampFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingStartDescTimestamp{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimeTZFamily, types.TimeFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingStartDescDatum{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(tree.Datum),
						}
						binOp, _, _ := eval.WindowFrameRangeOps{}.LookupImpl(
							ordColType, getOffsetType(ordColType))
						op.overloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp.EvalOp, EvalCtx: evalCtx}
						return op
					}
				}
			}
		case false:
			switch ordColAsc {
			case true:
				switch ordColType.Family() {
				case types.IntFamily:
					switch ordColType.Width() {
					case 16:
						op := &rangeHandlerOffsetPrecedingEndAscInt16{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int16),
						}
						return op
					case 32:
						op := &rangeHandlerOffsetPrecedingEndAscInt32{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int32),
						}
						return op
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingEndAscInt64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int64),
						}
						return op
					}
				case types.DecimalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingEndAscDecimal{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(apd.Decimal),
						}
						return op
					}
				case types.FloatFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingEndAscFloat64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(float64),
						}
						return op
					}
				case types.IntervalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingEndAscInterval{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.DateFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingEndAscDate{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimestampTZFamily, types.TimestampFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingEndAscTimestamp{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimeTZFamily, types.TimeFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingEndAscDatum{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(tree.Datum),
						}
						_, binOp, _ := eval.WindowFrameRangeOps{}.LookupImpl(
							ordColType, getOffsetType(ordColType))
						op.overloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp.EvalOp, EvalCtx: evalCtx}
						return op
					}
				}
			case false:
				switch ordColType.Family() {
				case types.IntFamily:
					switch ordColType.Width() {
					case 16:
						op := &rangeHandlerOffsetPrecedingEndDescInt16{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int16),
						}
						return op
					case 32:
						op := &rangeHandlerOffsetPrecedingEndDescInt32{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int32),
						}
						return op
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingEndDescInt64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int64),
						}
						return op
					}
				case types.DecimalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingEndDescDecimal{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(apd.Decimal),
						}
						return op
					}
				case types.FloatFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingEndDescFloat64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(float64),
						}
						return op
					}
				case types.IntervalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingEndDescInterval{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.DateFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingEndDescDate{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimestampTZFamily, types.TimestampFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingEndDescTimestamp{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimeTZFamily, types.TimeFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetPrecedingEndDescDatum{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(tree.Datum),
						}
						binOp, _, _ := eval.WindowFrameRangeOps{}.LookupImpl(
							ordColType, getOffsetType(ordColType))
						op.overloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp.EvalOp, EvalCtx: evalCtx}
						return op
					}
				}
			}
		}
	case execinfrapb.WindowerSpec_Frame_OFFSET_FOLLOWING:
		switch isStart {
		case true:
			switch ordColAsc {
			case true:
				switch ordColType.Family() {
				case types.IntFamily:
					switch ordColType.Width() {
					case 16:
						op := &rangeHandlerOffsetFollowingStartAscInt16{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int16),
						}
						return op
					case 32:
						op := &rangeHandlerOffsetFollowingStartAscInt32{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int32),
						}
						return op
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingStartAscInt64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int64),
						}
						return op
					}
				case types.DecimalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingStartAscDecimal{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(apd.Decimal),
						}
						return op
					}
				case types.FloatFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingStartAscFloat64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(float64),
						}
						return op
					}
				case types.IntervalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingStartAscInterval{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.DateFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingStartAscDate{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimestampTZFamily, types.TimestampFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingStartAscTimestamp{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimeTZFamily, types.TimeFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingStartAscDatum{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(tree.Datum),
						}
						binOp, _, _ := eval.WindowFrameRangeOps{}.LookupImpl(
							ordColType, getOffsetType(ordColType))
						op.overloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp.EvalOp, EvalCtx: evalCtx}
						return op
					}
				}
			case false:
				switch ordColType.Family() {
				case types.IntFamily:
					switch ordColType.Width() {
					case 16:
						op := &rangeHandlerOffsetFollowingStartDescInt16{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int16),
						}
						return op
					case 32:
						op := &rangeHandlerOffsetFollowingStartDescInt32{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int32),
						}
						return op
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingStartDescInt64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int64),
						}
						return op
					}
				case types.DecimalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingStartDescDecimal{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(apd.Decimal),
						}
						return op
					}
				case types.FloatFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingStartDescFloat64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(float64),
						}
						return op
					}
				case types.IntervalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingStartDescInterval{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.DateFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingStartDescDate{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimestampTZFamily, types.TimestampFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingStartDescTimestamp{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimeTZFamily, types.TimeFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingStartDescDatum{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(tree.Datum),
						}
						_, binOp, _ := eval.WindowFrameRangeOps{}.LookupImpl(
							ordColType, getOffsetType(ordColType))
						op.overloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp.EvalOp, EvalCtx: evalCtx}
						return op
					}
				}
			}
		case false:
			switch ordColAsc {
			case true:
				switch ordColType.Family() {
				case types.IntFamily:
					switch ordColType.Width() {
					case 16:
						op := &rangeHandlerOffsetFollowingEndAscInt16{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int16),
						}
						return op
					case 32:
						op := &rangeHandlerOffsetFollowingEndAscInt32{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int32),
						}
						return op
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingEndAscInt64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int64),
						}
						return op
					}
				case types.DecimalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingEndAscDecimal{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(apd.Decimal),
						}
						return op
					}
				case types.FloatFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingEndAscFloat64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(float64),
						}
						return op
					}
				case types.IntervalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingEndAscInterval{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.DateFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingEndAscDate{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimestampTZFamily, types.TimestampFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingEndAscTimestamp{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimeTZFamily, types.TimeFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingEndAscDatum{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(tree.Datum),
						}
						binOp, _, _ := eval.WindowFrameRangeOps{}.LookupImpl(
							ordColType, getOffsetType(ordColType))
						op.overloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp.EvalOp, EvalCtx: evalCtx}
						return op
					}
				}
			case false:
				switch ordColType.Family() {
				case types.IntFamily:
					switch ordColType.Width() {
					case 16:
						op := &rangeHandlerOffsetFollowingEndDescInt16{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int16),
						}
						return op
					case 32:
						op := &rangeHandlerOffsetFollowingEndDescInt32{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int32),
						}
						return op
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingEndDescInt64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(int64),
						}
						return op
					}
				case types.DecimalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingEndDescDecimal{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(apd.Decimal),
						}
						return op
					}
				case types.FloatFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingEndDescFloat64{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(float64),
						}
						return op
					}
				case types.IntervalFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingEndDescInterval{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.DateFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingEndDescDate{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimestampTZFamily, types.TimestampFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingEndDescTimestamp{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(duration.Duration),
						}
						return op
					}
				case types.TimeTZFamily, types.TimeFamily:
					switch ordColType.Width() {
					case -1:
					default:
						op := &rangeHandlerOffsetFollowingEndDescDatum{
							offset: decodeOffset(datumAlloc, ordColType, bound.TypedOffset).(tree.Datum),
						}
						_, binOp, _ := eval.WindowFrameRangeOps{}.LookupImpl(
							ordColType, getOffsetType(ordColType))
						op.overloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp.EvalOp, EvalCtx: evalCtx}
						return op
					}
				}
			}
		}
	}
	colexecerror.InternalError(errors.AssertionFailedf("unsupported range offset"))
	return nil
}

// rangeOffsetHandlerBase extracts common fields and methods of the
// rangeOffsetHandler utility operators.
type rangeOffsetHandlerBase struct {
	storedCols  *colexecutils.SpillingBuffer
	ordColIdx   int
	peersColIdx int
}

// rangeHandlerOffsetPrecedingStartAscInt16 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartAscInt16 struct {
	rangeOffsetHandlerBase
	offset int16
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartAscInt16{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartAscInt16) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int16()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) - int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) > 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int16()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartAscInt16) close() {
	*h = rangeHandlerOffsetPrecedingStartAscInt16{}
}

// rangeHandlerOffsetPrecedingStartAscInt32 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartAscInt32 struct {
	rangeOffsetHandlerBase
	offset int32
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartAscInt32{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartAscInt32) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int32()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) - int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) > 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int32()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartAscInt32) close() {
	*h = rangeHandlerOffsetPrecedingStartAscInt32{}
}

// rangeHandlerOffsetPrecedingStartAscInt64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartAscInt64 struct {
	rangeOffsetHandlerBase
	offset int64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartAscInt64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartAscInt64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) - int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) > 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartAscInt64) close() {
	*h = rangeHandlerOffsetPrecedingStartAscInt64{}
}

// rangeHandlerOffsetPrecedingStartAscDecimal is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartAscDecimal struct {
	rangeOffsetHandlerBase
	offset apd.Decimal
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartAscDecimal{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartAscDecimal) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   apd.Decimal
		cmpResult int
	)
	col := vec.Decimal()
	currRowVal := col.Get(vecIdx)

	{

		_, err := tree.ExactCtx.Sub(&seekVal, &currRowVal, &h.offset)
		if err != nil {
			colexecerror.ExpectedError(err)
		}

	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Decimal()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)
				cmpResult = tree.CompareDecimals(&cmpVal, &seekVal)
				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartAscDecimal) close() {
	*h = rangeHandlerOffsetPrecedingStartAscDecimal{}
}

// rangeHandlerOffsetPrecedingStartAscFloat64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartAscFloat64 struct {
	rangeOffsetHandlerBase
	offset float64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartAscFloat64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartAscFloat64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   float64
		cmpResult int
	)
	col := vec.Float64()
	currRowVal := col.Get(vecIdx)

	{

		seekVal = float64(currRowVal) - float64(h.offset)
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Float64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := float64(cmpVal), float64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else if a == b {
						cmpResult = 0
					} else if math.IsNaN(a) {
						if math.IsNaN(b) {
							cmpResult = 0
						} else {
							cmpResult = -1
						}
					} else {
						cmpResult = 1
					}
				}

				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartAscFloat64) close() {
	*h = rangeHandlerOffsetPrecedingStartAscFloat64{}
}

// rangeHandlerOffsetPrecedingStartAscInterval is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartAscInterval struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartAscInterval{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartAscInterval) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   duration.Duration
		cmpResult int
	)
	col := vec.Interval()
	currRowVal := col.Get(vecIdx)
	seekVal = currRowVal.Sub(h.offset)

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Interval()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)
				cmpResult = cmpVal.Compare(seekVal)
				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartAscInterval) close() {
	*h = rangeHandlerOffsetPrecedingStartAscInterval{}
}

// rangeHandlerOffsetPrecedingStartAscDate is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartAscDate struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartAscDate{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartAscDate) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	d_casted, err := pgdate.MakeDateFromUnixEpoch(currRowVal)
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_casted, err := d_casted.ToTime()
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_res := duration.Add(t_casted, h.offset.Mul(-1))
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				d_casted, err := pgdate.MakeDateFromUnixEpoch(cmpVal)
				if err != nil {
					colexecerror.ExpectedError(err)
				}
				t_casted, err := d_casted.ToTime()
				if err != nil {
					colexecerror.ExpectedError(err)
				}

				if t_casted.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(t_casted) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartAscDate) close() {
	*h = rangeHandlerOffsetPrecedingStartAscDate{}
}

// rangeHandlerOffsetPrecedingStartAscTimestamp is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartAscTimestamp struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartAscTimestamp{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartAscTimestamp) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Timestamp()
	currRowVal := col.Get(vecIdx)
	t_res := duration.Add(currRowVal, h.offset.Mul(-1))
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Timestamp()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				if cmpVal.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(cmpVal) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartAscTimestamp) close() {
	*h = rangeHandlerOffsetPrecedingStartAscTimestamp{}
}

// rangeHandlerOffsetPrecedingStartAscDatum is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartAscDatum struct {
	rangeOffsetHandlerBase
	overloadHelper colexecutils.BinaryOverloadHelper
	offset         tree.Datum
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartAscDatum{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartAscDatum) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {
	_overloadHelper := h.overloadHelper
	_ctx := ctx

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   tree.Datum
		cmpResult int
	)
	col := vec.Datum()
	currRowVal := col.Get(vecIdx)

	_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, currRowVal.(tree.Datum), h.offset.(tree.Datum))
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	seekVal = _res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Datum()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				cmpResult = coldataext.CompareDatum(cmpVal, col, seekVal)

				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartAscDatum) close() {
	*h = rangeHandlerOffsetPrecedingStartAscDatum{}
}

// rangeHandlerOffsetPrecedingStartDescInt16 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartDescInt16 struct {
	rangeOffsetHandlerBase
	offset int16
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartDescInt16{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartDescInt16) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int16()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) + int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) < 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int16()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartDescInt16) close() {
	*h = rangeHandlerOffsetPrecedingStartDescInt16{}
}

// rangeHandlerOffsetPrecedingStartDescInt32 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartDescInt32 struct {
	rangeOffsetHandlerBase
	offset int32
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartDescInt32{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartDescInt32) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int32()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) + int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) < 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int32()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartDescInt32) close() {
	*h = rangeHandlerOffsetPrecedingStartDescInt32{}
}

// rangeHandlerOffsetPrecedingStartDescInt64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartDescInt64 struct {
	rangeOffsetHandlerBase
	offset int64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartDescInt64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartDescInt64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) + int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) < 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartDescInt64) close() {
	*h = rangeHandlerOffsetPrecedingStartDescInt64{}
}

// rangeHandlerOffsetPrecedingStartDescDecimal is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartDescDecimal struct {
	rangeOffsetHandlerBase
	offset apd.Decimal
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartDescDecimal{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartDescDecimal) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   apd.Decimal
		cmpResult int
	)
	col := vec.Decimal()
	currRowVal := col.Get(vecIdx)

	{

		_, err := tree.ExactCtx.Add(&seekVal, &currRowVal, &h.offset)
		if err != nil {
			colexecerror.ExpectedError(err)
		}

	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Decimal()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)
				cmpResult = tree.CompareDecimals(&cmpVal, &seekVal)
				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartDescDecimal) close() {
	*h = rangeHandlerOffsetPrecedingStartDescDecimal{}
}

// rangeHandlerOffsetPrecedingStartDescFloat64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartDescFloat64 struct {
	rangeOffsetHandlerBase
	offset float64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartDescFloat64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartDescFloat64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   float64
		cmpResult int
	)
	col := vec.Float64()
	currRowVal := col.Get(vecIdx)

	{

		seekVal = float64(currRowVal) + float64(h.offset)
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Float64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := float64(cmpVal), float64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else if a == b {
						cmpResult = 0
					} else if math.IsNaN(a) {
						if math.IsNaN(b) {
							cmpResult = 0
						} else {
							cmpResult = -1
						}
					} else {
						cmpResult = 1
					}
				}

				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartDescFloat64) close() {
	*h = rangeHandlerOffsetPrecedingStartDescFloat64{}
}

// rangeHandlerOffsetPrecedingStartDescInterval is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartDescInterval struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartDescInterval{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartDescInterval) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   duration.Duration
		cmpResult int
	)
	col := vec.Interval()
	currRowVal := col.Get(vecIdx)
	seekVal = currRowVal.Add(h.offset)

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Interval()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)
				cmpResult = cmpVal.Compare(seekVal)
				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartDescInterval) close() {
	*h = rangeHandlerOffsetPrecedingStartDescInterval{}
}

// rangeHandlerOffsetPrecedingStartDescDate is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartDescDate struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartDescDate{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartDescDate) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	d_casted, err := pgdate.MakeDateFromUnixEpoch(currRowVal)
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_casted, err := d_casted.ToTime()
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_res := duration.Add(t_casted, h.offset)
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				d_casted, err := pgdate.MakeDateFromUnixEpoch(cmpVal)
				if err != nil {
					colexecerror.ExpectedError(err)
				}
				t_casted, err := d_casted.ToTime()
				if err != nil {
					colexecerror.ExpectedError(err)
				}

				if t_casted.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(t_casted) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartDescDate) close() {
	*h = rangeHandlerOffsetPrecedingStartDescDate{}
}

// rangeHandlerOffsetPrecedingStartDescTimestamp is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartDescTimestamp struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartDescTimestamp{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartDescTimestamp) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Timestamp()
	currRowVal := col.Get(vecIdx)
	t_res := duration.Add(currRowVal, h.offset)
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Timestamp()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				if cmpVal.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(cmpVal) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartDescTimestamp) close() {
	*h = rangeHandlerOffsetPrecedingStartDescTimestamp{}
}

// rangeHandlerOffsetPrecedingStartDescDatum is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingStartDescDatum struct {
	rangeOffsetHandlerBase
	overloadHelper colexecutils.BinaryOverloadHelper
	offset         tree.Datum
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingStartDescDatum{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingStartDescDatum) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {
	_overloadHelper := h.overloadHelper
	_ctx := ctx

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   tree.Datum
		cmpResult int
	)
	col := vec.Datum()
	currRowVal := col.Get(vecIdx)

	_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, currRowVal.(tree.Datum), h.offset.(tree.Datum))
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	seekVal = _res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Datum()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				cmpResult = coldataext.CompareDatum(cmpVal, col, seekVal)

				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingStartDescDatum) close() {
	*h = rangeHandlerOffsetPrecedingStartDescDatum{}
}

// rangeHandlerOffsetPrecedingEndAscInt16 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndAscInt16 struct {
	rangeOffsetHandlerBase
	offset int16
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndAscInt16{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndAscInt16) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int16()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) - int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) > 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int16()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndAscInt16) close() {
	*h = rangeHandlerOffsetPrecedingEndAscInt16{}
}

// rangeHandlerOffsetPrecedingEndAscInt32 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndAscInt32 struct {
	rangeOffsetHandlerBase
	offset int32
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndAscInt32{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndAscInt32) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int32()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) - int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) > 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int32()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndAscInt32) close() {
	*h = rangeHandlerOffsetPrecedingEndAscInt32{}
}

// rangeHandlerOffsetPrecedingEndAscInt64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndAscInt64 struct {
	rangeOffsetHandlerBase
	offset int64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndAscInt64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndAscInt64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) - int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) > 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndAscInt64) close() {
	*h = rangeHandlerOffsetPrecedingEndAscInt64{}
}

// rangeHandlerOffsetPrecedingEndAscDecimal is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndAscDecimal struct {
	rangeOffsetHandlerBase
	offset apd.Decimal
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndAscDecimal{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndAscDecimal) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   apd.Decimal
		cmpResult int
	)
	col := vec.Decimal()
	currRowVal := col.Get(vecIdx)

	{

		_, err := tree.ExactCtx.Sub(&seekVal, &currRowVal, &h.offset)
		if err != nil {
			colexecerror.ExpectedError(err)
		}

	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Decimal()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)
				cmpResult = tree.CompareDecimals(&cmpVal, &seekVal)
				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndAscDecimal) close() {
	*h = rangeHandlerOffsetPrecedingEndAscDecimal{}
}

// rangeHandlerOffsetPrecedingEndAscFloat64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndAscFloat64 struct {
	rangeOffsetHandlerBase
	offset float64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndAscFloat64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndAscFloat64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   float64
		cmpResult int
	)
	col := vec.Float64()
	currRowVal := col.Get(vecIdx)

	{

		seekVal = float64(currRowVal) - float64(h.offset)
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Float64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := float64(cmpVal), float64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else if a == b {
						cmpResult = 0
					} else if math.IsNaN(a) {
						if math.IsNaN(b) {
							cmpResult = 0
						} else {
							cmpResult = -1
						}
					} else {
						cmpResult = 1
					}
				}

				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndAscFloat64) close() {
	*h = rangeHandlerOffsetPrecedingEndAscFloat64{}
}

// rangeHandlerOffsetPrecedingEndAscInterval is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndAscInterval struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndAscInterval{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndAscInterval) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   duration.Duration
		cmpResult int
	)
	col := vec.Interval()
	currRowVal := col.Get(vecIdx)
	seekVal = currRowVal.Sub(h.offset)

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Interval()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)
				cmpResult = cmpVal.Compare(seekVal)
				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndAscInterval) close() {
	*h = rangeHandlerOffsetPrecedingEndAscInterval{}
}

// rangeHandlerOffsetPrecedingEndAscDate is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndAscDate struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndAscDate{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndAscDate) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	d_casted, err := pgdate.MakeDateFromUnixEpoch(currRowVal)
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_casted, err := d_casted.ToTime()
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_res := duration.Add(t_casted, h.offset.Mul(-1))
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				d_casted, err := pgdate.MakeDateFromUnixEpoch(cmpVal)
				if err != nil {
					colexecerror.ExpectedError(err)
				}
				t_casted, err := d_casted.ToTime()
				if err != nil {
					colexecerror.ExpectedError(err)
				}

				if t_casted.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(t_casted) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndAscDate) close() {
	*h = rangeHandlerOffsetPrecedingEndAscDate{}
}

// rangeHandlerOffsetPrecedingEndAscTimestamp is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndAscTimestamp struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndAscTimestamp{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndAscTimestamp) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Timestamp()
	currRowVal := col.Get(vecIdx)
	t_res := duration.Add(currRowVal, h.offset.Mul(-1))
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Timestamp()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				if cmpVal.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(cmpVal) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndAscTimestamp) close() {
	*h = rangeHandlerOffsetPrecedingEndAscTimestamp{}
}

// rangeHandlerOffsetPrecedingEndAscDatum is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndAscDatum struct {
	rangeOffsetHandlerBase
	overloadHelper colexecutils.BinaryOverloadHelper
	offset         tree.Datum
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndAscDatum{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndAscDatum) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {
	_overloadHelper := h.overloadHelper
	_ctx := ctx

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   tree.Datum
		cmpResult int
	)
	col := vec.Datum()
	currRowVal := col.Get(vecIdx)

	_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, currRowVal.(tree.Datum), h.offset.(tree.Datum))
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	seekVal = _res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Datum()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				cmpResult = coldataext.CompareDatum(cmpVal, col, seekVal)

				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndAscDatum) close() {
	*h = rangeHandlerOffsetPrecedingEndAscDatum{}
}

// rangeHandlerOffsetPrecedingEndDescInt16 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndDescInt16 struct {
	rangeOffsetHandlerBase
	offset int16
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndDescInt16{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndDescInt16) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int16()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) + int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) < 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int16()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndDescInt16) close() {
	*h = rangeHandlerOffsetPrecedingEndDescInt16{}
}

// rangeHandlerOffsetPrecedingEndDescInt32 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndDescInt32 struct {
	rangeOffsetHandlerBase
	offset int32
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndDescInt32{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndDescInt32) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int32()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) + int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) < 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int32()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndDescInt32) close() {
	*h = rangeHandlerOffsetPrecedingEndDescInt32{}
}

// rangeHandlerOffsetPrecedingEndDescInt64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndDescInt64 struct {
	rangeOffsetHandlerBase
	offset int64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndDescInt64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndDescInt64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) + int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) < 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndDescInt64) close() {
	*h = rangeHandlerOffsetPrecedingEndDescInt64{}
}

// rangeHandlerOffsetPrecedingEndDescDecimal is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndDescDecimal struct {
	rangeOffsetHandlerBase
	offset apd.Decimal
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndDescDecimal{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndDescDecimal) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   apd.Decimal
		cmpResult int
	)
	col := vec.Decimal()
	currRowVal := col.Get(vecIdx)

	{

		_, err := tree.ExactCtx.Add(&seekVal, &currRowVal, &h.offset)
		if err != nil {
			colexecerror.ExpectedError(err)
		}

	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Decimal()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)
				cmpResult = tree.CompareDecimals(&cmpVal, &seekVal)
				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndDescDecimal) close() {
	*h = rangeHandlerOffsetPrecedingEndDescDecimal{}
}

// rangeHandlerOffsetPrecedingEndDescFloat64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndDescFloat64 struct {
	rangeOffsetHandlerBase
	offset float64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndDescFloat64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndDescFloat64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   float64
		cmpResult int
	)
	col := vec.Float64()
	currRowVal := col.Get(vecIdx)

	{

		seekVal = float64(currRowVal) + float64(h.offset)
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Float64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := float64(cmpVal), float64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else if a == b {
						cmpResult = 0
					} else if math.IsNaN(a) {
						if math.IsNaN(b) {
							cmpResult = 0
						} else {
							cmpResult = -1
						}
					} else {
						cmpResult = 1
					}
				}

				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndDescFloat64) close() {
	*h = rangeHandlerOffsetPrecedingEndDescFloat64{}
}

// rangeHandlerOffsetPrecedingEndDescInterval is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndDescInterval struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndDescInterval{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndDescInterval) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   duration.Duration
		cmpResult int
	)
	col := vec.Interval()
	currRowVal := col.Get(vecIdx)
	seekVal = currRowVal.Add(h.offset)

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Interval()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)
				cmpResult = cmpVal.Compare(seekVal)
				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndDescInterval) close() {
	*h = rangeHandlerOffsetPrecedingEndDescInterval{}
}

// rangeHandlerOffsetPrecedingEndDescDate is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndDescDate struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndDescDate{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndDescDate) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	d_casted, err := pgdate.MakeDateFromUnixEpoch(currRowVal)
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_casted, err := d_casted.ToTime()
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_res := duration.Add(t_casted, h.offset)
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				d_casted, err := pgdate.MakeDateFromUnixEpoch(cmpVal)
				if err != nil {
					colexecerror.ExpectedError(err)
				}
				t_casted, err := d_casted.ToTime()
				if err != nil {
					colexecerror.ExpectedError(err)
				}

				if t_casted.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(t_casted) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndDescDate) close() {
	*h = rangeHandlerOffsetPrecedingEndDescDate{}
}

// rangeHandlerOffsetPrecedingEndDescTimestamp is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndDescTimestamp struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndDescTimestamp{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndDescTimestamp) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Timestamp()
	currRowVal := col.Get(vecIdx)
	t_res := duration.Add(currRowVal, h.offset)
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Timestamp()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				if cmpVal.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(cmpVal) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndDescTimestamp) close() {
	*h = rangeHandlerOffsetPrecedingEndDescTimestamp{}
}

// rangeHandlerOffsetPrecedingEndDescDatum is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetPrecedingEndDescDatum struct {
	rangeOffsetHandlerBase
	overloadHelper colexecutils.BinaryOverloadHelper
	offset         tree.Datum
}

var _ rangeOffsetHandler = &rangeHandlerOffsetPrecedingEndDescDatum{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetPrecedingEndDescDatum) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {
	_overloadHelper := h.overloadHelper
	_ctx := ctx

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   tree.Datum
		cmpResult int
	)
	col := vec.Datum()
	currRowVal := col.Get(vecIdx)

	_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, currRowVal.(tree.Datum), h.offset.(tree.Datum))
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	seekVal = _res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Datum()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				cmpResult = coldataext.CompareDatum(cmpVal, col, seekVal)

				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetPrecedingEndDescDatum) close() {
	*h = rangeHandlerOffsetPrecedingEndDescDatum{}
}

// rangeHandlerOffsetFollowingStartAscInt16 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartAscInt16 struct {
	rangeOffsetHandlerBase
	offset int16
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartAscInt16{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartAscInt16) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int16()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) + int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) < 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int16()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartAscInt16) close() {
	*h = rangeHandlerOffsetFollowingStartAscInt16{}
}

// rangeHandlerOffsetFollowingStartAscInt32 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartAscInt32 struct {
	rangeOffsetHandlerBase
	offset int32
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartAscInt32{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartAscInt32) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int32()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) + int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) < 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int32()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartAscInt32) close() {
	*h = rangeHandlerOffsetFollowingStartAscInt32{}
}

// rangeHandlerOffsetFollowingStartAscInt64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartAscInt64 struct {
	rangeOffsetHandlerBase
	offset int64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartAscInt64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartAscInt64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) + int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) < 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartAscInt64) close() {
	*h = rangeHandlerOffsetFollowingStartAscInt64{}
}

// rangeHandlerOffsetFollowingStartAscDecimal is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartAscDecimal struct {
	rangeOffsetHandlerBase
	offset apd.Decimal
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartAscDecimal{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartAscDecimal) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   apd.Decimal
		cmpResult int
	)
	col := vec.Decimal()
	currRowVal := col.Get(vecIdx)

	{

		_, err := tree.ExactCtx.Add(&seekVal, &currRowVal, &h.offset)
		if err != nil {
			colexecerror.ExpectedError(err)
		}

	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Decimal()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)
				cmpResult = tree.CompareDecimals(&cmpVal, &seekVal)
				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartAscDecimal) close() {
	*h = rangeHandlerOffsetFollowingStartAscDecimal{}
}

// rangeHandlerOffsetFollowingStartAscFloat64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartAscFloat64 struct {
	rangeOffsetHandlerBase
	offset float64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartAscFloat64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartAscFloat64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   float64
		cmpResult int
	)
	col := vec.Float64()
	currRowVal := col.Get(vecIdx)

	{

		seekVal = float64(currRowVal) + float64(h.offset)
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Float64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := float64(cmpVal), float64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else if a == b {
						cmpResult = 0
					} else if math.IsNaN(a) {
						if math.IsNaN(b) {
							cmpResult = 0
						} else {
							cmpResult = -1
						}
					} else {
						cmpResult = 1
					}
				}

				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartAscFloat64) close() {
	*h = rangeHandlerOffsetFollowingStartAscFloat64{}
}

// rangeHandlerOffsetFollowingStartAscInterval is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartAscInterval struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartAscInterval{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartAscInterval) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   duration.Duration
		cmpResult int
	)
	col := vec.Interval()
	currRowVal := col.Get(vecIdx)
	seekVal = currRowVal.Add(h.offset)

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Interval()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)
				cmpResult = cmpVal.Compare(seekVal)
				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartAscInterval) close() {
	*h = rangeHandlerOffsetFollowingStartAscInterval{}
}

// rangeHandlerOffsetFollowingStartAscDate is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartAscDate struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartAscDate{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartAscDate) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	d_casted, err := pgdate.MakeDateFromUnixEpoch(currRowVal)
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_casted, err := d_casted.ToTime()
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_res := duration.Add(t_casted, h.offset)
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				d_casted, err := pgdate.MakeDateFromUnixEpoch(cmpVal)
				if err != nil {
					colexecerror.ExpectedError(err)
				}
				t_casted, err := d_casted.ToTime()
				if err != nil {
					colexecerror.ExpectedError(err)
				}

				if t_casted.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(t_casted) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartAscDate) close() {
	*h = rangeHandlerOffsetFollowingStartAscDate{}
}

// rangeHandlerOffsetFollowingStartAscTimestamp is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartAscTimestamp struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartAscTimestamp{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartAscTimestamp) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Timestamp()
	currRowVal := col.Get(vecIdx)
	t_res := duration.Add(currRowVal, h.offset)
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Timestamp()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				if cmpVal.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(cmpVal) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartAscTimestamp) close() {
	*h = rangeHandlerOffsetFollowingStartAscTimestamp{}
}

// rangeHandlerOffsetFollowingStartAscDatum is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartAscDatum struct {
	rangeOffsetHandlerBase
	overloadHelper colexecutils.BinaryOverloadHelper
	offset         tree.Datum
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartAscDatum{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartAscDatum) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {
	_overloadHelper := h.overloadHelper
	_ctx := ctx

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   tree.Datum
		cmpResult int
	)
	col := vec.Datum()
	currRowVal := col.Get(vecIdx)

	_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, currRowVal.(tree.Datum), h.offset.(tree.Datum))
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	seekVal = _res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Datum()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				cmpResult = coldataext.CompareDatum(cmpVal, col, seekVal)

				if cmpResult >= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartAscDatum) close() {
	*h = rangeHandlerOffsetFollowingStartAscDatum{}
}

// rangeHandlerOffsetFollowingStartDescInt16 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartDescInt16 struct {
	rangeOffsetHandlerBase
	offset int16
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartDescInt16{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartDescInt16) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int16()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) - int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) > 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int16()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartDescInt16) close() {
	*h = rangeHandlerOffsetFollowingStartDescInt16{}
}

// rangeHandlerOffsetFollowingStartDescInt32 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartDescInt32 struct {
	rangeOffsetHandlerBase
	offset int32
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartDescInt32{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartDescInt32) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int32()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) - int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) > 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int32()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartDescInt32) close() {
	*h = rangeHandlerOffsetFollowingStartDescInt32{}
}

// rangeHandlerOffsetFollowingStartDescInt64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartDescInt64 struct {
	rangeOffsetHandlerBase
	offset int64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartDescInt64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartDescInt64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) - int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) > 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartDescInt64) close() {
	*h = rangeHandlerOffsetFollowingStartDescInt64{}
}

// rangeHandlerOffsetFollowingStartDescDecimal is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartDescDecimal struct {
	rangeOffsetHandlerBase
	offset apd.Decimal
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartDescDecimal{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartDescDecimal) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   apd.Decimal
		cmpResult int
	)
	col := vec.Decimal()
	currRowVal := col.Get(vecIdx)

	{

		_, err := tree.ExactCtx.Sub(&seekVal, &currRowVal, &h.offset)
		if err != nil {
			colexecerror.ExpectedError(err)
		}

	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Decimal()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)
				cmpResult = tree.CompareDecimals(&cmpVal, &seekVal)
				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartDescDecimal) close() {
	*h = rangeHandlerOffsetFollowingStartDescDecimal{}
}

// rangeHandlerOffsetFollowingStartDescFloat64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartDescFloat64 struct {
	rangeOffsetHandlerBase
	offset float64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartDescFloat64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartDescFloat64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   float64
		cmpResult int
	)
	col := vec.Float64()
	currRowVal := col.Get(vecIdx)

	{

		seekVal = float64(currRowVal) - float64(h.offset)
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Float64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := float64(cmpVal), float64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else if a == b {
						cmpResult = 0
					} else if math.IsNaN(a) {
						if math.IsNaN(b) {
							cmpResult = 0
						} else {
							cmpResult = -1
						}
					} else {
						cmpResult = 1
					}
				}

				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartDescFloat64) close() {
	*h = rangeHandlerOffsetFollowingStartDescFloat64{}
}

// rangeHandlerOffsetFollowingStartDescInterval is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartDescInterval struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartDescInterval{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartDescInterval) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   duration.Duration
		cmpResult int
	)
	col := vec.Interval()
	currRowVal := col.Get(vecIdx)
	seekVal = currRowVal.Sub(h.offset)

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Interval()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)
				cmpResult = cmpVal.Compare(seekVal)
				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartDescInterval) close() {
	*h = rangeHandlerOffsetFollowingStartDescInterval{}
}

// rangeHandlerOffsetFollowingStartDescDate is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartDescDate struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartDescDate{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartDescDate) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	d_casted, err := pgdate.MakeDateFromUnixEpoch(currRowVal)
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_casted, err := d_casted.ToTime()
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_res := duration.Add(t_casted, h.offset.Mul(-1))
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				d_casted, err := pgdate.MakeDateFromUnixEpoch(cmpVal)
				if err != nil {
					colexecerror.ExpectedError(err)
				}
				t_casted, err := d_casted.ToTime()
				if err != nil {
					colexecerror.ExpectedError(err)
				}

				if t_casted.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(t_casted) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartDescDate) close() {
	*h = rangeHandlerOffsetFollowingStartDescDate{}
}

// rangeHandlerOffsetFollowingStartDescTimestamp is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartDescTimestamp struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartDescTimestamp{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartDescTimestamp) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Timestamp()
	currRowVal := col.Get(vecIdx)
	t_res := duration.Add(currRowVal, h.offset.Mul(-1))
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Timestamp()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				if cmpVal.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(cmpVal) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartDescTimestamp) close() {
	*h = rangeHandlerOffsetFollowingStartDescTimestamp{}
}

// rangeHandlerOffsetFollowingStartDescDatum is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingStartDescDatum struct {
	rangeOffsetHandlerBase
	overloadHelper colexecutils.BinaryOverloadHelper
	offset         tree.Datum
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingStartDescDatum{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingStartDescDatum) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {
	_overloadHelper := h.overloadHelper
	_ctx := ctx

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   tree.Datum
		cmpResult int
	)
	col := vec.Datum()
	currRowVal := col.Get(vecIdx)

	_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, currRowVal.(tree.Datum), h.offset.(tree.Datum))
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	seekVal = _res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Datum()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				cmpResult = coldataext.CompareDatum(cmpVal, col, seekVal)

				if cmpResult <= 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingStartDescDatum) close() {
	*h = rangeHandlerOffsetFollowingStartDescDatum{}
}

// rangeHandlerOffsetFollowingEndAscInt16 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndAscInt16 struct {
	rangeOffsetHandlerBase
	offset int16
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndAscInt16{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndAscInt16) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int16()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) + int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) < 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int16()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndAscInt16) close() {
	*h = rangeHandlerOffsetFollowingEndAscInt16{}
}

// rangeHandlerOffsetFollowingEndAscInt32 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndAscInt32 struct {
	rangeOffsetHandlerBase
	offset int32
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndAscInt32{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndAscInt32) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int32()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) + int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) < 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int32()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndAscInt32) close() {
	*h = rangeHandlerOffsetFollowingEndAscInt32{}
}

// rangeHandlerOffsetFollowingEndAscInt64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndAscInt64 struct {
	rangeOffsetHandlerBase
	offset int64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndAscInt64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndAscInt64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) + int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) < 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndAscInt64) close() {
	*h = rangeHandlerOffsetFollowingEndAscInt64{}
}

// rangeHandlerOffsetFollowingEndAscDecimal is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndAscDecimal struct {
	rangeOffsetHandlerBase
	offset apd.Decimal
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndAscDecimal{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndAscDecimal) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   apd.Decimal
		cmpResult int
	)
	col := vec.Decimal()
	currRowVal := col.Get(vecIdx)

	{

		_, err := tree.ExactCtx.Add(&seekVal, &currRowVal, &h.offset)
		if err != nil {
			colexecerror.ExpectedError(err)
		}

	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Decimal()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)
				cmpResult = tree.CompareDecimals(&cmpVal, &seekVal)
				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndAscDecimal) close() {
	*h = rangeHandlerOffsetFollowingEndAscDecimal{}
}

// rangeHandlerOffsetFollowingEndAscFloat64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndAscFloat64 struct {
	rangeOffsetHandlerBase
	offset float64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndAscFloat64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndAscFloat64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   float64
		cmpResult int
	)
	col := vec.Float64()
	currRowVal := col.Get(vecIdx)

	{

		seekVal = float64(currRowVal) + float64(h.offset)
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Float64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				{
					a, b := float64(cmpVal), float64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else if a == b {
						cmpResult = 0
					} else if math.IsNaN(a) {
						if math.IsNaN(b) {
							cmpResult = 0
						} else {
							cmpResult = -1
						}
					} else {
						cmpResult = 1
					}
				}

				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndAscFloat64) close() {
	*h = rangeHandlerOffsetFollowingEndAscFloat64{}
}

// rangeHandlerOffsetFollowingEndAscInterval is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndAscInterval struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndAscInterval{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndAscInterval) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   duration.Duration
		cmpResult int
	)
	col := vec.Interval()
	currRowVal := col.Get(vecIdx)
	seekVal = currRowVal.Add(h.offset)

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Interval()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)
				cmpResult = cmpVal.Compare(seekVal)
				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndAscInterval) close() {
	*h = rangeHandlerOffsetFollowingEndAscInterval{}
}

// rangeHandlerOffsetFollowingEndAscDate is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndAscDate struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndAscDate{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndAscDate) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	d_casted, err := pgdate.MakeDateFromUnixEpoch(currRowVal)
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_casted, err := d_casted.ToTime()
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_res := duration.Add(t_casted, h.offset)
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				d_casted, err := pgdate.MakeDateFromUnixEpoch(cmpVal)
				if err != nil {
					colexecerror.ExpectedError(err)
				}
				t_casted, err := d_casted.ToTime()
				if err != nil {
					colexecerror.ExpectedError(err)
				}

				if t_casted.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(t_casted) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndAscDate) close() {
	*h = rangeHandlerOffsetFollowingEndAscDate{}
}

// rangeHandlerOffsetFollowingEndAscTimestamp is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndAscTimestamp struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndAscTimestamp{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndAscTimestamp) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Timestamp()
	currRowVal := col.Get(vecIdx)
	t_res := duration.Add(currRowVal, h.offset)
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Timestamp()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				if cmpVal.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(cmpVal) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndAscTimestamp) close() {
	*h = rangeHandlerOffsetFollowingEndAscTimestamp{}
}

// rangeHandlerOffsetFollowingEndAscDatum is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndAscDatum struct {
	rangeOffsetHandlerBase
	overloadHelper colexecutils.BinaryOverloadHelper
	offset         tree.Datum
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndAscDatum{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndAscDatum) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {
	_overloadHelper := h.overloadHelper
	_ctx := ctx

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   tree.Datum
		cmpResult int
	)
	col := vec.Datum()
	currRowVal := col.Get(vecIdx)

	_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, currRowVal.(tree.Datum), h.offset.(tree.Datum))
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	seekVal = _res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// If the ordering column is null at lastIdx, we must have just moved past the
	// end of the null rows (we already checked that the current row isn't null).
	// The index is only updated when a new peer group is encountered, and
	// non-null and null rows are never part of the same frame. So, we have to
	// iterate past any leading nulls.
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		idx++
		var foundNonNull bool
		for {
			if idx >= h.storedCols.Length() {
				return idx
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					// We have scanned past the null rows. We can't return yet, since we
					// may still need to continue scanning past non-null rows.
					foundNonNull = true
					break
				}
				idx++
			}
			if foundNonNull {
				break
			}
		}
	}

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Datum()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				cmpVal := col.Get(vecIdx)

				cmpResult = coldataext.CompareDatum(cmpVal, col, seekVal)

				if cmpResult > 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndAscDatum) close() {
	*h = rangeHandlerOffsetFollowingEndAscDatum{}
}

// rangeHandlerOffsetFollowingEndDescInt16 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndDescInt16 struct {
	rangeOffsetHandlerBase
	offset int16
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndDescInt16{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndDescInt16) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int16()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) - int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) > 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int16()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndDescInt16) close() {
	*h = rangeHandlerOffsetFollowingEndDescInt16{}
}

// rangeHandlerOffsetFollowingEndDescInt32 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndDescInt32 struct {
	rangeOffsetHandlerBase
	offset int32
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndDescInt32{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndDescInt32) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int32()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) - int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) > 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int32()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndDescInt32) close() {
	*h = rangeHandlerOffsetFollowingEndDescInt32{}
}

// rangeHandlerOffsetFollowingEndDescInt64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndDescInt64 struct {
	rangeOffsetHandlerBase
	offset int64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndDescInt64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndDescInt64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   int64
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	{
		result := int64(currRowVal) - int64(h.offset)
		if (result < int64(currRowVal)) != (int64(h.offset) > 0) {
			colexecerror.ExpectedError(tree.ErrIntOutOfRange)
		}
		seekVal = result
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := int64(cmpVal), int64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else {
						cmpResult = 0
					}
				}

				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndDescInt64) close() {
	*h = rangeHandlerOffsetFollowingEndDescInt64{}
}

// rangeHandlerOffsetFollowingEndDescDecimal is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndDescDecimal struct {
	rangeOffsetHandlerBase
	offset apd.Decimal
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndDescDecimal{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndDescDecimal) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   apd.Decimal
		cmpResult int
	)
	col := vec.Decimal()
	currRowVal := col.Get(vecIdx)

	{

		_, err := tree.ExactCtx.Sub(&seekVal, &currRowVal, &h.offset)
		if err != nil {
			colexecerror.ExpectedError(err)
		}

	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Decimal()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)
				cmpResult = tree.CompareDecimals(&cmpVal, &seekVal)
				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndDescDecimal) close() {
	*h = rangeHandlerOffsetFollowingEndDescDecimal{}
}

// rangeHandlerOffsetFollowingEndDescFloat64 is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndDescFloat64 struct {
	rangeOffsetHandlerBase
	offset float64
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndDescFloat64{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndDescFloat64) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   float64
		cmpResult int
	)
	col := vec.Float64()
	currRowVal := col.Get(vecIdx)

	{

		seekVal = float64(currRowVal) - float64(h.offset)
	}

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Float64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				{
					a, b := float64(cmpVal), float64(seekVal)
					if a < b {
						cmpResult = -1
					} else if a > b {
						cmpResult = 1
					} else if a == b {
						cmpResult = 0
					} else if math.IsNaN(a) {
						if math.IsNaN(b) {
							cmpResult = 0
						} else {
							cmpResult = -1
						}
					} else {
						cmpResult = 1
					}
				}

				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndDescFloat64) close() {
	*h = rangeHandlerOffsetFollowingEndDescFloat64{}
}

// rangeHandlerOffsetFollowingEndDescInterval is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndDescInterval struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndDescInterval{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndDescInterval) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   duration.Duration
		cmpResult int
	)
	col := vec.Interval()
	currRowVal := col.Get(vecIdx)
	seekVal = currRowVal.Sub(h.offset)

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Interval()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)
				cmpResult = cmpVal.Compare(seekVal)
				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndDescInterval) close() {
	*h = rangeHandlerOffsetFollowingEndDescInterval{}
}

// rangeHandlerOffsetFollowingEndDescDate is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndDescDate struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndDescDate{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndDescDate) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Int64()
	currRowVal := col.Get(vecIdx)

	d_casted, err := pgdate.MakeDateFromUnixEpoch(currRowVal)
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_casted, err := d_casted.ToTime()
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	t_res := duration.Add(t_casted, h.offset.Mul(-1))
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Int64()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				d_casted, err := pgdate.MakeDateFromUnixEpoch(cmpVal)
				if err != nil {
					colexecerror.ExpectedError(err)
				}
				t_casted, err := d_casted.ToTime()
				if err != nil {
					colexecerror.ExpectedError(err)
				}

				if t_casted.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(t_casted) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndDescDate) close() {
	*h = rangeHandlerOffsetFollowingEndDescDate{}
}

// rangeHandlerOffsetFollowingEndDescTimestamp is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndDescTimestamp struct {
	rangeOffsetHandlerBase
	offset duration.Duration
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndDescTimestamp{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndDescTimestamp) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   time.Time
		cmpResult int
	)
	col := vec.Timestamp()
	currRowVal := col.Get(vecIdx)
	t_res := duration.Add(currRowVal, h.offset.Mul(-1))
	rounded_res := t_res.Round(time.Microsecond)
	if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
		colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
	}
	seekVal = t_res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Timestamp()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				if cmpVal.Before(seekVal) {
					cmpResult = -1
				} else if seekVal.Before(cmpVal) {
					cmpResult = 1
				} else {
					cmpResult = 0
				}
				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndDescTimestamp) close() {
	*h = rangeHandlerOffsetFollowingEndDescTimestamp{}
}

// rangeHandlerOffsetFollowingEndDescDatum is a utility operator used to retrieve the location of
// the start or end bound for each row when in RANGE mode with an offset.
type rangeHandlerOffsetFollowingEndDescDatum struct {
	rangeOffsetHandlerBase
	overloadHelper colexecutils.BinaryOverloadHelper
	offset         tree.Datum
}

var _ rangeOffsetHandler = &rangeHandlerOffsetFollowingEndDescDatum{}

// getIdx provides an updated bound index for the current row given the
// location of the last bound index. It is called for the first row of each
// peer group. For example:
//
//	 ord col
//	 -------
//	    1
//	    2
//	    2
//	    3
//
//	currRow: 1
//	lastIdx: 0
//	offset:  1
//
// Assume we are calculating the end index for an ascending column. In this
// case, the value at the current row is '2' and the offset is '1' unit. So,
// getIdx will advance from the last end index (which is '0') until it reaches
// the first row for which the value is greater than 2 + 1 = 3, or the end of
// the partition, whichever comes first. In this case, the returned index would
// be '4' to indicate that the end index is the end of the partition.
func (h *rangeHandlerOffsetFollowingEndDescDatum) getIdx(ctx context.Context, currRow, lastIdx int) (idx int) {
	_overloadHelper := h.overloadHelper
	_ctx := ctx

	if lastIdx >= h.storedCols.Length() {
		return lastIdx
	}

	var vec *coldata.Vec
	var vecIdx, n int
	vec, vecIdx, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, currRow)

	// When the order column is null, the offset is ignored. The start index is
	// the first null value, and the end index is the end of the null group. All
	// null rows have the same start and end indices.
	if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
		// Since this function is only called for the first row of each peer group,
		// this is the first null row.
		idx = currRow
		// We need to scan beyond the last null to retrieve the end index.
		idx++
		for {
			if idx >= h.storedCols.Length() {
				break
			}
			vec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
			peersCol := vec.Bool()
			_, _ = peersCol[vecIdx], peersCol[n-1]
			for ; vecIdx < n; vecIdx++ {
				//gcassert:bce
				if peersCol[vecIdx] {
					return idx
				}
				idx++
			}
		}
		return idx
	}

	// The current row is not null. Retrieve the value that is equal to that at
	// the current row plus (minus if descending) 'offset' logical units.
	var (
		seekVal   tree.Datum
		cmpResult int
	)
	col := vec.Datum()
	currRowVal := col.Get(vecIdx)

	_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, currRowVal.(tree.Datum), h.offset.(tree.Datum))
	if err != nil {
		colexecerror.ExpectedError(err)
	}
	seekVal = _res

	// Pick up where the last index left off, since the start and indexes of each
	// successive window frame are non-decreasing as we increment the current row.
	// (This follows from the fact that offsets are required to be constants).
	idx = lastIdx

	// Scan to the next peer group and then compare to the value indicated by
	// the offset. If the comparison fails, scan again to the next peer group
	// and repeat.
	var peersVec *coldata.Vec
	for {
		if idx >= h.storedCols.Length() {
			break
		}
		peersVec, vecIdx, n = h.storedCols.GetVecWithTuple(ctx, h.peersColIdx, idx)
		vec, _, _ = h.storedCols.GetVecWithTuple(ctx, h.ordColIdx, idx)
		peersCol := peersVec.Bool()
		col = vec.Datum()
		_, _ = peersCol[vecIdx], peersCol[n-1]
		for ; vecIdx < n; vecIdx++ {
			//gcassert:bce
			if peersCol[vecIdx] {
				// Nulls and non-nulls are never part of the same window frame, which
				// means that this index must be the end of the current frame.
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(vecIdx) {
					return idx
				}
				cmpVal := col.Get(vecIdx)

				cmpResult = coldataext.CompareDatum(cmpVal, col, seekVal)

				if cmpResult < 0 {
					return idx
				}
			}
			idx++
		}
	}
	return idx
}

func (h *rangeHandlerOffsetFollowingEndDescDatum) close() {
	*h = rangeHandlerOffsetFollowingEndDescDatum{}
}

// startPartition resets the rangeOffsetHandler for use on the current
// partition.
func (b *rangeOffsetHandlerBase) startPartition(
	storedCols *colexecutils.SpillingBuffer, peersColIdx, ordColIdx int,
) {
	b.storedCols = storedCols
	b.peersColIdx = peersColIdx
	b.ordColIdx = ordColIdx
}

// decodeOffset decodes the given encoded offset into the given type.
func decodeOffset(
	datumAlloc *tree.DatumAlloc, orderColType *types.T, typedOffset []byte,
) interface{} {
	offsetType := getOffsetType(orderColType)
	datum, err := execinfra.DecodeDatum(datumAlloc, offsetType, typedOffset)
	if err != nil {
		colexecerror.InternalError(err)
	}
	switch typeconv.TypeFamilyToCanonicalTypeFamily(orderColType.Family()) {
	case typeconv.DatumVecCanonicalTypeFamily:
		return datum
	}
	typeConverter := colconv.GetDatumToPhysicalFn(offsetType)
	return typeConverter(datum)
}

// getOffsetType returns the offset type that corresponds to the given ordering
// column type.
func getOffsetType(orderColType *types.T) *types.T {
	if types.IsDateTimeType(orderColType) {
		return types.Interval
	}
	return orderColType
}
