// Code generated by execgen; DO NOT EDIT.
// Copyright 2021 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecwindow

import (
	"context"

	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexecutils"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecop"
	"github.com/cockroachdb/cockroach/pkg/sql/execinfrapb"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/builtins"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/errors"
)

// NewNthValueOperator creates a new Operator that computes window
// function nthValue. outputColIdx specifies in which coldata.Vec the operator
// should put its output (if there is no such column, a new column is appended).
func NewNthValueOperator(
	args *WindowArgs,
	frame *execinfrapb.WindowerSpec_Frame,
	ordering *execinfrapb.Ordering,
	argIdxs []int,
) (colexecop.ClosableOperator, error) {
	framer := newWindowFramer(args.EvalCtx, frame, ordering, args.InputTypes, args.PeersColIdx)
	colsToStore := framer.getColsToStore([]int{argIdxs[0]})

	// Allow the direct-access buffer 10% of the available memory. The rest will
	// be given to the bufferedWindowOp queue. While it is somewhat more important
	// for the direct-access buffer tuples to be kept in-memory, it only has to
	// store a single column. TODO(drewk): play around with benchmarks to find a
	// good empirically-supported fraction to use.
	bufferMemLimit := int64(float64(args.MemoryLimit) * 0.10)
	mainMemLimit := args.MemoryLimit - bufferMemLimit
	buffer := colexecutils.NewSpillingBuffer(
		args.BufferAllocator, bufferMemLimit, args.QueueCfg, args.FdSemaphore,
		args.InputTypes, args.DiskAcc, args.DiskQueueMemAcc, colsToStore...,
	)
	base := nthValueBase{
		partitionSeekerBase: partitionSeekerBase{
			buffer:          buffer,
			partitionColIdx: args.PartitionColIdx,
		},
		framer:       framer,
		outputColIdx: args.OutputColIdx,
		bufferArgIdx: 0, // The arg column is the first column in the buffer.
	}
	argType := args.InputTypes[argIdxs[0]]
	switch typeconv.TypeFamilyToCanonicalTypeFamily(argType.Family()) {
	case types.BoolFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &nthValueBoolWindow{nthValueBase: base}
			windower.nColIdx = argIdxs[1]
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case types.BytesFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &nthValueBytesWindow{nthValueBase: base}
			windower.nColIdx = argIdxs[1]
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case types.DecimalFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &nthValueDecimalWindow{nthValueBase: base}
			windower.nColIdx = argIdxs[1]
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case types.IntFamily:
		switch argType.Width() {
		case 16:
			windower := &nthValueInt16Window{nthValueBase: base}
			windower.nColIdx = argIdxs[1]
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		case 32:
			windower := &nthValueInt32Window{nthValueBase: base}
			windower.nColIdx = argIdxs[1]
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		case -1:
		default:
			windower := &nthValueInt64Window{nthValueBase: base}
			windower.nColIdx = argIdxs[1]
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case types.FloatFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &nthValueFloat64Window{nthValueBase: base}
			windower.nColIdx = argIdxs[1]
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case types.TimestampTZFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &nthValueTimestampWindow{nthValueBase: base}
			windower.nColIdx = argIdxs[1]
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case types.IntervalFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &nthValueIntervalWindow{nthValueBase: base}
			windower.nColIdx = argIdxs[1]
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case types.JsonFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &nthValueJSONWindow{nthValueBase: base}
			windower.nColIdx = argIdxs[1]
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &nthValueDatumWindow{nthValueBase: base}
			windower.nColIdx = argIdxs[1]
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	}
	return nil, errors.AssertionFailedf("unsupported nthValue window operator type %s", argType.Name())
}

type nthValueBase struct {
	partitionSeekerBase
	colexecop.CloserHelper
	framer windowFramer

	outputColIdx int
	bufferArgIdx int
}

type nthValueBoolWindow struct {
	nthValueBase
	nColIdx int
}

var _ bufferedWindower = &nthValueBoolWindow{}

// processBatch implements the bufferedWindower interface.
func (w *nthValueBoolWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Bool()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	nVec := batch.ColVec(w.nColIdx)
	nCol := nVec.Int64()
	nNulls := nVec.Nulls()
	_, _ = nCol[startIdx], nCol[endIdx-1]

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		if nNulls.MaybeHasNulls() && nNulls.NullAt(i) {
			// TODO(drewk): this could be pulled out of the loop, but for now keep the
			// templating simple.
			outputNulls.SetNull(i)
			continue
		}
		// gcassert:bce
		nVal := int(nCol[i])
		if nVal <= 0 {
			colexecerror.ExpectedError(builtins.ErrInvalidArgumentForNthValue)
		}
		requestedIdx := w.framer.frameNthIdx(nVal)
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Bool()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type nthValueBytesWindow struct {
	nthValueBase
	nColIdx int
}

var _ bufferedWindower = &nthValueBytesWindow{}

// processBatch implements the bufferedWindower interface.
func (w *nthValueBytesWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Bytes()
	outputNulls := outputVec.Nulls()

	nVec := batch.ColVec(w.nColIdx)
	nCol := nVec.Int64()
	nNulls := nVec.Nulls()
	_, _ = nCol[startIdx], nCol[endIdx-1]

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		if nNulls.MaybeHasNulls() && nNulls.NullAt(i) {
			// TODO(drewk): this could be pulled out of the loop, but for now keep the
			// templating simple.
			outputNulls.SetNull(i)
			continue
		}
		// gcassert:bce
		nVal := int(nCol[i])
		if nVal <= 0 {
			colexecerror.ExpectedError(builtins.ErrInvalidArgumentForNthValue)
		}
		requestedIdx := w.framer.frameNthIdx(nVal)
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Bytes()
		outputCol.Copy(col, i, idx)
	}
}

type nthValueDecimalWindow struct {
	nthValueBase
	nColIdx int
}

var _ bufferedWindower = &nthValueDecimalWindow{}

// processBatch implements the bufferedWindower interface.
func (w *nthValueDecimalWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Decimal()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	nVec := batch.ColVec(w.nColIdx)
	nCol := nVec.Int64()
	nNulls := nVec.Nulls()
	_, _ = nCol[startIdx], nCol[endIdx-1]

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		if nNulls.MaybeHasNulls() && nNulls.NullAt(i) {
			// TODO(drewk): this could be pulled out of the loop, but for now keep the
			// templating simple.
			outputNulls.SetNull(i)
			continue
		}
		// gcassert:bce
		nVal := int(nCol[i])
		if nVal <= 0 {
			colexecerror.ExpectedError(builtins.ErrInvalidArgumentForNthValue)
		}
		requestedIdx := w.framer.frameNthIdx(nVal)
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Decimal()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type nthValueInt16Window struct {
	nthValueBase
	nColIdx int
}

var _ bufferedWindower = &nthValueInt16Window{}

// processBatch implements the bufferedWindower interface.
func (w *nthValueInt16Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Int16()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	nVec := batch.ColVec(w.nColIdx)
	nCol := nVec.Int64()
	nNulls := nVec.Nulls()
	_, _ = nCol[startIdx], nCol[endIdx-1]

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		if nNulls.MaybeHasNulls() && nNulls.NullAt(i) {
			// TODO(drewk): this could be pulled out of the loop, but for now keep the
			// templating simple.
			outputNulls.SetNull(i)
			continue
		}
		// gcassert:bce
		nVal := int(nCol[i])
		if nVal <= 0 {
			colexecerror.ExpectedError(builtins.ErrInvalidArgumentForNthValue)
		}
		requestedIdx := w.framer.frameNthIdx(nVal)
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Int16()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type nthValueInt32Window struct {
	nthValueBase
	nColIdx int
}

var _ bufferedWindower = &nthValueInt32Window{}

// processBatch implements the bufferedWindower interface.
func (w *nthValueInt32Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Int32()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	nVec := batch.ColVec(w.nColIdx)
	nCol := nVec.Int64()
	nNulls := nVec.Nulls()
	_, _ = nCol[startIdx], nCol[endIdx-1]

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		if nNulls.MaybeHasNulls() && nNulls.NullAt(i) {
			// TODO(drewk): this could be pulled out of the loop, but for now keep the
			// templating simple.
			outputNulls.SetNull(i)
			continue
		}
		// gcassert:bce
		nVal := int(nCol[i])
		if nVal <= 0 {
			colexecerror.ExpectedError(builtins.ErrInvalidArgumentForNthValue)
		}
		requestedIdx := w.framer.frameNthIdx(nVal)
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Int32()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type nthValueInt64Window struct {
	nthValueBase
	nColIdx int
}

var _ bufferedWindower = &nthValueInt64Window{}

// processBatch implements the bufferedWindower interface.
func (w *nthValueInt64Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Int64()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	nVec := batch.ColVec(w.nColIdx)
	nCol := nVec.Int64()
	nNulls := nVec.Nulls()
	_, _ = nCol[startIdx], nCol[endIdx-1]

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		if nNulls.MaybeHasNulls() && nNulls.NullAt(i) {
			// TODO(drewk): this could be pulled out of the loop, but for now keep the
			// templating simple.
			outputNulls.SetNull(i)
			continue
		}
		// gcassert:bce
		nVal := int(nCol[i])
		if nVal <= 0 {
			colexecerror.ExpectedError(builtins.ErrInvalidArgumentForNthValue)
		}
		requestedIdx := w.framer.frameNthIdx(nVal)
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Int64()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type nthValueFloat64Window struct {
	nthValueBase
	nColIdx int
}

var _ bufferedWindower = &nthValueFloat64Window{}

// processBatch implements the bufferedWindower interface.
func (w *nthValueFloat64Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Float64()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	nVec := batch.ColVec(w.nColIdx)
	nCol := nVec.Int64()
	nNulls := nVec.Nulls()
	_, _ = nCol[startIdx], nCol[endIdx-1]

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		if nNulls.MaybeHasNulls() && nNulls.NullAt(i) {
			// TODO(drewk): this could be pulled out of the loop, but for now keep the
			// templating simple.
			outputNulls.SetNull(i)
			continue
		}
		// gcassert:bce
		nVal := int(nCol[i])
		if nVal <= 0 {
			colexecerror.ExpectedError(builtins.ErrInvalidArgumentForNthValue)
		}
		requestedIdx := w.framer.frameNthIdx(nVal)
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Float64()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type nthValueTimestampWindow struct {
	nthValueBase
	nColIdx int
}

var _ bufferedWindower = &nthValueTimestampWindow{}

// processBatch implements the bufferedWindower interface.
func (w *nthValueTimestampWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Timestamp()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	nVec := batch.ColVec(w.nColIdx)
	nCol := nVec.Int64()
	nNulls := nVec.Nulls()
	_, _ = nCol[startIdx], nCol[endIdx-1]

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		if nNulls.MaybeHasNulls() && nNulls.NullAt(i) {
			// TODO(drewk): this could be pulled out of the loop, but for now keep the
			// templating simple.
			outputNulls.SetNull(i)
			continue
		}
		// gcassert:bce
		nVal := int(nCol[i])
		if nVal <= 0 {
			colexecerror.ExpectedError(builtins.ErrInvalidArgumentForNthValue)
		}
		requestedIdx := w.framer.frameNthIdx(nVal)
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Timestamp()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type nthValueIntervalWindow struct {
	nthValueBase
	nColIdx int
}

var _ bufferedWindower = &nthValueIntervalWindow{}

// processBatch implements the bufferedWindower interface.
func (w *nthValueIntervalWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Interval()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	nVec := batch.ColVec(w.nColIdx)
	nCol := nVec.Int64()
	nNulls := nVec.Nulls()
	_, _ = nCol[startIdx], nCol[endIdx-1]

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		if nNulls.MaybeHasNulls() && nNulls.NullAt(i) {
			// TODO(drewk): this could be pulled out of the loop, but for now keep the
			// templating simple.
			outputNulls.SetNull(i)
			continue
		}
		// gcassert:bce
		nVal := int(nCol[i])
		if nVal <= 0 {
			colexecerror.ExpectedError(builtins.ErrInvalidArgumentForNthValue)
		}
		requestedIdx := w.framer.frameNthIdx(nVal)
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Interval()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type nthValueJSONWindow struct {
	nthValueBase
	nColIdx int
}

var _ bufferedWindower = &nthValueJSONWindow{}

// processBatch implements the bufferedWindower interface.
func (w *nthValueJSONWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.JSON()
	outputNulls := outputVec.Nulls()

	nVec := batch.ColVec(w.nColIdx)
	nCol := nVec.Int64()
	nNulls := nVec.Nulls()
	_, _ = nCol[startIdx], nCol[endIdx-1]

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		if nNulls.MaybeHasNulls() && nNulls.NullAt(i) {
			// TODO(drewk): this could be pulled out of the loop, but for now keep the
			// templating simple.
			outputNulls.SetNull(i)
			continue
		}
		// gcassert:bce
		nVal := int(nCol[i])
		if nVal <= 0 {
			colexecerror.ExpectedError(builtins.ErrInvalidArgumentForNthValue)
		}
		requestedIdx := w.framer.frameNthIdx(nVal)
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.JSON()
		outputCol.Copy(col, i, idx)
	}
}

type nthValueDatumWindow struct {
	nthValueBase
	nColIdx int
}

var _ bufferedWindower = &nthValueDatumWindow{}

// processBatch implements the bufferedWindower interface.
func (w *nthValueDatumWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Datum()
	outputNulls := outputVec.Nulls()

	nVec := batch.ColVec(w.nColIdx)
	nCol := nVec.Int64()
	nNulls := nVec.Nulls()
	_, _ = nCol[startIdx], nCol[endIdx-1]

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		if nNulls.MaybeHasNulls() && nNulls.NullAt(i) {
			// TODO(drewk): this could be pulled out of the loop, but for now keep the
			// templating simple.
			outputNulls.SetNull(i)
			continue
		}
		// gcassert:bce
		nVal := int(nCol[i])
		if nVal <= 0 {
			colexecerror.ExpectedError(builtins.ErrInvalidArgumentForNthValue)
		}
		requestedIdx := w.framer.frameNthIdx(nVal)
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Datum()
		val := col.Get(idx)
		outputCol.Set(i, val)
	}
}

// transitionToProcessing implements the bufferedWindower interface.
func (b *nthValueBase) transitionToProcessing() {
	b.framer.startPartition(b.Ctx, b.partitionSize, b.buffer)
}

// startNewPartition implements the bufferedWindower interface.
func (b *nthValueBase) startNewPartition() {
	b.partitionSize = 0
	b.buffer.Reset(b.Ctx)
}

// Init implements the bufferedWindower interface.
func (b *nthValueBase) Init(ctx context.Context) {
	if !b.InitHelper.Init(ctx) {
		return
	}
}

// Close implements the bufferedWindower interface.
func (b *nthValueBase) Close(ctx context.Context) {
	if !b.CloserHelper.Close() {
		return
	}
	b.buffer.Close(ctx)
}
