// Code generated by execgen; DO NOT EDIT.
// Copyright 2021 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecwindow

import (
	"bytes"
	"context"
	"math"
	"time"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexecutils"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecop"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
	"github.com/cockroachdb/cockroach/pkg/sql/memsize"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/cockroach/pkg/util/json"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ tree.AggType
	_ apd.Context
	_ duration.Duration
	_ json.JSON
	_ = coldataext.CompareDatum
	_ = colexecerror.InternalError
	_ = memsize.Uint32
)

const (
	// The argument column is always the first column in the SpillingBuffer.
	argColIdx = 0

	// The slice of uint32s in the deque can have up to 10,000 values (40KB).
	maxQueueLength = 10000
)

type minMaxRemovableAggBase struct {
	partitionSeekerBase
	colexecop.CloserHelper
	cancelChecker colexecutils.CancelChecker
	allocator     *colmem.Allocator
	outputColIdx  int
	framer        windowFramer

	// A partial deque of indices into the current partition ordered by the value
	// of the input column at each index. It contains only indices that are part
	// of the current window frame. The first value in the queue is the index of
	// the current value for the aggregation (NULL if empty). Under the
	// simplifying assumption that the window frame has no exclusion clause, the
	// queue does not need to contain any indices smaller than the best index -
	// this keeps the queue small in many common cases.
	queue minMaxQueue

	// omittedIndex tracks the index where we reached the limit of the length of
	// the queue, in which case we may be omitting values that could become
	// relevant as the frame shrinks. If the queue becomes empty while this
	// index is set, we have to aggregate over the previously omitted values.
	// The default (unset) value is -1.
	omittedIndex int

	scratchIntervals []windowInterval
}

// Init implements the bufferedWindower interface.
func (b *minMaxRemovableAggBase) Init(ctx context.Context) {
	b.InitHelper.Init(ctx)
	b.cancelChecker.Init(b.Ctx)
}

// transitionToProcessing implements the bufferedWindower interface.
func (b *minMaxRemovableAggBase) transitionToProcessing() {
	b.framer.startPartition(b.Ctx, b.partitionSize, b.buffer)
}

// startNewPartition implements the bufferedWindower interface.
func (b *minMaxRemovableAggBase) startNewPartition() {
	b.partitionSize = 0
	b.buffer.Reset(b.Ctx)
	b.queue.reset()
}

func newMinRemovableAggregator(
	args *WindowArgs, framer windowFramer, buffer *colexecutils.SpillingBuffer, argTyp *types.T,
) bufferedWindower {
	// Reserve the maximum memory usable by the queue up front to ensure that it
	// isn't used by the SpillingBuffer.
	args.BufferAllocator.AdjustMemoryUsage(maxQueueLength * memsize.Uint32)
	base := minMaxRemovableAggBase{
		partitionSeekerBase: partitionSeekerBase{
			partitionColIdx: args.PartitionColIdx,
			buffer:          buffer,
		},
		allocator:    args.MainAllocator,
		outputColIdx: args.OutputColIdx,
		framer:       framer,
		queue:        newMinMaxQueue(maxQueueLength),
		omittedIndex: -1,
	}
	switch typeconv.TypeFamilyToCanonicalTypeFamily(argTyp.Family()) {
	case types.BoolFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &minBoolAggregator{minMaxRemovableAggBase: base}
		}
	case types.BytesFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &minBytesAggregator{minMaxRemovableAggBase: base}
		}
	case types.DecimalFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &minDecimalAggregator{minMaxRemovableAggBase: base}
		}
	case types.IntFamily:
		switch argTyp.Width() {
		case 16:
			return &minInt16Aggregator{minMaxRemovableAggBase: base}
		case 32:
			return &minInt32Aggregator{minMaxRemovableAggBase: base}
		case -1:
		default:
			return &minInt64Aggregator{minMaxRemovableAggBase: base}
		}
	case types.FloatFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &minFloat64Aggregator{minMaxRemovableAggBase: base}
		}
	case types.TimestampTZFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &minTimestampAggregator{minMaxRemovableAggBase: base}
		}
	case types.IntervalFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &minIntervalAggregator{minMaxRemovableAggBase: base}
		}
	case types.JsonFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &minJSONAggregator{minMaxRemovableAggBase: base}
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &minDatumAggregator{minMaxRemovableAggBase: base}
		}
	}
	colexecerror.InternalError(
		errors.AssertionFailedf("unexpectedly didn't find min overload for %s type family", argTyp.Name()))
	// This code is unreachable, but the compiler cannot infer that.
	return nil
}

type minBoolAggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg bool
}

// processBatch implements the bufferedWindower interface.
func (a *minBoolAggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Bool()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Bool()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *minBoolAggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Bool()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						if !val && a.curAgg {
							cmpResult = -1
						} else if val && !a.curAgg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult < 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy bool
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Bool().Get(cmpIdx)

						{
							var cmpResult int

							if !cmpVal && valCopy {
								cmpResult = -1
							} else if cmpVal && !valCopy {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							cmp = cmpResult < 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *minBoolAggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = minBoolAggregator{}
}

type minBytesAggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg []byte
}

// processBatch implements the bufferedWindower interface.
func (a *minBytesAggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Bytes()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Bytes()
						val := col.Get(idx)
						a.curAgg = append(a.curAgg[:0], val...)
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *minBytesAggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Bytes()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int
						cmpResult = bytes.Compare(val, a.curAgg)
						cmp = cmpResult < 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = append(a.curAgg[:0], val...)
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy []byte
					valCopy = append(valCopy[:0], val...)
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Bytes().Get(cmpIdx)

						{
							var cmpResult int
							cmpResult = bytes.Compare(cmpVal, valCopy)
							cmp = cmpResult < 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *minBytesAggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = minBytesAggregator{}
}

type minDecimalAggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg apd.Decimal
}

// processBatch implements the bufferedWindower interface.
func (a *minDecimalAggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Decimal()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Decimal()
						val := col.Get(idx)
						a.curAgg.Set(&val)
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *minDecimalAggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Decimal()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&val, &a.curAgg)
						cmp = cmpResult < 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg.Set(&val)
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy apd.Decimal
					valCopy.Set(&val)
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Decimal().Get(cmpIdx)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&cmpVal, &valCopy)
							cmp = cmpResult < 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *minDecimalAggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = minDecimalAggregator{}
}

type minInt16Aggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg int16
}

// processBatch implements the bufferedWindower interface.
func (a *minInt16Aggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Int16()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Int16()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *minInt16Aggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Int16()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						{
							a, b := int64(val), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy int16
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Int16().Get(cmpIdx)

						{
							var cmpResult int

							{
								a, b := int64(cmpVal), int64(valCopy)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							cmp = cmpResult < 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *minInt16Aggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = minInt16Aggregator{}
}

type minInt32Aggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg int32
}

// processBatch implements the bufferedWindower interface.
func (a *minInt32Aggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Int32()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Int32()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *minInt32Aggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Int32()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						{
							a, b := int64(val), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy int32
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Int32().Get(cmpIdx)

						{
							var cmpResult int

							{
								a, b := int64(cmpVal), int64(valCopy)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							cmp = cmpResult < 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *minInt32Aggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = minInt32Aggregator{}
}

type minInt64Aggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg int64
}

// processBatch implements the bufferedWindower interface.
func (a *minInt64Aggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Int64()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Int64()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *minInt64Aggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Int64()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						{
							a, b := int64(val), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy int64
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Int64().Get(cmpIdx)

						{
							var cmpResult int

							{
								a, b := int64(cmpVal), int64(valCopy)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							cmp = cmpResult < 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *minInt64Aggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = minInt64Aggregator{}
}

type minFloat64Aggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg float64
}

// processBatch implements the bufferedWindower interface.
func (a *minFloat64Aggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Float64()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Float64()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *minFloat64Aggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Float64()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						{
							a, b := float64(val), float64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy float64
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Float64().Get(cmpIdx)

						{
							var cmpResult int

							{
								a, b := float64(cmpVal), float64(valCopy)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							cmp = cmpResult < 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *minFloat64Aggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = minFloat64Aggregator{}
}

type minTimestampAggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg time.Time
}

// processBatch implements the bufferedWindower interface.
func (a *minTimestampAggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Timestamp()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Timestamp()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *minTimestampAggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Timestamp()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						if val.Before(a.curAgg) {
							cmpResult = -1
						} else if a.curAgg.Before(val) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult < 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy time.Time
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Timestamp().Get(cmpIdx)

						{
							var cmpResult int

							if cmpVal.Before(valCopy) {
								cmpResult = -1
							} else if valCopy.Before(cmpVal) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							cmp = cmpResult < 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *minTimestampAggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = minTimestampAggregator{}
}

type minIntervalAggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg duration.Duration
}

// processBatch implements the bufferedWindower interface.
func (a *minIntervalAggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Interval()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Interval()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *minIntervalAggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Interval()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int
						cmpResult = val.Compare(a.curAgg)
						cmp = cmpResult < 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy duration.Duration
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Interval().Get(cmpIdx)

						{
							var cmpResult int
							cmpResult = cmpVal.Compare(valCopy)
							cmp = cmpResult < 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *minIntervalAggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = minIntervalAggregator{}
}

type minJSONAggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg json.JSON
}

// processBatch implements the bufferedWindower interface.
func (a *minJSONAggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.JSON()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.JSON()
						val := col.Get(idx)

						var _err error
						var _bytes []byte
						_bytes, _err = json.EncodeJSON(nil, val)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						a.curAgg, _err = json.FromEncoding(_bytes)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *minJSONAggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.JSON()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						var err error
						cmpResult, err = val.Compare(a.curAgg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)

					var _err error
					var _bytes []byte
					_bytes, _err = json.EncodeJSON(nil, val)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					a.curAgg, _err = json.FromEncoding(_bytes)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}

					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy json.JSON

					var _err error
					var _bytes []byte
					_bytes, _err = json.EncodeJSON(nil, val)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					valCopy, _err = json.FromEncoding(_bytes)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}

					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.JSON().Get(cmpIdx)

						{
							var cmpResult int

							var err error
							cmpResult, err = cmpVal.Compare(valCopy)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							cmp = cmpResult < 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *minJSONAggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = minJSONAggregator{}
}

type minDatumAggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg interface{}
}

// processBatch implements the bufferedWindower interface.
func (a *minDatumAggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Datum()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Datum()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *minDatumAggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Datum()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(val, col, a.curAgg)

						cmp = cmpResult < 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy interface{}
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Datum().Get(cmpIdx)

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(cmpVal, col, valCopy)

							cmp = cmpResult < 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *minDatumAggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = minDatumAggregator{}
}

func newMaxRemovableAggregator(
	args *WindowArgs, framer windowFramer, buffer *colexecutils.SpillingBuffer, argTyp *types.T,
) bufferedWindower {
	// Reserve the maximum memory usable by the queue up front to ensure that it
	// isn't used by the SpillingBuffer.
	args.BufferAllocator.AdjustMemoryUsage(maxQueueLength * memsize.Uint32)
	base := minMaxRemovableAggBase{
		partitionSeekerBase: partitionSeekerBase{
			partitionColIdx: args.PartitionColIdx,
			buffer:          buffer,
		},
		allocator:    args.MainAllocator,
		outputColIdx: args.OutputColIdx,
		framer:       framer,
		queue:        newMinMaxQueue(maxQueueLength),
		omittedIndex: -1,
	}
	switch typeconv.TypeFamilyToCanonicalTypeFamily(argTyp.Family()) {
	case types.BoolFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &maxBoolAggregator{minMaxRemovableAggBase: base}
		}
	case types.BytesFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &maxBytesAggregator{minMaxRemovableAggBase: base}
		}
	case types.DecimalFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &maxDecimalAggregator{minMaxRemovableAggBase: base}
		}
	case types.IntFamily:
		switch argTyp.Width() {
		case 16:
			return &maxInt16Aggregator{minMaxRemovableAggBase: base}
		case 32:
			return &maxInt32Aggregator{minMaxRemovableAggBase: base}
		case -1:
		default:
			return &maxInt64Aggregator{minMaxRemovableAggBase: base}
		}
	case types.FloatFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &maxFloat64Aggregator{minMaxRemovableAggBase: base}
		}
	case types.TimestampTZFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &maxTimestampAggregator{minMaxRemovableAggBase: base}
		}
	case types.IntervalFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &maxIntervalAggregator{minMaxRemovableAggBase: base}
		}
	case types.JsonFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &maxJSONAggregator{minMaxRemovableAggBase: base}
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch argTyp.Width() {
		case -1:
		default:
			return &maxDatumAggregator{minMaxRemovableAggBase: base}
		}
	}
	colexecerror.InternalError(
		errors.AssertionFailedf("unexpectedly didn't find max overload for %s type family", argTyp.Name()))
	// This code is unreachable, but the compiler cannot infer that.
	return nil
}

type maxBoolAggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg bool
}

// processBatch implements the bufferedWindower interface.
func (a *maxBoolAggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Bool()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Bool()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *maxBoolAggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Bool()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						if !val && a.curAgg {
							cmpResult = -1
						} else if val && !a.curAgg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult > 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy bool
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Bool().Get(cmpIdx)

						{
							var cmpResult int

							if !cmpVal && valCopy {
								cmpResult = -1
							} else if cmpVal && !valCopy {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							cmp = cmpResult > 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *maxBoolAggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = maxBoolAggregator{}
}

type maxBytesAggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg []byte
}

// processBatch implements the bufferedWindower interface.
func (a *maxBytesAggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Bytes()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Bytes()
						val := col.Get(idx)
						a.curAgg = append(a.curAgg[:0], val...)
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *maxBytesAggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Bytes()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int
						cmpResult = bytes.Compare(val, a.curAgg)
						cmp = cmpResult > 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = append(a.curAgg[:0], val...)
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy []byte
					valCopy = append(valCopy[:0], val...)
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Bytes().Get(cmpIdx)

						{
							var cmpResult int
							cmpResult = bytes.Compare(cmpVal, valCopy)
							cmp = cmpResult > 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *maxBytesAggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = maxBytesAggregator{}
}

type maxDecimalAggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg apd.Decimal
}

// processBatch implements the bufferedWindower interface.
func (a *maxDecimalAggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Decimal()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Decimal()
						val := col.Get(idx)
						a.curAgg.Set(&val)
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *maxDecimalAggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Decimal()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&val, &a.curAgg)
						cmp = cmpResult > 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg.Set(&val)
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy apd.Decimal
					valCopy.Set(&val)
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Decimal().Get(cmpIdx)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&cmpVal, &valCopy)
							cmp = cmpResult > 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *maxDecimalAggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = maxDecimalAggregator{}
}

type maxInt16Aggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg int16
}

// processBatch implements the bufferedWindower interface.
func (a *maxInt16Aggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Int16()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Int16()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *maxInt16Aggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Int16()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						{
							a, b := int64(val), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy int16
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Int16().Get(cmpIdx)

						{
							var cmpResult int

							{
								a, b := int64(cmpVal), int64(valCopy)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							cmp = cmpResult > 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *maxInt16Aggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = maxInt16Aggregator{}
}

type maxInt32Aggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg int32
}

// processBatch implements the bufferedWindower interface.
func (a *maxInt32Aggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Int32()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Int32()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *maxInt32Aggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Int32()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						{
							a, b := int64(val), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy int32
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Int32().Get(cmpIdx)

						{
							var cmpResult int

							{
								a, b := int64(cmpVal), int64(valCopy)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							cmp = cmpResult > 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *maxInt32Aggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = maxInt32Aggregator{}
}

type maxInt64Aggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg int64
}

// processBatch implements the bufferedWindower interface.
func (a *maxInt64Aggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Int64()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Int64()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *maxInt64Aggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Int64()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						{
							a, b := int64(val), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy int64
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Int64().Get(cmpIdx)

						{
							var cmpResult int

							{
								a, b := int64(cmpVal), int64(valCopy)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							cmp = cmpResult > 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *maxInt64Aggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = maxInt64Aggregator{}
}

type maxFloat64Aggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg float64
}

// processBatch implements the bufferedWindower interface.
func (a *maxFloat64Aggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Float64()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Float64()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *maxFloat64Aggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Float64()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						{
							a, b := float64(val), float64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy float64
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Float64().Get(cmpIdx)

						{
							var cmpResult int

							{
								a, b := float64(cmpVal), float64(valCopy)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							cmp = cmpResult > 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *maxFloat64Aggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = maxFloat64Aggregator{}
}

type maxTimestampAggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg time.Time
}

// processBatch implements the bufferedWindower interface.
func (a *maxTimestampAggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Timestamp()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Timestamp()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *maxTimestampAggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Timestamp()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						if val.Before(a.curAgg) {
							cmpResult = -1
						} else if a.curAgg.Before(val) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult > 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy time.Time
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Timestamp().Get(cmpIdx)

						{
							var cmpResult int

							if cmpVal.Before(valCopy) {
								cmpResult = -1
							} else if valCopy.Before(cmpVal) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							cmp = cmpResult > 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *maxTimestampAggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = maxTimestampAggregator{}
}

type maxIntervalAggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg duration.Duration
}

// processBatch implements the bufferedWindower interface.
func (a *maxIntervalAggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Interval()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Interval()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *maxIntervalAggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Interval()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int
						cmpResult = val.Compare(a.curAgg)
						cmp = cmpResult > 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy duration.Duration
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Interval().Get(cmpIdx)

						{
							var cmpResult int
							cmpResult = cmpVal.Compare(valCopy)
							cmp = cmpResult > 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *maxIntervalAggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = maxIntervalAggregator{}
}

type maxJSONAggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg json.JSON
}

// processBatch implements the bufferedWindower interface.
func (a *maxJSONAggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.JSON()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.JSON()
						val := col.Get(idx)

						var _err error
						var _bytes []byte
						_bytes, _err = json.EncodeJSON(nil, val)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						a.curAgg, _err = json.FromEncoding(_bytes)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *maxJSONAggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.JSON()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						var err error
						cmpResult, err = val.Compare(a.curAgg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)

					var _err error
					var _bytes []byte
					_bytes, _err = json.EncodeJSON(nil, val)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					a.curAgg, _err = json.FromEncoding(_bytes)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}

					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy json.JSON

					var _err error
					var _bytes []byte
					_bytes, _err = json.EncodeJSON(nil, val)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					valCopy, _err = json.FromEncoding(_bytes)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}

					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.JSON().Get(cmpIdx)

						{
							var cmpResult int

							var err error
							cmpResult, err = cmpVal.Compare(valCopy)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							cmp = cmpResult > 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *maxJSONAggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = maxJSONAggregator{}
}

type maxDatumAggregator struct {
	minMaxRemovableAggBase
	// curAgg holds the running min/max, so we can index into the output column
	// once per row, instead of on each iteration.
	// NOTE: if the length of the queue is zero, curAgg is undefined.
	curAgg interface{}
}

// processBatch implements the bufferedWindower interface.
func (a *maxDatumAggregator) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if endIdx <= startIdx {
		// There is no processing to be done.
		return
	}
	outVec := batch.ColVec(a.outputColIdx)
	outNulls := outVec.Nulls()
	outCol := outVec.Datum()
	a.allocator.PerformOperation([]*coldata.Vec{outVec}, func() {
		_, _ = outCol.Get(startIdx), outCol.Get(endIdx-1)
		for i := startIdx; i < endIdx; i++ {
			a.framer.next(a.Ctx)
			toAdd, toRemove := a.framer.slidingWindowIntervals()

			// Process the toRemove intervals first.
			if !a.queue.isEmpty() {
				prevBestIdx := a.queue.getFirst()
				for _, interval := range toRemove {
					if uint32(interval.start) > a.queue.getFirst() {
						colexecerror.InternalError(errors.AssertionFailedf(
							"expected default exclusion clause for min/max sliding window operator"))
					}
					a.queue.removeAllBefore(uint32(interval.end))
				}
				if !a.queue.isEmpty() {
					newBestIdx := a.queue.getFirst()
					if newBestIdx != prevBestIdx {
						// We need to update curAgg.
						vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(newBestIdx))
						col := vec.Datum()
						val := col.Get(idx)
						a.curAgg = val
					}
				}
			}

			// Now aggregate over the toAdd intervals.
			if a.queue.isEmpty() && a.omittedIndex != -1 {
				// We have exhausted all the values that fit in the queue - we need to
				// re-aggregate over the current window frame starting from the first
				// omitted index.
				a.scratchIntervals = getIntervalsGEIdx(
					a.framer.frameIntervals(), a.scratchIntervals, a.omittedIndex)
				a.omittedIndex = -1
				a.aggregateOverIntervals(a.scratchIntervals)
			} else {
				a.aggregateOverIntervals(toAdd)
			}

			// Set the output value for the current row.
			if a.queue.isEmpty() {
				outNulls.SetNull(i)
			} else {
				// gcassert:bce
				outCol.Set(i, a.curAgg)
			}
		}
	})
}

// aggregateOverIntervals accumulates all rows represented by the given
// intervals into the current aggregate.
func (a *maxDatumAggregator) aggregateOverIntervals(intervals []windowInterval) {
	for _, interval := range intervals {
		var cmp bool
		for j := interval.start; j < interval.end; j++ {
			a.cancelChecker.Check()
			idxToAdd := uint32(j)
			vec, idx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, j)
			nulls := vec.Nulls()
			col := vec.Datum()
			if !nulls.MaybeHasNulls() || !nulls.NullAt(idx) {
				val := col.Get(idx)

				// If this is the first value in the frame, it is the best so far.
				isBest := a.queue.isEmpty()
				if !a.queue.isEmpty() {
					// Compare to the best value seen so far.

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(val, col, a.curAgg)

						cmp = cmpResult > 0
					}

					if cmp {
						// Reset the queue because the current value replaces all others.
						isBest = true
						a.queue.reset()
					}
					isBest = cmp
				}
				if isBest {
					// The queue is already empty, so just add to the end of the queue.
					// If any values were omitted from the queue, they would be dominated
					// by this one anyway, so reset omittedIndex.
					a.queue.addLast(idxToAdd)
					a.curAgg = val
					a.omittedIndex = -1
					continue
				}

				// This is not the best value in the window frame, but we still need to
				// keep it in the queue. Iterate from the end of the queue, removing any
				// values that are dominated by the current one. Add the current value
				// once the last value in the queue is better than the current one.
				if !a.queue.isEmpty() {
					// We have to make a copy of val because GetVecWithTuple
					// calls below might reuse the same underlying vector.
					var valCopy interface{}
					valCopy = val
					for !a.queue.isEmpty() {
						cmpVec, cmpIdx, _ := a.buffer.GetVecWithTuple(a.Ctx, argColIdx, int(a.queue.getLast()))
						cmpVal := cmpVec.Datum().Get(cmpIdx)

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(cmpVal, col, valCopy)

							cmp = cmpResult > 0
						}

						if cmp {
							break
						}
						// Any values that could not fit in the queue would also have been
						// dominated by the current one, so reset omittedIndex.
						a.queue.removeLast()
						a.omittedIndex = -1
					}
				}
				if a.queue.addLast(idxToAdd) && a.omittedIndex == -1 {
					// The value couldn't fit in the queue. Keep track of the first index
					// from which the queue could no longer store values.
					a.omittedIndex = j
				}
			}
		}
	}
}

func (a *maxDatumAggregator) Close(ctx context.Context) {
	a.queue.close()
	a.framer.close()
	a.buffer.Close(ctx)
	*a = maxDatumAggregator{}
}

// getIntervalsGEIdx returns a set of intervals representing all indexes in the
// 'intervals' slice at or after the given index.
func getIntervalsGEIdx(intervals, scratch []windowInterval, idx int) []windowInterval {
	scratch = scratch[:0]
	for _, interval := range intervals {
		if interval.end <= idx {
			continue
		}
		if interval.start >= idx {
			scratch = append(scratch, interval)
			continue
		}
		scratch = append(scratch, windowInterval{start: idx, end: interval.end})
	}
	return scratch
}
