// Code generated by execgen; DO NOT EDIT.
// Copyright 2021 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecwindow

import (
	"context"

	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexecutils"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecop"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/errors"
)

// NewLeadOperator creates a new Operator that computes window
// function lead. outputColIdx specifies in which coldata.Vec the operator
// should put its output (if there is no such column, a new column is appended).
func NewLeadOperator(
	args *WindowArgs, argIdx int, offsetIdx int, defaultIdx int,
) (colexecop.ClosableOperator, error) {
	// Allow the direct-access buffer 10% of the available memory. The rest will
	// be given to the bufferedWindowOp queue. While it is somewhat more important
	// for the direct-access buffer tuples to be kept in-memory, it only has to
	// store a single column. TODO(drewk): play around with benchmarks to find a
	// good empirically-supported fraction to use.
	bufferMemLimit := int64(float64(args.MemoryLimit) * 0.10)
	mainMemLimit := args.MemoryLimit - bufferMemLimit
	buffer := colexecutils.NewSpillingBuffer(
		args.BufferAllocator, bufferMemLimit, args.QueueCfg, args.FdSemaphore,
		args.InputTypes, args.DiskAcc, args.DiskQueueMemAcc, argIdx,
	)
	base := leadBase{
		partitionSeekerBase: partitionSeekerBase{
			buffer:          buffer,
			partitionColIdx: args.PartitionColIdx,
		},
		outputColIdx: args.OutputColIdx,
		argIdx:       argIdx,
		offsetIdx:    offsetIdx,
		defaultIdx:   defaultIdx,
	}
	argType := args.InputTypes[argIdx]
	switch typeconv.TypeFamilyToCanonicalTypeFamily(argType.Family()) {
	case types.BoolFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &leadBoolWindow{leadBase: base}, argType, mainMemLimit), nil
		}
	case types.BytesFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &leadBytesWindow{leadBase: base}, argType, mainMemLimit), nil
		}
	case types.DecimalFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &leadDecimalWindow{leadBase: base}, argType, mainMemLimit), nil
		}
	case types.IntFamily:
		switch argType.Width() {
		case 16:
			return newBufferedWindowOperator(
				args, &leadInt16Window{leadBase: base}, argType, mainMemLimit), nil
		case 32:
			return newBufferedWindowOperator(
				args, &leadInt32Window{leadBase: base}, argType, mainMemLimit), nil
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &leadInt64Window{leadBase: base}, argType, mainMemLimit), nil
		}
	case types.FloatFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &leadFloat64Window{leadBase: base}, argType, mainMemLimit), nil
		}
	case types.TimestampTZFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &leadTimestampWindow{leadBase: base}, argType, mainMemLimit), nil
		}
	case types.IntervalFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &leadIntervalWindow{leadBase: base}, argType, mainMemLimit), nil
		}
	case types.JsonFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &leadJSONWindow{leadBase: base}, argType, mainMemLimit), nil
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &leadDatumWindow{leadBase: base}, argType, mainMemLimit), nil
		}
	}
	return nil, errors.AssertionFailedf("unsupported lead window operator type %s", argType.Name())
}

// leadBase extracts common fields and methods of the lead windower
// variations.
type leadBase struct {
	partitionSeekerBase
	colexecop.CloserHelper
	leadComputeFields

	outputColIdx    int
	partitionColIdx int
	argIdx          int
	offsetIdx       int
	defaultIdx      int
}

// leadComputeFields extracts the fields that are used to calculate lead
// output values.
type leadComputeFields struct {
	idx int
}

type leadBoolWindow struct {
	leadBase
}

var _ bufferedWindower = &leadBoolWindow{}

func (w *leadBoolWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Bool()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Bool()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx + int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Bool()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Bool()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Bool()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx + int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Bool()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type leadBytesWindow struct {
	leadBase
}

var _ bufferedWindower = &leadBytesWindow{}

func (w *leadBytesWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Bytes()
	leadLagNulls := leadLagVec.Nulls()

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Bytes()
	defaultNulls := defaultVec.Nulls()

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx + int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					leadLagCol.Copy(defaultCol, i, i)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Bytes()
				leadLagCol.Copy(col, i, idx)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				leadLagCol.Copy(defaultCol, i, i)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Bytes()
			leadLagCol.Copy(col, i, idx)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				leadLagCol.Copy(defaultCol, i, i)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Bytes()
			leadLagCol.Copy(col, i, idx)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx + int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			leadLagCol.Copy(defaultCol, i, i)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Bytes()
		leadLagCol.Copy(col, i, idx)
	}
}

type leadDecimalWindow struct {
	leadBase
}

var _ bufferedWindower = &leadDecimalWindow{}

func (w *leadDecimalWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Decimal()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Decimal()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx + int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Decimal()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Decimal()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Decimal()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx + int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Decimal()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type leadInt16Window struct {
	leadBase
}

var _ bufferedWindower = &leadInt16Window{}

func (w *leadInt16Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Int16()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Int16()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx + int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Int16()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Int16()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Int16()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx + int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Int16()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type leadInt32Window struct {
	leadBase
}

var _ bufferedWindower = &leadInt32Window{}

func (w *leadInt32Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Int32()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Int32()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx + int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Int32()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Int32()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Int32()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx + int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Int32()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type leadInt64Window struct {
	leadBase
}

var _ bufferedWindower = &leadInt64Window{}

func (w *leadInt64Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Int64()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Int64()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx + int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Int64()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Int64()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Int64()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx + int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Int64()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type leadFloat64Window struct {
	leadBase
}

var _ bufferedWindower = &leadFloat64Window{}

func (w *leadFloat64Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Float64()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Float64()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx + int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Float64()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Float64()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Float64()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx + int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Float64()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type leadTimestampWindow struct {
	leadBase
}

var _ bufferedWindower = &leadTimestampWindow{}

func (w *leadTimestampWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Timestamp()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Timestamp()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx + int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Timestamp()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Timestamp()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Timestamp()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx + int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Timestamp()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type leadIntervalWindow struct {
	leadBase
}

var _ bufferedWindower = &leadIntervalWindow{}

func (w *leadIntervalWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Interval()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Interval()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx + int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Interval()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Interval()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Interval()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx + int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Interval()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type leadJSONWindow struct {
	leadBase
}

var _ bufferedWindower = &leadJSONWindow{}

func (w *leadJSONWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.JSON()
	leadLagNulls := leadLagVec.Nulls()

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.JSON()
	defaultNulls := defaultVec.Nulls()

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx + int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					leadLagCol.Copy(defaultCol, i, i)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.JSON()
				leadLagCol.Copy(col, i, idx)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				leadLagCol.Copy(defaultCol, i, i)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.JSON()
			leadLagCol.Copy(col, i, idx)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				leadLagCol.Copy(defaultCol, i, i)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.JSON()
			leadLagCol.Copy(col, i, idx)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx + int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			leadLagCol.Copy(defaultCol, i, i)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.JSON()
		leadLagCol.Copy(col, i, idx)
	}
}

type leadDatumWindow struct {
	leadBase
}

var _ bufferedWindower = &leadDatumWindow{}

func (w *leadDatumWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Datum()
	leadLagNulls := leadLagVec.Nulls()

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Datum()
	defaultNulls := defaultVec.Nulls()

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx + int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Datum()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Datum()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx + int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Datum()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx + int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Datum()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

func (b *leadBase) transitionToProcessing() {}

func (b *leadBase) startNewPartition() {
	b.idx = 0
	b.partitionSize = 0
	b.buffer.Reset(b.Ctx)
}

func (b *leadBase) Init(ctx context.Context) {
	if !b.InitHelper.Init(ctx) {
		return
	}
}

func (b *leadBase) Close(ctx context.Context) {
	if !b.CloserHelper.Close() {
		return
	}
	b.buffer.Close(ctx)
}
