// Code generated by execgen; DO NOT EDIT.
// Copyright 2021 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecwindow

import (
	"context"

	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexecutils"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecop"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/errors"
)

// NewLagOperator creates a new Operator that computes window
// function lag. outputColIdx specifies in which coldata.Vec the operator
// should put its output (if there is no such column, a new column is appended).
func NewLagOperator(
	args *WindowArgs, argIdx int, offsetIdx int, defaultIdx int,
) (colexecop.ClosableOperator, error) {
	// Allow the direct-access buffer 10% of the available memory. The rest will
	// be given to the bufferedWindowOp queue. While it is somewhat more important
	// for the direct-access buffer tuples to be kept in-memory, it only has to
	// store a single column. TODO(drewk): play around with benchmarks to find a
	// good empirically-supported fraction to use.
	bufferMemLimit := int64(float64(args.MemoryLimit) * 0.10)
	mainMemLimit := args.MemoryLimit - bufferMemLimit
	buffer := colexecutils.NewSpillingBuffer(
		args.BufferAllocator, bufferMemLimit, args.QueueCfg, args.FdSemaphore,
		args.InputTypes, args.DiskAcc, args.DiskQueueMemAcc, argIdx,
	)
	base := lagBase{
		partitionSeekerBase: partitionSeekerBase{
			buffer:          buffer,
			partitionColIdx: args.PartitionColIdx,
		},
		outputColIdx: args.OutputColIdx,
		argIdx:       argIdx,
		offsetIdx:    offsetIdx,
		defaultIdx:   defaultIdx,
	}
	argType := args.InputTypes[argIdx]
	switch typeconv.TypeFamilyToCanonicalTypeFamily(argType.Family()) {
	case types.BoolFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &lagBoolWindow{lagBase: base}, argType, mainMemLimit), nil
		}
	case types.BytesFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &lagBytesWindow{lagBase: base}, argType, mainMemLimit), nil
		}
	case types.DecimalFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &lagDecimalWindow{lagBase: base}, argType, mainMemLimit), nil
		}
	case types.IntFamily:
		switch argType.Width() {
		case 16:
			return newBufferedWindowOperator(
				args, &lagInt16Window{lagBase: base}, argType, mainMemLimit), nil
		case 32:
			return newBufferedWindowOperator(
				args, &lagInt32Window{lagBase: base}, argType, mainMemLimit), nil
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &lagInt64Window{lagBase: base}, argType, mainMemLimit), nil
		}
	case types.FloatFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &lagFloat64Window{lagBase: base}, argType, mainMemLimit), nil
		}
	case types.TimestampTZFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &lagTimestampWindow{lagBase: base}, argType, mainMemLimit), nil
		}
	case types.IntervalFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &lagIntervalWindow{lagBase: base}, argType, mainMemLimit), nil
		}
	case types.JsonFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &lagJSONWindow{lagBase: base}, argType, mainMemLimit), nil
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch argType.Width() {
		case -1:
		default:
			return newBufferedWindowOperator(
				args, &lagDatumWindow{lagBase: base}, argType, mainMemLimit), nil
		}
	}
	return nil, errors.AssertionFailedf("unsupported lag window operator type %s", argType.Name())
}

// lagBase extracts common fields and methods of the lag windower
// variations.
type lagBase struct {
	partitionSeekerBase
	colexecop.CloserHelper
	lagComputeFields

	outputColIdx    int
	partitionColIdx int
	argIdx          int
	offsetIdx       int
	defaultIdx      int
}

// lagComputeFields extracts the fields that are used to calculate lag
// output values.
type lagComputeFields struct {
	idx int
}

type lagBoolWindow struct {
	lagBase
}

var _ bufferedWindower = &lagBoolWindow{}

func (w *lagBoolWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Bool()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Bool()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx - int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Bool()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Bool()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Bool()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx - int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Bool()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type lagBytesWindow struct {
	lagBase
}

var _ bufferedWindower = &lagBytesWindow{}

func (w *lagBytesWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Bytes()
	leadLagNulls := leadLagVec.Nulls()

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Bytes()
	defaultNulls := defaultVec.Nulls()

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx - int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					leadLagCol.Copy(defaultCol, i, i)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Bytes()
				leadLagCol.Copy(col, i, idx)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				leadLagCol.Copy(defaultCol, i, i)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Bytes()
			leadLagCol.Copy(col, i, idx)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				leadLagCol.Copy(defaultCol, i, i)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Bytes()
			leadLagCol.Copy(col, i, idx)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx - int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			leadLagCol.Copy(defaultCol, i, i)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Bytes()
		leadLagCol.Copy(col, i, idx)
	}
}

type lagDecimalWindow struct {
	lagBase
}

var _ bufferedWindower = &lagDecimalWindow{}

func (w *lagDecimalWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Decimal()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Decimal()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx - int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Decimal()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Decimal()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Decimal()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx - int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Decimal()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type lagInt16Window struct {
	lagBase
}

var _ bufferedWindower = &lagInt16Window{}

func (w *lagInt16Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Int16()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Int16()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx - int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Int16()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Int16()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Int16()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx - int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Int16()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type lagInt32Window struct {
	lagBase
}

var _ bufferedWindower = &lagInt32Window{}

func (w *lagInt32Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Int32()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Int32()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx - int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Int32()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Int32()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Int32()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx - int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Int32()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type lagInt64Window struct {
	lagBase
}

var _ bufferedWindower = &lagInt64Window{}

func (w *lagInt64Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Int64()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Int64()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx - int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Int64()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Int64()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Int64()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx - int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Int64()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type lagFloat64Window struct {
	lagBase
}

var _ bufferedWindower = &lagFloat64Window{}

func (w *lagFloat64Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Float64()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Float64()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx - int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Float64()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Float64()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Float64()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx - int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Float64()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type lagTimestampWindow struct {
	lagBase
}

var _ bufferedWindower = &lagTimestampWindow{}

func (w *lagTimestampWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Timestamp()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Timestamp()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx - int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Timestamp()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Timestamp()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Timestamp()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx - int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Timestamp()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type lagIntervalWindow struct {
	lagBase
}

var _ bufferedWindower = &lagIntervalWindow{}

func (w *lagIntervalWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Interval()
	leadLagNulls := leadLagVec.Nulls()
	_ = leadLagCol.Get(startIdx)
	_ = leadLagCol.Get(endIdx - 1)

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Interval()
	defaultNulls := defaultVec.Nulls()
	_ = defaultCol.Get(startIdx)
	_ = defaultCol.Get(endIdx - 1)

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx - int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Interval()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Interval()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Interval()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx - int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Interval()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

type lagJSONWindow struct {
	lagBase
}

var _ bufferedWindower = &lagJSONWindow{}

func (w *lagJSONWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.JSON()
	leadLagNulls := leadLagVec.Nulls()

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.JSON()
	defaultNulls := defaultVec.Nulls()

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx - int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					leadLagCol.Copy(defaultCol, i, i)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.JSON()
				leadLagCol.Copy(col, i, idx)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				leadLagCol.Copy(defaultCol, i, i)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.JSON()
			leadLagCol.Copy(col, i, idx)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				leadLagCol.Copy(defaultCol, i, i)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.JSON()
			leadLagCol.Copy(col, i, idx)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx - int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			leadLagCol.Copy(defaultCol, i, i)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.JSON()
		leadLagCol.Copy(col, i, idx)
	}
}

type lagDatumWindow struct {
	lagBase
}

var _ bufferedWindower = &lagDatumWindow{}

func (w *lagDatumWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	leadLagVec := batch.ColVec(w.outputColIdx)
	leadLagCol := leadLagVec.Datum()
	leadLagNulls := leadLagVec.Nulls()

	offsetVec := batch.ColVec(w.offsetIdx)
	offsetCol := offsetVec.Int64()
	offsetNulls := offsetVec.Nulls()
	_ = offsetCol[startIdx]
	_ = offsetCol[endIdx-1]

	defaultVec := batch.ColVec(w.defaultIdx)
	defaultCol := defaultVec.Datum()
	defaultNulls := defaultVec.Nulls()

	if offsetNulls.MaybeHasNulls() {
		if defaultNulls.MaybeHasNulls() {
			for i := startIdx; i < endIdx; i++ {
				if offsetNulls.NullAt(i) {
					// When the offset is null, the output value is also null.
					leadLagNulls.SetNull(i)
					w.idx++
					continue
				}
				requestedIdx := w.idx - int(offsetCol[i])
				w.idx++
				if requestedIdx < 0 || requestedIdx >= w.partitionSize {
					// The offset is out of range, so set the output value to the default.
					if defaultNulls.NullAt(i) {
						leadLagNulls.SetNull(i)
						continue
					}
					val := defaultCol.Get(i)
					leadLagCol.Set(i, val)
					continue
				}
				vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
				if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
					leadLagNulls.SetNull(i)
					continue
				}
				col := vec.Datum()
				val := col.Get(idx)
				leadLagCol.Set(i, val)
			}
			return
		}
		for i := startIdx; i < endIdx; i++ {
			if offsetNulls.NullAt(i) {
				// When the offset is null, the output value is also null.
				leadLagNulls.SetNull(i)
				w.idx++
				continue
			}
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Datum()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	if defaultNulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {
			requestedIdx := w.idx - int(offsetCol[i])
			w.idx++
			if requestedIdx < 0 || requestedIdx >= w.partitionSize {
				// The offset is out of range, so set the output value to the default.
				if defaultNulls.NullAt(i) {
					leadLagNulls.SetNull(i)
					continue
				}
				val := defaultCol.Get(i)
				leadLagCol.Set(i, val)
				continue
			}
			vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
			if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
				leadLagNulls.SetNull(i)
				continue
			}
			col := vec.Datum()
			val := col.Get(idx)
			leadLagCol.Set(i, val)
		}
		return
	}
	for i := startIdx; i < endIdx; i++ {
		requestedIdx := w.idx - int(offsetCol[i])
		w.idx++
		if requestedIdx < 0 || requestedIdx >= w.partitionSize {
			// The offset is out of range, so set the output value to the default.
			val := defaultCol.Get(i)
			leadLagCol.Set(i, val)
			continue
		}
		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, 0 /* colIdx */, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			leadLagNulls.SetNull(i)
			continue
		}
		col := vec.Datum()
		val := col.Get(idx)
		leadLagCol.Set(i, val)
	}
}

func (b *lagBase) transitionToProcessing() {}

func (b *lagBase) startNewPartition() {
	b.idx = 0
	b.partitionSize = 0
	b.buffer.Reset(b.Ctx)
}

func (b *lagBase) Init(ctx context.Context) {
	if !b.InitHelper.Init(ctx) {
		return
	}
}

func (b *lagBase) Close(ctx context.Context) {
	if !b.CloserHelper.Close() {
		return
	}
	b.buffer.Close(ctx)
}
