// Code generated by execgen; DO NOT EDIT.
// Copyright 2021 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecwindow

import (
	"context"

	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexecutils"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecop"
	"github.com/cockroachdb/cockroach/pkg/sql/execinfrapb"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/errors"
)

// NewFirstValueOperator creates a new Operator that computes window
// function firstValue. outputColIdx specifies in which coldata.Vec the operator
// should put its output (if there is no such column, a new column is appended).
func NewFirstValueOperator(
	args *WindowArgs,
	frame *execinfrapb.WindowerSpec_Frame,
	ordering *execinfrapb.Ordering,
	argIdxs []int,
) (colexecop.ClosableOperator, error) {
	framer := newWindowFramer(args.EvalCtx, frame, ordering, args.InputTypes, args.PeersColIdx)
	colsToStore := framer.getColsToStore([]int{argIdxs[0]})

	// Allow the direct-access buffer 10% of the available memory. The rest will
	// be given to the bufferedWindowOp queue. While it is somewhat more important
	// for the direct-access buffer tuples to be kept in-memory, it only has to
	// store a single column. TODO(drewk): play around with benchmarks to find a
	// good empirically-supported fraction to use.
	bufferMemLimit := int64(float64(args.MemoryLimit) * 0.10)
	mainMemLimit := args.MemoryLimit - bufferMemLimit
	buffer := colexecutils.NewSpillingBuffer(
		args.BufferAllocator, bufferMemLimit, args.QueueCfg, args.FdSemaphore,
		args.InputTypes, args.DiskAcc, args.DiskQueueMemAcc, colsToStore...,
	)
	base := firstValueBase{
		partitionSeekerBase: partitionSeekerBase{
			buffer:          buffer,
			partitionColIdx: args.PartitionColIdx,
		},
		framer:       framer,
		outputColIdx: args.OutputColIdx,
		bufferArgIdx: 0, // The arg column is the first column in the buffer.
	}
	argType := args.InputTypes[argIdxs[0]]
	switch typeconv.TypeFamilyToCanonicalTypeFamily(argType.Family()) {
	case types.BoolFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &firstValueBoolWindow{firstValueBase: base}
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case types.BytesFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &firstValueBytesWindow{firstValueBase: base}
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case types.DecimalFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &firstValueDecimalWindow{firstValueBase: base}
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case types.IntFamily:
		switch argType.Width() {
		case 16:
			windower := &firstValueInt16Window{firstValueBase: base}
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		case 32:
			windower := &firstValueInt32Window{firstValueBase: base}
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		case -1:
		default:
			windower := &firstValueInt64Window{firstValueBase: base}
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case types.FloatFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &firstValueFloat64Window{firstValueBase: base}
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case types.TimestampTZFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &firstValueTimestampWindow{firstValueBase: base}
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case types.IntervalFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &firstValueIntervalWindow{firstValueBase: base}
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case types.JsonFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &firstValueJSONWindow{firstValueBase: base}
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch argType.Width() {
		case -1:
		default:
			windower := &firstValueDatumWindow{firstValueBase: base}
			return newBufferedWindowOperator(args, windower, argType, mainMemLimit), nil
		}
	}
	return nil, errors.AssertionFailedf("unsupported firstValue window operator type %s", argType.Name())
}

type firstValueBase struct {
	partitionSeekerBase
	colexecop.CloserHelper
	framer windowFramer

	outputColIdx int
	bufferArgIdx int
}

type firstValueBoolWindow struct {
	firstValueBase
}

var _ bufferedWindower = &firstValueBoolWindow{}

// processBatch implements the bufferedWindower interface.
func (w *firstValueBoolWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Bool()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		requestedIdx := w.framer.frameFirstIdx()
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Bool()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type firstValueBytesWindow struct {
	firstValueBase
}

var _ bufferedWindower = &firstValueBytesWindow{}

// processBatch implements the bufferedWindower interface.
func (w *firstValueBytesWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Bytes()
	outputNulls := outputVec.Nulls()

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		requestedIdx := w.framer.frameFirstIdx()
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Bytes()
		outputCol.Copy(col, i, idx)
	}
}

type firstValueDecimalWindow struct {
	firstValueBase
}

var _ bufferedWindower = &firstValueDecimalWindow{}

// processBatch implements the bufferedWindower interface.
func (w *firstValueDecimalWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Decimal()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		requestedIdx := w.framer.frameFirstIdx()
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Decimal()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type firstValueInt16Window struct {
	firstValueBase
}

var _ bufferedWindower = &firstValueInt16Window{}

// processBatch implements the bufferedWindower interface.
func (w *firstValueInt16Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Int16()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		requestedIdx := w.framer.frameFirstIdx()
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Int16()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type firstValueInt32Window struct {
	firstValueBase
}

var _ bufferedWindower = &firstValueInt32Window{}

// processBatch implements the bufferedWindower interface.
func (w *firstValueInt32Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Int32()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		requestedIdx := w.framer.frameFirstIdx()
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Int32()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type firstValueInt64Window struct {
	firstValueBase
}

var _ bufferedWindower = &firstValueInt64Window{}

// processBatch implements the bufferedWindower interface.
func (w *firstValueInt64Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Int64()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		requestedIdx := w.framer.frameFirstIdx()
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Int64()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type firstValueFloat64Window struct {
	firstValueBase
}

var _ bufferedWindower = &firstValueFloat64Window{}

// processBatch implements the bufferedWindower interface.
func (w *firstValueFloat64Window) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Float64()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		requestedIdx := w.framer.frameFirstIdx()
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Float64()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type firstValueTimestampWindow struct {
	firstValueBase
}

var _ bufferedWindower = &firstValueTimestampWindow{}

// processBatch implements the bufferedWindower interface.
func (w *firstValueTimestampWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Timestamp()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		requestedIdx := w.framer.frameFirstIdx()
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Timestamp()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type firstValueIntervalWindow struct {
	firstValueBase
}

var _ bufferedWindower = &firstValueIntervalWindow{}

// processBatch implements the bufferedWindower interface.
func (w *firstValueIntervalWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Interval()
	outputNulls := outputVec.Nulls()
	_, _ = outputCol.Get(startIdx), outputCol.Get(endIdx-1)

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		requestedIdx := w.framer.frameFirstIdx()
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Interval()
		val := col.Get(idx)
		//gcassert:bce
		outputCol.Set(i, val)
	}
}

type firstValueJSONWindow struct {
	firstValueBase
}

var _ bufferedWindower = &firstValueJSONWindow{}

// processBatch implements the bufferedWindower interface.
func (w *firstValueJSONWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.JSON()
	outputNulls := outputVec.Nulls()

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		requestedIdx := w.framer.frameFirstIdx()
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.JSON()
		outputCol.Copy(col, i, idx)
	}
}

type firstValueDatumWindow struct {
	firstValueBase
}

var _ bufferedWindower = &firstValueDatumWindow{}

// processBatch implements the bufferedWindower interface.
func (w *firstValueDatumWindow) processBatch(batch coldata.Batch, startIdx, endIdx int) {
	if startIdx >= endIdx {
		// No processing needs to be done for this portion of the current partition.
		return
	}
	outputVec := batch.ColVec(w.outputColIdx)
	outputCol := outputVec.Datum()
	outputNulls := outputVec.Nulls()

	for i := startIdx; i < endIdx; i++ {
		w.framer.next(w.Ctx)
		requestedIdx := w.framer.frameFirstIdx()
		if requestedIdx == -1 {
			// The requested row does not exist.
			outputNulls.SetNull(i)
			continue
		}

		vec, idx, _ := w.buffer.GetVecWithTuple(w.Ctx, w.bufferArgIdx, requestedIdx)
		if vec.Nulls().MaybeHasNulls() && vec.Nulls().NullAt(idx) {
			outputNulls.SetNull(i)
			continue
		}
		col := vec.Datum()
		val := col.Get(idx)
		outputCol.Set(i, val)
	}
}

// transitionToProcessing implements the bufferedWindower interface.
func (b *firstValueBase) transitionToProcessing() {
	b.framer.startPartition(b.Ctx, b.partitionSize, b.buffer)
}

// startNewPartition implements the bufferedWindower interface.
func (b *firstValueBase) startNewPartition() {
	b.partitionSize = 0
	b.buffer.Reset(b.Ctx)
}

// Init implements the bufferedWindower interface.
func (b *firstValueBase) Init(ctx context.Context) {
	if !b.InitHelper.Init(ctx) {
		return
	}
}

// Close implements the bufferedWindower interface.
func (b *firstValueBase) Close(ctx context.Context) {
	if !b.CloserHelper.Close() {
		return
	}
	b.buffer.Close(ctx)
}
