// Code generated by execgen; DO NOT EDIT.
// Copyright 2021 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecspan

import (
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
	"github.com/cockroachdb/cockroach/pkg/sql/rowenc/keyside"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/encoding"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ = keyside.Encode
	_ tree.Datum
)

// newSpanEncoder creates a new utility operator that, given input batches,
// generates the encoding for the given key column. It is used by SpanAssembler
// operators to generate spans for index joins and lookup joins.
func newSpanEncoder(
	allocator *colmem.Allocator, typ *types.T, asc bool, encodeColIdx int,
) spanEncoder {
	base := spanEncoderBase{
		allocator:    allocator,
		encodeColIdx: encodeColIdx,
	}
	switch asc {
	case true:
		switch typeconv.TypeFamilyToCanonicalTypeFamily(typ.Family()) {
		case types.BoolFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderBoolAsc{spanEncoderBase: base}
			}
		case types.BytesFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderBytesAsc{spanEncoderBase: base}
			}
		case types.DecimalFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderDecimalAsc{spanEncoderBase: base}
			}
		case types.IntFamily:
			switch typ.Width() {
			case 16:
				return &spanEncoderInt16Asc{spanEncoderBase: base}
			case 32:
				return &spanEncoderInt32Asc{spanEncoderBase: base}
			case -1:
			default:
				return &spanEncoderInt64Asc{spanEncoderBase: base}
			}
		case types.FloatFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderFloat64Asc{spanEncoderBase: base}
			}
		case types.TimestampTZFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderTimestampAsc{spanEncoderBase: base}
			}
		case types.IntervalFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderIntervalAsc{spanEncoderBase: base}
			}
		case types.JsonFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderJSONAsc{spanEncoderBase: base}
			}
		case typeconv.DatumVecCanonicalTypeFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderDatumAsc{spanEncoderBase: base}
			}
		}
	case false:
		switch typeconv.TypeFamilyToCanonicalTypeFamily(typ.Family()) {
		case types.BoolFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderBoolDesc{spanEncoderBase: base}
			}
		case types.BytesFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderBytesDesc{spanEncoderBase: base}
			}
		case types.DecimalFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderDecimalDesc{spanEncoderBase: base}
			}
		case types.IntFamily:
			switch typ.Width() {
			case 16:
				return &spanEncoderInt16Desc{spanEncoderBase: base}
			case 32:
				return &spanEncoderInt32Desc{spanEncoderBase: base}
			case -1:
			default:
				return &spanEncoderInt64Desc{spanEncoderBase: base}
			}
		case types.FloatFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderFloat64Desc{spanEncoderBase: base}
			}
		case types.TimestampTZFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderTimestampDesc{spanEncoderBase: base}
			}
		case types.IntervalFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderIntervalDesc{spanEncoderBase: base}
			}
		case types.JsonFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderJSONDesc{spanEncoderBase: base}
			}
		case typeconv.DatumVecCanonicalTypeFamily:
			switch typ.Width() {
			case -1:
			default:
				return &spanEncoderDatumDesc{spanEncoderBase: base}
			}
		}
	}
	colexecerror.InternalError(errors.AssertionFailedf("unsupported span encoder type %s", typ.Name()))
	return nil
}

type spanEncoder interface {
	// next generates the encoding for the current key column for each row from
	// the given batch in the range [startIdx, endIdx), then returns each row's
	// encoding as a value in a Bytes column. The returned Bytes column is owned
	// by the spanEncoder operator and should not be modified. Calling next
	// invalidates previous calls to next. next assumes that startIdx and endIdx
	// constitute a valid range of the given batch.
	next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes

	close()
}

type spanEncoderBase struct {
	allocator *colmem.Allocator

	// outputBytes contains the encoding for each row of the key column. It is
	// reused between calls to next().
	outputBytes *coldata.Bytes

	// A scratch bytes slice used to hold each encoding before it is appended to
	// the output column. It is reused to avoid allocating for every row.
	scratch []byte

	encodeColIdx int
}

type spanEncoderBoolAsc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderBoolAsc{}

// next implements the spanEncoder interface.
func (op *spanEncoderBoolAsc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Bool()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					val := col.Get(i)

					var x int64
					if val {
						x = 1
					} else {
						x = 0
					}
					op.scratch = encoding.EncodeVarintAscending(op.scratch, x)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)

					var x int64
					if val {
						x = 1
					} else {
						x = 0
					}
					op.scratch = encoding.EncodeVarintAscending(op.scratch, x)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)

					var x int64
					if val {
						x = 1
					} else {
						x = 0
					}
					op.scratch = encoding.EncodeVarintAscending(op.scratch, x)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)

					var x int64
					if val {
						x = 1
					} else {
						x = 0
					}
					op.scratch = encoding.EncodeVarintAscending(op.scratch, x)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderBytesAsc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderBytesAsc{}

// next implements the spanEncoder interface.
func (op *spanEncoderBytesAsc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Bytes()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeBytesAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeBytesAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeBytesAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeBytesAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderDecimalAsc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderDecimalAsc{}

// next implements the spanEncoder interface.
func (op *spanEncoderDecimalAsc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Decimal()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeDecimalAscending(op.scratch, &val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeDecimalAscending(op.scratch, &val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeDecimalAscending(op.scratch, &val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeDecimalAscending(op.scratch, &val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderInt16Asc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderInt16Asc{}

// next implements the spanEncoder interface.
func (op *spanEncoderInt16Asc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Int16()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintAscending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintAscending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintAscending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintAscending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderInt32Asc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderInt32Asc{}

// next implements the spanEncoder interface.
func (op *spanEncoderInt32Asc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Int32()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintAscending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintAscending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintAscending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintAscending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderInt64Asc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderInt64Asc{}

// next implements the spanEncoder interface.
func (op *spanEncoderInt64Asc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Int64()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderFloat64Asc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderFloat64Asc{}

// next implements the spanEncoder interface.
func (op *spanEncoderFloat64Asc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Float64()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeFloatAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeFloatAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeFloatAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeFloatAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderTimestampAsc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderTimestampAsc{}

// next implements the spanEncoder interface.
func (op *spanEncoderTimestampAsc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Timestamp()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeTimeAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeTimeAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeTimeAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeTimeAscending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderIntervalAsc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderIntervalAsc{}

// next implements the spanEncoder interface.
func (op *spanEncoderIntervalAsc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Interval()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					val := col.Get(i)

					var err error
					op.scratch, err = encoding.EncodeDurationAscending(op.scratch, val)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)

					var err error
					op.scratch, err = encoding.EncodeDurationAscending(op.scratch, val)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)

					var err error
					op.scratch, err = encoding.EncodeDurationAscending(op.scratch, val)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)

					var err error
					op.scratch, err = encoding.EncodeDurationAscending(op.scratch, val)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderJSONAsc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderJSONAsc{}

// next implements the spanEncoder interface.
func (op *spanEncoderJSONAsc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.JSON()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					val := col.Get(i)

					var err error
					op.scratch, err = val.EncodeForwardIndex(op.scratch, encoding.Ascending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)

					var err error
					op.scratch, err = val.EncodeForwardIndex(op.scratch, encoding.Ascending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					val := col.Get(i)

					var err error
					op.scratch, err = val.EncodeForwardIndex(op.scratch, encoding.Ascending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)

					var err error
					op.scratch, err = val.EncodeForwardIndex(op.scratch, encoding.Ascending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderDatumAsc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderDatumAsc{}

// next implements the spanEncoder interface.
func (op *spanEncoderDatumAsc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Datum()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					val := col.Get(i)

					var err error
					op.scratch, err = keyside.Encode(op.scratch, val.(tree.Datum), encoding.Ascending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)

					var err error
					op.scratch, err = keyside.Encode(op.scratch, val.(tree.Datum), encoding.Ascending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullAscending(op.scratch))
						continue
					}
					val := col.Get(i)

					var err error
					op.scratch, err = keyside.Encode(op.scratch, val.(tree.Datum), encoding.Ascending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)

					var err error
					op.scratch, err = keyside.Encode(op.scratch, val.(tree.Datum), encoding.Ascending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderBoolDesc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderBoolDesc{}

// next implements the spanEncoder interface.
func (op *spanEncoderBoolDesc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Bool()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					val := col.Get(i)

					var x int64
					if val {
						x = 1
					} else {
						x = 0
					}
					op.scratch = encoding.EncodeVarintDescending(op.scratch, x)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)

					var x int64
					if val {
						x = 1
					} else {
						x = 0
					}
					op.scratch = encoding.EncodeVarintDescending(op.scratch, x)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)

					var x int64
					if val {
						x = 1
					} else {
						x = 0
					}
					op.scratch = encoding.EncodeVarintDescending(op.scratch, x)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)

					var x int64
					if val {
						x = 1
					} else {
						x = 0
					}
					op.scratch = encoding.EncodeVarintDescending(op.scratch, x)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderBytesDesc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderBytesDesc{}

// next implements the spanEncoder interface.
func (op *spanEncoderBytesDesc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Bytes()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeBytesDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeBytesDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeBytesDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeBytesDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderDecimalDesc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderDecimalDesc{}

// next implements the spanEncoder interface.
func (op *spanEncoderDecimalDesc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Decimal()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeDecimalDescending(op.scratch, &val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeDecimalDescending(op.scratch, &val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeDecimalDescending(op.scratch, &val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeDecimalDescending(op.scratch, &val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderInt16Desc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderInt16Desc{}

// next implements the spanEncoder interface.
func (op *spanEncoderInt16Desc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Int16()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintDescending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintDescending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintDescending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintDescending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderInt32Desc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderInt32Desc{}

// next implements the spanEncoder interface.
func (op *spanEncoderInt32Desc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Int32()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintDescending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintDescending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintDescending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintDescending(op.scratch, int64(val))
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderInt64Desc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderInt64Desc{}

// next implements the spanEncoder interface.
func (op *spanEncoderInt64Desc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Int64()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeVarintDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderFloat64Desc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderFloat64Desc{}

// next implements the spanEncoder interface.
func (op *spanEncoderFloat64Desc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Float64()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeFloatDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeFloatDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeFloatDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeFloatDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderTimestampDesc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderTimestampDesc{}

// next implements the spanEncoder interface.
func (op *spanEncoderTimestampDesc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Timestamp()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					val := col.Get(i)
					op.scratch = encoding.EncodeTimeDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)
					op.scratch = encoding.EncodeTimeDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeTimeDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)
					op.scratch = encoding.EncodeTimeDescending(op.scratch, val)
					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderIntervalDesc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderIntervalDesc{}

// next implements the spanEncoder interface.
func (op *spanEncoderIntervalDesc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Interval()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					val := col.Get(i)

					var err error
					op.scratch, err = encoding.EncodeDurationDescending(op.scratch, val)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)

					var err error
					op.scratch, err = encoding.EncodeDurationDescending(op.scratch, val)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					//gcassert:bce
					val := col.Get(i)

					var err error
					op.scratch, err = encoding.EncodeDurationDescending(op.scratch, val)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					//gcassert:bce
					val := col.Get(i)

					var err error
					op.scratch, err = encoding.EncodeDurationDescending(op.scratch, val)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderJSONDesc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderJSONDesc{}

// next implements the spanEncoder interface.
func (op *spanEncoderJSONDesc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.JSON()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					val := col.Get(i)

					var err error
					op.scratch, err = val.EncodeForwardIndex(op.scratch, encoding.Descending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)

					var err error
					op.scratch, err = val.EncodeForwardIndex(op.scratch, encoding.Descending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					val := col.Get(i)

					var err error
					op.scratch, err = val.EncodeForwardIndex(op.scratch, encoding.Descending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)

					var err error
					op.scratch, err = val.EncodeForwardIndex(op.scratch, encoding.Descending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

type spanEncoderDatumDesc struct {
	spanEncoderBase
}

var _ spanEncoder = &spanEncoderDatumDesc{}

// next implements the spanEncoder interface.
func (op *spanEncoderDatumDesc) next(batch coldata.Batch, startIdx, endIdx int) *coldata.Bytes {
	oldBytesSize := op.outputBytes.Size()
	if op.outputBytes == nil || op.outputBytes.Len() < endIdx-startIdx {
		op.outputBytes = coldata.NewBytes(endIdx - startIdx)
	} else {
		op.outputBytes.Reset()
	}

	vec := batch.ColVec(op.encodeColIdx)
	col := vec.Datum()

	sel := batch.Selection()
	if sel != nil {
		sel = sel[startIdx:endIdx]
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					val := col.Get(i)

					var err error
					op.scratch, err = keyside.Encode(op.scratch, val.(tree.Datum), encoding.Descending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for outIdx, i := range sel {
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)

					var err error
					op.scratch, err = keyside.Encode(op.scratch, val.(tree.Datum), encoding.Descending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	} else {
		_, _ = col.Get(startIdx), col.Get(endIdx-1)
		if vec.Nulls().MaybeHasNulls() {
			nulls := vec.Nulls()
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					if nulls.NullAt(i) {
						op.outputBytes.Set(outIdx, encoding.EncodeNullDescending(op.scratch))
						continue
					}
					val := col.Get(i)

					var err error
					op.scratch, err = keyside.Encode(op.scratch, val.(tree.Datum), encoding.Descending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		} else {
			for i := startIdx; i < endIdx; i++ {
				outIdx := i - startIdx
				{
					op.scratch = op.scratch[:0]
					val := col.Get(i)

					var err error
					op.scratch, err = keyside.Encode(op.scratch, val.(tree.Datum), encoding.Descending)
					if err != nil {
						colexecerror.ExpectedError(err)
					}

					op.outputBytes.Set(outIdx, op.scratch)
				}
			}
		}
	}

	op.allocator.AdjustMemoryUsageAfterAllocation(op.outputBytes.Size() - oldBytesSize)
	return op.outputBytes
}

// close implements the spanEncoder interface.
func (b *spanEncoderBase) close() {
	*b = spanEncoderBase{}
}

// execgen:inline
const _ = "template_encodeSpan"

// execgen:inline
const _ = "inlined_encodeSpan_true_true"

// execgen:inline
const _ = "inlined_encodeSpan_true_false"

// execgen:inline
const _ = "inlined_encodeSpan_false_true"

// execgen:inline
const _ = "inlined_encodeSpan_false_false"
