// Code generated by execgen; DO NOT EDIT.
// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecsel

import (
	"bytes"
	"math"
	"time"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexeccmp"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecop"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/eval"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree/treecmp"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/cockroach/pkg/util/json"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ apd.Context
	_ duration.Duration
	_ = coldataext.CompareDatum
	_ json.JSON
)

// selConstOpBase contains all of the fields for binary selections with a
// constant, except for the constant itself.
type selConstOpBase struct {
	colexecop.OneInputHelper
	colIdx int
}

// selOpBase contains all of the fields for non-constant binary selections.
type selOpBase struct {
	colexecop.OneInputHelper
	col1Idx int
	col2Idx int
}

type selEQBoolBoolConstOp struct {
	selConstOpBase
	constArg bool
}

func (p *selEQBoolBoolConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bool()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQBoolBoolOp struct {
	selOpBase
}

func (p *selEQBoolBoolOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bool()
		col2 := vec2.Bool()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQBytesBytesConstOp struct {
	selConstOpBase
	constArg []byte
}

func (p *selEQBytesBytesConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bytes()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQBytesBytesOp struct {
	selOpBase
}

func (p *selEQBytesBytesOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bytes()
		col2 := vec2.Bytes()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQDecimalInt16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selEQDecimalInt16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQDecimalInt16Op struct {
	selOpBase
}

func (p *selEQDecimalInt16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQDecimalInt32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selEQDecimalInt32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQDecimalInt32Op struct {
	selOpBase
}

func (p *selEQDecimalInt32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQDecimalInt64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selEQDecimalInt64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQDecimalInt64Op struct {
	selOpBase
}

func (p *selEQDecimalInt64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQDecimalFloat64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selEQDecimalFloat64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQDecimalFloat64Op struct {
	selOpBase
}

func (p *selEQDecimalFloat64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQDecimalDecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selEQDecimalDecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQDecimalDecimalOp struct {
	selOpBase
}

func (p *selEQDecimalDecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt16Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selEQInt16Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt16Int16Op struct {
	selOpBase
}

func (p *selEQInt16Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt16Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selEQInt16Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt16Int32Op struct {
	selOpBase
}

func (p *selEQInt16Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt16Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selEQInt16Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt16Int64Op struct {
	selOpBase
}

func (p *selEQInt16Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt16Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selEQInt16Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt16Float64Op struct {
	selOpBase
}

func (p *selEQInt16Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt16DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selEQInt16DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt16DecimalOp struct {
	selOpBase
}

func (p *selEQInt16DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt32Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selEQInt32Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt32Int16Op struct {
	selOpBase
}

func (p *selEQInt32Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt32Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selEQInt32Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt32Int32Op struct {
	selOpBase
}

func (p *selEQInt32Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt32Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selEQInt32Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt32Int64Op struct {
	selOpBase
}

func (p *selEQInt32Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt32Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selEQInt32Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt32Float64Op struct {
	selOpBase
}

func (p *selEQInt32Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt32DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selEQInt32DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt32DecimalOp struct {
	selOpBase
}

func (p *selEQInt32DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt64Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selEQInt64Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt64Int16Op struct {
	selOpBase
}

func (p *selEQInt64Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt64Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selEQInt64Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt64Int32Op struct {
	selOpBase
}

func (p *selEQInt64Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt64Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selEQInt64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt64Int64Op struct {
	selOpBase
}

func (p *selEQInt64Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt64Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selEQInt64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt64Float64Op struct {
	selOpBase
}

func (p *selEQInt64Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt64DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selEQInt64DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQInt64DecimalOp struct {
	selOpBase
}

func (p *selEQInt64DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQFloat64Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selEQFloat64Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQFloat64Int16Op struct {
	selOpBase
}

func (p *selEQFloat64Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQFloat64Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selEQFloat64Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQFloat64Int32Op struct {
	selOpBase
}

func (p *selEQFloat64Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQFloat64Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selEQFloat64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQFloat64Int64Op struct {
	selOpBase
}

func (p *selEQFloat64Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQFloat64Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selEQFloat64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQFloat64Float64Op struct {
	selOpBase
}

func (p *selEQFloat64Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQFloat64DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selEQFloat64DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQFloat64DecimalOp struct {
	selOpBase
}

func (p *selEQFloat64DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQTimestampTimestampConstOp struct {
	selConstOpBase
	constArg time.Time
}

func (p *selEQTimestampTimestampConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Timestamp()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQTimestampTimestampOp struct {
	selOpBase
}

func (p *selEQTimestampTimestampOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Timestamp()
		col2 := vec2.Timestamp()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQIntervalIntervalConstOp struct {
	selConstOpBase
	constArg duration.Duration
}

func (p *selEQIntervalIntervalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Interval()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQIntervalIntervalOp struct {
	selOpBase
}

func (p *selEQIntervalIntervalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Interval()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQJSONJSONConstOp struct {
	selConstOpBase
	constArg json.JSON
}

func (p *selEQJSONJSONConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.JSON()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQJSONJSONOp struct {
	selOpBase
}

func (p *selEQJSONJSONOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.JSON()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQDatumDatumConstOp struct {
	selConstOpBase
	constArg interface{}
}

func (p *selEQDatumDatumConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Datum()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selEQDatumDatumOp struct {
	selOpBase
}

func (p *selEQDatumDatumOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Datum()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult == 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEBoolBoolConstOp struct {
	selConstOpBase
	constArg bool
}

func (p *selNEBoolBoolConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bool()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEBoolBoolOp struct {
	selOpBase
}

func (p *selNEBoolBoolOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bool()
		col2 := vec2.Bool()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEBytesBytesConstOp struct {
	selConstOpBase
	constArg []byte
}

func (p *selNEBytesBytesConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bytes()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEBytesBytesOp struct {
	selOpBase
}

func (p *selNEBytesBytesOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bytes()
		col2 := vec2.Bytes()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEDecimalInt16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selNEDecimalInt16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEDecimalInt16Op struct {
	selOpBase
}

func (p *selNEDecimalInt16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEDecimalInt32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selNEDecimalInt32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEDecimalInt32Op struct {
	selOpBase
}

func (p *selNEDecimalInt32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEDecimalInt64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selNEDecimalInt64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEDecimalInt64Op struct {
	selOpBase
}

func (p *selNEDecimalInt64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEDecimalFloat64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selNEDecimalFloat64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEDecimalFloat64Op struct {
	selOpBase
}

func (p *selNEDecimalFloat64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEDecimalDecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selNEDecimalDecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEDecimalDecimalOp struct {
	selOpBase
}

func (p *selNEDecimalDecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt16Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selNEInt16Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt16Int16Op struct {
	selOpBase
}

func (p *selNEInt16Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt16Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selNEInt16Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt16Int32Op struct {
	selOpBase
}

func (p *selNEInt16Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt16Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selNEInt16Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt16Int64Op struct {
	selOpBase
}

func (p *selNEInt16Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt16Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selNEInt16Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt16Float64Op struct {
	selOpBase
}

func (p *selNEInt16Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt16DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selNEInt16DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt16DecimalOp struct {
	selOpBase
}

func (p *selNEInt16DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt32Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selNEInt32Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt32Int16Op struct {
	selOpBase
}

func (p *selNEInt32Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt32Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selNEInt32Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt32Int32Op struct {
	selOpBase
}

func (p *selNEInt32Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt32Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selNEInt32Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt32Int64Op struct {
	selOpBase
}

func (p *selNEInt32Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt32Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selNEInt32Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt32Float64Op struct {
	selOpBase
}

func (p *selNEInt32Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt32DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selNEInt32DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt32DecimalOp struct {
	selOpBase
}

func (p *selNEInt32DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt64Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selNEInt64Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt64Int16Op struct {
	selOpBase
}

func (p *selNEInt64Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt64Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selNEInt64Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt64Int32Op struct {
	selOpBase
}

func (p *selNEInt64Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt64Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selNEInt64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt64Int64Op struct {
	selOpBase
}

func (p *selNEInt64Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt64Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selNEInt64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt64Float64Op struct {
	selOpBase
}

func (p *selNEInt64Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt64DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selNEInt64DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEInt64DecimalOp struct {
	selOpBase
}

func (p *selNEInt64DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEFloat64Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selNEFloat64Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEFloat64Int16Op struct {
	selOpBase
}

func (p *selNEFloat64Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEFloat64Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selNEFloat64Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEFloat64Int32Op struct {
	selOpBase
}

func (p *selNEFloat64Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEFloat64Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selNEFloat64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEFloat64Int64Op struct {
	selOpBase
}

func (p *selNEFloat64Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEFloat64Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selNEFloat64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEFloat64Float64Op struct {
	selOpBase
}

func (p *selNEFloat64Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEFloat64DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selNEFloat64DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEFloat64DecimalOp struct {
	selOpBase
}

func (p *selNEFloat64DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNETimestampTimestampConstOp struct {
	selConstOpBase
	constArg time.Time
}

func (p *selNETimestampTimestampConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Timestamp()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNETimestampTimestampOp struct {
	selOpBase
}

func (p *selNETimestampTimestampOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Timestamp()
		col2 := vec2.Timestamp()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEIntervalIntervalConstOp struct {
	selConstOpBase
	constArg duration.Duration
}

func (p *selNEIntervalIntervalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Interval()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEIntervalIntervalOp struct {
	selOpBase
}

func (p *selNEIntervalIntervalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Interval()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEJSONJSONConstOp struct {
	selConstOpBase
	constArg json.JSON
}

func (p *selNEJSONJSONConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.JSON()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEJSONJSONOp struct {
	selOpBase
}

func (p *selNEJSONJSONOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.JSON()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEDatumDatumConstOp struct {
	selConstOpBase
	constArg interface{}
}

func (p *selNEDatumDatumConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Datum()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selNEDatumDatumOp struct {
	selOpBase
}

func (p *selNEDatumDatumOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Datum()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult != 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTBoolBoolConstOp struct {
	selConstOpBase
	constArg bool
}

func (p *selLTBoolBoolConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bool()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTBoolBoolOp struct {
	selOpBase
}

func (p *selLTBoolBoolOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bool()
		col2 := vec2.Bool()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTBytesBytesConstOp struct {
	selConstOpBase
	constArg []byte
}

func (p *selLTBytesBytesConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bytes()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTBytesBytesOp struct {
	selOpBase
}

func (p *selLTBytesBytesOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bytes()
		col2 := vec2.Bytes()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTDecimalInt16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selLTDecimalInt16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTDecimalInt16Op struct {
	selOpBase
}

func (p *selLTDecimalInt16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTDecimalInt32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selLTDecimalInt32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTDecimalInt32Op struct {
	selOpBase
}

func (p *selLTDecimalInt32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTDecimalInt64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selLTDecimalInt64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTDecimalInt64Op struct {
	selOpBase
}

func (p *selLTDecimalInt64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTDecimalFloat64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selLTDecimalFloat64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTDecimalFloat64Op struct {
	selOpBase
}

func (p *selLTDecimalFloat64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTDecimalDecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selLTDecimalDecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTDecimalDecimalOp struct {
	selOpBase
}

func (p *selLTDecimalDecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt16Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selLTInt16Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt16Int16Op struct {
	selOpBase
}

func (p *selLTInt16Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt16Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selLTInt16Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt16Int32Op struct {
	selOpBase
}

func (p *selLTInt16Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt16Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selLTInt16Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt16Int64Op struct {
	selOpBase
}

func (p *selLTInt16Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt16Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selLTInt16Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt16Float64Op struct {
	selOpBase
}

func (p *selLTInt16Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt16DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selLTInt16DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt16DecimalOp struct {
	selOpBase
}

func (p *selLTInt16DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt32Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selLTInt32Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt32Int16Op struct {
	selOpBase
}

func (p *selLTInt32Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt32Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selLTInt32Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt32Int32Op struct {
	selOpBase
}

func (p *selLTInt32Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt32Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selLTInt32Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt32Int64Op struct {
	selOpBase
}

func (p *selLTInt32Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt32Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selLTInt32Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt32Float64Op struct {
	selOpBase
}

func (p *selLTInt32Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt32DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selLTInt32DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt32DecimalOp struct {
	selOpBase
}

func (p *selLTInt32DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt64Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selLTInt64Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt64Int16Op struct {
	selOpBase
}

func (p *selLTInt64Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt64Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selLTInt64Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt64Int32Op struct {
	selOpBase
}

func (p *selLTInt64Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt64Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selLTInt64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt64Int64Op struct {
	selOpBase
}

func (p *selLTInt64Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt64Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selLTInt64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt64Float64Op struct {
	selOpBase
}

func (p *selLTInt64Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt64DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selLTInt64DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTInt64DecimalOp struct {
	selOpBase
}

func (p *selLTInt64DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTFloat64Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selLTFloat64Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTFloat64Int16Op struct {
	selOpBase
}

func (p *selLTFloat64Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTFloat64Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selLTFloat64Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTFloat64Int32Op struct {
	selOpBase
}

func (p *selLTFloat64Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTFloat64Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selLTFloat64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTFloat64Int64Op struct {
	selOpBase
}

func (p *selLTFloat64Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTFloat64Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selLTFloat64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTFloat64Float64Op struct {
	selOpBase
}

func (p *selLTFloat64Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTFloat64DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selLTFloat64DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTFloat64DecimalOp struct {
	selOpBase
}

func (p *selLTFloat64DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTTimestampTimestampConstOp struct {
	selConstOpBase
	constArg time.Time
}

func (p *selLTTimestampTimestampConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Timestamp()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTTimestampTimestampOp struct {
	selOpBase
}

func (p *selLTTimestampTimestampOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Timestamp()
		col2 := vec2.Timestamp()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTIntervalIntervalConstOp struct {
	selConstOpBase
	constArg duration.Duration
}

func (p *selLTIntervalIntervalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Interval()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTIntervalIntervalOp struct {
	selOpBase
}

func (p *selLTIntervalIntervalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Interval()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTJSONJSONConstOp struct {
	selConstOpBase
	constArg json.JSON
}

func (p *selLTJSONJSONConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.JSON()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTJSONJSONOp struct {
	selOpBase
}

func (p *selLTJSONJSONOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.JSON()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTDatumDatumConstOp struct {
	selConstOpBase
	constArg interface{}
}

func (p *selLTDatumDatumConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Datum()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLTDatumDatumOp struct {
	selOpBase
}

func (p *selLTDatumDatumOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Datum()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult < 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEBoolBoolConstOp struct {
	selConstOpBase
	constArg bool
}

func (p *selLEBoolBoolConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bool()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEBoolBoolOp struct {
	selOpBase
}

func (p *selLEBoolBoolOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bool()
		col2 := vec2.Bool()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEBytesBytesConstOp struct {
	selConstOpBase
	constArg []byte
}

func (p *selLEBytesBytesConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bytes()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEBytesBytesOp struct {
	selOpBase
}

func (p *selLEBytesBytesOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bytes()
		col2 := vec2.Bytes()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEDecimalInt16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selLEDecimalInt16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEDecimalInt16Op struct {
	selOpBase
}

func (p *selLEDecimalInt16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEDecimalInt32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selLEDecimalInt32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEDecimalInt32Op struct {
	selOpBase
}

func (p *selLEDecimalInt32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEDecimalInt64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selLEDecimalInt64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEDecimalInt64Op struct {
	selOpBase
}

func (p *selLEDecimalInt64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEDecimalFloat64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selLEDecimalFloat64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEDecimalFloat64Op struct {
	selOpBase
}

func (p *selLEDecimalFloat64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEDecimalDecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selLEDecimalDecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEDecimalDecimalOp struct {
	selOpBase
}

func (p *selLEDecimalDecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt16Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selLEInt16Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt16Int16Op struct {
	selOpBase
}

func (p *selLEInt16Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt16Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selLEInt16Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt16Int32Op struct {
	selOpBase
}

func (p *selLEInt16Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt16Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selLEInt16Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt16Int64Op struct {
	selOpBase
}

func (p *selLEInt16Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt16Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selLEInt16Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt16Float64Op struct {
	selOpBase
}

func (p *selLEInt16Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt16DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selLEInt16DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt16DecimalOp struct {
	selOpBase
}

func (p *selLEInt16DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt32Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selLEInt32Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt32Int16Op struct {
	selOpBase
}

func (p *selLEInt32Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt32Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selLEInt32Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt32Int32Op struct {
	selOpBase
}

func (p *selLEInt32Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt32Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selLEInt32Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt32Int64Op struct {
	selOpBase
}

func (p *selLEInt32Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt32Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selLEInt32Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt32Float64Op struct {
	selOpBase
}

func (p *selLEInt32Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt32DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selLEInt32DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt32DecimalOp struct {
	selOpBase
}

func (p *selLEInt32DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt64Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selLEInt64Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt64Int16Op struct {
	selOpBase
}

func (p *selLEInt64Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt64Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selLEInt64Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt64Int32Op struct {
	selOpBase
}

func (p *selLEInt64Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt64Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selLEInt64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt64Int64Op struct {
	selOpBase
}

func (p *selLEInt64Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt64Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selLEInt64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt64Float64Op struct {
	selOpBase
}

func (p *selLEInt64Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt64DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selLEInt64DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEInt64DecimalOp struct {
	selOpBase
}

func (p *selLEInt64DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEFloat64Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selLEFloat64Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEFloat64Int16Op struct {
	selOpBase
}

func (p *selLEFloat64Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEFloat64Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selLEFloat64Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEFloat64Int32Op struct {
	selOpBase
}

func (p *selLEFloat64Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEFloat64Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selLEFloat64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEFloat64Int64Op struct {
	selOpBase
}

func (p *selLEFloat64Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEFloat64Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selLEFloat64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEFloat64Float64Op struct {
	selOpBase
}

func (p *selLEFloat64Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEFloat64DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selLEFloat64DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEFloat64DecimalOp struct {
	selOpBase
}

func (p *selLEFloat64DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLETimestampTimestampConstOp struct {
	selConstOpBase
	constArg time.Time
}

func (p *selLETimestampTimestampConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Timestamp()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLETimestampTimestampOp struct {
	selOpBase
}

func (p *selLETimestampTimestampOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Timestamp()
		col2 := vec2.Timestamp()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEIntervalIntervalConstOp struct {
	selConstOpBase
	constArg duration.Duration
}

func (p *selLEIntervalIntervalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Interval()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEIntervalIntervalOp struct {
	selOpBase
}

func (p *selLEIntervalIntervalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Interval()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEJSONJSONConstOp struct {
	selConstOpBase
	constArg json.JSON
}

func (p *selLEJSONJSONConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.JSON()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEJSONJSONOp struct {
	selOpBase
}

func (p *selLEJSONJSONOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.JSON()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEDatumDatumConstOp struct {
	selConstOpBase
	constArg interface{}
}

func (p *selLEDatumDatumConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Datum()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selLEDatumDatumOp struct {
	selOpBase
}

func (p *selLEDatumDatumOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Datum()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult <= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTBoolBoolConstOp struct {
	selConstOpBase
	constArg bool
}

func (p *selGTBoolBoolConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bool()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTBoolBoolOp struct {
	selOpBase
}

func (p *selGTBoolBoolOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bool()
		col2 := vec2.Bool()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTBytesBytesConstOp struct {
	selConstOpBase
	constArg []byte
}

func (p *selGTBytesBytesConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bytes()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTBytesBytesOp struct {
	selOpBase
}

func (p *selGTBytesBytesOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bytes()
		col2 := vec2.Bytes()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTDecimalInt16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selGTDecimalInt16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTDecimalInt16Op struct {
	selOpBase
}

func (p *selGTDecimalInt16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTDecimalInt32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selGTDecimalInt32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTDecimalInt32Op struct {
	selOpBase
}

func (p *selGTDecimalInt32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTDecimalInt64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selGTDecimalInt64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTDecimalInt64Op struct {
	selOpBase
}

func (p *selGTDecimalInt64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTDecimalFloat64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selGTDecimalFloat64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTDecimalFloat64Op struct {
	selOpBase
}

func (p *selGTDecimalFloat64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTDecimalDecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selGTDecimalDecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTDecimalDecimalOp struct {
	selOpBase
}

func (p *selGTDecimalDecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt16Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selGTInt16Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt16Int16Op struct {
	selOpBase
}

func (p *selGTInt16Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt16Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selGTInt16Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt16Int32Op struct {
	selOpBase
}

func (p *selGTInt16Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt16Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selGTInt16Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt16Int64Op struct {
	selOpBase
}

func (p *selGTInt16Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt16Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selGTInt16Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt16Float64Op struct {
	selOpBase
}

func (p *selGTInt16Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt16DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selGTInt16DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt16DecimalOp struct {
	selOpBase
}

func (p *selGTInt16DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt32Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selGTInt32Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt32Int16Op struct {
	selOpBase
}

func (p *selGTInt32Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt32Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selGTInt32Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt32Int32Op struct {
	selOpBase
}

func (p *selGTInt32Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt32Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selGTInt32Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt32Int64Op struct {
	selOpBase
}

func (p *selGTInt32Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt32Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selGTInt32Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt32Float64Op struct {
	selOpBase
}

func (p *selGTInt32Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt32DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selGTInt32DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt32DecimalOp struct {
	selOpBase
}

func (p *selGTInt32DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt64Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selGTInt64Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt64Int16Op struct {
	selOpBase
}

func (p *selGTInt64Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt64Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selGTInt64Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt64Int32Op struct {
	selOpBase
}

func (p *selGTInt64Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt64Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selGTInt64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt64Int64Op struct {
	selOpBase
}

func (p *selGTInt64Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt64Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selGTInt64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt64Float64Op struct {
	selOpBase
}

func (p *selGTInt64Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt64DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selGTInt64DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTInt64DecimalOp struct {
	selOpBase
}

func (p *selGTInt64DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTFloat64Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selGTFloat64Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTFloat64Int16Op struct {
	selOpBase
}

func (p *selGTFloat64Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTFloat64Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selGTFloat64Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTFloat64Int32Op struct {
	selOpBase
}

func (p *selGTFloat64Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTFloat64Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selGTFloat64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTFloat64Int64Op struct {
	selOpBase
}

func (p *selGTFloat64Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTFloat64Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selGTFloat64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTFloat64Float64Op struct {
	selOpBase
}

func (p *selGTFloat64Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTFloat64DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selGTFloat64DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTFloat64DecimalOp struct {
	selOpBase
}

func (p *selGTFloat64DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTTimestampTimestampConstOp struct {
	selConstOpBase
	constArg time.Time
}

func (p *selGTTimestampTimestampConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Timestamp()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTTimestampTimestampOp struct {
	selOpBase
}

func (p *selGTTimestampTimestampOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Timestamp()
		col2 := vec2.Timestamp()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTIntervalIntervalConstOp struct {
	selConstOpBase
	constArg duration.Duration
}

func (p *selGTIntervalIntervalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Interval()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTIntervalIntervalOp struct {
	selOpBase
}

func (p *selGTIntervalIntervalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Interval()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTJSONJSONConstOp struct {
	selConstOpBase
	constArg json.JSON
}

func (p *selGTJSONJSONConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.JSON()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTJSONJSONOp struct {
	selOpBase
}

func (p *selGTJSONJSONOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.JSON()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTDatumDatumConstOp struct {
	selConstOpBase
	constArg interface{}
}

func (p *selGTDatumDatumConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Datum()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGTDatumDatumOp struct {
	selOpBase
}

func (p *selGTDatumDatumOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Datum()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult > 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEBoolBoolConstOp struct {
	selConstOpBase
	constArg bool
}

func (p *selGEBoolBoolConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bool()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEBoolBoolOp struct {
	selOpBase
}

func (p *selGEBoolBoolOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bool()
		col2 := vec2.Bool()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEBytesBytesConstOp struct {
	selConstOpBase
	constArg []byte
}

func (p *selGEBytesBytesConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bytes()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEBytesBytesOp struct {
	selOpBase
}

func (p *selGEBytesBytesOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bytes()
		col2 := vec2.Bytes()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEDecimalInt16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selGEDecimalInt16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEDecimalInt16Op struct {
	selOpBase
}

func (p *selGEDecimalInt16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEDecimalInt32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selGEDecimalInt32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEDecimalInt32Op struct {
	selOpBase
}

func (p *selGEDecimalInt32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEDecimalInt64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selGEDecimalInt64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEDecimalInt64Op struct {
	selOpBase
}

func (p *selGEDecimalInt64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEDecimalFloat64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selGEDecimalFloat64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEDecimalFloat64Op struct {
	selOpBase
}

func (p *selGEDecimalFloat64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEDecimalDecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selGEDecimalDecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Decimal()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEDecimalDecimalOp struct {
	selOpBase
}

func (p *selGEDecimalDecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt16Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selGEInt16Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt16Int16Op struct {
	selOpBase
}

func (p *selGEInt16Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt16Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selGEInt16Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt16Int32Op struct {
	selOpBase
}

func (p *selGEInt16Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt16Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selGEInt16Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt16Int64Op struct {
	selOpBase
}

func (p *selGEInt16Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt16Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selGEInt16Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt16Float64Op struct {
	selOpBase
}

func (p *selGEInt16Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt16DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selGEInt16DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int16()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt16DecimalOp struct {
	selOpBase
}

func (p *selGEInt16DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt32Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selGEInt32Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt32Int16Op struct {
	selOpBase
}

func (p *selGEInt32Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt32Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selGEInt32Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt32Int32Op struct {
	selOpBase
}

func (p *selGEInt32Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt32Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selGEInt32Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt32Int64Op struct {
	selOpBase
}

func (p *selGEInt32Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt32Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selGEInt32Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt32Float64Op struct {
	selOpBase
}

func (p *selGEInt32Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt32DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selGEInt32DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int32()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt32DecimalOp struct {
	selOpBase
}

func (p *selGEInt32DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt64Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selGEInt64Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt64Int16Op struct {
	selOpBase
}

func (p *selGEInt64Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt64Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selGEInt64Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt64Int32Op struct {
	selOpBase
}

func (p *selGEInt64Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt64Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selGEInt64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt64Int64Op struct {
	selOpBase
}

func (p *selGEInt64Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt64Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selGEInt64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt64Float64Op struct {
	selOpBase
}

func (p *selGEInt64Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt64DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selGEInt64DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Int64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEInt64DecimalOp struct {
	selOpBase
}

func (p *selGEInt64DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEFloat64Int16ConstOp struct {
	selConstOpBase
	constArg int16
}

func (p *selGEFloat64Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEFloat64Int16Op struct {
	selOpBase
}

func (p *selGEFloat64Int16Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int16()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEFloat64Int32ConstOp struct {
	selConstOpBase
	constArg int32
}

func (p *selGEFloat64Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEFloat64Int32Op struct {
	selOpBase
}

func (p *selGEFloat64Int32Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int32()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEFloat64Int64ConstOp struct {
	selConstOpBase
	constArg int64
}

func (p *selGEFloat64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEFloat64Int64Op struct {
	selOpBase
}

func (p *selGEFloat64Int64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEFloat64Float64ConstOp struct {
	selConstOpBase
	constArg float64
}

func (p *selGEFloat64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEFloat64Float64Op struct {
	selOpBase
}

func (p *selGEFloat64Float64Op) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEFloat64DecimalConstOp struct {
	selConstOpBase
	constArg apd.Decimal
}

func (p *selGEFloat64DecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Float64()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEFloat64DecimalOp struct {
	selOpBase
}

func (p *selGEFloat64DecimalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Decimal()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGETimestampTimestampConstOp struct {
	selConstOpBase
	constArg time.Time
}

func (p *selGETimestampTimestampConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Timestamp()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGETimestampTimestampOp struct {
	selOpBase
}

func (p *selGETimestampTimestampOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Timestamp()
		col2 := vec2.Timestamp()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEIntervalIntervalConstOp struct {
	selConstOpBase
	constArg duration.Duration
}

func (p *selGEIntervalIntervalConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Interval()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEIntervalIntervalOp struct {
	selOpBase
}

func (p *selGEIntervalIntervalOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Interval()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEJSONJSONConstOp struct {
	selConstOpBase
	constArg json.JSON
}

func (p *selGEJSONJSONConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.JSON()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEJSONJSONOp struct {
	selOpBase
}

func (p *selGEJSONJSONOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.JSON()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEDatumDatumConstOp struct {
	selConstOpBase
	constArg interface{}
}

func (p *selGEDatumDatumConstOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Datum()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selGEDatumDatumOp struct {
	selOpBase
}

func (p *selGEDatumDatumOp) Next() coldata.Batch {
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Datum()
		n := batch.Length()

		var idx int
		if vec1.MaybeHasNulls() || vec2.MaybeHasNulls() {
			nulls := vec1.Nulls().Or(*vec2.Nulls())
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						cmp = cmpResult >= 0
					}

					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

// GetSelectionConstOperator returns the appropriate constant selection operator
// for the given left and right column types and comparison.
func GetSelectionConstOperator(
	cmpOp treecmp.ComparisonOperator,
	input colexecop.Operator,
	inputTypes []*types.T,
	colIdx int,
	constArg tree.Datum,
	evalCtx *eval.Context,
	cmpExpr *tree.ComparisonExpr,
) (colexecop.Operator, error) {
	leftType, constType := inputTypes[colIdx], constArg.ResolvedType()
	c := colconv.GetDatumToPhysicalFn(constType)(constArg)
	selConstOpBase := selConstOpBase{
		OneInputHelper: colexecop.MakeOneInputHelper(input),
		colIdx:         colIdx,
	}
	if leftType.Family() != types.TupleFamily && constType.Family() != types.TupleFamily {
		// Tuple comparison has special null-handling semantics, so we will
		// fallback to the default comparison operator if either of the
		// input vectors is of a tuple type.
		switch cmpOp.Symbol {
		case treecmp.EQ:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.BoolFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.BoolFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQBoolBoolConstOp{selConstOpBase: selConstOpBase, constArg: c.(bool)}, nil
						}
					}
				}
			case types.BytesFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.BytesFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQBytesBytesConstOp{selConstOpBase: selConstOpBase, constArg: c.([]byte)}, nil
						}
					}
				}
			case types.DecimalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.IntFamily:
						switch constType.Width() {
						case 16:
							return &selEQDecimalInt16ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int16)}, nil
						case 32:
							return &selEQDecimalInt32ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int32)}, nil
						case -1:
						default:
							return &selEQDecimalInt64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int64)}, nil
						}
					case types.FloatFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQDecimalFloat64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(float64)}, nil
						}
					case types.DecimalFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQDecimalDecimalConstOp{selConstOpBase: selConstOpBase, constArg: c.(apd.Decimal)}, nil
						}
					}
				}
			case types.IntFamily:
				switch leftType.Width() {
				case 16:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.IntFamily:
						switch constType.Width() {
						case 16:
							return &selEQInt16Int16ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int16)}, nil
						case 32:
							return &selEQInt16Int32ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int32)}, nil
						case -1:
						default:
							return &selEQInt16Int64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int64)}, nil
						}
					case types.FloatFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQInt16Float64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(float64)}, nil
						}
					case types.DecimalFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQInt16DecimalConstOp{selConstOpBase: selConstOpBase, constArg: c.(apd.Decimal)}, nil
						}
					}
				case 32:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.IntFamily:
						switch constType.Width() {
						case 16:
							return &selEQInt32Int16ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int16)}, nil
						case 32:
							return &selEQInt32Int32ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int32)}, nil
						case -1:
						default:
							return &selEQInt32Int64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int64)}, nil
						}
					case types.FloatFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQInt32Float64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(float64)}, nil
						}
					case types.DecimalFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQInt32DecimalConstOp{selConstOpBase: selConstOpBase, constArg: c.(apd.Decimal)}, nil
						}
					}
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.IntFamily:
						switch constType.Width() {
						case 16:
							return &selEQInt64Int16ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int16)}, nil
						case 32:
							return &selEQInt64Int32ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int32)}, nil
						case -1:
						default:
							return &selEQInt64Int64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int64)}, nil
						}
					case types.FloatFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQInt64Float64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(float64)}, nil
						}
					case types.DecimalFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQInt64DecimalConstOp{selConstOpBase: selConstOpBase, constArg: c.(apd.Decimal)}, nil
						}
					}
				}
			case types.FloatFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.IntFamily:
						switch constType.Width() {
						case 16:
							return &selEQFloat64Int16ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int16)}, nil
						case 32:
							return &selEQFloat64Int32ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int32)}, nil
						case -1:
						default:
							return &selEQFloat64Int64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int64)}, nil
						}
					case types.FloatFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQFloat64Float64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(float64)}, nil
						}
					case types.DecimalFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQFloat64DecimalConstOp{selConstOpBase: selConstOpBase, constArg: c.(apd.Decimal)}, nil
						}
					}
				}
			case types.TimestampTZFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.TimestampTZFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQTimestampTimestampConstOp{selConstOpBase: selConstOpBase, constArg: c.(time.Time)}, nil
						}
					}
				}
			case types.IntervalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.IntervalFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQIntervalIntervalConstOp{selConstOpBase: selConstOpBase, constArg: c.(duration.Duration)}, nil
						}
					}
				}
			case types.JsonFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.JsonFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQJSONJSONConstOp{selConstOpBase: selConstOpBase, constArg: c.(json.JSON)}, nil
						}
					}
				}
			case typeconv.DatumVecCanonicalTypeFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case typeconv.DatumVecCanonicalTypeFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selEQDatumDatumConstOp{selConstOpBase: selConstOpBase, constArg: c.(interface{})}, nil
						}
					}
				}
			}
		case treecmp.NE:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.BoolFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.BoolFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNEBoolBoolConstOp{selConstOpBase: selConstOpBase, constArg: c.(bool)}, nil
						}
					}
				}
			case types.BytesFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.BytesFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNEBytesBytesConstOp{selConstOpBase: selConstOpBase, constArg: c.([]byte)}, nil
						}
					}
				}
			case types.DecimalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.IntFamily:
						switch constType.Width() {
						case 16:
							return &selNEDecimalInt16ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int16)}, nil
						case 32:
							return &selNEDecimalInt32ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int32)}, nil
						case -1:
						default:
							return &selNEDecimalInt64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int64)}, nil
						}
					case types.FloatFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNEDecimalFloat64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(float64)}, nil
						}
					case types.DecimalFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNEDecimalDecimalConstOp{selConstOpBase: selConstOpBase, constArg: c.(apd.Decimal)}, nil
						}
					}
				}
			case types.IntFamily:
				switch leftType.Width() {
				case 16:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.IntFamily:
						switch constType.Width() {
						case 16:
							return &selNEInt16Int16ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int16)}, nil
						case 32:
							return &selNEInt16Int32ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int32)}, nil
						case -1:
						default:
							return &selNEInt16Int64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int64)}, nil
						}
					case types.FloatFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNEInt16Float64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(float64)}, nil
						}
					case types.DecimalFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNEInt16DecimalConstOp{selConstOpBase: selConstOpBase, constArg: c.(apd.Decimal)}, nil
						}
					}
				case 32:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.IntFamily:
						switch constType.Width() {
						case 16:
							return &selNEInt32Int16ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int16)}, nil
						case 32:
							return &selNEInt32Int32ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int32)}, nil
						case -1:
						default:
							return &selNEInt32Int64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int64)}, nil
						}
					case types.FloatFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNEInt32Float64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(float64)}, nil
						}
					case types.DecimalFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNEInt32DecimalConstOp{selConstOpBase: selConstOpBase, constArg: c.(apd.Decimal)}, nil
						}
					}
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.IntFamily:
						switch constType.Width() {
						case 16:
							return &selNEInt64Int16ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int16)}, nil
						case 32:
							return &selNEInt64Int32ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int32)}, nil
						case -1:
						default:
							return &selNEInt64Int64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int64)}, nil
						}
					case types.FloatFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNEInt64Float64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(float64)}, nil
						}
					case types.DecimalFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNEInt64DecimalConstOp{selConstOpBase: selConstOpBase, constArg: c.(apd.Decimal)}, nil
						}
					}
				}
			case types.FloatFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.IntFamily:
						switch constType.Width() {
						case 16:
							return &selNEFloat64Int16ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int16)}, nil
						case 32:
							return &selNEFloat64Int32ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int32)}, nil
						case -1:
						default:
							return &selNEFloat64Int64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int64)}, nil
						}
					case types.FloatFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNEFloat64Float64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(float64)}, nil
						}
					case types.DecimalFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNEFloat64DecimalConstOp{selConstOpBase: selConstOpBase, constArg: c.(apd.Decimal)}, nil
						}
					}
				}
			case types.TimestampTZFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.TimestampTZFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNETimestampTimestampConstOp{selConstOpBase: selConstOpBase, constArg: c.(time.Time)}, nil
						}
					}
				}
			case types.IntervalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.IntervalFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNEIntervalIntervalConstOp{selConstOpBase: selConstOpBase, constArg: c.(duration.Duration)}, nil
						}
					}
				}
			case types.JsonFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.JsonFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNEJSONJSONConstOp{selConstOpBase: selConstOpBase, constArg: c.(json.JSON)}, nil
						}
					}
				}
			case typeconv.DatumVecCanonicalTypeFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case typeconv.DatumVecCanonicalTypeFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selNEDatumDatumConstOp{selConstOpBase: selConstOpBase, constArg: c.(interface{})}, nil
						}
					}
				}
			}
		case treecmp.LT:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.BoolFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.BoolFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selLTBoolBoolConstOp{selConstOpBase: selConstOpBase, constArg: c.(bool)}, nil
						}
					}
				}
			case types.BytesFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.BytesFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selLTBytesBytesConstOp{selConstOpBase: selConstOpBase, constArg: c.([]byte)}, nil
						}
					}
				}
			case types.DecimalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(constType.Family()) {
					case types.IntFamily:
						switch constType.Width() {
						case 16:
							return &selLTDecimalInt16ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int16)}, nil
						case 32:
							return &selLTDecimalInt32ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int32)}, nil
						case -1:
						default:
							return &selLTDecimalInt64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(int64)}, nil
						}
					case types.FloatFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selLTDecimalFloat64ConstOp{selConstOpBase: selConstOpBase, constArg: c.(float64)}, nil
						}
					case types.DecimalFamily:
						switch constType.Width() {
						case -1:
						default:
							return &selLTDecimalDecimalConstOp{selConstOpBase: selConstOpBase, constArg: c.(apd.Decimal)}, nil
						}
					}
				}
			case types.IntFamily:
				switch leftType.Width() {
				case 16:
					switch typeconv.TypeF