// Code generated by execgen; DO NOT EDIT.

// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecsel

import (
	"bytes"
	"regexp"

	"github.com/cockroachdb/cockroach/pkg/col/coldata"
)

type selPrefixBytesBytesConstOp struct {
	selConstOpBase
	constArg        []byte
	negate          bool
	caseInsensitive bool
}

func (p *selPrefixBytesBytesConstOp) Next() coldata.Batch {
	_negate := p.negate
	_caseInsensitive := p.caseInsensitive
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bytes()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)
					if _caseInsensitive {
						arg = bytes.ToUpper(arg)
					}
					cmp = bytes.HasPrefix(arg, p.constArg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)
					if _caseInsensitive {
						arg = bytes.ToUpper(arg)
					}
					cmp = bytes.HasPrefix(arg, p.constArg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)
					if _caseInsensitive {
						arg = bytes.ToUpper(arg)
					}
					cmp = bytes.HasPrefix(arg, p.constArg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)
					if _caseInsensitive {
						arg = bytes.ToUpper(arg)
					}
					cmp = bytes.HasPrefix(arg, p.constArg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selSuffixBytesBytesConstOp struct {
	selConstOpBase
	constArg        []byte
	negate          bool
	caseInsensitive bool
}

func (p *selSuffixBytesBytesConstOp) Next() coldata.Batch {
	_negate := p.negate
	_caseInsensitive := p.caseInsensitive
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bytes()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)
					if _caseInsensitive {
						arg = bytes.ToUpper(arg)
					}
					cmp = bytes.HasSuffix(arg, p.constArg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)
					if _caseInsensitive {
						arg = bytes.ToUpper(arg)
					}
					cmp = bytes.HasSuffix(arg, p.constArg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)
					if _caseInsensitive {
						arg = bytes.ToUpper(arg)
					}
					cmp = bytes.HasSuffix(arg, p.constArg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)
					if _caseInsensitive {
						arg = bytes.ToUpper(arg)
					}
					cmp = bytes.HasSuffix(arg, p.constArg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selContainsBytesBytesConstOp struct {
	selConstOpBase
	constArg        []byte
	negate          bool
	caseInsensitive bool
}

func (p *selContainsBytesBytesConstOp) Next() coldata.Batch {
	_negate := p.negate
	_caseInsensitive := p.caseInsensitive
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bytes()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)
					if _caseInsensitive {
						arg = bytes.ToUpper(arg)
					}
					cmp = bytes.Contains(arg, p.constArg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)
					if _caseInsensitive {
						arg = bytes.ToUpper(arg)
					}
					cmp = bytes.Contains(arg, p.constArg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)
					if _caseInsensitive {
						arg = bytes.ToUpper(arg)
					}
					cmp = bytes.Contains(arg, p.constArg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)
					if _caseInsensitive {
						arg = bytes.ToUpper(arg)
					}
					cmp = bytes.Contains(arg, p.constArg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selSkeletonBytesBytesConstOp struct {
	selConstOpBase
	constArg        [][]byte
	negate          bool
	caseInsensitive bool
}

func (p *selSkeletonBytesBytesConstOp) Next() coldata.Batch {
	_negate := p.negate
	_caseInsensitive := p.caseInsensitive
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bytes()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						if _caseInsensitive {
							arg = bytes.ToUpper(arg)
						}
						var idx, skeletonIdx int
						for skeletonIdx < len(p.constArg) {
							idx = bytes.Index(arg, p.constArg[skeletonIdx])
							if idx < 0 {
								break
							}
							arg = arg[idx+len(p.constArg[skeletonIdx]):]
							skeletonIdx++
						}
						cmp = skeletonIdx == len(p.constArg) != _negate
					}
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)

					{
						if _caseInsensitive {
							arg = bytes.ToUpper(arg)
						}
						var idx, skeletonIdx int
						for skeletonIdx < len(p.constArg) {
							idx = bytes.Index(arg, p.constArg[skeletonIdx])
							if idx < 0 {
								break
							}
							arg = arg[idx+len(p.constArg[skeletonIdx]):]
							skeletonIdx++
						}
						cmp = skeletonIdx == len(p.constArg) != _negate
					}
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)

					{
						if _caseInsensitive {
							arg = bytes.ToUpper(arg)
						}
						var idx, skeletonIdx int
						for skeletonIdx < len(p.constArg) {
							idx = bytes.Index(arg, p.constArg[skeletonIdx])
							if idx < 0 {
								break
							}
							arg = arg[idx+len(p.constArg[skeletonIdx]):]
							skeletonIdx++
						}
						cmp = skeletonIdx == len(p.constArg) != _negate
					}
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)

					{
						if _caseInsensitive {
							arg = bytes.ToUpper(arg)
						}
						var idx, skeletonIdx int
						for skeletonIdx < len(p.constArg) {
							idx = bytes.Index(arg, p.constArg[skeletonIdx])
							if idx < 0 {
								break
							}
							arg = arg[idx+len(p.constArg[skeletonIdx]):]
							skeletonIdx++
						}
						cmp = skeletonIdx == len(p.constArg) != _negate
					}
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

type selRegexpBytesBytesConstOp struct {
	selConstOpBase
	constArg *regexp.Regexp
	negate   bool
}

func (p *selRegexpBytesBytesConstOp) Next() coldata.Batch {
	_negate := p.negate
	for {
		batch := p.Input.Next()
		if batch.Length() == 0 {
			return batch
		}

		vec := batch.ColVec(p.colIdx)
		col := vec.Bytes()
		var idx int
		n := batch.Length()
		if vec.MaybeHasNulls() {
			nulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)
					cmp = p.constArg.Match(arg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if nulls.NullAt(i) {
						continue
					}
					var cmp bool
					arg := col.Get(i)
					cmp = p.constArg.Match(arg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					var cmp bool
					arg := col.Get(i)
					cmp = p.constArg.Match(arg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			} else {
				batch.SetSelection(true)
				sel := batch.Selection()
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					var cmp bool
					arg := col.Get(i)
					cmp = p.constArg.Match(arg) != _negate
					if cmp {
						sel[idx] = i
						idx++
					}
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}
