// Code generated by execgen; DO NOT EDIT.
// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecprojconst

import (
	"bytes"
	"math"
	"time"
	"unsafe"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/server/telemetry"
	"github.com/cockroachdb/cockroach/pkg/sql/colconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexeccmp"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexecutils"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecop"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/eval"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree/treebin"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree/treecmp"
	"github.com/cockroachdb/cockroach/pkg/sql/sqltelemetry"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/cockroach/pkg/util/encoding"
	"github.com/cockroachdb/cockroach/pkg/util/json"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ apd.Context
	_ duration.Duration
	_ sqltelemetry.EnumTelemetryType
	_ telemetry.Counter
	_ json.JSON
	_ = coldataext.CompareDatum
)

type projBitandInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projBitandInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitandInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projBitandInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitandInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projBitandInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitandInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projBitandInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitandInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projBitandInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitandInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projBitandInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitandInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projBitandInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitandInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projBitandInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitandInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projBitandInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) & int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) & int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitandDatumDatumConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projBitandDatumDatumConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*colNulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projBitorInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projBitorInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitorInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projBitorInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitorInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projBitorInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitorInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projBitorInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitorInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projBitorInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitorInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projBitorInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitorInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projBitorInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitorInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projBitorInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitorInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projBitorInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) | int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) | int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitorDatumDatumConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projBitorDatumDatumConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*colNulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projBitxorInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projBitxorInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projBitxorInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projBitxorInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projBitxorInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projBitxorInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projBitxorInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projBitxorInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projBitxorInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projBitxorInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(arg) ^ int64(p.constArg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(arg) ^ int64(p.constArg)

				}
			}
		}
	})
	return batch
}

type projBitxorDatumDatumConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projBitxorDatumDatumConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*colNulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusDecimalInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projPlusDecimalInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Add(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Add(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Add(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Add(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPlusDecimalInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projPlusDecimalInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Add(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Add(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Add(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Add(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPlusDecimalInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projPlusDecimalInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Add(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Add(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Add(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Add(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPlusDecimalDecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPlusDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							_, err := tree.ExactCtx.Add(&projCol[i], &arg, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							_, err := tree.ExactCtx.Add(&projCol[i], &arg, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						_, err := tree.ExactCtx.Add(&projCol[i], &arg, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						_, err := tree.ExactCtx.Add(&projCol[i], &arg, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPlusInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projPlusInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projPlusInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projPlusInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt16DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPlusInt16DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPlusInt16DatumConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projPlusInt16DatumConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projPlusInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projPlusInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projPlusInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt32DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPlusInt32DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPlusInt32DatumConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projPlusInt32DatumConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projPlusInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projPlusInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projPlusInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) + int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) + int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPlusInt64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPlusInt64DatumConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projPlusInt64DatumConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusFloat64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projPlusFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Float64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							projCol[i] = float64(arg) + float64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							projCol[i] = float64(arg) + float64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						projCol[i] = float64(arg) + float64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						projCol[i] = float64(arg) + float64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projPlusTimestampIntervalConstOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projPlusTimestampIntervalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Times
	col = vec.Timestamp()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Timestamp()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						t_res := duration.Add(arg, p.constArg)
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						t_res := duration.Add(arg, p.constArg)
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					t_res := duration.Add(arg, p.constArg)
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					t_res := duration.Add(arg, p.constArg)
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			}
		}
	})
	return batch
}

type projPlusIntervalTimestampConstOp struct {
	projConstOpBase
	constArg time.Time
}

func (p projPlusIntervalTimestampConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Timestamp()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						t_res := duration.Add(p.constArg, arg)
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						t_res := duration.Add(p.constArg, arg)
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					t_res := duration.Add(p.constArg, arg)
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					t_res := duration.Add(p.constArg, arg)
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			}
		}
	})
	return batch
}

type projPlusIntervalIntervalConstOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projPlusIntervalIntervalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = arg.Add(p.constArg)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = arg.Add(p.constArg)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = arg.Add(p.constArg)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = arg.Add(p.constArg)
				}
			}
		}
	})
	return batch
}

type projPlusIntervalDatumConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projPlusIntervalDatumConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusDatumIntervalConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg duration.Duration
}

func (p projPlusDatumIntervalConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: p.constArg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: p.constArg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: p.constArg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: p.constArg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusDatumInt16ConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int16
}

func (p projPlusDatumInt16ConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusDatumInt32ConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int32
}

func (p projPlusDatumInt32ConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusDatumInt64ConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int64
}

func (p projPlusDatumInt64ConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDecimalInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projMinusDecimalInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMinusDecimalInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projMinusDecimalInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMinusDecimalInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projMinusDecimalInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMinusDecimalDecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMinusDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							_, err := tree.ExactCtx.Sub(&projCol[i], &arg, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							_, err := tree.ExactCtx.Sub(&projCol[i], &arg, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						_, err := tree.ExactCtx.Sub(&projCol[i], &arg, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						_, err := tree.ExactCtx.Sub(&projCol[i], &arg, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMinusInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projMinusInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projMinusInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projMinusInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt16DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMinusInt16DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMinusInt16DatumConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projMinusInt16DatumConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projMinusInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projMinusInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projMinusInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt32DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMinusInt32DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMinusInt32DatumConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projMinusInt32DatumConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projMinusInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projMinusInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projMinusInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(arg) - int64(p.constArg)
							if (result < int64(arg)) != (int64(p.constArg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(arg) - int64(p.constArg)
						if (result < int64(arg)) != (int64(p.constArg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMinusInt64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMinusInt64DatumConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projMinusInt64DatumConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusFloat64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projMinusFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Float64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							projCol[i] = float64(arg) - float64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							projCol[i] = float64(arg) - float64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						projCol[i] = float64(arg) - float64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						projCol[i] = float64(arg) - float64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projMinusTimestampTimestampConstOp struct {
	projConstOpBase
	constArg time.Time
}

func (p projMinusTimestampTimestampConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Times
	col = vec.Timestamp()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						nanos := arg.Sub(p.constArg).Nanoseconds()
						projCol[i] = duration.MakeDurationJustifyHours(nanos, 0, 0)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						nanos := arg.Sub(p.constArg).Nanoseconds()
						projCol[i] = duration.MakeDurationJustifyHours(nanos, 0, 0)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					nanos := arg.Sub(p.constArg).Nanoseconds()
					projCol[i] = duration.MakeDurationJustifyHours(nanos, 0, 0)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					nanos := arg.Sub(p.constArg).Nanoseconds()
					projCol[i] = duration.MakeDurationJustifyHours(nanos, 0, 0)

				}
			}
		}
	})
	return batch
}

type projMinusTimestampIntervalConstOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projMinusTimestampIntervalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Times
	col = vec.Timestamp()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Timestamp()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						t_res := duration.Add(arg, p.constArg.Mul(-1))
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						t_res := duration.Add(arg, p.constArg.Mul(-1))
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					t_res := duration.Add(arg, p.constArg.Mul(-1))
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					t_res := duration.Add(arg, p.constArg.Mul(-1))
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			}
		}
	})
	return batch
}

type projMinusIntervalIntervalConstOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projMinusIntervalIntervalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = arg.Sub(p.constArg)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = arg.Sub(p.constArg)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = arg.Sub(p.constArg)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = arg.Sub(p.constArg)
				}
			}
		}
	})
	return batch
}

type projMinusIntervalDatumConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projMinusIntervalDatumConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusJSONBytesConstOp struct {
	projConstOpBase
	constArg []byte
}

func (p projMinusJSONBytesConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// RemoveString.
						_j, _, _err := arg.RemoveString(*(*string)(unsafe.Pointer(&p.constArg)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// RemoveString.
						_j, _, _err := arg.RemoveString(*(*string)(unsafe.Pointer(&p.constArg)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// RemoveString.
					_j, _, _err := arg.RemoveString(*(*string)(unsafe.Pointer(&p.constArg)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// RemoveString.
					_j, _, _err := arg.RemoveString(*(*string)(unsafe.Pointer(&p.constArg)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)

				}
			}
		}
	})
	return batch
}

type projMinusJSONInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projMinusJSONInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _, _err := arg.RemoveIndex(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_j, _, _err := arg.RemoveIndex(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _, _err := arg.RemoveIndex(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_j, _, _err := arg.RemoveIndex(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			}
		}
	})
	return batch
}

type projMinusJSONInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projMinusJSONInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _, _err := arg.RemoveIndex(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_j, _, _err := arg.RemoveIndex(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _, _err := arg.RemoveIndex(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_j, _, _err := arg.RemoveIndex(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			}
		}
	})
	return batch
}

type projMinusJSONInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projMinusJSONInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _, _err := arg.RemoveIndex(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_j, _, _err := arg.RemoveIndex(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _, _err := arg.RemoveIndex(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_j, _, _err := arg.RemoveIndex(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			}
		}
	})
	return batch
}

type projMinusDatumDatumConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projMinusDatumDatumConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*colNulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDatumIntervalConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg duration.Duration
}

func (p projMinusDatumIntervalConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: p.constArg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: p.constArg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: p.constArg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: p.constArg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDatumBytesConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg []byte
}

func (p projMinusDatumBytesConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DString(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DString(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DString(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DString(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDatumInt16ConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int16
}

func (p projMinusDatumInt16ConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDatumInt32ConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int32
}

func (p projMinusDatumInt32ConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDatumInt64ConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int64
}

func (p projMinusDatumInt64ConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMultDecimalInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projMultDecimalInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMultDecimalInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projMultDecimalInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMultDecimalInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projMultDecimalInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMultDecimalDecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMultDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							_, err := tree.ExactCtx.Mul(&projCol[i], &arg, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							_, err := tree.ExactCtx.Mul(&projCol[i], &arg, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						_, err := tree.ExactCtx.Mul(&projCol[i], &arg, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						_, err := tree.ExactCtx.Mul(&projCol[i], &arg, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMultDecimalIntervalConstOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projMultDecimalIntervalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						f, err := arg.Float64()
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						projCol[i] = p.constArg.MulFloat(f)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						f, err := arg.Float64()
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						projCol[i] = p.constArg.MulFloat(f)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					f, err := arg.Float64()
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					projCol[i] = p.constArg.MulFloat(f)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					f, err := arg.Float64()
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					projCol[i] = p.constArg.MulFloat(f)
				}
			}
		}
	})
	return batch
}

type projMultInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projMultInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt8 || _left < math.MinInt8 || _right > math.MaxInt8 || _right < math.MinInt8 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt8 || _left < math.MinInt8 || _right > math.MaxInt8 || _right < math.MinInt8 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt8 || _left < math.MinInt8 || _right > math.MaxInt8 || _right < math.MinInt8 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt8 || _left < math.MinInt8 || _right > math.MaxInt8 || _right < math.MinInt8 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projMultInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projMultInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt16DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMultInt16DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMultInt16IntervalConstOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projMultInt16IntervalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = p.constArg.Mul(int64(arg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = p.constArg.Mul(int64(arg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = p.constArg.Mul(int64(arg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = p.constArg.Mul(int64(arg))
				}
			}
		}
	})
	return batch
}

type projMultInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projMultInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projMultInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt16 || _left < math.MinInt16 || _right > math.MaxInt16 || _right < math.MinInt16 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt16 || _left < math.MinInt16 || _right > math.MaxInt16 || _right < math.MinInt16 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt16 || _left < math.MinInt16 || _right > math.MaxInt16 || _right < math.MinInt16 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt16 || _left < math.MinInt16 || _right > math.MaxInt16 || _right < math.MinInt16 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projMultInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt32DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMultInt32DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMultInt32IntervalConstOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projMultInt32IntervalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = p.constArg.Mul(int64(arg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = p.constArg.Mul(int64(arg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = p.constArg.Mul(int64(arg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = p.constArg.Mul(int64(arg))
				}
			}
		}
	})
	return batch
}

type projMultInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projMultInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projMultInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projMultInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(arg), int64(p.constArg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(arg), int64(p.constArg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMultInt64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMultInt64IntervalConstOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projMultInt64IntervalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = p.constArg.Mul(int64(arg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = p.constArg.Mul(int64(arg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = p.constArg.Mul(int64(arg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = p.constArg.Mul(int64(arg))
				}
			}
		}
	})
	return batch
}

type projMultFloat64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projMultFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Float64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							projCol[i] = float64(arg) * float64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							projCol[i] = float64(arg) * float64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						projCol[i] = float64(arg) * float64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						projCol[i] = float64(arg) * float64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projMultFloat64IntervalConstOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projMultFloat64IntervalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = p.constArg.MulFloat(float64(arg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = p.constArg.MulFloat(float64(arg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = p.constArg.MulFloat(float64(arg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = p.constArg.MulFloat(float64(arg))
				}
			}
		}
	})
	return batch
}

type projMultIntervalInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projMultIntervalInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = arg.Mul(int64(p.constArg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = arg.Mul(int64(p.constArg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = arg.Mul(int64(p.constArg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = arg.Mul(int64(p.constArg))
				}
			}
		}
	})
	return batch
}

type projMultIntervalInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projMultIntervalInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = arg.Mul(int64(p.constArg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = arg.Mul(int64(p.constArg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = arg.Mul(int64(p.constArg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = arg.Mul(int64(p.constArg))
				}
			}
		}
	})
	return batch
}

type projMultIntervalInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projMultIntervalInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = arg.Mul(int64(p.constArg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = arg.Mul(int64(p.constArg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = arg.Mul(int64(p.constArg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = arg.Mul(int64(p.constArg))
				}
			}
		}
	})
	return batch
}

type projMultIntervalFloat64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projMultIntervalFloat64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = arg.MulFloat(float64(p.constArg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = arg.MulFloat(float64(p.constArg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = arg.MulFloat(float64(p.constArg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = arg.MulFloat(float64(p.constArg))
				}
			}
		}
	})
	return batch
}

type projMultIntervalDecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMultIntervalDecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						f, err := p.constArg.Float64()
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						projCol[i] = arg.MulFloat(f)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						f, err := p.constArg.Float64()
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						projCol[i] = arg.MulFloat(f)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					f, err := p.constArg.Float64()
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					projCol[i] = arg.MulFloat(f)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					f, err := p.constArg.Float64()
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					projCol[i] = arg.MulFloat(f)
				}
			}
		}
	})
	return batch
}

type projDivDecimalInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projDivDecimalInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivDecimalInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projDivDecimalInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivDecimalInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projDivDecimalInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivDecimalDecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projDivDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg.IsZero() && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite && arg.Form == apd.Finite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg.IsZero() && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite && arg.Form == apd.Finite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg.IsZero() && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite && arg.Form == apd.Finite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg.IsZero() && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.DecimalCtx.Quo(&projCol[i], &arg, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite && arg.Form == apd.Finite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projDivInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projDivInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projDivInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projDivInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt16DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projDivInt16DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projDivInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projDivInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projDivInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projDivInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt32DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projDivInt32DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projDivInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projDivInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projDivInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projDivInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projDivInt64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projDivFloat64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projDivFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Float64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg == 0.0 && !math.IsNaN(arg) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = float64(arg) / float64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg == 0.0 && !math.IsNaN(arg) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = float64(arg) / float64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg == 0.0 && !math.IsNaN(arg) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = float64(arg) / float64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg == 0.0 && !math.IsNaN(arg) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = float64(arg) / float64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projDivIntervalInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projDivIntervalInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						if p.constArg == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg.Div(int64(p.constArg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						if p.constArg == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg.Div(int64(p.constArg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					if p.constArg == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg.Div(int64(p.constArg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					if p.constArg == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg.Div(int64(p.constArg))
				}
			}
		}
	})
	return batch
}

type projDivIntervalInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projDivIntervalInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						if p.constArg == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg.Div(int64(p.constArg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						if p.constArg == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg.Div(int64(p.constArg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					if p.constArg == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg.Div(int64(p.constArg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					if p.constArg == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg.Div(int64(p.constArg))
				}
			}
		}
	})
	return batch
}

type projDivIntervalInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projDivIntervalInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						if p.constArg == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg.Div(int64(p.constArg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						if p.constArg == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg.Div(int64(p.constArg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					if p.constArg == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg.Div(int64(p.constArg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					if p.constArg == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg.Div(int64(p.constArg))
				}
			}
		}
	})
	return batch
}

type projDivIntervalFloat64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projDivIntervalFloat64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						if p.constArg == 0.0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg.DivFloat(float64(p.constArg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						if p.constArg == 0.0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg.DivFloat(float64(p.constArg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					if p.constArg == 0.0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg.DivFloat(float64(p.constArg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					if p.constArg == 0.0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg.DivFloat(float64(p.constArg))
				}
			}
		}
	})
	return batch
}

type projFloorDivDecimalInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projFloorDivDecimalInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivDecimalInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projFloorDivDecimalInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivDecimalInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projFloorDivDecimalInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivDecimalDecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projFloorDivDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg.IsZero() && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite && arg.Form == apd.Finite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg.IsZero() && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite && arg.Form == apd.Finite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg.IsZero() && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite && arg.Form == apd.Finite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg.IsZero() && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite && arg.Form == apd.Finite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projFloorDivInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projFloorDivInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projFloorDivInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt16DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projFloorDivInt16DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projFloorDivInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projFloorDivInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projFloorDivInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt32DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projFloorDivInt32DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projFloorDivInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projFloorDivInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projFloorDivInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) / int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) / int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projFloorDivInt64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if p.constArg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if p.constArg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projFloorDivFloat64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projFloorDivFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Float64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg == 0.0 && !math.IsNaN(arg) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = math.Trunc(float64(arg) / float64(p.constArg))
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg == 0.0 && !math.IsNaN(arg) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = math.Trunc(float64(arg) / float64(p.constArg))
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg == 0.0 && !math.IsNaN(arg) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = math.Trunc(float64(arg) / float64(p.constArg))
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg == 0.0 && !math.IsNaN(arg) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = math.Trunc(float64(arg) / float64(p.constArg))
					}

				}
			}
		}
	})
	return batch
}

type projModDecimalInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projModDecimalInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projModDecimalInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projModDecimalInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projModDecimalInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projModDecimalInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg == 0 && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg == 0 && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projModDecimalDecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projModDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg.IsZero() && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg.IsZero() && arg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg.IsZero() && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg.IsZero() && arg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projModInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projModInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projModInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projModInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt16DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projModInt16DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projModInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projModInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projModInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projModInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt32DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projModInt32DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projModInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projModInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projModInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projModInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg) % int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg) % int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projModInt64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projModFloat64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projModFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Float64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if p.constArg == 0.0 && !math.IsNaN(arg) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = math.Mod(float64(arg), float64(p.constArg))
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if p.constArg == 0.0 && !math.IsNaN(arg) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = math.Mod(float64(arg), float64(p.constArg))
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if p.constArg == 0.0 && !math.IsNaN(arg) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = math.Mod(float64(arg), float64(p.constArg))
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if p.constArg == 0.0 && !math.IsNaN(arg) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = math.Mod(float64(arg), float64(p.constArg))
					}

				}
			}
		}
	})
	return batch
}

type projPowDecimalInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projPowDecimalInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPowDecimalInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projPowDecimalInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPowDecimalInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projPowDecimalInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPowDecimalDecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPowDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							_, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							_, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						_, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						_, err := tree.DecimalCtx.Pow(&projCol[i], &arg, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPowInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projPowInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projPowInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projPowInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt16DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPowInt16DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPowInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projPowInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projPowInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projPowInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt32DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPowInt32DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPowInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projPowInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projPowInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projPowInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg)))
							rightTmpDec.SetInt64(int64(int64(p.constArg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg)))
						rightTmpDec.SetInt64(int64(int64(p.constArg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPowInt64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPowFloat64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projPowFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Float64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							projCol[i] = math.Pow(float64(arg), float64(p.constArg))
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							projCol[i] = math.Pow(float64(arg), float64(p.constArg))
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						projCol[i] = math.Pow(float64(arg), float64(p.constArg))
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						projCol[i] = math.Pow(float64(arg), float64(p.constArg))
					}

				}
			}
		}
	})
	return batch
}

type projConcatBytesBytesConstOp struct {
	projConstOpBase
	constArg []byte
}

func (p projConcatBytesBytesConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.Bytes
	col = vec.Bytes()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bytes()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var r = []byte{}
							r = append(r, arg...)
							r = append(r, p.constArg...)
							projCol.Set(i, r)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var r = []byte{}
							r = append(r, arg...)
							r = append(r, p.constArg...)
							projCol.Set(i, r)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var r = []byte{}
						r = append(r, arg...)
						r = append(r, p.constArg...)
						projCol.Set(i, r)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					{
						var r = []byte{}
						r = append(r, arg...)
						r = append(r, p.constArg...)
						projCol.Set(i, r)
					}

				}
			}
		}
	})
	return batch
}

type projConcatJSONJSONConstOp struct {
	projConstOpBase
	constArg json.JSON
}

func (p projConcatJSONJSONConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := arg.Concat(p.constArg)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := arg.Concat(p.constArg)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

						projCol.Set(i, _j)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _err := arg.Concat(p.constArg)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}

					projCol.Set(i, _j)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_j, _err := arg.Concat(p.constArg)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}

					projCol.Set(i, _j)
				}
			}
		}
	})
	return batch
}

type projConcatDatumDatumConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projConcatDatumDatumConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*colNulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), p.constArg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projLShiftInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projLShiftInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projLShiftInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projLShiftInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projLShiftInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projLShiftInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projLShiftInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projLShiftInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projLShiftInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projLShiftInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) << int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) << int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftDatumInt16ConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int16
}

func (p projLShiftDatumInt16ConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projLShiftDatumInt32ConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int32
}

func (p projLShiftDatumInt32ConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projLShiftDatumInt64ConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int64
}

func (p projLShiftDatumInt64ConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projRShiftInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projRShiftInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projRShiftInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projRShiftInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projRShiftInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projRShiftInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projRShiftInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projRShiftInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projRShiftInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projRShiftInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg) >> int64(p.constArg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(p.constArg) < 0 || int64(p.constArg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg) >> int64(p.constArg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftDatumInt16ConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int16
}

func (p projRShiftDatumInt16ConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projRShiftDatumInt32ConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int32
}

func (p projRShiftDatumInt32ConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projRShiftDatumInt64ConstOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int64
}

func (p projRShiftDatumInt64ConstOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projJSONFetchValJSONBytesConstOp struct {
	projConstOpBase
	constArg []byte
}

func (p projJSONFetchValJSONBytesConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// FetchValKey.
						_j, _err := arg.FetchValKey(*(*string)(unsafe.Pointer(&p.constArg)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// FetchValKey.
						_j, _err := arg.FetchValKey(*(*string)(unsafe.Pointer(&p.constArg)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// FetchValKey.
					_j, _err := arg.FetchValKey(*(*string)(unsafe.Pointer(&p.constArg)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// FetchValKey.
					_j, _err := arg.FetchValKey(*(*string)(unsafe.Pointer(&p.constArg)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchValJSONInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projJSONFetchValJSONInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := arg.FetchValIdx(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_j, _err := arg.FetchValIdx(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _err := arg.FetchValIdx(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_j, _err := arg.FetchValIdx(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchValJSONInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projJSONFetchValJSONInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := arg.FetchValIdx(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_j, _err := arg.FetchValIdx(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _err := arg.FetchValIdx(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_j, _err := arg.FetchValIdx(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchValJSONInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projJSONFetchValJSONInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := arg.FetchValIdx(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_j, _err := arg.FetchValIdx(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _err := arg.FetchValIdx(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_j, _err := arg.FetchValIdx(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchTextJSONBytesConstOp struct {
	projConstOpBase
	constArg []byte
}

func (p projJSONFetchTextJSONBytesConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bytes()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// FetchValKey.
						_j, _err := arg.FetchValKey(*(*string)(unsafe.Pointer(&p.constArg)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// FetchValKey.
						_j, _err := arg.FetchValKey(*(*string)(unsafe.Pointer(&p.constArg)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// FetchValKey.
					_j, _err := arg.FetchValKey(*(*string)(unsafe.Pointer(&p.constArg)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// FetchValKey.
					_j, _err := arg.FetchValKey(*(*string)(unsafe.Pointer(&p.constArg)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchTextJSONInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projJSONFetchTextJSONInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bytes()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := arg.FetchValIdx(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_j, _err := arg.FetchValIdx(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _err := arg.FetchValIdx(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_j, _err := arg.FetchValIdx(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchTextJSONInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projJSONFetchTextJSONInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bytes()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := arg.FetchValIdx(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_j, _err := arg.FetchValIdx(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _err := arg.FetchValIdx(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_j, _err := arg.FetchValIdx(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchTextJSONInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projJSONFetchTextJSONInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bytes()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := arg.FetchValIdx(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_j, _err := arg.FetchValIdx(int(p.constArg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _err := arg.FetchValIdx(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_j, _err := arg.FetchValIdx(int(p.constArg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchValPathJSONDatumConstOp struct {
	projConstOpBase
	constArg interface{}
}

func (p projJSONFetchValPathJSONDatumConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_path, _err := tree.GetJSONPath(arg, *tree.MustBeDArray(p.constArg.(tree.Datum)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _path == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _path)
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_path, _err := tree.GetJSONPath(arg, *tree.MustBeDArray(p.constArg.(tree.Datum)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _path == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _path)
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_path, _err := tree.GetJSONPath(arg, *tree.MustBeDArray(p.constArg.(tree.Datum)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _path == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _path)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_path, _err := tree.GetJSONPath(arg, *tree.MustBeDArray(p.constArg.(tree.Datum)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _path == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _path)
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchTextPathJSONDatumConstOp struct {
	projConstOpBase
	constArg interface{}
}

func (p projJSONFetchTextPathJSONDatumConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bytes()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_path, _err := tree.GetJSONPath(arg, *tree.MustBeDArray(p.constArg.(tree.Datum)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _path == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _path.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}

						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_path, _err := tree.GetJSONPath(arg, *tree.MustBeDArray(p.constArg.(tree.Datum)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _path == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _path.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}

						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_path, _err := tree.GetJSONPath(arg, *tree.MustBeDArray(p.constArg.(tree.Datum)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _path == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _path.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_path, _err := tree.GetJSONPath(arg, *tree.MustBeDArray(p.constArg.(tree.Datum)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _path == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _path.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}

					}
				}
			}
		}
	})
	return batch
}

type projEQBoolBoolConstOp struct {
	projConstOpBase
	constArg bool
}

func (p projEQBoolBoolConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Bools
	col = vec.Bool()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							if !arg && p.constArg {
								cmpResult = -1
							} else if arg && !p.constArg {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							if !arg && p.constArg {
								cmpResult = -1
							} else if arg && !p.constArg {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQBytesBytesConstOp struct {
	projConstOpBase
	constArg []byte
}

func (p projEQBytesBytesConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.Bytes
	col = vec.Bytes()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg, p.constArg)
							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg, p.constArg)
							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQDecimalInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projEQDecimalInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQDecimalInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projEQDecimalInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQDecimalInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projEQDecimalInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQDecimalFloat64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projEQDecimalFloat64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQDecimalDecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projEQDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg, &p.constArg)
							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg, &p.constArg)
							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projEQInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projEQInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projEQInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt16Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projEQInt16Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt16DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projEQInt16DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projEQInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projEQInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projEQInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt32Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projEQInt32Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt32DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projEQInt32DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projEQInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projEQInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projEQInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projEQInt64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projEQInt64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQFloat64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projEQFloat64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQFloat64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projEQFloat64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQFloat64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projEQFloat64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQFloat64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projEQFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQFloat64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projEQFloat64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQTimestampTimestampConstOp struct {
	projConstOpBase
	constArg time.Time
}

func (p projEQTimestampTimestampConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Times
	col = vec.Timestamp()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							if arg.Before(p.constArg) {
								cmpResult = -1
							} else if p.constArg.Before(arg) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							if arg.Before(p.constArg) {
								cmpResult = -1
							} else if p.constArg.Before(arg) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQIntervalIntervalConstOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projEQIntervalIntervalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = arg.Compare(p.constArg)
							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = arg.Compare(p.constArg)
							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQJSONJSONConstOp struct {
	projConstOpBase
	constArg json.JSON
}

func (p projEQJSONJSONConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							var err error
							cmpResult, err = arg.Compare(p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							var err error
							cmpResult, err = arg.Compare(p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQDatumDatumConstOp struct {
	projConstOpBase
	constArg interface{}
}

func (p projEQDatumDatumConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*colNulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projNEBoolBoolConstOp struct {
	projConstOpBase
	constArg bool
}

func (p projNEBoolBoolConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Bools
	col = vec.Bool()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							if !arg && p.constArg {
								cmpResult = -1
							} else if arg && !p.constArg {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							if !arg && p.constArg {
								cmpResult = -1
							} else if arg && !p.constArg {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEBytesBytesConstOp struct {
	projConstOpBase
	constArg []byte
}

func (p projNEBytesBytesConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.Bytes
	col = vec.Bytes()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg, p.constArg)
							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg, p.constArg)
							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEDecimalInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projNEDecimalInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEDecimalInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projNEDecimalInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEDecimalInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projNEDecimalInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEDecimalFloat64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projNEDecimalFloat64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEDecimalDecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projNEDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg, &p.constArg)
							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg, &p.constArg)
							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projNEInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projNEInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projNEInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt16Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projNEInt16Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt16DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projNEInt16DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projNEInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projNEInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projNEInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt32Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projNEInt32Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt32DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projNEInt32DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projNEInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projNEInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projNEInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projNEInt64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projNEInt64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEFloat64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projNEFloat64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEFloat64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projNEFloat64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEFloat64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projNEFloat64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEFloat64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projNEFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEFloat64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projNEFloat64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNETimestampTimestampConstOp struct {
	projConstOpBase
	constArg time.Time
}

func (p projNETimestampTimestampConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Times
	col = vec.Timestamp()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							if arg.Before(p.constArg) {
								cmpResult = -1
							} else if p.constArg.Before(arg) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							if arg.Before(p.constArg) {
								cmpResult = -1
							} else if p.constArg.Before(arg) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEIntervalIntervalConstOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projNEIntervalIntervalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = arg.Compare(p.constArg)
							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = arg.Compare(p.constArg)
							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEJSONJSONConstOp struct {
	projConstOpBase
	constArg json.JSON
}

func (p projNEJSONJSONConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							var err error
							cmpResult, err = arg.Compare(p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							var err error
							cmpResult, err = arg.Compare(p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEDatumDatumConstOp struct {
	projConstOpBase
	constArg interface{}
}

func (p projNEDatumDatumConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*colNulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projLTBoolBoolConstOp struct {
	projConstOpBase
	constArg bool
}

func (p projLTBoolBoolConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Bools
	col = vec.Bool()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							if !arg && p.constArg {
								cmpResult = -1
							} else if arg && !p.constArg {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							if !arg && p.constArg {
								cmpResult = -1
							} else if arg && !p.constArg {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTBytesBytesConstOp struct {
	projConstOpBase
	constArg []byte
}

func (p projLTBytesBytesConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.Bytes
	col = vec.Bytes()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg, p.constArg)
							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg, p.constArg)
							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTDecimalInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projLTDecimalInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTDecimalInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projLTDecimalInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTDecimalInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projLTDecimalInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTDecimalFloat64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projLTDecimalFloat64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTDecimalDecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projLTDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg, &p.constArg)
							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg, &p.constArg)
							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projLTInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projLTInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projLTInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt16Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projLTInt16Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt16DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projLTInt16DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projLTInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projLTInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projLTInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt32Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projLTInt32Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt32DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projLTInt32DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projLTInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projLTInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projLTInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projLTInt64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projLTInt64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTFloat64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projLTFloat64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTFloat64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projLTFloat64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTFloat64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projLTFloat64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTFloat64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projLTFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTFloat64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projLTFloat64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTTimestampTimestampConstOp struct {
	projConstOpBase
	constArg time.Time
}

func (p projLTTimestampTimestampConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Times
	col = vec.Timestamp()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							if arg.Before(p.constArg) {
								cmpResult = -1
							} else if p.constArg.Before(arg) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							if arg.Before(p.constArg) {
								cmpResult = -1
							} else if p.constArg.Before(arg) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTIntervalIntervalConstOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projLTIntervalIntervalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = arg.Compare(p.constArg)
							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = arg.Compare(p.constArg)
							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTJSONJSONConstOp struct {
	projConstOpBase
	constArg json.JSON
}

func (p projLTJSONJSONConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							var err error
							cmpResult, err = arg.Compare(p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							var err error
							cmpResult, err = arg.Compare(p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTDatumDatumConstOp struct {
	projConstOpBase
	constArg interface{}
}

func (p projLTDatumDatumConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*colNulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLEBoolBoolConstOp struct {
	projConstOpBase
	constArg bool
}

func (p projLEBoolBoolConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Bools
	col = vec.Bool()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							if !arg && p.constArg {
								cmpResult = -1
							} else if arg && !p.constArg {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							if !arg && p.constArg {
								cmpResult = -1
							} else if arg && !p.constArg {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEBytesBytesConstOp struct {
	projConstOpBase
	constArg []byte
}

func (p projLEBytesBytesConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.Bytes
	col = vec.Bytes()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg, p.constArg)
							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg, p.constArg)
							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEDecimalInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projLEDecimalInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEDecimalInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projLEDecimalInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEDecimalInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projLEDecimalInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEDecimalFloat64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projLEDecimalFloat64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEDecimalDecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projLEDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg, &p.constArg)
							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg, &p.constArg)
							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projLEInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projLEInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projLEInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt16Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projLEInt16Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt16DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projLEInt16DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projLEInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projLEInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projLEInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt32Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projLEInt32Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt32DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projLEInt32DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projLEInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projLEInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projLEInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projLEInt64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projLEInt64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEFloat64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projLEFloat64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEFloat64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projLEFloat64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEFloat64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projLEFloat64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEFloat64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projLEFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEFloat64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projLEFloat64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLETimestampTimestampConstOp struct {
	projConstOpBase
	constArg time.Time
}

func (p projLETimestampTimestampConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Times
	col = vec.Timestamp()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							if arg.Before(p.constArg) {
								cmpResult = -1
							} else if p.constArg.Before(arg) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							if arg.Before(p.constArg) {
								cmpResult = -1
							} else if p.constArg.Before(arg) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if arg.Before(p.constArg) {
							cmpResult = -1
						} else if p.constArg.Before(arg) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEIntervalIntervalConstOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projLEIntervalIntervalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = arg.Compare(p.constArg)
							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = arg.Compare(p.constArg)
							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = arg.Compare(p.constArg)
						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEJSONJSONConstOp struct {
	projConstOpBase
	constArg json.JSON
}

func (p projLEJSONJSONConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							var err error
							cmpResult, err = arg.Compare(p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							var err error
							cmpResult, err = arg.Compare(p.constArg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg.Compare(p.constArg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEDatumDatumConstOp struct {
	projConstOpBase
	constArg interface{}
}

func (p projLEDatumDatumConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*colNulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg, col, p.constArg)

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projGTBoolBoolConstOp struct {
	projConstOpBase
	constArg bool
}

func (p projGTBoolBoolConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Bools
	col = vec.Bool()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							if !arg && p.constArg {
								cmpResult = -1
							} else if arg && !p.constArg {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							if !arg && p.constArg {
								cmpResult = -1
							} else if arg && !p.constArg {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						if !arg && p.constArg {
							cmpResult = -1
						} else if arg && !p.constArg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTBytesBytesConstOp struct {
	projConstOpBase
	constArg []byte
}

func (p projGTBytesBytesConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.Bytes
	col = vec.Bytes()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg, p.constArg)
							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg, p.constArg)
							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg, p.constArg)
						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTDecimalInt16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projGTDecimalInt16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTDecimalInt32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projGTDecimalInt32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTDecimalInt64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projGTDecimalInt64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(p.constArg))
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTDecimalFloat64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projGTDecimalFloat64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg, &tmpDec)
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(p.constArg)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg, &tmpDec)
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTDecimalDecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projGTDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg, &p.constArg)
							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg, &p.constArg)
							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg, &p.constArg)
						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTInt16Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projGTInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTInt16Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projGTInt16Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTInt16Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projGTInt16Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTInt16Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projGTInt16Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTInt16DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projGTInt16DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTInt32Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projGTInt32Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTInt32Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projGTInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTInt32Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projGTInt32Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTInt32Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projGTInt32Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTInt32DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projGTInt32DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTInt64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projGTInt64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTInt64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projGTInt64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTInt64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projGTInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg), int64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg), int64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTInt64Float64ConstOp struct {
	projConstOpBase
	constArg float64
}

func (p projGTInt64Float64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTInt64DecimalConstOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projGTInt64DecimalConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg))
								cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							cmpResult = tree.CompareDecimals(&tmpDec, &p.constArg)
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTFloat64Int16ConstOp struct {
	projConstOpBase
	constArg int16
}

func (p projGTFloat64Int16ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTFloat64Int32ConstOp struct {
	projConstOpBase
	constArg int32
}

func (p projGTFloat64Int32ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg), float64(p.constArg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult > 0
					}

				}
			}
		}
	})
	return batch
}

type projGTFloat64Int64ConstOp struct {
	projConstOpBase
	constArg int64
}

func (p projGTFloat64Int64ConstOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bool()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult > 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg), float64(p.constArg)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if mat