// Code generated by execgen; DO NOT EDIT.
// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecprojconst

import (
	"math"
	"time"
	"unsafe"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/server/telemetry"
	"github.com/cockroachdb/cockroach/pkg/sql/colconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexecutils"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecop"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/eval"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree/treebin"
	"github.com/cockroachdb/cockroach/pkg/sql/sqltelemetry"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/cockroach/pkg/util/encoding"
	"github.com/cockroachdb/cockroach/pkg/util/json"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ apd.Context
	_ duration.Duration
	_ sqltelemetry.EnumTelemetryType
	_ telemetry.Counter
	_ json.JSON
	_ = coldataext.CompareDatum
)

type projBitandInt16ConstInt16Op struct {
	projConstOpBase
	constArg int16
}

func (p projBitandInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitandInt16ConstInt32Op struct {
	projConstOpBase
	constArg int16
}

func (p projBitandInt16ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitandInt16ConstInt64Op struct {
	projConstOpBase
	constArg int16
}

func (p projBitandInt16ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitandInt32ConstInt16Op struct {
	projConstOpBase
	constArg int32
}

func (p projBitandInt32ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitandInt32ConstInt32Op struct {
	projConstOpBase
	constArg int32
}

func (p projBitandInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitandInt32ConstInt64Op struct {
	projConstOpBase
	constArg int32
}

func (p projBitandInt32ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitandInt64ConstInt16Op struct {
	projConstOpBase
	constArg int64
}

func (p projBitandInt64ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitandInt64ConstInt32Op struct {
	projConstOpBase
	constArg int64
}

func (p projBitandInt64ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitandInt64ConstInt64Op struct {
	projConstOpBase
	constArg int64
}

func (p projBitandInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) & int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) & int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitandDatumConstDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projBitandDatumConstDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*colNulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projBitorInt16ConstInt16Op struct {
	projConstOpBase
	constArg int16
}

func (p projBitorInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitorInt16ConstInt32Op struct {
	projConstOpBase
	constArg int16
}

func (p projBitorInt16ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitorInt16ConstInt64Op struct {
	projConstOpBase
	constArg int16
}

func (p projBitorInt16ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitorInt32ConstInt16Op struct {
	projConstOpBase
	constArg int32
}

func (p projBitorInt32ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitorInt32ConstInt32Op struct {
	projConstOpBase
	constArg int32
}

func (p projBitorInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitorInt32ConstInt64Op struct {
	projConstOpBase
	constArg int32
}

func (p projBitorInt32ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitorInt64ConstInt16Op struct {
	projConstOpBase
	constArg int64
}

func (p projBitorInt64ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitorInt64ConstInt32Op struct {
	projConstOpBase
	constArg int64
}

func (p projBitorInt64ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitorInt64ConstInt64Op struct {
	projConstOpBase
	constArg int64
}

func (p projBitorInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) | int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) | int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitorDatumConstDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projBitorDatumConstDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*colNulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projBitxorInt16ConstInt16Op struct {
	projConstOpBase
	constArg int16
}

func (p projBitxorInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt16ConstInt32Op struct {
	projConstOpBase
	constArg int16
}

func (p projBitxorInt16ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt16ConstInt64Op struct {
	projConstOpBase
	constArg int16
}

func (p projBitxorInt16ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt32ConstInt16Op struct {
	projConstOpBase
	constArg int32
}

func (p projBitxorInt32ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt32ConstInt32Op struct {
	projConstOpBase
	constArg int32
}

func (p projBitxorInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt32ConstInt64Op struct {
	projConstOpBase
	constArg int32
}

func (p projBitxorInt32ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt64ConstInt16Op struct {
	projConstOpBase
	constArg int64
}

func (p projBitxorInt64ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt64ConstInt32Op struct {
	projConstOpBase
	constArg int64
}

func (p projBitxorInt64ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitxorInt64ConstInt64Op struct {
	projConstOpBase
	constArg int64
}

func (p projBitxorInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						projCol[i] = int64(p.constArg) ^ int64(arg)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					projCol[i] = int64(p.constArg) ^ int64(arg)

				}
			}
		}
	})
	return batch
}

type projBitxorDatumConstDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projBitxorDatumConstDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*colNulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusDecimalConstInt16Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPlusDecimalConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPlusDecimalConstInt32Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPlusDecimalConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPlusDecimalConstInt64Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPlusDecimalConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPlusDecimalConstDecimalOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPlusDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							_, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							_, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						_, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						_, err := tree.ExactCtx.Add(&projCol[i], &p.constArg, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPlusInt16ConstInt16Op struct {
	projConstOpBase
	constArg int16
}

func (p projPlusInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt16ConstInt32Op struct {
	projConstOpBase
	constArg int16
}

func (p projPlusInt16ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt16ConstInt64Op struct {
	projConstOpBase
	constArg int16
}

func (p projPlusInt16ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt16ConstDecimalOp struct {
	projConstOpBase
	constArg int16
}

func (p projPlusInt16ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPlusInt16ConstDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int16
}

func (p projPlusInt16ConstDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusInt32ConstInt16Op struct {
	projConstOpBase
	constArg int32
}

func (p projPlusInt32ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt32ConstInt32Op struct {
	projConstOpBase
	constArg int32
}

func (p projPlusInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt32ConstInt64Op struct {
	projConstOpBase
	constArg int32
}

func (p projPlusInt32ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt32ConstDecimalOp struct {
	projConstOpBase
	constArg int32
}

func (p projPlusInt32ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPlusInt32ConstDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int32
}

func (p projPlusInt32ConstDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusInt64ConstInt16Op struct {
	projConstOpBase
	constArg int64
}

func (p projPlusInt64ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt64ConstInt32Op struct {
	projConstOpBase
	constArg int64
}

func (p projPlusInt64ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt64ConstInt64Op struct {
	projConstOpBase
	constArg int64
}

func (p projPlusInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) + int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) + int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt64ConstDecimalOp struct {
	projConstOpBase
	constArg int64
}

func (p projPlusInt64ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPlusInt64ConstDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int64
}

func (p projPlusInt64ConstDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusFloat64ConstFloat64Op struct {
	projConstOpBase
	constArg float64
}

func (p projPlusFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Float64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							projCol[i] = float64(p.constArg) + float64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							projCol[i] = float64(p.constArg) + float64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						projCol[i] = float64(p.constArg) + float64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						projCol[i] = float64(p.constArg) + float64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projPlusTimestampConstIntervalOp struct {
	projConstOpBase
	constArg time.Time
}

func (p projPlusTimestampConstIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Timestamp()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						t_res := duration.Add(p.constArg, arg)
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						t_res := duration.Add(p.constArg, arg)
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					t_res := duration.Add(p.constArg, arg)
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					t_res := duration.Add(p.constArg, arg)
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			}
		}
	})
	return batch
}

type projPlusIntervalConstTimestampOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projPlusIntervalConstTimestampOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Times
	col = vec.Timestamp()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Timestamp()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						t_res := duration.Add(arg, p.constArg)
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						t_res := duration.Add(arg, p.constArg)
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					t_res := duration.Add(arg, p.constArg)
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					t_res := duration.Add(arg, p.constArg)
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			}
		}
	})
	return batch
}

type projPlusIntervalConstIntervalOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projPlusIntervalConstIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = p.constArg.Add(arg)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = p.constArg.Add(arg)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = p.constArg.Add(arg)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = p.constArg.Add(arg)
				}
			}
		}
	})
	return batch
}

type projPlusIntervalConstDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg duration.Duration
}

func (p projPlusIntervalConstDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: p.constArg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: p.constArg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: p.constArg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: p.constArg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusDatumConstIntervalOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projPlusDatumConstIntervalOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusDatumConstInt16Op struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projPlusDatumConstInt16Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusDatumConstInt32Op struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projPlusDatumConstInt32Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusDatumConstInt64Op struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projPlusDatumConstInt64Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDecimalConstInt16Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMinusDecimalConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMinusDecimalConstInt32Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMinusDecimalConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMinusDecimalConstInt64Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMinusDecimalConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMinusDecimalConstDecimalOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMinusDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							_, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							_, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						_, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						_, err := tree.ExactCtx.Sub(&projCol[i], &p.constArg, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMinusInt16ConstInt16Op struct {
	projConstOpBase
	constArg int16
}

func (p projMinusInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt16ConstInt32Op struct {
	projConstOpBase
	constArg int16
}

func (p projMinusInt16ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt16ConstInt64Op struct {
	projConstOpBase
	constArg int16
}

func (p projMinusInt16ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt16ConstDecimalOp struct {
	projConstOpBase
	constArg int16
}

func (p projMinusInt16ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMinusInt16ConstDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int16
}

func (p projMinusInt16ConstDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusInt32ConstInt16Op struct {
	projConstOpBase
	constArg int32
}

func (p projMinusInt32ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt32ConstInt32Op struct {
	projConstOpBase
	constArg int32
}

func (p projMinusInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt32ConstInt64Op struct {
	projConstOpBase
	constArg int32
}

func (p projMinusInt32ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt32ConstDecimalOp struct {
	projConstOpBase
	constArg int32
}

func (p projMinusInt32ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMinusInt32ConstDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int32
}

func (p projMinusInt32ConstDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusInt64ConstInt16Op struct {
	projConstOpBase
	constArg int64
}

func (p projMinusInt64ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt64ConstInt32Op struct {
	projConstOpBase
	constArg int64
}

func (p projMinusInt64ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt64ConstInt64Op struct {
	projConstOpBase
	constArg int64
}

func (p projMinusInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							result := int64(p.constArg) - int64(arg)
							if (result < int64(p.constArg)) != (int64(arg) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						result := int64(p.constArg) - int64(arg)
						if (result < int64(p.constArg)) != (int64(arg) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt64ConstDecimalOp struct {
	projConstOpBase
	constArg int64
}

func (p projMinusInt64ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMinusInt64ConstDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg int64
}

func (p projMinusInt64ConstDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(p.constArg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(p.constArg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusFloat64ConstFloat64Op struct {
	projConstOpBase
	constArg float64
}

func (p projMinusFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Float64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							projCol[i] = float64(p.constArg) - float64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							projCol[i] = float64(p.constArg) - float64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						projCol[i] = float64(p.constArg) - float64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						projCol[i] = float64(p.constArg) - float64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projMinusTimestampConstTimestampOp struct {
	projConstOpBase
	constArg time.Time
}

func (p projMinusTimestampConstTimestampOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Times
	col = vec.Timestamp()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						nanos := p.constArg.Sub(arg).Nanoseconds()
						projCol[i] = duration.MakeDurationJustifyHours(nanos, 0, 0)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						nanos := p.constArg.Sub(arg).Nanoseconds()
						projCol[i] = duration.MakeDurationJustifyHours(nanos, 0, 0)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					nanos := p.constArg.Sub(arg).Nanoseconds()
					projCol[i] = duration.MakeDurationJustifyHours(nanos, 0, 0)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					nanos := p.constArg.Sub(arg).Nanoseconds()
					projCol[i] = duration.MakeDurationJustifyHours(nanos, 0, 0)

				}
			}
		}
	})
	return batch
}

type projMinusTimestampConstIntervalOp struct {
	projConstOpBase
	constArg time.Time
}

func (p projMinusTimestampConstIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Timestamp()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						t_res := duration.Add(p.constArg, arg.Mul(-1))
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						t_res := duration.Add(p.constArg, arg.Mul(-1))
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					t_res := duration.Add(p.constArg, arg.Mul(-1))
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					t_res := duration.Add(p.constArg, arg.Mul(-1))
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			}
		}
	})
	return batch
}

type projMinusIntervalConstIntervalOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projMinusIntervalConstIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = p.constArg.Sub(arg)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = p.constArg.Sub(arg)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = p.constArg.Sub(arg)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = p.constArg.Sub(arg)
				}
			}
		}
	})
	return batch
}

type projMinusIntervalConstDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg duration.Duration
}

func (p projMinusIntervalConstDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: p.constArg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: p.constArg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: p.constArg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: p.constArg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusJSONConstBytesOp struct {
	projConstOpBase
	constArg json.JSON
}

func (p projMinusJSONConstBytesOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.Bytes
	col = vec.Bytes()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// RemoveString.
						_j, _, _err := p.constArg.RemoveString(*(*string)(unsafe.Pointer(&arg)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// RemoveString.
						_j, _, _err := p.constArg.RemoveString(*(*string)(unsafe.Pointer(&arg)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// RemoveString.
					_j, _, _err := p.constArg.RemoveString(*(*string)(unsafe.Pointer(&arg)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// RemoveString.
					_j, _, _err := p.constArg.RemoveString(*(*string)(unsafe.Pointer(&arg)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)

				}
			}
		}
	})
	return batch
}

type projMinusJSONConstInt16Op struct {
	projConstOpBase
	constArg json.JSON
}

func (p projMinusJSONConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _, _err := p.constArg.RemoveIndex(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _, _err := p.constArg.RemoveIndex(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _, _err := p.constArg.RemoveIndex(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_j, _, _err := p.constArg.RemoveIndex(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			}
		}
	})
	return batch
}

type projMinusJSONConstInt32Op struct {
	projConstOpBase
	constArg json.JSON
}

func (p projMinusJSONConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _, _err := p.constArg.RemoveIndex(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _, _err := p.constArg.RemoveIndex(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _, _err := p.constArg.RemoveIndex(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_j, _, _err := p.constArg.RemoveIndex(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			}
		}
	})
	return batch
}

type projMinusJSONConstInt64Op struct {
	projConstOpBase
	constArg json.JSON
}

func (p projMinusJSONConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _, _err := p.constArg.RemoveIndex(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _, _err := p.constArg.RemoveIndex(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _, _err := p.constArg.RemoveIndex(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_j, _, _err := p.constArg.RemoveIndex(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			}
		}
	})
	return batch
}

type projMinusDatumConstDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projMinusDatumConstDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*colNulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDatumConstIntervalOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projMinusDatumConstIntervalOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDatumConstBytesOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projMinusDatumConstBytesOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.Bytes
	col = vec.Bytes()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DString(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DString(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DString(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DString(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDatumConstInt16Op struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projMinusDatumConstInt16Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDatumConstInt32Op struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projMinusDatumConstInt32Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDatumConstInt64Op struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projMinusDatumConstInt64Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMultDecimalConstInt16Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMultDecimalConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMultDecimalConstInt32Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMultDecimalConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMultDecimalConstInt64Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMultDecimalConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMultDecimalConstDecimalOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMultDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							_, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							_, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						_, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						_, err := tree.ExactCtx.Mul(&projCol[i], &p.constArg, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMultDecimalConstIntervalOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projMultDecimalConstIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						f, err := p.constArg.Float64()
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						projCol[i] = arg.MulFloat(f)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						f, err := p.constArg.Float64()
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						projCol[i] = arg.MulFloat(f)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					f, err := p.constArg.Float64()
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					projCol[i] = arg.MulFloat(f)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					f, err := p.constArg.Float64()
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					projCol[i] = arg.MulFloat(f)
				}
			}
		}
	})
	return batch
}

type projMultInt16ConstInt16Op struct {
	projConstOpBase
	constArg int16
}

func (p projMultInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt8 || _left < math.MinInt8 || _right > math.MaxInt8 || _right < math.MinInt8 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt8 || _left < math.MinInt8 || _right > math.MaxInt8 || _right < math.MinInt8 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt8 || _left < math.MinInt8 || _right > math.MaxInt8 || _right < math.MinInt8 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt8 || _left < math.MinInt8 || _right > math.MaxInt8 || _right < math.MinInt8 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt16ConstInt32Op struct {
	projConstOpBase
	constArg int16
}

func (p projMultInt16ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt16ConstInt64Op struct {
	projConstOpBase
	constArg int16
}

func (p projMultInt16ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt16ConstDecimalOp struct {
	projConstOpBase
	constArg int16
}

func (p projMultInt16ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMultInt16ConstIntervalOp struct {
	projConstOpBase
	constArg int16
}

func (p projMultInt16ConstIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = arg.Mul(int64(p.constArg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = arg.Mul(int64(p.constArg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = arg.Mul(int64(p.constArg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = arg.Mul(int64(p.constArg))
				}
			}
		}
	})
	return batch
}

type projMultInt32ConstInt16Op struct {
	projConstOpBase
	constArg int32
}

func (p projMultInt32ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt32ConstInt32Op struct {
	projConstOpBase
	constArg int32
}

func (p projMultInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt16 || _left < math.MinInt16 || _right > math.MaxInt16 || _right < math.MinInt16 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt16 || _left < math.MinInt16 || _right > math.MaxInt16 || _right < math.MinInt16 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt16 || _left < math.MinInt16 || _right > math.MaxInt16 || _right < math.MinInt16 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt16 || _left < math.MinInt16 || _right > math.MaxInt16 || _right < math.MinInt16 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt32ConstInt64Op struct {
	projConstOpBase
	constArg int32
}

func (p projMultInt32ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt32ConstDecimalOp struct {
	projConstOpBase
	constArg int32
}

func (p projMultInt32ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMultInt32ConstIntervalOp struct {
	projConstOpBase
	constArg int32
}

func (p projMultInt32ConstIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = arg.Mul(int64(p.constArg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = arg.Mul(int64(p.constArg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = arg.Mul(int64(p.constArg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = arg.Mul(int64(p.constArg))
				}
			}
		}
	})
	return batch
}

type projMultInt64ConstInt16Op struct {
	projConstOpBase
	constArg int64
}

func (p projMultInt64ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt64ConstInt32Op struct {
	projConstOpBase
	constArg int64
}

func (p projMultInt64ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt64ConstInt64Op struct {
	projConstOpBase
	constArg int64
}

func (p projMultInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							_left, _right := int64(p.constArg), int64(arg)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						_left, _right := int64(p.constArg), int64(arg)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt64ConstDecimalOp struct {
	projConstOpBase
	constArg int64
}

func (p projMultInt64ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMultInt64ConstIntervalOp struct {
	projConstOpBase
	constArg int64
}

func (p projMultInt64ConstIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = arg.Mul(int64(p.constArg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = arg.Mul(int64(p.constArg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = arg.Mul(int64(p.constArg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = arg.Mul(int64(p.constArg))
				}
			}
		}
	})
	return batch
}

type projMultFloat64ConstFloat64Op struct {
	projConstOpBase
	constArg float64
}

func (p projMultFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Float64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							projCol[i] = float64(p.constArg) * float64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							projCol[i] = float64(p.constArg) * float64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						projCol[i] = float64(p.constArg) * float64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						projCol[i] = float64(p.constArg) * float64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projMultFloat64ConstIntervalOp struct {
	projConstOpBase
	constArg float64
}

func (p projMultFloat64ConstIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Durations
	col = vec.Interval()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = arg.MulFloat(float64(p.constArg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = arg.MulFloat(float64(p.constArg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = arg.MulFloat(float64(p.constArg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = arg.MulFloat(float64(p.constArg))
				}
			}
		}
	})
	return batch
}

type projMultIntervalConstInt16Op struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projMultIntervalConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = p.constArg.Mul(int64(arg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = p.constArg.Mul(int64(arg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = p.constArg.Mul(int64(arg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = p.constArg.Mul(int64(arg))
				}
			}
		}
	})
	return batch
}

type projMultIntervalConstInt32Op struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projMultIntervalConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = p.constArg.Mul(int64(arg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = p.constArg.Mul(int64(arg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = p.constArg.Mul(int64(arg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = p.constArg.Mul(int64(arg))
				}
			}
		}
	})
	return batch
}

type projMultIntervalConstInt64Op struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projMultIntervalConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = p.constArg.Mul(int64(arg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = p.constArg.Mul(int64(arg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = p.constArg.Mul(int64(arg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = p.constArg.Mul(int64(arg))
				}
			}
		}
	})
	return batch
}

type projMultIntervalConstFloat64Op struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projMultIntervalConstFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						projCol[i] = p.constArg.MulFloat(float64(arg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)
						projCol[i] = p.constArg.MulFloat(float64(arg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)
					projCol[i] = p.constArg.MulFloat(float64(arg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)
					projCol[i] = p.constArg.MulFloat(float64(arg))
				}
			}
		}
	})
	return batch
}

type projMultIntervalConstDecimalOp struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projMultIntervalConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						f, err := arg.Float64()
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						projCol[i] = p.constArg.MulFloat(f)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						f, err := arg.Float64()
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						projCol[i] = p.constArg.MulFloat(f)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					f, err := arg.Float64()
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					projCol[i] = p.constArg.MulFloat(f)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					f, err := arg.Float64()
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					projCol[i] = p.constArg.MulFloat(f)
				}
			}
		}
	})
	return batch
}

type projDivDecimalConstInt16Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projDivDecimalConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivDecimalConstInt32Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projDivDecimalConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivDecimalConstInt64Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projDivDecimalConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivDecimalConstDecimalOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projDivDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg.IsZero() && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite && p.constArg.Form == apd.Finite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg.IsZero() && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite && p.constArg.Form == apd.Finite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg.IsZero() && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite && p.constArg.Form == apd.Finite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg.IsZero() && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite && p.constArg.Form == apd.Finite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projDivInt16ConstInt16Op struct {
	projConstOpBase
	constArg int16
}

func (p projDivInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt16ConstInt32Op struct {
	projConstOpBase
	constArg int16
}

func (p projDivInt16ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt16ConstInt64Op struct {
	projConstOpBase
	constArg int16
}

func (p projDivInt16ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt16ConstDecimalOp struct {
	projConstOpBase
	constArg int16
}

func (p projDivInt16ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projDivInt32ConstInt16Op struct {
	projConstOpBase
	constArg int32
}

func (p projDivInt32ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt32ConstInt32Op struct {
	projConstOpBase
	constArg int32
}

func (p projDivInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt32ConstInt64Op struct {
	projConstOpBase
	constArg int32
}

func (p projDivInt32ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt32ConstDecimalOp struct {
	projConstOpBase
	constArg int32
}

func (p projDivInt32ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projDivInt64ConstInt16Op struct {
	projConstOpBase
	constArg int64
}

func (p projDivInt64ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt64ConstInt32Op struct {
	projConstOpBase
	constArg int64
}

func (p projDivInt64ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt64ConstInt64Op struct {
	projConstOpBase
	constArg int64
}

func (p projDivInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt64ConstDecimalOp struct {
	projConstOpBase
	constArg int64
}

func (p projDivInt64ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projDivFloat64ConstFloat64Op struct {
	projConstOpBase
	constArg float64
}

func (p projDivFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Float64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg == 0.0 && !math.IsNaN(p.constArg) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = float64(p.constArg) / float64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg == 0.0 && !math.IsNaN(p.constArg) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = float64(p.constArg) / float64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg == 0.0 && !math.IsNaN(p.constArg) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = float64(p.constArg) / float64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg == 0.0 && !math.IsNaN(p.constArg) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = float64(p.constArg) / float64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projDivIntervalConstInt16Op struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projDivIntervalConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						if arg == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = p.constArg.Div(int64(arg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						if arg == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = p.constArg.Div(int64(arg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					if arg == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = p.constArg.Div(int64(arg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					if arg == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = p.constArg.Div(int64(arg))
				}
			}
		}
	})
	return batch
}

type projDivIntervalConstInt32Op struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projDivIntervalConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						if arg == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = p.constArg.Div(int64(arg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						if arg == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = p.constArg.Div(int64(arg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					if arg == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = p.constArg.Div(int64(arg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					if arg == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = p.constArg.Div(int64(arg))
				}
			}
		}
	})
	return batch
}

type projDivIntervalConstInt64Op struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projDivIntervalConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						if arg == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = p.constArg.Div(int64(arg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						if arg == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = p.constArg.Div(int64(arg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					if arg == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = p.constArg.Div(int64(arg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					if arg == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = p.constArg.Div(int64(arg))
				}
			}
		}
	})
	return batch
}

type projDivIntervalConstFloat64Op struct {
	projConstOpBase
	constArg duration.Duration
}

func (p projDivIntervalConstFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Interval()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						if arg == 0.0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = p.constArg.DivFloat(float64(arg))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						if arg == 0.0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = p.constArg.DivFloat(float64(arg))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					if arg == 0.0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = p.constArg.DivFloat(float64(arg))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					if arg == 0.0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = p.constArg.DivFloat(float64(arg))
				}
			}
		}
	})
	return batch
}

type projFloorDivDecimalConstInt16Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projFloorDivDecimalConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivDecimalConstInt32Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projFloorDivDecimalConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivDecimalConstInt64Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projFloorDivDecimalConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivDecimalConstDecimalOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projFloorDivDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg.IsZero() && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite && p.constArg.Form == apd.Finite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg.IsZero() && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite && p.constArg.Form == apd.Finite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg.IsZero() && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite && p.constArg.Form == apd.Finite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg.IsZero() && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &p.constArg, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite && p.constArg.Form == apd.Finite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt16ConstInt16Op struct {
	projConstOpBase
	constArg int16
}

func (p projFloorDivInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt16ConstInt32Op struct {
	projConstOpBase
	constArg int16
}

func (p projFloorDivInt16ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt16ConstInt64Op struct {
	projConstOpBase
	constArg int16
}

func (p projFloorDivInt16ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt16ConstDecimalOp struct {
	projConstOpBase
	constArg int16
}

func (p projFloorDivInt16ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt32ConstInt16Op struct {
	projConstOpBase
	constArg int32
}

func (p projFloorDivInt32ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt32ConstInt32Op struct {
	projConstOpBase
	constArg int32
}

func (p projFloorDivInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt32ConstInt64Op struct {
	projConstOpBase
	constArg int32
}

func (p projFloorDivInt32ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt32ConstDecimalOp struct {
	projConstOpBase
	constArg int32
}

func (p projFloorDivInt32ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt64ConstInt16Op struct {
	projConstOpBase
	constArg int64
}

func (p projFloorDivInt64ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt64ConstInt32Op struct {
	projConstOpBase
	constArg int64
}

func (p projFloorDivInt64ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt64ConstInt64Op struct {
	projConstOpBase
	constArg int64
}

func (p projFloorDivInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) / int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) / int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt64ConstDecimalOp struct {
	projConstOpBase
	constArg int64
}

func (p projFloorDivInt64ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projFloorDivFloat64ConstFloat64Op struct {
	projConstOpBase
	constArg float64
}

func (p projFloorDivFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Float64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg == 0.0 && !math.IsNaN(p.constArg) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = math.Trunc(float64(p.constArg) / float64(arg))
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg == 0.0 && !math.IsNaN(p.constArg) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = math.Trunc(float64(p.constArg) / float64(arg))
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg == 0.0 && !math.IsNaN(p.constArg) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = math.Trunc(float64(p.constArg) / float64(arg))
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg == 0.0 && !math.IsNaN(p.constArg) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = math.Trunc(float64(p.constArg) / float64(arg))
					}

				}
			}
		}
	})
	return batch
}

type projModDecimalConstInt16Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projModDecimalConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projModDecimalConstInt32Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projModDecimalConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projModDecimalConstInt64Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projModDecimalConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg == 0 && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg == 0 && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projModDecimalConstDecimalOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projModDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg.IsZero() && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg.IsZero() && p.constArg.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg.IsZero() && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg.IsZero() && p.constArg.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &p.constArg, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projModInt16ConstInt16Op struct {
	projConstOpBase
	constArg int16
}

func (p projModInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt16ConstInt32Op struct {
	projConstOpBase
	constArg int16
}

func (p projModInt16ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt16ConstInt64Op struct {
	projConstOpBase
	constArg int16
}

func (p projModInt16ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt16ConstDecimalOp struct {
	projConstOpBase
	constArg int16
}

func (p projModInt16ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projModInt32ConstInt16Op struct {
	projConstOpBase
	constArg int32
}

func (p projModInt32ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt32ConstInt32Op struct {
	projConstOpBase
	constArg int32
}

func (p projModInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt32ConstInt64Op struct {
	projConstOpBase
	constArg int32
}

func (p projModInt32ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt32ConstDecimalOp struct {
	projConstOpBase
	constArg int32
}

func (p projModInt32ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projModInt64ConstInt16Op struct {
	projConstOpBase
	constArg int64
}

func (p projModInt64ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt64ConstInt32Op struct {
	projConstOpBase
	constArg int64
}

func (p projModInt64ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt64ConstInt64Op struct {
	projConstOpBase
	constArg int64
}

func (p projModInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(p.constArg) % int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(p.constArg) % int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projModInt64ConstDecimalOp struct {
	projConstOpBase
	constArg int64
}

func (p projModInt64ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projModFloat64ConstFloat64Op struct {
	projConstOpBase
	constArg float64
}

func (p projModFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Float64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							if arg == 0.0 && !math.IsNaN(p.constArg) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = math.Mod(float64(p.constArg), float64(arg))
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							if arg == 0.0 && !math.IsNaN(p.constArg) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = math.Mod(float64(p.constArg), float64(arg))
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						if arg == 0.0 && !math.IsNaN(p.constArg) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = math.Mod(float64(p.constArg), float64(arg))
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						if arg == 0.0 && !math.IsNaN(p.constArg) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = math.Mod(float64(p.constArg), float64(arg))
					}

				}
			}
		}
	})
	return batch
}

type projPowDecimalConstInt16Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPowDecimalConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPowDecimalConstInt32Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPowDecimalConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPowDecimalConstInt64Op struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPowDecimalConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPowDecimalConstDecimalOp struct {
	projConstOpBase
	constArg apd.Decimal
}

func (p projPowDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							_, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							_, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						_, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						_, err := tree.DecimalCtx.Pow(&projCol[i], &p.constArg, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPowInt16ConstInt16Op struct {
	projConstOpBase
	constArg int16
}

func (p projPowInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt16ConstInt32Op struct {
	projConstOpBase
	constArg int16
}

func (p projPowInt16ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt16ConstInt64Op struct {
	projConstOpBase
	constArg int16
}

func (p projPowInt16ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt16ConstDecimalOp struct {
	projConstOpBase
	constArg int16
}

func (p projPowInt16ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPowInt32ConstInt16Op struct {
	projConstOpBase
	constArg int32
}

func (p projPowInt32ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt32ConstInt32Op struct {
	projConstOpBase
	constArg int32
}

func (p projPowInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt32ConstInt64Op struct {
	projConstOpBase
	constArg int32
}

func (p projPowInt32ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt32ConstDecimalOp struct {
	projConstOpBase
	constArg int32
}

func (p projPowInt32ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPowInt64ConstInt16Op struct {
	projConstOpBase
	constArg int64
}

func (p projPowInt64ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt64ConstInt32Op struct {
	projConstOpBase
	constArg int64
}

func (p projPowInt64ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt64ConstInt64Op struct {
	projConstOpBase
	constArg int64
}

func (p projPowInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(p.constArg)))
							rightTmpDec.SetInt64(int64(int64(arg)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(p.constArg)))
						rightTmpDec.SetInt64(int64(int64(arg)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt64ConstDecimalOp struct {
	projConstOpBase
	constArg int64
}

func (p projPowInt64ConstDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Decimals
	col = vec.Decimal()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Decimal()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(p.constArg))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(p.constArg))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPowFloat64ConstFloat64Op struct {
	projConstOpBase
	constArg float64
}

func (p projPowFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Float64s
	col = vec.Float64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Float64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{

							projCol[i] = math.Pow(float64(p.constArg), float64(arg))
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{

							projCol[i] = math.Pow(float64(p.constArg), float64(arg))
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{

						projCol[i] = math.Pow(float64(p.constArg), float64(arg))
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{

						projCol[i] = math.Pow(float64(p.constArg), float64(arg))
					}

				}
			}
		}
	})
	return batch
}

type projConcatBytesConstBytesOp struct {
	projConstOpBase
	constArg []byte
}

func (p projConcatBytesConstBytesOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.Bytes
	col = vec.Bytes()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bytes()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var r = []byte{}
							r = append(r, p.constArg...)
							r = append(r, arg...)
							projCol.Set(i, r)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							var r = []byte{}
							r = append(r, p.constArg...)
							r = append(r, arg...)
							projCol.Set(i, r)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						var r = []byte{}
						r = append(r, p.constArg...)
						r = append(r, arg...)
						projCol.Set(i, r)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					{
						var r = []byte{}
						r = append(r, p.constArg...)
						r = append(r, arg...)
						projCol.Set(i, r)
					}

				}
			}
		}
	})
	return batch
}

type projConcatJSONConstJSONOp struct {
	projConstOpBase
	constArg json.JSON
}

func (p projConcatJSONConstJSONOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.JSONs
	col = vec.JSON()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := p.constArg.Concat(arg)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := p.constArg.Concat(arg)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

						projCol.Set(i, _j)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _err := p.constArg.Concat(arg)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}

					projCol.Set(i, _j)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_j, _err := p.constArg.Concat(arg)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}

					projCol.Set(i, _j)
				}
			}
		}
	})
	return batch
}

type projConcatDatumConstDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projConcatDatumConstDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)
						if colNulls.NullAt(i) {
							arg = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*colNulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), arg.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projLShiftInt16ConstInt16Op struct {
	projConstOpBase
	constArg int16
}

func (p projLShiftInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt16ConstInt32Op struct {
	projConstOpBase
	constArg int16
}

func (p projLShiftInt16ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt16ConstInt64Op struct {
	projConstOpBase
	constArg int16
}

func (p projLShiftInt16ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt32ConstInt16Op struct {
	projConstOpBase
	constArg int32
}

func (p projLShiftInt32ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt32ConstInt32Op struct {
	projConstOpBase
	constArg int32
}

func (p projLShiftInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt32ConstInt64Op struct {
	projConstOpBase
	constArg int32
}

func (p projLShiftInt32ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt64ConstInt16Op struct {
	projConstOpBase
	constArg int64
}

func (p projLShiftInt64ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt64ConstInt32Op struct {
	projConstOpBase
	constArg int64
}

func (p projLShiftInt64ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt64ConstInt64Op struct {
	projConstOpBase
	constArg int64
}

func (p projLShiftInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) << int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) << int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftDatumConstInt16Op struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projLShiftDatumConstInt16Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projLShiftDatumConstInt32Op struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projLShiftDatumConstInt32Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projLShiftDatumConstInt64Op struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projLShiftDatumConstInt64Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projRShiftInt16ConstInt16Op struct {
	projConstOpBase
	constArg int16
}

func (p projRShiftInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt16ConstInt32Op struct {
	projConstOpBase
	constArg int16
}

func (p projRShiftInt16ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt16ConstInt64Op struct {
	projConstOpBase
	constArg int16
}

func (p projRShiftInt16ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt32ConstInt16Op struct {
	projConstOpBase
	constArg int32
}

func (p projRShiftInt32ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt32ConstInt32Op struct {
	projConstOpBase
	constArg int32
}

func (p projRShiftInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt32ConstInt64Op struct {
	projConstOpBase
	constArg int32
}

func (p projRShiftInt32ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt64ConstInt16Op struct {
	projConstOpBase
	constArg int64
}

func (p projRShiftInt64ConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt64ConstInt32Op struct {
	projConstOpBase
	constArg int64
}

func (p projRShiftInt64ConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt64ConstInt64Op struct {
	projConstOpBase
	constArg int64
}

func (p projRShiftInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Int64()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						//gcassert:bce
						arg := col.Get(i)

						{
							if int64(arg) < 0 || int64(arg) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(p.constArg) >> int64(arg)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg := col.Get(i)

					{
						if int64(arg) < 0 || int64(arg) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(p.constArg) >> int64(arg)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftDatumConstInt16Op struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projRShiftDatumConstInt16Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projRShiftDatumConstInt32Op struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projRShiftDatumConstInt32Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projRShiftDatumConstInt64Op struct {
	colexecutils.BinaryOverloadHelper
	projConstOpBase
	constArg interface{}
}

func (p projRShiftDatumConstInt64Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Datum()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_convertedNativeElem := tree.DInt(arg)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_convertedNativeElem := tree.DInt(arg)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, p.constArg.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projJSONFetchValJSONConstBytesOp struct {
	projConstOpBase
	constArg json.JSON
}

func (p projJSONFetchValJSONConstBytesOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.Bytes
	col = vec.Bytes()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// FetchValKey.
						_j, _err := p.constArg.FetchValKey(*(*string)(unsafe.Pointer(&arg)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// FetchValKey.
						_j, _err := p.constArg.FetchValKey(*(*string)(unsafe.Pointer(&arg)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// FetchValKey.
					_j, _err := p.constArg.FetchValKey(*(*string)(unsafe.Pointer(&arg)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// FetchValKey.
					_j, _err := p.constArg.FetchValKey(*(*string)(unsafe.Pointer(&arg)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchValJSONConstInt16Op struct {
	projConstOpBase
	constArg json.JSON
}

func (p projJSONFetchValJSONConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := p.constArg.FetchValIdx(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := p.constArg.FetchValIdx(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _err := p.constArg.FetchValIdx(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_j, _err := p.constArg.FetchValIdx(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchValJSONConstInt32Op struct {
	projConstOpBase
	constArg json.JSON
}

func (p projJSONFetchValJSONConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := p.constArg.FetchValIdx(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := p.constArg.FetchValIdx(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _err := p.constArg.FetchValIdx(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_j, _err := p.constArg.FetchValIdx(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchValJSONConstInt64Op struct {
	projConstOpBase
	constArg json.JSON
}

func (p projJSONFetchValJSONConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := p.constArg.FetchValIdx(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := p.constArg.FetchValIdx(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _err := p.constArg.FetchValIdx(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_j, _err := p.constArg.FetchValIdx(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchTextJSONConstBytesOp struct {
	projConstOpBase
	constArg json.JSON
}

func (p projJSONFetchTextJSONConstBytesOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col *coldata.Bytes
	col = vec.Bytes()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bytes()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// FetchValKey.
						_j, _err := p.constArg.FetchValKey(*(*string)(unsafe.Pointer(&arg)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// FetchValKey.
						_j, _err := p.constArg.FetchValKey(*(*string)(unsafe.Pointer(&arg)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// FetchValKey.
					_j, _err := p.constArg.FetchValKey(*(*string)(unsafe.Pointer(&arg)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// FetchValKey.
					_j, _err := p.constArg.FetchValKey(*(*string)(unsafe.Pointer(&arg)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchTextJSONConstInt16Op struct {
	projConstOpBase
	constArg json.JSON
}

func (p projJSONFetchTextJSONConstInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int16s
	col = vec.Int16()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bytes()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := p.constArg.FetchValIdx(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := p.constArg.FetchValIdx(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _err := p.constArg.FetchValIdx(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_j, _err := p.constArg.FetchValIdx(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchTextJSONConstInt32Op struct {
	projConstOpBase
	constArg json.JSON
}

func (p projJSONFetchTextJSONConstInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int32s
	col = vec.Int32()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bytes()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := p.constArg.FetchValIdx(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := p.constArg.FetchValIdx(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _err := p.constArg.FetchValIdx(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_j, _err := p.constArg.FetchValIdx(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchTextJSONConstInt64Op struct {
	projConstOpBase
	constArg json.JSON
}

func (p projJSONFetchTextJSONConstInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.Int64s
	col = vec.Int64()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bytes()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := p.constArg.FetchValIdx(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_j, _err := p.constArg.FetchValIdx(int(arg))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_j, _err := p.constArg.FetchValIdx(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_j, _err := p.constArg.FetchValIdx(int(arg))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchValPathJSONConstDatumOp struct {
	projConstOpBase
	constArg json.JSON
}

func (p projJSONFetchValPathJSONConstDatumOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.JSON()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_path, _err := tree.GetJSONPath(p.constArg, *tree.MustBeDArray(arg.(tree.Datum)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _path == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _path)
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_path, _err := tree.GetJSONPath(p.constArg, *tree.MustBeDArray(arg.(tree.Datum)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _path == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _path)
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_path, _err := tree.GetJSONPath(p.constArg, *tree.MustBeDArray(arg.(tree.Datum)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _path == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _path)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_path, _err := tree.GetJSONPath(p.constArg, *tree.MustBeDArray(arg.(tree.Datum)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _path == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _path)
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchTextPathJSONConstDatumOp struct {
	projConstOpBase
	constArg json.JSON
}

func (p projJSONFetchTextPathJSONConstDatumOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(p.colIdx)
	var col coldata.DatumVec
	col = vec.Datum()
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		// Capture col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		col := col
		projCol := projVec.Bytes()
		_outNulls := projVec.Nulls()
		if vec.Nulls().MaybeHasNulls() {
			colNulls := vec.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_path, _err := tree.GetJSONPath(p.constArg, *tree.MustBeDArray(arg.(tree.Datum)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _path == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _path.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}

						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || !colNulls.NullAt(i) {
						// We only want to perform the projection operation if the value is not null.
						arg := col.Get(i)

						_path, _err := tree.GetJSONPath(p.constArg, *tree.MustBeDArray(arg.(tree.Datum)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _path == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _path.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}

						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*colNulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg := col.Get(i)

					_path, _err := tree.GetJSONPath(p.constArg, *tree.MustBeDArray(arg.(tree.Datum)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _path == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _path.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col.Get(n - 1)
				for i := 0; i < n; i++ {
					arg := col.Get(i)

					_path, _err := tree.GetJSONPath(p.constArg, *tree.MustBeDArray(arg.(tree.Datum)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _path == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _path.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}

					}
				}
			}
		}
	})
	return batch
}

// GetProjectionLConstOperator returns the appropriate constant
// projection operator for the given left and right column types and operation.
func GetProjectionLConstOperator(
	allocator *colmem.Allocator,
	inputTypes []*types.T,
	constType *types.T,
	outputType *types.T,
	op tree.Operator,
	input colexecop.Operator,
	colIdx int,
	constArg tree.Datum,
	outputIdx int,
	evalCtx *eval.Context,
	binOp tree.BinaryEvalOp,
	cmpExpr *tree.ComparisonExpr,
	calledOnNullInput bool,
) (colexecop.Operator, error) {
	input = colexecutils.NewVectorTypeEnforcer(allocator, input, outputType, outputIdx)
	projConstOpBase := projConstOpBase{
		OneInputHelper:    colexecop.MakeOneInputHelper(input),
		allocator:         allocator,
		colIdx:            colIdx,
		outputIdx:         outputIdx,
		calledOnNullInput: calledOnNullInput,
	}
	c := colconv.GetDatumToPhysicalFn(constType)(constArg)
	leftType, rightType := constType, inputTypes[colIdx]
	switch op := op.(type) {
	case treebin.BinaryOperator:
		switch op.Symbol {
		case treebin.Bitand:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.IntFamily:
				switch leftType.Width() {
				case 16:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projBitandInt16ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case 32:
							op := &projBitandInt16ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case -1:
						default:
							op := &projBitandInt16ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					}
				case 32:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projBitandInt32ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case 32:
							op := &projBitandInt32ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case -1:
						default:
							op := &projBitandInt32ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					}
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projBitandInt64ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case 32:
							op := &projBitandInt64ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case -1:
						default:
							op := &projBitandInt64ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					}
				}
			case typeconv.DatumVecCanonicalTypeFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case typeconv.DatumVecCanonicalTypeFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projBitandDatumConstDatumOp{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				}
			}
		case treebin.Bitor:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.IntFamily:
				switch leftType.Width() {
				case 16:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projBitorInt16ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case 32:
							op := &projBitorInt16ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case -1:
						default:
							op := &projBitorInt16ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					}
				case 32:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projBitorInt32ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case 32:
							op := &projBitorInt32ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case -1:
						default:
							op := &projBitorInt32ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					}
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projBitorInt64ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case 32:
							op := &projBitorInt64ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case -1:
						default:
							op := &projBitorInt64ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					}
				}
			case typeconv.DatumVecCanonicalTypeFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case typeconv.DatumVecCanonicalTypeFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projBitorDatumConstDatumOp{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				}
			}
		case treebin.Bitxor:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.IntFamily:
				switch leftType.Width() {
				case 16:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projBitxorInt16ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case 32:
							op := &projBitxorInt16ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case -1:
						default:
							op := &projBitxorInt16ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					}
				case 32:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projBitxorInt32ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case 32:
							op := &projBitxorInt32ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case -1:
						default:
							op := &projBitxorInt32ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					}
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projBitxorInt64ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case 32:
							op := &projBitxorInt64ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case -1:
						default:
							op := &projBitxorInt64ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					}
				}
			case typeconv.DatumVecCanonicalTypeFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case typeconv.DatumVecCanonicalTypeFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projBitxorDatumConstDatumOp{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				}
			}
		case treebin.Plus:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.DecimalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projPlusDecimalConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						case 32:
							op := &projPlusDecimalConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						case -1:
						default:
							op := &projPlusDecimalConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPlusDecimalConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						}
					}
				}
			case types.IntFamily:
				switch leftType.Width() {
				case 16:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projPlusInt16ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case 32:
							op := &projPlusInt16ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case -1:
						default:
							op := &projPlusInt16ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPlusInt16ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					case typeconv.DatumVecCanonicalTypeFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPlusInt16ConstDatumOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				case 32:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projPlusInt32ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case 32:
							op := &projPlusInt32ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case -1:
						default:
							op := &projPlusInt32ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPlusInt32ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					case typeconv.DatumVecCanonicalTypeFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPlusInt32ConstDatumOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projPlusInt64ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case 32:
							op := &projPlusInt64ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case -1:
						default:
							op := &projPlusInt64ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPlusInt64ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					case typeconv.DatumVecCanonicalTypeFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPlusInt64ConstDatumOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				}
			case types.FloatFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.FloatFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPlusFloat64ConstFloat64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(float64),
							}
							return op, nil
						}
					}
				}
			case types.TimestampTZFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntervalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPlusTimestampConstIntervalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(time.Time),
							}
							return op, nil
						}
					}
				}
			case types.IntervalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.TimestampTZFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPlusIntervalConstTimestampOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(duration.Duration),
							}
							return op, nil
						}
					case types.IntervalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPlusIntervalConstIntervalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(duration.Duration),
							}
							return op, nil
						}
					case typeconv.DatumVecCanonicalTypeFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPlusIntervalConstDatumOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(duration.Duration),
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				}
			case typeconv.DatumVecCanonicalTypeFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntervalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPlusDatumConstIntervalOp{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projPlusDatumConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						case 32:
							op := &projPlusDatumConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						case -1:
						default:
							op := &projPlusDatumConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				}
			}
		case treebin.Minus:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.DecimalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projMinusDecimalConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						case 32:
							op := &projMinusDecimalConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						case -1:
						default:
							op := &projMinusDecimalConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusDecimalConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						}
					}
				}
			case types.IntFamily:
				switch leftType.Width() {
				case 16:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projMinusInt16ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case 32:
							op := &projMinusInt16ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case -1:
						default:
							op := &projMinusInt16ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusInt16ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					case typeconv.DatumVecCanonicalTypeFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusInt16ConstDatumOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				case 32:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projMinusInt32ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case 32:
							op := &projMinusInt32ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case -1:
						default:
							op := &projMinusInt32ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusInt32ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					case typeconv.DatumVecCanonicalTypeFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusInt32ConstDatumOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projMinusInt64ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case 32:
							op := &projMinusInt64ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case -1:
						default:
							op := &projMinusInt64ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusInt64ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					case typeconv.DatumVecCanonicalTypeFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusInt64ConstDatumOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				}
			case types.FloatFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.FloatFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusFloat64ConstFloat64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(float64),
							}
							return op, nil
						}
					}
				}
			case types.TimestampTZFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.TimestampTZFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusTimestampConstTimestampOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(time.Time),
							}
							return op, nil
						}
					case types.IntervalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusTimestampConstIntervalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(time.Time),
							}
							return op, nil
						}
					}
				}
			case types.IntervalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntervalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusIntervalConstIntervalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(duration.Duration),
							}
							return op, nil
						}
					case typeconv.DatumVecCanonicalTypeFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusIntervalConstDatumOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(duration.Duration),
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				}
			case types.JsonFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.BytesFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusJSONConstBytesOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(json.JSON),
							}
							return op, nil
						}
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projMinusJSONConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(json.JSON),
							}
							return op, nil
						case 32:
							op := &projMinusJSONConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(json.JSON),
							}
							return op, nil
						case -1:
						default:
							op := &projMinusJSONConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(json.JSON),
							}
							return op, nil
						}
					}
				}
			case typeconv.DatumVecCanonicalTypeFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case typeconv.DatumVecCanonicalTypeFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusDatumConstDatumOp{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					case types.IntervalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusDatumConstIntervalOp{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					case types.BytesFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMinusDatumConstBytesOp{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projMinusDatumConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						case 32:
							op := &projMinusDatumConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						case -1:
						default:
							op := &projMinusDatumConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				}
			}
		case treebin.Mult:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.DecimalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projMultDecimalConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						case 32:
							op := &projMultDecimalConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						case -1:
						default:
							op := &projMultDecimalConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMultDecimalConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						}
					case types.IntervalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMultDecimalConstIntervalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						}
					}
				}
			case types.IntFamily:
				switch leftType.Width() {
				case 16:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projMultInt16ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case 32:
							op := &projMultInt16ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case -1:
						default:
							op := &projMultInt16ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMultInt16ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					case types.IntervalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMultInt16ConstIntervalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					}
				case 32:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projMultInt32ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case 32:
							op := &projMultInt32ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case -1:
						default:
							op := &projMultInt32ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMultInt32ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					case types.IntervalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMultInt32ConstIntervalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					}
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projMultInt64ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case 32:
							op := &projMultInt64ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case -1:
						default:
							op := &projMultInt64ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMultInt64ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					case types.IntervalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMultInt64ConstIntervalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					}
				}
			case types.FloatFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.FloatFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMultFloat64ConstFloat64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(float64),
							}
							return op, nil
						}
					case types.IntervalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMultFloat64ConstIntervalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(float64),
							}
							return op, nil
						}
					}
				}
			case types.IntervalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projMultIntervalConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(duration.Duration),
							}
							return op, nil
						case 32:
							op := &projMultIntervalConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(duration.Duration),
							}
							return op, nil
						case -1:
						default:
							op := &projMultIntervalConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(duration.Duration),
							}
							return op, nil
						}
					case types.FloatFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMultIntervalConstFloat64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(duration.Duration),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projMultIntervalConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(duration.Duration),
							}
							return op, nil
						}
					}
				}
			}
		case treebin.Div:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.DecimalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projDivDecimalConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						case 32:
							op := &projDivDecimalConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						case -1:
						default:
							op := &projDivDecimalConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projDivDecimalConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						}
					}
				}
			case types.IntFamily:
				switch leftType.Width() {
				case 16:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projDivInt16ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case 32:
							op := &projDivInt16ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case -1:
						default:
							op := &projDivInt16ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projDivInt16ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					}
				case 32:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projDivInt32ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case 32:
							op := &projDivInt32ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case -1:
						default:
							op := &projDivInt32ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projDivInt32ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					}
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projDivInt64ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case 32:
							op := &projDivInt64ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case -1:
						default:
							op := &projDivInt64ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projDivInt64ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					}
				}
			case types.FloatFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.FloatFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projDivFloat64ConstFloat64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(float64),
							}
							return op, nil
						}
					}
				}
			case types.IntervalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projDivIntervalConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(duration.Duration),
							}
							return op, nil
						case 32:
							op := &projDivIntervalConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(duration.Duration),
							}
							return op, nil
						case -1:
						default:
							op := &projDivIntervalConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(duration.Duration),
							}
							return op, nil
						}
					case types.FloatFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projDivIntervalConstFloat64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(duration.Duration),
							}
							return op, nil
						}
					}
				}
			}
		case treebin.FloorDiv:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.DecimalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projFloorDivDecimalConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						case 32:
							op := &projFloorDivDecimalConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						case -1:
						default:
							op := &projFloorDivDecimalConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projFloorDivDecimalConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						}
					}
				}
			case types.IntFamily:
				switch leftType.Width() {
				case 16:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projFloorDivInt16ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case 32:
							op := &projFloorDivInt16ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case -1:
						default:
							op := &projFloorDivInt16ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projFloorDivInt16ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					}
				case 32:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projFloorDivInt32ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case 32:
							op := &projFloorDivInt32ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case -1:
						default:
							op := &projFloorDivInt32ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projFloorDivInt32ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					}
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projFloorDivInt64ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case 32:
							op := &projFloorDivInt64ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case -1:
						default:
							op := &projFloorDivInt64ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projFloorDivInt64ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					}
				}
			case types.FloatFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.FloatFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projFloorDivFloat64ConstFloat64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(float64),
							}
							return op, nil
						}
					}
				}
			}
		case treebin.Mod:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.DecimalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projModDecimalConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						case 32:
							op := &projModDecimalConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						case -1:
						default:
							op := &projModDecimalConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projModDecimalConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						}
					}
				}
			case types.IntFamily:
				switch leftType.Width() {
				case 16:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projModInt16ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case 32:
							op := &projModInt16ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case -1:
						default:
							op := &projModInt16ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projModInt16ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					}
				case 32:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projModInt32ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case 32:
							op := &projModInt32ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case -1:
						default:
							op := &projModInt32ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projModInt32ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					}
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projModInt64ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case 32:
							op := &projModInt64ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case -1:
						default:
							op := &projModInt64ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projModInt64ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					}
				}
			case types.FloatFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.FloatFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projModFloat64ConstFloat64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(float64),
							}
							return op, nil
						}
					}
				}
			}
		case treebin.Pow:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.DecimalFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projPowDecimalConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						case 32:
							op := &projPowDecimalConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						case -1:
						default:
							op := &projPowDecimalConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPowDecimalConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(apd.Decimal),
							}
							return op, nil
						}
					}
				}
			case types.IntFamily:
				switch leftType.Width() {
				case 16:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projPowInt16ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case 32:
							op := &projPowInt16ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case -1:
						default:
							op := &projPowInt16ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPowInt16ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					}
				case 32:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projPowInt32ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case 32:
							op := &projPowInt32ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case -1:
						default:
							op := &projPowInt32ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPowInt32ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					}
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projPowInt64ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case 32:
							op := &projPowInt64ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case -1:
						default:
							op := &projPowInt64ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					case types.DecimalFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPowInt64ConstDecimalOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					}
				}
			case types.FloatFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.FloatFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projPowFloat64ConstFloat64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(float64),
							}
							return op, nil
						}
					}
				}
			}
		case treebin.Concat:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.BytesFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.BytesFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projConcatBytesConstBytesOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.([]byte),
							}
							return op, nil
						}
					}
				}
			case types.JsonFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.JsonFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projConcatJSONConstJSONOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(json.JSON),
							}
							return op, nil
						}
					}
				}
			case typeconv.DatumVecCanonicalTypeFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case typeconv.DatumVecCanonicalTypeFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projConcatDatumConstDatumOp{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				}
			}
		case treebin.LShift:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.IntFamily:
				switch leftType.Width() {
				case 16:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projLShiftInt16ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case 32:
							op := &projLShiftInt16ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case -1:
						default:
							op := &projLShiftInt16ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					}
				case 32:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projLShiftInt32ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case 32:
							op := &projLShiftInt32ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case -1:
						default:
							op := &projLShiftInt32ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					}
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projLShiftInt64ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case 32:
							op := &projLShiftInt64ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case -1:
						default:
							op := &projLShiftInt64ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					}
				}
			case typeconv.DatumVecCanonicalTypeFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projLShiftDatumConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						case 32:
							op := &projLShiftDatumConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						case -1:
						default:
							op := &projLShiftDatumConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				}
			}
		case treebin.RShift:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.IntFamily:
				switch leftType.Width() {
				case 16:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projRShiftInt16ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case 32:
							op := &projRShiftInt16ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						case -1:
						default:
							op := &projRShiftInt16ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int16),
							}
							return op, nil
						}
					}
				case 32:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projRShiftInt32ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case 32:
							op := &projRShiftInt32ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						case -1:
						default:
							op := &projRShiftInt32ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int32),
							}
							return op, nil
						}
					}
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projRShiftInt64ConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case 32:
							op := &projRShiftInt64ConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						case -1:
						default:
							op := &projRShiftInt64ConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(int64),
							}
							return op, nil
						}
					}
				}
			case typeconv.DatumVecCanonicalTypeFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projRShiftDatumConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						case 32:
							op := &projRShiftDatumConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						case -1:
						default:
							op := &projRShiftDatumConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        constArg,
							}
							op.BinaryOverloadHelper = colexecutils.BinaryOverloadHelper{BinOp: binOp, EvalCtx: evalCtx}
							return op, nil
						}
					}
				}
			}
		case treebin.JSONFetchVal:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.JsonFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.BytesFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projJSONFetchValJSONConstBytesOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(json.JSON),
							}
							return op, nil
						}
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projJSONFetchValJSONConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(json.JSON),
							}
							return op, nil
						case 32:
							op := &projJSONFetchValJSONConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(json.JSON),
							}
							return op, nil
						case -1:
						default:
							op := &projJSONFetchValJSONConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(json.JSON),
							}
							return op, nil
						}
					}
				}
			}
		case treebin.JSONFetchText:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.JsonFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case types.BytesFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projJSONFetchTextJSONConstBytesOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(json.JSON),
							}
							return op, nil
						}
					case types.IntFamily:
						switch rightType.Width() {
						case 16:
							op := &projJSONFetchTextJSONConstInt16Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(json.JSON),
							}
							return op, nil
						case 32:
							op := &projJSONFetchTextJSONConstInt32Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(json.JSON),
							}
							return op, nil
						case -1:
						default:
							op := &projJSONFetchTextJSONConstInt64Op{
								projConstOpBase: projConstOpBase,
								constArg:        c.(json.JSON),
							}
							return op, nil
						}
					}
				}
			}
		case treebin.JSONFetchValPath:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.JsonFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case typeconv.DatumVecCanonicalTypeFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projJSONFetchValPathJSONConstDatumOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(json.JSON),
							}
							return op, nil
						}
					}
				}
			}
		case treebin.JSONFetchTextPath:
			switch typeconv.TypeFamilyToCanonicalTypeFamily(leftType.Family()) {
			case types.JsonFamily:
				switch leftType.Width() {
				case -1:
				default:
					switch typeconv.TypeFamilyToCanonicalTypeFamily(rightType.Family()) {
					case typeconv.DatumVecCanonicalTypeFamily:
						switch rightType.Width() {
						case -1:
						default:
							op := &projJSONFetchTextPathJSONConstDatumOp{
								projConstOpBase: projConstOpBase,
								constArg:        c.(json.JSON),
							}
							return op, nil
						}
					}
				}
			}
		}
	}
	return nil, errors.Errorf("couldn't find overload for %s %s %s", leftType.Name(), op, rightType.Name())
}
