// Code generated by execgen; DO NOT EDIT.
// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecproj

import (
	"bytes"
	"math"
	"time"
	"unsafe"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/server/telemetry"
	"github.com/cockroachdb/cockroach/pkg/sql/colconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexeccmp"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexecutils"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecop"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/eval"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree/treebin"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree/treecmp"
	"github.com/cockroachdb/cockroach/pkg/sql/sqltelemetry"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/cockroach/pkg/util/encoding"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ duration.Duration
	_ = coldataext.CompareDatum
	_ sqltelemetry.EnumTelemetryType
	_ telemetry.Counter
	_ apd.Context
)

// projOpBase contains all of the fields for non-constant projections.
type projOpBase struct {
	colexecop.OneInputHelper
	allocator         *colmem.Allocator
	col1Idx           int
	col2Idx           int
	outputIdx         int
	calledOnNullInput bool
}

type projBitandInt16Int16Op struct {
	projOpBase
}

func (p projBitandInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitandInt16Int32Op struct {
	projOpBase
}

func (p projBitandInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitandInt16Int64Op struct {
	projOpBase
}

func (p projBitandInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitandInt32Int16Op struct {
	projOpBase
}

func (p projBitandInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitandInt32Int32Op struct {
	projOpBase
}

func (p projBitandInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitandInt32Int64Op struct {
	projOpBase
}

func (p projBitandInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitandInt64Int16Op struct {
	projOpBase
}

func (p projBitandInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitandInt64Int32Op struct {
	projOpBase
}

func (p projBitandInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitandInt64Int64Op struct {
	projOpBase
}

func (p projBitandInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) & int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) & int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitandDatumDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projBitandDatumDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projBitorInt16Int16Op struct {
	projOpBase
}

func (p projBitorInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitorInt16Int32Op struct {
	projOpBase
}

func (p projBitorInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitorInt16Int64Op struct {
	projOpBase
}

func (p projBitorInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitorInt32Int16Op struct {
	projOpBase
}

func (p projBitorInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitorInt32Int32Op struct {
	projOpBase
}

func (p projBitorInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitorInt32Int64Op struct {
	projOpBase
}

func (p projBitorInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitorInt64Int16Op struct {
	projOpBase
}

func (p projBitorInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitorInt64Int32Op struct {
	projOpBase
}

func (p projBitorInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitorInt64Int64Op struct {
	projOpBase
}

func (p projBitorInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) | int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) | int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitorDatumDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projBitorDatumDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projBitxorInt16Int16Op struct {
	projOpBase
}

func (p projBitxorInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitxorInt16Int32Op struct {
	projOpBase
}

func (p projBitxorInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitxorInt16Int64Op struct {
	projOpBase
}

func (p projBitxorInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitxorInt32Int16Op struct {
	projOpBase
}

func (p projBitxorInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitxorInt32Int32Op struct {
	projOpBase
}

func (p projBitxorInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitxorInt32Int64Op struct {
	projOpBase
}

func (p projBitxorInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitxorInt64Int16Op struct {
	projOpBase
}

func (p projBitxorInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitxorInt64Int32Op struct {
	projOpBase
}

func (p projBitxorInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitxorInt64Int64Op struct {
	projOpBase
}

func (p projBitxorInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						projCol[i] = int64(arg1) ^ int64(arg2)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					projCol[i] = int64(arg1) ^ int64(arg2)

				}
			}
		}
	})
	return batch
}

type projBitxorDatumDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projBitxorDatumDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusDecimalInt16Op struct {
	projOpBase
}

func (p projPlusDecimalInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Add(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Add(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Add(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Add(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPlusDecimalInt32Op struct {
	projOpBase
}

func (p projPlusDecimalInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Add(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Add(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Add(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Add(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPlusDecimalInt64Op struct {
	projOpBase
}

func (p projPlusDecimalInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Add(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Add(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Add(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Add(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPlusDecimalDecimalOp struct {
	projOpBase
}

func (p projPlusDecimalDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							_, err := tree.ExactCtx.Add(&projCol[i], &arg1, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							_, err := tree.ExactCtx.Add(&projCol[i], &arg1, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						_, err := tree.ExactCtx.Add(&projCol[i], &arg1, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						_, err := tree.ExactCtx.Add(&projCol[i], &arg1, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPlusInt16Int16Op struct {
	projOpBase
}

func (p projPlusInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt16Int32Op struct {
	projOpBase
}

func (p projPlusInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt16Int64Op struct {
	projOpBase
}

func (p projPlusInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt16DecimalOp struct {
	projOpBase
}

func (p projPlusInt16DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPlusInt16DatumOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projPlusInt16DatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg1)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg1)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg1)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg1)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusInt32Int16Op struct {
	projOpBase
}

func (p projPlusInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt32Int32Op struct {
	projOpBase
}

func (p projPlusInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt32Int64Op struct {
	projOpBase
}

func (p projPlusInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt32DecimalOp struct {
	projOpBase
}

func (p projPlusInt32DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPlusInt32DatumOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projPlusInt32DatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg1)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg1)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg1)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg1)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusInt64Int16Op struct {
	projOpBase
}

func (p projPlusInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt64Int32Op struct {
	projOpBase
}

func (p projPlusInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt64Int64Op struct {
	projOpBase
}

func (p projPlusInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) + int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) + int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) < 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projPlusInt64DecimalOp struct {
	projOpBase
}

func (p projPlusInt64DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Add(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPlusInt64DatumOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projPlusInt64DatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg1)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg1)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg1)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg1)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusFloat64Float64Op struct {
	projOpBase
}

func (p projPlusFloat64Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Float64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							projCol[i] = float64(arg1) + float64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							projCol[i] = float64(arg1) + float64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						projCol[i] = float64(arg1) + float64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						projCol[i] = float64(arg1) + float64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projPlusTimestampIntervalOp struct {
	projOpBase
}

func (p projPlusTimestampIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Timestamp()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Timestamp()
		col2 := vec2.Interval()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)
						t_res := duration.Add(arg1, arg2)
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)
						t_res := duration.Add(arg1, arg2)
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)
					t_res := duration.Add(arg1, arg2)
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)
					t_res := duration.Add(arg1, arg2)
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			}
		}
	})
	return batch
}

type projPlusIntervalTimestampOp struct {
	projOpBase
}

func (p projPlusIntervalTimestampOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Timestamp()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Timestamp()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)
						t_res := duration.Add(arg2, arg1)
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)
						t_res := duration.Add(arg2, arg1)
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)
					t_res := duration.Add(arg2, arg1)
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)
					t_res := duration.Add(arg2, arg1)
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			}
		}
	})
	return batch
}

type projPlusIntervalIntervalOp struct {
	projOpBase
}

func (p projPlusIntervalIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Interval()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)
						projCol[i] = arg1.Add(arg2)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)
						projCol[i] = arg1.Add(arg2)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)
					projCol[i] = arg1.Add(arg2)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)
					projCol[i] = arg1.Add(arg2)
				}
			}
		}
	})
	return batch
}

type projPlusIntervalDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projPlusIntervalDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg1}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg1}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg1}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg1}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusDatumIntervalOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projPlusDatumIntervalOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Interval()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg2}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg2}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg2}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg2}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusDatumInt16Op struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projPlusDatumInt16Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusDatumInt32Op struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projPlusDatumInt32Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projPlusDatumInt64Op struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projPlusDatumInt64Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDecimalInt16Op struct {
	projOpBase
}

func (p projMinusDecimalInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMinusDecimalInt32Op struct {
	projOpBase
}

func (p projMinusDecimalInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMinusDecimalInt64Op struct {
	projOpBase
}

func (p projMinusDecimalInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMinusDecimalDecimalOp struct {
	projOpBase
}

func (p projMinusDecimalDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							_, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							_, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						_, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						_, err := tree.ExactCtx.Sub(&projCol[i], &arg1, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMinusInt16Int16Op struct {
	projOpBase
}

func (p projMinusInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt16Int32Op struct {
	projOpBase
}

func (p projMinusInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt16Int64Op struct {
	projOpBase
}

func (p projMinusInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt16DecimalOp struct {
	projOpBase
}

func (p projMinusInt16DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMinusInt16DatumOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projMinusInt16DatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg1)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg1)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg1)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg1)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusInt32Int16Op struct {
	projOpBase
}

func (p projMinusInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt32Int32Op struct {
	projOpBase
}

func (p projMinusInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt32Int64Op struct {
	projOpBase
}

func (p projMinusInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt32DecimalOp struct {
	projOpBase
}

func (p projMinusInt32DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMinusInt32DatumOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projMinusInt32DatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg1)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg1)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg1)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg1)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusInt64Int16Op struct {
	projOpBase
}

func (p projMinusInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt64Int32Op struct {
	projOpBase
}

func (p projMinusInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt64Int64Op struct {
	projOpBase
}

func (p projMinusInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							result := int64(arg1) - int64(arg2)
							if (result < int64(arg1)) != (int64(arg2) > 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						result := int64(arg1) - int64(arg2)
						if (result < int64(arg1)) != (int64(arg2) > 0) {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMinusInt64DecimalOp struct {
	projOpBase
}

func (p projMinusInt64DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Sub(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMinusInt64DatumOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projMinusInt64DatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg1)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg1)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg1)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg1)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusFloat64Float64Op struct {
	projOpBase
}

func (p projMinusFloat64Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Float64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							projCol[i] = float64(arg1) - float64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							projCol[i] = float64(arg1) - float64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						projCol[i] = float64(arg1) - float64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						projCol[i] = float64(arg1) - float64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projMinusTimestampTimestampOp struct {
	projOpBase
}

func (p projMinusTimestampTimestampOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Timestamp()
		col2 := vec2.Timestamp()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						nanos := arg1.Sub(arg2).Nanoseconds()
						projCol[i] = duration.MakeDurationJustifyHours(nanos, 0, 0)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						nanos := arg1.Sub(arg2).Nanoseconds()
						projCol[i] = duration.MakeDurationJustifyHours(nanos, 0, 0)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					nanos := arg1.Sub(arg2).Nanoseconds()
					projCol[i] = duration.MakeDurationJustifyHours(nanos, 0, 0)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					nanos := arg1.Sub(arg2).Nanoseconds()
					projCol[i] = duration.MakeDurationJustifyHours(nanos, 0, 0)

				}
			}
		}
	})
	return batch
}

type projMinusTimestampIntervalOp struct {
	projOpBase
}

func (p projMinusTimestampIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Timestamp()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Timestamp()
		col2 := vec2.Interval()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)
						t_res := duration.Add(arg1, arg2.Mul(-1))
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)
						t_res := duration.Add(arg1, arg2.Mul(-1))
						rounded_res := t_res.Round(time.Microsecond)
						if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
							colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
						}
						projCol[i] = t_res
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)
					t_res := duration.Add(arg1, arg2.Mul(-1))
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)
					t_res := duration.Add(arg1, arg2.Mul(-1))
					rounded_res := t_res.Round(time.Microsecond)
					if rounded_res.After(tree.MaxSupportedTime) || rounded_res.Before(tree.MinSupportedTime) {
						colexecerror.ExpectedError(errors.Newf("timestamp %q exceeds supported timestamp bounds", t_res.Format(time.RFC3339)))
					}
					projCol[i] = t_res
				}
			}
		}
	})
	return batch
}

type projMinusIntervalIntervalOp struct {
	projOpBase
}

func (p projMinusIntervalIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Interval()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)
						projCol[i] = arg1.Sub(arg2)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)
						projCol[i] = arg1.Sub(arg2)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)
					projCol[i] = arg1.Sub(arg2)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)
					projCol[i] = arg1.Sub(arg2)
				}
			}
		}
	})
	return batch
}

type projMinusIntervalDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projMinusIntervalDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg1}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg1}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg1}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg1}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, _nonDatumArgAsDatum.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusJSONBytesOp struct {
	projOpBase
}

func (p projMinusJSONBytesOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.JSON()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.Bytes()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// RemoveString.
						_j, _, _err := arg1.RemoveString(*(*string)(unsafe.Pointer(&arg2)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// RemoveString.
						_j, _, _err := arg1.RemoveString(*(*string)(unsafe.Pointer(&arg2)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// RemoveString.
					_j, _, _err := arg1.RemoveString(*(*string)(unsafe.Pointer(&arg2)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// RemoveString.
					_j, _, _err := arg1.RemoveString(*(*string)(unsafe.Pointer(&arg2)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)

				}
			}
		}
	})
	return batch
}

type projMinusJSONInt16Op struct {
	projOpBase
}

func (p projMinusJSONInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.JSON()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_j, _, _err := arg1.RemoveIndex(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_j, _, _err := arg1.RemoveIndex(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_j, _, _err := arg1.RemoveIndex(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_j, _, _err := arg1.RemoveIndex(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			}
		}
	})
	return batch
}

type projMinusJSONInt32Op struct {
	projOpBase
}

func (p projMinusJSONInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.JSON()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_j, _, _err := arg1.RemoveIndex(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_j, _, _err := arg1.RemoveIndex(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_j, _, _err := arg1.RemoveIndex(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_j, _, _err := arg1.RemoveIndex(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			}
		}
	})
	return batch
}

type projMinusJSONInt64Op struct {
	projOpBase
}

func (p projMinusJSONInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.JSON()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_j, _, _err := arg1.RemoveIndex(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_j, _, _err := arg1.RemoveIndex(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						projCol.Set(i, _j)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_j, _, _err := arg1.RemoveIndex(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_j, _, _err := arg1.RemoveIndex(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					projCol.Set(i, _j)
				}
			}
		}
	})
	return batch
}

type projMinusDatumDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projMinusDatumDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDatumIntervalOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projMinusDatumIntervalOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Interval()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg2}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInterval{Duration: arg2}
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg2}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInterval{Duration: arg2}
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDatumBytesOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projMinusDatumBytesOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Bytes()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DString(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DString(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DString(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DString(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDatumInt16Op struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projMinusDatumInt16Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDatumInt32Op struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projMinusDatumInt32Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMinusDatumInt64Op struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projMinusDatumInt64Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projMultDecimalInt16Op struct {
	projOpBase
}

func (p projMultDecimalInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMultDecimalInt32Op struct {
	projOpBase
}

func (p projMultDecimalInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMultDecimalInt64Op struct {
	projOpBase
}

func (p projMultDecimalInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projMultDecimalDecimalOp struct {
	projOpBase
}

func (p projMultDecimalDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							_, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							_, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						_, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						_, err := tree.ExactCtx.Mul(&projCol[i], &arg1, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMultDecimalIntervalOp struct {
	projOpBase
}

func (p projMultDecimalIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Interval()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						f, err := arg1.Float64()
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						projCol[i] = arg2.MulFloat(f)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						f, err := arg1.Float64()
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						projCol[i] = arg2.MulFloat(f)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					f, err := arg1.Float64()
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					projCol[i] = arg2.MulFloat(f)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					f, err := arg1.Float64()
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					projCol[i] = arg2.MulFloat(f)
				}
			}
		}
	})
	return batch
}

type projMultInt16Int16Op struct {
	projOpBase
}

func (p projMultInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt8 || _left < math.MinInt8 || _right > math.MaxInt8 || _right < math.MinInt8 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt8 || _left < math.MinInt8 || _right > math.MaxInt8 || _right < math.MinInt8 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt8 || _left < math.MinInt8 || _right > math.MaxInt8 || _right < math.MinInt8 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt8 || _left < math.MinInt8 || _right > math.MaxInt8 || _right < math.MinInt8 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt16Int32Op struct {
	projOpBase
}

func (p projMultInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt16Int64Op struct {
	projOpBase
}

func (p projMultInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt16DecimalOp struct {
	projOpBase
}

func (p projMultInt16DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMultInt16IntervalOp struct {
	projOpBase
}

func (p projMultInt16IntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Interval()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)
						projCol[i] = arg2.Mul(int64(arg1))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)
						projCol[i] = arg2.Mul(int64(arg1))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)
					projCol[i] = arg2.Mul(int64(arg1))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)
					projCol[i] = arg2.Mul(int64(arg1))
				}
			}
		}
	})
	return batch
}

type projMultInt32Int16Op struct {
	projOpBase
}

func (p projMultInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt32Int32Op struct {
	projOpBase
}

func (p projMultInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt16 || _left < math.MinInt16 || _right > math.MaxInt16 || _right < math.MinInt16 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt16 || _left < math.MinInt16 || _right > math.MaxInt16 || _right < math.MinInt16 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt16 || _left < math.MinInt16 || _right > math.MaxInt16 || _right < math.MinInt16 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt16 || _left < math.MinInt16 || _right > math.MaxInt16 || _right < math.MinInt16 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt32Int64Op struct {
	projOpBase
}

func (p projMultInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt32DecimalOp struct {
	projOpBase
}

func (p projMultInt32DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMultInt32IntervalOp struct {
	projOpBase
}

func (p projMultInt32IntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Interval()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)
						projCol[i] = arg2.Mul(int64(arg1))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)
						projCol[i] = arg2.Mul(int64(arg1))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)
					projCol[i] = arg2.Mul(int64(arg1))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)
					projCol[i] = arg2.Mul(int64(arg1))
				}
			}
		}
	})
	return batch
}

type projMultInt64Int16Op struct {
	projOpBase
}

func (p projMultInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt64Int32Op struct {
	projOpBase
}

func (p projMultInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt64Int64Op struct {
	projOpBase
}

func (p projMultInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							_left, _right := int64(arg1), int64(arg2)
							result := _left * _right
							if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
								if _left != 0 && _right != 0 {
									sameSign := (_left < 0) == (_right < 0)
									if (result < 0) == sameSign {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									} else if result/_right != _left {
										colexecerror.ExpectedError(tree.ErrIntOutOfRange)
									}
								}
							}
							projCol[i] = result
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						_left, _right := int64(arg1), int64(arg2)
						result := _left * _right
						if _left > math.MaxInt32 || _left < math.MinInt32 || _right > math.MaxInt32 || _right < math.MinInt32 {
							if _left != 0 && _right != 0 {
								sameSign := (_left < 0) == (_right < 0)
								if (result < 0) == sameSign {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								} else if result/_right != _left {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
							}
						}
						projCol[i] = result
					}

				}
			}
		}
	})
	return batch
}

type projMultInt64DecimalOp struct {
	projOpBase
}

func (p projMultInt64DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.ExactCtx.Mul(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projMultInt64IntervalOp struct {
	projOpBase
}

func (p projMultInt64IntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Interval()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)
						projCol[i] = arg2.Mul(int64(arg1))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)
						projCol[i] = arg2.Mul(int64(arg1))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)
					projCol[i] = arg2.Mul(int64(arg1))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)
					projCol[i] = arg2.Mul(int64(arg1))
				}
			}
		}
	})
	return batch
}

type projMultFloat64Float64Op struct {
	projOpBase
}

func (p projMultFloat64Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Float64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							projCol[i] = float64(arg1) * float64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							projCol[i] = float64(arg1) * float64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						projCol[i] = float64(arg1) * float64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						projCol[i] = float64(arg1) * float64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projMultFloat64IntervalOp struct {
	projOpBase
}

func (p projMultFloat64IntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Interval()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)
						projCol[i] = arg2.MulFloat(float64(arg1))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)
						projCol[i] = arg2.MulFloat(float64(arg1))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)
					projCol[i] = arg2.MulFloat(float64(arg1))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)
					projCol[i] = arg2.MulFloat(float64(arg1))
				}
			}
		}
	})
	return batch
}

type projMultIntervalInt16Op struct {
	projOpBase
}

func (p projMultIntervalInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)
						projCol[i] = arg1.Mul(int64(arg2))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)
						projCol[i] = arg1.Mul(int64(arg2))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)
					projCol[i] = arg1.Mul(int64(arg2))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)
					projCol[i] = arg1.Mul(int64(arg2))
				}
			}
		}
	})
	return batch
}

type projMultIntervalInt32Op struct {
	projOpBase
}

func (p projMultIntervalInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)
						projCol[i] = arg1.Mul(int64(arg2))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)
						projCol[i] = arg1.Mul(int64(arg2))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)
					projCol[i] = arg1.Mul(int64(arg2))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)
					projCol[i] = arg1.Mul(int64(arg2))
				}
			}
		}
	})
	return batch
}

type projMultIntervalInt64Op struct {
	projOpBase
}

func (p projMultIntervalInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)
						projCol[i] = arg1.Mul(int64(arg2))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)
						projCol[i] = arg1.Mul(int64(arg2))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)
					projCol[i] = arg1.Mul(int64(arg2))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)
					projCol[i] = arg1.Mul(int64(arg2))
				}
			}
		}
	})
	return batch
}

type projMultIntervalFloat64Op struct {
	projOpBase
}

func (p projMultIntervalFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)
						projCol[i] = arg1.MulFloat(float64(arg2))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)
						projCol[i] = arg1.MulFloat(float64(arg2))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)
					projCol[i] = arg1.MulFloat(float64(arg2))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)
					projCol[i] = arg1.MulFloat(float64(arg2))
				}
			}
		}
	})
	return batch
}

type projMultIntervalDecimalOp struct {
	projOpBase
}

func (p projMultIntervalDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						f, err := arg2.Float64()
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						projCol[i] = arg1.MulFloat(f)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						f, err := arg2.Float64()
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						projCol[i] = arg1.MulFloat(f)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					f, err := arg2.Float64()
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					projCol[i] = arg1.MulFloat(f)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					f, err := arg2.Float64()
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					projCol[i] = arg1.MulFloat(f)
				}
			}
		}
	})
	return batch
}

type projDivDecimalInt16Op struct {
	projOpBase
}

func (p projDivDecimalInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivDecimalInt32Op struct {
	projOpBase
}

func (p projDivDecimalInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivDecimalInt64Op struct {
	projOpBase
}

func (p projDivDecimalInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivDecimalDecimalOp struct {
	projOpBase
}

func (p projDivDecimalDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite && arg1.Form == apd.Finite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite && arg1.Form == apd.Finite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite && arg1.Form == apd.Finite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.DecimalCtx.Quo(&projCol[i], &arg1, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite && arg1.Form == apd.Finite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projDivInt16Int16Op struct {
	projOpBase
}

func (p projDivInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt16Int32Op struct {
	projOpBase
}

func (p projDivInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt16Int64Op struct {
	projOpBase
}

func (p projDivInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt16DecimalOp struct {
	projOpBase
}

func (p projDivInt16DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projDivInt32Int16Op struct {
	projOpBase
}

func (p projDivInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt32Int32Op struct {
	projOpBase
}

func (p projDivInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt32Int64Op struct {
	projOpBase
}

func (p projDivInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt32DecimalOp struct {
	projOpBase
}

func (p projDivInt32DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projDivInt64Int16Op struct {
	projOpBase
}

func (p projDivInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt64Int32Op struct {
	projOpBase
}

func (p projDivInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt64Int64Op struct {
	projOpBase
}

func (p projDivInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Quo(&projCol[i], &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projDivInt64DecimalOp struct {
	projOpBase
}

func (p projDivInt64DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.DecimalCtx.Quo(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projDivFloat64Float64Op struct {
	projOpBase
}

func (p projDivFloat64Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Float64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2 == 0.0 && !math.IsNaN(arg1) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = float64(arg1) / float64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2 == 0.0 && !math.IsNaN(arg1) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = float64(arg1) / float64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2 == 0.0 && !math.IsNaN(arg1) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = float64(arg1) / float64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2 == 0.0 && !math.IsNaN(arg1) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = float64(arg1) / float64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projDivIntervalInt16Op struct {
	projOpBase
}

func (p projDivIntervalInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						if arg2 == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg1.Div(int64(arg2))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						if arg2 == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg1.Div(int64(arg2))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					if arg2 == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg1.Div(int64(arg2))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					if arg2 == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg1.Div(int64(arg2))
				}
			}
		}
	})
	return batch
}

type projDivIntervalInt32Op struct {
	projOpBase
}

func (p projDivIntervalInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						if arg2 == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg1.Div(int64(arg2))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						if arg2 == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg1.Div(int64(arg2))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					if arg2 == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg1.Div(int64(arg2))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					if arg2 == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg1.Div(int64(arg2))
				}
			}
		}
	})
	return batch
}

type projDivIntervalInt64Op struct {
	projOpBase
}

func (p projDivIntervalInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						if arg2 == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg1.Div(int64(arg2))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						if arg2 == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg1.Div(int64(arg2))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					if arg2 == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg1.Div(int64(arg2))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					if arg2 == 0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg1.Div(int64(arg2))
				}
			}
		}
	})
	return batch
}

type projDivIntervalFloat64Op struct {
	projOpBase
}

func (p projDivIntervalFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Interval()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						if arg2 == 0.0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg1.DivFloat(float64(arg2))
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						if arg2 == 0.0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = arg1.DivFloat(float64(arg2))
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					if arg2 == 0.0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg1.DivFloat(float64(arg2))
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					if arg2 == 0.0 {
						colexecerror.ExpectedError(tree.ErrDivByZero)
					}
					projCol[i] = arg1.DivFloat(float64(arg2))
				}
			}
		}
	})
	return batch
}

type projFloorDivDecimalInt16Op struct {
	projOpBase
}

func (p projFloorDivDecimalInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivDecimalInt32Op struct {
	projOpBase
}

func (p projFloorDivDecimalInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivDecimalInt64Op struct {
	projOpBase
}

func (p projFloorDivDecimalInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivDecimalDecimalOp struct {
	projOpBase
}

func (p projFloorDivDecimalDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite && arg1.Form == apd.Finite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite && arg1.Form == apd.Finite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite && arg1.Form == apd.Finite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &arg1, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite && arg1.Form == apd.Finite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt16Int16Op struct {
	projOpBase
}

func (p projFloorDivInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt16Int32Op struct {
	projOpBase
}

func (p projFloorDivInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt16Int64Op struct {
	projOpBase
}

func (p projFloorDivInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt16DecimalOp struct {
	projOpBase
}

func (p projFloorDivInt16DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt32Int16Op struct {
	projOpBase
}

func (p projFloorDivInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt32Int32Op struct {
	projOpBase
}

func (p projFloorDivInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt32Int64Op struct {
	projOpBase
}

func (p projFloorDivInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt32DecimalOp struct {
	projOpBase
}

func (p projFloorDivInt32DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt64Int16Op struct {
	projOpBase
}

func (p projFloorDivInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt64Int32Op struct {
	projOpBase
}

func (p projFloorDivInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt64Int64Op struct {
	projOpBase
}

func (p projFloorDivInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) / int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) / int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projFloorDivInt64DecimalOp struct {
	projOpBase
}

func (p projFloorDivInt64DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							if arg2.Form == apd.Infinite {
								projCol[i] = apd.Decimal{}
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.HighPrecisionCtx.QuoInteger(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						if arg2.Form == apd.Infinite {
							projCol[i] = apd.Decimal{}
						}

					}

				}
			}
		}
	})
	return batch
}

type projFloorDivFloat64Float64Op struct {
	projOpBase
}

func (p projFloorDivFloat64Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Float64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2 == 0.0 && !math.IsNaN(arg1) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = math.Trunc(float64(arg1) / float64(arg2))
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2 == 0.0 && !math.IsNaN(arg1) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = math.Trunc(float64(arg1) / float64(arg2))
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2 == 0.0 && !math.IsNaN(arg1) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = math.Trunc(float64(arg1) / float64(arg2))
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2 == 0.0 && !math.IsNaN(arg1) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = math.Trunc(float64(arg1) / float64(arg2))
					}

				}
			}
		}
	})
	return batch
}

type projModDecimalInt16Op struct {
	projOpBase
}

func (p projModDecimalInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projModDecimalInt32Op struct {
	projOpBase
}

func (p projModDecimalInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projModDecimalInt64Op struct {
	projOpBase
}

func (p projModDecimalInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2 == 0 && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2 == 0 && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projModDecimalDecimalOp struct {
	projOpBase
}

func (p projModDecimalDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() && arg1.Form != apd.NaN {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() && arg1.Form != apd.NaN {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &arg1, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projModInt16Int16Op struct {
	projOpBase
}

func (p projModInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projModInt16Int32Op struct {
	projOpBase
}

func (p projModInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projModInt16Int64Op struct {
	projOpBase
}

func (p projModInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projModInt16DecimalOp struct {
	projOpBase
}

func (p projModInt16DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projModInt32Int16Op struct {
	projOpBase
}

func (p projModInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projModInt32Int32Op struct {
	projOpBase
}

func (p projModInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projModInt32Int64Op struct {
	projOpBase
}

func (p projModInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projModInt32DecimalOp struct {
	projOpBase
}

func (p projModInt32DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projModInt64Int16Op struct {
	projOpBase
}

func (p projModInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projModInt64Int32Op struct {
	projOpBase
}

func (p projModInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projModInt64Int64Op struct {
	projOpBase
}

func (p projModInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) == 0 {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}
							projCol[i] = int64(arg1) % int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) == 0 {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}
						projCol[i] = int64(arg1) % int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projModInt64DecimalOp struct {
	projOpBase
}

func (p projModInt64DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2.IsZero() {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2.IsZero() {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.HighPrecisionCtx.Rem(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projModFloat64Float64Op struct {
	projOpBase
}

func (p projModFloat64Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Float64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							if arg2 == 0.0 && !math.IsNaN(arg1) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = math.Mod(float64(arg1), float64(arg2))
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							if arg2 == 0.0 && !math.IsNaN(arg1) {
								colexecerror.ExpectedError(tree.ErrDivByZero)
							}

							projCol[i] = math.Mod(float64(arg1), float64(arg2))
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						if arg2 == 0.0 && !math.IsNaN(arg1) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = math.Mod(float64(arg1), float64(arg2))
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						if arg2 == 0.0 && !math.IsNaN(arg1) {
							colexecerror.ExpectedError(tree.ErrDivByZero)
						}

						projCol[i] = math.Mod(float64(arg1), float64(arg2))
					}

				}
			}
		}
	})
	return batch
}

type projPowDecimalInt16Op struct {
	projOpBase
}

func (p projPowDecimalInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPowDecimalInt32Op struct {
	projOpBase
}

func (p projPowDecimalInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPowDecimalInt64Op struct {
	projOpBase
}

func (p projPowDecimalInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg2))
						if _, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &tmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
					}

				}
			}
		}
	})
	return batch
}

type projPowDecimalDecimalOp struct {
	projOpBase
}

func (p projPowDecimalDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							_, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							_, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						_, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						_, err := tree.DecimalCtx.Pow(&projCol[i], &arg1, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPowInt16Int16Op struct {
	projOpBase
}

func (p projPowInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt16Int32Op struct {
	projOpBase
}

func (p projPowInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt16Int64Op struct {
	projOpBase
}

func (p projPowInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt16DecimalOp struct {
	projOpBase
}

func (p projPowInt16DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPowInt32Int16Op struct {
	projOpBase
}

func (p projPowInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt32Int32Op struct {
	projOpBase
}

func (p projPowInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt32Int64Op struct {
	projOpBase
}

func (p projPowInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt32DecimalOp struct {
	projOpBase
}

func (p projPowInt32DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPowInt64Int16Op struct {
	projOpBase
}

func (p projPowInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt64Int32Op struct {
	projOpBase
}

func (p projPowInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt64Int64Op struct {
	projOpBase
}

func (p projPowInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
							leftTmpDec.SetInt64(int64(int64(arg1)))
							rightTmpDec.SetInt64(int64(int64(arg2)))
							if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
							resultInt, err := leftTmpDec.Int64()
							if err != nil {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							projCol[i] = resultInt
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var leftTmpDec, rightTmpDec apd.Decimal //gcassert:noescape
						leftTmpDec.SetInt64(int64(int64(arg1)))
						rightTmpDec.SetInt64(int64(int64(arg2)))
						if _, err := tree.DecimalCtx.Pow(&leftTmpDec, &leftTmpDec, &rightTmpDec); err != nil {
							colexecerror.ExpectedError(err)
						}
						resultInt, err := leftTmpDec.Int64()
						if err != nil {
							colexecerror.ExpectedError(tree.ErrIntOutOfRange)
						}
						projCol[i] = resultInt
					}

				}
			}
		}
	})
	return batch
}

type projPowInt64DecimalOp struct {
	projOpBase
}

func (p projPowInt64DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Decimal()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.SetInt64(int64(arg1))
						_, err := tree.DecimalCtx.Pow(&projCol[i], &tmpDec, &arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

					}

				}
			}
		}
	})
	return batch
}

type projPowFloat64Float64Op struct {
	projOpBase
}

func (p projPowFloat64Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Float64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{

							projCol[i] = math.Pow(float64(arg1), float64(arg2))
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{

							projCol[i] = math.Pow(float64(arg1), float64(arg2))
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{

						projCol[i] = math.Pow(float64(arg1), float64(arg2))
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{

						projCol[i] = math.Pow(float64(arg1), float64(arg2))
					}

				}
			}
		}
	})
	return batch
}

type projConcatBytesBytesOp struct {
	projOpBase
}

func (p projConcatBytesBytesOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bytes()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bytes()
		col2 := vec2.Bytes()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var r = []byte{}
							r = append(r, arg1...)
							r = append(r, arg2...)
							projCol.Set(i, r)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var r = []byte{}
							r = append(r, arg1...)
							r = append(r, arg2...)
							projCol.Set(i, r)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var r = []byte{}
						r = append(r, arg1...)
						r = append(r, arg2...)
						projCol.Set(i, r)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var r = []byte{}
						r = append(r, arg1...)
						r = append(r, arg2...)
						projCol.Set(i, r)
					}

				}
			}
		}
	})
	return batch
}

type projConcatJSONJSONOp struct {
	projOpBase
}

func (p projConcatJSONJSONOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.JSON()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.JSON()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_j, _err := arg1.Concat(arg2)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_j, _err := arg1.Concat(arg2)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

						projCol.Set(i, _j)
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_j, _err := arg1.Concat(arg2)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}

					projCol.Set(i, _j)
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_j, _err := arg1.Concat(arg2)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}

					projCol.Set(i, _j)
				}
			}
		}
	})
	return batch
}

type projConcatDatumDatumOp struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projConcatDatumDatumOp) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), arg2.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projLShiftInt16Int16Op struct {
	projOpBase
}

func (p projLShiftInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt16Int32Op struct {
	projOpBase
}

func (p projLShiftInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt16Int64Op struct {
	projOpBase
}

func (p projLShiftInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt32Int16Op struct {
	projOpBase
}

func (p projLShiftInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt32Int32Op struct {
	projOpBase
}

func (p projLShiftInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt32Int64Op struct {
	projOpBase
}

func (p projLShiftInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt64Int16Op struct {
	projOpBase
}

func (p projLShiftInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt64Int32Op struct {
	projOpBase
}

func (p projLShiftInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftInt64Int64Op struct {
	projOpBase
}

func (p projLShiftInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) << int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeLShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) << int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projLShiftDatumInt16Op struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projLShiftDatumInt16Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projLShiftDatumInt32Op struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projLShiftDatumInt32Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projLShiftDatumInt64Op struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projLShiftDatumInt64Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projRShiftInt16Int16Op struct {
	projOpBase
}

func (p projRShiftInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt16Int32Op struct {
	projOpBase
}

func (p projRShiftInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt16Int64Op struct {
	projOpBase
}

func (p projRShiftInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt32Int16Op struct {
	projOpBase
}

func (p projRShiftInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt32Int32Op struct {
	projOpBase
}

func (p projRShiftInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt32Int64Op struct {
	projOpBase
}

func (p projRShiftInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt64Int16Op struct {
	projOpBase
}

func (p projRShiftInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt64Int32Op struct {
	projOpBase
}

func (p projRShiftInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftInt64Int64Op struct {
	projOpBase
}

func (p projRShiftInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Int64()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							if int64(arg2) < 0 || int64(arg2) >= 64 {
								telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
								colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
							}
							projCol[i] = int64(arg1) >> int64(arg2)
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						if int64(arg2) < 0 || int64(arg2) >= 64 {
							telemetry.Inc(sqltelemetry.LargeRShiftArgumentCounter)
							colexecerror.ExpectedError(tree.ErrShiftArgOutOfRange)
						}
						projCol[i] = int64(arg1) >> int64(arg2)
					}

				}
			}
		}
	})
	return batch
}

type projRShiftDatumInt16Op struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projRShiftDatumInt16Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projRShiftDatumInt32Op struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projRShiftDatumInt32Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projRShiftDatumInt64Op struct {
	colexecutils.BinaryOverloadHelper
	projOpBase
}

func (p projRShiftDatumInt64Op) Next() coldata.Batch {
	_overloadHelper := p.BinaryOverloadHelper
	_ctx := p.Ctx
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Datum()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_convertedNativeElem := tree.DInt(arg2)
						var _nonDatumArgAsDatum tree.Datum
						_nonDatumArgAsDatum = &_convertedNativeElem

						_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						if _res == tree.DNull {
							_outNulls.SetNull(i)
						}
						projCol.Set(i, _res)

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_convertedNativeElem := tree.DInt(arg2)
					var _nonDatumArgAsDatum tree.Datum
					_nonDatumArgAsDatum = &_convertedNativeElem

					_res, err := eval.BinaryOp(_ctx, _overloadHelper.EvalCtx, _overloadHelper.BinOp, arg1.(tree.Datum), _nonDatumArgAsDatum.(tree.Datum))
					if err != nil {
						colexecerror.ExpectedError(err)
					}
					if _res == tree.DNull {
						_outNulls.SetNull(i)
					}
					projCol.Set(i, _res)

				}
			}
		}
	})
	return batch
}

type projJSONFetchValJSONBytesOp struct {
	projOpBase
}

func (p projJSONFetchValJSONBytesOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.JSON()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.Bytes()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// FetchValKey.
						_j, _err := arg1.FetchValKey(*(*string)(unsafe.Pointer(&arg2)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// FetchValKey.
						_j, _err := arg1.FetchValKey(*(*string)(unsafe.Pointer(&arg2)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// FetchValKey.
					_j, _err := arg1.FetchValKey(*(*string)(unsafe.Pointer(&arg2)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// FetchValKey.
					_j, _err := arg1.FetchValKey(*(*string)(unsafe.Pointer(&arg2)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchValJSONInt16Op struct {
	projOpBase
}

func (p projJSONFetchValJSONInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.JSON()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_j, _err := arg1.FetchValIdx(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_j, _err := arg1.FetchValIdx(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_j, _err := arg1.FetchValIdx(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_j, _err := arg1.FetchValIdx(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchValJSONInt32Op struct {
	projOpBase
}

func (p projJSONFetchValJSONInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.JSON()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_j, _err := arg1.FetchValIdx(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_j, _err := arg1.FetchValIdx(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_j, _err := arg1.FetchValIdx(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_j, _err := arg1.FetchValIdx(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchValJSONInt64Op struct {
	projOpBase
}

func (p projJSONFetchValJSONInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.JSON()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_j, _err := arg1.FetchValIdx(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_j, _err := arg1.FetchValIdx(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _j)
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_j, _err := arg1.FetchValIdx(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_j, _err := arg1.FetchValIdx(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _j)
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchTextJSONBytesOp struct {
	projOpBase
}

func (p projJSONFetchTextJSONBytesOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bytes()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.Bytes()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// FetchValKey.
						_j, _err := arg1.FetchValKey(*(*string)(unsafe.Pointer(&arg2)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
						// is safe since we know the bytes won't change out from under us during
						// FetchValKey.
						_j, _err := arg1.FetchValKey(*(*string)(unsafe.Pointer(&arg2)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// FetchValKey.
					_j, _err := arg1.FetchValKey(*(*string)(unsafe.Pointer(&arg2)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					// Get an unsafe string handle onto the bytes, to avoid a spurious copy. This
					// is safe since we know the bytes won't change out from under us during
					// FetchValKey.
					_j, _err := arg1.FetchValKey(*(*string)(unsafe.Pointer(&arg2)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchTextJSONInt16Op struct {
	projOpBase
}

func (p projJSONFetchTextJSONInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bytes()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_j, _err := arg1.FetchValIdx(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_j, _err := arg1.FetchValIdx(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_j, _err := arg1.FetchValIdx(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_j, _err := arg1.FetchValIdx(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchTextJSONInt32Op struct {
	projOpBase
}

func (p projJSONFetchTextJSONInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bytes()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_j, _err := arg1.FetchValIdx(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_j, _err := arg1.FetchValIdx(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_j, _err := arg1.FetchValIdx(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_j, _err := arg1.FetchValIdx(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchTextJSONInt64Op struct {
	projOpBase
}

func (p projJSONFetchTextJSONInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bytes()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_j, _err := arg1.FetchValIdx(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						_j, _err := arg1.FetchValIdx(int(arg2))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _j == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _j.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_j, _err := arg1.FetchValIdx(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					_j, _err := arg1.FetchValIdx(int(arg2))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _j == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _j.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchValPathJSONDatumOp struct {
	projOpBase
}

func (p projJSONFetchValPathJSONDatumOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.JSON()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_path, _err := tree.GetJSONPath(arg1, *tree.MustBeDArray(arg2.(tree.Datum)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _path == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _path)
						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_path, _err := tree.GetJSONPath(arg1, *tree.MustBeDArray(arg2.(tree.Datum)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _path == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, _path)
						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_path, _err := tree.GetJSONPath(arg1, *tree.MustBeDArray(arg2.(tree.Datum)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _path == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _path)
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_path, _err := tree.GetJSONPath(arg1, *tree.MustBeDArray(arg2.(tree.Datum)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _path == nil {
						_outNulls.SetNull(i)
					} else {
						projCol.Set(i, _path)
					}
				}
			}
		}
	})
	return batch
}

type projJSONFetchTextPathJSONDatumOp struct {
	projOpBase
}

func (p projJSONFetchTextPathJSONDatumOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bytes()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_path, _err := tree.GetJSONPath(arg1, *tree.MustBeDArray(arg2.(tree.Datum)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _path == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _path.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}

						}
					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						_path, _err := tree.GetJSONPath(arg1, *tree.MustBeDArray(arg2.(tree.Datum)))
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _path == nil {
							_outNulls.SetNull(i)
						} else {

							_text, _err := _path.AsText()
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							if _text == nil {
								_outNulls.SetNull(i)
							} else {
								projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
							}

						}
					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_path, _err := tree.GetJSONPath(arg1, *tree.MustBeDArray(arg2.(tree.Datum)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _path == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _path.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					_path, _err := tree.GetJSONPath(arg1, *tree.MustBeDArray(arg2.(tree.Datum)))
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					if _path == nil {
						_outNulls.SetNull(i)
					} else {

						_text, _err := _path.AsText()
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						if _text == nil {
							_outNulls.SetNull(i)
						} else {
							projCol.Set(i, encoding.UnsafeConvertStringToBytes(*_text))
						}

					}
				}
			}
		}
	})
	return batch
}

type projEQBoolBoolOp struct {
	projOpBase
}

func (p projEQBoolBoolOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bool()
		col2 := vec2.Bool()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							if !arg1 && arg2 {
								cmpResult = -1
							} else if arg1 && !arg2 {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							if !arg1 && arg2 {
								cmpResult = -1
							} else if arg1 && !arg2 {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQBytesBytesOp struct {
	projOpBase
}

func (p projEQBytesBytesOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bytes()
		col2 := vec2.Bytes()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg1, arg2)
							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg1, arg2)
							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQDecimalInt16Op struct {
	projOpBase
}

func (p projEQDecimalInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQDecimalInt32Op struct {
	projOpBase
}

func (p projEQDecimalInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQDecimalInt64Op struct {
	projOpBase
}

func (p projEQDecimalInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQDecimalFloat64Op struct {
	projOpBase
}

func (p projEQDecimalFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQDecimalDecimalOp struct {
	projOpBase
}

func (p projEQDecimalDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg1, &arg2)
							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg1, &arg2)
							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt16Int16Op struct {
	projOpBase
}

func (p projEQInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt16Int32Op struct {
	projOpBase
}

func (p projEQInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt16Int64Op struct {
	projOpBase
}

func (p projEQInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt16Float64Op struct {
	projOpBase
}

func (p projEQInt16Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt16DecimalOp struct {
	projOpBase
}

func (p projEQInt16DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt32Int16Op struct {
	projOpBase
}

func (p projEQInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt32Int32Op struct {
	projOpBase
}

func (p projEQInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt32Int64Op struct {
	projOpBase
}

func (p projEQInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt32Float64Op struct {
	projOpBase
}

func (p projEQInt32Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt32DecimalOp struct {
	projOpBase
}

func (p projEQInt32DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt64Int16Op struct {
	projOpBase
}

func (p projEQInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt64Int32Op struct {
	projOpBase
}

func (p projEQInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt64Int64Op struct {
	projOpBase
}

func (p projEQInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt64Float64Op struct {
	projOpBase
}

func (p projEQInt64Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQInt64DecimalOp struct {
	projOpBase
}

func (p projEQInt64DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQFloat64Int16Op struct {
	projOpBase
}

func (p projEQFloat64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQFloat64Int32Op struct {
	projOpBase
}

func (p projEQFloat64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQFloat64Int64Op struct {
	projOpBase
}

func (p projEQFloat64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQFloat64Float64Op struct {
	projOpBase
}

func (p projEQFloat64Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQFloat64DecimalOp struct {
	projOpBase
}

func (p projEQFloat64DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQTimestampTimestampOp struct {
	projOpBase
}

func (p projEQTimestampTimestampOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Timestamp()
		col2 := vec2.Timestamp()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							if arg1.Before(arg2) {
								cmpResult = -1
							} else if arg2.Before(arg1) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							if arg1.Before(arg2) {
								cmpResult = -1
							} else if arg2.Before(arg1) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQIntervalIntervalOp struct {
	projOpBase
}

func (p projEQIntervalIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Interval()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = arg1.Compare(arg2)
							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = arg1.Compare(arg2)
							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQJSONJSONOp struct {
	projOpBase
}

func (p projEQJSONJSONOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.JSON()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							var err error
							cmpResult, err = arg1.Compare(arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							var err error
							cmpResult, err = arg1.Compare(arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projEQDatumDatumOp struct {
	projOpBase
}

func (p projEQDatumDatumOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

							projCol[i] = cmpResult == 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

							projCol[i] = cmpResult == 0
						}

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						projCol[i] = cmpResult == 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						projCol[i] = cmpResult == 0
					}

				}
			}
		}
	})
	return batch
}

type projNEBoolBoolOp struct {
	projOpBase
}

func (p projNEBoolBoolOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bool()
		col2 := vec2.Bool()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							if !arg1 && arg2 {
								cmpResult = -1
							} else if arg1 && !arg2 {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							if !arg1 && arg2 {
								cmpResult = -1
							} else if arg1 && !arg2 {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEBytesBytesOp struct {
	projOpBase
}

func (p projNEBytesBytesOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bytes()
		col2 := vec2.Bytes()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg1, arg2)
							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg1, arg2)
							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEDecimalInt16Op struct {
	projOpBase
}

func (p projNEDecimalInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEDecimalInt32Op struct {
	projOpBase
}

func (p projNEDecimalInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEDecimalInt64Op struct {
	projOpBase
}

func (p projNEDecimalInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEDecimalFloat64Op struct {
	projOpBase
}

func (p projNEDecimalFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEDecimalDecimalOp struct {
	projOpBase
}

func (p projNEDecimalDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg1, &arg2)
							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg1, &arg2)
							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt16Int16Op struct {
	projOpBase
}

func (p projNEInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt16Int32Op struct {
	projOpBase
}

func (p projNEInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt16Int64Op struct {
	projOpBase
}

func (p projNEInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt16Float64Op struct {
	projOpBase
}

func (p projNEInt16Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt16DecimalOp struct {
	projOpBase
}

func (p projNEInt16DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt32Int16Op struct {
	projOpBase
}

func (p projNEInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt32Int32Op struct {
	projOpBase
}

func (p projNEInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt32Int64Op struct {
	projOpBase
}

func (p projNEInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt32Float64Op struct {
	projOpBase
}

func (p projNEInt32Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt32DecimalOp struct {
	projOpBase
}

func (p projNEInt32DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt64Int16Op struct {
	projOpBase
}

func (p projNEInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt64Int32Op struct {
	projOpBase
}

func (p projNEInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt64Int64Op struct {
	projOpBase
}

func (p projNEInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt64Float64Op struct {
	projOpBase
}

func (p projNEInt64Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEInt64DecimalOp struct {
	projOpBase
}

func (p projNEInt64DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEFloat64Int16Op struct {
	projOpBase
}

func (p projNEFloat64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEFloat64Int32Op struct {
	projOpBase
}

func (p projNEFloat64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEFloat64Int64Op struct {
	projOpBase
}

func (p projNEFloat64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEFloat64Float64Op struct {
	projOpBase
}

func (p projNEFloat64Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEFloat64DecimalOp struct {
	projOpBase
}

func (p projNEFloat64DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNETimestampTimestampOp struct {
	projOpBase
}

func (p projNETimestampTimestampOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Timestamp()
		col2 := vec2.Timestamp()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							if arg1.Before(arg2) {
								cmpResult = -1
							} else if arg2.Before(arg1) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							if arg1.Before(arg2) {
								cmpResult = -1
							} else if arg2.Before(arg1) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEIntervalIntervalOp struct {
	projOpBase
}

func (p projNEIntervalIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Interval()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = arg1.Compare(arg2)
							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = arg1.Compare(arg2)
							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEJSONJSONOp struct {
	projOpBase
}

func (p projNEJSONJSONOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.JSON()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							var err error
							cmpResult, err = arg1.Compare(arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							var err error
							cmpResult, err = arg1.Compare(arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projNEDatumDatumOp struct {
	projOpBase
}

func (p projNEDatumDatumOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

							projCol[i] = cmpResult != 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

							projCol[i] = cmpResult != 0
						}

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						projCol[i] = cmpResult != 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						projCol[i] = cmpResult != 0
					}

				}
			}
		}
	})
	return batch
}

type projLTBoolBoolOp struct {
	projOpBase
}

func (p projLTBoolBoolOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bool()
		col2 := vec2.Bool()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							if !arg1 && arg2 {
								cmpResult = -1
							} else if arg1 && !arg2 {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							if !arg1 && arg2 {
								cmpResult = -1
							} else if arg1 && !arg2 {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTBytesBytesOp struct {
	projOpBase
}

func (p projLTBytesBytesOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bytes()
		col2 := vec2.Bytes()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg1, arg2)
							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg1, arg2)
							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTDecimalInt16Op struct {
	projOpBase
}

func (p projLTDecimalInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTDecimalInt32Op struct {
	projOpBase
}

func (p projLTDecimalInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTDecimalInt64Op struct {
	projOpBase
}

func (p projLTDecimalInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTDecimalFloat64Op struct {
	projOpBase
}

func (p projLTDecimalFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTDecimalDecimalOp struct {
	projOpBase
}

func (p projLTDecimalDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg1, &arg2)
							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg1, &arg2)
							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt16Int16Op struct {
	projOpBase
}

func (p projLTInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt16Int32Op struct {
	projOpBase
}

func (p projLTInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt16Int64Op struct {
	projOpBase
}

func (p projLTInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt16Float64Op struct {
	projOpBase
}

func (p projLTInt16Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt16DecimalOp struct {
	projOpBase
}

func (p projLTInt16DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt32Int16Op struct {
	projOpBase
}

func (p projLTInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt32Int32Op struct {
	projOpBase
}

func (p projLTInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt32Int64Op struct {
	projOpBase
}

func (p projLTInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt32Float64Op struct {
	projOpBase
}

func (p projLTInt32Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt32DecimalOp struct {
	projOpBase
}

func (p projLTInt32DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt64Int16Op struct {
	projOpBase
}

func (p projLTInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt64Int32Op struct {
	projOpBase
}

func (p projLTInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt64Int64Op struct {
	projOpBase
}

func (p projLTInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt64Float64Op struct {
	projOpBase
}

func (p projLTInt64Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTInt64DecimalOp struct {
	projOpBase
}

func (p projLTInt64DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTFloat64Int16Op struct {
	projOpBase
}

func (p projLTFloat64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTFloat64Int32Op struct {
	projOpBase
}

func (p projLTFloat64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTFloat64Int64Op struct {
	projOpBase
}

func (p projLTFloat64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTFloat64Float64Op struct {
	projOpBase
}

func (p projLTFloat64Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTFloat64DecimalOp struct {
	projOpBase
}

func (p projLTFloat64DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTTimestampTimestampOp struct {
	projOpBase
}

func (p projLTTimestampTimestampOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Timestamp()
		col2 := vec2.Timestamp()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							if arg1.Before(arg2) {
								cmpResult = -1
							} else if arg2.Before(arg1) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							if arg1.Before(arg2) {
								cmpResult = -1
							} else if arg2.Before(arg1) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if arg1.Before(arg2) {
							cmpResult = -1
						} else if arg2.Before(arg1) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTIntervalIntervalOp struct {
	projOpBase
}

func (p projLTIntervalIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Interval()
		col2 := vec2.Interval()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = arg1.Compare(arg2)
							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = arg1.Compare(arg2)
							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = arg1.Compare(arg2)
						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTJSONJSONOp struct {
	projOpBase
}

func (p projLTJSONJSONOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.JSON()
		col2 := vec2.JSON()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							var err error
							cmpResult, err = arg1.Compare(arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							var err error
							cmpResult, err = arg1.Compare(arg2)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = arg1.Compare(arg2)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLTDatumDatumOp struct {
	projOpBase
}

func (p projLTDatumDatumOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Datum()
		col2 := vec2.Datum()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

							projCol[i] = cmpResult < 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						if col1Nulls.NullAt(i) {
							arg1 = tree.DNull
						}
						arg2 := col2.Get(i)
						if col2Nulls.NullAt(i) {
							arg2 = tree.DNull
						}

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

							projCol[i] = cmpResult < 0
						}

					}
				}
			}
			if !p.calledOnNullInput {
				projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
			}
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						projCol[i] = cmpResult < 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(arg1, col1, arg2)

						projCol[i] = cmpResult < 0
					}

				}
			}
		}
	})
	return batch
}

type projLEBoolBoolOp struct {
	projOpBase
}

func (p projLEBoolBoolOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bool()
		col2 := vec2.Bool()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							if !arg1 && arg2 {
								cmpResult = -1
							} else if arg1 && !arg2 {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							if !arg1 && arg2 {
								cmpResult = -1
							} else if arg1 && !arg2 {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						if !arg1 && arg2 {
							cmpResult = -1
						} else if arg1 && !arg2 {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEBytesBytesOp struct {
	projOpBase
}

func (p projLEBytesBytesOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Bytes()
		col2 := vec2.Bytes()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg1, arg2)
							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = bytes.Compare(arg1, arg2)
							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(arg1, arg2)
						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEDecimalInt16Op struct {
	projOpBase
}

func (p projLEDecimalInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEDecimalInt32Op struct {
	projOpBase
}

func (p projLEDecimalInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEDecimalInt64Op struct {
	projOpBase
}

func (p projLEDecimalInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg2))
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg2))
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEDecimalFloat64Op struct {
	projOpBase
}

func (p projLEDecimalFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							if _, err := tmpDec.SetFloat64(float64(arg2)); err != nil {
								colexecerror.ExpectedError(err)
							}
							cmpResult = tree.CompareDecimals(&arg1, &tmpDec)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEDecimalDecimalOp struct {
	projOpBase
}

func (p projLEDecimalDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Decimal()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg1, &arg2)
							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&arg1, &arg2)
							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&arg1, &arg2)
						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt16Int16Op struct {
	projOpBase
}

func (p projLEInt16Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt16Int32Op struct {
	projOpBase
}

func (p projLEInt16Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt16Int64Op struct {
	projOpBase
}

func (p projLEInt16Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt16Float64Op struct {
	projOpBase
}

func (p projLEInt16Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt16DecimalOp struct {
	projOpBase
}

func (p projLEInt16DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int16()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt32Int16Op struct {
	projOpBase
}

func (p projLEInt32Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt32Int32Op struct {
	projOpBase
}

func (p projLEInt32Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt32Int64Op struct {
	projOpBase
}

func (p projLEInt32Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt32Float64Op struct {
	projOpBase
}

func (p projLEInt32Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt32DecimalOp struct {
	projOpBase
}

func (p projLEInt32DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int32()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt64Int16Op struct {
	projOpBase
}

func (p projLEInt64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt64Int32Op struct {
	projOpBase
}

func (p projLEInt64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt64Int64Op struct {
	projOpBase
}

func (p projLEInt64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := int64(arg1), int64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(arg1), int64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt64Float64Op struct {
	projOpBase
}

func (p projLEInt64Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if false {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if false {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEInt64DecimalOp struct {
	projOpBase
}

func (p projLEInt64DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Int64()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								tmpDec.SetInt64(int64(arg1))
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(arg1))
							cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEFloat64Int16Op struct {
	projOpBase
}

func (p projLEFloat64Int16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int16()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEFloat64Int32Op struct {
	projOpBase
}

func (p projLEFloat64Int32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int32()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEFloat64Int64Op struct {
	projOpBase
}

func (p projLEFloat64Int64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Int64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if false {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if false {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEFloat64Float64Op struct {
	projOpBase
}

func (p projLEFloat64Float64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Float64()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						//gcassert:bce
						arg1 := col1.Get(i)
						//gcassert:bce
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								a, b := float64(arg1), float64(arg2)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							projCol[i] = cmpResult <= 0
						}

					}
				}
			}
			projVec.SetNulls(_outNulls.Or(*col1Nulls).Or(*col2Nulls))
		} else {
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					arg1 := col1.Get(i)
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			} else {
				_ = projCol.Get(n - 1)
				_ = col1.Get(n - 1)
				_ = col2.Get(n - 1)
				for i := 0; i < n; i++ {
					//gcassert:bce
					arg1 := col1.Get(i)
					//gcassert:bce
					arg2 := col2.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(arg1), float64(arg2)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						projCol[i] = cmpResult <= 0
					}

				}
			}
		}
	})
	return batch
}

type projLEFloat64DecimalOp struct {
	projOpBase
}

func (p projLEFloat64DecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(p.outputIdx)
	p.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		projCol := projVec.Bool()
		vec1 := batch.ColVec(p.col1Idx)
		vec2 := batch.ColVec(p.col2Idx)
		col1 := vec1.Float64()
		col2 := vec2.Decimal()
		_outNulls := projVec.Nulls()
		if vec1.Nulls().MaybeHasNulls() || vec2.Nulls().MaybeHasNulls() {
			col1Nulls := vec1.Nulls()
			col2Nulls := vec2.Nulls()
			if sel := batch.Selection(); sel != nil {
				sel = sel[:n]
				for _, i := range sel {
					if p.calledOnNullInput || (!col1Nulls.NullAt(i) && !col2Nulls.NullAt(i)) {
						// We only want to perform the projection operation if both values are not
						// null.
						arg1 := col1.Get(i)
						arg2 := col2.Get(i)

						{
							var cmpResult int

							{
								var tmpDec apd.Decimal //gcassert:noescape
								if _, err := tmpDec.SetFloat64(float64(arg1)); err != nil {
									colexecerror.ExpectedError(err)
								}
								cmpResult = tree.CompareDecimals(&tmpDec, &arg2)
							}

							pro