// Code generated by execgen; DO NOT EDIT.
// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecjoin

import (
	"bytes"
	"math"
	"time"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecop"
	"github.com/cockroachdb/cockroach/pkg/sql/execinfrapb"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/cockroach/pkg/util/json"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ = typeconv.DatumVecCanonicalTypeFamily
	_ apd.Context
	_ = coldataext.CompareDatum
	_ duration.Duration
	_ tree.AggType
	_ json.JSON
)

type mergeJoinExceptAllOp struct {
	*mergeJoinBase
}

var _ colexecop.Operator = &mergeJoinExceptAllOp{}

func (o *mergeJoinExceptAllOp) probeBodyLSeltrueRSeltrue() {
	lSel := o.proberState.lBatch.Selection()
	rSel := o.proberState.rBatch.Selection()
	for eqColIdx := 0; eqColIdx < len(o.left.eqCols); eqColIdx++ {
		leftColIdx := o.left.eqCols[eqColIdx]
		rightColIdx := o.right.eqCols[eqColIdx]
		lVec := o.proberState.lBatch.ColVec(int(leftColIdx))
		rVec := o.proberState.rBatch.ColVec(int(rightColIdx))
		colType := o.left.sourceTypes[leftColIdx]
		lastEqCol := eqColIdx == len(o.left.eqCols)-1
		lNulls := lVec.Nulls()
		rNulls := rVec.Nulls()
		switch lVec.CanonicalTypeFamily() {
		case types.BoolFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Bool()
				rKeys := rVec.Bool()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       bool
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							if !lVal && rVal {
								cmp = -1
							} else if lVal && !rVal {
								cmp = 1
							} else {
								cmp = 0
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										if !newLVal && lVal {
											cmpResult = -1
										} else if newLVal && !lVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										if !newRVal && rVal {
											cmpResult = -1
										} else if newRVal && !rVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											if !newLVal && lVal {
												cmpResult = -1
											} else if newLVal && !lVal {
												cmpResult = 1
											} else {
												cmpResult = 0
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.BytesFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Bytes()
				rKeys := rVec.Bytes()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       []byte
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)
							cmp = bytes.Compare(lVal, rVal)
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int
										cmpResult = bytes.Compare(newLVal, lVal)
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int
										cmpResult = bytes.Compare(newRVal, rVal)
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int
											cmpResult = bytes.Compare(newLVal, lVal)
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.DecimalFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Decimal()
				rKeys := rVec.Decimal()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       apd.Decimal
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)
							cmp = tree.CompareDecimals(&lVal, &rVal)
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&newLVal, &lVal)
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&newRVal, &rVal)
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int
											cmpResult = tree.CompareDecimals(&newLVal, &lVal)
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.IntFamily:
			switch colType.Width() {
			case 16:
				lKeys := lVec.Int16()
				rKeys := rVec.Int16()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       int16
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := int64(lVal), int64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else {
									cmp = 0
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newLVal), int64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newRVal), int64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := int64(newLVal), int64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else {
													cmpResult = 0
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			case 32:
				lKeys := lVec.Int32()
				rKeys := rVec.Int32()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       int32
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := int64(lVal), int64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else {
									cmp = 0
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newLVal), int64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newRVal), int64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := int64(newLVal), int64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else {
													cmpResult = 0
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			case -1:
			default:
				lKeys := lVec.Int64()
				rKeys := rVec.Int64()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       int64
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := int64(lVal), int64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else {
									cmp = 0
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newLVal), int64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newRVal), int64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := int64(newLVal), int64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else {
													cmpResult = 0
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.FloatFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Float64()
				rKeys := rVec.Float64()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       float64
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := float64(lVal), float64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else if a == b {
									cmp = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmp = 0
									} else {
										cmp = -1
									}
								} else {
									cmp = 1
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := float64(newLVal), float64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := float64(newRVal), float64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := float64(newLVal), float64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else if a == b {
													cmpResult = 0
												} else if math.IsNaN(a) {
													if math.IsNaN(b) {
														cmpResult = 0
													} else {
														cmpResult = -1
													}
												} else {
													cmpResult = 1
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.TimestampTZFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Timestamp()
				rKeys := rVec.Timestamp()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       time.Time
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							if lVal.Before(rVal) {
								cmp = -1
							} else if rVal.Before(lVal) {
								cmp = 1
							} else {
								cmp = 0
							}
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										if newLVal.Before(lVal) {
											cmpResult = -1
										} else if lVal.Before(newLVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										if newRVal.Before(rVal) {
											cmpResult = -1
										} else if rVal.Before(newRVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											if newLVal.Before(lVal) {
												cmpResult = -1
											} else if lVal.Before(newLVal) {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.IntervalFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Interval()
				rKeys := rVec.Interval()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       duration.Duration
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)
							cmp = lVal.Compare(rVal)
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int
										cmpResult = newLVal.Compare(lVal)
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int
										cmpResult = newRVal.Compare(rVal)
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int
											cmpResult = newLVal.Compare(lVal)
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.JsonFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.JSON()
				rKeys := rVec.JSON()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       json.JSON
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							var err error
							cmp, err = lVal.Compare(rVal)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										var err error
										cmpResult, err = newLVal.Compare(lVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										var err error
										cmpResult, err = newRVal.Compare(rVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											var err error
											cmpResult, err = newLVal.Compare(lVal)
											if err != nil {
												colexecerror.ExpectedError(err)
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case typeconv.DatumVecCanonicalTypeFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Datum()
				rKeys := rVec.Datum()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       interface{}
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							cmp = coldataext.CompareDatum(lVal, lKeys, rVal)

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(newLVal, lKeys, lVal)

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(newRVal, rKeys, rVal)

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											cmpResult = coldataext.CompareDatum(newLVal, lKeys, lVal)

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		default:
			colexecerror.InternalError(errors.AssertionFailedf("unhandled type %s", colType))
		}
		// Look at the groups associated with the next equality column by moving
		// the circular buffer pointer up.
		o.groups.finishedCol()
	}
}

func (o *mergeJoinExceptAllOp) probeBodyLSeltrueRSelfalse() {
	lSel := o.proberState.lBatch.Selection()
	rSel := o.proberState.rBatch.Selection()
	for eqColIdx := 0; eqColIdx < len(o.left.eqCols); eqColIdx++ {
		leftColIdx := o.left.eqCols[eqColIdx]
		rightColIdx := o.right.eqCols[eqColIdx]
		lVec := o.proberState.lBatch.ColVec(int(leftColIdx))
		rVec := o.proberState.rBatch.ColVec(int(rightColIdx))
		colType := o.left.sourceTypes[leftColIdx]
		lastEqCol := eqColIdx == len(o.left.eqCols)-1
		lNulls := lVec.Nulls()
		rNulls := rVec.Nulls()
		switch lVec.CanonicalTypeFamily() {
		case types.BoolFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Bool()
				rKeys := rVec.Bool()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       bool
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							if !lVal && rVal {
								cmp = -1
							} else if lVal && !rVal {
								cmp = 1
							} else {
								cmp = 0
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										if !newLVal && lVal {
											cmpResult = -1
										} else if newLVal && !lVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										if !newRVal && rVal {
											cmpResult = -1
										} else if newRVal && !rVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											if !newLVal && lVal {
												cmpResult = -1
											} else if newLVal && !lVal {
												cmpResult = 1
											} else {
												cmpResult = 0
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.BytesFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Bytes()
				rKeys := rVec.Bytes()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       []byte
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)
							cmp = bytes.Compare(lVal, rVal)
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int
										cmpResult = bytes.Compare(newLVal, lVal)
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int
										cmpResult = bytes.Compare(newRVal, rVal)
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int
											cmpResult = bytes.Compare(newLVal, lVal)
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.DecimalFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Decimal()
				rKeys := rVec.Decimal()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       apd.Decimal
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)
							cmp = tree.CompareDecimals(&lVal, &rVal)
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&newLVal, &lVal)
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&newRVal, &rVal)
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int
											cmpResult = tree.CompareDecimals(&newLVal, &lVal)
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.IntFamily:
			switch colType.Width() {
			case 16:
				lKeys := lVec.Int16()
				rKeys := rVec.Int16()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       int16
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := int64(lVal), int64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else {
									cmp = 0
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newLVal), int64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newRVal), int64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := int64(newLVal), int64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else {
													cmpResult = 0
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			case 32:
				lKeys := lVec.Int32()
				rKeys := rVec.Int32()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       int32
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := int64(lVal), int64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else {
									cmp = 0
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newLVal), int64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newRVal), int64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := int64(newLVal), int64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else {
													cmpResult = 0
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			case -1:
			default:
				lKeys := lVec.Int64()
				rKeys := rVec.Int64()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       int64
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := int64(lVal), int64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else {
									cmp = 0
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newLVal), int64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newRVal), int64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := int64(newLVal), int64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else {
													cmpResult = 0
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.FloatFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Float64()
				rKeys := rVec.Float64()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       float64
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := float64(lVal), float64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else if a == b {
									cmp = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmp = 0
									} else {
										cmp = -1
									}
								} else {
									cmp = 1
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := float64(newLVal), float64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := float64(newRVal), float64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := float64(newLVal), float64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else if a == b {
													cmpResult = 0
												} else if math.IsNaN(a) {
													if math.IsNaN(b) {
														cmpResult = 0
													} else {
														cmpResult = -1
													}
												} else {
													cmpResult = 1
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.TimestampTZFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Timestamp()
				rKeys := rVec.Timestamp()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       time.Time
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							if lVal.Before(rVal) {
								cmp = -1
							} else if rVal.Before(lVal) {
								cmp = 1
							} else {
								cmp = 0
							}
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										if newLVal.Before(lVal) {
											cmpResult = -1
										} else if lVal.Before(newLVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										if newRVal.Before(rVal) {
											cmpResult = -1
										} else if rVal.Before(newRVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											if newLVal.Before(lVal) {
												cmpResult = -1
											} else if lVal.Before(newLVal) {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.IntervalFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Interval()
				rKeys := rVec.Interval()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       duration.Duration
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)
							cmp = lVal.Compare(rVal)
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int
										cmpResult = newLVal.Compare(lVal)
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int
										cmpResult = newRVal.Compare(rVal)
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int
											cmpResult = newLVal.Compare(lVal)
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.JsonFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.JSON()
				rKeys := rVec.JSON()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       json.JSON
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							var err error
							cmp, err = lVal.Compare(rVal)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										var err error
										cmpResult, err = newLVal.Compare(lVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										var err error
										cmpResult, err = newRVal.Compare(rVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											var err error
											cmpResult, err = newLVal.Compare(lVal)
											if err != nil {
												colexecerror.ExpectedError(err)
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case typeconv.DatumVecCanonicalTypeFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Datum()
				rKeys := rVec.Datum()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       interface{}
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(lSel[curLIdx])
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = lSel[curLIdx]
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							cmp = coldataext.CompareDatum(lVal, lKeys, rVal)

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(lSel[curLIdx]) {
										lComplete = true
										break
									}
									lSelIdx = lSel[curLIdx]
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(newLVal, lKeys, lVal)

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(newRVal, rKeys, rVal)

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(lSel[curLIdx])
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = lSel[curLIdx]
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											cmpResult = coldataext.CompareDatum(newLVal, lKeys, lVal)

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		default:
			colexecerror.InternalError(errors.AssertionFailedf("unhandled type %s", colType))
		}
		// Look at the groups associated with the next equality column by moving
		// the circular buffer pointer up.
		o.groups.finishedCol()
	}
}

func (o *mergeJoinExceptAllOp) probeBodyLSelfalseRSeltrue() {
	lSel := o.proberState.lBatch.Selection()
	rSel := o.proberState.rBatch.Selection()
	for eqColIdx := 0; eqColIdx < len(o.left.eqCols); eqColIdx++ {
		leftColIdx := o.left.eqCols[eqColIdx]
		rightColIdx := o.right.eqCols[eqColIdx]
		lVec := o.proberState.lBatch.ColVec(int(leftColIdx))
		rVec := o.proberState.rBatch.ColVec(int(rightColIdx))
		colType := o.left.sourceTypes[leftColIdx]
		lastEqCol := eqColIdx == len(o.left.eqCols)-1
		lNulls := lVec.Nulls()
		rNulls := rVec.Nulls()
		switch lVec.CanonicalTypeFamily() {
		case types.BoolFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Bool()
				rKeys := rVec.Bool()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       bool
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							if !lVal && rVal {
								cmp = -1
							} else if lVal && !rVal {
								cmp = 1
							} else {
								cmp = 0
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										if !newLVal && lVal {
											cmpResult = -1
										} else if newLVal && !lVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										if !newRVal && rVal {
											cmpResult = -1
										} else if newRVal && !rVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											if !newLVal && lVal {
												cmpResult = -1
											} else if newLVal && !lVal {
												cmpResult = 1
											} else {
												cmpResult = 0
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.BytesFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Bytes()
				rKeys := rVec.Bytes()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       []byte
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)
							cmp = bytes.Compare(lVal, rVal)
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int
										cmpResult = bytes.Compare(newLVal, lVal)
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int
										cmpResult = bytes.Compare(newRVal, rVal)
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int
											cmpResult = bytes.Compare(newLVal, lVal)
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.DecimalFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Decimal()
				rKeys := rVec.Decimal()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       apd.Decimal
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)
							cmp = tree.CompareDecimals(&lVal, &rVal)
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&newLVal, &lVal)
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&newRVal, &rVal)
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int
											cmpResult = tree.CompareDecimals(&newLVal, &lVal)
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.IntFamily:
			switch colType.Width() {
			case 16:
				lKeys := lVec.Int16()
				rKeys := rVec.Int16()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       int16
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := int64(lVal), int64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else {
									cmp = 0
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newLVal), int64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newRVal), int64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := int64(newLVal), int64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else {
													cmpResult = 0
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			case 32:
				lKeys := lVec.Int32()
				rKeys := rVec.Int32()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       int32
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := int64(lVal), int64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else {
									cmp = 0
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newLVal), int64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newRVal), int64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := int64(newLVal), int64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else {
													cmpResult = 0
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			case -1:
			default:
				lKeys := lVec.Int64()
				rKeys := rVec.Int64()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       int64
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := int64(lVal), int64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else {
									cmp = 0
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newLVal), int64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newRVal), int64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := int64(newLVal), int64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else {
													cmpResult = 0
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.FloatFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Float64()
				rKeys := rVec.Float64()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       float64
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := float64(lVal), float64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else if a == b {
									cmp = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmp = 0
									} else {
										cmp = -1
									}
								} else {
									cmp = 1
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := float64(newLVal), float64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := float64(newRVal), float64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := float64(newLVal), float64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else if a == b {
													cmpResult = 0
												} else if math.IsNaN(a) {
													if math.IsNaN(b) {
														cmpResult = 0
													} else {
														cmpResult = -1
													}
												} else {
													cmpResult = 1
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.TimestampTZFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Timestamp()
				rKeys := rVec.Timestamp()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       time.Time
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							if lVal.Before(rVal) {
								cmp = -1
							} else if rVal.Before(lVal) {
								cmp = 1
							} else {
								cmp = 0
							}
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										if newLVal.Before(lVal) {
											cmpResult = -1
										} else if lVal.Before(newLVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										if newRVal.Before(rVal) {
											cmpResult = -1
										} else if rVal.Before(newRVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											if newLVal.Before(lVal) {
												cmpResult = -1
											} else if lVal.Before(newLVal) {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.IntervalFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Interval()
				rKeys := rVec.Interval()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       duration.Duration
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)
							cmp = lVal.Compare(rVal)
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int
										cmpResult = newLVal.Compare(lVal)
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int
										cmpResult = newRVal.Compare(rVal)
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int
											cmpResult = newLVal.Compare(lVal)
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.JsonFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.JSON()
				rKeys := rVec.JSON()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       json.JSON
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							var err error
							cmp, err = lVal.Compare(rVal)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										var err error
										cmpResult, err = newLVal.Compare(lVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										var err error
										cmpResult, err = newRVal.Compare(rVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											var err error
											cmpResult, err = newLVal.Compare(lVal)
											if err != nil {
												colexecerror.ExpectedError(err)
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case typeconv.DatumVecCanonicalTypeFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Datum()
				rKeys := rVec.Datum()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       interface{}
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(rSel[curRIdx])

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = rSel[curRIdx]
							rVal = rKeys.Get(rSelIdx)

							cmp = coldataext.CompareDatum(lVal, lKeys, rVal)

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(newLVal, lKeys, lVal)

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(rSel[curRIdx]) {
										rComplete = true
										break
									}
									rSelIdx = rSel[curRIdx]
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(newRVal, rKeys, rVal)

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											cmpResult = coldataext.CompareDatum(newLVal, lKeys, lVal)

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		default:
			colexecerror.InternalError(errors.AssertionFailedf("unhandled type %s", colType))
		}
		// Look at the groups associated with the next equality column by moving
		// the circular buffer pointer up.
		o.groups.finishedCol()
	}
}

func (o *mergeJoinExceptAllOp) probeBodyLSelfalseRSelfalse() {
	lSel := o.proberState.lBatch.Selection()
	rSel := o.proberState.rBatch.Selection()
	for eqColIdx := 0; eqColIdx < len(o.left.eqCols); eqColIdx++ {
		leftColIdx := o.left.eqCols[eqColIdx]
		rightColIdx := o.right.eqCols[eqColIdx]
		lVec := o.proberState.lBatch.ColVec(int(leftColIdx))
		rVec := o.proberState.rBatch.ColVec(int(rightColIdx))
		colType := o.left.sourceTypes[leftColIdx]
		lastEqCol := eqColIdx == len(o.left.eqCols)-1
		lNulls := lVec.Nulls()
		rNulls := rVec.Nulls()
		switch lVec.CanonicalTypeFamily() {
		case types.BoolFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Bool()
				rKeys := rVec.Bool()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       bool
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							if !lVal && rVal {
								cmp = -1
							} else if lVal && !rVal {
								cmp = 1
							} else {
								cmp = 0
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										if !newLVal && lVal {
											cmpResult = -1
										} else if newLVal && !lVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										if !newRVal && rVal {
											cmpResult = -1
										} else if newRVal && !rVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											if !newLVal && lVal {
												cmpResult = -1
											} else if newLVal && !lVal {
												cmpResult = 1
											} else {
												cmpResult = 0
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.BytesFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Bytes()
				rKeys := rVec.Bytes()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       []byte
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)
							cmp = bytes.Compare(lVal, rVal)
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int
										cmpResult = bytes.Compare(newLVal, lVal)
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int
										cmpResult = bytes.Compare(newRVal, rVal)
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int
											cmpResult = bytes.Compare(newLVal, lVal)
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.DecimalFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Decimal()
				rKeys := rVec.Decimal()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       apd.Decimal
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)
							cmp = tree.CompareDecimals(&lVal, &rVal)
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&newLVal, &lVal)
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&newRVal, &rVal)
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int
											cmpResult = tree.CompareDecimals(&newLVal, &lVal)
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.IntFamily:
			switch colType.Width() {
			case 16:
				lKeys := lVec.Int16()
				rKeys := rVec.Int16()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       int16
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := int64(lVal), int64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else {
									cmp = 0
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newLVal), int64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newRVal), int64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := int64(newLVal), int64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else {
													cmpResult = 0
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			case 32:
				lKeys := lVec.Int32()
				rKeys := rVec.Int32()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       int32
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := int64(lVal), int64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else {
									cmp = 0
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newLVal), int64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newRVal), int64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := int64(newLVal), int64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else {
													cmpResult = 0
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			case -1:
			default:
				lKeys := lVec.Int64()
				rKeys := rVec.Int64()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       int64
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := int64(lVal), int64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else {
									cmp = 0
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newLVal), int64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := int64(newRVal), int64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := int64(newLVal), int64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else {
													cmpResult = 0
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.FloatFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Float64()
				rKeys := rVec.Float64()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       float64
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							{
								a, b := float64(lVal), float64(rVal)
								if a < b {
									cmp = -1
								} else if a > b {
									cmp = 1
								} else if a == b {
									cmp = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmp = 0
									} else {
										cmp = -1
									}
								} else {
									cmp = 1
								}
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										{
											a, b := float64(newLVal), float64(lVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										{
											a, b := float64(newRVal), float64(rVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											{
												a, b := float64(newLVal), float64(lVal)
												if a < b {
													cmpResult = -1
												} else if a > b {
													cmpResult = 1
												} else if a == b {
													cmpResult = 0
												} else if math.IsNaN(a) {
													if math.IsNaN(b) {
														cmpResult = 0
													} else {
														cmpResult = -1
													}
												} else {
													cmpResult = 1
												}
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.TimestampTZFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Timestamp()
				rKeys := rVec.Timestamp()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       time.Time
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							if lVal.Before(rVal) {
								cmp = -1
							} else if rVal.Before(lVal) {
								cmp = 1
							} else {
								cmp = 0
							}
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										if newLVal.Before(lVal) {
											cmpResult = -1
										} else if lVal.Before(newLVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										if newRVal.Before(rVal) {
											cmpResult = -1
										} else if rVal.Before(newRVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											if newLVal.Before(lVal) {
												cmpResult = -1
											} else if lVal.Before(newLVal) {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.IntervalFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Interval()
				rKeys := rVec.Interval()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       duration.Duration
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)
							cmp = lVal.Compare(rVal)
						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int
										cmpResult = newLVal.Compare(lVal)
										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int
										cmpResult = newRVal.Compare(rVal)
										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int
											cmpResult = newLVal.Compare(lVal)
											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case types.JsonFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.JSON()
				rKeys := rVec.JSON()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       json.JSON
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							var err error
							cmp, err = lVal.Compare(rVal)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										var err error
										cmpResult, err = newLVal.Compare(lVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										var err error
										cmpResult, err = newRVal.Compare(rVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											var err error
											cmpResult, err = newLVal.Compare(lVal)
											if err != nil {
												colexecerror.ExpectedError(err)
											}

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		case typeconv.DatumVecCanonicalTypeFamily:
			switch colType.Width() {
			case -1:
			default:
				lKeys := lVec.Datum()
				rKeys := rVec.Datum()
				var (
					lGroup, rGroup   group
					cmp              int
					match            bool
					lVal, rVal       interface{}
					lSelIdx, rSelIdx int
				)

				for o.groups.nextGroupInCol(&lGroup, &rGroup) {
					curLIdx := lGroup.rowStartIdx
					curRIdx := rGroup.rowStartIdx
					curLEndIdx := lGroup.rowEndIdx
					curREndIdx := rGroup.rowEndIdx
					if lGroup.unmatched {
						// The row already does not have a match, so we don't need to do any
						// additional processing.
						o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
						if lastEqCol && curLIdx >= o.proberState.lIdx {
							o.proberState.lIdx = curLIdx + 1
						}
						continue
					}
					// Expand or filter each group based on the current equality column.
					for curLIdx < curLEndIdx && curRIdx < curREndIdx {
						cmp = 0
						lNull := lNulls.NullAt(curLIdx)
						rNull := rNulls.NullAt(curRIdx)

						if lNull {
							cmp--
						}
						if rNull {
							cmp++
						}
						var nullMatch bool
						_ = nullMatch
						// If we have a NULL match, it will take precedence over
						// cmp value set above.
						nullMatch = lNull && rNull

						needToCompare := true
						// For set operation joins we have already set 'cmp' to
						// correct value above if we have a null value at least
						// on one side.
						needToCompare = !lNull && !rNull
						if needToCompare {
							lSelIdx = curLIdx
							lVal = lKeys.Get(lSelIdx)
							rSelIdx = curRIdx
							rVal = rKeys.Get(rSelIdx)

							cmp = coldataext.CompareDatum(lVal, lKeys, rVal)

						}

						if cmp == 0 {
							// Find the length of the groups on each side.
							lGroupLength, rGroupLength := 1, 1
							// If a group ends before the end of the probing batch,
							// then we know it is complete.
							lComplete := curLEndIdx < o.proberState.lLength
							rComplete := curREndIdx < o.proberState.rLength
							beginLIdx, beginRIdx := curLIdx, curRIdx
							curLIdx++
							curRIdx++

							// Find the length of the group on the left.
							for curLIdx < curLEndIdx {
								if nullMatch {
									if !lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
								} else {
									if lNulls.NullAt(curLIdx) {
										lComplete = true
										break
									}
									lSelIdx = curLIdx
									newLVal := lKeys.Get(lSelIdx)

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(newLVal, lKeys, lVal)

										match = cmpResult == 0
									}

									if !match {
										lComplete = true
										break
									}
								}
								lGroupLength++
								curLIdx++
							}

							// Find the length of the group on the right.
							for curRIdx < curREndIdx {
								if nullMatch {
									if !rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
								} else {
									if rNulls.NullAt(curRIdx) {
										rComplete = true
										break
									}
									rSelIdx = curRIdx
									newRVal := rKeys.Get(rSelIdx)

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(newRVal, rKeys, rVal)

										match = cmpResult == 0
									}

									if !match {
										rComplete = true
										break
									}
								}
								rGroupLength++
								curRIdx++
							}

							// Last equality column and either group is incomplete.
							if lastEqCol && (!lComplete || !rComplete) {
								// Store the state about the buffered group.
								o.startLeftBufferedGroup(lSel, beginLIdx, lGroupLength)
								o.bufferedGroup.leftGroupStartIdx = beginLIdx
								o.proberState.lIdx = lGroupLength + beginLIdx
								o.appendToRightBufferedGroup(rSel, beginRIdx, rGroupLength)
								o.proberState.rIdx = rGroupLength + beginRIdx
								o.groups.finishedCol()
								return
							}

							if !lastEqCol {
								o.groups.addGroupsToNextCol(beginLIdx, lGroupLength, beginRIdx, rGroupLength)
							} else {
								// For EXCEPT ALL join we add (lGroupLength - rGroupLength) number
								// (if positive) of unmatched left groups.
								for leftUnmatchedTupleIdx := beginLIdx + rGroupLength; leftUnmatchedTupleIdx < beginLIdx+lGroupLength; leftUnmatchedTupleIdx++ {
									// Right index here doesn't matter.
									o.groups.addLeftUnmatchedGroup(leftUnmatchedTupleIdx, beginRIdx)
								}
							}
						} else { // mismatch
							// The line below is a compact form of the following:
							//   incrementLeft :=
							//    (cmp < 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC) ||
							//	  (cmp > 0 && o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_DESC).
							incrementLeft := cmp < 0 == (o.left.directions[eqColIdx] == execinfrapb.Ordering_Column_ASC)
							if incrementLeft {
								curLIdx++
								// All the rows on the left within the current group will not get a match on
								// the right, so we're adding each of them as a left unmatched group.
								o.groups.addLeftUnmatchedGroup(curLIdx-1, curRIdx)
								for curLIdx < curLEndIdx {
									newLValNull := lNulls.NullAt(curLIdx)
									if lNull != newLValNull {
										// We have a null mismatch, so we've reached the end of the current
										// group on the left.
										break
									} else if newLValNull && lNull {
										nullMatch = true
									} else {
										nullMatch = false
									}

									if !nullMatch {
										lSelIdx = curLIdx
										newLVal := lKeys.Get(lSelIdx)

										{
											var cmpResult int

											cmpResult = coldataext.CompareDatum(newLVal, lKeys, lVal)

											match = cmpResult == 0
										}

										if !match {
											break
										}
									}
									o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
									curLIdx++
								}
							} else {
								curRIdx++
							}
						}
					}
					if !o.groups.isLastGroupInCol() {
						// The current group is not the last one within the column, so it cannot be
						// extended into the next batch, and we need to process it right now. Any
						// unprocessed row in the left group will not get a match, so each one of
						// them becomes a new unmatched group with a corresponding null group.
						for curLIdx < curLEndIdx {
							o.groups.addLeftUnmatchedGroup(curLIdx, curRIdx)
							curLIdx++
						}
					}
					// Both o.proberState.lIdx and o.proberState.rIdx should point
					// to the last tuples that have been fully processed in their
					// respective batches. This is the case when we've just finished
					// the last equality column or the current column is such that
					// all tuples were filtered out.
					if lastEqCol || !o.groups.hasGroupForNextCol() {
						o.proberState.lIdx = curLIdx
						o.proberState.rIdx = curRIdx
					}
				}
			}
		default:
			colexecerror.InternalError(errors.AssertionFailedf("unhandled type %s", colType))
		}
		// Look at the groups associated with the next equality column by moving
		// the circular buffer pointer up.
		o.groups.finishedCol()
	}
}

// buildLeftGroupsFromBatch takes a []group and expands each group into the
// output by repeating each row in the group numRepeats times. For example,
// given an input table:
//
//	L1 |  L2
//	--------
//	1  |  a
//	1  |  b
//
// and leftGroups = [{startIdx: 0, endIdx: 2, numRepeats: 3}]
// then buildLeftGroupsFromBatch expands this to
//
//	L1 |  L2
//	--------
//	1  |  a
//	1  |  a
//	1  |  a
//	1  |  b
//	1  |  b
//	1  |  b
//
// Note: this is different from buildRightGroupsFromBatch in that each row of
// group is repeated numRepeats times, instead of a simple copy of the group as
// a whole.
// SIDE EFFECTS: writes into o.output.
func (o *mergeJoinExceptAllOp) buildLeftGroupsFromBatch(
	leftGroups []group, input *mergeJoinInput, batch coldata.Batch, destStartIdx int,
) {
	sel := batch.Selection()
	initialBuilderState := o.builderState.left
	o.unlimitedAllocator.PerformOperation(
		o.output.ColVecs()[:len(input.sourceTypes)],
		func() {
			// Loop over every column.
		LeftColLoop:
			for colIdx := range input.sourceTypes {
				lastSrcCol := colIdx == len(input.sourceTypes)-1
				outStartIdx := destStartIdx
				out := o.output.ColVec(colIdx)
				var src *coldata.Vec
				if batch.Length() > 0 {
					src = batch.ColVec(colIdx)
				}
				if sel != nil {
					var srcNulls *coldata.Nulls
					if src != nil {
						srcNulls = src.Nulls()
					}
					outNulls := out.Nulls()
					switch input.canonicalTypeFamilies[colIdx] {
					case types.BoolFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Bools
							if src != nil {
								srcCol = src.Bool()
							}
							outCol := out.Bool()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := sel[o.builderState.left.curSrcStartIdx]

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.BytesFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol *coldata.Bytes
							if src != nil {
								srcCol = src.Bytes()
							}
							outCol := out.Bytes()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := sel[o.builderState.left.curSrcStartIdx]

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											for i := 0; i < toAppend; i++ {
												outCol.Copy(srcCol, outStartIdx+i, srcStartIdx)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.DecimalFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Decimals
							if src != nil {
								srcCol = src.Decimal()
							}
							outCol := out.Decimal()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := sel[o.builderState.left.curSrcStartIdx]

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.IntFamily:
						switch input.sourceTypes[colIdx].Width() {
						case 16:
							var srcCol coldata.Int16s
							if src != nil {
								srcCol = src.Int16()
							}
							outCol := out.Int16()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := sel[o.builderState.left.curSrcStartIdx]

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						case 32:
							var srcCol coldata.Int32s
							if src != nil {
								srcCol = src.Int32()
							}
							outCol := out.Int32()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := sel[o.builderState.left.curSrcStartIdx]

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						case -1:
						default:
							var srcCol coldata.Int64s
							if src != nil {
								srcCol = src.Int64()
							}
							outCol := out.Int64()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := sel[o.builderState.left.curSrcStartIdx]

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.FloatFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Float64s
							if src != nil {
								srcCol = src.Float64()
							}
							outCol := out.Float64()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := sel[o.builderState.left.curSrcStartIdx]

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.TimestampTZFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Times
							if src != nil {
								srcCol = src.Timestamp()
							}
							outCol := out.Timestamp()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := sel[o.builderState.left.curSrcStartIdx]

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.IntervalFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Durations
							if src != nil {
								srcCol = src.Interval()
							}
							outCol := out.Interval()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := sel[o.builderState.left.curSrcStartIdx]

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.JsonFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol *coldata.JSONs
							if src != nil {
								srcCol = src.JSON()
							}
							outCol := out.JSON()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := sel[o.builderState.left.curSrcStartIdx]

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											for i := 0; i < toAppend; i++ {
												outCol.Copy(srcCol, outStartIdx+i, srcStartIdx)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case typeconv.DatumVecCanonicalTypeFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.DatumVec
							if src != nil {
								srcCol = src.Datum()
							}
							outCol := out.Datum()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := sel[o.builderState.left.curSrcStartIdx]

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												outCol.Set(outStartIdx+i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					default:
						colexecerror.InternalError(errors.AssertionFailedf("unhandled type %s", input.sourceTypes[colIdx].String()))
					}
				} else {
					var srcNulls *coldata.Nulls
					if src != nil {
						srcNulls = src.Nulls()
					}
					outNulls := out.Nulls()
					switch input.canonicalTypeFamilies[colIdx] {
					case types.BoolFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Bools
							if src != nil {
								srcCol = src.Bool()
							}
							outCol := out.Bool()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := o.builderState.left.curSrcStartIdx

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.BytesFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol *coldata.Bytes
							if src != nil {
								srcCol = src.Bytes()
							}
							outCol := out.Bytes()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := o.builderState.left.curSrcStartIdx

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											for i := 0; i < toAppend; i++ {
												outCol.Copy(srcCol, outStartIdx+i, srcStartIdx)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.DecimalFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Decimals
							if src != nil {
								srcCol = src.Decimal()
							}
							outCol := out.Decimal()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := o.builderState.left.curSrcStartIdx

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.IntFamily:
						switch input.sourceTypes[colIdx].Width() {
						case 16:
							var srcCol coldata.Int16s
							if src != nil {
								srcCol = src.Int16()
							}
							outCol := out.Int16()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := o.builderState.left.curSrcStartIdx

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						case 32:
							var srcCol coldata.Int32s
							if src != nil {
								srcCol = src.Int32()
							}
							outCol := out.Int32()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := o.builderState.left.curSrcStartIdx

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						case -1:
						default:
							var srcCol coldata.Int64s
							if src != nil {
								srcCol = src.Int64()
							}
							outCol := out.Int64()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := o.builderState.left.curSrcStartIdx

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.FloatFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Float64s
							if src != nil {
								srcCol = src.Float64()
							}
							outCol := out.Float64()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := o.builderState.left.curSrcStartIdx

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.TimestampTZFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Times
							if src != nil {
								srcCol = src.Timestamp()
							}
							outCol := out.Timestamp()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := o.builderState.left.curSrcStartIdx

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.IntervalFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Durations
							if src != nil {
								srcCol = src.Interval()
							}
							outCol := out.Interval()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := o.builderState.left.curSrcStartIdx

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.JsonFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol *coldata.JSONs
							if src != nil {
								srcCol = src.JSON()
							}
							outCol := out.JSON()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := o.builderState.left.curSrcStartIdx

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											for i := 0; i < toAppend; i++ {
												outCol.Copy(srcCol, outStartIdx+i, srcStartIdx)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					case typeconv.DatumVecCanonicalTypeFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.DatumVec
							if src != nil {
								srcCol = src.Datum()
							}
							outCol := out.Datum()

							// Loop over every group.
							for ; o.builderState.left.groupsIdx < len(leftGroups); o.builderState.left.groupsIdx++ {
								leftGroup := &leftGroups[o.builderState.left.groupsIdx]
								if !leftGroup.unmatched {
									continue
								}
								// If curSrcStartIdx is uninitialized, start it at the group's start idx.
								// Otherwise continue where we left off.
								if o.builderState.left.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
									o.builderState.left.curSrcStartIdx = leftGroup.rowStartIdx
								}
								// Loop over every row in the group.
								for ; o.builderState.left.curSrcStartIdx < leftGroup.rowEndIdx; o.builderState.left.curSrcStartIdx++ {
									// Repeat each row numRepeats times.
									srcStartIdx := o.builderState.left.curSrcStartIdx

									repeatsLeft := leftGroup.numRepeats - o.builderState.left.numRepeatsIdx
									toAppend := repeatsLeft
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
										if toAppend == 0 {
											if lastSrcCol {
												return
											}
											o.builderState.left.setBuilderColumnState(initialBuilderState)
											continue LeftColLoop
										}
									}

									{
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												outCol.Set(outStartIdx+i, val)
											}
										}
									}
									outStartIdx += toAppend

									if toAppend < repeatsLeft {
										// We didn't materialize all the rows in the group so save state and
										// move to the next column.
										o.builderState.left.numRepeatsIdx += toAppend
										if lastSrcCol {
											return
										}
										o.builderState.left.setBuilderColumnState(initialBuilderState)
										continue LeftColLoop
									}

									o.builderState.left.numRepeatsIdx = zeroMJCPNumRepeatsIdx
								}
								o.builderState.left.curSrcStartIdx = zeroMJCPCurSrcStartIdx
							}
							o.builderState.left.groupsIdx = zeroMJCPGroupsIdx
						}
					default:
						colexecerror.InternalError(errors.AssertionFailedf("unhandled type %s", input.sourceTypes[colIdx].String()))
					}
				}
				o.builderState.left.setBuilderColumnState(initialBuilderState)
			}
			o.builderState.left.reset()
		},
	)
}

// buildRightGroupsFromBatch takes a []group and repeats each group numRepeats
// times. For example, given an input table:
//
//	R1 |  R2
//	--------
//	1  |  a
//	1  |  b
//
// and rightGroups = [{startIdx: 0, endIdx: 2, numRepeats: 3}]
// then buildRightGroups expands this to
//
//	R1 |  R2
//	--------
//	1  |  a
//	1  |  b
//	1  |  a
//	1  |  b
//	1  |  a
//	1  |  b
//
// Note: this is different from buildLeftGroupsFromBatch in that each group is
// not expanded but directly copied numRepeats times.
// SIDE EFFECTS: writes into o.output.
func (o *mergeJoinExceptAllOp) buildRightGroupsFromBatch(
	rightGroups []group, colOffset int, input *mergeJoinInput, batch coldata.Batch, destStartIdx int,
) {
	initialBuilderState := o.builderState.right
	sel := batch.Selection()
	o.unlimitedAllocator.PerformOperation(
		o.output.ColVecs()[colOffset:colOffset+len(input.sourceTypes)],
		func() {
			// Loop over every column.
		RightColLoop:
			for colIdx := range input.sourceTypes {
				lastSrcCol := colIdx == len(input.sourceTypes)-1
				outStartIdx := destStartIdx
				out := o.output.ColVec(colIdx + colOffset)
				var src *coldata.Vec
				if batch.Length() > 0 {
					src = batch.ColVec(colIdx)
				}
				if sel != nil {
					var srcNulls *coldata.Nulls
					if src != nil {
						srcNulls = src.Nulls()
					}
					outNulls := out.Nulls()
					switch input.canonicalTypeFamilies[colIdx] {
					case types.BoolFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Bools
							if src != nil {
								srcCol = src.Bool()
							}
							outCol := out.Bool()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := sel[o.builderState.right.curSrcStartIdx]
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.BytesFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol *coldata.Bytes
							if src != nil {
								srcCol = src.Bytes()
							}
							outCol := out.Bytes()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := sel[o.builderState.right.curSrcStartIdx]
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												outCol.Copy(srcCol, outStartIdx, srcIdx)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.DecimalFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Decimals
							if src != nil {
								srcCol = src.Decimal()
							}
							outCol := out.Decimal()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := sel[o.builderState.right.curSrcStartIdx]
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.IntFamily:
						switch input.sourceTypes[colIdx].Width() {
						case 16:
							var srcCol coldata.Int16s
							if src != nil {
								srcCol = src.Int16()
							}
							outCol := out.Int16()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := sel[o.builderState.right.curSrcStartIdx]
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						case 32:
							var srcCol coldata.Int32s
							if src != nil {
								srcCol = src.Int32()
							}
							outCol := out.Int32()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := sel[o.builderState.right.curSrcStartIdx]
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						case -1:
						default:
							var srcCol coldata.Int64s
							if src != nil {
								srcCol = src.Int64()
							}
							outCol := out.Int64()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := sel[o.builderState.right.curSrcStartIdx]
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.FloatFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Float64s
							if src != nil {
								srcCol = src.Float64()
							}
							outCol := out.Float64()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := sel[o.builderState.right.curSrcStartIdx]
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.TimestampTZFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Times
							if src != nil {
								srcCol = src.Timestamp()
							}
							outCol := out.Timestamp()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := sel[o.builderState.right.curSrcStartIdx]
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.IntervalFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Durations
							if src != nil {
								srcCol = src.Interval()
							}
							outCol := out.Interval()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := sel[o.builderState.right.curSrcStartIdx]
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.JsonFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol *coldata.JSONs
							if src != nil {
								srcCol = src.JSON()
							}
							outCol := out.JSON()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := sel[o.builderState.right.curSrcStartIdx]
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												outCol.Copy(srcCol, outStartIdx, srcIdx)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case typeconv.DatumVecCanonicalTypeFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.DatumVec
							if src != nil {
								srcCol = src.Datum()
							}
							outCol := out.Datum()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := sel[o.builderState.right.curSrcStartIdx]
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					default:
						colexecerror.InternalError(errors.AssertionFailedf("unhandled type %s", input.sourceTypes[colIdx].String()))
					}
				} else {
					var srcNulls *coldata.Nulls
					if src != nil {
						srcNulls = src.Nulls()
					}
					outNulls := out.Nulls()
					switch input.canonicalTypeFamilies[colIdx] {
					case types.BoolFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Bools
							if src != nil {
								srcCol = src.Bool()
							}
							outCol := out.Bool()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := o.builderState.right.curSrcStartIdx
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.BytesFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol *coldata.Bytes
							if src != nil {
								srcCol = src.Bytes()
							}
							outCol := out.Bytes()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := o.builderState.right.curSrcStartIdx
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												outCol.Copy(srcCol, outStartIdx, srcIdx)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.DecimalFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Decimals
							if src != nil {
								srcCol = src.Decimal()
							}
							outCol := out.Decimal()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := o.builderState.right.curSrcStartIdx
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.IntFamily:
						switch input.sourceTypes[colIdx].Width() {
						case 16:
							var srcCol coldata.Int16s
							if src != nil {
								srcCol = src.Int16()
							}
							outCol := out.Int16()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := o.builderState.right.curSrcStartIdx
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						case 32:
							var srcCol coldata.Int32s
							if src != nil {
								srcCol = src.Int32()
							}
							outCol := out.Int32()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := o.builderState.right.curSrcStartIdx
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						case -1:
						default:
							var srcCol coldata.Int64s
							if src != nil {
								srcCol = src.Int64()
							}
							outCol := out.Int64()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := o.builderState.right.curSrcStartIdx
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.FloatFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Float64s
							if src != nil {
								srcCol = src.Float64()
							}
							outCol := out.Float64()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := o.builderState.right.curSrcStartIdx
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.TimestampTZFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Times
							if src != nil {
								srcCol = src.Timestamp()
							}
							outCol := out.Timestamp()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := o.builderState.right.curSrcStartIdx
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.IntervalFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.Durations
							if src != nil {
								srcCol = src.Interval()
							}
							outCol := out.Interval()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := o.builderState.right.curSrcStartIdx
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case types.JsonFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol *coldata.JSONs
							if src != nil {
								srcCol = src.JSON()
							}
							outCol := out.JSON()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := o.builderState.right.curSrcStartIdx
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												outCol.Copy(srcCol, outStartIdx, srcIdx)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					case typeconv.DatumVecCanonicalTypeFamily:
						switch input.sourceTypes[colIdx].Width() {
						case -1:
						default:
							var srcCol coldata.DatumVec
							if src != nil {
								srcCol = src.Datum()
							}
							outCol := out.Datum()

							// Loop over every group.
							for ; o.builderState.right.groupsIdx < len(rightGroups); o.builderState.right.groupsIdx++ {
								rightGroup := &rightGroups[o.builderState.right.groupsIdx]
								// Repeat every group numRepeats times.
								for ; o.builderState.right.numRepeatsIdx < rightGroup.numRepeats; o.builderState.right.numRepeatsIdx++ {
									if o.builderState.right.curSrcStartIdx == zeroMJCPCurSrcStartIdx {
										o.builderState.right.curSrcStartIdx = rightGroup.rowStartIdx
									}
									toAppend := rightGroup.rowEndIdx - o.builderState.right.curSrcStartIdx
									if outStartIdx+toAppend > o.outputCapacity {
										toAppend = o.outputCapacity - outStartIdx
									}

									{
										// Optimization in the case that group length is 1, use assign
										// instead of copy.
										if toAppend == 1 {
											srcIdx := o.builderState.right.curSrcStartIdx
											if srcNulls.NullAt(srcIdx) {
												outNulls.SetNull(outStartIdx)
											} else {
												v := srcCol.Get(srcIdx)
												outCol.Set(outStartIdx, v)
											}
										} else {
											out.Copy(
												coldata.SliceArgs{
													Src:         src,
													Sel:         sel,
													DestIdx:     outStartIdx,
													SrcStartIdx: o.builderState.right.curSrcStartIdx,
													SrcEndIdx:   o.builderState.right.curSrcStartIdx + toAppend,
												},
											)
										}
									}

									outStartIdx += toAppend

									// If we haven't materialized all the rows from the group, then we are
									// done with the current column.
									if toAppend < rightGroup.rowEndIdx-o.builderState.right.curSrcStartIdx {
										// If it's the last column, save state and return.
										if lastSrcCol {
											o.builderState.right.curSrcStartIdx += toAppend
											return
										}
										// Otherwise, reset to the initial state and begin the next column.
										o.builderState.right.setBuilderColumnState(initialBuilderState)
										continue RightColLoop
									}
									o.builderState.right.curSrcStartIdx = zeroMJCPCurSrcStartIdx
								}
								o.builderState.right.numRepeatsIdx = zeroMJCPNumRepeatsIdx
							}
							o.builderState.right.groupsIdx = zeroMJCPGroupsIdx
						}
					default:
						colexecerror.InternalError(errors.AssertionFailedf("unhandled type %s", input.sourceTypes[colIdx].String()))
					}
				}
				o.builderState.right.setBuilderColumnState(initialBuilderState)
			}
			o.builderState.right.reset()
		})
}

// probe is where we generate the groups slices that are used in the build
// phase. We do this by first assuming that every row in both batches
// contributes to the cross product. Then, with every equality column, we
// filter out the rows that don't contribute to the cross product (i.e. they
// don't have a matching row on the other side in the case of an inner join),
// and set the correct cardinality.
// Note that in this phase, we do this for every group, except the last group
// in the batch.
func (o *mergeJoinExceptAllOp) probe() {
	o.groups.reset(o.proberState.lIdx, o.proberState.lLength, o.proberState.rIdx, o.proberState.rLength)
	lSel := o.proberState.lBatch.Selection()
	rSel := o.proberState.rBatch.Selection()
	if lSel != nil {
		if rSel != nil {
			o.probeBodyLSeltrueRSeltrue()
		} else {
			o.probeBodyLSeltrueRSelfalse()
		}
	} else {
		if rSel != nil {
			o.probeBodyLSelfalseRSeltrue()
		} else {
			o.probeBodyLSelfalseRSelfalse()
		}
	}
}

// exhaustLeftSource sets up the builder to process any remaining tuples from
// the left source. It should only be called when the right source has been
// exhausted.
func (o *mergeJoinExceptAllOp) exhaustLeftSource() {
	// The capacity of builder state lGroups and rGroups is always at least 1
	// given the init.
	o.builderState.lGroups = o.builderState.lGroups[:1]
	o.builderState.lGroups[0] = group{
		rowStartIdx: o.proberState.lIdx,
		rowEndIdx:   o.proberState.lLength,
		numRepeats:  1,
		toBuild:     o.proberState.lLength - o.proberState.lIdx,
		unmatched:   true,
	}

	o.proberState.lIdx = o.proberState.lLength
}

// exhaustRightSource sets up the builder to process any remaining tuples from
// the right source. It should only be called when the left source has been
// exhausted.
func (o *mergeJoinExceptAllOp) exhaustRightSource() {
	// Remaining tuples from the right source do not have a match, so they are
	// ignored in all joins except for RIGHT OUTER and FULL OUTER.
}

// numBuiltFromBatch uses the toBuild field of each group and the output
// capacity to determine the output count. Note that as soon as a group is
// materialized partially or fully to output, its toBuild field is updated
// accordingly. The number of tuples that will be built from batch during the
// current iteration is returned.
func (o *mergeJoinExceptAllOp) numBuiltFromBatch(groups []group) (numBuilt int) {
	outCount := o.builderState.outCount
	for i := 0; i < len(groups); i++ {
		if !groups[i].unmatched {
			// "Matched" groups are not outputted in LEFT ANTI, RIGHT ANTI,
			// and EXCEPT ALL joins (for the latter IsLeftAnti == true), so
			// they do not contribute to the output count.
			continue
		}
		outCount += groups[i].toBuild
		groups[i].toBuild = 0
		if outCount > o.outputCapacity {
			groups[i].toBuild = outCount - o.outputCapacity
			return o.outputCapacity - o.builderState.outCount
		}
	}
	return outCount - o.builderState.outCount
}

// buildFromBatch builds as many output rows as possible from the groups that
// were complete in the probing batches. New rows are put starting at
// o.builderState.outCount position until either the capacity is reached or all
// groups are processed.
func (o *mergeJoinExceptAllOp) buildFromBatch() {
	outStartIdx := o.builderState.outCount
	numBuilt := o.numBuiltFromBatch(o.builderState.lGroups)
	o.builderState.outCount += numBuilt
	if numBuilt > 0 && len(o.outputTypes) != 0 {
		// We will be actually building the output if we have columns in the output
		// batch (meaning that we're not doing query like 'SELECT count(*) ...')
		// and when builderState.outCount has increased (meaning that we have
		// something to build).
		colOffsetForRightGroups := 0
		o.buildLeftGroupsFromBatch(o.builderState.lGroups, &o.left, o.proberState.lBatch, outStartIdx)
		colOffsetForRightGroups = len(o.left.sourceTypes)
		_ = colOffsetForRightGroups
	}
}

// transitionIntoBuildingFromBufferedGroup should be called once we have
// non-empty right buffered group in order to setup the buffered group builder.
//
// It will complete the right buffered group (meaning it'll read all batches
// from the right input until either the new group is found or the input is
// exhausted).
//
// For a more detailed explanation and an example please refer to the comment at
// the top of mergejoiner.go.
func (o *mergeJoinExceptAllOp) transitionIntoBuildingFromBufferedGroup() {
	if o.proberState.rIdx == o.proberState.rLength {
		// The right buffered group might extend into the next batch, so we have
		// to complete it first.
		o.completeRightBufferedGroup()
	}

	o.bufferedGroup.helper.setupLeftBuilder()

	// For EXCEPT ALL joins we build # left tuples - # right tuples output rows
	// (if positive), so we have to discard first numRightTuples rows from the
	// left.
	numSkippedLeft := 0
	for {
		groupLength := o.proberState.lIdx - o.bufferedGroup.leftGroupStartIdx
		if numSkippedLeft+groupLength > o.bufferedGroup.helper.numRightTuples {
			// The current left batch is the first one that contains tuples
			// without a "match".
			break
		}
		numSkippedLeft += groupLength
		var groupFinished bool
		if o.proberState.lIdx < o.proberState.lLength {
			// The group on the left is finished within the current left
			// batch.
			groupFinished = true
		} else {
			// Fetch the next batch from the left input and calculate the
			// boundaries of the buffered group.
			o.continueLeftBufferedGroup()
			groupFinished = o.proberState.lIdx == 0
		}
		if groupFinished {
			// We have less matching tuples on the left than on the right, so we
			// don't emit any output for this buffered group.
			o.bufferedGroup.helper.Reset(o.Ctx)
			o.state = mjEntry
			return
		}
	}
	// We might need to skip some tuples in the current left batch since they
	// still had matches with the right side.
	toSkipInThisBatch := o.bufferedGroup.helper.numRightTuples - numSkippedLeft
	startIdx := o.bufferedGroup.leftGroupStartIdx + toSkipInThisBatch

	o.bufferedGroup.helper.prepareForNextLeftBatch(o.proberState.lBatch, startIdx, o.proberState.lIdx)
	o.state = mjBuildFromBufferedGroup
}

// buildFromBufferedGroup builds the output based on the current buffered group
// and puts new tuples starting at position b.builderState.outCount. It returns
// true once the output for the buffered group has been fully populated.
//
// It is assumed that transitionIntoBuildingFromBufferedGroup has been called.
//
// For a more detailed explanation and an example please refer to the comment at
// the top of mergejoiner.go.
func (o *mergeJoinExceptAllOp) buildFromBufferedGroup() (bufferedGroupComplete bool) {
	bg := &o.bufferedGroup
	// Iterate until either we use up the whole capacity of the output batch or
	// we complete the buffered group.
	for {
		if bg.helper.builderState.left.curSrcStartIdx == o.proberState.lLength {
			// The output has been fully built from the current left batch.
			bg.leftBatchDone = true
		}
		if bg.leftBatchDone {
			// The current left batch has been fully processed with regards to
			// the buffered group.
			bg.leftBatchDone = false
			if o.proberState.lIdx < o.proberState.lLength {
				// The group on the left is finished within the current left
				// batch.
				return true
			}
			var skipLeftBufferedGroup bool
			if skipLeftBufferedGroup {
				// Keep fetching the next batch from the left input until we
				// either find the start of the new group or we exhaust the
				// input.
				for o.proberState.lIdx == o.proberState.lLength && o.proberState.lLength > 0 {
					o.continueLeftBufferedGroup()
				}
				return true
			}
			// Fetch the next batch from the left input and calculate the
			// boundaries of the buffered group.
			o.continueLeftBufferedGroup()
			if o.proberState.lIdx == 0 {
				return true
			}
			bg.helper.prepareForNextLeftBatch(
				o.proberState.lBatch, bg.leftGroupStartIdx, o.proberState.lIdx,
			)
		}

		willEmit := bg.helper.canEmit()
		if o.builderState.outCount+willEmit > o.outputCapacity {
			willEmit = o.outputCapacity - o.builderState.outCount
		} else {
			bg.leftBatchDone = true
		}
		if willEmit > 0 && len(o.outputTypes) != 0 {
			bg.helper.buildFromLeftInput(o.Ctx, o.builderState.outCount)
		}
		o.builderState.outCount += willEmit
		if o.builderState.outCount == o.outputCapacity {
			return false
		}
	}
}

func (o *mergeJoinExceptAllOp) Next() coldata.Batch {
	o.output, _ = o.helper.ResetMaybeReallocate(o.outputTypes, o.output, 0 /* tuplesToBeSet */)
	o.outputCapacity = o.output.Capacity()
	o.bufferedGroup.helper.output = o.output
	o.builderState.outCount = 0
	for {
		switch o.state {
		case mjEntry:
			// If this is the first batch or we're done with the current batch,
			// get the next batch.
			if o.proberState.lBatch == nil || (o.proberState.lLength != 0 && o.proberState.lIdx == o.proberState.lLength) {
				o.cancelChecker.CheckEveryCall()
				o.proberState.lIdx, o.proberState.lBatch = 0, o.InputOne.Next()
				o.proberState.lLength = o.proberState.lBatch.Length()
			}
			if o.proberState.rBatch == nil || (o.proberState.rLength != 0 && o.proberState.rIdx == o.proberState.rLength) {
				o.cancelChecker.CheckEveryCall()
				o.proberState.rIdx, o.proberState.rBatch = 0, o.InputTwo.Next()
				o.proberState.rLength = o.proberState.rBatch.Length()
			}
			if o.sourceFinished() {
				o.state = mjSourceFinished
				break
			}
			o.state = mjProbe

		case mjSourceFinished:
			o.builderState.lGroups = o.builderState.lGroups[:0]
			o.builderState.rGroups = o.builderState.rGroups[:0]
			// At least one of the sources is finished. If it was the right one,
			// then we need to emit remaining tuples from the left source with
			// nulls corresponding to the right one. But if the left source is
			// finished, then there is nothing left to do.
			if o.proberState.lIdx < o.proberState.lLength {
				o.exhaustLeftSource()
			}
			if len(o.builderState.lGroups) == 0 && len(o.builderState.rGroups) == 0 {
				o.state = mjDone
				o.output.SetLength(o.builderState.outCount)
				return o.output
			}
			o.state = mjBuildFromBatch

		case mjProbe:
			o.probe()
			o.builderState.lGroups, o.builderState.rGroups = o.groups.getGroups()
			if len(o.builderState.lGroups) > 0 || len(o.builderState.rGroups) > 0 {
				o.state = mjBuildFromBatch
			} else if o.bufferedGroup.helper.numRightTuples != 0 {
				o.transitionIntoBuildingFromBufferedGroup()
			} else {
				o.state = mjEntry
			}

		case mjBuildFromBatch:
			o.buildFromBatch()
			if o.builderState.outCount == o.outputCapacity {
				o.output.SetLength(o.builderState.outCount)
				return o.output
			}
			if o.bufferedGroup.helper.numRightTuples != 0 {
				o.transitionIntoBuildingFromBufferedGroup()
			} else {
				o.state = mjEntry
			}

		case mjBuildFromBufferedGroup:
			bufferedGroupComplete := o.buildFromBufferedGroup()
			if bufferedGroupComplete {
				o.bufferedGroup.helper.Reset(o.Ctx)
				o.state = mjEntry
			}
			if o.builderState.outCount == o.outputCapacity {
				o.output.SetLength(o.builderState.outCount)
				return o.output
			}

		case mjDone:
			return coldata.ZeroBatch

		default:
			colexecerror.InternalError(errors.AssertionFailedf("unexpected merge joiner state in Next: %v", o.state))
		}
	}
}
