// Code generated by execgen; DO NOT EDIT.
// Copyright 2020 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecjoin

import (
	"context"

	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ = typeconv.DatumVecCanonicalTypeFamily
	_ = types.BoolFamily
)

// buildFromLeftBatch is the body of buildFromLeftInput that templates out the
// fact whether the current left batch has a selection vector or not.
// execgen:inline
const _ = "template_buildFromLeftBatch"

// buildFromLeftInput builds part of the output of a cross join that comes from
// the vectors of the left input. The new output tuples are put starting at
// index destStartIdx and will not exceed the capacity of the output batch. It
// is assumed that setupLeftBuilder and prepareForNextLeftBatch have been
// called.
//
// The goal of this method is to repeat each tuple from the left input
// leftNumRepeats times. Only the tuples in [curSrcStartIdx, leftSrcEndIdx) are
// used from the current left batch.
func (b *crossJoinerBase) buildFromLeftInput(ctx context.Context, destStartIdx int) {
	currentBatch := b.builderState.left.currentBatch
	b.left.unlimitedAllocator.PerformOperation(
		b.output.ColVecs()[:len(b.left.types)],
		func() {
			if sel := currentBatch.Selection(); sel != nil {
				{
					// We'll be modifying the builder state as we go, but we'll need to be able
					// to restore the state to initial for each column.
					initialBuilderState := b.builderState.left
					bs := &b.builderState.left
					leftNumRepeats := b.builderState.setup.leftNumRepeats
					leftSrcEndIdx := b.builderState.setup.leftSrcEndIdx
					outputCapacity := b.output.Capacity()
					var srcStartIdx int
					// Loop over every column.
					for colIdx := range b.left.types {
						if colIdx > 0 {
							// Restore the builder state so that this new column started off
							// fresh.
							*bs = initialBuilderState
						}
						outStartIdx := destStartIdx
						src := currentBatch.ColVec(colIdx)
						srcNulls := src.Nulls()
						out := b.output.ColVec(colIdx)
						outNulls := out.Nulls()
						switch b.left.canonicalTypeFamilies[colIdx] {
						case types.BoolFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Bool()
								outCol := out.Bool()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case types.BytesFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Bytes()
								outCol := out.Bytes()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											outCol.Copy(srcCol, outStartIdx, srcStartIdx)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											for i := 0; i < toAppend; i++ {
												outCol.Copy(srcCol, outStartIdx+i, srcStartIdx)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case types.DecimalFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Decimal()
								outCol := out.Decimal()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case types.IntFamily:
							switch b.left.types[colIdx].Width() {
							case 16:
								srcCol := src.Int16()
								outCol := out.Int16()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							case 32:
								srcCol := src.Int32()
								outCol := out.Int32()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							case -1:
							default:
								srcCol := src.Int64()
								outCol := out.Int64()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case types.FloatFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Float64()
								outCol := out.Float64()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case types.TimestampTZFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Timestamp()
								outCol := out.Timestamp()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case types.IntervalFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Interval()
								outCol := out.Interval()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case types.JsonFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.JSON()
								outCol := out.JSON()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											outCol.Copy(srcCol, outStartIdx, srcStartIdx)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											for i := 0; i < toAppend; i++ {
												outCol.Copy(srcCol, outStartIdx+i, srcStartIdx)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case typeconv.DatumVecCanonicalTypeFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Datum()
								outCol := out.Datum()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = sel[bs.curSrcStartIdx]
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												outCol.Set(outStartIdx+i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						default:
							colexecerror.InternalError(errors.AssertionFailedf("unhandled type %s", b.left.types[colIdx].String()))
						}
					}
					// If there are no columns projected from the left input, simply advance the
					// cross-joiner state according to the number of input rows.
					if len(b.left.types) == 0 {
						outStartIdx := destStartIdx
						for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
							// Repeat each row leftNumRepeats times.
							toAppend := leftNumRepeats - bs.numRepeatsIdx
							if outStartIdx+toAppend > outputCapacity {
								// We don't have enough space to repeat the current
								// value the required number of times, so we'll have
								// to continue from here on the next call.
								toAppend = outputCapacity - outStartIdx
								bs.numRepeatsIdx += toAppend
							} else {
								// We fully processed the current tuple for the
								// current column, and before moving on to the next
								// one, we need to reset numRepeatsIdx (so that the
								// next tuple would be repeated leftNumRepeats
								// times).
								bs.curSrcStartIdx++
								bs.numRepeatsIdx = 0
							}
							outStartIdx += toAppend
						}
					}
				}
			} else {
				{
					var sel []int = nil
					// Remove the unused warning.
					_ = sel
					// We'll be modifying the builder state as we go, but we'll need to be able
					// to restore the state to initial for each column.
					initialBuilderState := b.builderState.left
					bs := &b.builderState.left
					leftNumRepeats := b.builderState.setup.leftNumRepeats
					leftSrcEndIdx := b.builderState.setup.leftSrcEndIdx
					outputCapacity := b.output.Capacity()
					var srcStartIdx int
					// Loop over every column.
					for colIdx := range b.left.types {
						if colIdx > 0 {
							// Restore the builder state so that this new column started off
							// fresh.
							*bs = initialBuilderState
						}
						outStartIdx := destStartIdx
						src := currentBatch.ColVec(colIdx)
						srcNulls := src.Nulls()
						out := b.output.ColVec(colIdx)
						outNulls := out.Nulls()
						switch b.left.canonicalTypeFamilies[colIdx] {
						case types.BoolFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Bool()
								outCol := out.Bool()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case types.BytesFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Bytes()
								outCol := out.Bytes()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											outCol.Copy(srcCol, outStartIdx, srcStartIdx)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											for i := 0; i < toAppend; i++ {
												outCol.Copy(srcCol, outStartIdx+i, srcStartIdx)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case types.DecimalFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Decimal()
								outCol := out.Decimal()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case types.IntFamily:
							switch b.left.types[colIdx].Width() {
							case 16:
								srcCol := src.Int16()
								outCol := out.Int16()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							case 32:
								srcCol := src.Int32()
								outCol := out.Int32()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							case -1:
							default:
								srcCol := src.Int64()
								outCol := out.Int64()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case types.FloatFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Float64()
								outCol := out.Float64()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case types.TimestampTZFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Timestamp()
								outCol := out.Timestamp()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case types.IntervalFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Interval()
								outCol := out.Interval()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											outCol := outCol[outStartIdx:]
											_ = outCol[toAppend-1]
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												//gcassert:bce
												outCol.Set(i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case types.JsonFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.JSON()
								outCol := out.JSON()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											outCol.Copy(srcCol, outStartIdx, srcStartIdx)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											for i := 0; i < toAppend; i++ {
												outCol.Copy(srcCol, outStartIdx+i, srcStartIdx)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						case typeconv.DatumVecCanonicalTypeFamily:
							switch b.left.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Datum()
								outCol := out.Datum()
								if leftNumRepeats == 1 {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each tuple one time.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNull(outStartIdx)
										} else {
											val := srcCol.Get(srcStartIdx)
											outCol.Set(outStartIdx, val)
										}
										outStartIdx++
										bs.curSrcStartIdx++
									}
								} else {
									// Loop over every tuple in the current batch.
									for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
										// Repeat each row leftNumRepeats times.
										_ = true
										srcStartIdx = bs.curSrcStartIdx
										toAppend := leftNumRepeats - bs.numRepeatsIdx
										if outStartIdx+toAppend > outputCapacity {
											// We don't have enough space to repeat the current
											// value the required number of times, so we'll have
											// to continue from here on the next call.
											toAppend = outputCapacity - outStartIdx
											bs.numRepeatsIdx += toAppend
										} else {
											// We fully processed the current tuple for the
											// current column, and before moving on to the next
											// one, we need to reset numRepeatsIdx (so that the
											// next tuple would be repeated leftNumRepeats
											// times).
											bs.curSrcStartIdx++
											bs.numRepeatsIdx = 0
										}
										if srcNulls.NullAt(srcStartIdx) {
											outNulls.SetNullRange(outStartIdx, outStartIdx+toAppend)
										} else {
											val := srcCol.Get(srcStartIdx)
											for i := 0; i < toAppend; i++ {
												outCol.Set(outStartIdx+i, val)
											}
										}
										outStartIdx += toAppend
									}
								}
							}
						default:
							colexecerror.InternalError(errors.AssertionFailedf("unhandled type %s", b.left.types[colIdx].String()))
						}
					}
					// If there are no columns projected from the left input, simply advance the
					// cross-joiner state according to the number of input rows.
					if len(b.left.types) == 0 {
						outStartIdx := destStartIdx
						for bs.curSrcStartIdx < leftSrcEndIdx && outStartIdx < outputCapacity {
							// Repeat each row leftNumRepeats times.
							toAppend := leftNumRepeats - bs.numRepeatsIdx
							if outStartIdx+toAppend > outputCapacity {
								// We don't have enough space to repeat the current
								// value the required number of times, so we'll have
								// to continue from here on the next call.
								toAppend = outputCapacity - outStartIdx
								bs.numRepeatsIdx += toAppend
							} else {
								// We fully processed the current tuple for the
								// current column, and before moving on to the next
								// one, we need to reset numRepeatsIdx (so that the
								// next tuple would be repeated leftNumRepeats
								// times).
								bs.curSrcStartIdx++
								bs.numRepeatsIdx = 0
							}
							outStartIdx += toAppend
						}
					}
				}
			}
		},
	)
}

// buildFromRightInput builds part of the output of a cross join that comes from
// the vectors of the right input. The new output tuples are put starting at
// index destStartIdx and will not exceed the capacity of the output batch. It
// is assumed that the right input has been fully consumed and is stored in
// b.rightTuples spilling queue.
//
// The goal of this method is to repeat all tuples from the right input
// rightNumRepeats times (i.e. repeating the whole list of tuples at once).
func (b *crossJoinerBase) buildFromRightInput(ctx context.Context, destStartIdx int) {
	var err error
	bs := &b.builderState.right
	rightNumRepeats := b.builderState.setup.rightNumRepeats
	b.right.unlimitedAllocator.PerformOperation(
		b.output.ColVecs()[b.builderState.rightColOffset:],
		func() {
			outStartIdx := destStartIdx
			outputCapacity := b.output.Capacity()
			// Repeat the buffered tuples rightNumRepeats times until we fill
			// the output capacity.
			for ; outStartIdx < outputCapacity && bs.numRepeatsIdx < rightNumRepeats; bs.numRepeatsIdx++ {
				currentBatch := bs.currentBatch
				if currentBatch == nil {
					currentBatch, err = b.rightTuples.Dequeue(ctx)
					if err != nil {
						colexecerror.InternalError(err)
					}
					bs.currentBatch = currentBatch
					bs.curSrcStartIdx = 0
				}
				batchLength := currentBatch.Length()
				for batchLength > 0 {
					toAppend := batchLength - bs.curSrcStartIdx
					if outStartIdx+toAppend > outputCapacity {
						toAppend = outputCapacity - outStartIdx
					}

					// Loop over every column.
					for colIdx := range b.right.types {
						src := currentBatch.ColVec(colIdx)
						srcNulls := src.Nulls()
						out := b.output.ColVec(colIdx + b.builderState.rightColOffset)
						outNulls := out.Nulls()
						switch b.right.canonicalTypeFamilies[colIdx] {
						case types.BoolFamily:
							switch b.right.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Bool()
								outCol := out.Bool()

								// Optimization in the case that group length is 1, use assign
								// instead of copy.
								if toAppend == 1 {
									if srcNulls.NullAt(bs.curSrcStartIdx) {
										outNulls.SetNull(outStartIdx)
									} else {
										v := srcCol.Get(bs.curSrcStartIdx)
										outCol.Set(outStartIdx, v)
									}
								} else {
									out.Copy(
										coldata.SliceArgs{
											Src:         src,
											DestIdx:     outStartIdx,
											SrcStartIdx: bs.curSrcStartIdx,
											SrcEndIdx:   bs.curSrcStartIdx + toAppend,
										},
									)
								}
							}
						case types.BytesFamily:
							switch b.right.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Bytes()
								outCol := out.Bytes()

								// Optimization in the case that group length is 1, use assign
								// instead of copy.
								if toAppend == 1 {
									if srcNulls.NullAt(bs.curSrcStartIdx) {
										outNulls.SetNull(outStartIdx)
									} else {
										outCol.Copy(srcCol, outStartIdx, bs.curSrcStartIdx)
									}
								} else {
									out.Copy(
										coldata.SliceArgs{
											Src:         src,
											DestIdx:     outStartIdx,
											SrcStartIdx: bs.curSrcStartIdx,
											SrcEndIdx:   bs.curSrcStartIdx + toAppend,
										},
									)
								}
							}
						case types.DecimalFamily:
							switch b.right.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Decimal()
								outCol := out.Decimal()

								// Optimization in the case that group length is 1, use assign
								// instead of copy.
								if toAppend == 1 {
									if srcNulls.NullAt(bs.curSrcStartIdx) {
										outNulls.SetNull(outStartIdx)
									} else {
										v := srcCol.Get(bs.curSrcStartIdx)
										outCol.Set(outStartIdx, v)
									}
								} else {
									out.Copy(
										coldata.SliceArgs{
											Src:         src,
											DestIdx:     outStartIdx,
											SrcStartIdx: bs.curSrcStartIdx,
											SrcEndIdx:   bs.curSrcStartIdx + toAppend,
										},
									)
								}
							}
						case types.IntFamily:
							switch b.right.types[colIdx].Width() {
							case 16:
								srcCol := src.Int16()
								outCol := out.Int16()

								// Optimization in the case that group length is 1, use assign
								// instead of copy.
								if toAppend == 1 {
									if srcNulls.NullAt(bs.curSrcStartIdx) {
										outNulls.SetNull(outStartIdx)
									} else {
										v := srcCol.Get(bs.curSrcStartIdx)
										outCol.Set(outStartIdx, v)
									}
								} else {
									out.Copy(
										coldata.SliceArgs{
											Src:         src,
											DestIdx:     outStartIdx,
											SrcStartIdx: bs.curSrcStartIdx,
											SrcEndIdx:   bs.curSrcStartIdx + toAppend,
										},
									)
								}
							case 32:
								srcCol := src.Int32()
								outCol := out.Int32()

								// Optimization in the case that group length is 1, use assign
								// instead of copy.
								if toAppend == 1 {
									if srcNulls.NullAt(bs.curSrcStartIdx) {
										outNulls.SetNull(outStartIdx)
									} else {
										v := srcCol.Get(bs.curSrcStartIdx)
										outCol.Set(outStartIdx, v)
									}
								} else {
									out.Copy(
										coldata.SliceArgs{
											Src:         src,
											DestIdx:     outStartIdx,
											SrcStartIdx: bs.curSrcStartIdx,
											SrcEndIdx:   bs.curSrcStartIdx + toAppend,
										},
									)
								}
							case -1:
							default:
								srcCol := src.Int64()
								outCol := out.Int64()

								// Optimization in the case that group length is 1, use assign
								// instead of copy.
								if toAppend == 1 {
									if srcNulls.NullAt(bs.curSrcStartIdx) {
										outNulls.SetNull(outStartIdx)
									} else {
										v := srcCol.Get(bs.curSrcStartIdx)
										outCol.Set(outStartIdx, v)
									}
								} else {
									out.Copy(
										coldata.SliceArgs{
											Src:         src,
											DestIdx:     outStartIdx,
											SrcStartIdx: bs.curSrcStartIdx,
											SrcEndIdx:   bs.curSrcStartIdx + toAppend,
										},
									)
								}
							}
						case types.FloatFamily:
							switch b.right.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Float64()
								outCol := out.Float64()

								// Optimization in the case that group length is 1, use assign
								// instead of copy.
								if toAppend == 1 {
									if srcNulls.NullAt(bs.curSrcStartIdx) {
										outNulls.SetNull(outStartIdx)
									} else {
										v := srcCol.Get(bs.curSrcStartIdx)
										outCol.Set(outStartIdx, v)
									}
								} else {
									out.Copy(
										coldata.SliceArgs{
											Src:         src,
											DestIdx:     outStartIdx,
											SrcStartIdx: bs.curSrcStartIdx,
											SrcEndIdx:   bs.curSrcStartIdx + toAppend,
										},
									)
								}
							}
						case types.TimestampTZFamily:
							switch b.right.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Timestamp()
								outCol := out.Timestamp()

								// Optimization in the case that group length is 1, use assign
								// instead of copy.
								if toAppend == 1 {
									if srcNulls.NullAt(bs.curSrcStartIdx) {
										outNulls.SetNull(outStartIdx)
									} else {
										v := srcCol.Get(bs.curSrcStartIdx)
										outCol.Set(outStartIdx, v)
									}
								} else {
									out.Copy(
										coldata.SliceArgs{
											Src:         src,
											DestIdx:     outStartIdx,
											SrcStartIdx: bs.curSrcStartIdx,
											SrcEndIdx:   bs.curSrcStartIdx + toAppend,
										},
									)
								}
							}
						case types.IntervalFamily:
							switch b.right.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Interval()
								outCol := out.Interval()

								// Optimization in the case that group length is 1, use assign
								// instead of copy.
								if toAppend == 1 {
									if srcNulls.NullAt(bs.curSrcStartIdx) {
										outNulls.SetNull(outStartIdx)
									} else {
										v := srcCol.Get(bs.curSrcStartIdx)
										outCol.Set(outStartIdx, v)
									}
								} else {
									out.Copy(
										coldata.SliceArgs{
											Src:         src,
											DestIdx:     outStartIdx,
											SrcStartIdx: bs.curSrcStartIdx,
											SrcEndIdx:   bs.curSrcStartIdx + toAppend,
										},
									)
								}
							}
						case types.JsonFamily:
							switch b.right.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.JSON()
								outCol := out.JSON()

								// Optimization in the case that group length is 1, use assign
								// instead of copy.
								if toAppend == 1 {
									if srcNulls.NullAt(bs.curSrcStartIdx) {
										outNulls.SetNull(outStartIdx)
									} else {
										outCol.Copy(srcCol, outStartIdx, bs.curSrcStartIdx)
									}
								} else {
									out.Copy(
										coldata.SliceArgs{
											Src:         src,
											DestIdx:     outStartIdx,
											SrcStartIdx: bs.curSrcStartIdx,
											SrcEndIdx:   bs.curSrcStartIdx + toAppend,
										},
									)
								}
							}
						case typeconv.DatumVecCanonicalTypeFamily:
							switch b.right.types[colIdx].Width() {
							case -1:
							default:
								srcCol := src.Datum()
								outCol := out.Datum()

								// Optimization in the case that group length is 1, use assign
								// instead of copy.
								if toAppend == 1 {
									if srcNulls.NullAt(bs.curSrcStartIdx) {
										outNulls.SetNull(outStartIdx)
									} else {
										v := srcCol.Get(bs.curSrcStartIdx)
										outCol.Set(outStartIdx, v)
									}
								} else {
									out.Copy(
										coldata.SliceArgs{
											Src:         src,
											DestIdx:     outStartIdx,
											SrcStartIdx: bs.curSrcStartIdx,
											SrcEndIdx:   bs.curSrcStartIdx + toAppend,
										},
									)
								}
							}
						default:
							colexecerror.InternalError(errors.AssertionFailedf("unhandled type %s", b.right.types[colIdx].String()))
						}
					}
					outStartIdx += toAppend

					if toAppend < batchLength-bs.curSrcStartIdx {
						// If we haven't materialized all the tuples from the
						// batch, then we are ready to emit the output batch.
						bs.curSrcStartIdx += toAppend
						return
					}
					// We have fully processed the current batch, so we need to
					// get the next one.
					currentBatch, err = b.rightTuples.Dequeue(ctx)
					if err != nil {
						colexecerror.InternalError(err)
					}
					bs.currentBatch = currentBatch
					batchLength = currentBatch.Length()
					bs.curSrcStartIdx = 0
				}
				// We have fully processed all the batches from the right side,
				// so we need to Rewind the queue.
				if err := b.rightTuples.Rewind(ctx); err != nil {
					colexecerror.InternalError(err)
				}
				bs.currentBatch = nil
			}
		})
}

// buildFromLeftBatch is the body of buildFromLeftInput that templates out the
// fact whether the current left batch has a selection vector or not.
// execgen:inline
const _ = "inlined_buildFromLeftBatch_true"

// buildFromLeftBatch is the body of buildFromLeftInput that templates out the
// fact whether the current left batch has a selection vector or not.
// execgen:inline
const _ = "inlined_buildFromLeftBatch_false"
