// Code generated by execgen; DO NOT EDIT.
// Copyright 2020 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexechash

import (
	"bytes"
	"math"

	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ = typeconv.DatumVecCanonicalTypeFamily
	_ = coldataext.CompareDatum
	_ tree.AggType
)

// checkColDeleting determines if the current key column in the ToCheckID
// buckets matches the specified equality column key. If there is no match *or*
// the key has been already used, then the key is added to differs. If the
// bucket has reached the end, the key is rejected. If the HashTable disallows
// null equality, then if any element in the key is null, there is no match.
func (ht *HashTable) checkColDeleting(
	probeVec, buildVec *coldata.Vec, keyColIdx int, nToCheck uint32, probeSel []int,
) {
	switch probeVec.CanonicalTypeFamily() {
	case types.BoolFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.BoolFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Bool()
					buildKeys := buildVec.Bool()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.BytesFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.BytesFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Bytes()
					buildKeys := buildVec.Bytes()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.DecimalFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.DecimalFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Decimal()
					buildKeys := buildVec.Decimal()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.IntFamily:
		switch probeVec.Type().Width() {
		case 16:
			switch buildVec.CanonicalTypeFamily() {
			case types.IntFamily:
				switch buildVec.Type().Width() {
				case 16:
					probeKeys := probeVec.Int16()
					buildKeys := buildVec.Int16()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				case 32:
					probeKeys := probeVec.Int16()
					buildKeys := buildVec.Int32()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				case -1:
				default:
					probeKeys := probeVec.Int16()
					buildKeys := buildVec.Int64()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		case 32:
			switch buildVec.CanonicalTypeFamily() {
			case types.IntFamily:
				switch buildVec.Type().Width() {
				case 16:
					probeKeys := probeVec.Int32()
					buildKeys := buildVec.Int16()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				case 32:
					probeKeys := probeVec.Int32()
					buildKeys := buildVec.Int32()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				case -1:
				default:
					probeKeys := probeVec.Int32()
					buildKeys := buildVec.Int64()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.IntFamily:
				switch buildVec.Type().Width() {
				case 16:
					probeKeys := probeVec.Int64()
					buildKeys := buildVec.Int16()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				case 32:
					probeKeys := probeVec.Int64()
					buildKeys := buildVec.Int32()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				case -1:
				default:
					probeKeys := probeVec.Int64()
					buildKeys := buildVec.Int64()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.FloatFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.FloatFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Float64()
					buildKeys := buildVec.Float64()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.TimestampTZFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.TimestampTZFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Timestamp()
					buildKeys := buildVec.Timestamp()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.IntervalFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.IntervalFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Interval()
					buildKeys := buildVec.Interval()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.JsonFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.JsonFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.JSON()
					buildKeys := buildVec.JSON()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case typeconv.DatumVecCanonicalTypeFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Datum()
					buildKeys := buildVec.Datum()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									if ht.Visited[keyID] {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	}
}

// Check performs an equality check between the current key in the ToCheckID
// bucket and the probe key at that index. If there is a match, the HashTable's
// Same array is updated to lazily populate the linked list of identical build
// table keys. The Visited flag for corresponding build table key is also set. A
// key is removed from ToCheck if it has already been visited in a previous
// probe, or the bucket has reached the end (key not found in build table). The
// new length of ToCheck is returned by this function.
//
// Let's walk through an example of how this function works for the INNER join
// when the right source is not distinct (i.e. with the
// HashTableDefaultProbeMode probe mode and Same being non-nil).
//
// In this example the right source contains the following tuples:
//
//	[-1, -2, -4, -1, -3, -2, -1, -3]
//
// and for simplicity we will assume that our hash function is
//
//	h(i) = i % 2
//
// while the hash table only uses two buckets.
//
// During the build phase, before we get to Check function, the hash table is
// constructed in the following manner:
//
//	ht.BuildScratch.First = [2, 1]
//	ht.BuildScratch.Next  = [x, 4, 3, 6, 5, 7, 0, 8, 0]    ('x' means reserved)
//
// Describing in words what this tells us is: say, if we have a value i with
// h(i) = 1, then in order to iterate over all possible matches we do the
// following traversal:
//   - start at keyID = First[h(i)] = First[1] = 1 (i.e. zeroth tuple is the
//     first "candidate")
//   - then for each "candidate" keyID, do nextKeyID = Next[keyID] until it
//     becomes zero, so we will try keyIDs Next[1] = 4, Next[4] = 5,
//     Next[5] = 7, Next[7] = 8, and then stop.
//
// With this background in mind, let's imagine that the first probing batch from
// the left is [-3, -1, -5].
//
// On the first iteration of probing (i.e. the first Check call), we populate
// the following:
// -    ToCheck = [0, 1, 2]
// -  ToCheckID = [1, 1, 1].
// which means that for each probing tuple we have a hash match, and it's the
// zeroth build tuple. Check function finds that only the first probing tuple -1
// matches with the zeroth build tuple, so we end up with the following:
// -    differs = [true, false, true]
// -  HeadID[1] = 1.
// However, since we're selecting the "same" tuples (i.e. populating the Same
// slice), we actually want to continue probing the first tuple from the batch
// for more matches, so we still include it into the ToCheck Slice and do:
//
//	Visited[1] = true.
//
// Then we proceed to the second iteration of probing with all tuples still
// included:
// -    ToCheck = [0, 1, 2]
// -  ToCheckID = [4, 4, 4].
// Check function again finds that only the first probing tuple matches with the
// "candidate", so we end up with the following:
// -    differs = [true, false, true].
// Again, since we want to find all "same" tuples, we find that build tuples
// with firstID=1 and keyID=4 are the same, so we do
// -    Same[1] = 4
// - Visited[4] = true.
//
// On the third iteration, we're still checking all the probing tuples:
// -    ToCheck = [0, 1, 2]
// -  ToCheckID = [5, 5, 5].
// This time the Check function finds that the zeroth probing tuple has a match:
// -    differs = [false, true, true]
// -  HeadID[0] = 5
// - Visited[5] = true.
//
// On the fourth iteration, we're still checking all the probing tuples:
// -    ToCheck = [0, 1, 2]
// -  ToCheckID = [7, 7, 7].
// The Check function finds that the first probing tuple has a match:
// -    differs = [true, false, true].
// We have firstID = 1 and keyID = 7 and do:
// -    Same[7] = Same[1] = 4
// -    Same[1] = 7
// - Visited[7] = true.
//
// On the fifth iteration, we're still checking all the probing tuples:
// -    ToCheck = [0, 1, 2]
// -  ToCheckID = [8, 8, 8].
// The Check function finds that the zeroth probing tuple has a match:
// -    differs = [false, true, true].
// We have firstID = 5 and keyID = 8 and do:
// -    Same[5] = 8
// - Visited[8] = true.
//
// At this point, after five Check calls, there are no more "candidates" for any
// probing tuples (since we reached the end of the hash chain for each probing
// tuple), and the hash joiner will proceed to collecting the matches. Let's
// summarize the current state of things:
// - BuildScratch.First = [2, 1]
// - BuildScratch.Next  = [x, 4, 3, 6, 5, 7, 0, 8, 0]    ('x' means reserved)
// -              Same  = [x, 7, 0, 0, 0, 8, 0, 4, 0]
// -            Visited = [t, t, f, f, t, t, f, t, t]    ('f' means false, 't' means true)
// -             HeadID = [5, 1, 0].
// What this means is that the zeroth probing tuple -3 has an equality match
// with (HeadID[0] = 5) the fourth build tuple -3 as well as (Same[5] = 8) the
// seventh build tuple -3; the first probing tuple -1 has an equality match with
// build tuples with keyIDs HeadID[1] = 1, Same[1] = 7, Same[7] = 4 (i.e. the
// zeroth, the sixth, and the third build tuples with value -1); and the second
// probing tuple -5 doesn't have any matches.
//
// Now let's quickly go through the second probing batch from the left source
// that has values [-1, -2, -3].
//
// On the first Check call we have:
// -    ToCheck = [0, 1, 2]
// -  ToCheckID = [1, 2, 1].
// We find that zeroth and first probing tuple have matches, but since the build
// tuple with keyID=1 has already been visited, we don't include it to be
// checked again, yet keyID=2 hasn't been visited, so we still continue probing
// the first tuple:
// -     HeadID = [1, 2, 0]
// -    ToCheck = [1, 2]
// -  ToCheckID = [x, 3, 4]
// - Visited[2] = true.
//
// On the second Check call we find that both probing tuples didn't get matches
// with the candidates (i.e. they had hash collisions), so we continue probing
// both of them:
// -     HeadID = [1, 2, 0]
// -    ToCheck = [1, 2]
// -  ToCheckID = [x, 6, 5]
// - Visited[3] = true.
//
// On the third Check call both tuples got matches.
// -     HeadID = [1, 2, 5]
// -    Same[2] = 6
// - Visited[6] = true.
// Both tuples are removed from the ToCheck slice because for the -2 probing
// tuple we reached the end of the hash chain and for the -3 probing tuple we
// found a match that has been previously visited.
//
// At this point, after three Check calls, there are no more "candidates" for
// any probing tuples, and the hash joiner will proceed to collecting the
// matches. The current state of things:
// - BuildScratch.First = [2, 1]
// - BuildScratch.Next  = [x, 4, 3, 6, 5, 7, 0, 8, 0]    ('x' means reserved)
// -              Same  = [x, 7, 6, 0, 0, 8, 0, 4, 0]
// -            Visited = [t, t, t, t, t, t, t, t, t]    ('t' means true)
// -             HeadID = [1, 2, 5].
// This means that the zeroth probing tuple -1 has equality matches with keyIDs
// 1, 7, 4; the first probing tuple -2 with keyIDs 2, 6; the second probing
// tuple -3 with keyIDs 5, 8.
//
// We also have fully visited all tuples in the hash table, so all future
// probing batches will be handled more efficiently (namely, once we find a
// match, we stop probing for the corresponding tuple).
func (ht *HashTable) Check(nToCheck uint32, probeSel []int) uint32 {
	ht.checkCols(ht.Keys, nToCheck, probeSel)
	nDiffers := uint32(0)
	switch ht.probeMode {
	case HashTableDefaultProbeMode:
		if ht.Same != nil {
			toCheckSlice := ht.ProbeScratch.ToCheck
			_ = toCheckSlice[nToCheck-1]
			for toCheckPos := uint32(0); toCheckPos < nToCheck && nDiffers < nToCheck; toCheckPos++ {
				//gcassert:bce
				toCheck := toCheckSlice[toCheckPos]
				if ht.ProbeScratch.foundNull[toCheck] {
					ht.ProbeScratch.ToCheckID[toCheck] = 0
					continue
				}
				if !ht.ProbeScratch.differs[toCheck] {
					keyID := ht.ProbeScratch.ToCheckID[toCheck]
					if ht.ProbeScratch.HeadID[toCheck] == 0 {
						ht.ProbeScratch.HeadID[toCheck] = keyID
					}
					if !ht.Visited[keyID] {
						firstID := ht.ProbeScratch.HeadID[toCheck]
						if firstID != keyID {
							ht.Same[keyID] = ht.Same[firstID]
							ht.Same[firstID] = keyID
						}
						ht.Visited[keyID] = true
						//gcassert:bce
						toCheckSlice[nDiffers] = toCheck
						nDiffers++
					}
				} else {
					ht.ProbeScratch.differs[toCheck] = false
					//gcassert:bce
					toCheckSlice[nDiffers] = toCheck
					nDiffers++
				}
			}
		} else {
			toCheckSlice := ht.ProbeScratch.ToCheck
			_ = toCheckSlice[nToCheck-1]
			for toCheckPos := uint32(0); toCheckPos < nToCheck && nDiffers < nToCheck; toCheckPos++ {
				//gcassert:bce
				toCheck := toCheckSlice[toCheckPos]
				if ht.ProbeScratch.foundNull[toCheck] {
					ht.ProbeScratch.ToCheckID[toCheck] = 0
					continue
				}
				if !ht.ProbeScratch.differs[toCheck] {
					keyID := ht.ProbeScratch.ToCheckID[toCheck]
					if ht.ProbeScratch.HeadID[toCheck] == 0 {
						ht.ProbeScratch.HeadID[toCheck] = keyID
					}
				} else {
					ht.ProbeScratch.differs[toCheck] = false
					//gcassert:bce
					toCheckSlice[nDiffers] = toCheck
					nDiffers++
				}
			}
		}
	case HashTableDeletingProbeMode:
		toCheckSlice := ht.ProbeScratch.ToCheck
		_ = toCheckSlice[nToCheck-1]
		for toCheckPos := uint32(0); toCheckPos < nToCheck && nDiffers < nToCheck; toCheckPos++ {
			//gcassert:bce
			toCheck := toCheckSlice[toCheckPos]
			if !ht.ProbeScratch.differs[toCheck] {
				keyID := ht.ProbeScratch.ToCheckID[toCheck]
				if !ht.Visited[keyID] {
					ht.ProbeScratch.HeadID[toCheck] = keyID
					ht.Visited[keyID] = true
				} else {
					if keyID != 0 {
						//gcassert:bce
						toCheckSlice[nDiffers] = toCheck
						nDiffers++
					}
				}
			} else {
				ht.ProbeScratch.differs[toCheck] = false
				//gcassert:bce
				toCheckSlice[nDiffers] = toCheck
				nDiffers++
			}
		}
	default:
		colexecerror.InternalError(errors.AssertionFailedf("unsupported hash table probe mode"))
	}
	return nDiffers
}

// execgen:inline
const _ = "inlined_findBuckets_true_true"

// execgen:inline
const _ = "inlined_findBuckets_true_false"

// execgen:inline
const _ = "inlined_findBuckets_false_true"

// execgen:inline
const _ = "inlined_findBuckets_false_false"

// execgen:inline
const _ = "inlined_handleNextToCheckID_true_true_true"

// execgen:inline
const _ = "inlined_handleNextToCheckID_true_true_false"

// execgen:inline
const _ = "inlined_handleNextToCheckID_true_false_true"

// execgen:inline
const _ = "inlined_handleNextToCheckID_true_false_false"

// execgen:inline
const _ = "inlined_handleNextToCheckID_false_true_true"

// execgen:inline
const _ = "inlined_handleNextToCheckID_false_true_false"

// execgen:inline
const _ = "inlined_handleNextToCheckID_false_false_true"

// execgen:inline
const _ = "inlined_handleNextToCheckID_false_false_false"

// execgen:inline
const _ = "inlined_includeTupleToCheck_true"

// execgen:inline
const _ = "inlined_includeTupleToCheck_false"
