// Code generated by execgen; DO NOT EDIT.
// Copyright 2020 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexechash

import (
	"bytes"
	"math"

	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ = typeconv.DatumVecCanonicalTypeFamily
	_ = coldataext.CompareDatum
	_ tree.AggType
)

// checkCol determines if the current key column in the ToCheckID buckets matches
// the specified equality column key. If there is no match, then the key is
// added to differs. If the bucket has reached the end, the key is rejected. If
// the HashTable disallows null equality, then if any element in the key is
// null, there is no match.
func (ht *HashTable) checkCol(
	probeVec, buildVec *coldata.Vec, keyColIdx int, nToCheck uint32, probeSel []int,
) {
	switch probeVec.CanonicalTypeFamily() {
	case types.BoolFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.BoolFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Bool()
					buildKeys := buildVec.Bool()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.BytesFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.BytesFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Bytes()
					buildKeys := buildVec.Bytes()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.DecimalFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.DecimalFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Decimal()
					buildKeys := buildVec.Decimal()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.IntFamily:
		switch probeVec.Type().Width() {
		case 16:
			switch buildVec.CanonicalTypeFamily() {
			case types.IntFamily:
				switch buildVec.Type().Width() {
				case 16:
					probeKeys := probeVec.Int16()
					buildKeys := buildVec.Int16()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				case 32:
					probeKeys := probeVec.Int16()
					buildKeys := buildVec.Int32()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				case -1:
				default:
					probeKeys := probeVec.Int16()
					buildKeys := buildVec.Int64()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		case 32:
			switch buildVec.CanonicalTypeFamily() {
			case types.IntFamily:
				switch buildVec.Type().Width() {
				case 16:
					probeKeys := probeVec.Int32()
					buildKeys := buildVec.Int16()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				case 32:
					probeKeys := probeVec.Int32()
					buildKeys := buildVec.Int32()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				case -1:
				default:
					probeKeys := probeVec.Int32()
					buildKeys := buildVec.Int64()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.IntFamily:
				switch buildVec.Type().Width() {
				case 16:
					probeKeys := probeVec.Int64()
					buildKeys := buildVec.Int16()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				case 32:
					probeKeys := probeVec.Int64()
					buildKeys := buildVec.Int32()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				case -1:
				default:
					probeKeys := probeVec.Int64()
					buildKeys := buildVec.Int64()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.FloatFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.FloatFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Float64()
					buildKeys := buildVec.Float64()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.TimestampTZFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.TimestampTZFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Timestamp()
					buildKeys := buildVec.Timestamp()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.IntervalFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.IntervalFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Interval()
					buildKeys := buildVec.Interval()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.JsonFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.JsonFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.JSON()
					buildKeys := buildVec.JSON()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case typeconv.DatumVecCanonicalTypeFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Datum()
					buildKeys := buildVec.Datum()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	}
}

// execgen:inline
const _ = "inlined_findBuckets_true_true"

// execgen:inline
const _ = "inlined_findBuckets_true_false"

// execgen:inline
const _ = "inlined_findBuckets_false_true"

// execgen:inline
const _ = "inlined_findBuckets_false_false"

// execgen:inline
const _ = "inlined_handleNextToCheckID_true_true_true"

// execgen:inline
const _ = "inlined_handleNextToCheckID_true_true_false"

// execgen:inline
const _ = "inlined_handleNextToCheckID_true_false_true"

// execgen:inline
const _ = "inlined_handleNextToCheckID_true_false_false"

// execgen:inline
const _ = "inlined_handleNextToCheckID_false_true_true"

// execgen:inline
const _ = "inlined_handleNextToCheckID_false_true_false"

// execgen:inline
const _ = "inlined_handleNextToCheckID_false_false_true"

// execgen:inline
const _ = "inlined_handleNextToCheckID_false_false_false"

// execgen:inline
const _ = "inlined_includeTupleToCheck_true"

// execgen:inline
const _ = "inlined_includeTupleToCheck_false"
