// Code generated by execgen; DO NOT EDIT.
// Copyright 2020 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexechash

import (
	"bytes"
	"math"

	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexecutils"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ = typeconv.DatumVecCanonicalTypeFamily
	_ = coldataext.CompareDatum
	_ tree.AggType
)

// checkColAgainstItselfForDistinct is similar to checkCol, but it probes the
// vector against itself for the purposes of finding matches to unordered
// distinct columns.
func (ht *HashTable) checkColAgainstItselfForDistinct(
	vec *coldata.Vec, nToCheck uint32, sel []int,
) {
	probeVec, buildVec, probeSel := vec, vec, sel
	switch probeVec.CanonicalTypeFamily() {
	case types.BoolFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.BoolFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Bool()
					buildKeys := buildVec.Bool()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if !probeVal && buildVal {
											cmpResult = -1
										} else if probeVal && !buildVal {
											cmpResult = 1
										} else {
											cmpResult = 0
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.BytesFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.BytesFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Bytes()
					buildKeys := buildVec.Bytes()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = bytes.Compare(probeVal, buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.DecimalFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.DecimalFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Decimal()
					buildKeys := buildVec.Decimal()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.IntFamily:
		switch probeVec.Type().Width() {
		case 16:
			switch buildVec.CanonicalTypeFamily() {
			case types.IntFamily:
				switch buildVec.Type().Width() {
				case 16:
					probeKeys := probeVec.Int16()
					buildKeys := buildVec.Int16()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		case 32:
			switch buildVec.CanonicalTypeFamily() {
			case types.IntFamily:
				switch buildVec.Type().Width() {
				case 32:
					probeKeys := probeVec.Int32()
					buildKeys := buildVec.Int32()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.IntFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Int64()
					buildKeys := buildVec.Int64()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := int64(probeVal), int64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else {
												cmpResult = 0
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.FloatFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.FloatFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Float64()
					buildKeys := buildVec.Float64()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										{
											a, b := float64(probeVal), float64(buildVal)
											if a < b {
												cmpResult = -1
											} else if a > b {
												cmpResult = 1
											} else if a == b {
												cmpResult = 0
											} else if math.IsNaN(a) {
												if math.IsNaN(b) {
													cmpResult = 0
												} else {
													cmpResult = -1
												}
											} else {
												cmpResult = 1
											}
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.TimestampTZFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.TimestampTZFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Timestamp()
					buildKeys := buildVec.Timestamp()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										if probeVal.Before(buildVal) {
											cmpResult = -1
										} else if buildVal.Before(probeVal) {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.IntervalFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.IntervalFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Interval()
					buildKeys := buildVec.Interval()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int
										cmpResult = probeVal.Compare(buildVal)
										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case types.JsonFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case types.JsonFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.JSON()
					buildKeys := buildVec.JSON()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										var err error
										cmpResult, err = probeVal.Compare(buildVal)
										if err != nil {
											colexecerror.ExpectedError(err)
										}

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch buildVec.CanonicalTypeFamily() {
			case typeconv.DatumVecCanonicalTypeFamily:
				switch buildVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Datum()
					buildKeys := buildVec.Datum()
					if probeSel != nil {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = probeSel[toCheck]
									buildIdx = probeSel[keyID-1]
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					} else {
						if probeVec.MaybeHasNulls() {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											if !buildIsNull {
												ht.ProbeScratch.differs[toCheck] = true
											}
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								probeVecNulls := probeVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeIsNull := probeVecNulls.NullAt(probeIdx)
									if probeIsNull {
										if ht.allowNullEquality {
											ht.ProbeScratch.differs[toCheck] = true
										} else {
											ht.ProbeScratch.differs[toCheck] = true
											ht.ProbeScratch.foundNull[toCheck] = true
										}
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						} else {
							if buildVec.MaybeHasNulls() {
								var probeIdx, buildIdx int
								buildVecNulls := buildVec.Nulls()
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									buildIsNull := buildVecNulls.NullAt(buildIdx)
									if buildIsNull {
										ht.ProbeScratch.differs[toCheck] = true
										continue
									}
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							} else {
								var probeIdx, buildIdx int
								for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
									if ht.ProbeScratch.differs[toCheck] {
										continue
									}
									keyID := ht.ProbeScratch.ToCheckID[toCheck]
									probeIdx = int(toCheck)
									buildIdx = int(keyID - 1)
									probeVal := probeKeys.Get(probeIdx)
									buildVal := buildKeys.Get(buildIdx)
									var unique bool

									{
										var cmpResult int

										cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

										unique = cmpResult != 0
									}

									ht.ProbeScratch.differs[toCheck] = unique
								}
							}
						}
					}
				}
			}
		}
	}
}

func (ht *HashTable) checkColForDistinctTuples(
	probeVec, buildVec *coldata.Vec, nToCheck uint32, probeSel []int,
) {
	switch probeVec.CanonicalTypeFamily() {
	case types.BoolFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch probeVec.CanonicalTypeFamily() {
			case types.BoolFamily:
				switch probeVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Bool()
					buildKeys := buildVec.Bool()
					if probeVec.MaybeHasNulls() {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										if !buildIsNull {
											ht.ProbeScratch.differs[toCheck] = true
										}
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									if !probeVal && buildVal {
										cmpResult = -1
									} else if probeVal && !buildVal {
										cmpResult = 1
									} else {
										cmpResult = 0
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										ht.ProbeScratch.differs[toCheck] = true
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									if !probeVal && buildVal {
										cmpResult = -1
									} else if probeVal && !buildVal {
										cmpResult = 1
									} else {
										cmpResult = 0
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					} else {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									if !probeVal && buildVal {
										cmpResult = -1
									} else if probeVal && !buildVal {
										cmpResult = 1
									} else {
										cmpResult = 0
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									if !probeVal && buildVal {
										cmpResult = -1
									} else if probeVal && !buildVal {
										cmpResult = 1
									} else {
										cmpResult = 0
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					}
				}
			}
		}
	case types.BytesFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch probeVec.CanonicalTypeFamily() {
			case types.BytesFamily:
				switch probeVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Bytes()
					buildKeys := buildVec.Bytes()
					if probeVec.MaybeHasNulls() {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										if !buildIsNull {
											ht.ProbeScratch.differs[toCheck] = true
										}
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int
									cmpResult = bytes.Compare(probeVal, buildVal)
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										ht.ProbeScratch.differs[toCheck] = true
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int
									cmpResult = bytes.Compare(probeVal, buildVal)
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					} else {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int
									cmpResult = bytes.Compare(probeVal, buildVal)
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int
									cmpResult = bytes.Compare(probeVal, buildVal)
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					}
				}
			}
		}
	case types.DecimalFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch probeVec.CanonicalTypeFamily() {
			case types.IntFamily:
				switch probeVec.Type().Width() {
				}
			case types.FloatFamily:
				switch probeVec.Type().Width() {
				}
			case types.DecimalFamily:
				switch probeVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Decimal()
					buildKeys := buildVec.Decimal()
					if probeVec.MaybeHasNulls() {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										if !buildIsNull {
											ht.ProbeScratch.differs[toCheck] = true
										}
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int
									cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										ht.ProbeScratch.differs[toCheck] = true
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int
									cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					} else {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int
									cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int
									cmpResult = tree.CompareDecimals(&probeVal, &buildVal)
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					}
				}
			}
		}
	case types.IntFamily:
		switch probeVec.Type().Width() {
		case 16:
			switch probeVec.CanonicalTypeFamily() {
			case types.IntFamily:
				switch probeVec.Type().Width() {
				case 16:
					probeKeys := probeVec.Int16()
					buildKeys := buildVec.Int16()
					if probeVec.MaybeHasNulls() {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										if !buildIsNull {
											ht.ProbeScratch.differs[toCheck] = true
										}
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(probeVal), int64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										ht.ProbeScratch.differs[toCheck] = true
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(probeVal), int64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					} else {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(probeVal), int64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(probeVal), int64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					}
				}
			case types.FloatFamily:
				switch probeVec.Type().Width() {
				}
			case types.DecimalFamily:
				switch probeVec.Type().Width() {
				}
			}
		case 32:
			switch probeVec.CanonicalTypeFamily() {
			case types.IntFamily:
				switch probeVec.Type().Width() {
				case 32:
					probeKeys := probeVec.Int32()
					buildKeys := buildVec.Int32()
					if probeVec.MaybeHasNulls() {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										if !buildIsNull {
											ht.ProbeScratch.differs[toCheck] = true
										}
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(probeVal), int64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										ht.ProbeScratch.differs[toCheck] = true
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(probeVal), int64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					} else {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(probeVal), int64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(probeVal), int64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					}
				}
			case types.FloatFamily:
				switch probeVec.Type().Width() {
				}
			case types.DecimalFamily:
				switch probeVec.Type().Width() {
				}
			}
		case -1:
		default:
			switch probeVec.CanonicalTypeFamily() {
			case types.IntFamily:
				switch probeVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Int64()
					buildKeys := buildVec.Int64()
					if probeVec.MaybeHasNulls() {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										if !buildIsNull {
											ht.ProbeScratch.differs[toCheck] = true
										}
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(probeVal), int64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										ht.ProbeScratch.differs[toCheck] = true
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(probeVal), int64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					} else {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(probeVal), int64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(probeVal), int64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					}
				}
			case types.FloatFamily:
				switch probeVec.Type().Width() {
				}
			case types.DecimalFamily:
				switch probeVec.Type().Width() {
				}
			}
		}
	case types.FloatFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch probeVec.CanonicalTypeFamily() {
			case types.IntFamily:
				switch probeVec.Type().Width() {
				}
			case types.FloatFamily:
				switch probeVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Float64()
					buildKeys := buildVec.Float64()
					if probeVec.MaybeHasNulls() {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										if !buildIsNull {
											ht.ProbeScratch.differs[toCheck] = true
										}
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := float64(probeVal), float64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else if a == b {
											cmpResult = 0
										} else if math.IsNaN(a) {
											if math.IsNaN(b) {
												cmpResult = 0
											} else {
												cmpResult = -1
											}
										} else {
											cmpResult = 1
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										ht.ProbeScratch.differs[toCheck] = true
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := float64(probeVal), float64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else if a == b {
											cmpResult = 0
										} else if math.IsNaN(a) {
											if math.IsNaN(b) {
												cmpResult = 0
											} else {
												cmpResult = -1
											}
										} else {
											cmpResult = 1
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					} else {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := float64(probeVal), float64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else if a == b {
											cmpResult = 0
										} else if math.IsNaN(a) {
											if math.IsNaN(b) {
												cmpResult = 0
											} else {
												cmpResult = -1
											}
										} else {
											cmpResult = 1
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									{
										a, b := float64(probeVal), float64(buildVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else if a == b {
											cmpResult = 0
										} else if math.IsNaN(a) {
											if math.IsNaN(b) {
												cmpResult = 0
											} else {
												cmpResult = -1
											}
										} else {
											cmpResult = 1
										}
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					}
				}
			case types.DecimalFamily:
				switch probeVec.Type().Width() {
				}
			}
		}
	case types.TimestampTZFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch probeVec.CanonicalTypeFamily() {
			case types.TimestampTZFamily:
				switch probeVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Timestamp()
					buildKeys := buildVec.Timestamp()
					if probeVec.MaybeHasNulls() {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										if !buildIsNull {
											ht.ProbeScratch.differs[toCheck] = true
										}
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									if probeVal.Before(buildVal) {
										cmpResult = -1
									} else if buildVal.Before(probeVal) {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										ht.ProbeScratch.differs[toCheck] = true
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									if probeVal.Before(buildVal) {
										cmpResult = -1
									} else if buildVal.Before(probeVal) {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					} else {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									if probeVal.Before(buildVal) {
										cmpResult = -1
									} else if buildVal.Before(probeVal) {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									if probeVal.Before(buildVal) {
										cmpResult = -1
									} else if buildVal.Before(probeVal) {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					}
				}
			}
		}
	case types.IntervalFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch probeVec.CanonicalTypeFamily() {
			case types.IntervalFamily:
				switch probeVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Interval()
					buildKeys := buildVec.Interval()
					if probeVec.MaybeHasNulls() {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										if !buildIsNull {
											ht.ProbeScratch.differs[toCheck] = true
										}
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int
									cmpResult = probeVal.Compare(buildVal)
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										ht.ProbeScratch.differs[toCheck] = true
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int
									cmpResult = probeVal.Compare(buildVal)
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					} else {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int
									cmpResult = probeVal.Compare(buildVal)
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int
									cmpResult = probeVal.Compare(buildVal)
									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					}
				}
			}
		}
	case types.JsonFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch probeVec.CanonicalTypeFamily() {
			case types.JsonFamily:
				switch probeVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.JSON()
					buildKeys := buildVec.JSON()
					if probeVec.MaybeHasNulls() {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										if !buildIsNull {
											ht.ProbeScratch.differs[toCheck] = true
										}
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									var err error
									cmpResult, err = probeVal.Compare(buildVal)
									if err != nil {
										colexecerror.ExpectedError(err)
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										ht.ProbeScratch.differs[toCheck] = true
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									var err error
									cmpResult, err = probeVal.Compare(buildVal)
									if err != nil {
										colexecerror.ExpectedError(err)
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					} else {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									var err error
									cmpResult, err = probeVal.Compare(buildVal)
									if err != nil {
										colexecerror.ExpectedError(err)
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									var err error
									cmpResult, err = probeVal.Compare(buildVal)
									if err != nil {
										colexecerror.ExpectedError(err)
									}

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					}
				}
			}
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch probeVec.Type().Width() {
		case -1:
		default:
			switch probeVec.CanonicalTypeFamily() {
			case typeconv.DatumVecCanonicalTypeFamily:
				switch probeVec.Type().Width() {
				case -1:
				default:
					probeKeys := probeVec.Datum()
					buildKeys := buildVec.Datum()
					if probeVec.MaybeHasNulls() {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										if !buildIsNull {
											ht.ProbeScratch.differs[toCheck] = true
										}
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							probeVecNulls := probeVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeIsNull := probeVecNulls.NullAt(probeIdx)
								if probeIsNull {
									if ht.allowNullEquality {
										ht.ProbeScratch.differs[toCheck] = true
									} else {
										ht.ProbeScratch.differs[toCheck] = true
										ht.ProbeScratch.foundNull[toCheck] = true
									}
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					} else {
						if buildVec.MaybeHasNulls() {
							var probeIdx, buildIdx int
							buildVecNulls := buildVec.Nulls()
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								buildIsNull := buildVecNulls.NullAt(buildIdx)
								if buildIsNull {
									ht.ProbeScratch.differs[toCheck] = true
									continue
								}
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						} else {
							var probeIdx, buildIdx int
							for _, toCheck := range ht.ProbeScratch.ToCheck[:nToCheck] {
								if ht.ProbeScratch.differs[toCheck] {
									continue
								}
								keyID := ht.ProbeScratch.ToCheckID[toCheck]
								probeIdx = probeSel[toCheck]
								buildIdx = int(keyID - 1)
								probeVal := probeKeys.Get(probeIdx)
								buildVal := buildKeys.Get(buildIdx)
								var unique bool

								{
									var cmpResult int

									cmpResult = coldataext.CompareDatum(probeVal, probeKeys, buildVal)

									unique = cmpResult != 0
								}

								ht.ProbeScratch.differs[toCheck] = unique
							}
						}
					}
				}
			}
		}
	}
}

// CheckProbeForDistinct performs a column by column check for duplicated tuples
// in the probe table.
func (ht *HashTable) CheckProbeForDistinct(vecs []*coldata.Vec, nToCheck uint32, sel []int) uint32 {
	for i := range ht.keyCols {
		ht.checkColAgainstItselfForDistinct(vecs[i], nToCheck, sel)
	}
	nDiffers := uint32(0)
	if ht.allowNullEquality {
		toCheckSlice := ht.ProbeScratch.ToCheck
		_ = toCheckSlice[nToCheck-1]
		for toCheckPos := uint32(0); toCheckPos < nToCheck && nDiffers < nToCheck; toCheckPos++ {
			//gcassert:bce
			toCheck := toCheckSlice[toCheckPos]
			if !ht.ProbeScratch.differs[toCheck] {
				keyID := ht.ProbeScratch.ToCheckID[toCheck]
				ht.ProbeScratch.HeadID[toCheck] = keyID
			} else {
				ht.ProbeScratch.differs[toCheck] = false
				//gcassert:bce
				toCheckSlice[nDiffers] = toCheck
				nDiffers++
			}
		}
	} else {
		toCheckSlice := ht.ProbeScratch.ToCheck
		_ = toCheckSlice[nToCheck-1]
		for toCheckPos := uint32(0); toCheckPos < nToCheck && nDiffers < nToCheck; toCheckPos++ {
			//gcassert:bce
			toCheck := toCheckSlice[toCheckPos]
			if ht.ProbeScratch.foundNull[toCheck] {
				ht.ProbeScratch.HeadID[toCheck] = toCheck + 1
				continue
			}
			if !ht.ProbeScratch.differs[toCheck] {
				keyID := ht.ProbeScratch.ToCheckID[toCheck]
				ht.ProbeScratch.HeadID[toCheck] = keyID
			} else {
				ht.ProbeScratch.differs[toCheck] = false
				//gcassert:bce
				toCheckSlice[nDiffers] = toCheck
				nDiffers++
			}
		}
	}
	return nDiffers
}

// updateSel updates the selection vector in the given batch using the HeadID
// buffer. For each nonzero keyID in HeadID, it will be translated to the actual
// key index using the convention keyID = keys.indexOf(key) + 1. If the input
// batch's selection vector is nil, the key index will be directly used to
// populate the selection vector. Otherwise, the selection vector's value at the
// key index will be used. The duplicated keyIDs will be discarded. The
// HashBuffer will also compact and discard hash values of duplicated keys.
func (ht *HashTable) updateSel(b coldata.Batch) {
	if b.Length() == 0 {
		return
	}
	if sel := b.Selection(); sel != nil {
		batchLength := b.Length()
		// Capture the slices in order for BCE to occur.
		HeadIDs := ht.ProbeScratch.HeadID
		hashBuffer := ht.ProbeScratch.HashBuffer
		_ = HeadIDs[batchLength-1]
		_ = hashBuffer[batchLength-1]
		// Reuse the buffer allocated for foundNull.
		visited := ht.ProbeScratch.foundNull
		copy(visited, colexecutils.ZeroBoolColumn)
		distinctCount := 0
		for i := 0; i < batchLength && distinctCount < batchLength; i++ {
			//gcassert:bce
			HeadID := HeadIDs[i]
			if HeadID != 0 {
				if hasVisited := visited[HeadID-1]; !hasVisited {
					sel[distinctCount] = sel[HeadID-1]
					visited[HeadID-1] = true
					//gcassert:bce
					hashBuffer[distinctCount] = hashBuffer[i]
					distinctCount++
				}
			}
		}
		b.SetLength(distinctCount)
	} else {
		b.SetSelection(true)
		sel = b.Selection()
		batchLength := b.Length()
		// Capture the slices in order for BCE to occur.
		HeadIDs := ht.ProbeScratch.HeadID
		hashBuffer := ht.ProbeScratch.HashBuffer
		_ = HeadIDs[batchLength-1]
		_ = hashBuffer[batchLength-1]
		// Reuse the buffer allocated for foundNull.
		visited := ht.ProbeScratch.foundNull
		copy(visited, colexecutils.ZeroBoolColumn)
		distinctCount := 0
		for i := 0; i < batchLength && distinctCount < batchLength; i++ {
			//gcassert:bce
			HeadID := HeadIDs[i]
			if HeadID != 0 {
				if hasVisited := visited[HeadID-1]; !hasVisited {
					sel[distinctCount] = int(HeadID - 1)
					visited[HeadID-1] = true
					//gcassert:bce
					hashBuffer[distinctCount] = hashBuffer[i]
					distinctCount++
				}
			}
		}
		b.SetLength(distinctCount)
	}
}

// FindBuckets finds the buckets for all tuples in batch when probing against a
// hash table that is specified by 'first' and 'next' vectors as well as
// 'duplicatesChecker'. `duplicatesChecker` takes a slice of key columns of the
// batch, number of tuples to check, and the selection vector of the batch, and
// it returns number of tuples that needs to be checked for next iteration.
// The "buckets" are specified by equal values in ht.ProbeScratch.HeadID.
//
// - zeroHeadIDForDistinctTuple controls how a bucket with a single distinct
// tuple will be represented (i.e. this tuple is distinct from all tuples in the
// hash table). If zeroHeadIDForDistinctTuple is true, then this tuple will have
// HeadID of 0, otherwise, it'll have HeadID[i] = keyID(i) = i + 1.
// - probingAgainstItself, if true, indicates that the hash table was built on
// the probing batch itself. In such a scenario the behavior can be optimized
// since we know that every tuple has at least one match.
//
// NOTE: *first* and *next* vectors should be properly populated.
// NOTE: batch is assumed to be non-zero length.
func (ht *HashTable) FindBuckets(
	batch coldata.Batch,
	keyCols []*coldata.Vec,
	first, next []keyID,
	duplicatesChecker func([]*coldata.Vec, uint32, []int) uint32,
	zeroHeadIDForDistinctTuple bool,
	probingAgainstItself bool,
) {
	ht.ProbeScratch.SetupLimitedSlices(batch.Length())
	if zeroHeadIDForDistinctTuple {
		if probingAgainstItself {
			{
				batchLength := batch.Length()
				sel := batch.Selection()
				// Early bounds checks.
				toCheckIDs := ht.ProbeScratch.ToCheckID
				_ = toCheckIDs[batchLength-1]
				headIDs := ht.ProbeScratch.HeadID
				_ = headIDs[batchLength-1]
				var nToCheck uint32
				for i, hash := range ht.ProbeScratch.HashBuffer[:batchLength] {
					toCheck := uint32(i)
					nextToCheckID := first[hash]
					{
						if toCheck+1 == nextToCheckID {
							_ = true
							//gcassert:gce
							headIDs[toCheck] = nextToCheckID
						} else {
							{
								_ = true
								//gcassert:bce
								toCheckIDs[i] = nextToCheckID
								ht.ProbeScratch.ToCheck[nToCheck] = toCheck
								nToCheck++
							}
						}
					}
				}

				for nToCheck > 0 {
					nToCheck = duplicatesChecker(keyCols, nToCheck, sel)
					toCheckSlice := ht.ProbeScratch.ToCheck[:nToCheck]
					nToCheck = 0
					for _, toCheck := range toCheckSlice {
						nextToCheckID := next[toCheckIDs[toCheck]]
						{
							if toCheck+1 == nextToCheckID {
								_ = true
								headIDs[toCheck] = nextToCheckID
							} else {
								{
									_ = true
									//gcassert:bce
									toCheckIDs[toCheck] = nextToCheckID
									ht.ProbeScratch.ToCheck[nToCheck] = toCheck
									nToCheck++
								}
							}
						}
					}
				}
			}
		} else {
			{
				batchLength := batch.Length()
				sel := batch.Selection()
				// Early bounds checks.
				toCheckIDs := ht.ProbeScratch.ToCheckID
				_ = toCheckIDs[batchLength-1]
				var nToCheck uint32
				for i, hash := range ht.ProbeScratch.HashBuffer[:batchLength] {
					toCheck := uint32(i)
					nextToCheckID := first[hash]
					{
						if nextToCheckID != 0 {
							{
								_ = true
								//gcassert:bce
								toCheckIDs[i] = nextToCheckID
								ht.ProbeScratch.ToCheck[nToCheck] = toCheck
								nToCheck++
							}
						} else {
							_ = true
						}
					}
				}

				for nToCheck > 0 {
					nToCheck = duplicatesChecker(keyCols, nToCheck, sel)
					toCheckSlice := ht.ProbeScratch.ToCheck[:nToCheck]
					nToCheck = 0
					for _, toCheck := range toCheckSlice {
						nextToCheckID := next[toCheckIDs[toCheck]]
						{
							if nextToCheckID != 0 {
								{
									_ = true
									//gcassert:bce
									toCheckIDs[toCheck] = nextToCheckID
									ht.ProbeScratch.ToCheck[nToCheck] = toCheck
									nToCheck++
								}
							} else {
								_ = true
							}
						}
					}
				}
			}
		}
	} else {
		if probingAgainstItself {
			{
				batchLength := batch.Length()
				sel := batch.Selection()
				// Early bounds checks.
				toCheckIDs := ht.ProbeScratch.ToCheckID
				_ = toCheckIDs[batchLength-1]
				headIDs := ht.ProbeScratch.HeadID
				_ = headIDs[batchLength-1]
				var nToCheck uint32
				for i, hash := range ht.ProbeScratch.HashBuffer[:batchLength] {
					toCheck := uint32(i)
					nextToCheckID := first[hash]
					{
						if toCheck+1 == nextToCheckID {
							_ = true
							//gcassert:gce
							headIDs[toCheck] = nextToCheckID
						} else {
							{
								_ = true
								//gcassert:bce
								toCheckIDs[i] = nextToCheckID
								ht.ProbeScratch.ToCheck[nToCheck] = toCheck
								nToCheck++
							}
						}
					}
				}

				for nToCheck > 0 {
					nToCheck = duplicatesChecker(keyCols, nToCheck, sel)
					toCheckSlice := ht.ProbeScratch.ToCheck[:nToCheck]
					nToCheck = 0
					for _, toCheck := range toCheckSlice {
						nextToCheckID := next[toCheckIDs[toCheck]]
						{
							if toCheck+1 == nextToCheckID {
								_ = true
								headIDs[toCheck] = nextToCheckID
							} else {
								{
									_ = true
									//gcassert:bce
									toCheckIDs[toCheck] = nextToCheckID
									ht.ProbeScratch.ToCheck[nToCheck] = toCheck
									nToCheck++
								}
							}
						}
					}
				}
			}
		} else {
			{
				batchLength := batch.Length()
				sel := batch.Selection()
				// Early bounds checks.
				toCheckIDs := ht.ProbeScratch.ToCheckID
				_ = toCheckIDs[batchLength-1]
				headIDs := ht.ProbeScratch.HeadID
				_ = headIDs[batchLength-1]
				var nToCheck uint32
				for i, hash := range ht.ProbeScratch.HashBuffer[:batchLength] {
					toCheck := uint32(i)
					nextToCheckID := first[hash]
					{
						if nextToCheckID != 0 {
							{
								_ = true
								//gcassert:bce
								toCheckIDs[i] = nextToCheckID
								ht.ProbeScratch.ToCheck[nToCheck] = toCheck
								nToCheck++
							}
						} else {
							_ = true
							_ = true
							//gcassert:gce
							headIDs[toCheck] = toCheck + 1
						}
					}
				}

				for nToCheck > 0 {
					nToCheck = duplicatesChecker(keyCols, nToCheck, sel)
					toCheckSlice := ht.ProbeScratch.ToCheck[:nToCheck]
					nToCheck = 0
					for _, toCheck := range toCheckSlice {
						nextToCheckID := next[toCheckIDs[toCheck]]
						{
							if nextToCheckID != 0 {
								{
									_ = true
									//gcassert:bce
									toCheckIDs[toCheck] = nextToCheckID
									ht.ProbeScratch.ToCheck[nToCheck] = toCheck
									nToCheck++
								}
							} else {
								_ = true
								_ = true
								headIDs[toCheck] = toCheck + 1
							}
						}
					}
				}
			}
		}
	}
}

// execgen:inline
const _ = "template_findBuckets"

// execgen:inline
const _ = "template_handleNextToCheckID"

// execgen:inline
const _ = "template_includeTupleToCheck"

// execgen:inline
const _ = "inlined_findBuckets_true_true"

// execgen:inline
const _ = "inlined_findBuckets_true_false"

// execgen:inline
const _ = "inlined_findBuckets_false_true"

// execgen:inline
const _ = "inlined_findBuckets_false_false"

// execgen:inline
const _ = "inlined_handleNextToCheckID_true_true_true"

// execgen:inline
const _ = "inlined_handleNextToCheckID_true_true_false"

// execgen:inline
const _ = "inlined_handleNextToCheckID_true_false_true"

// execgen:inline
const _ = "inlined_handleNextToCheckID_true_false_false"

// execgen:inline
const _ = "inlined_handleNextToCheckID_false_true_true"

// execgen:inline
const _ = "inlined_handleNextToCheckID_false_true_false"

// execgen:inline
const _ = "inlined_handleNextToCheckID_false_false_true"

// execgen:inline
const _ = "inlined_handleNextToCheckID_false_false_false"

// execgen:inline
const _ = "inlined_includeTupleToCheck_true"

// execgen:inline
const _ = "inlined_includeTupleToCheck_false"
