// Code generated by execgen; DO NOT EDIT.
// Copyright 2020 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexechash

import (
	"math"
	"reflect"
	"unsafe"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexecutils"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/json"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ = typeconv.DatumVecCanonicalTypeFamily
	_ = coldataext.Hash
	_ json.JSON
	_ tree.Datum
	_ apd.Context
)

// rehash takes an element of a key (tuple representing a row of equality
// column values) at a given column and computes a new hash by applying a
// transformation to the existing hash.
func rehash[T uint32 | uint64](
	buckets []T,
	col *coldata.Vec,
	nKeys int,
	sel []int,
	cancelChecker colexecutils.CancelChecker,
	datumAlloc *tree.DatumAlloc,
) {
	switch col.CanonicalTypeFamily() {
	case types.BoolFamily:
		switch col.Type().Width() {
		case -1:
		default:
			keys, nulls := col.Bool(), col.Nulls()
			if col.MaybeHasNulls() {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						if nulls.NullAt(selIdx) {
							continue
						}
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						x := 0
						if v {
							x = 1
						}
						p = p*31 + uintptr(x)

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						if nulls.NullAt(selIdx) {
							continue
						}
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						x := 0
						if v {
							x = 1
						}
						p = p*31 + uintptr(x)

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			} else {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						x := 0
						if v {
							x = 1
						}
						p = p*31 + uintptr(x)

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						x := 0
						if v {
							x = 1
						}
						p = p*31 + uintptr(x)

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			}
		}
	case types.BytesFamily:
		switch col.Type().Width() {
		case -1:
		default:
			keys, nulls := col.Bytes(), col.Nulls()
			if col.MaybeHasNulls() {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						if nulls.NullAt(selIdx) {
							continue
						}
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						sh := (*reflect.SliceHeader)(unsafe.Pointer(&v))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(v)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						if nulls.NullAt(selIdx) {
							continue
						}
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						sh := (*reflect.SliceHeader)(unsafe.Pointer(&v))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(v)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			} else {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						sh := (*reflect.SliceHeader)(unsafe.Pointer(&v))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(v)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						sh := (*reflect.SliceHeader)(unsafe.Pointer(&v))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(v)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			}
		}
	case types.DecimalFamily:
		switch col.Type().Width() {
		case -1:
		default:
			keys, nulls := col.Decimal(), col.Nulls()
			if col.MaybeHasNulls() {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						if nulls.NullAt(selIdx) {
							continue
						}
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for equal decimals to hash to the same value we need to
						// remove the trailing zeroes if there are any.
						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.Reduce(&v)
						b := []byte(tmpDec.String())
						sh := (*reflect.SliceHeader)(unsafe.Pointer(&b))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(b)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						if nulls.NullAt(selIdx) {
							continue
						}
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for equal decimals to hash to the same value we need to
						// remove the trailing zeroes if there are any.
						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.Reduce(&v)
						b := []byte(tmpDec.String())
						sh := (*reflect.SliceHeader)(unsafe.Pointer(&b))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(b)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			} else {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for equal decimals to hash to the same value we need to
						// remove the trailing zeroes if there are any.
						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.Reduce(&v)
						b := []byte(tmpDec.String())
						sh := (*reflect.SliceHeader)(unsafe.Pointer(&b))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(b)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for equal decimals to hash to the same value we need to
						// remove the trailing zeroes if there are any.
						var tmpDec apd.Decimal //gcassert:noescape
						tmpDec.Reduce(&v)
						b := []byte(tmpDec.String())
						sh := (*reflect.SliceHeader)(unsafe.Pointer(&b))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(b)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			}
		}
	case types.IntFamily:
		switch col.Type().Width() {
		case 16:
			keys, nulls := col.Int16(), col.Nulls()
			if col.MaybeHasNulls() {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						if nulls.NullAt(selIdx) {
							continue
						}
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for integers with different widths but of the same value to
						// to hash to the same value, we upcast all of them to int64.
						asInt64 := int64(v)
						p = memhash64(noescape(unsafe.Pointer(&asInt64)), p)
						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						if nulls.NullAt(selIdx) {
							continue
						}
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for integers with different widths but of the same value to
						// to hash to the same value, we upcast all of them to int64.
						asInt64 := int64(v)
						p = memhash64(noescape(unsafe.Pointer(&asInt64)), p)
						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			} else {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for integers with different widths but of the same value to
						// to hash to the same value, we upcast all of them to int64.
						asInt64 := int64(v)
						p = memhash64(noescape(unsafe.Pointer(&asInt64)), p)
						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for integers with different widths but of the same value to
						// to hash to the same value, we upcast all of them to int64.
						asInt64 := int64(v)
						p = memhash64(noescape(unsafe.Pointer(&asInt64)), p)
						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			}
		case 32:
			keys, nulls := col.Int32(), col.Nulls()
			if col.MaybeHasNulls() {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						if nulls.NullAt(selIdx) {
							continue
						}
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for integers with different widths but of the same value to
						// to hash to the same value, we upcast all of them to int64.
						asInt64 := int64(v)
						p = memhash64(noescape(unsafe.Pointer(&asInt64)), p)
						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						if nulls.NullAt(selIdx) {
							continue
						}
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for integers with different widths but of the same value to
						// to hash to the same value, we upcast all of them to int64.
						asInt64 := int64(v)
						p = memhash64(noescape(unsafe.Pointer(&asInt64)), p)
						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			} else {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for integers with different widths but of the same value to
						// to hash to the same value, we upcast all of them to int64.
						asInt64 := int64(v)
						p = memhash64(noescape(unsafe.Pointer(&asInt64)), p)
						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for integers with different widths but of the same value to
						// to hash to the same value, we upcast all of them to int64.
						asInt64 := int64(v)
						p = memhash64(noescape(unsafe.Pointer(&asInt64)), p)
						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			}
		case -1:
		default:
			keys, nulls := col.Int64(), col.Nulls()
			if col.MaybeHasNulls() {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						if nulls.NullAt(selIdx) {
							continue
						}
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for integers with different widths but of the same value to
						// to hash to the same value, we upcast all of them to int64.
						asInt64 := int64(v)
						p = memhash64(noescape(unsafe.Pointer(&asInt64)), p)
						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						if nulls.NullAt(selIdx) {
							continue
						}
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for integers with different widths but of the same value to
						// to hash to the same value, we upcast all of them to int64.
						asInt64 := int64(v)
						p = memhash64(noescape(unsafe.Pointer(&asInt64)), p)
						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			} else {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for integers with different widths but of the same value to
						// to hash to the same value, we upcast all of them to int64.
						asInt64 := int64(v)
						p = memhash64(noescape(unsafe.Pointer(&asInt64)), p)
						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						// In order for integers with different widths but of the same value to
						// to hash to the same value, we upcast all of them to int64.
						asInt64 := int64(v)
						p = memhash64(noescape(unsafe.Pointer(&asInt64)), p)
						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			}
		}
	case types.FloatFamily:
		switch col.Type().Width() {
		case -1:
		default:
			keys, nulls := col.Float64(), col.Nulls()
			if col.MaybeHasNulls() {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						if nulls.NullAt(selIdx) {
							continue
						}
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						f := v
						if math.IsNaN(float64(f)) {
							f = 0
						}
						p = f64hash(noescape(unsafe.Pointer(&f)), p)

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						if nulls.NullAt(selIdx) {
							continue
						}
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						f := v
						if math.IsNaN(float64(f)) {
							f = 0
						}
						p = f64hash(noescape(unsafe.Pointer(&f)), p)

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			} else {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						f := v
						if math.IsNaN(float64(f)) {
							f = 0
						}
						p = f64hash(noescape(unsafe.Pointer(&f)), p)

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						f := v
						if math.IsNaN(float64(f)) {
							f = 0
						}
						p = f64hash(noescape(unsafe.Pointer(&f)), p)

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			}
		}
	case types.TimestampTZFamily:
		switch col.Type().Width() {
		case -1:
		default:
			keys, nulls := col.Timestamp(), col.Nulls()
			if col.MaybeHasNulls() {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						if nulls.NullAt(selIdx) {
							continue
						}
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						s := v.UnixNano()
						p = memhash64(noescape(unsafe.Pointer(&s)), p)

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						if nulls.NullAt(selIdx) {
							continue
						}
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						s := v.UnixNano()
						p = memhash64(noescape(unsafe.Pointer(&s)), p)

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			} else {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						s := v.UnixNano()
						p = memhash64(noescape(unsafe.Pointer(&s)), p)

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						s := v.UnixNano()
						p = memhash64(noescape(unsafe.Pointer(&s)), p)

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			}
		}
	case types.IntervalFamily:
		switch col.Type().Width() {
		case -1:
		default:
			keys, nulls := col.Interval(), col.Nulls()
			if col.MaybeHasNulls() {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						if nulls.NullAt(selIdx) {
							continue
						}
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						months, days, nanos := v.Months, v.Days, v.Nanos()
						p = memhash64(noescape(unsafe.Pointer(&months)), p)
						p = memhash64(noescape(unsafe.Pointer(&days)), p)
						p = memhash64(noescape(unsafe.Pointer(&nanos)), p)

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						if nulls.NullAt(selIdx) {
							continue
						}
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						months, days, nanos := v.Months, v.Days, v.Nanos()
						p = memhash64(noescape(unsafe.Pointer(&months)), p)
						p = memhash64(noescape(unsafe.Pointer(&days)), p)
						p = memhash64(noescape(unsafe.Pointer(&nanos)), p)

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			} else {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						months, days, nanos := v.Months, v.Days, v.Nanos()
						p = memhash64(noescape(unsafe.Pointer(&months)), p)
						p = memhash64(noescape(unsafe.Pointer(&days)), p)
						p = memhash64(noescape(unsafe.Pointer(&nanos)), p)

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = keys.Get(nKeys - 1)
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						//gcassert:bce
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])

						months, days, nanos := v.Months, v.Days, v.Nanos()
						p = memhash64(noescape(unsafe.Pointer(&months)), p)
						p = memhash64(noescape(unsafe.Pointer(&days)), p)
						p = memhash64(noescape(unsafe.Pointer(&nanos)), p)

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			}
		}
	case types.JsonFamily:
		switch col.Type().Width() {
		case -1:
		default:
			keys, nulls := col.JSON(), col.Nulls()
			if col.MaybeHasNulls() {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						if nulls.NullAt(selIdx) {
							continue
						}
						//gcassert:bce
						p := uintptr(buckets[i])

						// Access the underlying []byte directly which allows us to skip
						// decoding-encoding of the JSON object.
						_b := keys.Bytes.Get(selIdx)

						sh := (*reflect.SliceHeader)(unsafe.Pointer(&_b))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(_b)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						if nulls.NullAt(selIdx) {
							continue
						}
						//gcassert:bce
						p := uintptr(buckets[i])

						// Access the underlying []byte directly which allows us to skip
						// decoding-encoding of the JSON object.
						_b := keys.Bytes.Get(selIdx)

						sh := (*reflect.SliceHeader)(unsafe.Pointer(&_b))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(_b)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			} else {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						//gcassert:bce
						p := uintptr(buckets[i])

						// Access the underlying []byte directly which allows us to skip
						// decoding-encoding of the JSON object.
						_b := keys.Bytes.Get(selIdx)

						sh := (*reflect.SliceHeader)(unsafe.Pointer(&_b))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(_b)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						//gcassert:bce
						p := uintptr(buckets[i])

						// Access the underlying []byte directly which allows us to skip
						// decoding-encoding of the JSON object.
						_b := keys.Bytes.Get(selIdx)

						sh := (*reflect.SliceHeader)(unsafe.Pointer(&_b))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(_b)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			}
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch col.Type().Width() {
		case -1:
		default:
			keys, nulls := col.Datum(), col.Nulls()
			if col.MaybeHasNulls() {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						if nulls.NullAt(selIdx) {
							continue
						}
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])
						b := coldataext.Hash(v.(tree.Datum), datumAlloc)
						sh := (*reflect.SliceHeader)(unsafe.Pointer(&b))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(b)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						if nulls.NullAt(selIdx) {
							continue
						}
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])
						b := coldataext.Hash(v.(tree.Datum), datumAlloc)
						sh := (*reflect.SliceHeader)(unsafe.Pointer(&b))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(b)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			} else {
				if sel != nil {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					_ = sel[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						//gcassert:bce
						selIdx = sel[i]
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])
						b := coldataext.Hash(v.(tree.Datum), datumAlloc)
						sh := (*reflect.SliceHeader)(unsafe.Pointer(&b))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(b)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				} else {
					// Early bounds checks.
					_ = buckets[nKeys-1]
					var selIdx int
					for i := 0; i < nKeys; i++ {
						selIdx = i
						v := keys.Get(selIdx)
						//gcassert:bce
						p := uintptr(buckets[i])
						b := coldataext.Hash(v.(tree.Datum), datumAlloc)
						sh := (*reflect.SliceHeader)(unsafe.Pointer(&b))
						p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(b)))

						//gcassert:bce
						buckets[i] = T(p)
					}
				}
			}
		}
	default:
		colexecerror.InternalError(errors.AssertionFailedf("unhandled type %s", col.Type()))
	}
	cancelChecker.CheckEveryCall()
}
