// Code generated by execgen; DO NOT EDIT.
// Copyright 2020 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexeccmp

import (
	"context"

	"github.com/cockroachdb/cockroach/pkg/sql/sem/eval"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/errors"
)

type cmpExprAdapterBase struct {
	op      tree.BinaryEvalOp
	evalCtx *eval.Context
}

type cmpExprAdapter struct {
	cmpExprAdapterBase
}

var _ ComparisonExprAdapter = &cmpExprAdapter{}

func (c *cmpExprAdapter) Eval(ctx context.Context, left, right tree.Datum) (tree.Datum, error) {
	if left == tree.DNull || right == tree.DNull {
		return tree.DNull, nil
	}
	d, err := eval.BinaryOp(ctx, c.evalCtx, c.op, left, right)
	if d == tree.DNull || err != nil {
		return d, err
	}
	b, ok := d.(*tree.DBool)
	if !ok {
		return nil, errors.AssertionFailedf("%v is %T and not *DBool", d, d)
	}
	result := tree.MakeDBool(*b)
	return result, nil
}

type cmpNegateExprAdapter struct {
	cmpExprAdapterBase
}

var _ ComparisonExprAdapter = &cmpNegateExprAdapter{}

func (c *cmpNegateExprAdapter) Eval(ctx context.Context, left, right tree.Datum) (tree.Datum, error) {
	if left == tree.DNull || right == tree.DNull {
		return tree.DNull, nil
	}
	d, err := eval.BinaryOp(ctx, c.evalCtx, c.op, left, right)
	if d == tree.DNull || err != nil {
		return d, err
	}
	b, ok := d.(*tree.DBool)
	if !ok {
		return nil, errors.AssertionFailedf("%v is %T and not *DBool", d, d)
	}
	result := tree.MakeDBool(!*b)
	return result, nil
}

type cmpFlippedExprAdapter struct {
	cmpExprAdapterBase
}

var _ ComparisonExprAdapter = &cmpFlippedExprAdapter{}

func (c *cmpFlippedExprAdapter) Eval(ctx context.Context, left, right tree.Datum) (tree.Datum, error) {
	if left == tree.DNull || right == tree.DNull {
		return tree.DNull, nil
	}
	left, right = right, left
	d, err := eval.BinaryOp(ctx, c.evalCtx, c.op, left, right)
	if d == tree.DNull || err != nil {
		return d, err
	}
	b, ok := d.(*tree.DBool)
	if !ok {
		return nil, errors.AssertionFailedf("%v is %T and not *DBool", d, d)
	}
	result := tree.MakeDBool(*b)
	return result, nil
}

type cmpFlippedNegateExprAdapter struct {
	cmpExprAdapterBase
}

var _ ComparisonExprAdapter = &cmpFlippedNegateExprAdapter{}

func (c *cmpFlippedNegateExprAdapter) Eval(ctx context.Context, left, right tree.Datum) (tree.Datum, error) {
	if left == tree.DNull || right == tree.DNull {
		return tree.DNull, nil
	}
	left, right = right, left
	d, err := eval.BinaryOp(ctx, c.evalCtx, c.op, left, right)
	if d == tree.DNull || err != nil {
		return d, err
	}
	b, ok := d.(*tree.DBool)
	if !ok {
		return nil, errors.AssertionFailedf("%v is %T and not *DBool", d, d)
	}
	result := tree.MakeDBool(!*b)
	return result, nil
}

type cmpNullableExprAdapter struct {
	cmpExprAdapterBase
}

var _ ComparisonExprAdapter = &cmpNullableExprAdapter{}

func (c *cmpNullableExprAdapter) Eval(ctx context.Context, left, right tree.Datum) (tree.Datum, error) {
	d, err := eval.BinaryOp(ctx, c.evalCtx, c.op, left, right)
	if d == tree.DNull || err != nil {
		return d, err
	}
	b, ok := d.(*tree.DBool)
	if !ok {
		return nil, errors.AssertionFailedf("%v is %T and not *DBool", d, d)
	}
	result := tree.MakeDBool(*b)
	return result, nil
}

type cmpNullableNegateExprAdapter struct {
	cmpExprAdapterBase
}

var _ ComparisonExprAdapter = &cmpNullableNegateExprAdapter{}

func (c *cmpNullableNegateExprAdapter) Eval(ctx context.Context, left, right tree.Datum) (tree.Datum, error) {
	d, err := eval.BinaryOp(ctx, c.evalCtx, c.op, left, right)
	if d == tree.DNull || err != nil {
		return d, err
	}
	b, ok := d.(*tree.DBool)
	if !ok {
		return nil, errors.AssertionFailedf("%v is %T and not *DBool", d, d)
	}
	result := tree.MakeDBool(!*b)
	return result, nil
}

type cmpNullableFlippedExprAdapter struct {
	cmpExprAdapterBase
}

var _ ComparisonExprAdapter = &cmpNullableFlippedExprAdapter{}

func (c *cmpNullableFlippedExprAdapter) Eval(ctx context.Context, left, right tree.Datum) (tree.Datum, error) {
	left, right = right, left
	d, err := eval.BinaryOp(ctx, c.evalCtx, c.op, left, right)
	if d == tree.DNull || err != nil {
		return d, err
	}
	b, ok := d.(*tree.DBool)
	if !ok {
		return nil, errors.AssertionFailedf("%v is %T and not *DBool", d, d)
	}
	result := tree.MakeDBool(*b)
	return result, nil
}

type cmpNullableFlippedNegateExprAdapter struct {
	cmpExprAdapterBase
}

var _ ComparisonExprAdapter = &cmpNullableFlippedNegateExprAdapter{}

func (c *cmpNullableFlippedNegateExprAdapter) Eval(ctx context.Context, left, right tree.Datum) (tree.Datum, error) {
	left, right = right, left
	d, err := eval.BinaryOp(ctx, c.evalCtx, c.op, left, right)
	if d == tree.DNull || err != nil {
		return d, err
	}
	b, ok := d.(*tree.DBool)
	if !ok {
		return nil, errors.AssertionFailedf("%v is %T and not *DBool", d, d)
	}
	result := tree.MakeDBool(!*b)
	return result, nil
}

type cmpWithSubOperatorExprAdapter struct {
	cmpExprAdapterBase
	expr *tree.ComparisonExpr
}

var _ ComparisonExprAdapter = &cmpWithSubOperatorExprAdapter{}

func (c *cmpWithSubOperatorExprAdapter) Eval(
	ctx context.Context, left, right tree.Datum,
) (tree.Datum, error) {
	return eval.ComparisonExprWithSubOperator(ctx, c.evalCtx, c.expr, left, right)
}
