// Code generated by execgen; DO NOT EDIT.

// Copyright 2018 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecbase

import (
	"bytes"
	"context"
	"math"
	"time"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecop"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/cockroach/pkg/util/json"
	"github.com/cockroachdb/errors"
)

func newSingleDistinct(
	input colexecop.Operator, distinctColIdx int, outputCol []bool, t *types.T, nullsAreDistinct bool,
) colexecop.Operator {
	switch typeconv.TypeFamilyToCanonicalTypeFamily(t.Family()) {
	case types.BoolFamily:
		switch t.Width() {
		case -1:
		default:
			return &distinctBoolOp{
				OneInputHelper:   colexecop.MakeOneInputHelper(input),
				distinctColIdx:   distinctColIdx,
				outputCol:        outputCol,
				nullsAreDistinct: nullsAreDistinct,
			}
		}
	case types.BytesFamily:
		switch t.Width() {
		case -1:
		default:
			return &distinctBytesOp{
				OneInputHelper:   colexecop.MakeOneInputHelper(input),
				distinctColIdx:   distinctColIdx,
				outputCol:        outputCol,
				nullsAreDistinct: nullsAreDistinct,
			}
		}
	case types.DecimalFamily:
		switch t.Width() {
		case -1:
		default:
			return &distinctDecimalOp{
				OneInputHelper:   colexecop.MakeOneInputHelper(input),
				distinctColIdx:   distinctColIdx,
				outputCol:        outputCol,
				nullsAreDistinct: nullsAreDistinct,
			}
		}
	case types.IntFamily:
		switch t.Width() {
		case 16:
			return &distinctInt16Op{
				OneInputHelper:   colexecop.MakeOneInputHelper(input),
				distinctColIdx:   distinctColIdx,
				outputCol:        outputCol,
				nullsAreDistinct: nullsAreDistinct,
			}
		case 32:
			return &distinctInt32Op{
				OneInputHelper:   colexecop.MakeOneInputHelper(input),
				distinctColIdx:   distinctColIdx,
				outputCol:        outputCol,
				nullsAreDistinct: nullsAreDistinct,
			}
		case -1:
		default:
			return &distinctInt64Op{
				OneInputHelper:   colexecop.MakeOneInputHelper(input),
				distinctColIdx:   distinctColIdx,
				outputCol:        outputCol,
				nullsAreDistinct: nullsAreDistinct,
			}
		}
	case types.FloatFamily:
		switch t.Width() {
		case -1:
		default:
			return &distinctFloat64Op{
				OneInputHelper:   colexecop.MakeOneInputHelper(input),
				distinctColIdx:   distinctColIdx,
				outputCol:        outputCol,
				nullsAreDistinct: nullsAreDistinct,
			}
		}
	case types.TimestampTZFamily:
		switch t.Width() {
		case -1:
		default:
			return &distinctTimestampOp{
				OneInputHelper:   colexecop.MakeOneInputHelper(input),
				distinctColIdx:   distinctColIdx,
				outputCol:        outputCol,
				nullsAreDistinct: nullsAreDistinct,
			}
		}
	case types.IntervalFamily:
		switch t.Width() {
		case -1:
		default:
			return &distinctIntervalOp{
				OneInputHelper:   colexecop.MakeOneInputHelper(input),
				distinctColIdx:   distinctColIdx,
				outputCol:        outputCol,
				nullsAreDistinct: nullsAreDistinct,
			}
		}
	case types.JsonFamily:
		switch t.Width() {
		case -1:
		default:
			return &distinctJSONOp{
				OneInputHelper:   colexecop.MakeOneInputHelper(input),
				distinctColIdx:   distinctColIdx,
				outputCol:        outputCol,
				nullsAreDistinct: nullsAreDistinct,
			}
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch t.Width() {
		case -1:
		default:
			return &distinctDatumOp{
				OneInputHelper:   colexecop.MakeOneInputHelper(input),
				distinctColIdx:   distinctColIdx,
				outputCol:        outputCol,
				nullsAreDistinct: nullsAreDistinct,
			}
		}
	}
	colexecerror.InternalError(errors.AssertionFailedf("unsupported type %s", t))
	// This code is unreachable, but the compiler cannot infer that.
	return nil
}

// distinctBoolOp runs a distinct on the column in distinctColIdx, writing
// true to the resultant bool column for every value that differs from the
// previous one.
type distinctBoolOp struct {
	colexecop.OneInputHelper

	// outputCol is the boolean output column. It is shared by all of the
	// other distinct operators in a distinct operator set.
	outputCol []bool

	// lastVal is the last value seen by the operator, so that the distincting
	// still works across batch boundaries.
	lastVal bool

	// distinctColIdx is the index of the column to distinct upon.
	distinctColIdx int

	// Set to true at runtime when we've seen the first row. Distinct always
	// outputs the first row that it sees.
	foundFirstRow bool

	lastValNull bool

	nullsAreDistinct bool
}

var _ colexecop.ResettableOperator = &distinctBoolOp{}

func (p *distinctBoolOp) Reset(ctx context.Context) {
	p.foundFirstRow = false
	p.lastValNull = false
	if resetter, ok := p.Input.(colexecop.Resetter); ok {
		resetter.Reset(ctx)
	}
}

func (p *distinctBoolOp) Next() coldata.Batch {
	batch := p.Input.Next()
	if batch.Length() == 0 {
		return batch
	}
	outputCol := p.outputCol
	vec := batch.ColVec(p.distinctColIdx)
	var nulls *coldata.Nulls
	if vec.MaybeHasNulls() {
		nulls = vec.Nulls()
	}
	col := vec.Bool()

	// We always output the first row.
	lastVal := p.lastVal
	lastValNull := p.lastValNull
	sel := batch.Selection()
	firstIdx := 0
	if sel != nil {
		firstIdx = sel[0]
	}
	if !p.foundFirstRow {
		outputCol[firstIdx] = true
		p.foundFirstRow = true
	} else if nulls == nil && lastValNull {
		// The last value of the previous batch was null, so the first value of this
		// non-null batch is distinct.
		outputCol[firstIdx] = true
		lastValNull = false
	}

	n := batch.Length()
	if sel != nil {
		sel = sel[:n]
		if nulls != nil {
			for _, idx := range sel {
				{
					var (
						__retval_lastVal     bool
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								outputCol[outputIdx] = true
							}
						} else {
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									if !v && lastVal {
										cmpResult = -1
									} else if v && !lastVal {
										cmpResult = 1
									} else {
										cmpResult = 0
									}

									unique = cmpResult != 0
								}

								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for _, idx := range sel {
				{
					var __retval_0 bool
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							if !v && lastVal {
								cmpResult = -1
							} else if v && !lastVal {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							unique = cmpResult != 0
						}

						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	} else {
		// Eliminate bounds checks for outputCol[idx].
		_ = outputCol[n-1]
		// Eliminate bounds checks for col[idx].
		_ = col.Get(n - 1)
		if nulls != nil {
			for idx := 0; idx < n; idx++ {
				{
					var (
						__retval_lastVal     bool
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							}
						} else {
							//gcassert:bce
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									if !v && lastVal {
										cmpResult = -1
									} else if v && !lastVal {
										cmpResult = 1
									} else {
										cmpResult = 0
									}

									unique = cmpResult != 0
								}

								//gcassert:bce
								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for idx := 0; idx < n; idx++ {
				{
					var __retval_0 bool
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						//gcassert:bce
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							if !v && lastVal {
								cmpResult = -1
							} else if v && !lastVal {
								cmpResult = 1
							} else {
								cmpResult = 0
							}

							unique = cmpResult != 0
						}

						//gcassert:bce
						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	}

	if !lastValNull {
		// We need to perform a deep copy for the next iteration if we didn't have
		// a null value.
		p.lastVal = lastVal
	}
	p.lastValNull = lastValNull

	return batch
}

// distinctBytesOp runs a distinct on the column in distinctColIdx, writing
// true to the resultant bool column for every value that differs from the
// previous one.
type distinctBytesOp struct {
	colexecop.OneInputHelper

	// outputCol is the boolean output column. It is shared by all of the
	// other distinct operators in a distinct operator set.
	outputCol []bool

	// lastVal is the last value seen by the operator, so that the distincting
	// still works across batch boundaries.
	lastVal []byte

	// distinctColIdx is the index of the column to distinct upon.
	distinctColIdx int

	// Set to true at runtime when we've seen the first row. Distinct always
	// outputs the first row that it sees.
	foundFirstRow bool

	lastValNull bool

	nullsAreDistinct bool
}

var _ colexecop.ResettableOperator = &distinctBytesOp{}

func (p *distinctBytesOp) Reset(ctx context.Context) {
	p.foundFirstRow = false
	p.lastValNull = false
	if resetter, ok := p.Input.(colexecop.Resetter); ok {
		resetter.Reset(ctx)
	}
}

func (p *distinctBytesOp) Next() coldata.Batch {
	batch := p.Input.Next()
	if batch.Length() == 0 {
		return batch
	}
	outputCol := p.outputCol
	vec := batch.ColVec(p.distinctColIdx)
	var nulls *coldata.Nulls
	if vec.MaybeHasNulls() {
		nulls = vec.Nulls()
	}
	col := vec.Bytes()

	// We always output the first row.
	lastVal := p.lastVal
	lastValNull := p.lastValNull
	sel := batch.Selection()
	firstIdx := 0
	if sel != nil {
		firstIdx = sel[0]
	}
	if !p.foundFirstRow {
		outputCol[firstIdx] = true
		p.foundFirstRow = true
	} else if nulls == nil && lastValNull {
		// The last value of the previous batch was null, so the first value of this
		// non-null batch is distinct.
		outputCol[firstIdx] = true
		lastValNull = false
	}

	n := batch.Length()
	if sel != nil {
		sel = sel[:n]
		if nulls != nil {
			for _, idx := range sel {
				{
					var (
						__retval_lastVal     []byte
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								outputCol[outputIdx] = true
							}
						} else {
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int
									cmpResult = bytes.Compare(v, lastVal)
									unique = cmpResult != 0
								}

								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for _, idx := range sel {
				{
					var __retval_0 []byte
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int
							cmpResult = bytes.Compare(v, lastVal)
							unique = cmpResult != 0
						}

						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	} else {
		// Eliminate bounds checks for outputCol[idx].
		_ = outputCol[n-1]
		if nulls != nil {
			for idx := 0; idx < n; idx++ {
				{
					var (
						__retval_lastVal     []byte
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							}
						} else {
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int
									cmpResult = bytes.Compare(v, lastVal)
									unique = cmpResult != 0
								}

								//gcassert:bce
								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for idx := 0; idx < n; idx++ {
				{
					var __retval_0 []byte
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int
							cmpResult = bytes.Compare(v, lastVal)
							unique = cmpResult != 0
						}

						//gcassert:bce
						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	}

	if !lastValNull {
		// We need to perform a deep copy for the next iteration if we didn't have
		// a null value.
		p.lastVal = append(p.lastVal[:0], lastVal...)
	}
	p.lastValNull = lastValNull

	return batch
}

// distinctDecimalOp runs a distinct on the column in distinctColIdx, writing
// true to the resultant bool column for every value that differs from the
// previous one.
type distinctDecimalOp struct {
	colexecop.OneInputHelper

	// outputCol is the boolean output column. It is shared by all of the
	// other distinct operators in a distinct operator set.
	outputCol []bool

	// lastVal is the last value seen by the operator, so that the distincting
	// still works across batch boundaries.
	lastVal apd.Decimal

	// distinctColIdx is the index of the column to distinct upon.
	distinctColIdx int

	// Set to true at runtime when we've seen the first row. Distinct always
	// outputs the first row that it sees.
	foundFirstRow bool

	lastValNull bool

	nullsAreDistinct bool
}

var _ colexecop.ResettableOperator = &distinctDecimalOp{}

func (p *distinctDecimalOp) Reset(ctx context.Context) {
	p.foundFirstRow = false
	p.lastValNull = false
	if resetter, ok := p.Input.(colexecop.Resetter); ok {
		resetter.Reset(ctx)
	}
}

func (p *distinctDecimalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	if batch.Length() == 0 {
		return batch
	}
	outputCol := p.outputCol
	vec := batch.ColVec(p.distinctColIdx)
	var nulls *coldata.Nulls
	if vec.MaybeHasNulls() {
		nulls = vec.Nulls()
	}
	col := vec.Decimal()

	// We always output the first row.
	lastVal := p.lastVal
	lastValNull := p.lastValNull
	sel := batch.Selection()
	firstIdx := 0
	if sel != nil {
		firstIdx = sel[0]
	}
	if !p.foundFirstRow {
		outputCol[firstIdx] = true
		p.foundFirstRow = true
	} else if nulls == nil && lastValNull {
		// The last value of the previous batch was null, so the first value of this
		// non-null batch is distinct.
		outputCol[firstIdx] = true
		lastValNull = false
	}

	n := batch.Length()
	if sel != nil {
		sel = sel[:n]
		if nulls != nil {
			for _, idx := range sel {
				{
					var (
						__retval_lastVal     apd.Decimal
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								outputCol[outputIdx] = true
							}
						} else {
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int
									cmpResult = tree.CompareDecimals(&v, &lastVal)
									unique = cmpResult != 0
								}

								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for _, idx := range sel {
				{
					var __retval_0 apd.Decimal
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&v, &lastVal)
							unique = cmpResult != 0
						}

						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	} else {
		// Eliminate bounds checks for outputCol[idx].
		_ = outputCol[n-1]
		// Eliminate bounds checks for col[idx].
		_ = col.Get(n - 1)
		if nulls != nil {
			for idx := 0; idx < n; idx++ {
				{
					var (
						__retval_lastVal     apd.Decimal
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							}
						} else {
							//gcassert:bce
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int
									cmpResult = tree.CompareDecimals(&v, &lastVal)
									unique = cmpResult != 0
								}

								//gcassert:bce
								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for idx := 0; idx < n; idx++ {
				{
					var __retval_0 apd.Decimal
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						//gcassert:bce
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int
							cmpResult = tree.CompareDecimals(&v, &lastVal)
							unique = cmpResult != 0
						}

						//gcassert:bce
						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	}

	if !lastValNull {
		// We need to perform a deep copy for the next iteration if we didn't have
		// a null value.
		p.lastVal.Set(&lastVal)
	}
	p.lastValNull = lastValNull

	return batch
}

// distinctInt16Op runs a distinct on the column in distinctColIdx, writing
// true to the resultant bool column for every value that differs from the
// previous one.
type distinctInt16Op struct {
	colexecop.OneInputHelper

	// outputCol is the boolean output column. It is shared by all of the
	// other distinct operators in a distinct operator set.
	outputCol []bool

	// lastVal is the last value seen by the operator, so that the distincting
	// still works across batch boundaries.
	lastVal int16

	// distinctColIdx is the index of the column to distinct upon.
	distinctColIdx int

	// Set to true at runtime when we've seen the first row. Distinct always
	// outputs the first row that it sees.
	foundFirstRow bool

	lastValNull bool

	nullsAreDistinct bool
}

var _ colexecop.ResettableOperator = &distinctInt16Op{}

func (p *distinctInt16Op) Reset(ctx context.Context) {
	p.foundFirstRow = false
	p.lastValNull = false
	if resetter, ok := p.Input.(colexecop.Resetter); ok {
		resetter.Reset(ctx)
	}
}

func (p *distinctInt16Op) Next() coldata.Batch {
	batch := p.Input.Next()
	if batch.Length() == 0 {
		return batch
	}
	outputCol := p.outputCol
	vec := batch.ColVec(p.distinctColIdx)
	var nulls *coldata.Nulls
	if vec.MaybeHasNulls() {
		nulls = vec.Nulls()
	}
	col := vec.Int16()

	// We always output the first row.
	lastVal := p.lastVal
	lastValNull := p.lastValNull
	sel := batch.Selection()
	firstIdx := 0
	if sel != nil {
		firstIdx = sel[0]
	}
	if !p.foundFirstRow {
		outputCol[firstIdx] = true
		p.foundFirstRow = true
	} else if nulls == nil && lastValNull {
		// The last value of the previous batch was null, so the first value of this
		// non-null batch is distinct.
		outputCol[firstIdx] = true
		lastValNull = false
	}

	n := batch.Length()
	if sel != nil {
		sel = sel[:n]
		if nulls != nil {
			for _, idx := range sel {
				{
					var (
						__retval_lastVal     int16
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								outputCol[outputIdx] = true
							}
						} else {
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(v), int64(lastVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for _, idx := range sel {
				{
					var __retval_0 int16
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							{
								a, b := int64(v), int64(lastVal)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							unique = cmpResult != 0
						}

						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	} else {
		// Eliminate bounds checks for outputCol[idx].
		_ = outputCol[n-1]
		// Eliminate bounds checks for col[idx].
		_ = col.Get(n - 1)
		if nulls != nil {
			for idx := 0; idx < n; idx++ {
				{
					var (
						__retval_lastVal     int16
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							}
						} else {
							//gcassert:bce
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(v), int64(lastVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								//gcassert:bce
								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for idx := 0; idx < n; idx++ {
				{
					var __retval_0 int16
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						//gcassert:bce
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							{
								a, b := int64(v), int64(lastVal)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							unique = cmpResult != 0
						}

						//gcassert:bce
						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	}

	if !lastValNull {
		// We need to perform a deep copy for the next iteration if we didn't have
		// a null value.
		p.lastVal = lastVal
	}
	p.lastValNull = lastValNull

	return batch
}

// distinctInt32Op runs a distinct on the column in distinctColIdx, writing
// true to the resultant bool column for every value that differs from the
// previous one.
type distinctInt32Op struct {
	colexecop.OneInputHelper

	// outputCol is the boolean output column. It is shared by all of the
	// other distinct operators in a distinct operator set.
	outputCol []bool

	// lastVal is the last value seen by the operator, so that the distincting
	// still works across batch boundaries.
	lastVal int32

	// distinctColIdx is the index of the column to distinct upon.
	distinctColIdx int

	// Set to true at runtime when we've seen the first row. Distinct always
	// outputs the first row that it sees.
	foundFirstRow bool

	lastValNull bool

	nullsAreDistinct bool
}

var _ colexecop.ResettableOperator = &distinctInt32Op{}

func (p *distinctInt32Op) Reset(ctx context.Context) {
	p.foundFirstRow = false
	p.lastValNull = false
	if resetter, ok := p.Input.(colexecop.Resetter); ok {
		resetter.Reset(ctx)
	}
}

func (p *distinctInt32Op) Next() coldata.Batch {
	batch := p.Input.Next()
	if batch.Length() == 0 {
		return batch
	}
	outputCol := p.outputCol
	vec := batch.ColVec(p.distinctColIdx)
	var nulls *coldata.Nulls
	if vec.MaybeHasNulls() {
		nulls = vec.Nulls()
	}
	col := vec.Int32()

	// We always output the first row.
	lastVal := p.lastVal
	lastValNull := p.lastValNull
	sel := batch.Selection()
	firstIdx := 0
	if sel != nil {
		firstIdx = sel[0]
	}
	if !p.foundFirstRow {
		outputCol[firstIdx] = true
		p.foundFirstRow = true
	} else if nulls == nil && lastValNull {
		// The last value of the previous batch was null, so the first value of this
		// non-null batch is distinct.
		outputCol[firstIdx] = true
		lastValNull = false
	}

	n := batch.Length()
	if sel != nil {
		sel = sel[:n]
		if nulls != nil {
			for _, idx := range sel {
				{
					var (
						__retval_lastVal     int32
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								outputCol[outputIdx] = true
							}
						} else {
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(v), int64(lastVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for _, idx := range sel {
				{
					var __retval_0 int32
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							{
								a, b := int64(v), int64(lastVal)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							unique = cmpResult != 0
						}

						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	} else {
		// Eliminate bounds checks for outputCol[idx].
		_ = outputCol[n-1]
		// Eliminate bounds checks for col[idx].
		_ = col.Get(n - 1)
		if nulls != nil {
			for idx := 0; idx < n; idx++ {
				{
					var (
						__retval_lastVal     int32
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							}
						} else {
							//gcassert:bce
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(v), int64(lastVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								//gcassert:bce
								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for idx := 0; idx < n; idx++ {
				{
					var __retval_0 int32
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						//gcassert:bce
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							{
								a, b := int64(v), int64(lastVal)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							unique = cmpResult != 0
						}

						//gcassert:bce
						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	}

	if !lastValNull {
		// We need to perform a deep copy for the next iteration if we didn't have
		// a null value.
		p.lastVal = lastVal
	}
	p.lastValNull = lastValNull

	return batch
}

// distinctInt64Op runs a distinct on the column in distinctColIdx, writing
// true to the resultant bool column for every value that differs from the
// previous one.
type distinctInt64Op struct {
	colexecop.OneInputHelper

	// outputCol is the boolean output column. It is shared by all of the
	// other distinct operators in a distinct operator set.
	outputCol []bool

	// lastVal is the last value seen by the operator, so that the distincting
	// still works across batch boundaries.
	lastVal int64

	// distinctColIdx is the index of the column to distinct upon.
	distinctColIdx int

	// Set to true at runtime when we've seen the first row. Distinct always
	// outputs the first row that it sees.
	foundFirstRow bool

	lastValNull bool

	nullsAreDistinct bool
}

var _ colexecop.ResettableOperator = &distinctInt64Op{}

func (p *distinctInt64Op) Reset(ctx context.Context) {
	p.foundFirstRow = false
	p.lastValNull = false
	if resetter, ok := p.Input.(colexecop.Resetter); ok {
		resetter.Reset(ctx)
	}
}

func (p *distinctInt64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	if batch.Length() == 0 {
		return batch
	}
	outputCol := p.outputCol
	vec := batch.ColVec(p.distinctColIdx)
	var nulls *coldata.Nulls
	if vec.MaybeHasNulls() {
		nulls = vec.Nulls()
	}
	col := vec.Int64()

	// We always output the first row.
	lastVal := p.lastVal
	lastValNull := p.lastValNull
	sel := batch.Selection()
	firstIdx := 0
	if sel != nil {
		firstIdx = sel[0]
	}
	if !p.foundFirstRow {
		outputCol[firstIdx] = true
		p.foundFirstRow = true
	} else if nulls == nil && lastValNull {
		// The last value of the previous batch was null, so the first value of this
		// non-null batch is distinct.
		outputCol[firstIdx] = true
		lastValNull = false
	}

	n := batch.Length()
	if sel != nil {
		sel = sel[:n]
		if nulls != nil {
			for _, idx := range sel {
				{
					var (
						__retval_lastVal     int64
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								outputCol[outputIdx] = true
							}
						} else {
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(v), int64(lastVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for _, idx := range sel {
				{
					var __retval_0 int64
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							{
								a, b := int64(v), int64(lastVal)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							unique = cmpResult != 0
						}

						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	} else {
		// Eliminate bounds checks for outputCol[idx].
		_ = outputCol[n-1]
		// Eliminate bounds checks for col[idx].
		_ = col.Get(n - 1)
		if nulls != nil {
			for idx := 0; idx < n; idx++ {
				{
					var (
						__retval_lastVal     int64
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							}
						} else {
							//gcassert:bce
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									{
										a, b := int64(v), int64(lastVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else {
											cmpResult = 0
										}
									}

									unique = cmpResult != 0
								}

								//gcassert:bce
								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for idx := 0; idx < n; idx++ {
				{
					var __retval_0 int64
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						//gcassert:bce
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							{
								a, b := int64(v), int64(lastVal)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
							}

							unique = cmpResult != 0
						}

						//gcassert:bce
						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	}

	if !lastValNull {
		// We need to perform a deep copy for the next iteration if we didn't have
		// a null value.
		p.lastVal = lastVal
	}
	p.lastValNull = lastValNull

	return batch
}

// distinctFloat64Op runs a distinct on the column in distinctColIdx, writing
// true to the resultant bool column for every value that differs from the
// previous one.
type distinctFloat64Op struct {
	colexecop.OneInputHelper

	// outputCol is the boolean output column. It is shared by all of the
	// other distinct operators in a distinct operator set.
	outputCol []bool

	// lastVal is the last value seen by the operator, so that the distincting
	// still works across batch boundaries.
	lastVal float64

	// distinctColIdx is the index of the column to distinct upon.
	distinctColIdx int

	// Set to true at runtime when we've seen the first row. Distinct always
	// outputs the first row that it sees.
	foundFirstRow bool

	lastValNull bool

	nullsAreDistinct bool
}

var _ colexecop.ResettableOperator = &distinctFloat64Op{}

func (p *distinctFloat64Op) Reset(ctx context.Context) {
	p.foundFirstRow = false
	p.lastValNull = false
	if resetter, ok := p.Input.(colexecop.Resetter); ok {
		resetter.Reset(ctx)
	}
}

func (p *distinctFloat64Op) Next() coldata.Batch {
	batch := p.Input.Next()
	if batch.Length() == 0 {
		return batch
	}
	outputCol := p.outputCol
	vec := batch.ColVec(p.distinctColIdx)
	var nulls *coldata.Nulls
	if vec.MaybeHasNulls() {
		nulls = vec.Nulls()
	}
	col := vec.Float64()

	// We always output the first row.
	lastVal := p.lastVal
	lastValNull := p.lastValNull
	sel := batch.Selection()
	firstIdx := 0
	if sel != nil {
		firstIdx = sel[0]
	}
	if !p.foundFirstRow {
		outputCol[firstIdx] = true
		p.foundFirstRow = true
	} else if nulls == nil && lastValNull {
		// The last value of the previous batch was null, so the first value of this
		// non-null batch is distinct.
		outputCol[firstIdx] = true
		lastValNull = false
	}

	n := batch.Length()
	if sel != nil {
		sel = sel[:n]
		if nulls != nil {
			for _, idx := range sel {
				{
					var (
						__retval_lastVal     float64
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								outputCol[outputIdx] = true
							}
						} else {
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									{
										a, b := float64(v), float64(lastVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else if a == b {
											cmpResult = 0
										} else if math.IsNaN(a) {
											if math.IsNaN(b) {
												cmpResult = 0
											} else {
												cmpResult = -1
											}
										} else {
											cmpResult = 1
										}
									}

									unique = cmpResult != 0
								}

								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for _, idx := range sel {
				{
					var __retval_0 float64
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							{
								a, b := float64(v), float64(lastVal)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							unique = cmpResult != 0
						}

						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	} else {
		// Eliminate bounds checks for outputCol[idx].
		_ = outputCol[n-1]
		// Eliminate bounds checks for col[idx].
		_ = col.Get(n - 1)
		if nulls != nil {
			for idx := 0; idx < n; idx++ {
				{
					var (
						__retval_lastVal     float64
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							}
						} else {
							//gcassert:bce
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									{
										a, b := float64(v), float64(lastVal)
										if a < b {
											cmpResult = -1
										} else if a > b {
											cmpResult = 1
										} else if a == b {
											cmpResult = 0
										} else if math.IsNaN(a) {
											if math.IsNaN(b) {
												cmpResult = 0
											} else {
												cmpResult = -1
											}
										} else {
											cmpResult = 1
										}
									}

									unique = cmpResult != 0
								}

								//gcassert:bce
								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for idx := 0; idx < n; idx++ {
				{
					var __retval_0 float64
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						//gcassert:bce
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							{
								a, b := float64(v), float64(lastVal)
								if a < b {
									cmpResult = -1
								} else if a > b {
									cmpResult = 1
								} else if a == b {
									cmpResult = 0
								} else if math.IsNaN(a) {
									if math.IsNaN(b) {
										cmpResult = 0
									} else {
										cmpResult = -1
									}
								} else {
									cmpResult = 1
								}
							}

							unique = cmpResult != 0
						}

						//gcassert:bce
						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	}

	if !lastValNull {
		// We need to perform a deep copy for the next iteration if we didn't have
		// a null value.
		p.lastVal = lastVal
	}
	p.lastValNull = lastValNull

	return batch
}

// distinctTimestampOp runs a distinct on the column in distinctColIdx, writing
// true to the resultant bool column for every value that differs from the
// previous one.
type distinctTimestampOp struct {
	colexecop.OneInputHelper

	// outputCol is the boolean output column. It is shared by all of the
	// other distinct operators in a distinct operator set.
	outputCol []bool

	// lastVal is the last value seen by the operator, so that the distincting
	// still works across batch boundaries.
	lastVal time.Time

	// distinctColIdx is the index of the column to distinct upon.
	distinctColIdx int

	// Set to true at runtime when we've seen the first row. Distinct always
	// outputs the first row that it sees.
	foundFirstRow bool

	lastValNull bool

	nullsAreDistinct bool
}

var _ colexecop.ResettableOperator = &distinctTimestampOp{}

func (p *distinctTimestampOp) Reset(ctx context.Context) {
	p.foundFirstRow = false
	p.lastValNull = false
	if resetter, ok := p.Input.(colexecop.Resetter); ok {
		resetter.Reset(ctx)
	}
}

func (p *distinctTimestampOp) Next() coldata.Batch {
	batch := p.Input.Next()
	if batch.Length() == 0 {
		return batch
	}
	outputCol := p.outputCol
	vec := batch.ColVec(p.distinctColIdx)
	var nulls *coldata.Nulls
	if vec.MaybeHasNulls() {
		nulls = vec.Nulls()
	}
	col := vec.Timestamp()

	// We always output the first row.
	lastVal := p.lastVal
	lastValNull := p.lastValNull
	sel := batch.Selection()
	firstIdx := 0
	if sel != nil {
		firstIdx = sel[0]
	}
	if !p.foundFirstRow {
		outputCol[firstIdx] = true
		p.foundFirstRow = true
	} else if nulls == nil && lastValNull {
		// The last value of the previous batch was null, so the first value of this
		// non-null batch is distinct.
		outputCol[firstIdx] = true
		lastValNull = false
	}

	n := batch.Length()
	if sel != nil {
		sel = sel[:n]
		if nulls != nil {
			for _, idx := range sel {
				{
					var (
						__retval_lastVal     time.Time
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								outputCol[outputIdx] = true
							}
						} else {
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									if v.Before(lastVal) {
										cmpResult = -1
									} else if lastVal.Before(v) {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
									unique = cmpResult != 0
								}

								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for _, idx := range sel {
				{
					var __retval_0 time.Time
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							if v.Before(lastVal) {
								cmpResult = -1
							} else if lastVal.Before(v) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							unique = cmpResult != 0
						}

						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	} else {
		// Eliminate bounds checks for outputCol[idx].
		_ = outputCol[n-1]
		// Eliminate bounds checks for col[idx].
		_ = col.Get(n - 1)
		if nulls != nil {
			for idx := 0; idx < n; idx++ {
				{
					var (
						__retval_lastVal     time.Time
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							}
						} else {
							//gcassert:bce
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									if v.Before(lastVal) {
										cmpResult = -1
									} else if lastVal.Before(v) {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
									unique = cmpResult != 0
								}

								//gcassert:bce
								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for idx := 0; idx < n; idx++ {
				{
					var __retval_0 time.Time
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						//gcassert:bce
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							if v.Before(lastVal) {
								cmpResult = -1
							} else if lastVal.Before(v) {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
							unique = cmpResult != 0
						}

						//gcassert:bce
						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	}

	if !lastValNull {
		// We need to perform a deep copy for the next iteration if we didn't have
		// a null value.
		p.lastVal = lastVal
	}
	p.lastValNull = lastValNull

	return batch
}

// distinctIntervalOp runs a distinct on the column in distinctColIdx, writing
// true to the resultant bool column for every value that differs from the
// previous one.
type distinctIntervalOp struct {
	colexecop.OneInputHelper

	// outputCol is the boolean output column. It is shared by all of the
	// other distinct operators in a distinct operator set.
	outputCol []bool

	// lastVal is the last value seen by the operator, so that the distincting
	// still works across batch boundaries.
	lastVal duration.Duration

	// distinctColIdx is the index of the column to distinct upon.
	distinctColIdx int

	// Set to true at runtime when we've seen the first row. Distinct always
	// outputs the first row that it sees.
	foundFirstRow bool

	lastValNull bool

	nullsAreDistinct bool
}

var _ colexecop.ResettableOperator = &distinctIntervalOp{}

func (p *distinctIntervalOp) Reset(ctx context.Context) {
	p.foundFirstRow = false
	p.lastValNull = false
	if resetter, ok := p.Input.(colexecop.Resetter); ok {
		resetter.Reset(ctx)
	}
}

func (p *distinctIntervalOp) Next() coldata.Batch {
	batch := p.Input.Next()
	if batch.Length() == 0 {
		return batch
	}
	outputCol := p.outputCol
	vec := batch.ColVec(p.distinctColIdx)
	var nulls *coldata.Nulls
	if vec.MaybeHasNulls() {
		nulls = vec.Nulls()
	}
	col := vec.Interval()

	// We always output the first row.
	lastVal := p.lastVal
	lastValNull := p.lastValNull
	sel := batch.Selection()
	firstIdx := 0
	if sel != nil {
		firstIdx = sel[0]
	}
	if !p.foundFirstRow {
		outputCol[firstIdx] = true
		p.foundFirstRow = true
	} else if nulls == nil && lastValNull {
		// The last value of the previous batch was null, so the first value of this
		// non-null batch is distinct.
		outputCol[firstIdx] = true
		lastValNull = false
	}

	n := batch.Length()
	if sel != nil {
		sel = sel[:n]
		if nulls != nil {
			for _, idx := range sel {
				{
					var (
						__retval_lastVal     duration.Duration
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								outputCol[outputIdx] = true
							}
						} else {
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int
									cmpResult = v.Compare(lastVal)
									unique = cmpResult != 0
								}

								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for _, idx := range sel {
				{
					var __retval_0 duration.Duration
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int
							cmpResult = v.Compare(lastVal)
							unique = cmpResult != 0
						}

						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	} else {
		// Eliminate bounds checks for outputCol[idx].
		_ = outputCol[n-1]
		// Eliminate bounds checks for col[idx].
		_ = col.Get(n - 1)
		if nulls != nil {
			for idx := 0; idx < n; idx++ {
				{
					var (
						__retval_lastVal     duration.Duration
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							}
						} else {
							//gcassert:bce
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int
									cmpResult = v.Compare(lastVal)
									unique = cmpResult != 0
								}

								//gcassert:bce
								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for idx := 0; idx < n; idx++ {
				{
					var __retval_0 duration.Duration
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						//gcassert:bce
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int
							cmpResult = v.Compare(lastVal)
							unique = cmpResult != 0
						}

						//gcassert:bce
						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	}

	if !lastValNull {
		// We need to perform a deep copy for the next iteration if we didn't have
		// a null value.
		p.lastVal = lastVal
	}
	p.lastValNull = lastValNull

	return batch
}

// distinctJSONOp runs a distinct on the column in distinctColIdx, writing
// true to the resultant bool column for every value that differs from the
// previous one.
type distinctJSONOp struct {
	colexecop.OneInputHelper

	// outputCol is the boolean output column. It is shared by all of the
	// other distinct operators in a distinct operator set.
	outputCol []bool

	// lastVal is the last value seen by the operator, so that the distincting
	// still works across batch boundaries.
	lastVal json.JSON

	// distinctColIdx is the index of the column to distinct upon.
	distinctColIdx int

	// Set to true at runtime when we've seen the first row. Distinct always
	// outputs the first row that it sees.
	foundFirstRow bool

	lastValNull bool

	nullsAreDistinct bool
}

var _ colexecop.ResettableOperator = &distinctJSONOp{}

func (p *distinctJSONOp) Reset(ctx context.Context) {
	p.foundFirstRow = false
	p.lastValNull = false
	if resetter, ok := p.Input.(colexecop.Resetter); ok {
		resetter.Reset(ctx)
	}
}

func (p *distinctJSONOp) Next() coldata.Batch {
	batch := p.Input.Next()
	if batch.Length() == 0 {
		return batch
	}
	outputCol := p.outputCol
	vec := batch.ColVec(p.distinctColIdx)
	var nulls *coldata.Nulls
	if vec.MaybeHasNulls() {
		nulls = vec.Nulls()
	}
	col := vec.JSON()

	// We always output the first row.
	lastVal := p.lastVal
	lastValNull := p.lastValNull
	sel := batch.Selection()
	firstIdx := 0
	if sel != nil {
		firstIdx = sel[0]
	}
	if !p.foundFirstRow {
		outputCol[firstIdx] = true
		p.foundFirstRow = true
	} else if nulls == nil && lastValNull {
		// The last value of the previous batch was null, so the first value of this
		// non-null batch is distinct.
		outputCol[firstIdx] = true
		lastValNull = false
	}

	n := batch.Length()
	if sel != nil {
		sel = sel[:n]
		if nulls != nil {
			for _, idx := range sel {
				{
					var (
						__retval_lastVal     json.JSON
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								outputCol[outputIdx] = true
							}
						} else {
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									var err error
									cmpResult, err = v.Compare(lastVal)
									if err != nil {
										colexecerror.ExpectedError(err)
									}

									unique = cmpResult != 0
								}

								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for _, idx := range sel {
				{
					var __retval_0 json.JSON
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							var err error
							cmpResult, err = v.Compare(lastVal)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							unique = cmpResult != 0
						}

						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	} else {
		// Eliminate bounds checks for outputCol[idx].
		_ = outputCol[n-1]
		if nulls != nil {
			for idx := 0; idx < n; idx++ {
				{
					var (
						__retval_lastVal     json.JSON
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							}
						} else {
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									var err error
									cmpResult, err = v.Compare(lastVal)
									if err != nil {
										colexecerror.ExpectedError(err)
									}

									unique = cmpResult != 0
								}

								//gcassert:bce
								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for idx := 0; idx < n; idx++ {
				{
					var __retval_0 json.JSON
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							var err error
							cmpResult, err = v.Compare(lastVal)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							unique = cmpResult != 0
						}

						//gcassert:bce
						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	}

	if !lastValNull {
		// We need to perform a deep copy for the next iteration if we didn't have
		// a null value.

		var _err error
		var _bytes []byte
		_bytes, _err = json.EncodeJSON(nil, lastVal)
		if _err != nil {
			colexecerror.ExpectedError(_err)
		}
		p.lastVal, _err = json.FromEncoding(_bytes)
		if _err != nil {
			colexecerror.ExpectedError(_err)
		}

	}
	p.lastValNull = lastValNull

	return batch
}

// distinctDatumOp runs a distinct on the column in distinctColIdx, writing
// true to the resultant bool column for every value that differs from the
// previous one.
type distinctDatumOp struct {
	colexecop.OneInputHelper

	// outputCol is the boolean output column. It is shared by all of the
	// other distinct operators in a distinct operator set.
	outputCol []bool

	// lastVal is the last value seen by the operator, so that the distincting
	// still works across batch boundaries.
	lastVal interface{}

	// distinctColIdx is the index of the column to distinct upon.
	distinctColIdx int

	// Set to true at runtime when we've seen the first row. Distinct always
	// outputs the first row that it sees.
	foundFirstRow bool

	lastValNull bool

	nullsAreDistinct bool
}

var _ colexecop.ResettableOperator = &distinctDatumOp{}

func (p *distinctDatumOp) Reset(ctx context.Context) {
	p.foundFirstRow = false
	p.lastValNull = false
	if resetter, ok := p.Input.(colexecop.Resetter); ok {
		resetter.Reset(ctx)
	}
}

func (p *distinctDatumOp) Next() coldata.Batch {
	batch := p.Input.Next()
	if batch.Length() == 0 {
		return batch
	}
	outputCol := p.outputCol
	vec := batch.ColVec(p.distinctColIdx)
	var nulls *coldata.Nulls
	if vec.MaybeHasNulls() {
		nulls = vec.Nulls()
	}
	col := vec.Datum()

	// We always output the first row.
	lastVal := p.lastVal
	lastValNull := p.lastValNull
	sel := batch.Selection()
	firstIdx := 0
	if sel != nil {
		firstIdx = sel[0]
	}
	if !p.foundFirstRow {
		outputCol[firstIdx] = true
		p.foundFirstRow = true
	} else if nulls == nil && lastValNull {
		// The last value of the previous batch was null, so the first value of this
		// non-null batch is distinct.
		outputCol[firstIdx] = true
		lastValNull = false
	}

	n := batch.Length()
	if sel != nil {
		sel = sel[:n]
		if nulls != nil {
			for _, idx := range sel {
				{
					var (
						__retval_lastVal     interface{}
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								outputCol[outputIdx] = true
							}
						} else {
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									cmpResult = coldataext.CompareDatum(v, col, lastVal)

									unique = cmpResult != 0
								}

								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for _, idx := range sel {
				{
					var __retval_0 interface{}
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(v, col, lastVal)

							unique = cmpResult != 0
						}

						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	} else {
		// Eliminate bounds checks for outputCol[idx].
		_ = outputCol[n-1]
		if nulls != nil {
			for idx := 0; idx < n; idx++ {
				{
					var (
						__retval_lastVal     interface{}
						__retval_lastValNull bool
					)
					{
						var (
							checkIdx         int  = idx
							outputIdx        int  = idx
							nullsAreDistinct bool = p.nullsAreDistinct
						)
						null := nulls.NullAt(checkIdx)
						if null {
							if !lastValNull || nullsAreDistinct {
								// The current value is null, and either the previous one is not
								// (meaning they are definitely distinct) or we treat nulls as
								// distinct values.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							}
						} else {
							v := col.Get(checkIdx)
							if lastValNull {
								// The previous value was null while the current is not.
								_ = true
								//gcassert:bce
								outputCol[outputIdx] = true
							} else {
								// Neither value is null, so we must compare.
								var unique bool

								{
									var cmpResult int

									cmpResult = coldataext.CompareDatum(v, col, lastVal)

									unique = cmpResult != 0
								}

								//gcassert:bce
								outputCol[outputIdx] = outputCol[outputIdx] || unique
							}
							lastVal = v
						}
						{
							__retval_lastVal = lastVal
							__retval_lastValNull = null
						}
					}
					lastVal, lastValNull = __retval_lastVal, __retval_lastValNull
				}
			}
		} else {
			for idx := 0; idx < n; idx++ {
				{
					var __retval_0 interface{}
					{
						var (
							checkIdx  int = idx
							outputIdx int = idx
						)
						v := col.Get(checkIdx)
						var unique bool

						{
							var cmpResult int

							cmpResult = coldataext.CompareDatum(v, col, lastVal)

							unique = cmpResult != 0
						}

						//gcassert:bce
						outputCol[outputIdx] = outputCol[outputIdx] || unique
						{
							__retval_0 = v
						}
					}
					lastVal = __retval_0
				}
			}
		}
	}

	if !lastValNull {
		// We need to perform a deep copy for the next iteration if we didn't have
		// a null value.
		p.lastVal = lastVal
	}
	p.lastValNull = lastValNull

	return batch
}
