// Code generated by execgen; DO NOT EDIT.
// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecbase

import (
	"bytes"
	"context"
	"math"
	"strconv"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexec/colexecutils"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecop"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
	"github.com/cockroachdb/cockroach/pkg/sql/lex"
	"github.com/cockroachdb/cockroach/pkg/sql/pgwire/pgcode"
	"github.com/cockroachdb/cockroach/pkg/sql/pgwire/pgerror"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/eval"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/cockroach/pkg/util/json"
	"github.com/cockroachdb/cockroach/pkg/util/log"
	"github.com/cockroachdb/cockroach/pkg/util/timeutil/pgdate"
	"github.com/cockroachdb/cockroach/pkg/util/uuid"
	"github.com/cockroachdb/errors"
	"github.com/lib/pq/oid"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ duration.Duration
	_ json.JSON
	_ = lex.DecodeRawBytesToByteArrayAuto
	_ = uuid.FromBytes
	_ = oid.T_name
	_ = util.TruncateString
	_ = pgcode.Syntax
	_ = pgdate.ParseTimestamp
	_ = pgerror.Wrapf
)

func isIdentityCast(fromType, toType *types.T) bool {
	if fromType.Identical(toType) {
		return true
	}
	if fromType.Family() == types.FloatFamily && toType.Family() == types.FloatFamily {
		// Casts between floats are identical because all floats are represented
		// by float64 physically.
		return true
	}
	if toType.Family() == types.BytesFamily && (fromType.Family() == types.UuidFamily || fromType.Family() == types.EnumFamily) {
		// The casts from UUID or enum to Bytes is an identity because we don't
		// need to perform any conversion since both are represented in the same
		// way.
		return true
	}
	return false
}

var errUnhandledCast = errors.New("unhandled cast")

func GetCastOperator(
	ctx context.Context,
	allocator *colmem.Allocator,
	input colexecop.Operator,
	colIdx int,
	resultIdx int,
	fromType *types.T,
	toType *types.T,
	evalCtx *eval.Context,
) (colexecop.Operator, error) {
	input = colexecutils.NewVectorTypeEnforcer(allocator, input, toType, resultIdx)
	base := castOpBase{
		OneInputInitCloserHelper: colexecop.MakeOneInputInitCloserHelper(input),
		allocator:                allocator,
		colIdx:                   colIdx,
		outputIdx:                resultIdx,
		evalCtx:                  evalCtx,
	}
	if fromType.Family() == types.UnknownFamily {
		return &castOpNullAny{castOpBase: base}, nil
	}
	if isIdentityCast(fromType, toType) {
		// bpchars require special handling.
		if toType.Oid() == oid.T_bpchar {
			return &castBPCharIdentityOp{castOpBase: base}, nil
		}
		// If we don't have an array of bpchars, then we use the identity,
		// otherwise we'll fallback to datum-datum cast below.
		if toType.Oid() != oid.T__bpchar {
			return &castIdentityOp{castOpBase: base}, nil
		}
	}
	isFromDatum := typeconv.TypeFamilyToCanonicalTypeFamily(fromType.Family()) == typeconv.DatumVecCanonicalTypeFamily
	isToDatum := typeconv.TypeFamilyToCanonicalTypeFamily(toType.Family()) == typeconv.DatumVecCanonicalTypeFamily
	if isFromDatum {
		if isToDatum {
			return &castDatumDatumOp{castOpBase: base}, nil
		}
		switch toType.Family() {
		case types.BoolFamily:
			switch toType.Width() {
			case -1:
			default:
				return &castDatumBoolOp{castOpBase: base}, nil
			}
		case types.IntFamily:
			switch toType.Width() {
			case 16:
				return &castDatumInt2Op{castOpBase: base}, nil
			case 32:
				return &castDatumInt4Op{castOpBase: base}, nil
			case -1:
			default:
				return &castDatumIntOp{castOpBase: base}, nil
			}
		case types.FloatFamily:
			switch toType.Width() {
			case -1:
			default:
				return &castDatumFloatOp{castOpBase: base}, nil
			}
		case types.DecimalFamily:
			switch toType.Width() {
			case -1:
			default:
				return &castDatumDecimalOp{castOpBase: base}, nil
			}
		case types.DateFamily:
			switch toType.Width() {
			case -1:
			default:
				return &castDatumDateOp{castOpBase: base}, nil
			}
		case types.TimestampFamily:
			switch toType.Width() {
			case -1:
			default:
				return &castDatumTimestampOp{castOpBase: base}, nil
			}
		case types.IntervalFamily:
			switch toType.Width() {
			case -1:
			default:
				return &castDatumIntervalOp{castOpBase: base}, nil
			}
		case types.StringFamily:
			switch toType.Width() {
			case -1:
			default:
				return &castDatumStringOp{castOpBase: base}, nil
			}
		case types.BytesFamily:
			switch toType.Width() {
			case -1:
			default:
				return &castDatumBytesOp{castOpBase: base}, nil
			}
		case types.TimestampTZFamily:
			switch toType.Width() {
			case -1:
			default:
				return &castDatumTimestamptzOp{castOpBase: base}, nil
			}
		case types.UuidFamily:
			switch toType.Width() {
			case -1:
			default:
				return &castDatumUuidOp{castOpBase: base}, nil
			}
		case types.JsonFamily:
			switch toType.Width() {
			case -1:
			default:
				return &castDatumJsonbOp{castOpBase: base}, nil
			}
		}
	} else {
		if isToDatum {
			return &castNativeToDatumOp{castOpBase: base}, nil
		}
		switch fromType.Family() {
		case types.BoolFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.FloatFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castBoolFloatOp{castOpBase: base}, nil
					}
				case types.IntFamily:
					switch toType.Width() {
					case 16:
						return &castBoolInt2Op{castOpBase: base}, nil
					case 32:
						return &castBoolInt4Op{castOpBase: base}, nil
					case -1:
					default:
						return &castBoolIntOp{castOpBase: base}, nil
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castBoolStringOp{castOpBase: base}, nil
					}
				}
			}
		case types.BytesFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castBytesStringOp{castOpBase: base}, nil
					}
				case types.UuidFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castBytesUuidOp{castOpBase: base}, nil
					}
				}
			}
		case types.DateFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.DecimalFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castDateDecimalOp{castOpBase: base}, nil
					}
				case types.FloatFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castDateFloatOp{castOpBase: base}, nil
					}
				case types.IntFamily:
					switch toType.Width() {
					case 16:
						return &castDateInt2Op{castOpBase: base}, nil
					case 32:
						return &castDateInt4Op{castOpBase: base}, nil
					case -1:
					default:
						return &castDateIntOp{castOpBase: base}, nil
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castDateStringOp{castOpBase: base}, nil
					}
				}
			}
		case types.DecimalFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.BoolFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castDecimalBoolOp{castOpBase: base}, nil
					}
				case types.DecimalFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castDecimalDecimalOp{castOpBase: base}, nil
					}
				case types.FloatFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castDecimalFloatOp{castOpBase: base}, nil
					}
				case types.IntFamily:
					switch toType.Width() {
					case 16:
						return &castDecimalInt2Op{castOpBase: base}, nil
					case 32:
						return &castDecimalInt4Op{castOpBase: base}, nil
					case -1:
					default:
						return &castDecimalIntOp{castOpBase: base}, nil
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castDecimalStringOp{castOpBase: base}, nil
					}
				}
			}
		case types.EnumFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castEnumStringOp{castOpBase: base}, nil
					}
				}
			}
		case types.FloatFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.BoolFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castFloatBoolOp{castOpBase: base}, nil
					}
				case types.DecimalFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castFloatDecimalOp{castOpBase: base}, nil
					}
				case types.IntFamily:
					switch toType.Width() {
					case 16:
						return &castFloatInt2Op{castOpBase: base}, nil
					case 32:
						return &castFloatInt4Op{castOpBase: base}, nil
					case -1:
					default:
						return &castFloatIntOp{castOpBase: base}, nil
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castFloatStringOp{castOpBase: base}, nil
					}
				}
			}
		case types.IntFamily:
			switch fromType.Width() {
			case 16:
				switch toType.Family() {
				case types.BoolFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castInt2BoolOp{castOpBase: base}, nil
					}
				case types.DecimalFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castInt2DecimalOp{castOpBase: base}, nil
					}
				case types.FloatFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castInt2FloatOp{castOpBase: base}, nil
					}
				case types.IntFamily:
					switch toType.Width() {
					case 32:
						return &castInt2Int4Op{castOpBase: base}, nil
					case -1:
					default:
						return &castInt2IntOp{castOpBase: base}, nil
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castInt2StringOp{castOpBase: base}, nil
					}
				}
			case 32:
				switch toType.Family() {
				case types.BoolFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castInt4BoolOp{castOpBase: base}, nil
					}
				case types.DecimalFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castInt4DecimalOp{castOpBase: base}, nil
					}
				case types.FloatFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castInt4FloatOp{castOpBase: base}, nil
					}
				case types.IntFamily:
					switch toType.Width() {
					case 16:
						return &castInt4Int2Op{castOpBase: base}, nil
					case -1:
					default:
						return &castInt4IntOp{castOpBase: base}, nil
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castInt4StringOp{castOpBase: base}, nil
					}
				}
			case -1:
			default:
				switch toType.Family() {
				case types.BoolFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castIntBoolOp{castOpBase: base}, nil
					}
				case types.DecimalFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castIntDecimalOp{castOpBase: base}, nil
					}
				case types.FloatFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castIntFloatOp{castOpBase: base}, nil
					}
				case types.IntFamily:
					switch toType.Width() {
					case 16:
						return &castIntInt2Op{castOpBase: base}, nil
					case 32:
						return &castIntInt4Op{castOpBase: base}, nil
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castIntStringOp{castOpBase: base}, nil
					}
				}
			}
		case types.IntervalFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castIntervalStringOp{castOpBase: base}, nil
					}
				}
			}
		case types.JsonFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castJsonbStringOp{castOpBase: base}, nil
					}
				}
			}
		case types.StringFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.BoolFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castStringBoolOp{castOpBase: base}, nil
					}
				case types.BytesFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castStringBytesOp{castOpBase: base}, nil
					}
				case types.DateFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castStringDateOp{castOpBase: base}, nil
					}
				case types.DecimalFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castStringDecimalOp{castOpBase: base}, nil
					}
				case types.EnumFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castStringEnumOp{castOpBase: base}, nil
					}
				case types.FloatFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castStringFloatOp{castOpBase: base}, nil
					}
				case types.IntFamily:
					switch toType.Width() {
					case 16:
						return &castStringInt2Op{castOpBase: base}, nil
					case 32:
						return &castStringInt4Op{castOpBase: base}, nil
					case -1:
					default:
						return &castStringIntOp{castOpBase: base}, nil
					}
				case types.IntervalFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castStringIntervalOp{castOpBase: base}, nil
					}
				case types.JsonFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castStringJsonbOp{castOpBase: base}, nil
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castStringStringOp{castOpBase: base}, nil
					}
				case types.TimestampFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castStringTimestampOp{castOpBase: base}, nil
					}
				case types.TimestampTZFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castStringTimestamptzOp{castOpBase: base}, nil
					}
				case types.UuidFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castStringUuidOp{castOpBase: base}, nil
					}
				}
			}
		case types.TimestampFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castTimestampStringOp{castOpBase: base}, nil
					}
				}
			}
		case types.TimestampTZFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castTimestamptzStringOp{castOpBase: base}, nil
					}
				}
			}
		case types.UuidFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return &castUuidStringOp{castOpBase: base}, nil
					}
				}
			}
		}
	}
	err := errUnhandledCast
	if log.ExpensiveLogEnabled(ctx, 1) {
		err = errors.Newf("unhandled cast %s -> %s", fromType.SQLStringForError(), toType.SQLStringForError())
	}
	return nil, err
}

func IsCastSupported(fromType, toType *types.T) bool {
	if fromType.Family() == types.UnknownFamily {
		return true
	}
	if isIdentityCast(fromType, toType) {
		return true
	}
	isFromDatum := typeconv.TypeFamilyToCanonicalTypeFamily(fromType.Family()) == typeconv.DatumVecCanonicalTypeFamily
	isToDatum := typeconv.TypeFamilyToCanonicalTypeFamily(toType.Family()) == typeconv.DatumVecCanonicalTypeFamily
	if isFromDatum {
		if isToDatum {
			return true
		}
		switch toType.Family() {
		case types.BoolFamily:
			switch toType.Width() {
			case -1:
			default:
				return true
			}
		case types.IntFamily:
			switch toType.Width() {
			case 16:
				return true
			case 32:
				return true
			case -1:
			default:
				return true
			}
		case types.FloatFamily:
			switch toType.Width() {
			case -1:
			default:
				return true
			}
		case types.DecimalFamily:
			switch toType.Width() {
			case -1:
			default:
				return true
			}
		case types.DateFamily:
			switch toType.Width() {
			case -1:
			default:
				return true
			}
		case types.TimestampFamily:
			switch toType.Width() {
			case -1:
			default:
				return true
			}
		case types.IntervalFamily:
			switch toType.Width() {
			case -1:
			default:
				return true
			}
		case types.StringFamily:
			switch toType.Width() {
			case -1:
			default:
				return true
			}
		case types.BytesFamily:
			switch toType.Width() {
			case -1:
			default:
				return true
			}
		case types.TimestampTZFamily:
			switch toType.Width() {
			case -1:
			default:
				return true
			}
		case types.UuidFamily:
			switch toType.Width() {
			case -1:
			default:
				return true
			}
		case types.JsonFamily:
			switch toType.Width() {
			case -1:
			default:
				return true
			}
		}
	} else {
		if isToDatum {
			return true
		}
		switch fromType.Family() {
		case types.BoolFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.FloatFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.IntFamily:
					switch toType.Width() {
					case 16:
						return true
					case 32:
						return true
					case -1:
					default:
						return true
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				}
			}
		case types.BytesFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.UuidFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				}
			}
		case types.DateFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.DecimalFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.FloatFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.IntFamily:
					switch toType.Width() {
					case 16:
						return true
					case 32:
						return true
					case -1:
					default:
						return true
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				}
			}
		case types.DecimalFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.BoolFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.DecimalFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.FloatFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.IntFamily:
					switch toType.Width() {
					case 16:
						return true
					case 32:
						return true
					case -1:
					default:
						return true
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				}
			}
		case types.EnumFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				}
			}
		case types.FloatFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.BoolFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.DecimalFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.IntFamily:
					switch toType.Width() {
					case 16:
						return true
					case 32:
						return true
					case -1:
					default:
						return true
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				}
			}
		case types.IntFamily:
			switch fromType.Width() {
			case 16:
				switch toType.Family() {
				case types.BoolFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.DecimalFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.FloatFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.IntFamily:
					switch toType.Width() {
					case 32:
						return true
					case -1:
					default:
						return true
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				}
			case 32:
				switch toType.Family() {
				case types.BoolFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.DecimalFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.FloatFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.IntFamily:
					switch toType.Width() {
					case 16:
						return true
					case -1:
					default:
						return true
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				}
			case -1:
			default:
				switch toType.Family() {
				case types.BoolFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.DecimalFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.FloatFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.IntFamily:
					switch toType.Width() {
					case 16:
						return true
					case 32:
						return true
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				}
			}
		case types.IntervalFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				}
			}
		case types.JsonFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				}
			}
		case types.StringFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.BoolFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.BytesFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.DateFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.DecimalFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.EnumFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.FloatFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.IntFamily:
					switch toType.Width() {
					case 16:
						return true
					case 32:
						return true
					case -1:
					default:
						return true
					}
				case types.IntervalFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.JsonFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.TimestampFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.TimestampTZFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				case types.UuidFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				}
			}
		case types.TimestampFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				}
			}
		case types.TimestampTZFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				}
			}
		case types.UuidFamily:
			switch fromType.Width() {
			case -1:
			default:
				switch toType.Family() {
				case types.StringFamily:
					switch toType.Width() {
					case -1:
					default:
						return true
					}
				}
			}
		}
	}
	return false
}

type castOpBase struct {
	allocator *colmem.Allocator
	evalCtx   *eval.Context
	buf       bytes.Buffer
	colexecop.OneInputInitCloserHelper
	colIdx    int
	outputIdx int
}

func (c *castOpBase) Reset(ctx context.Context) {
	if r, ok := c.Input.(colexecop.Resetter); ok {
		r.Reset(ctx)
	}
}

type castOpNullAny struct {
	castOpBase
}

var _ colexecop.ClosableOperator = &castOpNullAny{}

func (c *castOpNullAny) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	vec := batch.ColVec(c.colIdx)
	projVec := batch.ColVec(c.outputIdx)
	vecNulls := vec.Nulls()
	projNulls := projVec.Nulls()
	if sel := batch.Selection(); sel != nil {
		sel = sel[:n]
		for _, i := range sel {
			if vecNulls.NullAt(i) {
				projNulls.SetNull(i)
			} else {
				colexecerror.InternalError(errors.AssertionFailedf("unexpected non-null at index %d", i))
			}
		}
	} else {
		for i := 0; i < n; i++ {
			if vecNulls.NullAt(i) {
				projNulls.SetNull(i)
			} else {
				colexecerror.InternalError(errors.AssertionFailedf("unexpected non-null at index %d", i))
			}
		}
	}
	return batch
}

// castIdentityOp is a special cast operator for the case when "from" and "to"
// types are identical. The job of this operator is to simply copy the input
// column into the output column, without performing the deselection step. Not
// performing the deselection is justified by the following:
//
//  1. to be in line with other cast operators
//  2. AND/OR projection operators cannot handle when a different batch is
//     returned than the one they fed into the projection chain (which might
//     contain casts)
//  3. performing the deselection would require copying over all vectors, not
//     just the output one.
//
// This operator should be planned rarely enough (if ever) to not be very
// important.
type castIdentityOp struct {
	castOpBase
}

var _ colexecop.ClosableOperator = &castIdentityOp{}

// identityOrder is a slice in which every integer equals its ordinal.
var identityOrder []int

func init() {
	identityOrder = make([]int, coldata.MaxBatchSize)
	for i := range identityOrder {
		identityOrder[i] = i
	}
}

func (c *castIdentityOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	projVec := batch.ColVec(c.outputIdx)
	c.allocator.PerformOperation([]*coldata.Vec{projVec}, func() {
		srcVec := batch.ColVec(c.colIdx)
		if sel := batch.Selection(); sel != nil {
			// We don't want to perform the deselection during copying, so we
			// use a special copy in which we use the identity order but apply
			// the selection vector.
			projVec.CopyWithReorderedSource(srcVec, sel[:n], identityOrder)
		} else {
			projVec.Copy(coldata.SliceArgs{
				Src:         srcVec,
				SrcStartIdx: 0,
				SrcEndIdx:   n,
			})
		}
	})
	return batch
}

// castBPCharIdentityOp is a specialization of castIdentityOp which handles
// casts to the bpchar type (which trims trailing whitespaces).
type castBPCharIdentityOp struct {
	castOpBase
}

var _ colexecop.ClosableOperator = &castBPCharIdentityOp{}

func (c *castBPCharIdentityOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	inputVec := batch.ColVec(c.colIdx)
	inputCol := inputVec.Bytes()
	inputNulls := inputVec.Nulls()
	outputVec := batch.ColVec(c.outputIdx)
	outputCol := outputVec.Bytes()
	outputNulls := outputVec.Nulls()
	// Note that the loops below are not as optimized as in other cast operators
	// since this operator should only be planned in tests.
	c.allocator.PerformOperation([]*coldata.Vec{outputVec}, func() {
		if sel := batch.Selection(); sel != nil {
			for _, i := range sel[:n] {
				if inputNulls.NullAt(i) {
					outputNulls.SetNull(i)
				} else {
					outputCol.Set(i, bytes.TrimRight(inputCol.Get(i), " "))
				}
			}
		} else {
			for i := 0; i < n; i++ {
				if inputNulls.NullAt(i) {
					outputNulls.SetNull(i)
				} else {
					outputCol.Set(i, bytes.TrimRight(inputCol.Get(i), " "))
				}
			}
		}
	})
	return batch
}

type castNativeToDatumOp struct {
	castOpBase

	scratch []tree.Datum
	da      tree.DatumAlloc
}

var _ colexecop.ClosableOperator = &castNativeToDatumOp{}

func (c *castNativeToDatumOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	outputCol := outputVec.Datum()
	outputNulls := outputVec.Nulls()
	toType := outputVec.Type()
	c.allocator.PerformOperation([]*coldata.Vec{outputVec}, func() {
		if n > c.da.DefaultAllocSize {
			c.da.DefaultAllocSize = n
		}
		if cap(c.scratch) < n {
			c.scratch = make([]tree.Datum, n)
		} else {
			c.scratch = c.scratch[:n]
		}
		scratch := c.scratch
		sel := batch.Selection()
		colconv.ColVecToDatumAndDeselect(scratch, inputVec, n, sel, &c.da)
		if sel != nil {
			if inputVec.Nulls().MaybeHasNulls() {
				for scratchIdx, outputIdx := range sel[:n] {
					{
						var (
							ctx     context.Context = c.Ctx
							evalCtx *eval.Context   = c.evalCtx
						)
						converted := scratch[scratchIdx]
						if true && converted == tree.DNull {
							outputNulls.SetNull(outputIdx)
							continue
						}
						res, err := eval.PerformCast(ctx, evalCtx, converted, toType)
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						outputCol.Set(outputIdx, res)
					}
				}
			} else {
				for scratchIdx, outputIdx := range sel[:n] {
					{
						var (
							ctx     context.Context = c.Ctx
							evalCtx *eval.Context   = c.evalCtx
						)
						converted := scratch[scratchIdx]
						if false && converted == tree.DNull {
							outputNulls.SetNull(outputIdx)
							continue
						}
						res, err := eval.PerformCast(ctx, evalCtx, converted, toType)
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						outputCol.Set(outputIdx, res)
					}
				}
			}
		} else {
			_ = scratch[n-1]
			if inputVec.Nulls().MaybeHasNulls() {
				for idx := 0; idx < n; idx++ {
					{
						var (
							ctx        context.Context = c.Ctx
							scratchIdx int             = idx
							outputIdx  int             = idx
							evalCtx    *eval.Context   = c.evalCtx
						)
						//gcassert:bce
						converted := scratch[scratchIdx]
						if true && converted == tree.DNull {
							outputNulls.SetNull(outputIdx)
							continue
						}
						res, err := eval.PerformCast(ctx, evalCtx, converted, toType)
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						outputCol.Set(outputIdx, res)
					}
				}
			} else {
				for idx := 0; idx < n; idx++ {
					{
						var (
							ctx        context.Context = c.Ctx
							scratchIdx int             = idx
							outputIdx  int             = idx
							evalCtx    *eval.Context   = c.evalCtx
						)
						//gcassert:bce
						converted := scratch[scratchIdx]
						if false && converted == tree.DNull {
							outputNulls.SetNull(outputIdx)
							continue
						}
						res, err := eval.PerformCast(ctx, evalCtx, converted, toType)
						if err != nil {
							colexecerror.ExpectedError(err)
						}
						outputCol.Set(outputIdx, res)
					}
				}
			}
		}
	})
	return batch
}

// setNativeToDatumCast performs the cast of the converted datum in
// scratch[scratchIdx] to toType and sets the result into position outputIdx of
// outputCol (or into the output nulls bitmap).
// execgen:inline
const _ = "template_setNativeToDatumCast"

type castBoolFloatOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castBoolFloatOp{}
var _ colexecop.ClosableOperator = &castBoolFloatOp{}

func (c *castBoolFloatOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bool()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Float64()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							r = 0
							if v {
								r = 1
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r float64

							r = 0
							if v {
								r = 1
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							r = 0
							if v {
								r = 1
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r float64

							r = 0
							if v {
								r = 1
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castBoolInt2Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castBoolInt2Op{}
var _ colexecop.ClosableOperator = &castBoolInt2Op{}

func (c *castBoolInt2Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bool()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int16()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							r = 0
							if v {
								r = 1
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int16

							r = 0
							if v {
								r = 1
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							r = 0
							if v {
								r = 1
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int16

							r = 0
							if v {
								r = 1
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castBoolInt4Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castBoolInt4Op{}
var _ colexecop.ClosableOperator = &castBoolInt4Op{}

func (c *castBoolInt4Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bool()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int32()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							r = 0
							if v {
								r = 1
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int32

							r = 0
							if v {
								r = 1
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							r = 0
							if v {
								r = 1
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int32

							r = 0
							if v {
								r = 1
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castBoolIntOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castBoolIntOp{}
var _ colexecop.ClosableOperator = &castBoolIntOp{}

func (c *castBoolIntOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bool()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int64()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							r = 0
							if v {
								r = 1
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int64

							r = 0
							if v {
								r = 1
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							r = 0
							if v {
								r = 1
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int64

							r = 0
							if v {
								r = 1
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castBoolStringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castBoolStringOp{}
var _ colexecop.ClosableOperator = &castBoolStringOp{}

func (c *castBoolStringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bool()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = []byte(strconv.FormatBool(v))
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = []byte(strconv.FormatBool(v))
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = []byte(strconv.FormatBool(v))
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = []byte(strconv.FormatBool(v))
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castBytesStringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castBytesStringOp{}
var _ colexecop.ClosableOperator = &castBytesStringOp{}

func (c *castBytesStringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_format := evalCtx.SessionData().DataConversionConfig.BytesEncodeFormat
							r = []byte(lex.EncodeByteArrayToRawBytes(string(v), _format, false /* skipHexPrefix */))

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_format := evalCtx.SessionData().DataConversionConfig.BytesEncodeFormat
							r = []byte(lex.EncodeByteArrayToRawBytes(string(v), _format, false /* skipHexPrefix */))

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_format := evalCtx.SessionData().DataConversionConfig.BytesEncodeFormat
							r = []byte(lex.EncodeByteArrayToRawBytes(string(v), _format, false /* skipHexPrefix */))

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_format := evalCtx.SessionData().DataConversionConfig.BytesEncodeFormat
							r = []byte(lex.EncodeByteArrayToRawBytes(string(v), _format, false /* skipHexPrefix */))

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castBytesUuidOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castBytesUuidOp{}
var _ colexecop.ClosableOperator = &castBytesUuidOp{}

func (c *castBytesUuidOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_uuid, err := uuid.FromBytes(v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = _uuid.GetBytes()

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_uuid, err := uuid.FromBytes(v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = _uuid.GetBytes()

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_uuid, err := uuid.FromBytes(v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = _uuid.GetBytes()

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_uuid, err := uuid.FromBytes(v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = _uuid.GetBytes()

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDateDecimalOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDateDecimalOp{}
var _ colexecop.ClosableOperator = &castDateDecimalOp{}

func (c *castDateDecimalOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Decimal()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDateFloatOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDateFloatOp{}
var _ colexecop.ClosableOperator = &castDateFloatOp{}

func (c *castDateFloatOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Float64()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDateInt2Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDateInt2Op{}
var _ colexecop.ClosableOperator = &castDateInt2Op{}

func (c *castDateInt2Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int16()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							shifted := v >> uint(15)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
							}
							r = int16(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int16

							shifted := v >> uint(15)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
							}
							r = int16(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							shifted := v >> uint(15)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
							}
							r = int16(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int16

							shifted := v >> uint(15)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
							}
							r = int16(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDateInt4Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDateInt4Op{}
var _ colexecop.ClosableOperator = &castDateInt4Op{}

func (c *castDateInt4Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int32()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							shifted := v >> uint(31)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
							}
							r = int32(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int32

							shifted := v >> uint(31)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
							}
							r = int32(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							shifted := v >> uint(31)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
							}
							r = int32(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int32

							shifted := v >> uint(31)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
							}
							r = int32(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDateIntOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDateIntOp{}
var _ colexecop.ClosableOperator = &castDateIntOp{}

func (c *castDateIntOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int64()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64
							r = int64(v)
							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int64
							r = int64(v)
							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64
							r = int64(v)
							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int64
							r = int64(v)
							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDateStringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDateStringOp{}
var _ colexecop.ClosableOperator = &castDateStringOp{}

func (c *castDateStringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_date := pgdate.MakeCompatibleDateFromDisk(v)
							buf.Reset()
							_date.Format(buf)
							r = []byte(buf.String())

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							_date := pgdate.MakeCompatibleDateFromDisk(v)
							buf.Reset()
							_date.Format(buf)
							r = []byte(buf.String())

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_date := pgdate.MakeCompatibleDateFromDisk(v)
							buf.Reset()
							_date.Format(buf)
							r = []byte(buf.String())

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							_date := pgdate.MakeCompatibleDateFromDisk(v)
							buf.Reset()
							_date.Format(buf)
							r = []byte(buf.String())

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDecimalBoolOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDecimalBoolOp{}
var _ colexecop.ClosableOperator = &castDecimalBoolOp{}

func (c *castDecimalBoolOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Decimal()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bool()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool
							r = v.Sign() != 0
							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r bool
							r = v.Sign() != 0
							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool
							r = v.Sign() != 0
							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r bool
							r = v.Sign() != 0
							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDecimalDecimalOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDecimalDecimalOp{}
var _ colexecop.ClosableOperator = &castDecimalDecimalOp{}

func (c *castDecimalDecimalOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Decimal()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Decimal()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.Set(&v)
							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.Set(&v)
							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.Set(&v)
							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.Set(&v)
							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDecimalFloatOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDecimalFloatOp{}
var _ colexecop.ClosableOperator = &castDecimalFloatOp{}

func (c *castDecimalFloatOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Decimal()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Float64()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							{
								f, err := v.Float64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrFloatOutOfRange)
								}
								r = f
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r float64

							{
								f, err := v.Float64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrFloatOutOfRange)
								}
								r = f
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							{
								f, err := v.Float64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrFloatOutOfRange)
								}
								r = f
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r float64

							{
								f, err := v.Float64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrFloatOutOfRange)
								}
								r = f
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDecimalInt2Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDecimalInt2Op{}
var _ colexecop.ClosableOperator = &castDecimalInt2Op{}

func (c *castDecimalInt2Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Decimal()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int16()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							{
								var tmpDec apd.Decimal //gcassert:noescape
								_, err := tree.DecimalCtx.RoundToIntegralValue(&tmpDec, &v)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								_i, err := tmpDec.Int64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
								}

								shifted := _i >> uint(15)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
								}
								r = int16(_i)

							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int16

							{
								var tmpDec apd.Decimal //gcassert:noescape
								_, err := tree.DecimalCtx.RoundToIntegralValue(&tmpDec, &v)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								_i, err := tmpDec.Int64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
								}

								shifted := _i >> uint(15)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
								}
								r = int16(_i)

							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							{
								var tmpDec apd.Decimal //gcassert:noescape
								_, err := tree.DecimalCtx.RoundToIntegralValue(&tmpDec, &v)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								_i, err := tmpDec.Int64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
								}

								shifted := _i >> uint(15)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
								}
								r = int16(_i)

							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int16

							{
								var tmpDec apd.Decimal //gcassert:noescape
								_, err := tree.DecimalCtx.RoundToIntegralValue(&tmpDec, &v)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								_i, err := tmpDec.Int64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
								}

								shifted := _i >> uint(15)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
								}
								r = int16(_i)

							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDecimalInt4Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDecimalInt4Op{}
var _ colexecop.ClosableOperator = &castDecimalInt4Op{}

func (c *castDecimalInt4Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Decimal()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int32()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							{
								var tmpDec apd.Decimal //gcassert:noescape
								_, err := tree.DecimalCtx.RoundToIntegralValue(&tmpDec, &v)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								_i, err := tmpDec.Int64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
								}

								shifted := _i >> uint(31)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
								}
								r = int32(_i)

							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int32

							{
								var tmpDec apd.Decimal //gcassert:noescape
								_, err := tree.DecimalCtx.RoundToIntegralValue(&tmpDec, &v)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								_i, err := tmpDec.Int64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
								}

								shifted := _i >> uint(31)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
								}
								r = int32(_i)

							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							{
								var tmpDec apd.Decimal //gcassert:noescape
								_, err := tree.DecimalCtx.RoundToIntegralValue(&tmpDec, &v)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								_i, err := tmpDec.Int64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
								}

								shifted := _i >> uint(31)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
								}
								r = int32(_i)

							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int32

							{
								var tmpDec apd.Decimal //gcassert:noescape
								_, err := tree.DecimalCtx.RoundToIntegralValue(&tmpDec, &v)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								_i, err := tmpDec.Int64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
								}

								shifted := _i >> uint(31)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
								}
								r = int32(_i)

							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDecimalIntOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDecimalIntOp{}
var _ colexecop.ClosableOperator = &castDecimalIntOp{}

func (c *castDecimalIntOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Decimal()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int64()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								var tmpDec apd.Decimal //gcassert:noescape
								_, err := tree.DecimalCtx.RoundToIntegralValue(&tmpDec, &v)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								_i, err := tmpDec.Int64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
								r = int64(_i)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								var tmpDec apd.Decimal //gcassert:noescape
								_, err := tree.DecimalCtx.RoundToIntegralValue(&tmpDec, &v)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								_i, err := tmpDec.Int64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
								r = int64(_i)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								var tmpDec apd.Decimal //gcassert:noescape
								_, err := tree.DecimalCtx.RoundToIntegralValue(&tmpDec, &v)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								_i, err := tmpDec.Int64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
								r = int64(_i)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								var tmpDec apd.Decimal //gcassert:noescape
								_, err := tree.DecimalCtx.RoundToIntegralValue(&tmpDec, &v)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								_i, err := tmpDec.Int64()
								if err != nil {
									colexecerror.ExpectedError(tree.ErrIntOutOfRange)
								}
								r = int64(_i)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDecimalStringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDecimalStringOp{}
var _ colexecop.ClosableOperator = &castDecimalStringOp{}

func (c *castDecimalStringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Decimal()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = []byte(v.String())
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = []byte(v.String())
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = []byte(v.String())
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = []byte(v.String())
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castEnumStringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castEnumStringOp{}
var _ colexecop.ClosableOperator = &castEnumStringOp{}

func (c *castEnumStringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	fromType := inputVec.Type()
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_, logical, err := tree.GetEnumComponentsFromPhysicalRep(fromType, v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = []byte(logical)

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_, logical, err := tree.GetEnumComponentsFromPhysicalRep(fromType, v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = []byte(logical)

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_, logical, err := tree.GetEnumComponentsFromPhysicalRep(fromType, v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = []byte(logical)

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_, logical, err := tree.GetEnumComponentsFromPhysicalRep(fromType, v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = []byte(logical)

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castFloatBoolOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castFloatBoolOp{}
var _ colexecop.ClosableOperator = &castFloatBoolOp{}

func (c *castFloatBoolOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Float64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bool()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castFloatDecimalOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castFloatDecimalOp{}
var _ colexecop.ClosableOperator = &castFloatDecimalOp{}

func (c *castFloatDecimalOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Float64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Decimal()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							if _, err := r.SetFloat64(float64(v)); err != nil {
								colexecerror.ExpectedError(err)
							}

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							if _, err := r.SetFloat64(float64(v)); err != nil {
								colexecerror.ExpectedError(err)
							}

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							if _, err := r.SetFloat64(float64(v)); err != nil {
								colexecerror.ExpectedError(err)
							}

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							if _, err := r.SetFloat64(float64(v)); err != nil {
								colexecerror.ExpectedError(err)
							}

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castFloatInt2Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castFloatInt2Op{}
var _ colexecop.ClosableOperator = &castFloatInt2Op{}

func (c *castFloatInt2Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Float64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int16()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							if math.IsNaN(float64(v)) || v <= float64(math.MinInt16) || v >= float64(math.MaxInt16) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							r = int16(math.RoundToEven(v))

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int16

							if math.IsNaN(float64(v)) || v <= float64(math.MinInt16) || v >= float64(math.MaxInt16) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							r = int16(math.RoundToEven(v))

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							if math.IsNaN(float64(v)) || v <= float64(math.MinInt16) || v >= float64(math.MaxInt16) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							r = int16(math.RoundToEven(v))

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int16

							if math.IsNaN(float64(v)) || v <= float64(math.MinInt16) || v >= float64(math.MaxInt16) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							r = int16(math.RoundToEven(v))

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castFloatInt4Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castFloatInt4Op{}
var _ colexecop.ClosableOperator = &castFloatInt4Op{}

func (c *castFloatInt4Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Float64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int32()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							if math.IsNaN(float64(v)) || v <= float64(math.MinInt32) || v >= float64(math.MaxInt32) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							r = int32(math.RoundToEven(v))

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int32

							if math.IsNaN(float64(v)) || v <= float64(math.MinInt32) || v >= float64(math.MaxInt32) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							r = int32(math.RoundToEven(v))

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							if math.IsNaN(float64(v)) || v <= float64(math.MinInt32) || v >= float64(math.MaxInt32) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							r = int32(math.RoundToEven(v))

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int32

							if math.IsNaN(float64(v)) || v <= float64(math.MinInt32) || v >= float64(math.MaxInt32) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							r = int32(math.RoundToEven(v))

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castFloatIntOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castFloatIntOp{}
var _ colexecop.ClosableOperator = &castFloatIntOp{}

func (c *castFloatIntOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Float64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int64()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							if math.IsNaN(float64(v)) || v <= float64(math.MinInt64) || v >= float64(math.MaxInt64) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							r = int64(math.RoundToEven(v))

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int64

							if math.IsNaN(float64(v)) || v <= float64(math.MinInt64) || v >= float64(math.MaxInt64) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							r = int64(math.RoundToEven(v))

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							if math.IsNaN(float64(v)) || v <= float64(math.MinInt64) || v >= float64(math.MaxInt64) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							r = int64(math.RoundToEven(v))

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int64

							if math.IsNaN(float64(v)) || v <= float64(math.MinInt64) || v >= float64(math.MaxInt64) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							r = int64(math.RoundToEven(v))

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castFloatStringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castFloatStringOp{}
var _ colexecop.ClosableOperator = &castFloatStringOp{}

func (c *castFloatStringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Float64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							dcc := evalCtx.SessionData().DataConversionConfig
							r = tree.PgwireFormatFloat(nil /* buf */, v, dcc, types.Float)

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							dcc := evalCtx.SessionData().DataConversionConfig
							r = tree.PgwireFormatFloat(nil /* buf */, v, dcc, types.Float)

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							dcc := evalCtx.SessionData().DataConversionConfig
							r = tree.PgwireFormatFloat(nil /* buf */, v, dcc, types.Float)

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							dcc := evalCtx.SessionData().DataConversionConfig
							r = tree.PgwireFormatFloat(nil /* buf */, v, dcc, types.Float)

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castInt2BoolOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castInt2BoolOp{}
var _ colexecop.ClosableOperator = &castInt2BoolOp{}

func (c *castInt2BoolOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int16()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bool()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castInt2DecimalOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castInt2DecimalOp{}
var _ colexecop.ClosableOperator = &castInt2DecimalOp{}

func (c *castInt2DecimalOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int16()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Decimal()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castInt2FloatOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castInt2FloatOp{}
var _ colexecop.ClosableOperator = &castInt2FloatOp{}

func (c *castInt2FloatOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int16()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Float64()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castInt2Int4Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castInt2Int4Op{}
var _ colexecop.ClosableOperator = &castInt2Int4Op{}

func (c *castInt2Int4Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int16()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int32()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32
							r = int32(v)
							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int32
							r = int32(v)
							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32
							r = int32(v)
							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int32
							r = int32(v)
							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castInt2IntOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castInt2IntOp{}
var _ colexecop.ClosableOperator = &castInt2IntOp{}

func (c *castInt2IntOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int16()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int64()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64
							r = int64(v)
							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int64
							r = int64(v)
							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64
							r = int64(v)
							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int64
							r = int64(v)
							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castInt2StringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castInt2StringOp{}
var _ colexecop.ClosableOperator = &castInt2StringOp{}

func (c *castInt2StringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int16()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							if toType.Oid() == oid.T_char {
								// int to "char" casts just return the corresponding ASCII byte.
								if v > math.MaxInt8 || v < math.MinInt8 {
									colexecerror.ExpectedError(tree.ErrCharOutOfRange)
								}
								if v == 0 {
									r = []byte{}
								} else {
									r = []byte{byte(v)}
								}
							} else {
								r = []byte(strconv.FormatInt(int64(v), 10))
							}

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							if toType.Oid() == oid.T_char {
								// int to "char" casts just return the corresponding ASCII byte.
								if v > math.MaxInt8 || v < math.MinInt8 {
									colexecerror.ExpectedError(tree.ErrCharOutOfRange)
								}
								if v == 0 {
									r = []byte{}
								} else {
									r = []byte{byte(v)}
								}
							} else {
								r = []byte(strconv.FormatInt(int64(v), 10))
							}

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							if toType.Oid() == oid.T_char {
								// int to "char" casts just return the corresponding ASCII byte.
								if v > math.MaxInt8 || v < math.MinInt8 {
									colexecerror.ExpectedError(tree.ErrCharOutOfRange)
								}
								if v == 0 {
									r = []byte{}
								} else {
									r = []byte{byte(v)}
								}
							} else {
								r = []byte(strconv.FormatInt(int64(v), 10))
							}

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							if toType.Oid() == oid.T_char {
								// int to "char" casts just return the corresponding ASCII byte.
								if v > math.MaxInt8 || v < math.MinInt8 {
									colexecerror.ExpectedError(tree.ErrCharOutOfRange)
								}
								if v == 0 {
									r = []byte{}
								} else {
									r = []byte{byte(v)}
								}
							} else {
								r = []byte(strconv.FormatInt(int64(v), 10))
							}

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castInt4BoolOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castInt4BoolOp{}
var _ colexecop.ClosableOperator = &castInt4BoolOp{}

func (c *castInt4BoolOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int32()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bool()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castInt4DecimalOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castInt4DecimalOp{}
var _ colexecop.ClosableOperator = &castInt4DecimalOp{}

func (c *castInt4DecimalOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int32()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Decimal()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castInt4FloatOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castInt4FloatOp{}
var _ colexecop.ClosableOperator = &castInt4FloatOp{}

func (c *castInt4FloatOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int32()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Float64()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castInt4Int2Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castInt4Int2Op{}
var _ colexecop.ClosableOperator = &castInt4Int2Op{}

func (c *castInt4Int2Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int32()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int16()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							shifted := v >> uint(15)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
							}
							r = int16(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int16

							shifted := v >> uint(15)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
							}
							r = int16(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							shifted := v >> uint(15)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
							}
							r = int16(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int16

							shifted := v >> uint(15)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
							}
							r = int16(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castInt4IntOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castInt4IntOp{}
var _ colexecop.ClosableOperator = &castInt4IntOp{}

func (c *castInt4IntOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int32()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int64()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64
							r = int64(v)
							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int64
							r = int64(v)
							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64
							r = int64(v)
							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int64
							r = int64(v)
							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castInt4StringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castInt4StringOp{}
var _ colexecop.ClosableOperator = &castInt4StringOp{}

func (c *castInt4StringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int32()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							if toType.Oid() == oid.T_char {
								// int to "char" casts just return the corresponding ASCII byte.
								if v > math.MaxInt8 || v < math.MinInt8 {
									colexecerror.ExpectedError(tree.ErrCharOutOfRange)
								}
								if v == 0 {
									r = []byte{}
								} else {
									r = []byte{byte(v)}
								}
							} else {
								r = []byte(strconv.FormatInt(int64(v), 10))
							}

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							if toType.Oid() == oid.T_char {
								// int to "char" casts just return the corresponding ASCII byte.
								if v > math.MaxInt8 || v < math.MinInt8 {
									colexecerror.ExpectedError(tree.ErrCharOutOfRange)
								}
								if v == 0 {
									r = []byte{}
								} else {
									r = []byte{byte(v)}
								}
							} else {
								r = []byte(strconv.FormatInt(int64(v), 10))
							}

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							if toType.Oid() == oid.T_char {
								// int to "char" casts just return the corresponding ASCII byte.
								if v > math.MaxInt8 || v < math.MinInt8 {
									colexecerror.ExpectedError(tree.ErrCharOutOfRange)
								}
								if v == 0 {
									r = []byte{}
								} else {
									r = []byte{byte(v)}
								}
							} else {
								r = []byte(strconv.FormatInt(int64(v), 10))
							}

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							if toType.Oid() == oid.T_char {
								// int to "char" casts just return the corresponding ASCII byte.
								if v > math.MaxInt8 || v < math.MinInt8 {
									colexecerror.ExpectedError(tree.ErrCharOutOfRange)
								}
								if v == 0 {
									r = []byte{}
								} else {
									r = []byte{byte(v)}
								}
							} else {
								r = []byte(strconv.FormatInt(int64(v), 10))
							}

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castIntBoolOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castIntBoolOp{}
var _ colexecop.ClosableOperator = &castIntBoolOp{}

func (c *castIntBoolOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bool()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r bool

							r = v != 0

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castIntDecimalOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castIntDecimalOp{}
var _ colexecop.ClosableOperator = &castIntDecimalOp{}

func (c *castIntDecimalOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Decimal()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							r.SetInt64(int64(v))

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castIntFloatOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castIntFloatOp{}
var _ colexecop.ClosableOperator = &castIntFloatOp{}

func (c *castIntFloatOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Float64()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r float64

							r = float64(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castIntInt2Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castIntInt2Op{}
var _ colexecop.ClosableOperator = &castIntInt2Op{}

func (c *castIntInt2Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int16()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							shifted := v >> uint(15)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
							}
							r = int16(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int16

							shifted := v >> uint(15)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
							}
							r = int16(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							shifted := v >> uint(15)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
							}
							r = int16(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int16

							shifted := v >> uint(15)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
							}
							r = int16(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castIntInt4Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castIntInt4Op{}
var _ colexecop.ClosableOperator = &castIntInt4Op{}

func (c *castIntInt4Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int32()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							shifted := v >> uint(31)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
							}
							r = int32(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int32

							shifted := v >> uint(31)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
							}
							r = int32(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							shifted := v >> uint(31)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
							}
							r = int32(v)

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r int32

							shifted := v >> uint(31)
							if (v >= 0 && shifted > 0) || (v < 0 && shifted < -1) {
								colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
							}
							r = int32(v)

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castIntStringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castIntStringOp{}
var _ colexecop.ClosableOperator = &castIntStringOp{}

func (c *castIntStringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Int64()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							if toType.Oid() == oid.T_char {
								// int to "char" casts just return the corresponding ASCII byte.
								if v > math.MaxInt8 || v < math.MinInt8 {
									colexecerror.ExpectedError(tree.ErrCharOutOfRange)
								}
								if v == 0 {
									r = []byte{}
								} else {
									r = []byte{byte(v)}
								}
							} else {
								r = []byte(strconv.FormatInt(int64(v), 10))
							}

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							if toType.Oid() == oid.T_char {
								// int to "char" casts just return the corresponding ASCII byte.
								if v > math.MaxInt8 || v < math.MinInt8 {
									colexecerror.ExpectedError(tree.ErrCharOutOfRange)
								}
								if v == 0 {
									r = []byte{}
								} else {
									r = []byte{byte(v)}
								}
							} else {
								r = []byte(strconv.FormatInt(int64(v), 10))
							}

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							if toType.Oid() == oid.T_char {
								// int to "char" casts just return the corresponding ASCII byte.
								if v > math.MaxInt8 || v < math.MinInt8 {
									colexecerror.ExpectedError(tree.ErrCharOutOfRange)
								}
								if v == 0 {
									r = []byte{}
								} else {
									r = []byte{byte(v)}
								}
							} else {
								r = []byte(strconv.FormatInt(int64(v), 10))
							}

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							if toType.Oid() == oid.T_char {
								// int to "char" casts just return the corresponding ASCII byte.
								if v > math.MaxInt8 || v < math.MinInt8 {
									colexecerror.ExpectedError(tree.ErrCharOutOfRange)
								}
								if v == 0 {
									r = []byte{}
								} else {
									r = []byte{byte(v)}
								}
							} else {
								r = []byte(strconv.FormatInt(int64(v), 10))
							}

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castIntervalStringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castIntervalStringOp{}
var _ colexecop.ClosableOperator = &castIntervalStringOp{}

func (c *castIntervalStringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Interval()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							dcc := evalCtx.SessionData().DataConversionConfig
							buf.Reset()
							v.FormatWithStyle(buf, dcc.IntervalStyle)
							r = []byte(buf.String())

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							dcc := evalCtx.SessionData().DataConversionConfig
							buf.Reset()
							v.FormatWithStyle(buf, dcc.IntervalStyle)
							r = []byte(buf.String())

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							dcc := evalCtx.SessionData().DataConversionConfig
							buf.Reset()
							v.FormatWithStyle(buf, dcc.IntervalStyle)
							r = []byte(buf.String())

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							dcc := evalCtx.SessionData().DataConversionConfig
							buf.Reset()
							v.FormatWithStyle(buf, dcc.IntervalStyle)
							r = []byte(buf.String())

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castJsonbStringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castJsonbStringOp{}
var _ colexecop.ClosableOperator = &castJsonbStringOp{}

func (c *castJsonbStringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.JSON()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = []byte(v.String())
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = []byte(v.String())
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = []byte(v.String())
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = []byte(v.String())
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castStringBoolOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castStringBoolOp{}
var _ colexecop.ClosableOperator = &castStringBoolOp{}

func (c *castStringBoolOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bool()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							var err error
							r, err = tree.ParseBool(string(v))
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							var err error
							r, err = tree.ParseBool(string(v))
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							var err error
							r, err = tree.ParseBool(string(v))
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							var err error
							r, err = tree.ParseBool(string(v))
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castStringBytesOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castStringBytesOp{}
var _ colexecop.ClosableOperator = &castStringBytesOp{}

func (c *castStringBytesOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							var err error
							r, err = lex.DecodeRawBytesToByteArrayAuto(v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							var err error
							r, err = lex.DecodeRawBytesToByteArrayAuto(v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							var err error
							r, err = lex.DecodeRawBytesToByteArrayAuto(v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							var err error
							r, err = lex.DecodeRawBytesToByteArrayAuto(v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castStringDateOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castStringDateOp{}
var _ colexecop.ClosableOperator = &castStringDateOp{}

func (c *castStringDateOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int64()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							_now := evalCtx.GetRelativeParseTime()
							_dateStyle := evalCtx.GetDateStyle()
							_ph := &evalCtx.ParseHelper
							_d, _, err := pgdate.ParseDate(_now, _dateStyle, string(v), _ph)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = _d.UnixEpochDays()

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							_now := evalCtx.GetRelativeParseTime()
							_dateStyle := evalCtx.GetDateStyle()
							_ph := &evalCtx.ParseHelper
							_d, _, err := pgdate.ParseDate(_now, _dateStyle, string(v), _ph)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = _d.UnixEpochDays()

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							_now := evalCtx.GetRelativeParseTime()
							_dateStyle := evalCtx.GetDateStyle()
							_ph := &evalCtx.ParseHelper
							_d, _, err := pgdate.ParseDate(_now, _dateStyle, string(v), _ph)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = _d.UnixEpochDays()

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							_now := evalCtx.GetRelativeParseTime()
							_dateStyle := evalCtx.GetDateStyle()
							_ph := &evalCtx.ParseHelper
							_d, _, err := pgdate.ParseDate(_now, _dateStyle, string(v), _ph)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = _d.UnixEpochDays()

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castStringDecimalOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castStringDecimalOp{}
var _ colexecop.ClosableOperator = &castStringDecimalOp{}

func (c *castStringDecimalOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Decimal()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							_s := strings.TrimSpace(string(v))
							_, res, err := tree.ExactCtx.SetString(&r, _s)
							if res != 0 || err != nil {
								colexecerror.ExpectedError(tree.MakeParseError(_s, types.Decimal, err))
							}
							switch r.Form {
							case apd.NaNSignaling:
								r.Form = apd.NaN
								r.Negative = false
							case apd.NaN:
								r.Negative = false
							case apd.Finite:
								if r.IsZero() && r.Negative {
									r.Negative = false
								}
							}

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							_s := strings.TrimSpace(string(v))
							_, res, err := tree.ExactCtx.SetString(&r, _s)
							if res != 0 || err != nil {
								colexecerror.ExpectedError(tree.MakeParseError(_s, types.Decimal, err))
							}
							switch r.Form {
							case apd.NaNSignaling:
								r.Form = apd.NaN
								r.Negative = false
							case apd.NaN:
								r.Negative = false
							case apd.Finite:
								if r.IsZero() && r.Negative {
									r.Negative = false
								}
							}

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							_s := strings.TrimSpace(string(v))
							_, res, err := tree.ExactCtx.SetString(&r, _s)
							if res != 0 || err != nil {
								colexecerror.ExpectedError(tree.MakeParseError(_s, types.Decimal, err))
							}
							switch r.Form {
							case apd.NaNSignaling:
								r.Form = apd.NaN
								r.Negative = false
							case apd.NaN:
								r.Negative = false
							case apd.Finite:
								if r.IsZero() && r.Negative {
									r.Negative = false
								}
							}

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							_s := strings.TrimSpace(string(v))
							_, res, err := tree.ExactCtx.SetString(&r, _s)
							if res != 0 || err != nil {
								colexecerror.ExpectedError(tree.MakeParseError(_s, types.Decimal, err))
							}
							switch r.Form {
							case apd.NaNSignaling:
								r.Form = apd.NaN
								r.Negative = false
							case apd.NaN:
								r.Negative = false
							case apd.Finite:
								if r.IsZero() && r.Negative {
									r.Negative = false
								}
							}

							if err := tree.LimitDecimalWidth(&r, int(toType.Precision()), int(toType.Scale())); err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castStringEnumOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castStringEnumOp{}
var _ colexecop.ClosableOperator = &castStringEnumOp{}

func (c *castStringEnumOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_logical := string(v)
							var err error
							r, _, err = tree.GetEnumComponentsFromLogicalRep(toType, _logical)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_logical := string(v)
							var err error
							r, _, err = tree.GetEnumComponentsFromLogicalRep(toType, _logical)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_logical := string(v)
							var err error
							r, _, err = tree.GetEnumComponentsFromLogicalRep(toType, _logical)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_logical := string(v)
							var err error
							r, _, err = tree.GetEnumComponentsFromLogicalRep(toType, _logical)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castStringFloatOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castStringFloatOp{}
var _ colexecop.ClosableOperator = &castStringFloatOp{}

func (c *castStringFloatOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Float64()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							_s := string(v)
							var _err error
							r, _err = strconv.ParseFloat(strings.TrimSpace(_s), 64)
							if _err != nil {
								colexecerror.ExpectedError(tree.MakeParseError(_s, toType, _err))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							_s := string(v)
							var _err error
							r, _err = strconv.ParseFloat(strings.TrimSpace(_s), 64)
							if _err != nil {
								colexecerror.ExpectedError(tree.MakeParseError(_s, toType, _err))
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							_s := string(v)
							var _err error
							r, _err = strconv.ParseFloat(strings.TrimSpace(_s), 64)
							if _err != nil {
								colexecerror.ExpectedError(tree.MakeParseError(_s, toType, _err))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							_s := string(v)
							var _err error
							r, _err = strconv.ParseFloat(strings.TrimSpace(_s), 64)
							if _err != nil {
								colexecerror.ExpectedError(tree.MakeParseError(_s, toType, _err))
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castStringInt2Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castStringInt2Op{}
var _ colexecop.ClosableOperator = &castStringInt2Op{}

func (c *castStringInt2Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int16()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							{
								_s := string(v)
								_i, err := strconv.ParseInt(strings.TrimSpace(_s), 0, 64)
								if err != nil {
									colexecerror.ExpectedError(tree.MakeParseError(_s, toType, err))
								}

								shifted := _i >> uint(15)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
								}
								r = int16(_i)

							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							{
								_s := string(v)
								_i, err := strconv.ParseInt(strings.TrimSpace(_s), 0, 64)
								if err != nil {
									colexecerror.ExpectedError(tree.MakeParseError(_s, toType, err))
								}

								shifted := _i >> uint(15)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
								}
								r = int16(_i)

							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							{
								_s := string(v)
								_i, err := strconv.ParseInt(strings.TrimSpace(_s), 0, 64)
								if err != nil {
									colexecerror.ExpectedError(tree.MakeParseError(_s, toType, err))
								}

								shifted := _i >> uint(15)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
								}
								r = int16(_i)

							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							{
								_s := string(v)
								_i, err := strconv.ParseInt(strings.TrimSpace(_s), 0, 64)
								if err != nil {
									colexecerror.ExpectedError(tree.MakeParseError(_s, toType, err))
								}

								shifted := _i >> uint(15)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt2OutOfRange)
								}
								r = int16(_i)

							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castStringInt4Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castStringInt4Op{}
var _ colexecop.ClosableOperator = &castStringInt4Op{}

func (c *castStringInt4Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int32()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							{
								_s := string(v)
								_i, err := strconv.ParseInt(strings.TrimSpace(_s), 0, 64)
								if err != nil {
									colexecerror.ExpectedError(tree.MakeParseError(_s, toType, err))
								}

								shifted := _i >> uint(31)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
								}
								r = int32(_i)

							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							{
								_s := string(v)
								_i, err := strconv.ParseInt(strings.TrimSpace(_s), 0, 64)
								if err != nil {
									colexecerror.ExpectedError(tree.MakeParseError(_s, toType, err))
								}

								shifted := _i >> uint(31)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
								}
								r = int32(_i)

							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							{
								_s := string(v)
								_i, err := strconv.ParseInt(strings.TrimSpace(_s), 0, 64)
								if err != nil {
									colexecerror.ExpectedError(tree.MakeParseError(_s, toType, err))
								}

								shifted := _i >> uint(31)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
								}
								r = int32(_i)

							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							{
								_s := string(v)
								_i, err := strconv.ParseInt(strings.TrimSpace(_s), 0, 64)
								if err != nil {
									colexecerror.ExpectedError(tree.MakeParseError(_s, toType, err))
								}

								shifted := _i >> uint(31)
								if (_i >= 0 && shifted > 0) || (_i < 0 && shifted < -1) {
									colexecerror.ExpectedError(tree.ErrInt4OutOfRange)
								}
								r = int32(_i)

							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castStringIntOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castStringIntOp{}
var _ colexecop.ClosableOperator = &castStringIntOp{}

func (c *castStringIntOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int64()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								_s := string(v)
								_i, err := strconv.ParseInt(strings.TrimSpace(_s), 0, 64)
								if err != nil {
									colexecerror.ExpectedError(tree.MakeParseError(_s, toType, err))
								}
								r = int64(_i)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								_s := string(v)
								_i, err := strconv.ParseInt(strings.TrimSpace(_s), 0, 64)
								if err != nil {
									colexecerror.ExpectedError(tree.MakeParseError(_s, toType, err))
								}
								r = int64(_i)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								_s := string(v)
								_i, err := strconv.ParseInt(strings.TrimSpace(_s), 0, 64)
								if err != nil {
									colexecerror.ExpectedError(tree.MakeParseError(_s, toType, err))
								}
								r = int64(_i)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								_s := string(v)
								_i, err := strconv.ParseInt(strings.TrimSpace(_s), 0, 64)
								if err != nil {
									colexecerror.ExpectedError(tree.MakeParseError(_s, toType, err))
								}
								r = int64(_i)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castStringIntervalOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castStringIntervalOp{}
var _ colexecop.ClosableOperator = &castStringIntervalOp{}

func (c *castStringIntervalOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Interval()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r duration.Duration

							_itm, err := toType.IntervalTypeMetadata()
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							_intervalStyle := evalCtx.GetIntervalStyle()
							r, err = tree.ParseIntervalWithTypeMetadata(_intervalStyle, string(v), _itm)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r duration.Duration

							_itm, err := toType.IntervalTypeMetadata()
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							_intervalStyle := evalCtx.GetIntervalStyle()
							r, err = tree.ParseIntervalWithTypeMetadata(_intervalStyle, string(v), _itm)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r duration.Duration

							_itm, err := toType.IntervalTypeMetadata()
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							_intervalStyle := evalCtx.GetIntervalStyle()
							r, err = tree.ParseIntervalWithTypeMetadata(_intervalStyle, string(v), _itm)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r duration.Duration

							_itm, err := toType.IntervalTypeMetadata()
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							_intervalStyle := evalCtx.GetIntervalStyle()
							r, err = tree.ParseIntervalWithTypeMetadata(_intervalStyle, string(v), _itm)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castStringJsonbOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castStringJsonbOp{}
var _ colexecop.ClosableOperator = &castStringJsonbOp{}

func (c *castStringJsonbOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.JSON()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r json.JSON

							var err error
							r, err = json.ParseJSON(string(v))
							if err != nil {
								colexecerror.ExpectedError(pgerror.Wrapf(err, pgcode.Syntax, "could not parse JSON"))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r json.JSON

							var err error
							r, err = json.ParseJSON(string(v))
							if err != nil {
								colexecerror.ExpectedError(pgerror.Wrapf(err, pgcode.Syntax, "could not parse JSON"))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r json.JSON

							var err error
							r, err = json.ParseJSON(string(v))
							if err != nil {
								colexecerror.ExpectedError(pgerror.Wrapf(err, pgcode.Syntax, "could not parse JSON"))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r json.JSON

							var err error
							r, err = json.ParseJSON(string(v))
							if err != nil {
								colexecerror.ExpectedError(pgerror.Wrapf(err, pgcode.Syntax, "could not parse JSON"))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castStringStringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castStringStringOp{}
var _ colexecop.ClosableOperator = &castStringStringOp{}

func (c *castStringStringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = v
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = v
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = v
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = v
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castStringTimestampOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castStringTimestampOp{}
var _ colexecop.ClosableOperator = &castStringTimestampOp{}

func (c *castStringTimestampOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Timestamp()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							_roundTo := tree.TimeFamilyPrecisionToRoundDuration(toType.Precision())
							_now := evalCtx.GetRelativeParseTime()
							_dateStyle := evalCtx.GetDateStyle()
							_h := evalCtx.GetDateHelper()
							_t, _, err := pgdate.ParseTimestampWithoutTimezone(_now, _dateStyle, string(v), _h)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							r = _t.Round(_roundTo)
							if r.After(tree.MaxSupportedTime) || r.Before(tree.MinSupportedTime) {
								colexecerror.ExpectedError(tree.NewTimestampExceedsBoundsError(r))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							_roundTo := tree.TimeFamilyPrecisionToRoundDuration(toType.Precision())
							_now := evalCtx.GetRelativeParseTime()
							_dateStyle := evalCtx.GetDateStyle()
							_h := evalCtx.GetDateHelper()
							_t, _, err := pgdate.ParseTimestampWithoutTimezone(_now, _dateStyle, string(v), _h)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							r = _t.Round(_roundTo)
							if r.After(tree.MaxSupportedTime) || r.Before(tree.MinSupportedTime) {
								colexecerror.ExpectedError(tree.NewTimestampExceedsBoundsError(r))
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							_roundTo := tree.TimeFamilyPrecisionToRoundDuration(toType.Precision())
							_now := evalCtx.GetRelativeParseTime()
							_dateStyle := evalCtx.GetDateStyle()
							_h := evalCtx.GetDateHelper()
							_t, _, err := pgdate.ParseTimestampWithoutTimezone(_now, _dateStyle, string(v), _h)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							r = _t.Round(_roundTo)
							if r.After(tree.MaxSupportedTime) || r.Before(tree.MinSupportedTime) {
								colexecerror.ExpectedError(tree.NewTimestampExceedsBoundsError(r))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							_roundTo := tree.TimeFamilyPrecisionToRoundDuration(toType.Precision())
							_now := evalCtx.GetRelativeParseTime()
							_dateStyle := evalCtx.GetDateStyle()
							_h := evalCtx.GetDateHelper()
							_t, _, err := pgdate.ParseTimestampWithoutTimezone(_now, _dateStyle, string(v), _h)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							r = _t.Round(_roundTo)
							if r.After(tree.MaxSupportedTime) || r.Before(tree.MinSupportedTime) {
								colexecerror.ExpectedError(tree.NewTimestampExceedsBoundsError(r))
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castStringTimestamptzOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castStringTimestamptzOp{}
var _ colexecop.ClosableOperator = &castStringTimestamptzOp{}

func (c *castStringTimestamptzOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Timestamp()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							_roundTo := tree.TimeFamilyPrecisionToRoundDuration(toType.Precision())
							_now := evalCtx.GetRelativeParseTime()
							_dateStyle := evalCtx.GetDateStyle()
							_h := evalCtx.GetDateHelper()
							_t, _, err := pgdate.ParseTimestamp(_now, _dateStyle, string(v), _h)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							r = _t.Round(_roundTo)
							if r.After(tree.MaxSupportedTime) || r.Before(tree.MinSupportedTime) {
								colexecerror.ExpectedError(tree.NewTimestampExceedsBoundsError(r))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							_roundTo := tree.TimeFamilyPrecisionToRoundDuration(toType.Precision())
							_now := evalCtx.GetRelativeParseTime()
							_dateStyle := evalCtx.GetDateStyle()
							_h := evalCtx.GetDateHelper()
							_t, _, err := pgdate.ParseTimestamp(_now, _dateStyle, string(v), _h)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							r = _t.Round(_roundTo)
							if r.After(tree.MaxSupportedTime) || r.Before(tree.MinSupportedTime) {
								colexecerror.ExpectedError(tree.NewTimestampExceedsBoundsError(r))
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							_roundTo := tree.TimeFamilyPrecisionToRoundDuration(toType.Precision())
							_now := evalCtx.GetRelativeParseTime()
							_dateStyle := evalCtx.GetDateStyle()
							_h := evalCtx.GetDateHelper()
							_t, _, err := pgdate.ParseTimestamp(_now, _dateStyle, string(v), _h)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							r = _t.Round(_roundTo)
							if r.After(tree.MaxSupportedTime) || r.Before(tree.MinSupportedTime) {
								colexecerror.ExpectedError(tree.NewTimestampExceedsBoundsError(r))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							_roundTo := tree.TimeFamilyPrecisionToRoundDuration(toType.Precision())
							_now := evalCtx.GetRelativeParseTime()
							_dateStyle := evalCtx.GetDateStyle()
							_h := evalCtx.GetDateHelper()
							_t, _, err := pgdate.ParseTimestamp(_now, _dateStyle, string(v), _h)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

							r = _t.Round(_roundTo)
							if r.After(tree.MaxSupportedTime) || r.Before(tree.MinSupportedTime) {
								colexecerror.ExpectedError(tree.NewTimestampExceedsBoundsError(r))
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castStringUuidOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castStringUuidOp{}
var _ colexecop.ClosableOperator = &castStringUuidOp{}

func (c *castStringUuidOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_uuid, err := uuid.FromString(string(v))
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = _uuid.GetBytes()

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_uuid, err := uuid.FromString(string(v))
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = _uuid.GetBytes()

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_uuid, err := uuid.FromString(string(v))
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = _uuid.GetBytes()

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_uuid, err := uuid.FromString(string(v))
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = _uuid.GetBytes()

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castTimestampStringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castTimestampStringOp{}
var _ colexecop.ClosableOperator = &castTimestampStringOp{}

func (c *castTimestampStringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Timestamp()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = tree.PGWireFormatTimestamp(v, nil, r)
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = tree.PGWireFormatTimestamp(v, nil, r)
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = tree.PGWireFormatTimestamp(v, nil, r)
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							r = tree.PGWireFormatTimestamp(v, nil, r)
							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castTimestamptzStringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castTimestamptzStringOp{}
var _ colexecop.ClosableOperator = &castTimestamptzStringOp{}

func (c *castTimestamptzStringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Timestamp()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							// Convert to context timezone for correct display.
							_t := v

							_t = _t.Round(time.Microsecond)
							if _t.After(tree.MaxSupportedTime) || _t.Before(tree.MinSupportedTime) {
								colexecerror.ExpectedError(tree.NewTimestampExceedsBoundsError(_t))
							}

							r = tree.PGWireFormatTimestamp(_t, evalCtx.GetLocation(), r)

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							// Convert to context timezone for correct display.
							_t := v

							_t = _t.Round(time.Microsecond)
							if _t.After(tree.MaxSupportedTime) || _t.Before(tree.MinSupportedTime) {
								colexecerror.ExpectedError(tree.NewTimestampExceedsBoundsError(_t))
							}

							r = tree.PGWireFormatTimestamp(_t, evalCtx.GetLocation(), r)

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							// Convert to context timezone for correct display.
							_t := v

							_t = _t.Round(time.Microsecond)
							if _t.After(tree.MaxSupportedTime) || _t.Before(tree.MinSupportedTime) {
								colexecerror.ExpectedError(tree.NewTimestampExceedsBoundsError(_t))
							}

							r = tree.PGWireFormatTimestamp(_t, evalCtx.GetLocation(), r)

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = inputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							//gcassert:bce
							v := inputCol.Get(tupleIdx)
							var r []byte

							// Convert to context timezone for correct display.
							_t := v

							_t = _t.Round(time.Microsecond)
							if _t.After(tree.MaxSupportedTime) || _t.Before(tree.MinSupportedTime) {
								colexecerror.ExpectedError(tree.NewTimestampExceedsBoundsError(_t))
							}

							r = tree.PGWireFormatTimestamp(_t, evalCtx.GetLocation(), r)

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castUuidStringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castUuidStringOp{}
var _ colexecop.ClosableOperator = &castUuidStringOp{}

func (c *castUuidStringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Bytes()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_uuid, err := uuid.FromBytes(v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = []byte(_uuid.String())

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_uuid, err := uuid.FromBytes(v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = []byte(_uuid.String())

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_uuid, err := uuid.FromBytes(v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = []byte(_uuid.String())

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							_uuid, err := uuid.FromBytes(v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}
							r = []byte(_uuid.String())

							if toType.Oid() != oid.T_name {
								// bpchar types truncate trailing whitespace.
								if toType.Oid() == oid.T_bpchar {
									r = bytes.TrimRight(r, " ")
								}
								// If the string type specifies a limit we truncate to that limit:
								//   'hello'::CHAR(2) -> 'he'
								// This is true of all the string type variants.
								if toType.Width() > 0 {
									r = []byte(util.TruncateString(string(r), int(toType.Width())))
								}
								if toType.Oid() == oid.T_char {
									// "char" is supposed to truncate long values.
									r = []byte(util.TruncateString(string(r), 1))
								}
							}
							if toType.Width() > 0 && utf8.RuneCountInString(string(r)) > int(toType.Width()) {
								_typeString := toType.SQLString()
								colexecerror.ExpectedError(
									pgerror.Newf(pgcode.StringDataRightTruncation, "value too long for type "+_typeString))
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDatumBoolOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDatumBoolOp{}
var _ colexecop.ClosableOperator = &castDatumBoolOp{}

func (c *castDatumBoolOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Datum()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bool()
			outputNulls := outputVec.Nulls()
			converter := colconv.GetDatumToPhysicalFn(toType)
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(bool)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(bool)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(bool)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r bool

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(bool)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDatumInt2Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDatumInt2Op{}
var _ colexecop.ClosableOperator = &castDatumInt2Op{}

func (c *castDatumInt2Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Datum()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int16()
			outputNulls := outputVec.Nulls()
			converter := colconv.GetDatumToPhysicalFn(toType)
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int16)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int16)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int16)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int16

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int16)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDatumInt4Op struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDatumInt4Op{}
var _ colexecop.ClosableOperator = &castDatumInt4Op{}

func (c *castDatumInt4Op) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Datum()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int32()
			outputNulls := outputVec.Nulls()
			converter := colconv.GetDatumToPhysicalFn(toType)
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int32)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int32)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int32)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int32

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int32)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDatumIntOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDatumIntOp{}
var _ colexecop.ClosableOperator = &castDatumIntOp{}

func (c *castDatumIntOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Datum()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int64()
			outputNulls := outputVec.Nulls()
			converter := colconv.GetDatumToPhysicalFn(toType)
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int64)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int64)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int64)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int64)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDatumFloatOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDatumFloatOp{}
var _ colexecop.ClosableOperator = &castDatumFloatOp{}

func (c *castDatumFloatOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Datum()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Float64()
			outputNulls := outputVec.Nulls()
			converter := colconv.GetDatumToPhysicalFn(toType)
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(float64)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(float64)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(float64)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r float64

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(float64)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDatumDecimalOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDatumDecimalOp{}
var _ colexecop.ClosableOperator = &castDatumDecimalOp{}

func (c *castDatumDecimalOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Datum()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Decimal()
			outputNulls := outputVec.Nulls()
			converter := colconv.GetDatumToPhysicalFn(toType)
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(apd.Decimal)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(apd.Decimal)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(apd.Decimal)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r apd.Decimal

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(apd.Decimal)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDatumDateOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDatumDateOp{}
var _ colexecop.ClosableOperator = &castDatumDateOp{}

func (c *castDatumDateOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Datum()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Int64()
			outputNulls := outputVec.Nulls()
			converter := colconv.GetDatumToPhysicalFn(toType)
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int64)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int64)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int64)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r int64

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(int64)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDatumTimestampOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDatumTimestampOp{}
var _ colexecop.ClosableOperator = &castDatumTimestampOp{}

func (c *castDatumTimestampOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Datum()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Timestamp()
			outputNulls := outputVec.Nulls()
			converter := colconv.GetDatumToPhysicalFn(toType)
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(time.Time)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(time.Time)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(time.Time)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(time.Time)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDatumIntervalOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDatumIntervalOp{}
var _ colexecop.ClosableOperator = &castDatumIntervalOp{}

func (c *castDatumIntervalOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Datum()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Interval()
			outputNulls := outputVec.Nulls()
			converter := colconv.GetDatumToPhysicalFn(toType)
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r duration.Duration

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(duration.Duration)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r duration.Duration

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(duration.Duration)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r duration.Duration

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(duration.Duration)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r duration.Duration

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(duration.Duration)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDatumStringOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDatumStringOp{}
var _ colexecop.ClosableOperator = &castDatumStringOp{}

func (c *castDatumStringOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Datum()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			converter := colconv.GetDatumToPhysicalFn(toType)
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).([]byte)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).([]byte)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).([]byte)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).([]byte)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDatumBytesOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDatumBytesOp{}
var _ colexecop.ClosableOperator = &castDatumBytesOp{}

func (c *castDatumBytesOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Datum()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			converter := colconv.GetDatumToPhysicalFn(toType)
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).([]byte)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).([]byte)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).([]byte)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).([]byte)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDatumTimestamptzOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDatumTimestamptzOp{}
var _ colexecop.ClosableOperator = &castDatumTimestamptzOp{}

func (c *castDatumTimestamptzOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Datum()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Timestamp()
			outputNulls := outputVec.Nulls()
			converter := colconv.GetDatumToPhysicalFn(toType)
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(time.Time)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(time.Time)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(time.Time)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						_ = outputCol.Get(n - 1)
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r time.Time

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(time.Time)
							}

							//gcassert:bce
							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDatumUuidOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDatumUuidOp{}
var _ colexecop.ClosableOperator = &castDatumUuidOp{}

func (c *castDatumUuidOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Datum()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Bytes()
			outputNulls := outputVec.Nulls()
			converter := colconv.GetDatumToPhysicalFn(toType)
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).([]byte)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).([]byte)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).([]byte)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r []byte

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).([]byte)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDatumJsonbOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDatumJsonbOp{}
var _ colexecop.ClosableOperator = &castDatumJsonbOp{}

func (c *castDatumJsonbOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Datum()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.JSON()
			outputNulls := outputVec.Nulls()
			converter := colconv.GetDatumToPhysicalFn(toType)
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r json.JSON

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(json.JSON)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r json.JSON

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(json.JSON)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r json.JSON

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(json.JSON)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r json.JSON

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = converter(_castedDatum).(json.JSON)
							}

							outputCol.Set(tupleIdx, r)
						}
					}
				}
			}
		},
	)
	return batch
}

type castDatumDatumOp struct {
	castOpBase
}

var _ colexecop.ResettableOperator = &castDatumDatumOp{}
var _ colexecop.ClosableOperator = &castDatumDatumOp{}

func (c *castDatumDatumOp) Next() coldata.Batch {
	batch := c.Input.Next()
	n := batch.Length()
	if n == 0 {
		return coldata.ZeroBatch
	}
	sel := batch.Selection()
	inputVec := batch.ColVec(c.colIdx)
	outputVec := batch.ColVec(c.outputIdx)
	toType := outputVec.Type()
	// Remove unused warnings.
	_ = toType
	c.allocator.PerformOperation(
		[]*coldata.Vec{outputVec}, func() {
			inputCol := inputVec.Datum()
			inputNulls := inputVec.Nulls()
			outputCol := outputVec.Datum()
			outputNulls := outputVec.Nulls()
			if inputVec.MaybeHasNulls() {
				outputNulls.Copy(inputNulls)
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r interface{}

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = _castedDatum
							}

							outputCol.Set(tupleIdx, r)
							// Casting to datum-backed vector might produce a null value on
							// non-null tuple, so we need to check that case after the cast was
							// performed.
							if r == tree.DNull {
								outputNulls.SetNull(tupleIdx)
							}
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if true && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r interface{}

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = _castedDatum
							}

							outputCol.Set(tupleIdx, r)
							// Casting to datum-backed vector might produce a null value on
							// non-null tuple, so we need to check that case after the cast was
							// performed.
							if r == tree.DNull {
								outputNulls.SetNull(tupleIdx)
							}
						}
					}
				}
			} else {
				if sel != nil {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = sel[i]
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r interface{}

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = _castedDatum
							}

							outputCol.Set(tupleIdx, r)
							// Casting to datum-backed vector might produce a null value on
							// non-null tuple, so we need to check that case after the cast was
							// performed.
							if r == tree.DNull {
								outputNulls.SetNull(tupleIdx)
							}
						}
					}
				} else {
					{
						var (
							evalCtx *eval.Context = c.evalCtx
							buf     *bytes.Buffer = &c.buf
						)
						// Silence unused warnings.
						_ = evalCtx
						_ = buf
						var tupleIdx int
						for i := 0; i < n; i++ {
							tupleIdx = i
							if false && inputNulls.NullAt(tupleIdx) {
								continue
							}
							v := inputCol.Get(tupleIdx)
							var r interface{}

							{
								_castedDatum, err := eval.PerformCast(c.Ctx, evalCtx, v.(tree.Datum), toType)
								if err != nil {
									colexecerror.ExpectedError(err)
								}
								r = _castedDatum
							}

							outputCol.Set(tupleIdx, r)
							// Casting to datum-backed vector might produce a null value on
							// non-null tuple, so we need to check that case after the cast was
							// performed.
							if r == tree.DNull {
								outputNulls.SetNull(tupleIdx)
							}
						}
					}
				}
			}
		},
	)
	return batch
}

// castTuples casts all non-null tuples from the vector named 'inputCol' to the
// vector named 'outputCol'.
// execgen:inline
const _ = "template_castTuples"

// setNativeToDatumCast performs the cast of the converted datum in
// scratch[scratchIdx] to toType and sets the result into position outputIdx of
// outputCol (or into the output nulls bitmap).
// execgen:inline
const _ = "inlined_setNativeToDatumCast_true_false"

// setNativeToDatumCast performs the cast of the converted datum in
// scratch[scratchIdx] to toType and sets the result into position outputIdx of
// outputCol (or into the output nulls bitmap).
// execgen:inline
const _ = "inlined_setNativeToDatumCast_false_false"

// setNativeToDatumCast performs the cast of the converted datum in
// scratch[scratchIdx] to toType and sets the result into position outputIdx of
// outputCol (or into the output nulls bitmap).
// execgen:inline
const _ = "inlined_setNativeToDatumCast_true_true"

// setNativeToDatumCast performs the cast of the converted datum in
// scratch[scratchIdx] to toType and sets the result into position outputIdx of
// outputCol (or into the output nulls bitmap).
// execgen:inline
const _ = "inlined_setNativeToDatumCast_false_true"

// castTuples casts all non-null tuples from the vector named 'inputCol' to the
// vector named 'outputCol'.
// execgen:inline
const _ = "inlined_castTuples_true_true"

// castTuples casts all non-null tuples from the vector named 'inputCol' to the
// vector named 'outputCol'.
// execgen:inline
const _ = "inlined_castTuples_true_false"

// castTuples casts all non-null tuples from the vector named 'inputCol' to the
// vector named 'outputCol'.
// execgen:inline
const _ = "inlined_castTuples_false_true"

// castTuples casts all non-null tuples from the vector named 'inputCol' to the
// vector named 'outputCol'.
// execgen:inline
const _ = "inlined_castTuples_false_false"
