// Code generated by execgen; DO NOT EDIT.
// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecagg

import (
	"bytes"
	"math"
	"time"
	"unsafe"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/cockroach/pkg/util/json"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ tree.AggType
	_ apd.Context
	_ duration.Duration
	_ json.JSON
	_ = coldataext.CompareDatum
)

// Remove unused warning.
var _ = colexecerror.InternalError

func newMinWindowAggAlloc(
	allocator *colmem.Allocator, t *types.T, allocSize int64,
) aggregateFuncAlloc {
	allocBase := aggAllocBase{allocator: allocator, allocSize: allocSize}
	switch typeconv.TypeFamilyToCanonicalTypeFamily(t.Family()) {
	case types.BoolFamily:
		switch t.Width() {
		case -1:
		default:
			return &minBoolWindowAggAlloc{aggAllocBase: allocBase}
		}
	case types.BytesFamily:
		switch t.Width() {
		case -1:
		default:
			return &minBytesWindowAggAlloc{aggAllocBase: allocBase}
		}
	case types.DecimalFamily:
		switch t.Width() {
		case -1:
		default:
			return &minDecimalWindowAggAlloc{aggAllocBase: allocBase}
		}
	case types.IntFamily:
		switch t.Width() {
		case 16:
			return &minInt16WindowAggAlloc{aggAllocBase: allocBase}
		case 32:
			return &minInt32WindowAggAlloc{aggAllocBase: allocBase}
		case -1:
		default:
			return &minInt64WindowAggAlloc{aggAllocBase: allocBase}
		}
	case types.FloatFamily:
		switch t.Width() {
		case -1:
		default:
			return &minFloat64WindowAggAlloc{aggAllocBase: allocBase}
		}
	case types.TimestampTZFamily:
		switch t.Width() {
		case -1:
		default:
			return &minTimestampWindowAggAlloc{aggAllocBase: allocBase}
		}
	case types.IntervalFamily:
		switch t.Width() {
		case -1:
		default:
			return &minIntervalWindowAggAlloc{aggAllocBase: allocBase}
		}
	case types.JsonFamily:
		switch t.Width() {
		case -1:
		default:
			return &minJSONWindowAggAlloc{aggAllocBase: allocBase}
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch t.Width() {
		case -1:
		default:
			return &minDatumWindowAggAlloc{aggAllocBase: allocBase}
		}
	}
	colexecerror.InternalError(errors.AssertionFailedf("unexpectedly didn't find min overload for %s type family", t.Name()))
	// This code is unreachable, but the compiler cannot infer that.
	return nil
}

type minBoolWindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg bool
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minBoolWindowAgg{}

func (a *minBoolWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Bool(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						if !candidate && a.curAgg {
							cmpResult = -1
						} else if candidate && !a.curAgg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						if !candidate && a.curAgg {
							cmpResult = -1
						} else if candidate && !a.curAgg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minBoolWindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Bool()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minBoolWindowAgg) Reset() {
	a.numNonNull = 0
}

type minBoolWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []minBoolWindowAgg
}

var _ aggregateFuncAlloc = &minBoolWindowAggAlloc{}

const sizeOfminBoolWindowAgg = int64(unsafe.Sizeof(minBoolWindowAgg{}))
const minBoolWindowAggSliceOverhead = int64(unsafe.Sizeof([]minBoolWindowAgg{}))

func (a *minBoolWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minBoolWindowAggSliceOverhead + sizeOfminBoolWindowAgg*a.allocSize)
		a.aggFuncs = make([]minBoolWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*minBoolWindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on minBoolWindowAgg"))
}

type minBytesWindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg []byte
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minBytesWindowAgg{}

func (a *minBytesWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurAggSize := len(a.curAgg)
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Bytes(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = append(a.curAgg[:0], val...)
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(candidate, a.curAgg)
						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = append(a.curAgg[:0], candidate...)
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = append(a.curAgg[:0], val...)
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(candidate, a.curAgg)
						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = append(a.curAgg[:0], candidate...)
					}
				}
				a.numNonNull++
			}
		}
	}
	newCurAggSize := len(a.curAgg)
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minBytesWindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Bytes()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minBytesWindowAgg) Reset() {
	a.numNonNull = 0
	oldCurAggSize := len(a.curAgg)
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type minBytesWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []minBytesWindowAgg
}

var _ aggregateFuncAlloc = &minBytesWindowAggAlloc{}

const sizeOfminBytesWindowAgg = int64(unsafe.Sizeof(minBytesWindowAgg{}))
const minBytesWindowAggSliceOverhead = int64(unsafe.Sizeof([]minBytesWindowAgg{}))

func (a *minBytesWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minBytesWindowAggSliceOverhead + sizeOfminBytesWindowAgg*a.allocSize)
		a.aggFuncs = make([]minBytesWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*minBytesWindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on minBytesWindowAgg"))
}

type minDecimalWindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg apd.Decimal
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minDecimalWindowAgg{}

func (a *minDecimalWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurAggSize := a.curAgg.Size()
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Decimal(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg.Set(&val)
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg.Set(&candidate)
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg.Set(&val)
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg.Set(&candidate)
					}
				}
				a.numNonNull++
			}
		}
	}
	newCurAggSize := a.curAgg.Size()
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minDecimalWindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Decimal()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minDecimalWindowAgg) Reset() {
	a.numNonNull = 0
}

type minDecimalWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []minDecimalWindowAgg
}

var _ aggregateFuncAlloc = &minDecimalWindowAggAlloc{}

const sizeOfminDecimalWindowAgg = int64(unsafe.Sizeof(minDecimalWindowAgg{}))
const minDecimalWindowAggSliceOverhead = int64(unsafe.Sizeof([]minDecimalWindowAgg{}))

func (a *minDecimalWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minDecimalWindowAggSliceOverhead + sizeOfminDecimalWindowAgg*a.allocSize)
		a.aggFuncs = make([]minDecimalWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*minDecimalWindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on minDecimalWindowAgg"))
}

type minInt16WindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int16
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minInt16WindowAgg{}

func (a *minInt16WindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int16(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(candidate), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(candidate), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minInt16WindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Int16()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minInt16WindowAgg) Reset() {
	a.numNonNull = 0
}

type minInt16WindowAggAlloc struct {
	aggAllocBase
	aggFuncs []minInt16WindowAgg
}

var _ aggregateFuncAlloc = &minInt16WindowAggAlloc{}

const sizeOfminInt16WindowAgg = int64(unsafe.Sizeof(minInt16WindowAgg{}))
const minInt16WindowAggSliceOverhead = int64(unsafe.Sizeof([]minInt16WindowAgg{}))

func (a *minInt16WindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minInt16WindowAggSliceOverhead + sizeOfminInt16WindowAgg*a.allocSize)
		a.aggFuncs = make([]minInt16WindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*minInt16WindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on minInt16WindowAgg"))
}

type minInt32WindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int32
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minInt32WindowAgg{}

func (a *minInt32WindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int32(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(candidate), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(candidate), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minInt32WindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Int32()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minInt32WindowAgg) Reset() {
	a.numNonNull = 0
}

type minInt32WindowAggAlloc struct {
	aggAllocBase
	aggFuncs []minInt32WindowAgg
}

var _ aggregateFuncAlloc = &minInt32WindowAggAlloc{}

const sizeOfminInt32WindowAgg = int64(unsafe.Sizeof(minInt32WindowAgg{}))
const minInt32WindowAggSliceOverhead = int64(unsafe.Sizeof([]minInt32WindowAgg{}))

func (a *minInt32WindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minInt32WindowAggSliceOverhead + sizeOfminInt32WindowAgg*a.allocSize)
		a.aggFuncs = make([]minInt32WindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*minInt32WindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on minInt32WindowAgg"))
}

type minInt64WindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int64
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minInt64WindowAgg{}

func (a *minInt64WindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int64(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(candidate), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(candidate), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minInt64WindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Int64()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minInt64WindowAgg) Reset() {
	a.numNonNull = 0
}

type minInt64WindowAggAlloc struct {
	aggAllocBase
	aggFuncs []minInt64WindowAgg
}

var _ aggregateFuncAlloc = &minInt64WindowAggAlloc{}

const sizeOfminInt64WindowAgg = int64(unsafe.Sizeof(minInt64WindowAgg{}))
const minInt64WindowAggSliceOverhead = int64(unsafe.Sizeof([]minInt64WindowAgg{}))

func (a *minInt64WindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minInt64WindowAggSliceOverhead + sizeOfminInt64WindowAgg*a.allocSize)
		a.aggFuncs = make([]minInt64WindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*minInt64WindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on minInt64WindowAgg"))
}

type minFloat64WindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg float64
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minFloat64WindowAgg{}

func (a *minFloat64WindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Float64(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(candidate), float64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(candidate), float64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minFloat64WindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Float64()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minFloat64WindowAgg) Reset() {
	a.numNonNull = 0
}

type minFloat64WindowAggAlloc struct {
	aggAllocBase
	aggFuncs []minFloat64WindowAgg
}

var _ aggregateFuncAlloc = &minFloat64WindowAggAlloc{}

const sizeOfminFloat64WindowAgg = int64(unsafe.Sizeof(minFloat64WindowAgg{}))
const minFloat64WindowAggSliceOverhead = int64(unsafe.Sizeof([]minFloat64WindowAgg{}))

func (a *minFloat64WindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minFloat64WindowAggSliceOverhead + sizeOfminFloat64WindowAgg*a.allocSize)
		a.aggFuncs = make([]minFloat64WindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*minFloat64WindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on minFloat64WindowAgg"))
}

type minTimestampWindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg time.Time
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minTimestampWindowAgg{}

func (a *minTimestampWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Timestamp(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						if candidate.Before(a.curAgg) {
							cmpResult = -1
						} else if a.curAgg.Before(candidate) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						if candidate.Before(a.curAgg) {
							cmpResult = -1
						} else if a.curAgg.Before(candidate) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minTimestampWindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Timestamp()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minTimestampWindowAgg) Reset() {
	a.numNonNull = 0
}

type minTimestampWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []minTimestampWindowAgg
}

var _ aggregateFuncAlloc = &minTimestampWindowAggAlloc{}

const sizeOfminTimestampWindowAgg = int64(unsafe.Sizeof(minTimestampWindowAgg{}))
const minTimestampWindowAggSliceOverhead = int64(unsafe.Sizeof([]minTimestampWindowAgg{}))

func (a *minTimestampWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minTimestampWindowAggSliceOverhead + sizeOfminTimestampWindowAgg*a.allocSize)
		a.aggFuncs = make([]minTimestampWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*minTimestampWindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on minTimestampWindowAgg"))
}

type minIntervalWindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg duration.Duration
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minIntervalWindowAgg{}

func (a *minIntervalWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Interval(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int
						cmpResult = candidate.Compare(a.curAgg)
						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int
						cmpResult = candidate.Compare(a.curAgg)
						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minIntervalWindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Interval()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minIntervalWindowAgg) Reset() {
	a.numNonNull = 0
}

type minIntervalWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []minIntervalWindowAgg
}

var _ aggregateFuncAlloc = &minIntervalWindowAggAlloc{}

const sizeOfminIntervalWindowAgg = int64(unsafe.Sizeof(minIntervalWindowAgg{}))
const minIntervalWindowAggSliceOverhead = int64(unsafe.Sizeof([]minIntervalWindowAgg{}))

func (a *minIntervalWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minIntervalWindowAggSliceOverhead + sizeOfminIntervalWindowAgg*a.allocSize)
		a.aggFuncs = make([]minIntervalWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*minIntervalWindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on minIntervalWindowAgg"))
}

type minJSONWindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg json.JSON
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minJSONWindowAgg{}

func (a *minJSONWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.JSON(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)

					var _err error
					var _bytes []byte
					_bytes, _err = json.EncodeJSON(nil, val)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					a.curAgg, _err = json.FromEncoding(_bytes)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}

				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = candidate.Compare(a.curAgg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult < 0
					}

					if cmp {

						var _err error
						var _bytes []byte
						_bytes, _err = json.EncodeJSON(nil, candidate)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						a.curAgg, _err = json.FromEncoding(_bytes)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)

					var _err error
					var _bytes []byte
					_bytes, _err = json.EncodeJSON(nil, val)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					a.curAgg, _err = json.FromEncoding(_bytes)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}

				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = candidate.Compare(a.curAgg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult < 0
					}

					if cmp {

						var _err error
						var _bytes []byte
						_bytes, _err = json.EncodeJSON(nil, candidate)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						a.curAgg, _err = json.FromEncoding(_bytes)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if a.curAgg != nil {
		newCurAggSize = a.curAgg.Size()
	}
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minJSONWindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.JSON()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minJSONWindowAgg) Reset() {
	a.numNonNull = 0
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type minJSONWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []minJSONWindowAgg
}

var _ aggregateFuncAlloc = &minJSONWindowAggAlloc{}

const sizeOfminJSONWindowAgg = int64(unsafe.Sizeof(minJSONWindowAgg{}))
const minJSONWindowAggSliceOverhead = int64(unsafe.Sizeof([]minJSONWindowAgg{}))

func (a *minJSONWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minJSONWindowAggSliceOverhead + sizeOfminJSONWindowAgg*a.allocSize)
		a.aggFuncs = make([]minJSONWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*minJSONWindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on minJSONWindowAgg"))
}

type minDatumWindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg interface{}
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minDatumWindowAgg{}

func (a *minDatumWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Datum(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

						cmp = cmpResult < 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}

	var newCurAggSize uintptr
	if a.curAgg != nil {
		newCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minDatumWindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Datum()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minDatumWindowAgg) Reset() {
	a.numNonNull = 0

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type minDatumWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []minDatumWindowAgg
}

var _ aggregateFuncAlloc = &minDatumWindowAggAlloc{}

const sizeOfminDatumWindowAgg = int64(unsafe.Sizeof(minDatumWindowAgg{}))
const minDatumWindowAggSliceOverhead = int64(unsafe.Sizeof([]minDatumWindowAgg{}))

func (a *minDatumWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minDatumWindowAggSliceOverhead + sizeOfminDatumWindowAgg*a.allocSize)
		a.aggFuncs = make([]minDatumWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*minDatumWindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on minDatumWindowAgg"))
}

func newMaxWindowAggAlloc(
	allocator *colmem.Allocator, t *types.T, allocSize int64,
) aggregateFuncAlloc {
	allocBase := aggAllocBase{allocator: allocator, allocSize: allocSize}
	switch typeconv.TypeFamilyToCanonicalTypeFamily(t.Family()) {
	case types.BoolFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxBoolWindowAggAlloc{aggAllocBase: allocBase}
		}
	case types.BytesFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxBytesWindowAggAlloc{aggAllocBase: allocBase}
		}
	case types.DecimalFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxDecimalWindowAggAlloc{aggAllocBase: allocBase}
		}
	case types.IntFamily:
		switch t.Width() {
		case 16:
			return &maxInt16WindowAggAlloc{aggAllocBase: allocBase}
		case 32:
			return &maxInt32WindowAggAlloc{aggAllocBase: allocBase}
		case -1:
		default:
			return &maxInt64WindowAggAlloc{aggAllocBase: allocBase}
		}
	case types.FloatFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxFloat64WindowAggAlloc{aggAllocBase: allocBase}
		}
	case types.TimestampTZFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxTimestampWindowAggAlloc{aggAllocBase: allocBase}
		}
	case types.IntervalFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxIntervalWindowAggAlloc{aggAllocBase: allocBase}
		}
	case types.JsonFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxJSONWindowAggAlloc{aggAllocBase: allocBase}
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxDatumWindowAggAlloc{aggAllocBase: allocBase}
		}
	}
	colexecerror.InternalError(errors.AssertionFailedf("unexpectedly didn't find max overload for %s type family", t.Name()))
	// This code is unreachable, but the compiler cannot infer that.
	return nil
}

type maxBoolWindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg bool
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxBoolWindowAgg{}

func (a *maxBoolWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Bool(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						if !candidate && a.curAgg {
							cmpResult = -1
						} else if candidate && !a.curAgg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						if !candidate && a.curAgg {
							cmpResult = -1
						} else if candidate && !a.curAgg {
							cmpResult = 1
						} else {
							cmpResult = 0
						}

						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxBoolWindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Bool()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxBoolWindowAgg) Reset() {
	a.numNonNull = 0
}

type maxBoolWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []maxBoolWindowAgg
}

var _ aggregateFuncAlloc = &maxBoolWindowAggAlloc{}

const sizeOfmaxBoolWindowAgg = int64(unsafe.Sizeof(maxBoolWindowAgg{}))
const maxBoolWindowAggSliceOverhead = int64(unsafe.Sizeof([]maxBoolWindowAgg{}))

func (a *maxBoolWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxBoolWindowAggSliceOverhead + sizeOfmaxBoolWindowAgg*a.allocSize)
		a.aggFuncs = make([]maxBoolWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*maxBoolWindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on maxBoolWindowAgg"))
}

type maxBytesWindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg []byte
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxBytesWindowAgg{}

func (a *maxBytesWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurAggSize := len(a.curAgg)
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Bytes(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = append(a.curAgg[:0], val...)
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(candidate, a.curAgg)
						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = append(a.curAgg[:0], candidate...)
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = append(a.curAgg[:0], val...)
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int
						cmpResult = bytes.Compare(candidate, a.curAgg)
						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = append(a.curAgg[:0], candidate...)
					}
				}
				a.numNonNull++
			}
		}
	}
	newCurAggSize := len(a.curAgg)
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxBytesWindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Bytes()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxBytesWindowAgg) Reset() {
	a.numNonNull = 0
	oldCurAggSize := len(a.curAgg)
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type maxBytesWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []maxBytesWindowAgg
}

var _ aggregateFuncAlloc = &maxBytesWindowAggAlloc{}

const sizeOfmaxBytesWindowAgg = int64(unsafe.Sizeof(maxBytesWindowAgg{}))
const maxBytesWindowAggSliceOverhead = int64(unsafe.Sizeof([]maxBytesWindowAgg{}))

func (a *maxBytesWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxBytesWindowAggSliceOverhead + sizeOfmaxBytesWindowAgg*a.allocSize)
		a.aggFuncs = make([]maxBytesWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*maxBytesWindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on maxBytesWindowAgg"))
}

type maxDecimalWindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg apd.Decimal
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxDecimalWindowAgg{}

func (a *maxDecimalWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurAggSize := a.curAgg.Size()
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Decimal(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg.Set(&val)
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg.Set(&candidate)
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg.Set(&val)
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int
						cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg.Set(&candidate)
					}
				}
				a.numNonNull++
			}
		}
	}
	newCurAggSize := a.curAgg.Size()
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxDecimalWindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Decimal()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxDecimalWindowAgg) Reset() {
	a.numNonNull = 0
}

type maxDecimalWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []maxDecimalWindowAgg
}

var _ aggregateFuncAlloc = &maxDecimalWindowAggAlloc{}

const sizeOfmaxDecimalWindowAgg = int64(unsafe.Sizeof(maxDecimalWindowAgg{}))
const maxDecimalWindowAggSliceOverhead = int64(unsafe.Sizeof([]maxDecimalWindowAgg{}))

func (a *maxDecimalWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxDecimalWindowAggSliceOverhead + sizeOfmaxDecimalWindowAgg*a.allocSize)
		a.aggFuncs = make([]maxDecimalWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*maxDecimalWindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on maxDecimalWindowAgg"))
}

type maxInt16WindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int16
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxInt16WindowAgg{}

func (a *maxInt16WindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int16(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(candidate), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(candidate), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxInt16WindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Int16()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxInt16WindowAgg) Reset() {
	a.numNonNull = 0
}

type maxInt16WindowAggAlloc struct {
	aggAllocBase
	aggFuncs []maxInt16WindowAgg
}

var _ aggregateFuncAlloc = &maxInt16WindowAggAlloc{}

const sizeOfmaxInt16WindowAgg = int64(unsafe.Sizeof(maxInt16WindowAgg{}))
const maxInt16WindowAggSliceOverhead = int64(unsafe.Sizeof([]maxInt16WindowAgg{}))

func (a *maxInt16WindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxInt16WindowAggSliceOverhead + sizeOfmaxInt16WindowAgg*a.allocSize)
		a.aggFuncs = make([]maxInt16WindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*maxInt16WindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on maxInt16WindowAgg"))
}

type maxInt32WindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int32
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxInt32WindowAgg{}

func (a *maxInt32WindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int32(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(candidate), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(candidate), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxInt32WindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Int32()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxInt32WindowAgg) Reset() {
	a.numNonNull = 0
}

type maxInt32WindowAggAlloc struct {
	aggAllocBase
	aggFuncs []maxInt32WindowAgg
}

var _ aggregateFuncAlloc = &maxInt32WindowAggAlloc{}

const sizeOfmaxInt32WindowAgg = int64(unsafe.Sizeof(maxInt32WindowAgg{}))
const maxInt32WindowAggSliceOverhead = int64(unsafe.Sizeof([]maxInt32WindowAgg{}))

func (a *maxInt32WindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxInt32WindowAggSliceOverhead + sizeOfmaxInt32WindowAgg*a.allocSize)
		a.aggFuncs = make([]maxInt32WindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*maxInt32WindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on maxInt32WindowAgg"))
}

type maxInt64WindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int64
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxInt64WindowAgg{}

func (a *maxInt64WindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int64(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(candidate), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := int64(candidate), int64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else {
								cmpResult = 0
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxInt64WindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Int64()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxInt64WindowAgg) Reset() {
	a.numNonNull = 0
}

type maxInt64WindowAggAlloc struct {
	aggAllocBase
	aggFuncs []maxInt64WindowAgg
}

var _ aggregateFuncAlloc = &maxInt64WindowAggAlloc{}

const sizeOfmaxInt64WindowAgg = int64(unsafe.Sizeof(maxInt64WindowAgg{}))
const maxInt64WindowAggSliceOverhead = int64(unsafe.Sizeof([]maxInt64WindowAgg{}))

func (a *maxInt64WindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxInt64WindowAggSliceOverhead + sizeOfmaxInt64WindowAgg*a.allocSize)
		a.aggFuncs = make([]maxInt64WindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*maxInt64WindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on maxInt64WindowAgg"))
}

type maxFloat64WindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg float64
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxFloat64WindowAgg{}

func (a *maxFloat64WindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Float64(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(candidate), float64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						{
							a, b := float64(candidate), float64(a.curAgg)
							if a < b {
								cmpResult = -1
							} else if a > b {
								cmpResult = 1
							} else if a == b {
								cmpResult = 0
							} else if math.IsNaN(a) {
								if math.IsNaN(b) {
									cmpResult = 0
								} else {
									cmpResult = -1
								}
							} else {
								cmpResult = 1
							}
						}

						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxFloat64WindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Float64()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxFloat64WindowAgg) Reset() {
	a.numNonNull = 0
}

type maxFloat64WindowAggAlloc struct {
	aggAllocBase
	aggFuncs []maxFloat64WindowAgg
}

var _ aggregateFuncAlloc = &maxFloat64WindowAggAlloc{}

const sizeOfmaxFloat64WindowAgg = int64(unsafe.Sizeof(maxFloat64WindowAgg{}))
const maxFloat64WindowAggSliceOverhead = int64(unsafe.Sizeof([]maxFloat64WindowAgg{}))

func (a *maxFloat64WindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxFloat64WindowAggSliceOverhead + sizeOfmaxFloat64WindowAgg*a.allocSize)
		a.aggFuncs = make([]maxFloat64WindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*maxFloat64WindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on maxFloat64WindowAgg"))
}

type maxTimestampWindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg time.Time
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxTimestampWindowAgg{}

func (a *maxTimestampWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Timestamp(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						if candidate.Before(a.curAgg) {
							cmpResult = -1
						} else if a.curAgg.Before(candidate) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						if candidate.Before(a.curAgg) {
							cmpResult = -1
						} else if a.curAgg.Before(candidate) {
							cmpResult = 1
						} else {
							cmpResult = 0
						}
						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxTimestampWindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Timestamp()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxTimestampWindowAgg) Reset() {
	a.numNonNull = 0
}

type maxTimestampWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []maxTimestampWindowAgg
}

var _ aggregateFuncAlloc = &maxTimestampWindowAggAlloc{}

const sizeOfmaxTimestampWindowAgg = int64(unsafe.Sizeof(maxTimestampWindowAgg{}))
const maxTimestampWindowAggSliceOverhead = int64(unsafe.Sizeof([]maxTimestampWindowAgg{}))

func (a *maxTimestampWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxTimestampWindowAggSliceOverhead + sizeOfmaxTimestampWindowAgg*a.allocSize)
		a.aggFuncs = make([]maxTimestampWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*maxTimestampWindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on maxTimestampWindowAgg"))
}

type maxIntervalWindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg duration.Duration
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxIntervalWindowAgg{}

func (a *maxIntervalWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Interval(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int
						cmpResult = candidate.Compare(a.curAgg)
						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int
						cmpResult = candidate.Compare(a.curAgg)
						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxIntervalWindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Interval()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxIntervalWindowAgg) Reset() {
	a.numNonNull = 0
}

type maxIntervalWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []maxIntervalWindowAgg
}

var _ aggregateFuncAlloc = &maxIntervalWindowAggAlloc{}

const sizeOfmaxIntervalWindowAgg = int64(unsafe.Sizeof(maxIntervalWindowAgg{}))
const maxIntervalWindowAggSliceOverhead = int64(unsafe.Sizeof([]maxIntervalWindowAgg{}))

func (a *maxIntervalWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxIntervalWindowAggSliceOverhead + sizeOfmaxIntervalWindowAgg*a.allocSize)
		a.aggFuncs = make([]maxIntervalWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*maxIntervalWindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on maxIntervalWindowAgg"))
}

type maxJSONWindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg json.JSON
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxJSONWindowAgg{}

func (a *maxJSONWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.JSON(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)

					var _err error
					var _bytes []byte
					_bytes, _err = json.EncodeJSON(nil, val)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					a.curAgg, _err = json.FromEncoding(_bytes)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}

				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = candidate.Compare(a.curAgg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult > 0
					}

					if cmp {

						var _err error
						var _bytes []byte
						_bytes, _err = json.EncodeJSON(nil, candidate)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						a.curAgg, _err = json.FromEncoding(_bytes)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)

					var _err error
					var _bytes []byte
					_bytes, _err = json.EncodeJSON(nil, val)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}
					a.curAgg, _err = json.FromEncoding(_bytes)
					if _err != nil {
						colexecerror.ExpectedError(_err)
					}

				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						var err error
						cmpResult, err = candidate.Compare(a.curAgg)
						if err != nil {
							colexecerror.ExpectedError(err)
						}

						cmp = cmpResult > 0
					}

					if cmp {

						var _err error
						var _bytes []byte
						_bytes, _err = json.EncodeJSON(nil, candidate)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						a.curAgg, _err = json.FromEncoding(_bytes)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

					}
				}
				a.numNonNull++
			}
		}
	}
	var newCurAggSize uintptr
	if a.curAgg != nil {
		newCurAggSize = a.curAgg.Size()
	}
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxJSONWindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.JSON()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxJSONWindowAgg) Reset() {
	a.numNonNull = 0
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type maxJSONWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []maxJSONWindowAgg
}

var _ aggregateFuncAlloc = &maxJSONWindowAggAlloc{}

const sizeOfmaxJSONWindowAgg = int64(unsafe.Sizeof(maxJSONWindowAgg{}))
const maxJSONWindowAggSliceOverhead = int64(unsafe.Sizeof([]maxJSONWindowAgg{}))

func (a *maxJSONWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxJSONWindowAggSliceOverhead + sizeOfmaxJSONWindowAgg*a.allocSize)
		a.aggFuncs = make([]maxJSONWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*maxJSONWindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on maxJSONWindowAgg"))
}

type maxDatumWindowAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg interface{}
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxDatumWindowAgg{}

func (a *maxDatumWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Datum(), vec.Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	_, _ = col.Get(endIdx-1), col.Get(startIdx)
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = nulls.NullAt(i)
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var isNull bool
			isNull = false
			if !isNull {
				if a.numNonNull == 0 {
					val := col.Get(i)
					a.curAgg = val
				} else {
					var cmp bool
					candidate := col.Get(i)

					{
						var cmpResult int

						cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

						cmp = cmpResult > 0
					}

					if cmp {
						a.curAgg = candidate
					}
				}
				a.numNonNull++
			}
		}
	}

	var newCurAggSize uintptr
	if a.curAgg != nil {
		newCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxDatumWindowAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Datum()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxDatumWindowAgg) Reset() {
	a.numNonNull = 0

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type maxDatumWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []maxDatumWindowAgg
}

var _ aggregateFuncAlloc = &maxDatumWindowAggAlloc{}

const sizeOfmaxDatumWindowAgg = int64(unsafe.Sizeof(maxDatumWindowAgg{}))
const maxDatumWindowAggSliceOverhead = int64(unsafe.Sizeof([]maxDatumWindowAgg{}))

func (a *maxDatumWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxDatumWindowAggSliceOverhead + sizeOfmaxDatumWindowAgg*a.allocSize)
		a.aggFuncs = make([]maxDatumWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go). This allows min and max operators to be used when
// the window frame only grows. For the case when the window frame can shrink,
// a specialized implementation is needed (see min_max_removable_agg_tmpl.go).
func (*maxDatumWindowAgg) Remove(vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int) {
	colexecerror.InternalError(errors.AssertionFailedf("Remove called on maxDatumWindowAgg"))
}
