// Code generated by execgen; DO NOT EDIT.
// Copyright 2018 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecagg

import (
	"unsafe"

	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
)

func newCountRowsWindowAggAlloc(
	allocator *colmem.Allocator, allocSize int64,
) aggregateFuncAlloc {
	return &countRowsWindowAggAlloc{aggAllocBase: aggAllocBase{
		allocator: allocator,
		allocSize: allocSize,
	}}
}

// countRowsWindowAgg supports either COUNT(*) or COUNT(col) aggregate.
type countRowsWindowAgg struct {
	unorderedAggregateFuncBase
	curAgg int64
}

var _ AggregateFunc = &countRowsWindowAgg{}

func (a *countRowsWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	{
		for i := startIdx; i < endIdx; i++ {

			var y int64
			y = int64(1)
			a.curAgg += y
		}
	}
}

func (a *countRowsWindowAgg) Flush(outputIdx int) {
	col := a.vec.Int64()
	col[outputIdx] = a.curAgg
}

func (a *countRowsWindowAgg) Reset() {
	a.curAgg = 0
}

type countRowsWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []countRowsWindowAgg
}

var _ aggregateFuncAlloc = &countRowsWindowAggAlloc{}

const sizeOfCountRowsWindowAgg = int64(unsafe.Sizeof(countRowsWindowAgg{}))
const countRowsWindowAggSliceOverhead = int64(unsafe.Sizeof([]countRowsWindowAgg{}))

func (a *countRowsWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(countRowsWindowAggSliceOverhead + sizeOfCountRowsWindowAgg*a.allocSize)
		a.aggFuncs = make([]countRowsWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

func newCountWindowAggAlloc(
	allocator *colmem.Allocator, allocSize int64,
) aggregateFuncAlloc {
	return &countWindowAggAlloc{aggAllocBase: aggAllocBase{
		allocator: allocator,
		allocSize: allocSize,
	}}
}

// countWindowAgg supports either COUNT(*) or COUNT(col) aggregate.
type countWindowAgg struct {
	unorderedAggregateFuncBase
	curAgg int64
}

var _ AggregateFunc = &countWindowAgg{}

func (a *countWindowAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	// If this is a COUNT(col) aggregator and there are nulls in this batch,
	// we must check each value for nullity. Note that it is only legal to do a
	// COUNT aggregate on a single column.
	nulls := vecs[inputIdxs[0]].Nulls()
	// Unnecessary memory accounting can have significant overhead for window
	// aggregate functions because Compute is called at least once for every row.
	// For this reason, we do not use PerformOperation here.
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var y int64
			y = int64(0)
			if !nulls.NullAt(i) {
				y = 1
			}
			a.curAgg += y
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var y int64
			y = int64(1)
			a.curAgg += y
		}
	}
}

func (a *countWindowAgg) Flush(outputIdx int) {
	col := a.vec.Int64()
	col[outputIdx] = a.curAgg
}

func (a *countWindowAgg) Reset() {
	a.curAgg = 0
}

// Remove implements the slidingWindowAggregateFunc interface (see
// window_aggregator_tmpl.go).
func (a *countWindowAgg) Remove(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int,
) {
	nulls := vecs[inputIdxs[0]].Nulls()
	if nulls.MaybeHasNulls() {
		for i := startIdx; i < endIdx; i++ {

			var y int64
			y = int64(0)
			if !nulls.NullAt(i) {
				y = 1
			}
			a.curAgg -= y
		}
	} else {
		for i := startIdx; i < endIdx; i++ {

			var y int64
			y = int64(1)
			a.curAgg -= y
		}
	}
}

type countWindowAggAlloc struct {
	aggAllocBase
	aggFuncs []countWindowAgg
}

var _ aggregateFuncAlloc = &countWindowAggAlloc{}

const sizeOfCountWindowAgg = int64(unsafe.Sizeof(countWindowAgg{}))
const countWindowAggSliceOverhead = int64(unsafe.Sizeof([]countWindowAgg{}))

func (a *countWindowAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(countWindowAggSliceOverhead + sizeOfCountWindowAgg*a.allocSize)
		a.aggFuncs = make([]countWindowAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}
