// Code generated by execgen; DO NOT EDIT.
// Copyright 2018 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecagg

import (
	"unsafe"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ tree.AggType
	_ apd.Context
	_ duration.Duration
	_ = typeconv.TypeFamilyToCanonicalTypeFamily
)

const sumIntNumOverloads = 3

func init() {
	// Sanity check the hard-coded number of overloads.
	var numOverloads int
	numOverloads++
	numOverloads++
	numOverloads++
	if numOverloads != sumIntNumOverloads {
		colexecerror.InternalError(errors.AssertionFailedf(
			"sumIntNumOverloads should be updated: expected %d, found %d", numOverloads, sumIntNumOverloads,
		))
	}
}

// sumIntOverloadOffset returns the offset for this particular type overload
// within contiguous slice of allocators for this aggregate function.
func sumIntOverloadOffset(t *types.T) int {
	var offset int
	canonicalTypeFamily := typeconv.TypeFamilyToCanonicalTypeFamily(t.Family())
	if canonicalTypeFamily == types.IntFamily {
		if t.Width() == 16 {
			return offset
		}
		offset++
		if t.Width() == 32 {
			return offset
		}
		offset++
		return offset
	}
	offset += 3
	colexecerror.InternalError(errors.AssertionFailedf("didn't find overload offset for %s", t.SQLStringForError()))
	return 0
}

func newSumIntOrderedAggAlloc(
	allocator *colmem.Allocator, t *types.T, allocSize int64,
) (aggregateFuncAlloc, error) {
	allocBase := aggAllocBase{allocator: allocator, allocSize: allocSize}
	switch t.Family() {
	case types.IntFamily:
		switch t.Width() {
		case 16:
			return &sumIntInt16OrderedAggAlloc{aggAllocBase: allocBase}, nil
		case 32:
			return &sumIntInt32OrderedAggAlloc{aggAllocBase: allocBase}, nil
		case -1:
		default:
			return &sumIntInt64OrderedAggAlloc{aggAllocBase: allocBase}, nil
		}
	}
	return nil, errors.AssertionFailedf("unsupported sum agg type %s", t.Name())
}

type sumIntInt16OrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Int64s
	// curAgg holds the running total, so we can index into the slice once per
	// group, instead of on each iteration.
	curAgg int64
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &sumIntInt16OrderedAgg{}

func (a *sumIntInt16OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Int64()
}

func (a *sumIntInt16OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int16(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curAgg
							}
							a.curIdx++
							a.curAgg = zeroInt64Value

							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{
							result := int64(a.curAgg) + int64(v)
							if (result < int64(a.curAgg)) != (int64(v) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							a.curAgg = result
						}

						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curAgg
							}
							a.curIdx++
							a.curAgg = zeroInt64Value

						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{
							result := int64(a.curAgg) + int64(v)
							if (result < int64(a.curAgg)) != (int64(v) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							a.curAgg = result
						}

						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curAgg
							}
							a.curIdx++
							a.curAgg = zeroInt64Value

							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						v := col.Get(i)

						{
							result := int64(a.curAgg) + int64(v)
							if (result < int64(a.curAgg)) != (int64(v) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							a.curAgg = result
						}

						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curAgg
							}
							a.curIdx++
							a.curAgg = zeroInt64Value

						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						v := col.Get(i)

						{
							result := int64(a.curAgg) + int64(v)
							if (result < int64(a.curAgg)) != (int64(v) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							a.curAgg = result
						}

						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *sumIntInt16OrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should be
	// null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *sumIntInt16OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.curAgg = zeroInt64Value
	a.numNonNull = 0
}

type sumIntInt16OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []sumIntInt16OrderedAgg
}

var _ aggregateFuncAlloc = &sumIntInt16OrderedAggAlloc{}

const sizeOfSumIntInt16OrderedAgg = int64(unsafe.Sizeof(sumIntInt16OrderedAgg{}))
const sumIntInt16OrderedAggSliceOverhead = int64(unsafe.Sizeof([]sumIntInt16OrderedAgg{}))

func (a *sumIntInt16OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(sumIntInt16OrderedAggSliceOverhead + sizeOfSumIntInt16OrderedAgg*a.allocSize)
		a.aggFuncs = make([]sumIntInt16OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type sumIntInt32OrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Int64s
	// curAgg holds the running total, so we can index into the slice once per
	// group, instead of on each iteration.
	curAgg int64
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &sumIntInt32OrderedAgg{}

func (a *sumIntInt32OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Int64()
}

func (a *sumIntInt32OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int32(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curAgg
							}
							a.curIdx++
							a.curAgg = zeroInt64Value

							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{
							result := int64(a.curAgg) + int64(v)
							if (result < int64(a.curAgg)) != (int64(v) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							a.curAgg = result
						}

						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curAgg
							}
							a.curIdx++
							a.curAgg = zeroInt64Value

						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{
							result := int64(a.curAgg) + int64(v)
							if (result < int64(a.curAgg)) != (int64(v) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							a.curAgg = result
						}

						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curAgg
							}
							a.curIdx++
							a.curAgg = zeroInt64Value

							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						v := col.Get(i)

						{
							result := int64(a.curAgg) + int64(v)
							if (result < int64(a.curAgg)) != (int64(v) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							a.curAgg = result
						}

						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curAgg
							}
							a.curIdx++
							a.curAgg = zeroInt64Value

						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						v := col.Get(i)

						{
							result := int64(a.curAgg) + int64(v)
							if (result < int64(a.curAgg)) != (int64(v) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							a.curAgg = result
						}

						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *sumIntInt32OrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should be
	// null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *sumIntInt32OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.curAgg = zeroInt64Value
	a.numNonNull = 0
}

type sumIntInt32OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []sumIntInt32OrderedAgg
}

var _ aggregateFuncAlloc = &sumIntInt32OrderedAggAlloc{}

const sizeOfSumIntInt32OrderedAgg = int64(unsafe.Sizeof(sumIntInt32OrderedAgg{}))
const sumIntInt32OrderedAggSliceOverhead = int64(unsafe.Sizeof([]sumIntInt32OrderedAgg{}))

func (a *sumIntInt32OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(sumIntInt32OrderedAggSliceOverhead + sizeOfSumIntInt32OrderedAgg*a.allocSize)
		a.aggFuncs = make([]sumIntInt32OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type sumIntInt64OrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Int64s
	// curAgg holds the running total, so we can index into the slice once per
	// group, instead of on each iteration.
	curAgg int64
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &sumIntInt64OrderedAgg{}

func (a *sumIntInt64OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Int64()
}

func (a *sumIntInt64OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int64(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curAgg
							}
							a.curIdx++
							a.curAgg = zeroInt64Value

							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{
							result := int64(a.curAgg) + int64(v)
							if (result < int64(a.curAgg)) != (int64(v) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							a.curAgg = result
						}

						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curAgg
							}
							a.curIdx++
							a.curAgg = zeroInt64Value

						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{
							result := int64(a.curAgg) + int64(v)
							if (result < int64(a.curAgg)) != (int64(v) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							a.curAgg = result
						}

						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curAgg
							}
							a.curIdx++
							a.curAgg = zeroInt64Value

							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						v := col.Get(i)

						{
							result := int64(a.curAgg) + int64(v)
							if (result < int64(a.curAgg)) != (int64(v) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							a.curAgg = result
						}

						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curAgg
							}
							a.curIdx++
							a.curAgg = zeroInt64Value

						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						v := col.Get(i)

						{
							result := int64(a.curAgg) + int64(v)
							if (result < int64(a.curAgg)) != (int64(v) < 0) {
								colexecerror.ExpectedError(tree.ErrIntOutOfRange)
							}
							a.curAgg = result
						}

						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *sumIntInt64OrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should be
	// null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *sumIntInt64OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.curAgg = zeroInt64Value
	a.numNonNull = 0
}

type sumIntInt64OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []sumIntInt64OrderedAgg
}

var _ aggregateFuncAlloc = &sumIntInt64OrderedAggAlloc{}

const sizeOfSumIntInt64OrderedAgg = int64(unsafe.Sizeof(sumIntInt64OrderedAgg{}))
const sumIntInt64OrderedAggSliceOverhead = int64(unsafe.Sizeof([]sumIntInt64OrderedAgg{}))

func (a *sumIntInt64OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(sumIntInt64OrderedAggSliceOverhead + sizeOfSumIntInt64OrderedAgg*a.allocSize)
		a.aggFuncs = make([]sumIntInt64OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}
