// Code generated by execgen; DO NOT EDIT.
// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecagg

import (
	"bytes"
	"math"
	"time"
	"unsafe"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/cockroach/pkg/util/json"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ tree.AggType
	_ apd.Context
	_ duration.Duration
	_ json.JSON
	_ = coldataext.CompareDatum
)

// Remove unused warning.
var _ = colexecerror.InternalError

const minMaxNumOverloads = 11

func init() {
	// Sanity check the hard-coded number of overloads.
	var numOverloads int
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	if numOverloads != minMaxNumOverloads {
		colexecerror.InternalError(errors.AssertionFailedf(
			"minMaxNumOverloads should be updated: expected %d, found %d", numOverloads, minMaxNumOverloads,
		))
	}
}

// minMaxOverloadOffset returns the offset for this particular type overload
// within contiguous slice of allocators for this aggregate function.
func minMaxOverloadOffset(t *types.T) int {
	var offset int
	canonicalTypeFamily := typeconv.TypeFamilyToCanonicalTypeFamily(t.Family())
	if canonicalTypeFamily == types.BoolFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == types.BytesFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == types.DecimalFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == types.IntFamily {
		if t.Width() == 16 {
			return offset
		}
		offset++
		if t.Width() == 32 {
			return offset
		}
		offset++
		return offset
	}
	offset += 3
	if canonicalTypeFamily == types.FloatFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == types.TimestampTZFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == types.IntervalFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == types.JsonFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == typeconv.DatumVecCanonicalTypeFamily {
		return offset
	}
	offset += 1
	colexecerror.InternalError(errors.AssertionFailedf("didn't find overload offset for %s", t.SQLStringForError()))
	return 0
}

func newMinOrderedAggAlloc(
	allocator *colmem.Allocator, t *types.T, allocSize int64,
) aggregateFuncAlloc {
	allocBase := aggAllocBase{allocator: allocator, allocSize: allocSize}
	switch typeconv.TypeFamilyToCanonicalTypeFamily(t.Family()) {
	case types.BoolFamily:
		switch t.Width() {
		case -1:
		default:
			return &minBoolOrderedAggAlloc{aggAllocBase: allocBase}
		}
	case types.BytesFamily:
		switch t.Width() {
		case -1:
		default:
			return &minBytesOrderedAggAlloc{aggAllocBase: allocBase}
		}
	case types.DecimalFamily:
		switch t.Width() {
		case -1:
		default:
			return &minDecimalOrderedAggAlloc{aggAllocBase: allocBase}
		}
	case types.IntFamily:
		switch t.Width() {
		case 16:
			return &minInt16OrderedAggAlloc{aggAllocBase: allocBase}
		case 32:
			return &minInt32OrderedAggAlloc{aggAllocBase: allocBase}
		case -1:
		default:
			return &minInt64OrderedAggAlloc{aggAllocBase: allocBase}
		}
	case types.FloatFamily:
		switch t.Width() {
		case -1:
		default:
			return &minFloat64OrderedAggAlloc{aggAllocBase: allocBase}
		}
	case types.TimestampTZFamily:
		switch t.Width() {
		case -1:
		default:
			return &minTimestampOrderedAggAlloc{aggAllocBase: allocBase}
		}
	case types.IntervalFamily:
		switch t.Width() {
		case -1:
		default:
			return &minIntervalOrderedAggAlloc{aggAllocBase: allocBase}
		}
	case types.JsonFamily:
		switch t.Width() {
		case -1:
		default:
			return &minJSONOrderedAggAlloc{aggAllocBase: allocBase}
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch t.Width() {
		case -1:
		default:
			return &minDatumOrderedAggAlloc{aggAllocBase: allocBase}
		}
	}
	colexecerror.InternalError(errors.AssertionFailedf("unexpectedly didn't find min overload for %s type family", t.Name()))
	// This code is unreachable, but the compiler cannot infer that.
	return nil
}

type minBoolOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Bools
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg bool
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minBoolOrderedAgg{}

func (a *minBoolOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Bool()
}

func (a *minBoolOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Bool(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if !candidate && a.curAgg {
									cmpResult = -1
								} else if candidate && !a.curAgg {
									cmpResult = 1
								} else {
									cmpResult = 0
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if !candidate && a.curAgg {
									cmpResult = -1
								} else if candidate && !a.curAgg {
									cmpResult = 1
								} else {
									cmpResult = 0
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if !candidate && a.curAgg {
									cmpResult = -1
								} else if candidate && !a.curAgg {
									cmpResult = 1
								} else {
									cmpResult = 0
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if !candidate && a.curAgg {
									cmpResult = -1
								} else if candidate && !a.curAgg {
									cmpResult = 1
								} else {
									cmpResult = 0
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minBoolOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minBoolOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type minBoolOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []minBoolOrderedAgg
}

var _ aggregateFuncAlloc = &minBoolOrderedAggAlloc{}

const sizeOfminBoolOrderedAgg = int64(unsafe.Sizeof(minBoolOrderedAgg{}))
const minBoolOrderedAggSliceOverhead = int64(unsafe.Sizeof([]minBoolOrderedAgg{}))

func (a *minBoolOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minBoolOrderedAggSliceOverhead + sizeOfminBoolOrderedAgg*a.allocSize)
		a.aggFuncs = make([]minBoolOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minBytesOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col *coldata.Bytes
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg []byte
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minBytesOrderedAgg{}

func (a *minBytesOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Bytes()
}

func (a *minBytesOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurAggSize := len(a.curAgg)
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Bytes(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = append(a.curAgg[:0], val...)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = bytes.Compare(candidate, a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = append(a.curAgg[:0], candidate...)
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = append(a.curAgg[:0], val...)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = bytes.Compare(candidate, a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = append(a.curAgg[:0], candidate...)
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = append(a.curAgg[:0], val...)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = bytes.Compare(candidate, a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = append(a.curAgg[:0], candidate...)
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = append(a.curAgg[:0], val...)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = bytes.Compare(candidate, a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = append(a.curAgg[:0], candidate...)
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	newCurAggSize := len(a.curAgg)
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minBytesOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
	oldCurAggSize := len(a.curAgg)
	// Release the reference to curAgg eagerly. We can't do this for the window
	// variants because they may reuse curAgg between subsequent window frames.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

func (a *minBytesOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
	oldCurAggSize := len(a.curAgg)
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type minBytesOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []minBytesOrderedAgg
}

var _ aggregateFuncAlloc = &minBytesOrderedAggAlloc{}

const sizeOfminBytesOrderedAgg = int64(unsafe.Sizeof(minBytesOrderedAgg{}))
const minBytesOrderedAggSliceOverhead = int64(unsafe.Sizeof([]minBytesOrderedAgg{}))

func (a *minBytesOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minBytesOrderedAggSliceOverhead + sizeOfminBytesOrderedAgg*a.allocSize)
		a.aggFuncs = make([]minBytesOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minDecimalOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Decimals
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg apd.Decimal
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minDecimalOrderedAgg{}

func (a *minDecimalOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Decimal()
}

func (a *minDecimalOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurAggSize := a.curAgg.Size()
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Decimal(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg.Set(&val)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg.Set(&candidate)
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg.Set(&val)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg.Set(&candidate)
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg.Set(&val)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg.Set(&candidate)
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg.Set(&val)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg.Set(&candidate)
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	newCurAggSize := a.curAgg.Size()
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minDecimalOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minDecimalOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type minDecimalOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []minDecimalOrderedAgg
}

var _ aggregateFuncAlloc = &minDecimalOrderedAggAlloc{}

const sizeOfminDecimalOrderedAgg = int64(unsafe.Sizeof(minDecimalOrderedAgg{}))
const minDecimalOrderedAggSliceOverhead = int64(unsafe.Sizeof([]minDecimalOrderedAgg{}))

func (a *minDecimalOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minDecimalOrderedAggSliceOverhead + sizeOfminDecimalOrderedAgg*a.allocSize)
		a.aggFuncs = make([]minDecimalOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minInt16OrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Int16s
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int16
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minInt16OrderedAgg{}

func (a *minInt16OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Int16()
}

func (a *minInt16OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int16(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minInt16OrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minInt16OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type minInt16OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []minInt16OrderedAgg
}

var _ aggregateFuncAlloc = &minInt16OrderedAggAlloc{}

const sizeOfminInt16OrderedAgg = int64(unsafe.Sizeof(minInt16OrderedAgg{}))
const minInt16OrderedAggSliceOverhead = int64(unsafe.Sizeof([]minInt16OrderedAgg{}))

func (a *minInt16OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minInt16OrderedAggSliceOverhead + sizeOfminInt16OrderedAgg*a.allocSize)
		a.aggFuncs = make([]minInt16OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minInt32OrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Int32s
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int32
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minInt32OrderedAgg{}

func (a *minInt32OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Int32()
}

func (a *minInt32OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int32(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minInt32OrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minInt32OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type minInt32OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []minInt32OrderedAgg
}

var _ aggregateFuncAlloc = &minInt32OrderedAggAlloc{}

const sizeOfminInt32OrderedAgg = int64(unsafe.Sizeof(minInt32OrderedAgg{}))
const minInt32OrderedAggSliceOverhead = int64(unsafe.Sizeof([]minInt32OrderedAgg{}))

func (a *minInt32OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minInt32OrderedAggSliceOverhead + sizeOfminInt32OrderedAgg*a.allocSize)
		a.aggFuncs = make([]minInt32OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minInt64OrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Int64s
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int64
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minInt64OrderedAgg{}

func (a *minInt64OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Int64()
}

func (a *minInt64OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int64(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minInt64OrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minInt64OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type minInt64OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []minInt64OrderedAgg
}

var _ aggregateFuncAlloc = &minInt64OrderedAggAlloc{}

const sizeOfminInt64OrderedAgg = int64(unsafe.Sizeof(minInt64OrderedAgg{}))
const minInt64OrderedAggSliceOverhead = int64(unsafe.Sizeof([]minInt64OrderedAgg{}))

func (a *minInt64OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minInt64OrderedAggSliceOverhead + sizeOfminInt64OrderedAgg*a.allocSize)
		a.aggFuncs = make([]minInt64OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minFloat64OrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Float64s
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg float64
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minFloat64OrderedAgg{}

func (a *minFloat64OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Float64()
}

func (a *minFloat64OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Float64(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := float64(candidate), float64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else if a == b {
										cmpResult = 0
									} else if math.IsNaN(a) {
										if math.IsNaN(b) {
											cmpResult = 0
										} else {
											cmpResult = -1
										}
									} else {
										cmpResult = 1
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := float64(candidate), float64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else if a == b {
										cmpResult = 0
									} else if math.IsNaN(a) {
										if math.IsNaN(b) {
											cmpResult = 0
										} else {
											cmpResult = -1
										}
									} else {
										cmpResult = 1
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := float64(candidate), float64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else if a == b {
										cmpResult = 0
									} else if math.IsNaN(a) {
										if math.IsNaN(b) {
											cmpResult = 0
										} else {
											cmpResult = -1
										}
									} else {
										cmpResult = 1
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := float64(candidate), float64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else if a == b {
										cmpResult = 0
									} else if math.IsNaN(a) {
										if math.IsNaN(b) {
											cmpResult = 0
										} else {
											cmpResult = -1
										}
									} else {
										cmpResult = 1
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minFloat64OrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minFloat64OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type minFloat64OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []minFloat64OrderedAgg
}

var _ aggregateFuncAlloc = &minFloat64OrderedAggAlloc{}

const sizeOfminFloat64OrderedAgg = int64(unsafe.Sizeof(minFloat64OrderedAgg{}))
const minFloat64OrderedAggSliceOverhead = int64(unsafe.Sizeof([]minFloat64OrderedAgg{}))

func (a *minFloat64OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minFloat64OrderedAggSliceOverhead + sizeOfminFloat64OrderedAgg*a.allocSize)
		a.aggFuncs = make([]minFloat64OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minTimestampOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Times
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg time.Time
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minTimestampOrderedAgg{}

func (a *minTimestampOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Timestamp()
}

func (a *minTimestampOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Timestamp(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if candidate.Before(a.curAgg) {
									cmpResult = -1
								} else if a.curAgg.Before(candidate) {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if candidate.Before(a.curAgg) {
									cmpResult = -1
								} else if a.curAgg.Before(candidate) {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if candidate.Before(a.curAgg) {
									cmpResult = -1
								} else if a.curAgg.Before(candidate) {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if candidate.Before(a.curAgg) {
									cmpResult = -1
								} else if a.curAgg.Before(candidate) {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minTimestampOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minTimestampOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type minTimestampOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []minTimestampOrderedAgg
}

var _ aggregateFuncAlloc = &minTimestampOrderedAggAlloc{}

const sizeOfminTimestampOrderedAgg = int64(unsafe.Sizeof(minTimestampOrderedAgg{}))
const minTimestampOrderedAggSliceOverhead = int64(unsafe.Sizeof([]minTimestampOrderedAgg{}))

func (a *minTimestampOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minTimestampOrderedAggSliceOverhead + sizeOfminTimestampOrderedAgg*a.allocSize)
		a.aggFuncs = make([]minTimestampOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minIntervalOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Durations
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg duration.Duration
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minIntervalOrderedAgg{}

func (a *minIntervalOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Interval()
}

func (a *minIntervalOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Interval(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = candidate.Compare(a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = candidate.Compare(a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = candidate.Compare(a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = candidate.Compare(a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minIntervalOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minIntervalOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type minIntervalOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []minIntervalOrderedAgg
}

var _ aggregateFuncAlloc = &minIntervalOrderedAggAlloc{}

const sizeOfminIntervalOrderedAgg = int64(unsafe.Sizeof(minIntervalOrderedAgg{}))
const minIntervalOrderedAggSliceOverhead = int64(unsafe.Sizeof([]minIntervalOrderedAgg{}))

func (a *minIntervalOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minIntervalOrderedAggSliceOverhead + sizeOfminIntervalOrderedAgg*a.allocSize)
		a.aggFuncs = make([]minIntervalOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minJSONOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col *coldata.JSONs
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg json.JSON
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minJSONOrderedAgg{}

func (a *minJSONOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.JSON()
}

func (a *minJSONOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.JSON(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)

							var _err error
							var _bytes []byte
							_bytes, _err = json.EncodeJSON(nil, val)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							a.curAgg, _err = json.FromEncoding(_bytes)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}

						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								var err error
								cmpResult, err = candidate.Compare(a.curAgg)
								if err != nil {
									colexecerror.ExpectedError(err)
								}

								cmp = cmpResult < 0
							}

							if cmp {

								var _err error
								var _bytes []byte
								_bytes, _err = json.EncodeJSON(nil, candidate)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}
								a.curAgg, _err = json.FromEncoding(_bytes)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}

							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)

							var _err error
							var _bytes []byte
							_bytes, _err = json.EncodeJSON(nil, val)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							a.curAgg, _err = json.FromEncoding(_bytes)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}

						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								var err error
								cmpResult, err = candidate.Compare(a.curAgg)
								if err != nil {
									colexecerror.ExpectedError(err)
								}

								cmp = cmpResult < 0
							}

							if cmp {

								var _err error
								var _bytes []byte
								_bytes, _err = json.EncodeJSON(nil, candidate)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}
								a.curAgg, _err = json.FromEncoding(_bytes)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}

							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)

							var _err error
							var _bytes []byte
							_bytes, _err = json.EncodeJSON(nil, val)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							a.curAgg, _err = json.FromEncoding(_bytes)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}

						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								var err error
								cmpResult, err = candidate.Compare(a.curAgg)
								if err != nil {
									colexecerror.ExpectedError(err)
								}

								cmp = cmpResult < 0
							}

							if cmp {

								var _err error
								var _bytes []byte
								_bytes, _err = json.EncodeJSON(nil, candidate)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}
								a.curAgg, _err = json.FromEncoding(_bytes)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}

							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)

							var _err error
							var _bytes []byte
							_bytes, _err = json.EncodeJSON(nil, val)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							a.curAgg, _err = json.FromEncoding(_bytes)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}

						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								var err error
								cmpResult, err = candidate.Compare(a.curAgg)
								if err != nil {
									colexecerror.ExpectedError(err)
								}

								cmp = cmpResult < 0
							}

							if cmp {

								var _err error
								var _bytes []byte
								_bytes, _err = json.EncodeJSON(nil, candidate)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}
								a.curAgg, _err = json.FromEncoding(_bytes)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}

							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if a.curAgg != nil {
		newCurAggSize = a.curAgg.Size()
	}
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minJSONOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	// Release the reference to curAgg eagerly. We can't do this for the window
	// variants because they may reuse curAgg between subsequent window frames.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

func (a *minJSONOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type minJSONOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []minJSONOrderedAgg
}

var _ aggregateFuncAlloc = &minJSONOrderedAggAlloc{}

const sizeOfminJSONOrderedAgg = int64(unsafe.Sizeof(minJSONOrderedAgg{}))
const minJSONOrderedAggSliceOverhead = int64(unsafe.Sizeof([]minJSONOrderedAgg{}))

func (a *minJSONOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minJSONOrderedAggSliceOverhead + sizeOfminJSONOrderedAgg*a.allocSize)
		a.aggFuncs = make([]minJSONOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minDatumOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.DatumVec
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg interface{}
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minDatumOrderedAgg{}

func (a *minDatumOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Datum()
}

func (a *minDatumOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Datum(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)

	var newCurAggSize uintptr
	if a.curAgg != nil {
		newCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minDatumOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	// Release the reference to curAgg eagerly. We can't do this for the window
	// variants because they may reuse curAgg between subsequent window frames.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

func (a *minDatumOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type minDatumOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []minDatumOrderedAgg
}

var _ aggregateFuncAlloc = &minDatumOrderedAggAlloc{}

const sizeOfminDatumOrderedAgg = int64(unsafe.Sizeof(minDatumOrderedAgg{}))
const minDatumOrderedAggSliceOverhead = int64(unsafe.Sizeof([]minDatumOrderedAgg{}))

func (a *minDatumOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minDatumOrderedAggSliceOverhead + sizeOfminDatumOrderedAgg*a.allocSize)
		a.aggFuncs = make([]minDatumOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

func newMaxOrderedAggAlloc(
	allocator *colmem.Allocator, t *types.T, allocSize int64,
) aggregateFuncAlloc {
	allocBase := aggAllocBase{allocator: allocator, allocSize: allocSize}
	switch typeconv.TypeFamilyToCanonicalTypeFamily(t.Family()) {
	case types.BoolFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxBoolOrderedAggAlloc{aggAllocBase: allocBase}
		}
	case types.BytesFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxBytesOrderedAggAlloc{aggAllocBase: allocBase}
		}
	case types.DecimalFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxDecimalOrderedAggAlloc{aggAllocBase: allocBase}
		}
	case types.IntFamily:
		switch t.Width() {
		case 16:
			return &maxInt16OrderedAggAlloc{aggAllocBase: allocBase}
		case 32:
			return &maxInt32OrderedAggAlloc{aggAllocBase: allocBase}
		case -1:
		default:
			return &maxInt64OrderedAggAlloc{aggAllocBase: allocBase}
		}
	case types.FloatFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxFloat64OrderedAggAlloc{aggAllocBase: allocBase}
		}
	case types.TimestampTZFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxTimestampOrderedAggAlloc{aggAllocBase: allocBase}
		}
	case types.IntervalFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxIntervalOrderedAggAlloc{aggAllocBase: allocBase}
		}
	case types.JsonFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxJSONOrderedAggAlloc{aggAllocBase: allocBase}
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxDatumOrderedAggAlloc{aggAllocBase: allocBase}
		}
	}
	colexecerror.InternalError(errors.AssertionFailedf("unexpectedly didn't find max overload for %s type family", t.Name()))
	// This code is unreachable, but the compiler cannot infer that.
	return nil
}

type maxBoolOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Bools
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg bool
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxBoolOrderedAgg{}

func (a *maxBoolOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Bool()
}

func (a *maxBoolOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Bool(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if !candidate && a.curAgg {
									cmpResult = -1
								} else if candidate && !a.curAgg {
									cmpResult = 1
								} else {
									cmpResult = 0
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if !candidate && a.curAgg {
									cmpResult = -1
								} else if candidate && !a.curAgg {
									cmpResult = 1
								} else {
									cmpResult = 0
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if !candidate && a.curAgg {
									cmpResult = -1
								} else if candidate && !a.curAgg {
									cmpResult = 1
								} else {
									cmpResult = 0
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if !candidate && a.curAgg {
									cmpResult = -1
								} else if candidate && !a.curAgg {
									cmpResult = 1
								} else {
									cmpResult = 0
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxBoolOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxBoolOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type maxBoolOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []maxBoolOrderedAgg
}

var _ aggregateFuncAlloc = &maxBoolOrderedAggAlloc{}

const sizeOfmaxBoolOrderedAgg = int64(unsafe.Sizeof(maxBoolOrderedAgg{}))
const maxBoolOrderedAggSliceOverhead = int64(unsafe.Sizeof([]maxBoolOrderedAgg{}))

func (a *maxBoolOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxBoolOrderedAggSliceOverhead + sizeOfmaxBoolOrderedAgg*a.allocSize)
		a.aggFuncs = make([]maxBoolOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxBytesOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col *coldata.Bytes
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg []byte
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxBytesOrderedAgg{}

func (a *maxBytesOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Bytes()
}

func (a *maxBytesOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurAggSize := len(a.curAgg)
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Bytes(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = append(a.curAgg[:0], val...)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = bytes.Compare(candidate, a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = append(a.curAgg[:0], candidate...)
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = append(a.curAgg[:0], val...)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = bytes.Compare(candidate, a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = append(a.curAgg[:0], candidate...)
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = append(a.curAgg[:0], val...)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = bytes.Compare(candidate, a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = append(a.curAgg[:0], candidate...)
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = append(a.curAgg[:0], val...)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = bytes.Compare(candidate, a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = append(a.curAgg[:0], candidate...)
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	newCurAggSize := len(a.curAgg)
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxBytesOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
	oldCurAggSize := len(a.curAgg)
	// Release the reference to curAgg eagerly. We can't do this for the window
	// variants because they may reuse curAgg between subsequent window frames.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

func (a *maxBytesOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
	oldCurAggSize := len(a.curAgg)
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type maxBytesOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []maxBytesOrderedAgg
}

var _ aggregateFuncAlloc = &maxBytesOrderedAggAlloc{}

const sizeOfmaxBytesOrderedAgg = int64(unsafe.Sizeof(maxBytesOrderedAgg{}))
const maxBytesOrderedAggSliceOverhead = int64(unsafe.Sizeof([]maxBytesOrderedAgg{}))

func (a *maxBytesOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxBytesOrderedAggSliceOverhead + sizeOfmaxBytesOrderedAgg*a.allocSize)
		a.aggFuncs = make([]maxBytesOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxDecimalOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Decimals
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg apd.Decimal
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxDecimalOrderedAgg{}

func (a *maxDecimalOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Decimal()
}

func (a *maxDecimalOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurAggSize := a.curAgg.Size()
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Decimal(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg.Set(&val)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg.Set(&candidate)
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg.Set(&val)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg.Set(&candidate)
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg.Set(&val)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg.Set(&candidate)
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg.Set(&val)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg.Set(&candidate)
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	newCurAggSize := a.curAgg.Size()
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxDecimalOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxDecimalOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type maxDecimalOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []maxDecimalOrderedAgg
}

var _ aggregateFuncAlloc = &maxDecimalOrderedAggAlloc{}

const sizeOfmaxDecimalOrderedAgg = int64(unsafe.Sizeof(maxDecimalOrderedAgg{}))
const maxDecimalOrderedAggSliceOverhead = int64(unsafe.Sizeof([]maxDecimalOrderedAgg{}))

func (a *maxDecimalOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxDecimalOrderedAggSliceOverhead + sizeOfmaxDecimalOrderedAgg*a.allocSize)
		a.aggFuncs = make([]maxDecimalOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxInt16OrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Int16s
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int16
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxInt16OrderedAgg{}

func (a *maxInt16OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Int16()
}

func (a *maxInt16OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int16(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxInt16OrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxInt16OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type maxInt16OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []maxInt16OrderedAgg
}

var _ aggregateFuncAlloc = &maxInt16OrderedAggAlloc{}

const sizeOfmaxInt16OrderedAgg = int64(unsafe.Sizeof(maxInt16OrderedAgg{}))
const maxInt16OrderedAggSliceOverhead = int64(unsafe.Sizeof([]maxInt16OrderedAgg{}))

func (a *maxInt16OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxInt16OrderedAggSliceOverhead + sizeOfmaxInt16OrderedAgg*a.allocSize)
		a.aggFuncs = make([]maxInt16OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxInt32OrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Int32s
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int32
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxInt32OrderedAgg{}

func (a *maxInt32OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Int32()
}

func (a *maxInt32OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int32(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxInt32OrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxInt32OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type maxInt32OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []maxInt32OrderedAgg
}

var _ aggregateFuncAlloc = &maxInt32OrderedAggAlloc{}

const sizeOfmaxInt32OrderedAgg = int64(unsafe.Sizeof(maxInt32OrderedAgg{}))
const maxInt32OrderedAggSliceOverhead = int64(unsafe.Sizeof([]maxInt32OrderedAgg{}))

func (a *maxInt32OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxInt32OrderedAggSliceOverhead + sizeOfmaxInt32OrderedAgg*a.allocSize)
		a.aggFuncs = make([]maxInt32OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxInt64OrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Int64s
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int64
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxInt64OrderedAgg{}

func (a *maxInt64OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Int64()
}

func (a *maxInt64OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int64(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxInt64OrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxInt64OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type maxInt64OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []maxInt64OrderedAgg
}

var _ aggregateFuncAlloc = &maxInt64OrderedAggAlloc{}

const sizeOfmaxInt64OrderedAgg = int64(unsafe.Sizeof(maxInt64OrderedAgg{}))
const maxInt64OrderedAggSliceOverhead = int64(unsafe.Sizeof([]maxInt64OrderedAgg{}))

func (a *maxInt64OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxInt64OrderedAggSliceOverhead + sizeOfmaxInt64OrderedAgg*a.allocSize)
		a.aggFuncs = make([]maxInt64OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxFloat64OrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Float64s
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg float64
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxFloat64OrderedAgg{}

func (a *maxFloat64OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Float64()
}

func (a *maxFloat64OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Float64(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := float64(candidate), float64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else if a == b {
										cmpResult = 0
									} else if math.IsNaN(a) {
										if math.IsNaN(b) {
											cmpResult = 0
										} else {
											cmpResult = -1
										}
									} else {
										cmpResult = 1
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := float64(candidate), float64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else if a == b {
										cmpResult = 0
									} else if math.IsNaN(a) {
										if math.IsNaN(b) {
											cmpResult = 0
										} else {
											cmpResult = -1
										}
									} else {
										cmpResult = 1
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := float64(candidate), float64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else if a == b {
										cmpResult = 0
									} else if math.IsNaN(a) {
										if math.IsNaN(b) {
											cmpResult = 0
										} else {
											cmpResult = -1
										}
									} else {
										cmpResult = 1
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := float64(candidate), float64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else if a == b {
										cmpResult = 0
									} else if math.IsNaN(a) {
										if math.IsNaN(b) {
											cmpResult = 0
										} else {
											cmpResult = -1
										}
									} else {
										cmpResult = 1
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxFloat64OrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxFloat64OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type maxFloat64OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []maxFloat64OrderedAgg
}

var _ aggregateFuncAlloc = &maxFloat64OrderedAggAlloc{}

const sizeOfmaxFloat64OrderedAgg = int64(unsafe.Sizeof(maxFloat64OrderedAgg{}))
const maxFloat64OrderedAggSliceOverhead = int64(unsafe.Sizeof([]maxFloat64OrderedAgg{}))

func (a *maxFloat64OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxFloat64OrderedAggSliceOverhead + sizeOfmaxFloat64OrderedAgg*a.allocSize)
		a.aggFuncs = make([]maxFloat64OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxTimestampOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Times
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg time.Time
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxTimestampOrderedAgg{}

func (a *maxTimestampOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Timestamp()
}

func (a *maxTimestampOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Timestamp(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if candidate.Before(a.curAgg) {
									cmpResult = -1
								} else if a.curAgg.Before(candidate) {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if candidate.Before(a.curAgg) {
									cmpResult = -1
								} else if a.curAgg.Before(candidate) {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if candidate.Before(a.curAgg) {
									cmpResult = -1
								} else if a.curAgg.Before(candidate) {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if candidate.Before(a.curAgg) {
									cmpResult = -1
								} else if a.curAgg.Before(candidate) {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxTimestampOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxTimestampOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type maxTimestampOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []maxTimestampOrderedAgg
}

var _ aggregateFuncAlloc = &maxTimestampOrderedAggAlloc{}

const sizeOfmaxTimestampOrderedAgg = int64(unsafe.Sizeof(maxTimestampOrderedAgg{}))
const maxTimestampOrderedAggSliceOverhead = int64(unsafe.Sizeof([]maxTimestampOrderedAgg{}))

func (a *maxTimestampOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxTimestampOrderedAggSliceOverhead + sizeOfmaxTimestampOrderedAgg*a.allocSize)
		a.aggFuncs = make([]maxTimestampOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxIntervalOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.Durations
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg duration.Duration
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxIntervalOrderedAgg{}

func (a *maxIntervalOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Interval()
}

func (a *maxIntervalOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Interval(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = candidate.Compare(a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = candidate.Compare(a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = candidate.Compare(a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = candidate.Compare(a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxIntervalOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxIntervalOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
}

type maxIntervalOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []maxIntervalOrderedAgg
}

var _ aggregateFuncAlloc = &maxIntervalOrderedAggAlloc{}

const sizeOfmaxIntervalOrderedAgg = int64(unsafe.Sizeof(maxIntervalOrderedAgg{}))
const maxIntervalOrderedAggSliceOverhead = int64(unsafe.Sizeof([]maxIntervalOrderedAgg{}))

func (a *maxIntervalOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxIntervalOrderedAggSliceOverhead + sizeOfmaxIntervalOrderedAgg*a.allocSize)
		a.aggFuncs = make([]maxIntervalOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxJSONOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col *coldata.JSONs
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg json.JSON
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxJSONOrderedAgg{}

func (a *maxJSONOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.JSON()
}

func (a *maxJSONOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.JSON(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)

							var _err error
							var _bytes []byte
							_bytes, _err = json.EncodeJSON(nil, val)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							a.curAgg, _err = json.FromEncoding(_bytes)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}

						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								var err error
								cmpResult, err = candidate.Compare(a.curAgg)
								if err != nil {
									colexecerror.ExpectedError(err)
								}

								cmp = cmpResult > 0
							}

							if cmp {

								var _err error
								var _bytes []byte
								_bytes, _err = json.EncodeJSON(nil, candidate)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}
								a.curAgg, _err = json.FromEncoding(_bytes)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}

							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)

							var _err error
							var _bytes []byte
							_bytes, _err = json.EncodeJSON(nil, val)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							a.curAgg, _err = json.FromEncoding(_bytes)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}

						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								var err error
								cmpResult, err = candidate.Compare(a.curAgg)
								if err != nil {
									colexecerror.ExpectedError(err)
								}

								cmp = cmpResult > 0
							}

							if cmp {

								var _err error
								var _bytes []byte
								_bytes, _err = json.EncodeJSON(nil, candidate)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}
								a.curAgg, _err = json.FromEncoding(_bytes)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}

							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)

							var _err error
							var _bytes []byte
							_bytes, _err = json.EncodeJSON(nil, val)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							a.curAgg, _err = json.FromEncoding(_bytes)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}

						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								var err error
								cmpResult, err = candidate.Compare(a.curAgg)
								if err != nil {
									colexecerror.ExpectedError(err)
								}

								cmp = cmpResult > 0
							}

							if cmp {

								var _err error
								var _bytes []byte
								_bytes, _err = json.EncodeJSON(nil, candidate)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}
								a.curAgg, _err = json.FromEncoding(_bytes)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}

							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)

							var _err error
							var _bytes []byte
							_bytes, _err = json.EncodeJSON(nil, val)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							a.curAgg, _err = json.FromEncoding(_bytes)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}

						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								var err error
								cmpResult, err = candidate.Compare(a.curAgg)
								if err != nil {
									colexecerror.ExpectedError(err)
								}

								cmp = cmpResult > 0
							}

							if cmp {

								var _err error
								var _bytes []byte
								_bytes, _err = json.EncodeJSON(nil, candidate)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}
								a.curAgg, _err = json.FromEncoding(_bytes)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}

							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if a.curAgg != nil {
		newCurAggSize = a.curAgg.Size()
	}
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxJSONOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	// Release the reference to curAgg eagerly. We can't do this for the window
	// variants because they may reuse curAgg between subsequent window frames.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

func (a *maxJSONOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type maxJSONOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []maxJSONOrderedAgg
}

var _ aggregateFuncAlloc = &maxJSONOrderedAggAlloc{}

const sizeOfmaxJSONOrderedAgg = int64(unsafe.Sizeof(maxJSONOrderedAgg{}))
const maxJSONOrderedAggSliceOverhead = int64(unsafe.Sizeof([]maxJSONOrderedAgg{}))

func (a *maxJSONOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxJSONOrderedAggSliceOverhead + sizeOfmaxJSONOrderedAgg*a.allocSize)
		a.aggFuncs = make([]maxJSONOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxDatumOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the output vector we are updating.
	col coldata.DatumVec
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg interface{}
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxDatumOrderedAgg{}

func (a *maxDatumOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Datum()
}

func (a *maxDatumOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Datum(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.numNonNull == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.numNonNull = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)

	var newCurAggSize uintptr
	if a.curAgg != nil {
		newCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxDatumOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	// Release the reference to curAgg eagerly. We can't do this for the window
	// variants because they may reuse curAgg between subsequent window frames.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

func (a *maxDatumOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.numNonNull = 0

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type maxDatumOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []maxDatumOrderedAgg
}

var _ aggregateFuncAlloc = &maxDatumOrderedAggAlloc{}

const sizeOfmaxDatumOrderedAgg = int64(unsafe.Sizeof(maxDatumOrderedAgg{}))
const maxDatumOrderedAggSliceOverhead = int64(unsafe.Sizeof([]maxDatumOrderedAgg{}))

func (a *maxDatumOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxDatumOrderedAggSliceOverhead + sizeOfmaxDatumOrderedAgg*a.allocSize)
		a.aggFuncs = make([]maxDatumOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}
