// Code generated by execgen; DO NOT EDIT.
// Copyright 2018 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecagg

import (
	"unsafe"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ tree.AggType
	_ apd.Context
	_ duration.Duration
	_ = typeconv.TypeFamilyToCanonicalTypeFamily
)

const avgNumOverloads = 6

func init() {
	// Sanity check the hard-coded number of overloads.
	var numOverloads int
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	if numOverloads != avgNumOverloads {
		colexecerror.InternalError(errors.AssertionFailedf(
			"avgNumOverloads should be updated: expected %d, found %d", numOverloads, avgNumOverloads,
		))
	}
}

// avgOverloadOffset returns the offset for this particular type overload
// within contiguous slice of allocators for this aggregate function.
func avgOverloadOffset(t *types.T) int {
	var offset int
	canonicalTypeFamily := typeconv.TypeFamilyToCanonicalTypeFamily(t.Family())
	if canonicalTypeFamily == types.IntFamily {
		if t.Width() == 16 {
			return offset
		}
		offset++
		if t.Width() == 32 {
			return offset
		}
		offset++
		return offset
	}
	offset += 3
	if canonicalTypeFamily == types.DecimalFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == types.FloatFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == types.IntervalFamily {
		return offset
	}
	offset += 1
	colexecerror.InternalError(errors.AssertionFailedf("didn't find overload offset for %s", t.SQLStringForError()))
	return 0
}

func newAvgOrderedAggAlloc(
	allocator *colmem.Allocator, t *types.T, allocSize int64,
) (aggregateFuncAlloc, error) {
	allocBase := aggAllocBase{allocator: allocator, allocSize: allocSize}
	switch t.Family() {
	case types.IntFamily:
		switch t.Width() {
		case 16:
			return &avgInt16OrderedAggAlloc{aggAllocBase: allocBase}, nil
		case 32:
			return &avgInt32OrderedAggAlloc{aggAllocBase: allocBase}, nil
		case -1:
		default:
			return &avgInt64OrderedAggAlloc{aggAllocBase: allocBase}, nil
		}
	case types.DecimalFamily:
		switch t.Width() {
		case -1:
		default:
			return &avgDecimalOrderedAggAlloc{aggAllocBase: allocBase}, nil
		}
	case types.FloatFamily:
		switch t.Width() {
		case -1:
		default:
			return &avgFloat64OrderedAggAlloc{aggAllocBase: allocBase}, nil
		}
	case types.IntervalFamily:
		switch t.Width() {
		case -1:
		default:
			return &avgIntervalOrderedAggAlloc{aggAllocBase: allocBase}, nil
		}
	}
	return nil, errors.AssertionFailedf("unsupported avg agg type %s", t.Name())
}

type avgInt16OrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the statically-typed output vector.
	col coldata.Decimals
	// curSum keeps track of the sum of elements belonging to the current group,
	// so we can index into the slice once per group, instead of on each
	// iteration.
	curSum apd.Decimal
	// curCount keeps track of the number of non-null elements that we've seen
	// belonging to the current group.
	curCount int64
}

var _ AggregateFunc = &avgInt16OrderedAgg{}

func (a *avgInt16OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Decimal()
}

func (a *avgInt16OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurSumSize := a.curSum.Size()
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int16(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(v))
							if _, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

						a.curCount++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(v))
							if _, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

						a.curCount++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						v := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(v))
							if _, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

						a.curCount++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						v := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(v))
							if _, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

						a.curCount++
					}
				}
			}
		}
	},
	)
	newCurSumSize := a.curSum.Size()
	if newCurSumSize != oldCurSumSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurSumSize - oldCurSumSize))
	}
}

func (a *avgInt16OrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should be
	// NULL.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.curCount == 0 {
		a.nulls.SetNull(outputIdx)
	} else {

		col[outputIdx].SetInt64(a.curCount)
		if _, err := tree.DecimalCtx.Quo(&col[outputIdx], &a.curSum, &col[outputIdx]); err != nil {
			colexecerror.ExpectedError(err)
		}
	}
}

func (a *avgInt16OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.curSum = zeroDecimalValue
	a.curCount = 0
}

type avgInt16OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []avgInt16OrderedAgg
}

var _ aggregateFuncAlloc = &avgInt16OrderedAggAlloc{}

const sizeOfAvgInt16OrderedAgg = int64(unsafe.Sizeof(avgInt16OrderedAgg{}))
const avgInt16OrderedAggSliceOverhead = int64(unsafe.Sizeof([]avgInt16OrderedAgg{}))

func (a *avgInt16OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(avgInt16OrderedAggSliceOverhead + sizeOfAvgInt16OrderedAgg*a.allocSize)
		a.aggFuncs = make([]avgInt16OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type avgInt32OrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the statically-typed output vector.
	col coldata.Decimals
	// curSum keeps track of the sum of elements belonging to the current group,
	// so we can index into the slice once per group, instead of on each
	// iteration.
	curSum apd.Decimal
	// curCount keeps track of the number of non-null elements that we've seen
	// belonging to the current group.
	curCount int64
}

var _ AggregateFunc = &avgInt32OrderedAgg{}

func (a *avgInt32OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Decimal()
}

func (a *avgInt32OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurSumSize := a.curSum.Size()
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int32(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(v))
							if _, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

						a.curCount++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(v))
							if _, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

						a.curCount++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						v := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(v))
							if _, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

						a.curCount++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						v := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(v))
							if _, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

						a.curCount++
					}
				}
			}
		}
	},
	)
	newCurSumSize := a.curSum.Size()
	if newCurSumSize != oldCurSumSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurSumSize - oldCurSumSize))
	}
}

func (a *avgInt32OrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should be
	// NULL.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.curCount == 0 {
		a.nulls.SetNull(outputIdx)
	} else {

		col[outputIdx].SetInt64(a.curCount)
		if _, err := tree.DecimalCtx.Quo(&col[outputIdx], &a.curSum, &col[outputIdx]); err != nil {
			colexecerror.ExpectedError(err)
		}
	}
}

func (a *avgInt32OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.curSum = zeroDecimalValue
	a.curCount = 0
}

type avgInt32OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []avgInt32OrderedAgg
}

var _ aggregateFuncAlloc = &avgInt32OrderedAggAlloc{}

const sizeOfAvgInt32OrderedAgg = int64(unsafe.Sizeof(avgInt32OrderedAgg{}))
const avgInt32OrderedAggSliceOverhead = int64(unsafe.Sizeof([]avgInt32OrderedAgg{}))

func (a *avgInt32OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(avgInt32OrderedAggSliceOverhead + sizeOfAvgInt32OrderedAgg*a.allocSize)
		a.aggFuncs = make([]avgInt32OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type avgInt64OrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the statically-typed output vector.
	col coldata.Decimals
	// curSum keeps track of the sum of elements belonging to the current group,
	// so we can index into the slice once per group, instead of on each
	// iteration.
	curSum apd.Decimal
	// curCount keeps track of the number of non-null elements that we've seen
	// belonging to the current group.
	curCount int64
}

var _ AggregateFunc = &avgInt64OrderedAgg{}

func (a *avgInt64OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Decimal()
}

func (a *avgInt64OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurSumSize := a.curSum.Size()
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int64(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(v))
							if _, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

						a.curCount++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(v))
							if _, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

						a.curCount++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						v := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(v))
							if _, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

						a.curCount++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						v := col.Get(i)

						{

							var tmpDec apd.Decimal //gcassert:noescape
							tmpDec.SetInt64(int64(v))
							if _, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &tmpDec); err != nil {
								colexecerror.ExpectedError(err)
							}
						}

						a.curCount++
					}
				}
			}
		}
	},
	)
	newCurSumSize := a.curSum.Size()
	if newCurSumSize != oldCurSumSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurSumSize - oldCurSumSize))
	}
}

func (a *avgInt64OrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should be
	// NULL.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.curCount == 0 {
		a.nulls.SetNull(outputIdx)
	} else {

		col[outputIdx].SetInt64(a.curCount)
		if _, err := tree.DecimalCtx.Quo(&col[outputIdx], &a.curSum, &col[outputIdx]); err != nil {
			colexecerror.ExpectedError(err)
		}
	}
}

func (a *avgInt64OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.curSum = zeroDecimalValue
	a.curCount = 0
}

type avgInt64OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []avgInt64OrderedAgg
}

var _ aggregateFuncAlloc = &avgInt64OrderedAggAlloc{}

const sizeOfAvgInt64OrderedAgg = int64(unsafe.Sizeof(avgInt64OrderedAgg{}))
const avgInt64OrderedAggSliceOverhead = int64(unsafe.Sizeof([]avgInt64OrderedAgg{}))

func (a *avgInt64OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(avgInt64OrderedAggSliceOverhead + sizeOfAvgInt64OrderedAgg*a.allocSize)
		a.aggFuncs = make([]avgInt64OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type avgDecimalOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the statically-typed output vector.
	col coldata.Decimals
	// curSum keeps track of the sum of elements belonging to the current group,
	// so we can index into the slice once per group, instead of on each
	// iteration.
	curSum apd.Decimal
	// curCount keeps track of the number of non-null elements that we've seen
	// belonging to the current group.
	curCount int64
}

var _ AggregateFunc = &avgDecimalOrderedAgg{}

func (a *avgDecimalOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Decimal()
}

func (a *avgDecimalOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurSumSize := a.curSum.Size()
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Decimal(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{

							_, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

						a.curCount++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{

							_, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

						a.curCount++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						v := col.Get(i)

						{

							_, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

						a.curCount++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {

								a.col[a.curIdx].SetInt64(a.curCount)
								if _, err := tree.DecimalCtx.Quo(&a.col[a.curIdx], &a.curSum, &a.col[a.curIdx]); err != nil {
									colexecerror.ExpectedError(err)
								}
							}
							a.curIdx++
							a.curSum = zeroDecimalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						v := col.Get(i)

						{

							_, err := tree.ExactCtx.Add(&a.curSum, &a.curSum, &v)
							if err != nil {
								colexecerror.ExpectedError(err)
							}

						}

						a.curCount++
					}
				}
			}
		}
	},
	)
	newCurSumSize := a.curSum.Size()
	if newCurSumSize != oldCurSumSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurSumSize - oldCurSumSize))
	}
}

func (a *avgDecimalOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should be
	// NULL.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.curCount == 0 {
		a.nulls.SetNull(outputIdx)
	} else {

		col[outputIdx].SetInt64(a.curCount)
		if _, err := tree.DecimalCtx.Quo(&col[outputIdx], &a.curSum, &col[outputIdx]); err != nil {
			colexecerror.ExpectedError(err)
		}
	}
}

func (a *avgDecimalOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.curSum = zeroDecimalValue
	a.curCount = 0
}

type avgDecimalOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []avgDecimalOrderedAgg
}

var _ aggregateFuncAlloc = &avgDecimalOrderedAggAlloc{}

const sizeOfAvgDecimalOrderedAgg = int64(unsafe.Sizeof(avgDecimalOrderedAgg{}))
const avgDecimalOrderedAggSliceOverhead = int64(unsafe.Sizeof([]avgDecimalOrderedAgg{}))

func (a *avgDecimalOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(avgDecimalOrderedAggSliceOverhead + sizeOfAvgDecimalOrderedAgg*a.allocSize)
		a.aggFuncs = make([]avgDecimalOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type avgFloat64OrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the statically-typed output vector.
	col coldata.Float64s
	// curSum keeps track of the sum of elements belonging to the current group,
	// so we can index into the slice once per group, instead of on each
	// iteration.
	curSum float64
	// curCount keeps track of the number of non-null elements that we've seen
	// belonging to the current group.
	curCount int64
}

var _ AggregateFunc = &avgFloat64OrderedAgg{}

func (a *avgFloat64OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Float64()
}

func (a *avgFloat64OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurSumSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Float64(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curSum / float64(a.curCount)
							}
							a.curIdx++
							a.curSum = zeroFloat64Value
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{

							a.curSum = float64(a.curSum) + float64(v)
						}

						a.curCount++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curSum / float64(a.curCount)
							}
							a.curIdx++
							a.curSum = zeroFloat64Value
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						//gcassert:bce
						v := col.Get(i)

						{

							a.curSum = float64(a.curSum) + float64(v)
						}

						a.curCount++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curSum / float64(a.curCount)
							}
							a.curIdx++
							a.curSum = zeroFloat64Value
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						v := col.Get(i)

						{

							a.curSum = float64(a.curSum) + float64(v)
						}

						a.curCount++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curSum / float64(a.curCount)
							}
							a.curIdx++
							a.curSum = zeroFloat64Value
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						v := col.Get(i)

						{

							a.curSum = float64(a.curSum) + float64(v)
						}

						a.curCount++
					}
				}
			}
		}
	},
	)
	var newCurSumSize uintptr
	if newCurSumSize != oldCurSumSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurSumSize - oldCurSumSize))
	}
}

func (a *avgFloat64OrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should be
	// NULL.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.curCount == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col[outputIdx] = a.curSum / float64(a.curCount)
	}
}

func (a *avgFloat64OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.curSum = zeroFloat64Value
	a.curCount = 0
}

type avgFloat64OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []avgFloat64OrderedAgg
}

var _ aggregateFuncAlloc = &avgFloat64OrderedAggAlloc{}

const sizeOfAvgFloat64OrderedAgg = int64(unsafe.Sizeof(avgFloat64OrderedAgg{}))
const avgFloat64OrderedAggSliceOverhead = int64(unsafe.Sizeof([]avgFloat64OrderedAgg{}))

func (a *avgFloat64OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(avgFloat64OrderedAggSliceOverhead + sizeOfAvgFloat64OrderedAgg*a.allocSize)
		a.aggFuncs = make([]avgFloat64OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type avgIntervalOrderedAgg struct {
	orderedAggregateFuncBase
	// col points to the statically-typed output vector.
	col coldata.Durations
	// curSum keeps track of the sum of elements belonging to the current group,
	// so we can index into the slice once per group, instead of on each
	// iteration.
	curSum duration.Duration
	// curCount keeps track of the number of non-null elements that we've seen
	// belonging to the current group.
	curCount int64
}

var _ AggregateFunc = &avgIntervalOrderedAgg{}

func (a *avgIntervalOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Interval()
}

func (a *avgIntervalOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurSumSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Interval(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curSum.Div(int64(a.curCount))
							}
							a.curIdx++
							a.curSum = zeroIntervalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						//gcassert:bce
						v := col.Get(i)
						a.curSum = a.curSum.Add(v)
						a.curCount++
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {

					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curSum.Div(int64(a.curCount))
							}
							a.curIdx++
							a.curSum = zeroIntervalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						//gcassert:bce
						v := col.Get(i)
						a.curSum = a.curSum.Add(v)
						a.curCount++
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curSum.Div(int64(a.curCount))
							}
							a.curIdx++
							a.curSum = zeroIntervalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						v := col.Get(i)
						a.curSum = a.curSum.Add(v)
						a.curCount++
					}
				}
			} else {
				for _, i := range sel {

					if groups[i] {
						if !a.isFirstGroup {
							// If we encounter a new group, and we haven't found any non-nulls for the
							// current group, the output for this group should be null.
							if a.curCount == 0 {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col[a.curIdx] = a.curSum.Div(int64(a.curCount))
							}
							a.curIdx++
							a.curSum = zeroIntervalValue
							a.curCount = 0
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !isNull {
						v := col.Get(i)
						a.curSum = a.curSum.Add(v)
						a.curCount++
					}
				}
			}
		}
	},
	)
	var newCurSumSize uintptr
	if newCurSumSize != oldCurSumSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurSumSize - oldCurSumSize))
	}
}

func (a *avgIntervalOrderedAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should be
	// NULL.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if a.curCount == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col[outputIdx] = a.curSum.Div(int64(a.curCount))
	}
}

func (a *avgIntervalOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.curSum = zeroIntervalValue
	a.curCount = 0
}

type avgIntervalOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []avgIntervalOrderedAgg
}

var _ aggregateFuncAlloc = &avgIntervalOrderedAggAlloc{}

const sizeOfAvgIntervalOrderedAgg = int64(unsafe.Sizeof(avgIntervalOrderedAgg{}))
const avgIntervalOrderedAggSliceOverhead = int64(unsafe.Sizeof([]avgIntervalOrderedAgg{}))

func (a *avgIntervalOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(avgIntervalOrderedAggSliceOverhead + sizeOfAvgIntervalOrderedAgg*a.allocSize)
		a.aggFuncs = make([]avgIntervalOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}
