// Code generated by execgen; DO NOT EDIT.
// Copyright 2018 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecagg

import (
	"time"
	"unsafe"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/cockroach/pkg/util/json"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ tree.AggType
	_ apd.Context
	_ duration.Duration
	_ json.JSON
	_ colexecerror.StorageError
)

const anyNotNullNumOverloads = 11

func init() {
	// Sanity check the hard-coded number of overloads.
	var numOverloads int
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	numOverloads++
	if numOverloads != anyNotNullNumOverloads {
		colexecerror.InternalError(errors.AssertionFailedf(
			"anyNotNullNumOverloads should be updated: expected %d, found %d", numOverloads, anyNotNullNumOverloads,
		))
	}
}

// anyNotNullOverloadOffset returns the offset for this particular type overload
// within contiguous slice of allocators for this aggregate function.
func anyNotNullOverloadOffset(t *types.T) int {
	var offset int
	canonicalTypeFamily := typeconv.TypeFamilyToCanonicalTypeFamily(t.Family())
	if canonicalTypeFamily == types.BoolFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == types.BytesFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == types.DecimalFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == types.IntFamily {
		if t.Width() == 16 {
			return offset
		}
		offset++
		if t.Width() == 32 {
			return offset
		}
		offset++
		return offset
	}
	offset += 3
	if canonicalTypeFamily == types.FloatFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == types.TimestampTZFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == types.IntervalFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == types.JsonFamily {
		return offset
	}
	offset += 1
	if canonicalTypeFamily == typeconv.DatumVecCanonicalTypeFamily {
		return offset
	}
	offset += 1
	colexecerror.InternalError(errors.AssertionFailedf("didn't find overload offset for %s", t.SQLStringForError()))
	return 0
}

func newAnyNotNullOrderedAggAlloc(
	allocator *colmem.Allocator, t *types.T, allocSize int64,
) (aggregateFuncAlloc, error) {
	allocBase := aggAllocBase{allocator: allocator, allocSize: allocSize}
	switch typeconv.TypeFamilyToCanonicalTypeFamily(t.Family()) {
	case types.BoolFamily:
		switch t.Width() {
		case -1:
		default:
			return &anyNotNullBoolOrderedAggAlloc{aggAllocBase: allocBase}, nil
		}
	case types.BytesFamily:
		switch t.Width() {
		case -1:
		default:
			return &anyNotNullBytesOrderedAggAlloc{aggAllocBase: allocBase}, nil
		}
	case types.DecimalFamily:
		switch t.Width() {
		case -1:
		default:
			return &anyNotNullDecimalOrderedAggAlloc{aggAllocBase: allocBase}, nil
		}
	case types.IntFamily:
		switch t.Width() {
		case 16:
			return &anyNotNullInt16OrderedAggAlloc{aggAllocBase: allocBase}, nil
		case 32:
			return &anyNotNullInt32OrderedAggAlloc{aggAllocBase: allocBase}, nil
		case -1:
		default:
			return &anyNotNullInt64OrderedAggAlloc{aggAllocBase: allocBase}, nil
		}
	case types.FloatFamily:
		switch t.Width() {
		case -1:
		default:
			return &anyNotNullFloat64OrderedAggAlloc{aggAllocBase: allocBase}, nil
		}
	case types.TimestampTZFamily:
		switch t.Width() {
		case -1:
		default:
			return &anyNotNullTimestampOrderedAggAlloc{aggAllocBase: allocBase}, nil
		}
	case types.IntervalFamily:
		switch t.Width() {
		case -1:
		default:
			return &anyNotNullIntervalOrderedAggAlloc{aggAllocBase: allocBase}, nil
		}
	case types.JsonFamily:
		switch t.Width() {
		case -1:
		default:
			return &anyNotNullJSONOrderedAggAlloc{aggAllocBase: allocBase}, nil
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch t.Width() {
		case -1:
		default:
			return &anyNotNullDatumOrderedAggAlloc{aggAllocBase: allocBase}, nil
		}
	}
	return nil, errors.AssertionFailedf("unsupported any not null agg type %s", t.Name())
}

// anyNotNullBoolOrderedAgg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
type anyNotNullBoolOrderedAgg struct {
	orderedAggregateFuncBase
	col                         coldata.Bools
	curAgg                      bool
	foundNonNullForCurrentGroup bool
}

var _ AggregateFunc = &anyNotNullBoolOrderedAgg{}

func (a *anyNotNullBoolOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Bool()
}

func (a *anyNotNullBoolOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Bool(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *anyNotNullBoolOrderedAgg) Flush(outputIdx int) {
	// If we haven't found any non-nulls for this group so far, the output for
	// this group should be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if !a.foundNonNullForCurrentGroup {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *anyNotNullBoolOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.foundNonNullForCurrentGroup = false
}

type anyNotNullBoolOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []anyNotNullBoolOrderedAgg
}

var _ aggregateFuncAlloc = &anyNotNullBoolOrderedAggAlloc{}

const sizeOfAnyNotNullBoolOrderedAgg = int64(unsafe.Sizeof(anyNotNullBoolOrderedAgg{}))
const anyNotNullBoolOrderedAggSliceOverhead = int64(unsafe.Sizeof([]anyNotNullBoolOrderedAgg{}))

func (a *anyNotNullBoolOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(anyNotNullBoolOrderedAggSliceOverhead + sizeOfAnyNotNullBoolOrderedAgg*a.allocSize)
		a.aggFuncs = make([]anyNotNullBoolOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// anyNotNullBytesOrderedAgg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
type anyNotNullBytesOrderedAgg struct {
	orderedAggregateFuncBase
	col                         *coldata.Bytes
	curAgg                      []byte
	foundNonNullForCurrentGroup bool
}

var _ AggregateFunc = &anyNotNullBytesOrderedAgg{}

func (a *anyNotNullBytesOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Bytes()
}

func (a *anyNotNullBytesOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	oldCurAggSize := len(a.curAgg)
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Bytes(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = append(a.curAgg[:0], val...)
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = append(a.curAgg[:0], val...)
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = append(a.curAgg[:0], val...)
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = append(a.curAgg[:0], val...)
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		}
	},
	)
	newCurAggSize := len(a.curAgg)
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *anyNotNullBytesOrderedAgg) Flush(outputIdx int) {
	// If we haven't found any non-nulls for this group so far, the output for
	// this group should be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if !a.foundNonNullForCurrentGroup {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
	// Release the reference to curAgg eagerly.
	oldCurAggSize := len(a.curAgg)
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

func (a *anyNotNullBytesOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.foundNonNullForCurrentGroup = false
}

type anyNotNullBytesOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []anyNotNullBytesOrderedAgg
}

var _ aggregateFuncAlloc = &anyNotNullBytesOrderedAggAlloc{}

const sizeOfAnyNotNullBytesOrderedAgg = int64(unsafe.Sizeof(anyNotNullBytesOrderedAgg{}))
const anyNotNullBytesOrderedAggSliceOverhead = int64(unsafe.Sizeof([]anyNotNullBytesOrderedAgg{}))

func (a *anyNotNullBytesOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(anyNotNullBytesOrderedAggSliceOverhead + sizeOfAnyNotNullBytesOrderedAgg*a.allocSize)
		a.aggFuncs = make([]anyNotNullBytesOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// anyNotNullDecimalOrderedAgg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
type anyNotNullDecimalOrderedAgg struct {
	orderedAggregateFuncBase
	col                         coldata.Decimals
	curAgg                      apd.Decimal
	foundNonNullForCurrentGroup bool
}

var _ AggregateFunc = &anyNotNullDecimalOrderedAgg{}

func (a *anyNotNullDecimalOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Decimal()
}

func (a *anyNotNullDecimalOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	oldCurAggSize := a.curAgg.Size()
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Decimal(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg.Set(&val)
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg.Set(&val)
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg.Set(&val)
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg.Set(&val)
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		}
	},
	)
	newCurAggSize := a.curAgg.Size()
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *anyNotNullDecimalOrderedAgg) Flush(outputIdx int) {
	// If we haven't found any non-nulls for this group so far, the output for
	// this group should be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if !a.foundNonNullForCurrentGroup {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *anyNotNullDecimalOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.foundNonNullForCurrentGroup = false
}

type anyNotNullDecimalOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []anyNotNullDecimalOrderedAgg
}

var _ aggregateFuncAlloc = &anyNotNullDecimalOrderedAggAlloc{}

const sizeOfAnyNotNullDecimalOrderedAgg = int64(unsafe.Sizeof(anyNotNullDecimalOrderedAgg{}))
const anyNotNullDecimalOrderedAggSliceOverhead = int64(unsafe.Sizeof([]anyNotNullDecimalOrderedAgg{}))

func (a *anyNotNullDecimalOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(anyNotNullDecimalOrderedAggSliceOverhead + sizeOfAnyNotNullDecimalOrderedAgg*a.allocSize)
		a.aggFuncs = make([]anyNotNullDecimalOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// anyNotNullInt16OrderedAgg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
type anyNotNullInt16OrderedAgg struct {
	orderedAggregateFuncBase
	col                         coldata.Int16s
	curAgg                      int16
	foundNonNullForCurrentGroup bool
}

var _ AggregateFunc = &anyNotNullInt16OrderedAgg{}

func (a *anyNotNullInt16OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Int16()
}

func (a *anyNotNullInt16OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int16(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *anyNotNullInt16OrderedAgg) Flush(outputIdx int) {
	// If we haven't found any non-nulls for this group so far, the output for
	// this group should be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if !a.foundNonNullForCurrentGroup {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *anyNotNullInt16OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.foundNonNullForCurrentGroup = false
}

type anyNotNullInt16OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []anyNotNullInt16OrderedAgg
}

var _ aggregateFuncAlloc = &anyNotNullInt16OrderedAggAlloc{}

const sizeOfAnyNotNullInt16OrderedAgg = int64(unsafe.Sizeof(anyNotNullInt16OrderedAgg{}))
const anyNotNullInt16OrderedAggSliceOverhead = int64(unsafe.Sizeof([]anyNotNullInt16OrderedAgg{}))

func (a *anyNotNullInt16OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(anyNotNullInt16OrderedAggSliceOverhead + sizeOfAnyNotNullInt16OrderedAgg*a.allocSize)
		a.aggFuncs = make([]anyNotNullInt16OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// anyNotNullInt32OrderedAgg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
type anyNotNullInt32OrderedAgg struct {
	orderedAggregateFuncBase
	col                         coldata.Int32s
	curAgg                      int32
	foundNonNullForCurrentGroup bool
}

var _ AggregateFunc = &anyNotNullInt32OrderedAgg{}

func (a *anyNotNullInt32OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Int32()
}

func (a *anyNotNullInt32OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int32(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *anyNotNullInt32OrderedAgg) Flush(outputIdx int) {
	// If we haven't found any non-nulls for this group so far, the output for
	// this group should be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if !a.foundNonNullForCurrentGroup {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *anyNotNullInt32OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.foundNonNullForCurrentGroup = false
}

type anyNotNullInt32OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []anyNotNullInt32OrderedAgg
}

var _ aggregateFuncAlloc = &anyNotNullInt32OrderedAggAlloc{}

const sizeOfAnyNotNullInt32OrderedAgg = int64(unsafe.Sizeof(anyNotNullInt32OrderedAgg{}))
const anyNotNullInt32OrderedAggSliceOverhead = int64(unsafe.Sizeof([]anyNotNullInt32OrderedAgg{}))

func (a *anyNotNullInt32OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(anyNotNullInt32OrderedAggSliceOverhead + sizeOfAnyNotNullInt32OrderedAgg*a.allocSize)
		a.aggFuncs = make([]anyNotNullInt32OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// anyNotNullInt64OrderedAgg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
type anyNotNullInt64OrderedAgg struct {
	orderedAggregateFuncBase
	col                         coldata.Int64s
	curAgg                      int64
	foundNonNullForCurrentGroup bool
}

var _ AggregateFunc = &anyNotNullInt64OrderedAgg{}

func (a *anyNotNullInt64OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Int64()
}

func (a *anyNotNullInt64OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int64(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *anyNotNullInt64OrderedAgg) Flush(outputIdx int) {
	// If we haven't found any non-nulls for this group so far, the output for
	// this group should be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if !a.foundNonNullForCurrentGroup {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *anyNotNullInt64OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.foundNonNullForCurrentGroup = false
}

type anyNotNullInt64OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []anyNotNullInt64OrderedAgg
}

var _ aggregateFuncAlloc = &anyNotNullInt64OrderedAggAlloc{}

const sizeOfAnyNotNullInt64OrderedAgg = int64(unsafe.Sizeof(anyNotNullInt64OrderedAgg{}))
const anyNotNullInt64OrderedAggSliceOverhead = int64(unsafe.Sizeof([]anyNotNullInt64OrderedAgg{}))

func (a *anyNotNullInt64OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(anyNotNullInt64OrderedAggSliceOverhead + sizeOfAnyNotNullInt64OrderedAgg*a.allocSize)
		a.aggFuncs = make([]anyNotNullInt64OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// anyNotNullFloat64OrderedAgg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
type anyNotNullFloat64OrderedAgg struct {
	orderedAggregateFuncBase
	col                         coldata.Float64s
	curAgg                      float64
	foundNonNullForCurrentGroup bool
}

var _ AggregateFunc = &anyNotNullFloat64OrderedAgg{}

func (a *anyNotNullFloat64OrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Float64()
}

func (a *anyNotNullFloat64OrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Float64(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *anyNotNullFloat64OrderedAgg) Flush(outputIdx int) {
	// If we haven't found any non-nulls for this group so far, the output for
	// this group should be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if !a.foundNonNullForCurrentGroup {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *anyNotNullFloat64OrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.foundNonNullForCurrentGroup = false
}

type anyNotNullFloat64OrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []anyNotNullFloat64OrderedAgg
}

var _ aggregateFuncAlloc = &anyNotNullFloat64OrderedAggAlloc{}

const sizeOfAnyNotNullFloat64OrderedAgg = int64(unsafe.Sizeof(anyNotNullFloat64OrderedAgg{}))
const anyNotNullFloat64OrderedAggSliceOverhead = int64(unsafe.Sizeof([]anyNotNullFloat64OrderedAgg{}))

func (a *anyNotNullFloat64OrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(anyNotNullFloat64OrderedAggSliceOverhead + sizeOfAnyNotNullFloat64OrderedAgg*a.allocSize)
		a.aggFuncs = make([]anyNotNullFloat64OrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// anyNotNullTimestampOrderedAgg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
type anyNotNullTimestampOrderedAgg struct {
	orderedAggregateFuncBase
	col                         coldata.Times
	curAgg                      time.Time
	foundNonNullForCurrentGroup bool
}

var _ AggregateFunc = &anyNotNullTimestampOrderedAgg{}

func (a *anyNotNullTimestampOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Timestamp()
}

func (a *anyNotNullTimestampOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Timestamp(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *anyNotNullTimestampOrderedAgg) Flush(outputIdx int) {
	// If we haven't found any non-nulls for this group so far, the output for
	// this group should be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if !a.foundNonNullForCurrentGroup {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *anyNotNullTimestampOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.foundNonNullForCurrentGroup = false
}

type anyNotNullTimestampOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []anyNotNullTimestampOrderedAgg
}

var _ aggregateFuncAlloc = &anyNotNullTimestampOrderedAggAlloc{}

const sizeOfAnyNotNullTimestampOrderedAgg = int64(unsafe.Sizeof(anyNotNullTimestampOrderedAgg{}))
const anyNotNullTimestampOrderedAggSliceOverhead = int64(unsafe.Sizeof([]anyNotNullTimestampOrderedAgg{}))

func (a *anyNotNullTimestampOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(anyNotNullTimestampOrderedAggSliceOverhead + sizeOfAnyNotNullTimestampOrderedAgg*a.allocSize)
		a.aggFuncs = make([]anyNotNullTimestampOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// anyNotNullIntervalOrderedAgg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
type anyNotNullIntervalOrderedAgg struct {
	orderedAggregateFuncBase
	col                         coldata.Durations
	curAgg                      duration.Duration
	foundNonNullForCurrentGroup bool
}

var _ AggregateFunc = &anyNotNullIntervalOrderedAgg{}

func (a *anyNotNullIntervalOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Interval()
}

func (a *anyNotNullIntervalOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Interval(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *anyNotNullIntervalOrderedAgg) Flush(outputIdx int) {
	// If we haven't found any non-nulls for this group so far, the output for
	// this group should be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if !a.foundNonNullForCurrentGroup {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *anyNotNullIntervalOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.foundNonNullForCurrentGroup = false
}

type anyNotNullIntervalOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []anyNotNullIntervalOrderedAgg
}

var _ aggregateFuncAlloc = &anyNotNullIntervalOrderedAggAlloc{}

const sizeOfAnyNotNullIntervalOrderedAgg = int64(unsafe.Sizeof(anyNotNullIntervalOrderedAgg{}))
const anyNotNullIntervalOrderedAggSliceOverhead = int64(unsafe.Sizeof([]anyNotNullIntervalOrderedAgg{}))

func (a *anyNotNullIntervalOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(anyNotNullIntervalOrderedAggSliceOverhead + sizeOfAnyNotNullIntervalOrderedAgg*a.allocSize)
		a.aggFuncs = make([]anyNotNullIntervalOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// anyNotNullJSONOrderedAgg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
type anyNotNullJSONOrderedAgg struct {
	orderedAggregateFuncBase
	col                         *coldata.JSONs
	curAgg                      json.JSON
	foundNonNullForCurrentGroup bool
}

var _ AggregateFunc = &anyNotNullJSONOrderedAgg{}

func (a *anyNotNullJSONOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.JSON()
}

func (a *anyNotNullJSONOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.JSON(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)

						var _err error
						var _bytes []byte
						_bytes, _err = json.EncodeJSON(nil, val)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						a.curAgg, _err = json.FromEncoding(_bytes)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)

						var _err error
						var _bytes []byte
						_bytes, _err = json.EncodeJSON(nil, val)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						a.curAgg, _err = json.FromEncoding(_bytes)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)

						var _err error
						var _bytes []byte
						_bytes, _err = json.EncodeJSON(nil, val)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						a.curAgg, _err = json.FromEncoding(_bytes)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)

						var _err error
						var _bytes []byte
						_bytes, _err = json.EncodeJSON(nil, val)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}
						a.curAgg, _err = json.FromEncoding(_bytes)
						if _err != nil {
							colexecerror.ExpectedError(_err)
						}

						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if a.curAgg != nil {
		newCurAggSize = a.curAgg.Size()
	}
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *anyNotNullJSONOrderedAgg) Flush(outputIdx int) {
	// If we haven't found any non-nulls for this group so far, the output for
	// this group should be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if !a.foundNonNullForCurrentGroup {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
	// Release the reference to curAgg eagerly.
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

func (a *anyNotNullJSONOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.foundNonNullForCurrentGroup = false
}

type anyNotNullJSONOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []anyNotNullJSONOrderedAgg
}

var _ aggregateFuncAlloc = &anyNotNullJSONOrderedAggAlloc{}

const sizeOfAnyNotNullJSONOrderedAgg = int64(unsafe.Sizeof(anyNotNullJSONOrderedAgg{}))
const anyNotNullJSONOrderedAggSliceOverhead = int64(unsafe.Sizeof([]anyNotNullJSONOrderedAgg{}))

func (a *anyNotNullJSONOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(anyNotNullJSONOrderedAggSliceOverhead + sizeOfAnyNotNullJSONOrderedAgg*a.allocSize)
		a.aggFuncs = make([]anyNotNullJSONOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

// anyNotNullDatumOrderedAgg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
type anyNotNullDatumOrderedAgg struct {
	orderedAggregateFuncBase
	col                         coldata.DatumVec
	curAgg                      interface{}
	foundNonNullForCurrentGroup bool
}

var _ AggregateFunc = &anyNotNullDatumOrderedAgg{}

func (a *anyNotNullDatumOrderedAgg) SetOutput(vec *coldata.Vec) {
	a.orderedAggregateFuncBase.SetOutput(vec)
	a.col = vec.Datum()
}

func (a *anyNotNullDatumOrderedAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Datum(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		// Capture groups and col to force bounds check to work. See
		// https://github.com/golang/go/issues/39756
		groups := a.groups
		col := col
		if sel == nil {
			_, _ = groups[endIdx-1], groups[startIdx]
			_, _ = col.Get(endIdx-1), col.Get(startIdx)
			if nulls.MaybeHasNulls() {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for i := startIdx; i < endIdx; i++ {
					//gcassert:bce
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		} else {
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = nulls.NullAt(i)
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for _, i := range sel {
					if groups[i] {
						if !a.isFirstGroup {
							// If this is a new group, check if any non-nulls have been found for the
							// current group.
							if !a.foundNonNullForCurrentGroup {
								a.nulls.SetNull(a.curIdx)
							} else {
								a.col.Set(a.curIdx, a.curAgg)
							}
							a.curIdx++
							a.foundNonNullForCurrentGroup = false
						}
						a.isFirstGroup = false
					}

					var isNull bool
					isNull = false
					if !a.foundNonNullForCurrentGroup && !isNull {
						// If we haven't seen any non-nulls for the current group yet, and the
						// current value is non-null, then we can pick the current value to be
						// the output.
						val := col.Get(i)
						a.curAgg = val
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		}
	},
	)

	var newCurAggSize uintptr
	if a.curAgg != nil {
		newCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *anyNotNullDatumOrderedAgg) Flush(outputIdx int) {
	// If we haven't found any non-nulls for this group so far, the output for
	// this group should be null.
	// Go around "argument overwritten before first use" linter error.
	_ = outputIdx
	outputIdx = a.curIdx
	a.curIdx++
	col := a.col
	if !a.foundNonNullForCurrentGroup {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
	// Release the reference to curAgg eagerly.

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

func (a *anyNotNullDatumOrderedAgg) Reset() {
	a.orderedAggregateFuncBase.Reset()
	a.foundNonNullForCurrentGroup = false
}

type anyNotNullDatumOrderedAggAlloc struct {
	aggAllocBase
	aggFuncs []anyNotNullDatumOrderedAgg
}

var _ aggregateFuncAlloc = &anyNotNullDatumOrderedAggAlloc{}

const sizeOfAnyNotNullDatumOrderedAgg = int64(unsafe.Sizeof(anyNotNullDatumOrderedAgg{}))
const anyNotNullDatumOrderedAggSliceOverhead = int64(unsafe.Sizeof([]anyNotNullDatumOrderedAgg{}))

func (a *anyNotNullDatumOrderedAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(anyNotNullDatumOrderedAggSliceOverhead + sizeOfAnyNotNullDatumOrderedAgg*a.allocSize)
		a.aggFuncs = make([]anyNotNullDatumOrderedAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}
