// Code generated by execgen; DO NOT EDIT.
// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecagg

import (
	"bytes"
	"math"
	"time"
	"unsafe"

	"github.com/cockroachdb/apd/v3"
	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/col/coldataext"
	"github.com/cockroachdb/cockroach/pkg/col/typeconv"
	"github.com/cockroachdb/cockroach/pkg/sql/colexecerror"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/types"
	"github.com/cockroachdb/cockroach/pkg/util/duration"
	"github.com/cockroachdb/cockroach/pkg/util/json"
	"github.com/cockroachdb/errors"
)

// Workaround for bazel auto-generated code. goimports does not automatically
// pick up the right packages when run within the bazel sandbox.
var (
	_ tree.AggType
	_ apd.Context
	_ duration.Duration
	_ json.JSON
	_ = coldataext.CompareDatum
)

// Remove unused warning.
var _ = colexecerror.InternalError

func newMinHashAggAlloc(
	allocator *colmem.Allocator, t *types.T, allocSize int64,
) aggregateFuncAlloc {
	allocBase := aggAllocBase{allocator: allocator, allocSize: allocSize}
	switch typeconv.TypeFamilyToCanonicalTypeFamily(t.Family()) {
	case types.BoolFamily:
		switch t.Width() {
		case -1:
		default:
			return &minBoolHashAggAlloc{aggAllocBase: allocBase}
		}
	case types.BytesFamily:
		switch t.Width() {
		case -1:
		default:
			return &minBytesHashAggAlloc{aggAllocBase: allocBase}
		}
	case types.DecimalFamily:
		switch t.Width() {
		case -1:
		default:
			return &minDecimalHashAggAlloc{aggAllocBase: allocBase}
		}
	case types.IntFamily:
		switch t.Width() {
		case 16:
			return &minInt16HashAggAlloc{aggAllocBase: allocBase}
		case 32:
			return &minInt32HashAggAlloc{aggAllocBase: allocBase}
		case -1:
		default:
			return &minInt64HashAggAlloc{aggAllocBase: allocBase}
		}
	case types.FloatFamily:
		switch t.Width() {
		case -1:
		default:
			return &minFloat64HashAggAlloc{aggAllocBase: allocBase}
		}
	case types.TimestampTZFamily:
		switch t.Width() {
		case -1:
		default:
			return &minTimestampHashAggAlloc{aggAllocBase: allocBase}
		}
	case types.IntervalFamily:
		switch t.Width() {
		case -1:
		default:
			return &minIntervalHashAggAlloc{aggAllocBase: allocBase}
		}
	case types.JsonFamily:
		switch t.Width() {
		case -1:
		default:
			return &minJSONHashAggAlloc{aggAllocBase: allocBase}
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch t.Width() {
		case -1:
		default:
			return &minDatumHashAggAlloc{aggAllocBase: allocBase}
		}
	}
	colexecerror.InternalError(errors.AssertionFailedf("unexpectedly didn't find min overload for %s type family", t.Name()))
	// This code is unreachable, but the compiler cannot infer that.
	return nil
}

type minBoolHashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg bool
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minBoolHashAgg{}

func (a *minBoolHashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Bool(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if !candidate && a.curAgg {
									cmpResult = -1
								} else if candidate && !a.curAgg {
									cmpResult = 1
								} else {
									cmpResult = 0
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if !candidate && a.curAgg {
									cmpResult = -1
								} else if candidate && !a.curAgg {
									cmpResult = 1
								} else {
									cmpResult = 0
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minBoolHashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Bool()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minBoolHashAgg) Reset() {
	a.numNonNull = 0
}

type minBoolHashAggAlloc struct {
	aggAllocBase
	aggFuncs []minBoolHashAgg
}

var _ aggregateFuncAlloc = &minBoolHashAggAlloc{}

const sizeOfminBoolHashAgg = int64(unsafe.Sizeof(minBoolHashAgg{}))
const minBoolHashAggSliceOverhead = int64(unsafe.Sizeof([]minBoolHashAgg{}))

func (a *minBoolHashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minBoolHashAggSliceOverhead + sizeOfminBoolHashAgg*a.allocSize)
		a.aggFuncs = make([]minBoolHashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minBytesHashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg []byte
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minBytesHashAgg{}

func (a *minBytesHashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurAggSize := len(a.curAgg)
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Bytes(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = append(a.curAgg[:0], val...)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = bytes.Compare(candidate, a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = append(a.curAgg[:0], candidate...)
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = append(a.curAgg[:0], val...)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = bytes.Compare(candidate, a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = append(a.curAgg[:0], candidate...)
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	newCurAggSize := len(a.curAgg)
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minBytesHashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Bytes()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
	oldCurAggSize := len(a.curAgg)
	// Release the reference to curAgg eagerly. We can't do this for the window
	// variants because they may reuse curAgg between subsequent window frames.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

func (a *minBytesHashAgg) Reset() {
	a.numNonNull = 0
	oldCurAggSize := len(a.curAgg)
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type minBytesHashAggAlloc struct {
	aggAllocBase
	aggFuncs []minBytesHashAgg
}

var _ aggregateFuncAlloc = &minBytesHashAggAlloc{}

const sizeOfminBytesHashAgg = int64(unsafe.Sizeof(minBytesHashAgg{}))
const minBytesHashAggSliceOverhead = int64(unsafe.Sizeof([]minBytesHashAgg{}))

func (a *minBytesHashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minBytesHashAggSliceOverhead + sizeOfminBytesHashAgg*a.allocSize)
		a.aggFuncs = make([]minBytesHashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minDecimalHashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg apd.Decimal
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minDecimalHashAgg{}

func (a *minDecimalHashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurAggSize := a.curAgg.Size()
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Decimal(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg.Set(&val)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg.Set(&candidate)
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg.Set(&val)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg.Set(&candidate)
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	newCurAggSize := a.curAgg.Size()
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minDecimalHashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Decimal()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minDecimalHashAgg) Reset() {
	a.numNonNull = 0
}

type minDecimalHashAggAlloc struct {
	aggAllocBase
	aggFuncs []minDecimalHashAgg
}

var _ aggregateFuncAlloc = &minDecimalHashAggAlloc{}

const sizeOfminDecimalHashAgg = int64(unsafe.Sizeof(minDecimalHashAgg{}))
const minDecimalHashAggSliceOverhead = int64(unsafe.Sizeof([]minDecimalHashAgg{}))

func (a *minDecimalHashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minDecimalHashAggSliceOverhead + sizeOfminDecimalHashAgg*a.allocSize)
		a.aggFuncs = make([]minDecimalHashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minInt16HashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int16
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minInt16HashAgg{}

func (a *minInt16HashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int16(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minInt16HashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Int16()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minInt16HashAgg) Reset() {
	a.numNonNull = 0
}

type minInt16HashAggAlloc struct {
	aggAllocBase
	aggFuncs []minInt16HashAgg
}

var _ aggregateFuncAlloc = &minInt16HashAggAlloc{}

const sizeOfminInt16HashAgg = int64(unsafe.Sizeof(minInt16HashAgg{}))
const minInt16HashAggSliceOverhead = int64(unsafe.Sizeof([]minInt16HashAgg{}))

func (a *minInt16HashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minInt16HashAggSliceOverhead + sizeOfminInt16HashAgg*a.allocSize)
		a.aggFuncs = make([]minInt16HashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minInt32HashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int32
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minInt32HashAgg{}

func (a *minInt32HashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int32(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minInt32HashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Int32()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minInt32HashAgg) Reset() {
	a.numNonNull = 0
}

type minInt32HashAggAlloc struct {
	aggAllocBase
	aggFuncs []minInt32HashAgg
}

var _ aggregateFuncAlloc = &minInt32HashAggAlloc{}

const sizeOfminInt32HashAgg = int64(unsafe.Sizeof(minInt32HashAgg{}))
const minInt32HashAggSliceOverhead = int64(unsafe.Sizeof([]minInt32HashAgg{}))

func (a *minInt32HashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minInt32HashAggSliceOverhead + sizeOfminInt32HashAgg*a.allocSize)
		a.aggFuncs = make([]minInt32HashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minInt64HashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int64
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minInt64HashAgg{}

func (a *minInt64HashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int64(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minInt64HashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Int64()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minInt64HashAgg) Reset() {
	a.numNonNull = 0
}

type minInt64HashAggAlloc struct {
	aggAllocBase
	aggFuncs []minInt64HashAgg
}

var _ aggregateFuncAlloc = &minInt64HashAggAlloc{}

const sizeOfminInt64HashAgg = int64(unsafe.Sizeof(minInt64HashAgg{}))
const minInt64HashAggSliceOverhead = int64(unsafe.Sizeof([]minInt64HashAgg{}))

func (a *minInt64HashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minInt64HashAggSliceOverhead + sizeOfminInt64HashAgg*a.allocSize)
		a.aggFuncs = make([]minInt64HashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minFloat64HashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg float64
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minFloat64HashAgg{}

func (a *minFloat64HashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Float64(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := float64(candidate), float64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else if a == b {
										cmpResult = 0
									} else if math.IsNaN(a) {
										if math.IsNaN(b) {
											cmpResult = 0
										} else {
											cmpResult = -1
										}
									} else {
										cmpResult = 1
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := float64(candidate), float64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else if a == b {
										cmpResult = 0
									} else if math.IsNaN(a) {
										if math.IsNaN(b) {
											cmpResult = 0
										} else {
											cmpResult = -1
										}
									} else {
										cmpResult = 1
									}
								}

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minFloat64HashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Float64()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minFloat64HashAgg) Reset() {
	a.numNonNull = 0
}

type minFloat64HashAggAlloc struct {
	aggAllocBase
	aggFuncs []minFloat64HashAgg
}

var _ aggregateFuncAlloc = &minFloat64HashAggAlloc{}

const sizeOfminFloat64HashAgg = int64(unsafe.Sizeof(minFloat64HashAgg{}))
const minFloat64HashAggSliceOverhead = int64(unsafe.Sizeof([]minFloat64HashAgg{}))

func (a *minFloat64HashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minFloat64HashAggSliceOverhead + sizeOfminFloat64HashAgg*a.allocSize)
		a.aggFuncs = make([]minFloat64HashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minTimestampHashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg time.Time
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minTimestampHashAgg{}

func (a *minTimestampHashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Timestamp(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if candidate.Before(a.curAgg) {
									cmpResult = -1
								} else if a.curAgg.Before(candidate) {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if candidate.Before(a.curAgg) {
									cmpResult = -1
								} else if a.curAgg.Before(candidate) {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minTimestampHashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Timestamp()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minTimestampHashAgg) Reset() {
	a.numNonNull = 0
}

type minTimestampHashAggAlloc struct {
	aggAllocBase
	aggFuncs []minTimestampHashAgg
}

var _ aggregateFuncAlloc = &minTimestampHashAggAlloc{}

const sizeOfminTimestampHashAgg = int64(unsafe.Sizeof(minTimestampHashAgg{}))
const minTimestampHashAggSliceOverhead = int64(unsafe.Sizeof([]minTimestampHashAgg{}))

func (a *minTimestampHashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minTimestampHashAggSliceOverhead + sizeOfminTimestampHashAgg*a.allocSize)
		a.aggFuncs = make([]minTimestampHashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minIntervalHashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg duration.Duration
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minIntervalHashAgg{}

func (a *minIntervalHashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Interval(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = candidate.Compare(a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = candidate.Compare(a.curAgg)
								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minIntervalHashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Interval()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *minIntervalHashAgg) Reset() {
	a.numNonNull = 0
}

type minIntervalHashAggAlloc struct {
	aggAllocBase
	aggFuncs []minIntervalHashAgg
}

var _ aggregateFuncAlloc = &minIntervalHashAggAlloc{}

const sizeOfminIntervalHashAgg = int64(unsafe.Sizeof(minIntervalHashAgg{}))
const minIntervalHashAggSliceOverhead = int64(unsafe.Sizeof([]minIntervalHashAgg{}))

func (a *minIntervalHashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minIntervalHashAggSliceOverhead + sizeOfminIntervalHashAgg*a.allocSize)
		a.aggFuncs = make([]minIntervalHashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minJSONHashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg json.JSON
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minJSONHashAgg{}

func (a *minJSONHashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.JSON(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)

							var _err error
							var _bytes []byte
							_bytes, _err = json.EncodeJSON(nil, val)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							a.curAgg, _err = json.FromEncoding(_bytes)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}

						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								var err error
								cmpResult, err = candidate.Compare(a.curAgg)
								if err != nil {
									colexecerror.ExpectedError(err)
								}

								cmp = cmpResult < 0
							}

							if cmp {

								var _err error
								var _bytes []byte
								_bytes, _err = json.EncodeJSON(nil, candidate)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}
								a.curAgg, _err = json.FromEncoding(_bytes)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}

							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)

							var _err error
							var _bytes []byte
							_bytes, _err = json.EncodeJSON(nil, val)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							a.curAgg, _err = json.FromEncoding(_bytes)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}

						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								var err error
								cmpResult, err = candidate.Compare(a.curAgg)
								if err != nil {
									colexecerror.ExpectedError(err)
								}

								cmp = cmpResult < 0
							}

							if cmp {

								var _err error
								var _bytes []byte
								_bytes, _err = json.EncodeJSON(nil, candidate)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}
								a.curAgg, _err = json.FromEncoding(_bytes)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}

							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if a.curAgg != nil {
		newCurAggSize = a.curAgg.Size()
	}
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minJSONHashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.JSON()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	// Release the reference to curAgg eagerly. We can't do this for the window
	// variants because they may reuse curAgg between subsequent window frames.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

func (a *minJSONHashAgg) Reset() {
	a.numNonNull = 0
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type minJSONHashAggAlloc struct {
	aggAllocBase
	aggFuncs []minJSONHashAgg
}

var _ aggregateFuncAlloc = &minJSONHashAggAlloc{}

const sizeOfminJSONHashAgg = int64(unsafe.Sizeof(minJSONHashAgg{}))
const minJSONHashAggSliceOverhead = int64(unsafe.Sizeof([]minJSONHashAgg{}))

func (a *minJSONHashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minJSONHashAggSliceOverhead + sizeOfminJSONHashAgg*a.allocSize)
		a.aggFuncs = make([]minJSONHashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type minDatumHashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg interface{}
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &minDatumHashAgg{}

func (a *minDatumHashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Datum(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

								cmp = cmpResult < 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)

	var newCurAggSize uintptr
	if a.curAgg != nil {
		newCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *minDatumHashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Datum()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	// Release the reference to curAgg eagerly. We can't do this for the window
	// variants because they may reuse curAgg between subsequent window frames.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

func (a *minDatumHashAgg) Reset() {
	a.numNonNull = 0

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type minDatumHashAggAlloc struct {
	aggAllocBase
	aggFuncs []minDatumHashAgg
}

var _ aggregateFuncAlloc = &minDatumHashAggAlloc{}

const sizeOfminDatumHashAgg = int64(unsafe.Sizeof(minDatumHashAgg{}))
const minDatumHashAggSliceOverhead = int64(unsafe.Sizeof([]minDatumHashAgg{}))

func (a *minDatumHashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(minDatumHashAggSliceOverhead + sizeOfminDatumHashAgg*a.allocSize)
		a.aggFuncs = make([]minDatumHashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

func newMaxHashAggAlloc(
	allocator *colmem.Allocator, t *types.T, allocSize int64,
) aggregateFuncAlloc {
	allocBase := aggAllocBase{allocator: allocator, allocSize: allocSize}
	switch typeconv.TypeFamilyToCanonicalTypeFamily(t.Family()) {
	case types.BoolFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxBoolHashAggAlloc{aggAllocBase: allocBase}
		}
	case types.BytesFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxBytesHashAggAlloc{aggAllocBase: allocBase}
		}
	case types.DecimalFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxDecimalHashAggAlloc{aggAllocBase: allocBase}
		}
	case types.IntFamily:
		switch t.Width() {
		case 16:
			return &maxInt16HashAggAlloc{aggAllocBase: allocBase}
		case 32:
			return &maxInt32HashAggAlloc{aggAllocBase: allocBase}
		case -1:
		default:
			return &maxInt64HashAggAlloc{aggAllocBase: allocBase}
		}
	case types.FloatFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxFloat64HashAggAlloc{aggAllocBase: allocBase}
		}
	case types.TimestampTZFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxTimestampHashAggAlloc{aggAllocBase: allocBase}
		}
	case types.IntervalFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxIntervalHashAggAlloc{aggAllocBase: allocBase}
		}
	case types.JsonFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxJSONHashAggAlloc{aggAllocBase: allocBase}
		}
	case typeconv.DatumVecCanonicalTypeFamily:
		switch t.Width() {
		case -1:
		default:
			return &maxDatumHashAggAlloc{aggAllocBase: allocBase}
		}
	}
	colexecerror.InternalError(errors.AssertionFailedf("unexpectedly didn't find max overload for %s type family", t.Name()))
	// This code is unreachable, but the compiler cannot infer that.
	return nil
}

type maxBoolHashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg bool
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxBoolHashAgg{}

func (a *maxBoolHashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Bool(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if !candidate && a.curAgg {
									cmpResult = -1
								} else if candidate && !a.curAgg {
									cmpResult = 1
								} else {
									cmpResult = 0
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if !candidate && a.curAgg {
									cmpResult = -1
								} else if candidate && !a.curAgg {
									cmpResult = 1
								} else {
									cmpResult = 0
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxBoolHashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Bool()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxBoolHashAgg) Reset() {
	a.numNonNull = 0
}

type maxBoolHashAggAlloc struct {
	aggAllocBase
	aggFuncs []maxBoolHashAgg
}

var _ aggregateFuncAlloc = &maxBoolHashAggAlloc{}

const sizeOfmaxBoolHashAgg = int64(unsafe.Sizeof(maxBoolHashAgg{}))
const maxBoolHashAggSliceOverhead = int64(unsafe.Sizeof([]maxBoolHashAgg{}))

func (a *maxBoolHashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxBoolHashAggSliceOverhead + sizeOfmaxBoolHashAgg*a.allocSize)
		a.aggFuncs = make([]maxBoolHashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxBytesHashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg []byte
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxBytesHashAgg{}

func (a *maxBytesHashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurAggSize := len(a.curAgg)
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Bytes(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = append(a.curAgg[:0], val...)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = bytes.Compare(candidate, a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = append(a.curAgg[:0], candidate...)
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = append(a.curAgg[:0], val...)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = bytes.Compare(candidate, a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = append(a.curAgg[:0], candidate...)
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	newCurAggSize := len(a.curAgg)
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxBytesHashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Bytes()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
	oldCurAggSize := len(a.curAgg)
	// Release the reference to curAgg eagerly. We can't do this for the window
	// variants because they may reuse curAgg between subsequent window frames.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

func (a *maxBytesHashAgg) Reset() {
	a.numNonNull = 0
	oldCurAggSize := len(a.curAgg)
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type maxBytesHashAggAlloc struct {
	aggAllocBase
	aggFuncs []maxBytesHashAgg
}

var _ aggregateFuncAlloc = &maxBytesHashAggAlloc{}

const sizeOfmaxBytesHashAgg = int64(unsafe.Sizeof(maxBytesHashAgg{}))
const maxBytesHashAggSliceOverhead = int64(unsafe.Sizeof([]maxBytesHashAgg{}))

func (a *maxBytesHashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxBytesHashAggSliceOverhead + sizeOfmaxBytesHashAgg*a.allocSize)
		a.aggFuncs = make([]maxBytesHashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxDecimalHashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg apd.Decimal
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxDecimalHashAgg{}

func (a *maxDecimalHashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurAggSize := a.curAgg.Size()
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Decimal(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg.Set(&val)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg.Set(&candidate)
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg.Set(&val)
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = tree.CompareDecimals(&candidate, &a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg.Set(&candidate)
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	newCurAggSize := a.curAgg.Size()
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxDecimalHashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Decimal()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxDecimalHashAgg) Reset() {
	a.numNonNull = 0
}

type maxDecimalHashAggAlloc struct {
	aggAllocBase
	aggFuncs []maxDecimalHashAgg
}

var _ aggregateFuncAlloc = &maxDecimalHashAggAlloc{}

const sizeOfmaxDecimalHashAgg = int64(unsafe.Sizeof(maxDecimalHashAgg{}))
const maxDecimalHashAggSliceOverhead = int64(unsafe.Sizeof([]maxDecimalHashAgg{}))

func (a *maxDecimalHashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxDecimalHashAggSliceOverhead + sizeOfmaxDecimalHashAgg*a.allocSize)
		a.aggFuncs = make([]maxDecimalHashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxInt16HashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int16
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxInt16HashAgg{}

func (a *maxInt16HashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int16(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxInt16HashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Int16()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxInt16HashAgg) Reset() {
	a.numNonNull = 0
}

type maxInt16HashAggAlloc struct {
	aggAllocBase
	aggFuncs []maxInt16HashAgg
}

var _ aggregateFuncAlloc = &maxInt16HashAggAlloc{}

const sizeOfmaxInt16HashAgg = int64(unsafe.Sizeof(maxInt16HashAgg{}))
const maxInt16HashAggSliceOverhead = int64(unsafe.Sizeof([]maxInt16HashAgg{}))

func (a *maxInt16HashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxInt16HashAggSliceOverhead + sizeOfmaxInt16HashAgg*a.allocSize)
		a.aggFuncs = make([]maxInt16HashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxInt32HashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int32
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxInt32HashAgg{}

func (a *maxInt32HashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int32(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxInt32HashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Int32()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxInt32HashAgg) Reset() {
	a.numNonNull = 0
}

type maxInt32HashAggAlloc struct {
	aggAllocBase
	aggFuncs []maxInt32HashAgg
}

var _ aggregateFuncAlloc = &maxInt32HashAggAlloc{}

const sizeOfmaxInt32HashAgg = int64(unsafe.Sizeof(maxInt32HashAgg{}))
const maxInt32HashAggSliceOverhead = int64(unsafe.Sizeof([]maxInt32HashAgg{}))

func (a *maxInt32HashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxInt32HashAggSliceOverhead + sizeOfmaxInt32HashAgg*a.allocSize)
		a.aggFuncs = make([]maxInt32HashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxInt64HashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg int64
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxInt64HashAgg{}

func (a *maxInt64HashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Int64(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := int64(candidate), int64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else {
										cmpResult = 0
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxInt64HashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Int64()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxInt64HashAgg) Reset() {
	a.numNonNull = 0
}

type maxInt64HashAggAlloc struct {
	aggAllocBase
	aggFuncs []maxInt64HashAgg
}

var _ aggregateFuncAlloc = &maxInt64HashAggAlloc{}

const sizeOfmaxInt64HashAgg = int64(unsafe.Sizeof(maxInt64HashAgg{}))
const maxInt64HashAggSliceOverhead = int64(unsafe.Sizeof([]maxInt64HashAgg{}))

func (a *maxInt64HashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxInt64HashAggSliceOverhead + sizeOfmaxInt64HashAgg*a.allocSize)
		a.aggFuncs = make([]maxInt64HashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxFloat64HashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg float64
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxFloat64HashAgg{}

func (a *maxFloat64HashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Float64(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := float64(candidate), float64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else if a == b {
										cmpResult = 0
									} else if math.IsNaN(a) {
										if math.IsNaN(b) {
											cmpResult = 0
										} else {
											cmpResult = -1
										}
									} else {
										cmpResult = 1
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								{
									a, b := float64(candidate), float64(a.curAgg)
									if a < b {
										cmpResult = -1
									} else if a > b {
										cmpResult = 1
									} else if a == b {
										cmpResult = 0
									} else if math.IsNaN(a) {
										if math.IsNaN(b) {
											cmpResult = 0
										} else {
											cmpResult = -1
										}
									} else {
										cmpResult = 1
									}
								}

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxFloat64HashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Float64()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxFloat64HashAgg) Reset() {
	a.numNonNull = 0
}

type maxFloat64HashAggAlloc struct {
	aggAllocBase
	aggFuncs []maxFloat64HashAgg
}

var _ aggregateFuncAlloc = &maxFloat64HashAggAlloc{}

const sizeOfmaxFloat64HashAgg = int64(unsafe.Sizeof(maxFloat64HashAgg{}))
const maxFloat64HashAggSliceOverhead = int64(unsafe.Sizeof([]maxFloat64HashAgg{}))

func (a *maxFloat64HashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxFloat64HashAggSliceOverhead + sizeOfmaxFloat64HashAgg*a.allocSize)
		a.aggFuncs = make([]maxFloat64HashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxTimestampHashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg time.Time
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxTimestampHashAgg{}

func (a *maxTimestampHashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Timestamp(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if candidate.Before(a.curAgg) {
									cmpResult = -1
								} else if a.curAgg.Before(candidate) {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								if candidate.Before(a.curAgg) {
									cmpResult = -1
								} else if a.curAgg.Before(candidate) {
									cmpResult = 1
								} else {
									cmpResult = 0
								}
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxTimestampHashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Timestamp()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxTimestampHashAgg) Reset() {
	a.numNonNull = 0
}

type maxTimestampHashAggAlloc struct {
	aggAllocBase
	aggFuncs []maxTimestampHashAgg
}

var _ aggregateFuncAlloc = &maxTimestampHashAggAlloc{}

const sizeOfmaxTimestampHashAgg = int64(unsafe.Sizeof(maxTimestampHashAgg{}))
const maxTimestampHashAggSliceOverhead = int64(unsafe.Sizeof([]maxTimestampHashAgg{}))

func (a *maxTimestampHashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxTimestampHashAggSliceOverhead + sizeOfmaxTimestampHashAgg*a.allocSize)
		a.aggFuncs = make([]maxTimestampHashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxIntervalHashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg duration.Duration
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxIntervalHashAgg{}

func (a *maxIntervalHashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Interval(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = candidate.Compare(a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int
								cmpResult = candidate.Compare(a.curAgg)
								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxIntervalHashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Interval()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
}

func (a *maxIntervalHashAgg) Reset() {
	a.numNonNull = 0
}

type maxIntervalHashAggAlloc struct {
	aggAllocBase
	aggFuncs []maxIntervalHashAgg
}

var _ aggregateFuncAlloc = &maxIntervalHashAggAlloc{}

const sizeOfmaxIntervalHashAgg = int64(unsafe.Sizeof(maxIntervalHashAgg{}))
const maxIntervalHashAggSliceOverhead = int64(unsafe.Sizeof([]maxIntervalHashAgg{}))

func (a *maxIntervalHashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxIntervalHashAggSliceOverhead + sizeOfmaxIntervalHashAgg*a.allocSize)
		a.aggFuncs = make([]maxIntervalHashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxJSONHashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg json.JSON
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxJSONHashAgg{}

func (a *maxJSONHashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.JSON(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)

							var _err error
							var _bytes []byte
							_bytes, _err = json.EncodeJSON(nil, val)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							a.curAgg, _err = json.FromEncoding(_bytes)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}

						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								var err error
								cmpResult, err = candidate.Compare(a.curAgg)
								if err != nil {
									colexecerror.ExpectedError(err)
								}

								cmp = cmpResult > 0
							}

							if cmp {

								var _err error
								var _bytes []byte
								_bytes, _err = json.EncodeJSON(nil, candidate)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}
								a.curAgg, _err = json.FromEncoding(_bytes)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}

							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)

							var _err error
							var _bytes []byte
							_bytes, _err = json.EncodeJSON(nil, val)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}
							a.curAgg, _err = json.FromEncoding(_bytes)
							if _err != nil {
								colexecerror.ExpectedError(_err)
							}

						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								var err error
								cmpResult, err = candidate.Compare(a.curAgg)
								if err != nil {
									colexecerror.ExpectedError(err)
								}

								cmp = cmpResult > 0
							}

							if cmp {

								var _err error
								var _bytes []byte
								_bytes, _err = json.EncodeJSON(nil, candidate)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}
								a.curAgg, _err = json.FromEncoding(_bytes)
								if _err != nil {
									colexecerror.ExpectedError(_err)
								}

							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)
	var newCurAggSize uintptr
	if a.curAgg != nil {
		newCurAggSize = a.curAgg.Size()
	}
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxJSONHashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.JSON()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	// Release the reference to curAgg eagerly. We can't do this for the window
	// variants because they may reuse curAgg between subsequent window frames.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

func (a *maxJSONHashAgg) Reset() {
	a.numNonNull = 0
	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.Size()
	}
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type maxJSONHashAggAlloc struct {
	aggAllocBase
	aggFuncs []maxJSONHashAgg
}

var _ aggregateFuncAlloc = &maxJSONHashAggAlloc{}

const sizeOfmaxJSONHashAgg = int64(unsafe.Sizeof(maxJSONHashAgg{}))
const maxJSONHashAggSliceOverhead = int64(unsafe.Sizeof([]maxJSONHashAgg{}))

func (a *maxJSONHashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxJSONHashAggSliceOverhead + sizeOfmaxJSONHashAgg*a.allocSize)
		a.aggFuncs = make([]maxJSONHashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}

type maxDatumHashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running min/max, so we can index into the slice once per
	// group, instead of on each iteration.
	// NOTE: if numNonNull is zero, curAgg is undefined.
	curAgg interface{}
	// numNonNull tracks the number of non-null values we have seen for the group
	// that is currently being aggregated.
	numNonNull uint64
}

var _ AggregateFunc = &maxDatumHashAgg{}

func (a *maxDatumHashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Datum(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						if a.numNonNull == 0 {
							val := col.Get(i)
							a.curAgg = val
						} else {
							var cmp bool
							candidate := col.Get(i)

							{
								var cmpResult int

								cmpResult = coldataext.CompareDatum(candidate, col, a.curAgg)

								cmp = cmpResult > 0
							}

							if cmp {
								a.curAgg = candidate
							}
						}
						a.numNonNull++
					}
				}
			}
		}
	},
	)

	var newCurAggSize uintptr
	if a.curAgg != nil {
		newCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *maxDatumHashAgg) Flush(outputIdx int) {
	// The aggregation is finished. Flush the last value. If we haven't found
	// any non-nulls for this group so far, the output for this group should
	// be null.
	col := a.vec.Datum()
	if a.numNonNull == 0 {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	// Release the reference to curAgg eagerly. We can't do this for the window
	// variants because they may reuse curAgg between subsequent window frames.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

func (a *maxDatumHashAgg) Reset() {
	a.numNonNull = 0

	var oldCurAggSize uintptr
	if a.curAgg != nil {
		oldCurAggSize = a.curAgg.(tree.Datum).Size()
	}
	// Release the reference to curAgg.
	a.allocator.AdjustMemoryUsage(-int64(oldCurAggSize))
	a.curAgg = nil
}

type maxDatumHashAggAlloc struct {
	aggAllocBase
	aggFuncs []maxDatumHashAgg
}

var _ aggregateFuncAlloc = &maxDatumHashAggAlloc{}

const sizeOfmaxDatumHashAgg = int64(unsafe.Sizeof(maxDatumHashAgg{}))
const maxDatumHashAggSliceOverhead = int64(unsafe.Sizeof([]maxDatumHashAgg{}))

func (a *maxDatumHashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(maxDatumHashAggSliceOverhead + sizeOfmaxDatumHashAgg*a.allocSize)
		a.aggFuncs = make([]maxDatumHashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}
