// Code generated by execgen; DO NOT EDIT.
// Copyright 2020 The Cockroach Authors.
//
// Use of this software is governed by the CockroachDB Software License
// included in the /LICENSE file.

package colexecagg

import (
	"unsafe"

	"github.com/cockroachdb/cockroach/pkg/col/coldata"
	"github.com/cockroachdb/cockroach/pkg/sql/colmem"
)

func newConcatHashAggAlloc(allocator *colmem.Allocator, allocSize int64) aggregateFuncAlloc {
	return &concatHashAggAlloc{aggAllocBase: aggAllocBase{
		allocator: allocator,
		allocSize: allocSize,
	}}
}

type concatHashAgg struct {
	unorderedAggregateFuncBase
	// curAgg holds the running total.
	curAgg []byte
	// foundNonNullForCurrentGroup tracks if we have seen any non-null values
	// for the group that is currently being aggregated.
	foundNonNullForCurrentGroup bool
}

func (a *concatHashAgg) Compute(
	vecs []*coldata.Vec, inputIdxs []uint32, startIdx, endIdx int, sel []int,
) {
	oldCurAggSize := len(a.curAgg)
	vec := vecs[inputIdxs[0]]
	col, nulls := vec.Bytes(), vec.Nulls()
	a.allocator.PerformOperation([]*coldata.Vec{a.vec}, func() {
		{
			sel = sel[startIdx:endIdx]
			if nulls.MaybeHasNulls() {
				for _, i := range sel {

					var isNull bool
					isNull = nulls.NullAt(i)
					if !isNull {
						a.curAgg = append(a.curAgg, col.Get(i)...)
						a.foundNonNullForCurrentGroup = true
					}
				}
			} else {
				for _, i := range sel {

					var isNull bool
					isNull = false
					if !isNull {
						a.curAgg = append(a.curAgg, col.Get(i)...)
						a.foundNonNullForCurrentGroup = true
					}
				}
			}
		}
	},
	)
	newCurAggSize := len(a.curAgg)
	if newCurAggSize != oldCurAggSize {
		a.allocator.AdjustMemoryUsageAfterAllocation(int64(newCurAggSize - oldCurAggSize))
	}
}

func (a *concatHashAgg) Flush(outputIdx int) {
	col := a.vec.Bytes()
	if !a.foundNonNullForCurrentGroup {
		a.nulls.SetNull(outputIdx)
	} else {
		col.Set(outputIdx, a.curAgg)
	}
	// Release the reference to curAgg eagerly.
	a.allocator.AdjustMemoryUsage(-int64(len(a.curAgg)))
	a.curAgg = nil
}

func (a *concatHashAgg) Reset() {
	a.curAgg = nil
	a.foundNonNullForCurrentGroup = false
}

type concatHashAggAlloc struct {
	aggAllocBase
	aggFuncs []concatHashAgg
}

var _ aggregateFuncAlloc = &concatHashAggAlloc{}

const sizeOfConcatHashAgg = int64(unsafe.Sizeof(concatHashAgg{}))
const concatHashAggSliceOverhead = int64(unsafe.Sizeof([]concatHashAgg{}))

func (a *concatHashAggAlloc) newAggFunc() AggregateFunc {
	if len(a.aggFuncs) == 0 {
		a.allocator.AdjustMemoryUsage(concatHashAggSliceOverhead + sizeOfConcatHashAgg*a.allocSize)
		a.aggFuncs = make([]concatHashAgg, a.allocSize)
	}
	f := &a.aggFuncs[0]
	f.allocator = a.allocator
	a.aggFuncs = a.aggFuncs[1:]
	return f
}
